unit uAutoPatcher;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, rmGauge, StdCtrls, ExtCtrls, uConfig, rmBrowseFor,
  IdBaseComponent, IdComponent, IdTCPConnection, IdTCPClient, IdHTTP, Inifiles,
  PowerArc, ShellApi, IdFTP, IdIPWatch, jpeg, md5, IdCookieManager, IdCookie,
  uSpecialInput, uMessageForm, uFileCache, uUtilities, StrLib;

const   typ_nonpatch = 0;
        typ_anim = 1;
        typ_art = 2;
        typ_gump = 3;
        typ_tex = 4;
        typ_static = 5;
        typ_map = 6;
        typ_tiledata = 7;
        typ_radarcol = 8;
        typ_sound = 9;
        typ_befehl = 10;
        typ_map2 = 11;
        typ_static2 = 12;
        typ_map3 = 13;
        typ_static3 = 14;
        typ_map4 = 15;
        typ_static4 = 16;
        typ_tiledata_variabel = 17;
        typ_anim2 = 18;
        typ_anim3 = 19;
        typ_anim4 = 20;
        typ_anim5 = 21;
        typ_config = 22;
        typ_script = 23;
        typ_encrypt = 24;
        typ_map_variabel = 25;

        ReIndex_Anim = 0;
        ReIndex_Art = 1;
        ReIndex_Gumps = 2;
        ReIndex_Sound = 3;
        ReIndex_Statics = 4;
        ReIndex_Textures = 5;
        JumpTo = 6;
        ChangeHeight = 7;

        LangValueCount = 49;
        LangValues : array[0..LangValueCount-1,0..1] of string = (
                ( 'Starting client', 'Starte Client' ),
                ( 'Creating tempfile', 'Erstelle Tempfile' ),
                ( 'Not enough free disk memory', 'Nicht genug Festplattenspeicher vorhanden' ),
                ( 'Decompressing patch', 'Entpacke Patch' ),
                ( 'Start decompressing', 'Beginne entpacken' ),
                ( 'Decompressing finished', 'Entpacken beendet' ),
                ( 'Starting patch', 'Beginne Patch' ),
                ( 'Installing patch', 'Installiere Patch' ),
                ( 'Next index', 'Nchster Index' ),
                ( 'Creating memorystream', 'Erstelle MemoryStream' ),
                ( 'Saving memoryStream to', 'Speichere MemoryStream nach' ),
                ( 'Index done', 'Index fertig' ),
                ( 'Patching', 'Patche' ),
                ( 'Done', 'Fertig' ),
                ( 'Preparing reindex', 'Bereite Reindizieren vor' ),
                ( 'Start reindication', 'Starte Reindizierungsvorgang' ),
                ( 'Reindexing of', 'Reinidizieren von' ),
                ( 'Patch installed', 'Patch installiert' ),
                ( 'Deleting tempfile', 'Lsche Tempfile' ),
                ( 'Patch done', 'Patch fertig' ),
                ( 'Searching for patcher updates at http://patcher.uodev.de/', 'Suche nach Patcherupdates von http://patcher.uodev.de/' ),
                ( 'New version of this patcher is loading', 'Neue Patcherversion wird geladen' ),
                ( 'New version loaded successfully', 'Neue Patcherversion erfolgreich geladen' ),
                ( 'Please restart patcher', 'Bitte Patcher neu starten' ),
                ( 'Patcher is up to date', 'Patcherversion ist aktuell' ),
                ( 'Could not reach updateserver, going on', 'Server fr Patcherupdates momentan nicht erreichbar, weiter mit Patch.' ),
		( 'Connecting to the server', 'Verbindung zum Server wird aufgebaut' ),
		( 'Checking version', 'berprfe version' ),
		( 'No News existing', 'Keine Infos/News vorhanden' ),
		( 'Local version is up to date', 'Lokale Version ist aktuell' ),
		( 'new patches', 'neue Patches' ),
		( 'No message', 'keine Nachricht' ),
		( 'Wrong login or password', 'Falscher Login oder Falsches Passwort' ),
		( 'Please type in your username', 'Gebt euren Username ein' ),
		( 'Please type in your password', 'Gebt eurer Passwort ein' ),
		( 'Loading patch', 'Lade Patch' ),
		( 'Opening existing patch, please wait', 'ffne vorhandenen Patch, bitte warten' ),
		( 'Patch loaded', 'Patch geladen' ),
		( 'Loading', 'Lade' ),
		( 'Choose your UO directory', 'Whle dein UO-Verzeichnis' ),
                ( 'Local version', 'Lokale Version' ),
                ( 'Server version', 'Server Version' ),
                ( 'Cancel', 'Abbrechen' ),
                ( 'Patcherversion', 'Patcherversion' ),
                ( 'Patch interrupted', 'Patch unterbrochen' ),
                ( 'Current patch', 'Momentaner Patch' ),
                ( 'Whole patching', 'Gesamter Patchvorgang' ),
                ( 'Jumping to', 'Springe zu Patch: ' ),
                ( 'CommandTag', 'CommandTag: ' )
                );

        PatcherVersion = 36;

type    TPatchThread = Class( TThread )
                protected
                        procedure Execute; override;
                        function Entpacken : TFileStream;
                public
                        FPackedStream : TStream;
                        procedure ProgressCallback(Current: integer);                        
        end;

        TPatcher = class(TForm)
                Balken: TrmGauge;
                BalkenGesamt: TrmGauge;
                HTTP: TIdHTTP;
                Memo: TMemo;
                Menge: TLabel;
                Geschw: TLabel;
                btnCancel: TButton;
                HTTP_TDV: TIdHTTP;
                Banner: TImage;
                MemoShardinfo: TMemo;
                Version: TLabel;
                CookieMan: TIdCookieManager;
                procedure HTTPWork(Sender: TObject; AWorkMode: TWorkMode; const AWorkCount: Integer);
                procedure HTTPWorkEnd(Sender: TObject; AWorkMode: TWorkMode);
                procedure HTTPWorkBegin(Sender: TObject; AWorkMode: TWorkMode; const AWorkCountMax: Integer);
                procedure btnCancelClick(Sender: TObject);
                procedure HTTP_TDVWork(Sender: TObject; AWorkMode: TWorkMode; const AWorkCount: Integer);
                procedure HTTP_TDVWorkBegin(Sender: TObject; AWorkMode: TWorkMode; const AWorkCountMax: Integer);
                procedure HTTP_TDVWorkEnd(Sender: TObject; AWorkMode: TWorkMode);
                procedure CookieManNewCookie(ASender: TObject; ACookie: TIdCookieRFC2109; var VAccept: Boolean);
                procedure FormCreate(Sender: TObject);
        private
                { Private declarations }
                SessId : String;
                Ending : Boolean;
                CustomCaption : String;
                Lang : TIniFile;
        public
                SizeLastTick, LastTick, StartSize : Integer;
                PatchThread : TPatchThread;
                FileCache : TFileCache;
                JumpTo : Integer;
                procedure StartClient;
                procedure StartPatcher;
                procedure Log( zeile : String );
                procedure ApplyPatch( FPackedStream : TFileStream );
                function SpecialInputBox( const ACaption, APrompt, ADefault: string; Password : Boolean = False ) : string;
                procedure SpecialInputQuery( const ACaption, APrompt: string; Password : Boolean; var Value: string );
                function GetLang( Value : String ) : String;
                function GetTypeString( Value : Byte ) : String;
                { Public declarations }
        end;

        TIndex = packed record
                Lookup, Length, Tag, Typ : integer;
        end;

        TUOIndex = packed record
                Lookup, Length, Tag : integer;
        end;

        TMapTile = packed record
                Tile : word;
                Hoehe : shortint;
        end;

        TMapBlock = packed record
                Header: Cardinal;
                Cells: Array[0..63] of TMapTile;
        end;

        TMapBlockPatch = packed record
                Cells: Array[0..63] of TMapTile;
        end;

        TLandTile = packed record
                Flags : longword;
                TexID : word;
                Name : array[0..19] of char;
        end;

        TStaticTile = packed record
                Flags : longword;
                Weight, Quality : byte;
                Unknown : word;
                Unknown2 : byte;
                Quantity : byte;
                AnimID : word;
                Unknown3, Hue, Unknown4, Unknown5, Height : byte;
                Name : array[0..19] of char;
        end;

var
        Patcher: TPatcher;
        FileSuffix : String;
        TotalSize : Integer;       

implementation

{$R *.dfm}

procedure Log( Zeile : String );
begin
        Patcher.Log( Zeile );
end;

function TPatcher.GetTypeString( Value : Byte ) : String;
begin
        Case Value of
                typ_nonpatch : Result := 'copying file';
                typ_anim  : Result := 'animation';
                typ_anim2 : Result := 'animation2';
                typ_anim3 : Result := 'animation3';
                typ_anim4 : Result := 'animation4';
                typ_anim5 : Result := 'animation5';                
                typ_art : Result := 'art';
                typ_gump : Result := 'gumpart';
                typ_tex : Result := 'textures';
                typ_static : Result := 'statics';
                typ_map : Result := 'map';
                typ_map_variabel : Result := 'map';
                typ_tiledata : Result := 'tiledata';
                typ_radarcol : Result := 'radarcol';
                typ_sound : Result := 'sound';
                typ_befehl : Result := 'command';
                typ_map2 : Result := 'map2';
                typ_static2 : Result := 'statics2';
                typ_map3 : Result := 'map3';
                typ_static3 : Result := 'statics3';
                typ_map4 : Result := 'map4';
                typ_static4 : Result := 'static4';
                typ_tiledata_variabel : Result := 'variable_length_tiledata';
        else
                Result := IntToStr( Value );
        end;
end;

procedure TPatcher.Log( Zeile : String );
var     tFile : TextFile;
begin
        AssignFile( tFile, ExtractFilePath( Application.ExeName ) + 'log.txt' );
        if FileExists( ExtractFilePath( Application.ExeName ) + 'log.txt' ) then
                Append( tFile )
        else
                Rewrite( tFile );

        Writeln( tFile, zeile );
        CloseFile( tFile );
end;

procedure TPatcher.StartClient;
var     LoginFile : Textfile;
        Clientname : string;
begin
        if Config.GetInteger( 'DoNotStartClientAfterPatching' ) = 1 then begin
                Memo.Lines.SaveToFile( ExtractFilePath( Application.ExeName ) + 'patcher.log' );
                Close;
                exit;
        end;

        Memo.Lines.Add( GetLang( 'Starting client' ) );
        FreeAndNil( Lang );

        Memo.Lines.SaveToFile( ExtractFilePath( Application.ExeName ) + 'patcher.log' );
        if FileExists( Config.GetString( 'UOPath' ) + 'login.cfg' ) then
                DeleteFile( Config.GetString( 'UOPath' ) + 'login.cfg' );
        AssignFile( LoginFile, Config.GetString( 'UOPath' ) + 'login.cfg' );
        Rewrite( LoginFile );
        WriteLn( LoginFile, Config.GetString( 'LoginString' ) );
        CloseFile( LoginFile );

        Clientname := Config.GetString( 'UOPath' ) + Config.GetString( 'Client' );
        ShellExecute( Application.Handle, 'open', PChar( Clientname ), nil, nil, SW_SHOW );
end;

procedure TPatcher.ApplyPatch( FPackedStream : TFileStream );
begin
        PatchThread := TPatchThread.Create( True );
        PatchThread.FPackedStream := FPackedStream;
        PatchThread.Execute;

        while not PatchThread.Terminated do begin
                Sleep( 5 );
                Application.ProcessMessages;
        end;

        PatchThread.Free;
end;

function TPatchThread.Entpacken : TFileStream;
var     DecompressStream : TPowerArcDecompressStream;
        TempStream : TMemoryStream;
        Len : Integer;
        Buff : Array[0..4095] of Byte;
        Buf : PByteArray;
begin
        Log( Patcher.GetLang( 'Creating tempfile' ) );

        FPackedStream.Seek( FPackedStream.Size-4, soFromBeginning );
        FPackedStream.Read( TotalSize, 4 );

        if TotalSize = 0 then begin
                Log( 'TotalSize: 0' );
                Terminate;
                Result := nil;
                exit;
        end;

        if DiskFree( 0 ) <= TotalSize then
                raise Exception.Create( Patcher.GetLang( 'Not enough free disk memory' ) );

        Result := TFileStream.Create( ExtractFilePath( Application.ExeName ) + 'patches\temp.' + FileSuffix, fmCreate );
        Result.Seek( 0, soFromBeginning );
        
        FPackedStream.Seek( 0, soFromBeginning );

        TempStream := TMemoryStream.Create;
        TempStream.Seek( 0, soFromBeginning );

        GetMem( Buf, FPackedStream.Size-4 );
        FPackedStream.Read( Buf^, FPackedStream.Size-4 );
        TempStream.Write( Buf^, FPackedStream.Size-4 );
        FreeMem( Buf, FPackedStream.Size-4 );

        TempStream.Seek( 0, soFromBeginning );

        Patcher.Memo.Lines.Add( Patcher.GetLang( 'Decompressing patch' ) );
        Log( Patcher.GetLang( 'Start decompressing' ) );

        DecompressStream := TPowerArcDecompressStream.Create( TempStream );
        try
                DecompressStream.OnProgress := ProgressCallback;
                Len := DecompressStream.Read( Buff[0], 4096 );
                while Len > 0 do begin
                        Result.Write( Buff[0], Len );
                        Len := DecompressStream.Read( Buff[0], 4096 );
                end;
        except
                on E: Exception do
                        raise Exception.Create( E.Message );
        end;
        DecompressStream.Free;
        TempStream.Free;
        Log( Patcher.GetLang( 'Decompressing finished' ) );
end;

procedure TPatchThread.Execute;
var     Index : TIndex;
        MStream, IndexFile, DataFile, FStream : TFileStream;
        MapMul, StaIdx, StaMul : TFileStream;
        Buf : PByteArray;
        Name : array[0..30] of Char;
        NameNew, ReIndexTyp : string;
        UOIndex, IndexRecord : TUOIndex;
        I, J, Pos, Header, Count : Integer;
        LandTile : TLandTile;
        StaticTile, TmpStaticTile : TStaticTile;
        MapTile, Cell : TMapTile;
        MapBlock : TMapBlockPatch;
        MapBlockNew : TMapBlock;
        Changed : Boolean;
        OldIdx, OldMul, NewIdx, NewMul : TFileStream;
        IndexOld, IndexNew : TUOIndex;
        MinX, MaxX, MinY, MaxY : Integer;
        MapHoehe : Word;
        Delta, X, Y : Integer;
        ChangeMap, ChangeStatic, MapNr : Byte;
        BlockId : LongWord;
        SX, SY : Byte;
        SZ : ShortInt;
        Id, Color : Word;
begin
        Log( Patcher.GetLang( 'Starting patch' ) );

        try
                MStream := Entpacken;
        except
                on E : Exception do begin
                        raise Exception.Create( E.Message );
                        exit;
                end;
        end;

        if MStream = nil then begin
                Log( Patcher.GetLang( 'Deleting tempfile' ) );
                DeleteFile( ExtractFilePath( Application.ExeName ) + 'patches\temp.' + FileSuffix );
                exit;
        end;

        Patcher.Memo.Lines.Add( Patcher.GetLang( 'Installing patch' ) );

        MStream.Seek( 0, soFromBeginning );

        while MStream.Position < MStream.Size do begin
                if Patcher.Ending then
                        break;
                
                Patcher.Balken.Percent := Trunc( 100 * MStream.Position / MStream.Size );
                MStream.Read( Index, sizeof( TIndex ) );
                //nonpatch
                Log( Patcher.GetLang( 'Next index' ) + ': ' + Patcher.GetTypeString( Index.Typ ) + ', Id:' + IntToStr( Index.Lookup div 12 ) );
                if Index.Typ = typ_nonpatch then begin
                        MStream.Read( Name, 30 );
                        NameNew := Name;
                        Patcher.FileCache.FreeFile( NameNew );
                        if FileExists( Config.GetString( 'UOPath' ) + NameNew ) then
                                DeleteFile( Config.GetString( 'UOPath' ) + NameNew );

                        FStream := TFileStream.Create( Config.GetString( 'UOPath' ) + NameNew, fmCreate );

                        GetMem( Buf, Index.Length );
                        Log( Patcher.GetLang( 'Creating memorystream' ) );
                        MStream.Read( Buf^, Index.Length );
                        Log( Patcher.GetLang( 'Saving memoryStream to' ) + ' ' + NameNew );
                        FStream.Write( Buf^, Index.Length );
                        FreeMem( Buf, Index.Length );

                        FStream.Free;                        
                        Log( Patcher.GetLang( 'Index done' ) );
                end;
                //Art
                if Index.Typ = typ_art then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'artidx.mul' );

                        if Index.Lookup > IndexFile.Size then begin
                                IndexFile.Seek( 0, soFromEnd );
                                UOIndex.Lookup := -1;
                                UOIndex.Length := -1;
                                UOIndex.Tag := -1;
                                while IndexFile.Size < Index.Lookup do
                                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );
                        end;

                        IndexFile.Seek( Index.Lookup, soFromBeginning );
                        DataFile := Patcher.FileCache.GetFileStream( 'art.mul' );
                        DataFile.Seek( 0, soFromEnd );
                        UOIndex.Lookup := DataFile.Position;
                        UOIndex.Length := Index.Length;
                        UOIndex.Tag := Index.Tag;
                        Log( Patcher.GetLang( 'Patching' ) + ' Art' );
                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );

                        GetMem( Buf, UOIndex.Length );
                        MStream.Read( Buf^, UOIndex.Length );
                        DataFile.Write( Buf^, UOIndex.Length );
                        FreeMem( Buf, UOIndex.Length );

                        Log( 'Art ' + Patcher.GetLang( 'Done' ) );
                end;
                //Gumps
                if Index.Typ = typ_gump then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'gumpidx.mul' );

                        if Index.Lookup > IndexFile.Size then begin
                                IndexFile.Seek( 0, soFromEnd );
                                UOIndex.Lookup := -1;
                                UOIndex.Length := -1;
                                UOIndex.Tag := -1;
                                while IndexFile.Size < Index.Lookup do
                                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );
                        end;

                        IndexFile.Seek( Index.Lookup, soFromBeginning );
                        DataFile := Patcher.FileCache.GetFileStream( 'gumpart.mul' );
                        DataFile.Seek( 0, soFromEnd );
                        UOIndex.Lookup := DataFile.Position;
                        UOIndex.Length := Index.Length;
                        UOIndex.Tag := Index.Tag;
                        Log( Patcher.GetLang( 'Patching' ) + ' Gump' );
                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );

                        GetMem( Buf, UOIndex.Length );
                        MStream.Read( Buf^, UOIndex.Length );
                        DataFile.Write( Buf^, UOIndex.Length );
                        FreeMem( Buf, UOIndex.Length );

                        Log( 'Gump ' + Patcher.GetLang( 'Done' ) );
                end;
                //Texturen
                if Index.Typ = typ_tex then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'texidx.mul' );

                        if Index.Lookup > IndexFile.Size then begin
                                IndexFile.Seek( 0, soFromEnd );
                                UOIndex.Lookup := -1;
                                UOIndex.Length := -1;
                                UOIndex.Tag := -1;
                                while IndexFile.Size < Index.Lookup do
                                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );
                        end;

                        IndexFile.Seek( Index.Lookup, soFromBeginning );
                        DataFile := Patcher.FileCache.GetFileStream( 'texmaps.mul' );
                        DataFile.Seek( 0, soFromEnd );
                        UOIndex.Lookup := DataFile.Position;
                        UOIndex.Length := Index.Length;
                        UOIndex.Tag := Index.Tag;
                        Log( Patcher.GetLang( 'Patching' ) + ' Tex' );
                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );

                        GetMem( Buf, UOIndex.Length );
                        MStream.Read( Buf^, UOIndex.Length );
                        DataFile.Write( Buf^, UOIndex.Length );
                        FreeMem( Buf, UOIndex.Length );

                        Log( 'Tex ' + Patcher.GetLang( 'Done' ) );
                end;
                //Anims
                if Index.Typ = typ_anim then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'anim.idx' );

                        if Index.Lookup > IndexFile.Size then begin
                                IndexFile.Seek( 0, soFromEnd );
                                UOIndex.Lookup := -1;
                                UOIndex.Length := -1;
                                UOIndex.Tag := -1;
                                while IndexFile.Size < Index.Lookup do
                                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );
                        end;

                        IndexFile.Seek( Index.Lookup, soFromBeginning );
                        DataFile := Patcher.FileCache.GetFileStream( 'anim.mul' );
                        DataFile.Seek( 0, soFromEnd );
                        UOIndex.Lookup := DataFile.Position;
                        UOIndex.Length := Index.Length;
                        UOIndex.Tag := Index.Tag;
                        Log( Format( Patcher.GetLang( 'Patching' ) + ' Anim 0x%x', [Index.Lookup div 12] ) );
                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );

                        GetMem( Buf, UOIndex.Length );
                        MStream.Read( Buf^, UOIndex.Length );
                        DataFile.Write( Buf^, UOIndex.Length );
                        FreeMem( Buf, UOIndex.Length );

                        Log( 'Anim ' + Patcher.GetLang( 'Done' ) );
                end;
                //Anims2
                if Index.Typ = typ_anim2 then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'anim2.idx' );

                        if Index.Lookup > IndexFile.Size then begin
                                IndexFile.Seek( 0, soFromEnd );
                                UOIndex.Lookup := -1;
                                UOIndex.Length := -1;
                                UOIndex.Tag := -1;
                                while IndexFile.Size < Index.Lookup do
                                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );
                        end;

                        IndexFile.Seek( Index.Lookup, soFromBeginning );
                        DataFile := Patcher.FileCache.GetFileStream( 'anim2.mul' );
                        DataFile.Seek( 0, soFromEnd );
                        UOIndex.Lookup := DataFile.Position;
                        UOIndex.Length := Index.Length;
                        UOIndex.Tag := Index.Tag;
                        Log( Format( Patcher.GetLang( 'Patching' ) + ' Anim2 0x%x', [Index.Lookup div 12] ) );
                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );

                        GetMem( Buf, UOIndex.Length );
                        MStream.Read( Buf^, UOIndex.Length );
                        DataFile.Write( Buf^, UOIndex.Length );
                        FreeMem( Buf, UOIndex.Length );

                        Log( 'Anim2 ' + Patcher.GetLang( 'Done' ) );
                end;
                //Anims3
                if Index.Typ = typ_anim3 then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'anim3.idx' );

                        if Index.Lookup > IndexFile.Size then begin
                                IndexFile.Seek( 0, soFromEnd );
                                UOIndex.Lookup := -1;
                                UOIndex.Length := -1;
                                UOIndex.Tag := -1;
                                while IndexFile.Size < Index.Lookup do
                                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );
                        end;

                        IndexFile.Seek( Index.Lookup, soFromBeginning );
                        DataFile := Patcher.FileCache.GetFileStream( 'anim3.mul' );
                        DataFile.Seek( 0, soFromEnd );
                        UOIndex.Lookup := DataFile.Position;
                        UOIndex.Length := Index.Length;
                        UOIndex.Tag := Index.Tag;
                        Log( Format( Patcher.GetLang( 'Patching' ) + ' Anim3 0x%x', [Index.Lookup div 12] ) );
                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );

                        GetMem( Buf, UOIndex.Length );
                        MStream.Read( Buf^, UOIndex.Length );
                        DataFile.Write( Buf^, UOIndex.Length );
                        FreeMem( Buf, UOIndex.Length );

                        Log( 'Anim3 ' + Patcher.GetLang( 'Done' ) );
                end;
                //Anims4
                if Index.Typ = typ_anim4 then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'anim4.idx' );

                        if Index.Lookup > IndexFile.Size then begin
                                IndexFile.Seek( 0, soFromEnd );
                                UOIndex.Lookup := -1;
                                UOIndex.Length := -1;
                                UOIndex.Tag := -1;
                                while IndexFile.Size < Index.Lookup do
                                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );
                        end;

                        IndexFile.Seek( Index.Lookup, soFromBeginning );
                        DataFile := Patcher.FileCache.GetFileStream( 'anim4.mul' );
                        DataFile.Seek( 0, soFromEnd );
                        UOIndex.Lookup := DataFile.Position;
                        UOIndex.Length := Index.Length;
                        UOIndex.Tag := Index.Tag;
                        Log( Format( Patcher.GetLang( 'Patching' ) + ' Anim4 0x%x', [Index.Lookup div 12] ) );
                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );

                        GetMem( Buf, UOIndex.Length );
                        MStream.Read( Buf^, UOIndex.Length );
                        DataFile.Write( Buf^, UOIndex.Length );
                        FreeMem( Buf, UOIndex.Length );

                        Log( 'Anim4 ' + Patcher.GetLang( 'Done' ) );
                end;
                //Anims5
                if Index.Typ = typ_anim5 then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'anim5.idx' );

                        if Index.Lookup > IndexFile.Size then begin
                                IndexFile.Seek( 0, soFromEnd );
                                UOIndex.Lookup := -1;
                                UOIndex.Length := -1;
                                UOIndex.Tag := -1;
                                while IndexFile.Size < Index.Lookup do
                                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );
                        end;

                        IndexFile.Seek( Index.Lookup, soFromBeginning );
                        DataFile := Patcher.FileCache.GetFileStream( 'anim5.mul' );
                        DataFile.Seek( 0, soFromEnd );
                        UOIndex.Lookup := DataFile.Position;
                        UOIndex.Length := Index.Length;
                        UOIndex.Tag := Index.Tag;
                        Log( Format( Patcher.GetLang( 'Patching' ) + ' Anim5 0x%x', [Index.Lookup div 12] ) );
                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );

                        GetMem( Buf, UOIndex.Length );
                        MStream.Read( Buf^, UOIndex.Length );
                        DataFile.Write( Buf^, UOIndex.Length );
                        FreeMem( Buf, UOIndex.Length );

                        Log( 'Anim5 ' + Patcher.GetLang( 'Done' ) );
                end;                
                //Sounds
                if Index.Typ = typ_sound then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'soundidx.mul' );

                        if Index.Lookup > IndexFile.Size then begin
                                IndexFile.Seek( 0, soFromEnd );
                                UOIndex.Lookup := -1;
                                UOIndex.Length := -1;
                                UOIndex.Tag := -1;
                                while IndexFile.Size < Index.Lookup do
                                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );
                        end;

                        IndexFile.Seek( Index.Lookup, soFromBeginning );
                        DataFile := Patcher.FileCache.GetFileStream( 'sound.mul' );
                        DataFile.Seek( 0, soFromEnd );
                        UOIndex.Lookup := DataFile.Position;
                        UOIndex.Length := Index.Length;
                        UOIndex.Tag := Index.Tag;
                        Log( Patcher.GetLang( 'Patching' ) + ' Sound' );
                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );

                        GetMem( Buf, UOIndex.Length );
                        MStream.Read( Buf^, UOIndex.Length );
                        DataFile.Write( Buf^, UOIndex.Length );
                        FreeMem( Buf, UOIndex.Length );

                        Log( 'Sound ' + Patcher.GetLang( 'Done' ) );
                end;
                //Radarcol
                if Index.Typ = typ_radarcol then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'radarcol.mul' );
                        IndexFile.Seek( Index.Lookup, soFromBeginning );

                        Log( Patcher.GetLang( 'Patching' ) + ' Radarcol' );
                        for I := 1 to ( Index.Length div 2 ) do begin
                                MStream.Read( Color, 2 );
                                if Color <> 0 then begin
                                        IndexFile.Seek( (I-1)*2, soFromBeginning );
                                        IndexFile.Write( Color, 2 );
                                end;
                        end;
                        Log( 'Radarcol ' + Patcher.GetLang( 'Done' ) );
                end;
                //Tiledata
                if Index.Typ = typ_tiledata then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'tiledata.mul' );
                        IndexFile.Seek( Index.Lookup, soFromBeginning );

                        Log( Patcher.GetLang( 'Patching' ) + ' Landtiles' );
                        for I := 1 to 512*32 do begin
                                MStream.Read( LandTile, 26 );
                                NameNew := LandTile.Name;
                                if ( LandTile.Flags <> 0 ) or ( LandTile.TexID <> 0 ) or ( NameNew <> '' ) then begin
                                        IndexFile.Seek( (I-1)*26+(((I-1) div 32)+1)*4, soFromBeginning );
                                        IndexFile.Write( LandTile, 26 );
                                end;
                        end;
                        Log( Patcher.GetLang( 'Patching' ) + ' Statictiles' );
                        for I := 1 to 512*32 do begin
                                MStream.Read( StaticTile, 37 );
                                NameNew := StaticTile.Name;
                                if ( StaticTile.Flags <> 0 ) or ( StaticTile.Weight <> 0 ) or ( StaticTile.Quality <> 0 ) or ( StaticTile.Unknown <> 0 ) or ( StaticTile.Unknown2 <> 0 ) or ( StaticTile.Quantity <> 0 ) or ( StaticTile.AnimID <> 0 ) or ( StaticTile.Unknown3 <> 0 ) or ( StaticTile.Hue <> 0 ) or ( StaticTile.Unknown4 <> 0 ) or ( StaticTile.Unknown5 <> 0 ) or ( StaticTile.Height <> 0 ) or ( NameNew <> '' ) then begin
                                        IndexFile.Seek( 512*32*26+512*4+(I-1)*37+(((I-1) div 32)+1)*4, soFromBeginning );
                                        IndexFile.Write( StaticTile, 37 );
                                end;

                        end;
                        Log( 'Tiledata ' + Patcher.GetLang( 'Done' ) );
                end;
                //Tiledata variable Lnge
                if Index.Typ = typ_tiledata_variabel then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'tiledata.mul' );
                        IndexFile.Seek( Index.Lookup, soFromBeginning );

                        Log( Patcher.GetLang( 'Patching' ) + ' Landtiles' );
                        for I := 1 to 512*32 do begin
                                MStream.Read( LandTile, 26 );
                                NameNew := LandTile.Name;
                                if ( LandTile.Flags <> 0 ) or ( LandTile.TexID <> 0 ) or ( NameNew <> '' ) then begin
                                        IndexFile.Seek( (I-1)*26+(((I-1) div 32)+1)*4, soFromBeginning );
                                        IndexFile.Write( LandTile, 26 );
                                end;
                        end;

                        MStream.Read( Count, 4 );
                        Count := Count*32;
                        Log( Patcher.GetLang( 'Patching' ) + ' ' + IntToStr( Count ) + ' Statictiles' );

                        for I := 1 to Count do begin
                                MStream.Read( StaticTile, 37 );
                                NameNew := StaticTile.Name;
                                if ( StaticTile.Flags <> 0 ) or ( StaticTile.Weight <> 0 ) or ( StaticTile.Quality <> 0 ) or ( StaticTile.Unknown <> 0 ) or ( StaticTile.Unknown2 <> 0 ) or ( StaticTile.Quantity <> 0 ) or ( StaticTile.AnimID <> 0 ) or ( StaticTile.Unknown3 <> 0 ) or ( StaticTile.Hue <> 0 ) or ( StaticTile.Unknown4 <> 0 ) or ( StaticTile.Unknown5 <> 0 ) or ( StaticTile.Height <> 0 ) or ( NameNew <> '' ) then begin
                                        Pos := 512*32*26+512*4+(I-1)*37+(((I-1) div 32)+1)*4;
                                        if Pos > IndexFile.Size then begin
                                                FillChar( TmpStaticTile, 37, 0 );
                                                Header := 0;
                                                IndexFile.Seek( 0, soFromEnd );
                                                while Pos > IndexFile.Size do begin
                                                        IndexFile.Write( Header, 4 );
                                                        for J := 0 to 31 do
                                                                IndexFile.Write( TmpStaticTile, 37 );
                                                end;
                                        end;
                                        IndexFile.Seek( Pos, soFromBeginning );
                                        IndexFile.Write( StaticTile, 37 );
                                end;

                        end;
                        Log( 'Tiledata ' + Patcher.GetLang( 'Done' ) );
                end;
                //Statics
                if Index.Typ = typ_static then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'staidx0.mul' );

                        if Index.Lookup > IndexFile.Size then begin
                                IndexFile.Seek( 0, soFromEnd );
                                UOIndex.Lookup := -1;
                                UOIndex.Length := -1;
                                UOIndex.Tag := -1;
                                while IndexFile.Size < Index.Lookup do
                                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );
                        end;

                        IndexFile.Seek( Index.Lookup, soFromBeginning );
                        DataFile := Patcher.FileCache.GetFileStream( 'statics0.mul' );
                        DataFile.Seek( 0, soFromEnd );

                        UOIndex.Lookup := DataFile.Position;
                        UOIndex.Length := Index.Length;
                        UOIndex.Tag := Index.Tag;
                        Log( Patcher.GetLang( 'Patching' ) + ' Statics' );
                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );

                        GetMem( Buf, UOIndex.Length );
                        MStream.Read( Buf^, UOIndex.Length );
                        DataFile.Write( Buf^, UOIndex.Length );
                        FreeMem( Buf, UOIndex.Length );

                        Log( 'Statics ' + Patcher.GetLang( 'Done' ) );
                end;
                //Statics2
                if Index.Typ = typ_static2 then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'staidx2.mul' );

                        if Index.Lookup > IndexFile.Size then begin
                                IndexFile.Seek( 0, soFromEnd );
                                UOIndex.Lookup := -1;
                                UOIndex.Length := -1;
                                UOIndex.Tag := -1;
                                while IndexFile.Size < Index.Lookup do
                                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );
                        end;

                        IndexFile.Seek( Index.Lookup, soFromBeginning );
                        DataFile := Patcher.FileCache.GetFileStream( 'statics2.mul' );
                        DataFile.Seek( 0, soFromEnd );

                        UOIndex.Lookup := DataFile.Position;
                        UOIndex.Length := Index.Length;
                        UOIndex.Tag := Index.Tag;
                        Log( Patcher.GetLang( 'Patching' ) + ' Statics2' );
                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );

                        GetMem( Buf, UOIndex.Length );
                        MStream.Read( Buf^, UOIndex.Length );
                        DataFile.Write( Buf^, UOIndex.Length );
                        FreeMem( Buf, UOIndex.Length );

                        Log( 'Statics2 ' + Patcher.GetLang( 'Done' ) );
                end;
                //Statics3
                if Index.Typ = typ_static3 then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'staidx3.mul' );

                        if Index.Lookup > IndexFile.Size then begin
                                IndexFile.Seek( 0, soFromEnd );
                                UOIndex.Lookup := -1;
                                UOIndex.Length := -1;
                                UOIndex.Tag := -1;
                                while IndexFile.Size < Index.Lookup do
                                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );
                        end;

                        IndexFile.Seek( Index.Lookup, soFromBeginning );
                        DataFile := Patcher.FileCache.GetFileStream( 'statics3.mul' );
                        DataFile.Seek( 0, soFromEnd );

                        UOIndex.Lookup := DataFile.Position;
                        UOIndex.Length := Index.Length;
                        UOIndex.Tag := Index.Tag;
                        Log( Patcher.GetLang( 'Patching' ) + ' Statics3' );
                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );

                        GetMem( Buf, UOIndex.Length );
                        MStream.Read( Buf^, UOIndex.Length );
                        DataFile.Write( Buf^, UOIndex.Length );
                        FreeMem( Buf, UOIndex.Length );

                        Log( 'Statics3 ' + Patcher.GetLang( 'Done' ) );
                end;
                //Statics4
                if Index.Typ = typ_static4 then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'staidx4.mul' );

                        if Index.Lookup > IndexFile.Size then begin
                                IndexFile.Seek( 0, soFromEnd );
                                UOIndex.Lookup := -1;
                                UOIndex.Length := -1;
                                UOIndex.Tag := -1;
                                while IndexFile.Size < Index.Lookup do
                                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );
                        end;

                        IndexFile.Seek( Index.Lookup, soFromBeginning );
                        DataFile := Patcher.FileCache.GetFileStream( 'statics4.mul' );
                        DataFile.Seek( 0, soFromEnd );

                        UOIndex.Lookup := DataFile.Position;
                        UOIndex.Length := Index.Length;
                        UOIndex.Tag := Index.Tag;
                        Log( Patcher.GetLang( 'Patching' ) + ' Statics4' );
                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );

                        GetMem( Buf, UOIndex.Length );
                        MStream.Read( Buf^, UOIndex.Length );
                        DataFile.Write( Buf^, UOIndex.Length );
                        FreeMem( Buf, UOIndex.Length );

                        Log( 'Statics4 ' + Patcher.GetLang( 'Done' ) );
                end;
                //map
                if Index.Typ = typ_map then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'map0.mul' );
                        IndexFile.Seek( 0, soFromBeginning );

                        Log( Patcher.GetLang( 'Patching' ) + ' Map' );
                        for I := 1 to 768*512 do begin
                                Patcher.Geschw.Caption := IntToStr( trunc( I / ( 768*512/100 ) ) ) + ' %';
                                if I mod 10000 = 0 then
                                        Application.ProcessMessages;
                                MStream.Read( MapBlock, sizeof( TMapBlockPatch ) );
                                IndexFile.Read( MapBlockNew, sizeof( TMapBlock ) );
                                Changed := False;
                                for J := 0 to 63 do begin
                                        if ( MapBlock.Cells[ J ].Tile <> 0 ) or ( MapBlock.Cells[ J ].Hoehe <> 0 ) then begin
                                                MapBlockNew.Cells[ J ].Tile := MapBlock.Cells[ J ].Tile;
                                                MapBlockNew.Cells[ J ].Hoehe := MapBlock.Cells[ J ].Hoehe;
                                                Changed := true;
                                        end;
                                end;
                                if Changed then begin
                                        IndexFile.Seek( -sizeof( TMapBlock ), soFromCurrent );
                                        IndexFile.Write( MapBlockNew, sizeof( TMapBlock ) );
                                end;
                        end;
                        Patcher.Geschw.Caption := '';
                        Log( 'Map ' + Patcher.GetLang( 'Done' ) );
                end;
                //map variabel
                if Index.Typ = typ_map_variabel then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'map0.mul' );
                        IndexFile.Seek( 0, soFromBeginning );

                        Count := Index.Length div (64*3);

                        Log( Patcher.GetLang( 'Patching' ) + ' Map' );
                        for I := 1 to Count do begin
                                Patcher.Geschw.Caption := IntToStr( trunc( I / ( Count/100 ) ) ) + ' %';
                                if I mod 10000 = 0 then
                                        Application.ProcessMessages;
                                MStream.Read( MapBlock, sizeof( TMapBlockPatch ) );

                                if IndexFile.Position < IndexFile.Size then begin
                                        IndexFile.Read( MapBlockNew, sizeof( TMapBlock ) );
                                        Changed := False;
                                        for J := 0 to 63 do begin
                                                if ( MapBlock.Cells[ J ].Tile <> 0 ) or ( MapBlock.Cells[ J ].Hoehe <> 0 ) then begin
                                                        MapBlockNew.Cells[ J ].Tile := MapBlock.Cells[ J ].Tile;
                                                        MapBlockNew.Cells[ J ].Hoehe := MapBlock.Cells[ J ].Hoehe;
                                                        Changed := true;
                                                end;
                                        end;
                                        if Changed then begin
                                                IndexFile.Seek( -sizeof( TMapBlock ), soFromCurrent );
                                                IndexFile.Write( MapBlockNew, sizeof( TMapBlock ) );
                                        end;
                                end
                                else begin
                                        MapBlockNew.Header := 0;
                                        for J := 0 to 63 do begin
                                                MapBlockNew.Cells[ J ].Tile := MapBlock.Cells[ J ].Tile;
                                                MapBlockNew.Cells[ J ].Hoehe := MapBlock.Cells[ J ].Hoehe;
                                        end;
                                        IndexFile.Write( MapBlockNew, sizeof( TMapBlock ) );
                                end;
                        end;
                        Patcher.Geschw.Caption := '';
                        Log( 'Map ' + Patcher.GetLang( 'Done' ) );
                end;
                //map2
                if Index.Typ = typ_map2 then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'map2.mul' );
                        IndexFile.Seek( 0, soFromBeginning );

                        Log( Patcher.GetLang( 'Patching' ) + ' Map2' );
                        for I := 1 to 288*200 do begin
                                Patcher.Geschw.Caption := inttostr( trunc( I / ( 288*200/100 ) ) ) + ' %';
                                if I mod 10000 = 0 then
                                        Application.ProcessMessages;
                                MStream.Read( MapBlock, sizeof( TMapBlockPatch ) );
                                IndexFile.Read( MapBlockNew, sizeof( TMapBlock ) );
                                Changed := false;
                                for J := 0 to 63 do begin
                                        if ( MapBlock.Cells[ J ].Tile <> 0 ) or ( MapBlock.Cells[ J ].Hoehe <> 0 ) then begin
                                                MapBlockNew.Cells[ J ].Tile := MapBlock.Cells[ J ].Tile;
                                                MapBlockNew.Cells[ J ].Hoehe := MapBlock.Cells[ J ].Hoehe;
                                                changed := true;
                                        end;
                                end;
                                if Changed then begin
                                        IndexFile.Seek( -sizeof( TMapBlock ), soFromCurrent );
                                        IndexFile.Write( MapBlockNew, sizeof( TMapBlock ) );
                                end;
                        end;
                        Patcher.Geschw.Caption := '';
                        log( 'Map2 ' + Patcher.GetLang( 'Done' ) );
                end;
                //map3
                if Index.Typ = typ_map3 then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'map3.mul' );
                        IndexFile.Seek( 0, soFromBeginning );

                        Log( Patcher.GetLang( 'Patching' ) + ' Map3' );
                        for I := 1 to 320*256 do begin
                                Patcher.Geschw.Caption := Inttostr( trunc( I / ( 320*256/100 ) ) ) + ' %';
                                if I mod 10000 = 0 then
                                        Application.ProcessMessages;
                                MStream.Read( MapBlock, sizeof( TMapBlockPatch ) );
                                IndexFile.Read( MapBlockNew, sizeof( TMapBlock ) );
                                Changed := False;
                                for J := 0 to 63 do begin
                                        if ( MapBlock.Cells[ J ].Tile <> 0 ) or ( MapBlock.Cells[ J ].Hoehe <> 0 ) then begin
                                                MapBlockNew.Cells[ J ].Tile := MapBlock.Cells[ J ].Tile;
                                                MapBlockNew.Cells[ J ].Hoehe := MapBlock.Cells[ J ].Hoehe;
                                                Changed := true;
                                        end;
                                end;
                                if Changed then begin
                                        IndexFile.Seek( -sizeof( TMapBlock ), soFromCurrent );
                                        IndexFile.Write( MapBlockNew, sizeof( TMapBlock ) );
                                end;
                        end;
                        Patcher.Geschw.Caption := '';
                        Log( 'Map3 ' + Patcher.GetLang( 'Done' ) );
                end;
                //map4
                if Index.Typ = typ_map4 then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'map4.mul' );
                        IndexFile.Seek( 0, soFromBeginning );

                        Log( Patcher.GetLang( 'Patching' ) + ' Map4' );
                        for I := 1 to 181*181 do begin
                                Patcher.geschw.Caption := inttostr( trunc( I / ( 181*181/100 ) ) ) + ' %';
                                if I mod 10000 = 0 then
                                        Application.ProcessMessages;
                                MStream.Read( MapBlock, sizeof( TMapBlockPatch ) );
                                IndexFile.Read( MapBlockNew, sizeof( TMapBlock ) );
                                Changed := False;
                                for J := 0 to 63 do begin
                                        if ( MapBlock.Cells[ J ].Tile <> 0 ) or ( MapBlock.Cells[ J ].Hoehe <> 0 ) then begin
                                                MapBlockNew.Cells[ J ].Tile := MapBlock.Cells[ J ].Tile;
                                                MapBlockNew.Cells[ J ].Hoehe := MapBlock.Cells[ J ].Hoehe;
                                                Changed := true;
                                        end;
                                end;
                                if Changed then begin
                                        IndexFile.Seek( -sizeof( TMapBlock ), soFromCurrent );
                                        IndexFile.Write( MapBlockNew, sizeof( TMapBlock ) );
                                end;
                        end;
                        Patcher.geschw.Caption := '';
                        IndexFile.Free;
                        Log( 'Map4 ' + Patcher.GetLang( 'Done' ) );
                end;

                if Index.Typ = typ_befehl then begin
                        Log( Patcher.GetLang( 'CommandTag' ) + IntToStr( Index.Tag ) );
                        case Index.Tag of
                                JumpTo : begin
                                        Log( Patcher.GetLang( 'Jumping to' ) + IntToStr( Index.Lookup ) );
                                        Patcher.JumpTo := Index.Lookup;
                                        continue;
                                end;
                                ChangeHeight : begin
                                        MStream.Read( MinX, 4 );
                                        MStream.Read( MinY, 4 );
                                        MStream.Read( MaxX, 4 );
                                        MStream.Read( MaxY, 4 );

                                        MStream.Read( MapNr, 1 );
                                        MStream.Read( MapHoehe, 2 );
                                        MStream.Read( ChangeMap, 1 );
                                        MStream.Read( ChangeStatic, 1 );
                                        MStream.Read( Delta, 4 );

                                        Log( Format( 'CH: %d,%d %d,%d %d %d %d %d %d', [MinX, MinY, MaxX, MaxY, MapNr, MapHoehe, ChangeMap, ChangeStatic, Delta] ) );

                                        MapHoehe := MapHoehe div 8;

                                        if ChangeMap > 0 then
                                                MapMul := Patcher.FileCache.GetFileStream( Format( 'map%d.mul', [MapNr] ) );
                                        if ChangeStatic > 0 then begin
                                                StaIdx := Patcher.FileCache.GetFileStream( Format( 'staidx%d.mul', [MapNr] ) );
                                                StaMul := Patcher.FileCache.GetFileStream( Format( 'statics%d.mul', [MapNr] ) );
                                        end;

                                        for X := MinX to MaxX do begin
                                                for Y := MinY to MaxY do begin
                                                        BlockID := ( X div 8 ) * MapHoehe + ( Y div 8 );

                                                        if ChangeMap > 0 then begin
                                                                MapMul.Seek( BlockId*sizeof( TMapBlock ), soFromBeginning );
                                                                MapMul.Read( MapBlockNew, sizeof( TMapBlock ) );

                                                                MapBlockNew.Cells[ (Y mod 8)*8+(X mod 8) ].Hoehe := MapBlockNew.Cells[ (Y mod 8)*8+(X mod 8) ].Hoehe + Delta;

                                                                MapMul.Seek( BlockId*sizeof( TMapBlock ), soFromBeginning );
                                                                MapMul.Write( MapBlockNew, sizeof( TMapBlock ) );
                                                        end;

                                                        if ChangeStatic > 0 then begin
                                                                StaIdx.Seek( BlockId*12, soFromBeginning );
                                                                StaIdx.Read( IndexRecord, 12 );

                                                                if (IndexRecord.Lookup <> -1) and (IndexRecord.Length <> -1) then begin
                                                                        StaMul.Seek( IndexRecord.Lookup, soFromBeginning );

                                                                        while StaMul.Position < (IndexRecord.Lookup+IndexRecord.Length) do begin
                                                                                StaMul.Read( Id, 2 );
                                                                                StaMul.Read( SX, 1 );
                                                                                StaMul.Read( SY, 1 );
                                                                                StaMul.Read( SZ, 1 );

                                                                                if ((X mod 8) = SX) and ((Y mod 8) = SY) then begin
                                                                                        SZ := SZ + Delta;
                                                                                        StaMul.Seek( -1, soFromCurrent );
                                                                                        StaMul.Write( SZ, 1 );
                                                                                end;

                                                                                StaMul.Read( Color, 2 );
                                                                        end;
                                                                end;
                                                        end;

                                                        Patcher.Geschw.Caption := Format( '%d %', [Round( 100*( (X-MinX)*(MaxY-MinY+1) + (Y-MinY) ) / ( (MaxX-MinX+1)*(MaxY-MinY+1) ) )] );
                                                        Application.ProcessMessages;
                                                end;
                                        end;
                                        Log( Patcher.GetLang( 'Done' ) );
                                        continue;
                                end;
                                {ReIndex_Anim : begin
                                        Log( Patcher.GetLang( 'Preparing reindex' ) );
                                        Log( 'Free Anim' );
                                        Patcher.FileCache.FreeFile( 'anim.idx' );
                                        Patcher.FileCache.FreeFile( 'anim.mul' );

                                        try
                                                Log( 'Backup Anim' );
                                                if FileExists( Config.GetString( 'UOPath' ) + 'anim.idx.bak' ) then
                                                        DeleteFile( Config.GetString( 'UOPath' ) + 'anim.idx.bak' );
                                                RenameFile( Config.GetString( 'UOPath' ) + 'anim.idx', Config.GetString( 'UOPath' ) + 'anim.idx.bak' );
                                                if FileExists( Config.GetString( 'UOPath' ) + 'anim.mul.bak' ) then
                                                        DeleteFile( Config.GetString( 'UOPath' ) + 'anim.mul.bak' );
                                                RenameFile( Config.GetString( 'UOPath' ) + 'anim.mul', Config.GetString( 'UOPath' ) + 'anim.mul.bak' );

                                                Log( 'Open Files' );
                                                OldIdx := TFileStream.Create( Config.GetString( 'UOPath' ) + 'anim.idx.bak', fmOpenRead );
                                                NewIdx := TFileStream.Create( Config.GetString( 'UOPath' ) + 'anim.idx', fmCreate );
                                                OldMul := TFileStream.Create( Config.GetString( 'UOPath' ) + 'anim.mul.bak', fmOpenRead );
                                                NewMul := TFileStream.Create( Config.GetString( 'UOPath' ) + 'anim.mul', fmCreate );
                                        except
                                                on E : Exception do
                                                        raise Exception.Create( E.Message );
                                        end;
                                        ReIndexTyp := 'Animations';
                                end; }
                                ReIndex_Art : begin
                                        Log( Patcher.GetLang( 'Preparing reindex' ) );
                                        Log( 'Free Art' );
                                        Patcher.FileCache.FreeFile( 'artidx.mul' );
                                        Patcher.FileCache.FreeFile( 'art.mul' );

                                        try
                                                Log( 'Backup Art' );
                                                if FileExists( Config.GetString( 'UOPath' ) + 'artidx.mul.bak' ) then
                                                        DeleteFile( Config.GetString( 'UOPath' ) + 'artidx.mul.bak' );
                                                RenameFile( Config.GetString( 'UOPath' ) + 'artidx.mul', Config.GetString( 'UOPath' ) + 'artidx.mul.bak' );
                                                if FileExists( Config.GetString( 'UOPath' ) + 'art.mul.bak' ) then
                                                        DeleteFile( Config.GetString( 'UOPath' ) + 'art.mul.bak' );
                                                RenameFile( Config.GetString( 'UOPath' ) + 'art.mul', Config.GetString( 'UOPath' ) + 'art.mul.bak' );

                                                Log( 'Open Files' );
                                                OldIdx := TFileStream.Create( Config.GetString( 'UOPath' ) + 'artidx.mul.bak', fmOpenRead );
                                                NewIdx := TFileStream.Create( Config.GetString( 'UOPath' ) + 'artidx.mul', fmCreate );
                                                OldMul := TFileStream.Create( Config.GetString( 'UOPath' ) + 'art.mul.bak', fmOpenRead );
                                                NewMul := TFileStream.Create( Config.GetString( 'UOPath' ) + 'art.mul', fmCreate );
                                        except
                                                on E : Exception do
                                                        raise Exception.Create( E.Message );
                                        end;
                                        ReIndexTyp := 'Art';
                                end;
                                ReIndex_Gumps : begin
                                        Log( Patcher.GetLang( 'Preparing reindex' ) );
                                        Log( 'Free Gumps' );
                                        Patcher.FileCache.FreeFile( 'gumpidx.mul' );
                                        Patcher.FileCache.FreeFile( 'gumpart.mul' );

                                        try
                                                Log( 'Backup Gumps' );                                        
                                                if FileExists( Config.GetString( 'UOPath' ) + 'gumpidx.mul.bak' ) then
                                                        DeleteFile( Config.GetString( 'UOPath' ) + 'gumpidx.mul.bak' );
                                                RenameFile( Config.GetString( 'UOPath' ) + 'gumpidx.mul', Config.GetString( 'UOPath' ) + 'gumpidx.mul.bak' );
                                                if FileExists( Config.GetString( 'UOPath' ) + 'gumpart.mul.bak' ) then
                                                        DeleteFile( Config.GetString( 'UOPath' ) + 'gumpart.mul.bak' );
                                                RenameFile( Config.GetString( 'UOPath' ) + 'gumpart.mul', Config.GetString( 'UOPath' ) + 'gumpart.mul.bak' );

                                                Log( 'Open Files' );
                                                OldIdx := TFileStream.Create( Config.GetString( 'UOPath' ) + 'gumpidx.mul.bak', fmOpenRead );
                                                NewIdx := TFileStream.Create( Config.GetString( 'UOPath' ) + 'gumpidx.mul', fmCreate );
                                                OldMul := TFileStream.Create( Config.GetString( 'UOPath' ) + 'gumpart.mul.bak', fmOpenRead );
                                                NewMul := TFileStream.Create( Config.GetString( 'UOPath' ) + 'gumpart.mul', fmCreate );
                                        except
                                                on E : Exception do
                                                        raise Exception.Create( E.Message );
                                        end;
                                        ReIndexTyp := 'Gumps';
                                end;
                                ReIndex_Sound : begin
                                        Log( Patcher.GetLang( 'Preparing reindex' ) );
                                        Log( 'Free Sound' );
                                        Patcher.FileCache.FreeFile( 'soundidx.mul' );
                                        Patcher.FileCache.FreeFile( 'sound.mul' );

                                        try
                                                Log( 'Backup Sound' );
                                                if FileExists( Config.GetString( 'UOPath' ) + 'soundidx.mul.bak' ) then
                                                        DeleteFile( Config.GetString( 'UOPath' ) + 'soundidx.mul.bak' );
                                                RenameFile( Config.GetString( 'UOPath' ) + 'soundidx.mul', Config.GetString( 'UOPath' ) + 'soundidx.mul.bak' );
                                                if FileExists( Config.GetString( 'UOPath' ) + 'sound.mul.bak' ) then
                                                        DeleteFile( Config.GetString( 'UOPath' ) + 'sound.mul.bak' );
                                                RenameFile( Config.GetString( 'UOPath' ) + 'sound.mul', Config.GetString( 'UOPath' ) + 'sound.mul.bak' );

                                                Log( 'Open Files' );
                                                OldIdx := TFileStream.Create( Config.GetString( 'UOPath' ) + 'soundidx.mul.bak', fmOpenRead );
                                                NewIdx := TFileStream.Create( Config.GetString( 'UOPath' ) + 'soundidx.mul', fmCreate );
                                                OldMul := TFileStream.Create( Config.GetString( 'UOPath' ) + 'sound.mul.bak', fmOpenRead );
                                                NewMul := TFileStream.Create( Config.GetString( 'UOPath' ) + 'sound.mul', fmCreate );
                                        except
                                                on E : Exception do
                                                        raise Exception.Create( E.Message );
                                        end;
                                        ReIndexTyp := 'Sound';
                                end;
                                ReIndex_Statics : begin
                                        Log( Patcher.GetLang( 'Preparing reindex' ) );
                                        Log( 'Free Statics' );
                                        Patcher.FileCache.FreeFile( 'staidx0.mul' );
                                        Patcher.FileCache.FreeFile( 'statics0.mul' );

                                        try
                                                Log( 'Backup Statics' );
                                                if FileExists( Config.GetString( 'UOPath' ) + 'staidx0.mul.bak' ) then
                                                        DeleteFile( Config.GetString( 'UOPath' ) + 'staidx0.mul.bak' );
                                                RenameFile( Config.GetString( 'UOPath' ) + 'staidx0.mul', Config.GetString( 'UOPath' ) + 'staidx0.mul.bak' );
                                                if FileExists( Config.GetString( 'UOPath' ) + 'statics0.mul.bak' ) then
                                                        DeleteFile( Config.GetString( 'UOPath' ) + 'statics0.mul.bak' );
                                                RenameFile( Config.GetString( 'UOPath' ) + 'statics0.mul', Config.GetString( 'UOPath' ) + 'statics0.mul.bak' );

                                                Log( 'Open Files' );
                                                OldIdx := TFileStream.Create( Config.GetString( 'UOPath' ) + 'staidx0.mul.bak', fmOpenRead );
                                                NewIdx := TFileStream.Create( Config.GetString( 'UOPath' ) + 'staidx0.mul', fmCreate );
                                                OldMul := TFileStream.Create( Config.GetString( 'UOPath' ) + 'statics0.mul.bak', fmOpenRead );
                                                NewMul := TFileStream.Create( Config.GetString( 'UOPath' ) + 'statics0.mul', fmCreate );
                                        except
                                                on E : Exception do
                                                        raise Exception.Create( E.Message );
                                        end;
                                        ReIndexTyp := 'Statics';
                                end;
                                ReIndex_Textures : begin
                                        Log( Patcher.GetLang( 'Preparing reindex' ) );
                                        Log( 'Free Textures' );                                
                                        Patcher.FileCache.FreeFile( 'texidx.mul' );
                                        Patcher.FileCache.FreeFile( 'texmaps.mul' );

                                        try
                                                Log( 'Backup Textures' );                                        
                                                if FileExists( Config.GetString( 'UOPath' ) + 'texidx.mul.bak' ) then
                                                        DeleteFile( Config.GetString( 'UOPath' ) + 'texidx.mul.bak' );
                                                RenameFile( Config.GetString( 'UOPath' ) + 'texidx.mul', Config.GetString( 'UOPath' ) + 'texidx.mul.bak' );
                                                if FileExists( Config.GetString( 'UOPath' ) + 'texmaps.mul.bak' ) then
                                                        DeleteFile( Config.GetString( 'UOPath' ) + 'texmaps.mul.bak' );
                                                RenameFile( Config.GetString( 'UOPath' ) + 'texmaps.mul', Config.GetString( 'UOPath' ) + 'texmaps.mul.bak' );

                                                Log( 'Open Files' );                                                
                                                OldIdx := TFileStream.Create( Config.GetString( 'UOPath' ) + 'texidx.mul.bak', fmOpenRead );
                                                NewIdx := TFileStream.Create( Config.GetString( 'UOPath' ) + 'texidx.mul', fmCreate );
                                                OldMul := TFileStream.Create( Config.GetString( 'UOPath' ) + 'texmaps.mul.bak', fmOpenRead );
                                                NewMul := TFileStream.Create( Config.GetString( 'UOPath' ) + 'texmaps.mul', fmCreate );
                                        except
                                                on E : Exception do
                                                        raise Exception.Create( E.Message );
                                        end;
                                        ReIndexTyp := 'Textures';
                                end;
                                else begin
                                        continue;
                                end;
                        end;

                        OldIdx.Seek( 0, soFromBeginning );
                        NewIdx.Seek( 0, soFromBeginning );
                        NewMul.Seek( 0, soFromBeginning );

                        Patcher.Memo.Lines.Add( 'Reindexing ' + ReIndexTyp + '.' );
                        Log( Patcher.GetLang( 'Start reindication' ) );

                        I := 0;
                        while OldIdx.Position < OldIdx.Size do begin
                                if (I mod 100) = 0 then begin
                                        Patcher.Geschw.Caption := IntToStr( Trunc( 100*OldIdx.Position/OldIdx.Size ) ) + '%';
                                        Application.ProcessMessages;
                                end;

                                OldIdx.Read( IndexOld, sizeof( TUOIndex ) );
                                if ( IndexOld.Lookup = -1 ) or ( IndexOld.Length = -1 ) then begin
                                        IndexNew.Lookup := -1;
                                        IndexNew.Length := -1;
                                        IndexNew.Tag := -1;
                                        NewIdx.Write( IndexNew, sizeof( TUOIndex ) );
                                end
                                else begin
                                        IndexNew.Lookup := NewMul.Position;
                                        IndexNew.Length := IndexOld.Length;
                                        IndexNew.Tag := IndexOld.Tag;
                                        NewIdx.Write( IndexNew, sizeof( TUOIndex ) );

                                        OldMul.Seek( IndexOld.Lookup, soFromBeginning );
                                        NewMul.CopyFrom( OldMul, IndexOld.Length );
                                end;
                        end;

                        Patcher.geschw.Caption := '';

                        OldIdx.Free;
                        OldMul.Free;
                        NewIdx.Free;
                        NewMul.Free;

                        Patcher.Memo.Lines.Add(  Patcher.GetLang( 'Reindexing of' ) + ' ' + ReIndexTyp + ' ' + Patcher.GetLang( 'Done' ) );
                end;

                Application.ProcessMessages;
        end;
        if not Patcher.Ending then begin
                Patcher.Balken.Percent := 100;

                Patcher.Memo.Lines.Add( Patcher.GetLang( 'Patch installed' ) );
                Patcher.Memo.Lines.Add( '' );
        end;
        MStream.Free;
        Log( Patcher.GetLang( 'Deleting tempfile' ) );
        DeleteFile( ExtractFilePath( Application.ExeName ) + 'patches\temp.' + FileSuffix );
        if Patcher.Ending then
                Log( Patcher.GetLang( 'Patch interrupted' ) )
        else
                Log( Patcher.GetLang( 'Patch done' ) );
        Terminate;
end;

procedure TPatcher.StartPatcher;
var     MStream, MStream2 : TMemoryStream;
        Ini, Nachrichten, Hashes: TMemIniFile;
        I, Auth, Count : Integer;
        VersionServer, VersionLokal : integer;
        FStream : TFileStream;
        Liste : TStringList;
        FileName, PatchName : String;
        TmpList : TStringList;
begin
        try
                if FileExists( ExtractFilePath( Application.ExeName ) + 'log.txt' ) then
                        DeleteFile( ExtractFilePath( Application.ExeName ) + 'log.txt' );

                if Config.GetInteger( 'SecToWaitAfterPatching' ) = 0 then
                        Config.SetInteger( 'SecToWaitAfterPatching', 5 );
                if Config.GetInteger( 'DoNotStartClientAfterPatching' ) = 0 then
                        Config.SetInteger( 'DoNotStartClientAfterPatching', 0 );
                if Config.GetInteger( 'ShowNotAlways' ) = 0 then
                        Config.SetInteger( 'ShowNotAlways', 0 );

                if Config.GetInteger( 'ShowNotAlways' ) = 0 then
                        Show;

                try
                        Memo.Lines.Add( GetLang( 'Searching for patcher updates at http://patcher.uodev.de/' ) );

                        HTTP_TDV.RedirectMaximum := 100;
                        HTTP_TDV.HandleRedirects := true;
                        MStream := TMemoryStream.Create;
                        MStream.Seek( 0, soFromBeginning );

                        HTTP_TDV.Get( 'http://patcher.uodev.de/patcherversion.tdv', MStream );
                        MStream.SaveToFile( ExtractFilePath( Application.ExeName ) + 'patcherversion.tdv' );

                        Ini := TMemIniFile.Create( ExtractFilePath( Application.ExeName ) + 'patcherversion.tdv' );
                        DeleteFile( ExtractFilePath( Application.ExeName ) + 'patcherversion.tdv' );

                        if PatcherVersion < Ini.ReadInteger( 'TDV', 'PatcherVersion', 0 ) then begin
                                Show;
                                Memo.Lines.Add( Patcher.GetLang( 'New version of this patcher is loading' ) );
                                MStream2 := TMemoryStream.Create;
                                MStream2.Seek( 0, soFromBeginning );
                                HTTP_TDV.Get( 'http://patcher.uodev.de/autopatcher_new.dll', MStream2 );
                                MStream2.SaveToFile( ExtractFilePath( Application.ExeName ) + 'autopatcher_new.dll' );
                                MStream2.Free;
                                Memo.Lines.Add( GetLang( 'New version loaded successfully' ) );
                                Memo.Lines.Add( '' );
                                Memo.Lines.Add( GetLang( 'Please restart patcher' ) );

                                MStream.Free;
                                Ini.Free;
                                Sleep( 2000 );
                                exit;
                                end
                        else
                                Memo.Lines.Add( GetLang( 'Patcher is up to date' ) );

                        Ini.Free;
                except
                        Memo.Lines.Add( GetLang( 'Could not reach updateserver, going on' ) );
                end;

                Memo.Lines.Add( '' );
                MStream.Free;

                Memo.Lines.Add( GetLang( 'Connecting to the server' ) );

                MStream := TMemoryStream.Create;
                MStream.Seek( 0, soFromBeginning );

                HTTP.RedirectMaximum := 100;
                HTTP.HandleRedirects := True;
                HTTP.AllowCookies := True;
                StartSize := 0;

                HTTP.Request.ContentRangeStart := 0;

                HTTP.Get( Config.GetString( 'Servername' ) + 'version.tdv', MStream );

                Memo.Lines.Add( GetLang( 'Checking version' ) );

                MStream.SaveToFile( ExtractFilePath( Application.ExeName ) + 'version.tdv' );
                MStream.Free;

                Ini := TMemIniFile.Create( ExtractFilePath( Application.ExeName ) + 'version.tdv' );

                DeleteFile( ExtractFilePath( Application.ExeName ) + 'version.tdv' );

                FileSuffix := Ini.ReadString( 'TDV', 'FileSuffix', 'tdv' );

                if Ini.ReadString( 'TDV', 'Shardinfo', '' ) <> '' then begin
                        MemoShardinfo.Clear;

                        TmpList := TStringList.Create;
                        StrLib.Split( Ini.ReadString( 'TDV', 'Shardinfo', '' ), '\n', TmpList );
                        MemoShardinfo.Lines.AddStrings( TmpList );
                        TmpList.Free;
                end
                else
                        MemoShardinfo.Lines.Add( GetLang( 'No News existing' ) );

                if Ini.ReadString( 'TDV', 'Banner', '' ) <> Config.GetString( 'Banner' ) then begin
                        Config.SetString( 'Banner', Ini.ReadString( 'TDV', 'Banner', '' ) );
                        if Config.GetString( 'Banner' ) <> '' then begin
                                MStream := TMemoryStream.Create;
                                MStream.Seek( 0, soFromBeginning );
                                HTTP.Request.ContentRangeStart := 0;
                                HTTP.Get( Config.GetString( 'Servername' ) + Config.GetString( 'Banner' ), MStream );
                                MStream.SaveToFile( ExtractFilePath( Application.ExeName ) + Config.GetString( 'Banner' ) );
                                MStream.Free;
                                Banner.Picture.LoadFromFile( ExtractFilePath( Application.ExeName ) + Config.GetString( 'Banner' ) );
                        end;
                end;

                Auth := Ini.ReadInteger( 'TDV', 'Auth', 0 );

                Memo.Lines.Add( GetLang( 'Local version' ) + ':' + Config.GetString( 'Versionname' ) );
                Memo.Lines.Add( GetLang( 'Server version' ) + ':' + Ini.ReadString( 'TDV', 'Versionname', '' ) );

                VersionLokal := Config.GetInteger( 'Version' );
                VersionServer := Ini.ReadInteger( 'TDV', 'Version', 0 );

                Memo.Lines.Add( '' );

                if Ini.ReadInteger( 'TDV', 'ShowPatcherOnlyForPatches', 0 ) > 0 then
                        Config.SetInteger( 'ShowNotAlways', 1 );

                if VersionLokal = VersionServer then begin
                        Memo.Lines.Add( GetLang( 'Local version is up to date' ) );
                        end
                else begin
                        Show;
                        memo.Lines.Add( inttostr( VersionServer - VersionLokal ) + ' ' + GetLang( 'new patches' ) );

                        FileCache := TFileCache.Create( Config.GetString( 'UOPath' ) );

                        Nachrichten := nil;
                        if Ini.ReadInteger( 'TDV', 'PatchMessages', 0 ) > 0 then begin
                                FileName := ExtractFilePath( Application.ExeName ) + 'patches\messages.ini';
                                if FileExists( FileName ) then
                                        DeleteFile( FileName );
                                FStream := TFileStream.Create( FileName, fmCreate );
                                FStream.Seek( 0, soFromBeginning );
                                HTTP.Get( Config.GetString( 'Servername' ) + 'messages.ini', FStream );
                                FStream.Free;

                                Nachrichten := TMemIniFile.Create( FileName );
                                DeleteFile( FileName );
                        end;

                        Hashes := nil;
                        if Ini.ReadInteger( 'TDV', 'Hashes', 0 ) > 0 then begin
                                FileName := ExtractFilePath( Application.ExeName ) + 'patches\hashes.ini';
                                if FileExists( FileName ) then
                                        DeleteFile( FileName );
                                FStream := TFileStream.Create( FileName, fmCreate );
                                FStream.Seek( 0, soFromBeginning );
                                HTTP.Get( Config.GetString( 'Servername' ) + 'hashes.ini', FStream );
                                FStream.Free;

                                Hashes := TMemIniFile.Create( FileName );
                                DeleteFile( FileName );
                        end;

                        I := VersionLokal+1;
                        while I <= VersionServer do begin
                                if Ending then
                                        break;

                                if Nachrichten <> nil then begin
                                        MemoShardInfo.Clear;
                                        TmpList := TStringList.Create;
                                        StrLib.Split( Nachrichten.ReadString( 'Patch', IntToStr( i ), GetLang( 'No message' ) ), '\n', TmpList );
                                        MemoShardinfo.Lines.AddStrings( TmpList );
                                        TmpList.Free;
                                end;

                                if (Hashes <> nil) and (Hashes.ReadString( 'Patch', IntToStr( I ), '' ) <> '') and FileExists( ExtractFilePath( Application.ExeName ) + 'patches\patch_' + IntToStr( I ) + '.' + FileSuffix ) and (LowerCase(Hashes.ReadString( 'Patch', IntToStr( I ), '' )) <> LowerCase(MD5DigestToStr( MD5File( ExtractFilePath( Application.ExeName ) + 'patches\patch_' + IntToStr( I ) + '.' + FileSuffix )) ) ) then
                                        DeleteFile( ExtractFilePath( Application.ExeName ) + 'patches\patch_' + IntToStr( I ) + '.' + FileSuffix );

                                if Auth > 0 then begin
                                        if Config.GetString( 'Username' ) = '' then
                                                Config.SetString( 'Username', SpecialInputBox( GetLang( 'Please type in your username' ), 'Username:', '' ) );
                                        if Config.GetString( 'Password' ) = '' then
                                                Config.SetString( 'Password', LowerCase( Md5DigestToStr( Md5String( SpecialInputBox( GetLang( 'Please type in your password' ), 'Passwort:', '', True ) ) ) ) );
                                        Count := 0;
                                        SessID := '0';
                                        while Count < 3 do begin
                                                HTTP.Request.ContentRangeStart := 0;
                                                HTTP.Response.ProcessHeaders;
                                                HTTP.Get( Config.GetString( 'Servername' ) + 'patcher.php?action=authenticate&user=' + Config.GetString( 'Username' ) + '&password=' + Config.GetString( 'Password' ) );
                                                if HTTP.Response.RawHeaders.Values[ 'patcher-auth' ] = 'ok' then
                                                        break
                                                else begin
                                                        Memo.Lines.Add( GetLang( 'Wrong login or password' ) );
                                                        if Count = 2 then begin
                                                                Sleep( Config.GetInteger( 'SecToWaitAfterPatching' )*1000 );
                                                                Memo.Lines.SaveToFile( ExtractFilePath( Application.ExeName ) + 'patcher.log' );
                                                                Patcher.Close;
                                                                exit;
                                                        end;
                                                end;
                                                Config.SetString( 'Username', SpecialInputBox( GetLang( 'Please type in your username' ), 'Username:', '' ) );
                                                Config.SetString( 'Password', LowerCase( Md5DigestToStr( Md5String( SpecialInputBox( GetLang( 'Please type in your password' ), 'Passwort:', '', True ) ) ) ) );
                                                Inc( Count );
                                        end;
                                end;

                                Memo.Lines.Add( GetLang( 'Loading patch' ) + ': ' + IntToStr( I ) );

                                if not FileExists( ExtractFilePath( Application.ExeName ) + 'patches\patch_' + inttostr( i ) + '.' + FileSuffix ) then begin
                                        if Auth = 0 then begin
                                                if FileExists(ExtractFilePath( Application.ExeName ) + 'patches\download_' + inttostr( i ) + '.' + FileSuffix ) then
                                                        if Ini.ReadInteger( 'TDV', 'EnableDownloadResume', 0 ) > 0 then begin
                                                                Memo.Lines.Add( GetLang( 'Opening existing patch, please wait' ) );
                                                                FStream := TFileStream.Create( ExtractFilePath( Application.ExeName ) + 'patches\download_' + inttostr( i ) + '.' + FileSuffix, fmOpenWrite );
                                                        end
                                                        else begin
                                                                DeleteFile( ExtractFilePath( Application.ExeName ) + 'patches\download_' + inttostr( i ) + '.' + FileSuffix );
                                                                FStream := TFileStream.Create( ExtractFilePath( Application.ExeName ) + 'patches\download_' + inttostr( i ) + '.' + FileSuffix, fmCreate );
                                                        end
                                                else
                                                        FStream := TFileStream.Create( ExtractFilePath( Application.ExeName ) + 'patches\download_' + inttostr( i ) + '.' + FileSuffix, fmCreate );
                                                FStream.Seek( 0, soFromEnd );
                                                StartSize := FStream.Size;
                                                HTTP.Request.ContentRangeStart := StartSize;
                                                HTTP.Get( Config.GetString( 'Servername' ) + 'patch_' + inttostr( i ) + '.' + FileSuffix, FStream );
                                                FStream.Free;
                                                if Ending then begin
                                                        if Ini.ReadInteger( 'TDV', 'EnableDownloadResume', 0 ) = 0 then
                                                                DeleteFile( ExtractFilePath( Application.ExeName ) + 'patches\download_' + inttostr( i ) + '.' + FileSuffix );
                                                        Sleep( Config.GetInteger( 'SecToWaitAfterPatching' )*1000 );
                                                        Memo.Lines.SaveToFile( ExtractFilePath( Application.ExeName ) + 'patcher.log' );
                                                        Patcher.Close;
                                                        exit;
                                                end;
                                                RenameFile( ExtractFilePath( Application.ExeName ) + 'patches\download_' + inttostr( i ) + '.' + FileSuffix,  ExtractFilePath( Application.ExeName ) + 'patches\patch_' + inttostr( i ) + '.' + FileSuffix );
                                        end
                                        else begin
                                                Count := 0;
                                                while Count < 3 do begin
                                                        if FileExists(ExtractFilePath( Application.ExeName ) + 'patches\download_' + inttostr( i ) + '.' + FileSuffix ) then
                                                                if Ini.ReadInteger( 'TDV', 'EnableDownloadResume', 0 ) > 0 then begin
                                                                        Memo.Lines.Add( GetLang( 'Opening existing patch, please wait' ) );
                                                                        FStream := TFileStream.Create( ExtractFilePath( Application.ExeName ) + 'patches\download_' + inttostr( i ) + '.' + FileSuffix, fmOpenWrite );
                                                                end
                                                                else begin
                                                                        DeleteFile( ExtractFilePath( Application.ExeName ) + 'patches\download_' + inttostr( i ) + '.' + FileSuffix );
                                                                        FStream := TFileStream.Create( ExtractFilePath( Application.ExeName ) + 'patches\download_' + inttostr( i ) + '.' + FileSuffix, fmCreate );
                                                                end
                                                        else
                                                                FStream := TFileStream.Create( ExtractFilePath( Application.ExeName ) + 'patches\download_' + inttostr( i ) + '.' + FileSuffix, fmCreate );
                                                        FStream.Seek( 0, soFromEnd );
                                                        StartSize := FStream.Size;
                                                        HTTP.Request.ContentRangeStart := StartSize;
                                                        HTTP.Get( Config.GetString( 'Servername' ) + 'patcher.php?sessionId=' + SessID + '&request=' + 'patch_' + inttostr( i ) + '.' + FileSuffix, FStream );
                                                        FStream.Free;
                                                        if LowerCase( HTTP.Response.RawHeaders.Values[ 'patch_verification' ] ) = LowerCase( Md5DigestToStr( Md5File( ExtractFilePath( Application.ExeName ) + 'patches\download_' + inttostr( i ) + '.' + FileSuffix ) ) ) then begin
                                                                RenameFile( ExtractFilePath( Application.ExeName ) + 'patches\download_' + inttostr( i ) + '.' + FileSuffix,  ExtractFilePath( Application.ExeName ) + 'patches\patch_' + inttostr( i ) + '.' + FileSuffix );
                                                                break;
                                                        end
                                                        else if Ending or (Count = 2) then begin
                                                                Memo.Lines.Add( 'Patch patch_' + inttostr( i ) + '.' + FileSuffix + ' scheint defekt zu sein, patchen abgebrochen.' );
                                                                if Ini.ReadInteger( 'TDV', 'EnableDownloadResume', 0 ) = 0 then
                                                                        DeleteFile( ExtractFilePath( Application.ExeName ) + 'patches\download_' + inttostr( i ) + '.' + FileSuffix );
                                                                Sleep( Config.GetInteger( 'SecToWaitAfterPatching' )*1000 );
                                                                Memo.Lines.SaveToFile( ExtractFilePath( Application.ExeName ) + 'patcher.log' );
                                                                Patcher.Close;
                                                                exit;
                                                        end;
                                                        Inc( Count );
                                                end;
                                        end;
                                        StartSize := 0;
                                end;

                                Memo.Lines.Add( GetLang( 'Patch loaded' ) );

                                JumpTo := I;

                                FStream := TFileStream.Create( ExtractFilePath( Application.ExeName ) + 'patches\patch_' + inttostr( i ) + '.' + FileSuffix, fmOpenRead );
                                try
                                        ApplyPatch( FStream );
                                except
                                        on E : Exception do begin
                                                Memo.Lines.Add( E.Message );
                                                Sleep( Config.GetInteger( 'SecToWaitAfterPatching' )*1000 );
         					Memo.Lines.SaveToFile( ExtractFilePath( Application.ExeName ) + 'patcher.log' );
                                                exit;
                                        end;
                                end;

                                I := JumpTo;

                                FStream.Free;
                                BalkenGesamt.Percent := trunc( 100*(i-VersionLokal)/(VersionServer-VersionLokal) );

                                if not Ending then
                                        Config.SetInteger( 'Version', I );
                                Inc( I );
                        end;

                        FileCache.Free;

                        if not Ending then
                                Config.SetString( 'Versionname', Ini.ReadString( 'TDV', 'Versionname', '' ) );

                        if Nachrichten <> nil then
                                Nachrichten.Free;
                end;

                Sleep( Config.GetInteger( 'SecToWaitAfterPatching' )*1000 );
                Hide;

                if Ini.ReadInteger( 'TDV', 'Popup', 0 ) > 0 then begin
                        FileName := ExtractFilePath( Application.ExeName ) + 'popup.txt';
                        if FileExists( FileName ) then
                                DeleteFile( FileName );
                        FStream := TFileStream.Create( FileName, fmCreate );
                        FStream.Seek( 0, soFromBeginning );
                        HTTP.Get( Config.GetString( 'Servername' ) + 'popup.txt', FStream );
                        FStream.Free;

                        Liste := TStringList.Create;
                        Liste.LoadFromFile( FileName );
                        DeleteFile( FileName );

                        MessageForm.LoadText( Liste );
                        MessageForm.ShowModal;

                        Liste.Free;
                end;

                Ini.Free;

                StartClient;
        except
                on E : Exception do begin
                        Memo.Lines.Add( E.Message );
                        Sleep( Config.GetInteger( 'SecToWaitAfterPatching' )*1000 );
                        Memo.Lines.SaveToFile( ExtractFilePath( Application.ExeName ) + 'patcher.log' );
                        exit;
                end;
        end;
end;

procedure TPatcher.HTTPWork(Sender: TObject; AWorkMode: TWorkMode;
  const AWorkCount: Integer);
var TickCount : Integer;
begin
        Balken.Percent := trunc( 100 * ( (AWorkCount+StartSize) / (HTTP.Response.ContentLength+StartSize) ) );
        Caption := Format( '%d%s %s', [Balken.Percent,'%',CustomCaption] );
        Menge.Caption := inttostr( trunc( (AWorkCount+StartSize)/1024  ) ) + '/' + inttostr( trunc( (HTTP.Response.ContentLength+StartSize)/1024 ) ) + ' kb';

        if LastTick <> 0 then begin
                TickCount := GetTickCount;
                if (TickCount-LastTick) >= 1000 then begin
                        Geschw.Caption := inttostr( trunc( (AWorkCount-SizeLastTick) / (TickCount-LastTick) ) ) + ' kb/s';
                        LastTick := TickCount;
                        SizeLastTick := AWorkCount;
                end;
        end
        else begin
                LastTick := GetTickCount;
                SizeLastTick := AWorkCount;
        end;
        Application.ProcessMessages;
end;

procedure TPatcher.HTTPWorkEnd(Sender: TObject; AWorkMode: TWorkMode);
begin
        Balken.Percent := 0;
        Menge.Caption := '';
        Geschw.Caption := '';
        Caption := CustomCaption;
end;

procedure TPatcher.HTTPWorkBegin(Sender: TObject; AWorkMode: TWorkMode;
  const AWorkCountMax: Integer);
begin
        if HTTP.Response.ContentLength <> 0 then
                if HTTP.Response.ContentLength > 1024 then
                        Memo.Lines.Add( GetLang( 'Loading' ) + ' ' + inttostr( trunc( HTTP.Response.ContentLength/1024 ) ) + ' kb.' );
        SizeLastTick := 0;
        LastTick := 0;
end;

procedure TPatchThread.ProgressCallback(Current: integer);
begin
        Patcher.Balken.Percent := trunc(100*(Current/Totalsize) );
        Application.ProcessMessages;
end;

procedure TPatcher.btnCancelClick(Sender: TObject);
begin
        Ending := True;
        if Http.Connected then
                Http.Disconnect;
        Application.Terminate;
end;

procedure TPatcher.HTTP_TDVWork(Sender: TObject; AWorkMode: TWorkMode;
  const AWorkCount: Integer);
var TickCount : Integer;
begin
        Balken.Percent := trunc( 100 * ( AWorkCount / HTTP_TDV.Response.ContentLength ) );
        Menge.Caption := inttostr( trunc( AWorkCount/1024  ) ) + '/' + inttostr( trunc( HTTP_TDV.Response.ContentLength/1024 ) ) + ' kb';

        if LastTick <> 0 then begin
                TickCount := GetTickCount;
                if (TickCount-LastTick) >= 1000 then begin
                        Geschw.Caption := inttostr( trunc( (AWorkCount-SizeLastTick) / (TickCount-LastTick) ) ) + ' kb/s';
                        LastTick := TickCount;
                        SizeLastTick := AWorkCount;
                end;
        end
        else begin
                LastTick := GetTickCount;
                SizeLastTick := AWorkCount;
        end;
        Application.ProcessMessages;
end;

procedure TPatcher.HTTP_TDVWorkBegin(Sender: TObject; AWorkMode: TWorkMode;
  const AWorkCountMax: Integer);
begin
        if HTTP_TDV.Response.ContentLength <> 0 then
                if HTTP_TDV.Response.ContentLength > 1024 then
                        Memo.Lines.Add( GetLang( 'Loading' ) + ' ' + inttostr( trunc( HTTP_TDV.Response.ContentLength/1024 ) ) + ' kb.' );
        SizeLastTick := 0;
        LastTick := 0;
end;

procedure TPatcher.HTTP_TDVWorkEnd(Sender: TObject; AWorkMode: TWorkMode);
begin
        Balken.Percent := 0;
        Menge.Caption := '';
        Geschw.Caption := '';
end;

procedure TPatcher.CookieManNewCookie(ASender: TObject;
  ACookie: TIdCookieRFC2109; var VAccept: Boolean);
var     P : Integer;
begin
        P := Pos( ';', ACookie.CookieText );
        SessID := Copy( ACookie.CookieText, 11, P-11 );
end;

function TPatcher.SpecialInputBox( const ACaption, APrompt, ADefault: string; Password : Boolean ) : string;
begin
        Result := ADefault;
        SpecialInputQuery( ACaption, APrompt, Password, Result );
end;

procedure TPatcher.SpecialInputQuery( const ACaption, APrompt: string; Password : Boolean; var Value: string );
begin
        InputForm := TInputForm.Create( Application );
        InputForm.Caption := ACaption;
        InputForm.lPrompt.Caption := APrompt;
        InputForm.ePass.Text := Value;
        if Password then
                InputForm.ePass.PasswordChar := '*'
        else
                InputForm.ePass.PasswordChar := #0;
        if InputForm.ShowModal = mrOK then
                Value := InputForm.ePass.Text
        else
                Value := '';
        InputForm.Free;
end;

procedure TPatcher.FormCreate(Sender: TObject);
var     VerzDialog : TrmBrowseForFolder;
        I : Integer;
begin
        Ending := False;

        Lang := TIniFile.Create( ExtractFilePath( Application.ExeName ) + 'language.ini' );

        for I := 0 to LangValueCount-1 do begin
                if not Lang.ValueExists( 'Language', LangValues[I][0] ) then begin
                        Lang.WriteString( 'Language', LangValues[I][0], LangValues[I][1] );
                end;
        end;

        btnCancel.Caption := GetLang( 'Cancel' );

        Balken.Hint := GetLang( 'Current patch' );
        BalkenGesamt.Hint := GetLang( 'Whole patching' );

        if not DirectoryExists( ExtractFilePath( Application.ExeName ) + 'patches' ) then
                ForceDirectories( ExtractFilePath( Application.ExeName ) + 'patches' );

        if (Config.GetString( 'UOPath' ) = '') or (Config.GetString( 'UOPath' ) = '\')  or (Config.GetString( 'UOPath' ) = '/') then begin
                VerzDialog := TrmBrowseForFolder.create( self );
                VerzDialog.Title := GetLang( 'Choose your UO directory' );

                if not VerzDialog.Execute then begin
                        VerzDialog.Free;
                        Application.Terminate;
                end;

                Config.SetString( 'UOPath', VerzDialog.Folder + '\' );
                VerzDialog.Free;
        end;

        CustomCaption := Config.GetString( 'ProgName' );
        Patcher.Caption := CustomCaption;

        if Config.GetString( 'Banner' ) <> '' then
                if FileExists( ExtractFilePath( Application.ExeName ) + Config.GetString( 'Banner' ) ) then
                        Banner.Picture.LoadFromFile( ExtractFilePath( Application.ExeName ) + Config.GetString( 'Banner' ) )
                else
                        Config.SetString( 'Banner', '' );

        Version.Caption := GetLang( 'Patcherversion' ) + ': ' + inttostr( PatcherVersion );
end;

function TPatcher.GetLang( Value : String ) : String;
begin
        if Lang <> nil then
                Result := Lang.ReadString( 'Language', Value, Value )
        else
                Result := '';
end;

end.
