unit uFileCache;

interface

uses    SysUtils, Classes, uUtilities, Dialogs;

type    TFileStreamRecord = Class
                public
                        FileName : String;
                        Stream : TFileStream;                
                        constructor Create( Dir, Name : String );
                        destructor Free;
        end;

        TFileCache = Class
                private
                        Cache : TList;
                        Dir : String;
                public
                        constructor Create( NewDir : String );
                        destructor Free;
                        function GetFileStream( FileName : String ) : TFileStream;
                        procedure FreeFile( FileName : String );
        end;

implementation

uses    uAutoPatcher;

constructor TFileStreamRecord.Create( Dir, Name : String );
begin
        FileName := Name;
        try
                Stream := TFileStream.Create( Dir + Name, fmOpenReadWrite );
        except
                on E : Exception do
                        raise Exception.Create( E.Message );
        end;
end;

destructor TFileStreamRecord.Free;
begin
        try
                Stream.Free;
        except
                on E : Exception do
                        raise Exception.Create( E.Message );
        end;
end;

constructor TFileCache.Create( NewDir : String );
begin
        Dir := NewDir;
        Cache := TList.Create;
end;

destructor TFileCache.Free;
var     I : Integer;
begin
        for I := 0 to Cache.Count-1 do begin
                try
                        TFileStreamRecord( Cache.Items[ I ] ).Free;
                except
                        on E : Exception do
                                raise Exception.Create( E.Message );
                end;
        end;
        Cache.Free;
end;

function TFileCache.GetFileStream( FileName : String ) : TFileStream;
var     I : Integer;
        FileStreamRecord : TFileStreamRecord;
begin
        for I := 0 to Cache.Count-1 do begin
                if TFileStreamRecord( Cache.Items[ I ] ).FileName = FileName then begin
                        Result := TFileStreamRecord( Cache.Items[ I ] ).Stream;
                        exit;
                end;
        end;

        //file is not cached yet
        Patcher.Log( Format( 'ffne %s.', [FileName] ) );
        FileStreamRecord := TFileStreamRecord.Create( Dir, Filename );
        Patcher.Log( Format( '%s geffnet.', [FileName] ) );        
        Cache.Add( FileStreamRecord );
        Result := FileStreamRecord.Stream;
end;

procedure TFileCache.FreeFile( FileName : String );
var     I : Integer;
begin
        for I := 0 to Cache.Count-1 do begin
                if TFileStreamRecord( Cache.Items[ I ] ).FileName = FileName then begin
                        TFileStreamRecord( Cache.Items[ I ] ).Free;
                        Cache.Delete( I );
                        exit;
                end;
        end;
end;

end.
