unit uPatchmaker;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Menus, ExtCtrls, rmBrowseFor, PowerArc, Md5, uMulCrypt,
  rmNotebook2, uUtilities;

const
        knownfiles : array[0..27] of string = ( 'artidx.mul', 'art.mul', 'gumpart.mul', 'gumpidx.mul',
                        'anim.idx', 'anim.mul', 'map0.mul', 'radarcol.mul',
                        'staidx0.mul', 'statics0.mul', 'texidx.mul', 'texmaps.mul',
                        'tiledata.mul', 'soundidx.mul', 'sound.mul', 'map2.mul',
                        'staidx2.mul', 'statics2.mul', 'map3.mul', 'staidx3.mul',
                        'statics3.mul', 'map4.mul', 'staidx4.mul', 'statics4.mul',
                        'anim2.idx', 'anim3.idx', 'anim4.idx', 'anim5.idx' );
        {indextypen}
        typ_nonpatch = 0;
        typ_anim = 1;
        typ_art = 2;
        typ_gump = 3;
        typ_tex = 4;
        typ_static = 5;
        typ_map = 6;
        typ_tiledata = 7;
        typ_radarcol = 8;
        typ_sound = 9;
        typ_befehl = 10;
        typ_map2 = 11;
        typ_static2 = 12;
        typ_map3 = 13;
        typ_static3 = 14;
        typ_map4 = 15;
        typ_static4 = 16;
        typ_tiledata_variabel = 17;
        typ_anim2 = 18;
        typ_anim3 = 19;
        typ_anim4 = 20;
        typ_anim5 = 21;
        typ_config = 22;
        typ_script = 23;
        typ_encrypt = 24;
        typ_map_variabel = 25;

        ReIndex_Anim = 0;
        ReIndex_Art = 1;
        ReIndex_Gumps = 2;
        ReIndex_Sound = 3;
        ReIndex_Statics = 4;
        ReIndex_Textures = 5;
        JumpTo = 6;
        ChangeHeight = 7;

type
  Ttdvpm = class(TForm)
    popaddfile: TPopupMenu;
    Add: TMenuItem;
    Change: TMenuItem;
    Delete1: TMenuItem;
    Tab: TrmTabbedNoteBookControl;
    TabFiles: TrmNotebookPage;
    state: TLabel;
    Label2: TLabel;
    Label1: TLabel;
    Memo: TMemo;
    listbox: TListBox;
    editUoPath: TLabeledEdit;
    btnStart: TButton;
    btnChangeUoPath: TButton;
    TabReindex: TrmNotebookPage;
    lReindex: TLabel;
    cbReIndexAnim: TCheckBox;
    cbReindexArt: TCheckBox;
    cbReindexStatics: TCheckBox;
    cbReindexTextures: TCheckBox;
    cbReindexSound: TCheckBox;
    cbReIndexGumps: TCheckBox;
    eJumpTo: TLabeledEdit;
    eXMin: TLabeledEdit;
    eYMin: TLabeledEdit;
    eXMax: TLabeledEdit;
    eYMax: TLabeledEdit;
    eCH: TLabeledEdit;
    eMapHoehe: TLabeledEdit;
    eMapNr: TLabeledEdit;
    cbCHMap: TCheckBox;
    cbCHStatics: TCheckBox;
    cbEncrypt: TCheckBox;
    AddConfigFile: TMenuItem;
    AddScript: TMenuItem;
    cbME: TCheckBox;
    procedure FormContextPopup(Sender: TObject; MousePos: TPoint;
      var Handled: Boolean);
    procedure FormCreate(Sender: TObject);
    procedure AddClick(Sender: TObject);
    procedure listboxDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure ChangeClick(Sender: TObject);
    procedure btnChangeUoPathClick(Sender: TObject);
    procedure btnStartClick(Sender: TObject);
    procedure Delete1Click(Sender: TObject);
    procedure AddConfigFileClick(Sender: TObject);
    procedure AddScriptClick(Sender: TObject);
    procedure cbMEClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
    function known( name : String ) : boolean;
  public
    { Public declarations }
    MulCrypt : TMulCrypt;
    procedure ProgressCallback(Current: integer);
  end;
  {$A-}
  TIndex = record
        Lookup, Length, Tag, Typ : integer;
        end;

  TUOIndex = record
        Lookup, Length, Tag : integer;
        end;

  TMapTile = record
        Tile : word;
        Hoehe : shortint;
        end;

  TLandTile = record
        Flags : longword;
        TexID : word;
        Name : array[0..19] of char;
  end;
  
  TStaticTile = record
        Flags : longword;
        Weight, Quality : byte;
        Unknown : word;
        Unknown2 : byte;
        Quantity : byte;
        AnimID : word;
        Unknown3, Hue, Unknown4, Unknown5, Height : byte;
        Name : array[0..19] of char;
        end;

  TStaticItem = record
        Id : Word;
        X, Y : Byte;
        Z : ShortInt;
        Color : Word;
  end;
  {$A+}
var
  tdvpm: Ttdvpm;
  patchlist : TList;
  TotalSize : integer;

implementation

{$R *.dfm}

function Ttdvpm.known( name : String ) : boolean;
var i : integer;
begin
    for i:=0 to 27 do
        if knownfiles[i] = name then begin
                result := true;
                exit;
        end;
    result := false;
end;

procedure Ttdvpm.FormContextPopup(Sender: TObject; MousePos: TPoint;
  var Handled: Boolean);
begin
        if listbox.ItemIndex <> -1 then
                if Integer( patchlist.Items[ listbox.ItemIndex ] ) = 0 then
                        if known( LowerCase( ExtractFileName( listbox.Items[ listbox.ItemIndex ] ) ) ) then begin
                                popaddfile.Items[1].Caption := 'Patchen';
                                popaddfile.Items[1].Visible := true;
                                end
                        else
                                popaddfile.Items[1].Visible := false
                else begin
                        popaddfile.Items[1].Caption := 'Nicht Patchen';
                        popaddfile.Items[1].Visible := true;
                end;
        popaddfile.Popup( MousePos.X+tdvpm.Left, MousePos.Y+tdvpm.Top );
end;

procedure Ttdvpm.FormCreate(Sender: TObject);
begin
        patchlist := TList.Create;
        tab.ActivePageIndex := 1;
        tab.ActivePageIndex := 0;
        tab.Update;

        MulCrypt := nil;
end;

procedure Ttdvpm.AddClick(Sender: TObject);
var Opendialog : TOpendialog;
    i : integer;
    name : string;
begin
    Opendialog := TOpendialog.Create( nil );

    if not Opendialog.Execute then
    begin
      Opendialog.Free;
      Exit;
    end;

    if not FileExists(Opendialog.FileName) then
    begin
      Application.MessageBox( 'Diese Datei ist nicht existent. Bitte whlen sie einen gltigen Dateinamen.', 'Datei nicht gefunden', MB_OK+MB_ICONERROR );
      Opendialog.Free;
      Exit;
    end;

    if listbox.Items.Count > 0 then begin
        for i:=0 to listbox.Count-1 do
                if listbox.Items[i] = Opendialog.FileName then begin
                        Opendialog.Free;
                        Application.MessageBox( 'Jede Datei kann nur einmal ausgewhlt werden.', 'Datei schon ausgewhlt', MB_OK+MB_ICONERROR );
                        exit;
                end;
    end;

    listbox.Items.Add( Opendialog.FileName );

    name := LowerCase( ExtractFileName( Opendialog.FileName ) );
    if known( name ) then
        patchlist.Add( Pointer( 1 ) )
    else
        patchlist.Add( Pointer( 0 ) );

    Opendialog.Free;
end;


procedure Ttdvpm.listboxDrawItem(Control: TWinControl; Index: Integer;
  Rect: TRect; State: TOwnerDrawState);
begin
  listbox.Canvas.Brush.Style:=bssolid;
  listbox.Canvas.Brush.Color:=clwhite;
  if (odselected in state) then
  begin
        listbox.Canvas.Brush.Color:=clnavy;
  end;
  listbox.Canvas.FillRect(rect);

  if Integer( patchlist.Items[ Index ] ) <> 1 then
        listbox.Canvas.Font.Color:=clred
  else
        listbox.Canvas.Font.Color:=clgreen;

  listbox.Canvas.Brush.Style:=bsclear;
  if (odselected in state) then
  begin
        listbox.Canvas.Font.Color:=clwhite;
  end;

  listbox.Canvas.TextOut(10,(-listbox.TopIndex+Index)*listbox.ItemHeight,listbox.Items[Index]);
end;

procedure Ttdvpm.ChangeClick(Sender: TObject);
begin
        if listbox.ItemIndex = -1 then
                exit;
        if Integer( patchlist.Items[ listbox.ItemIndex ] ) = 0 then
                patchlist.Items[ listbox.ItemIndex ] := Pointer( 1 )
        else if Integer( patchlist.Items[ listbox.ItemIndex ] ) = 1 then
                patchlist.Items[ listbox.ItemIndex ] := Pointer( 0 );
end;

procedure Ttdvpm.btnChangeUoPathClick(Sender: TObject);
var VerzDialog : TrmBrowseForFolder;
begin
        VerzDialog := TrmBrowseForFolder.create( nil );

        if not VerzDialog.Execute then begin
                VerzDialog.Free;
                Exit;
        end;

        editUoPath.Text := IncludeTrailingPathDelimiter( VerzDialog.Folder );
end;

procedure Ttdvpm.btnStartClick(Sender: TObject);
var SaveDialog : TSaveDialog;
    MStream : TFileStream;
    FStream : TFileStream;
    filename : string;
    i,j,k,l,m : integer;
    IndexOld : TFileStream;
    Index : TIndex;
    UOIndexOld, UOIndexNew : TIndexRecord;
    buf : PByteArray;
    IndexNew, DataNew, DataOld: TFileStream;
    TmpStream : TMemoryStream;
    fn : string;
    name : array[0..30] of char;
    offset, Count : integer;
    MapTileOld, MapTileNew : TMapTile;
    ColorNew, ColorOld : word;
    LandTileOld, LandTileNew : TLandTile;
    StaticTileOld, StaticTileNew : TStaticTile;
    NameOld, NameNew : string;
    identisch : Boolean;
    ItemOld, ItemNew : TStaticItem;
    Data : TStringList;
    MinX, MaxX, MinY, MaxY, Delta : Integer;
    MapNr, ChangeMap, ChangeStatic : Byte;
    MapHoehe : Word;
    TmpRecord : TIndexRecord;
    BOld, BNew : PByteArray;
begin
    SaveDialog := TSaveDialog.Create( nil );

    if not SaveDialog.Execute then begin
        SaveDialog.Free;
        exit;
    end;

    filename := SaveDialog.FileName;
    SaveDialog.Free;

    if listbox.Count = 0 then begin
        showmessage( 'Keine Files zum Patchen ausgewhlt.' );
    end;

    MStream := TFileStream.Create( filename+'2', fmCreate );
    MStream.Seek( 0, soFromBeginning );

    for i:=0 to listbox.Count-1 do begin
        if Integer( patchlist.Items[ i ] ) = 0 then begin
                DataNew := TFileStream.Create( listbox.Items[i], fmOpenRead );
                DataNew.Seek( 0, soFromBeginning );
                Memo.Lines.Add( 'Fge Datei ' + ExtractFileName( listbox.Items[i] ) + ' zum Patch hinzu.' );
                Index.Lookup := MStream.Position + sizeof( TIndex ) + 30;
                Index.Length := DataNew.Size;
                Index.Tag := 0;
                Index.Typ := typ_nonpatch;
                lstrcpy( name, pChar( ExtractFileName( listbox.Items[i] ) ) );

                MStream.Write( Index, Sizeof( TIndex ) );
                MStream.Write( name, 30 );

                GetMem( buf, Index.Length );
                DataNew.Read( buf^, Index.Length );
                MStream.Write( buf^, Index.Length );
                FreeMem( buf, Index.Length );

                DataNew.Free;
                Memo.Lines.Add( 'Fertig.' );
                end
        else if Integer( patchlist.Items[ i ] ) = 2 then begin
                DataNew := TFileStream.Create( listbox.Items[i], fmOpenRead );
                DataNew.Seek( 0, soFromBeginning );
                Memo.Lines.Add( 'Fge ConfigDatei ' + ExtractFileName( listbox.Items[i] ) + ' zum Patch hinzu.' );
                Index.Lookup := MStream.Position + sizeof( TIndex ) + 30;
                Index.Length := DataNew.Size;
                Index.Tag := 0;
                Index.Typ := typ_config;
                lstrcpy( name, pChar( ExtractFileName( listbox.Items[i] ) ) );

                MStream.Write( Index, Sizeof( TIndex ) );
                MStream.Write( name, 30 );

                GetMem( buf, Index.Length );
                DataNew.Read( buf^, Index.Length );
                MStream.Write( buf^, Index.Length );
                FreeMem( buf, Index.Length );

                DataNew.Free;
                Memo.Lines.Add( 'Fertig.' );
                end
        else if Integer( patchlist.Items[ i ] ) = 3 then begin
                DataNew := TFileStream.Create( listbox.Items[i], fmOpenRead );
                DataNew.Seek( 0, soFromBeginning );
                Memo.Lines.Add( 'Fge Datei ' + ExtractFileName( listbox.Items[i] ) + ' zum Patch hinzu.' );
                Index.Lookup := MStream.Position + sizeof( TIndex ) + 30;
                Index.Length := DataNew.Size;
                Index.Tag := 0;
                Index.Typ := typ_script;
                lstrcpy( name, pChar( ExtractFileName( listbox.Items[i] ) ) );

                MStream.Write( Index, Sizeof( TIndex ) );
                MStream.Write( name, 30 );

                GetMem( buf, Index.Length );
                DataNew.Read( buf^, Index.Length );
                MStream.Write( buf^, Index.Length );
                FreeMem( buf, Index.Length );

                DataNew.Free;
                Memo.Lines.Add( 'Fertig.' );
                end
        else if Integer( patchlist.Items[ i ] ) = 1 then begin
                fn := LowerCase( ExtractFileName( listbox.Items[ i ] ) );
                if fn = 'artidx.mul' then begin
                        memo.Lines.Add( 'Erstelle Patch fr Art.' );
                        IndexNew := TFileStream.Create( listbox.Items[i], fmOpenRead );
                        IndexOld := TFileStream.Create( editUOPath.Text + 'artidx.mul', fmOpenRead );
                        J := 0;
                        K := 0;
                        IndexNew.Seek( 0, soFromBeginning );
                        IndexOld.Seek( 0, soFromBeginning );

                        DataNew := TFileStream.Create( ExtractFilePath( listbox.Items[i] ) + 'art.mul', fmOpenRead );
                        DataOld := TFileStream.Create( editUOPath.Text + 'art.mul', fmOpenRead );

                        while IndexNew.Position < IndexNew.Size do begin
                                if IndexOld.Position < IndexOld.Size then begin
                                        IndexOld.Read( UOIndexOld, 12 );
                                        if cbME.Checked then begin
                                                MulCrypt.DecryptIndexRecordArt( (IndexOld.Position-12) div 12, UOIndexOld );
                                        end;
                                end
                                else begin
                                        UOIndexOld.Offset := -1;
                                        UOIndexOld.Length := -1;
                                        UOIndexOld.Extra := 0;
                                end;
                                
                                IndexNew.Read( UOIndexNew, 12 );
                                if cbME.Checked then begin
                                        MulCrypt.DecryptIndexRecordArt( (IndexNew.Position-12) div 12, UOIndexNew );
                                end;
                                Inc( K );

                                if K mod 100 = 0 then begin
                                        State.Caption := Inttostr( trunc( 100 * IndexNew.Position / IndexNew.Size ) ) + '%';
                                        Application.ProcessMessages;
                                end;

                                Identisch := ( UOIndexOld.Length = UOIndexNew.Length ) and ( UOIndexOld.Extra = UOIndexNew.Extra );

                                if Identisch and (UOIndexNew.Offset <> -1) and (UOIndexOld.Offset <> -1) then begin
                                        DataOld.Seek( UOIndexOld.Offset, soFromBeginning );
                                        DataNew.Seek( UOIndexNew.Offset, soFromBeginning );

                                        GetMem( BOld, UOIndexOld.Length );
                                        GetMem( BNew, UOIndexOld.Length );

                                        DataOld.Read( BOld^, UOIndexOld.Length );
                                        DataNew.Read( BNew^, UOIndexOld.Length );

                                        for m := 0 to UOIndexOld.Length-1 do begin
                                                if BOld^[ m ] <> BNew^[ m ] then begin
                                                        Identisch := False;
                                                        Break;
                                                end;
                                        end;

                                        FreeMem( BOld );
                                        FreeMem( BNew );
                                end;

                                if Identisch and (UOIndexNew.Offset <> -1) and (UOIndexOld.Offset = -1) then begin
                                        Identisch := False;
                                end;

                                if not Identisch then begin
                                        Index.Lookup := IndexNew.Position - 12;
                                        Index.Length := UOIndexNew.Length;
                                        Index.Tag := UOIndexNew.Extra;
                                        Index.Typ := typ_art;

                                        if cbME.Checked then begin
                                                TmpRecord.Offset := Index.Lookup;
                                                TmpRecord.Length := Index.Length;
                                                TmpRecord.Extra := Index.Tag;
                                                MulCrypt.EncryptIndexRecordArt( Index.Typ, TmpRecord );
                                                Index.Lookup := TmpRecord.Offset;
                                                Index.Length := TmpRecord.Length;
                                                Index.Tag := TmpRecord.Extra;
                                        end;

                                        MStream.Write( Index, sizeof( TIndex ) );

                                        if UOIndexNew.Offset <> -1 then begin
                                                DataNew.Seek( UOIndexNew.Offset, soFrombeginning );
                                                MStream.CopyFrom( DataNew, UOIndexNew.Length );
                                        end;
                                        Inc( J );
                                        if J mod 10 = 0 then
                                                Application.ProcessMessages;
                                end;
                        end;
                        DataNew.Free;
                        DataOld.Free;
                        IndexOld.Free;
                        IndexNew.Free;
                        State.Caption := '';
                        Memo.Lines.Add( inttostr( j ) + ' IDs gepatcht.' );
                end;
                //gumpart.mul
                if fn = 'gumpidx.mul' then begin
                        memo.Lines.Add( 'Erstelle Patch fr Gumps.' );
                        IndexNew := TFileStream.Create( listbox.Items[i], fmOpenRead );
                        IndexOld := TFileStream.Create( editUOPath.Text + 'gumpidx.mul', fmOpenRead );
                        J := 0;
                        K := 0;
                        IndexNew.Seek( 0, soFromBeginning );
                        IndexOld.Seek( 0, soFromBeginning );

                        DataNew := TFileStream.Create( ExtractFilePath( listbox.Items[i] ) + 'gumpart.mul', fmOpenRead );
                        DataOld := TFileStream.Create( editUOPath.Text + 'gumpart.mul', fmOpenRead );

                        while IndexNew.Position < IndexNew.Size do begin
                                if IndexOld.Position < IndexOld.Size then begin
                                        IndexOld.Read( UOIndexOld, 12 );
                                        if cbME.Checked then begin
                                                MulCrypt.DecryptIndexRecordGump( (IndexOld.Position-12) div 12, UOIndexOld );
                                        end;
                                end
                                else begin
                                        UOIndexOld.Offset := -1;
                                        UOIndexOld.Length := -1;
                                        UOIndexOld.Extra := 0;
                                end;
                                
                                IndexNew.Read( UOIndexNew, 12 );
                                if cbME.Checked then begin
                                        MulCrypt.DecryptIndexRecordGump( (IndexNew.Position-12) div 12, UOIndexNew );
                                end;
                                Inc( K );

                                if K mod 100 = 0 then begin
                                        State.Caption := Inttostr( trunc( 100 * IndexNew.Position / IndexNew.Size ) ) + '%';
                                        Application.ProcessMessages;
                                end;

                                Identisch := ( UOIndexOld.Length = UOIndexNew.Length ) and ( UOIndexOld.Extra = UOIndexNew.Extra );

                                if Identisch and (UOIndexNew.Offset <> -1) and (UOIndexOld.Offset <> -1) then begin
                                        DataOld.Seek( UOIndexOld.Offset, soFromBeginning );
                                        DataNew.Seek( UOIndexNew.Offset, soFromBeginning );

                                        GetMem( BOld, UOIndexOld.Length );
                                        GetMem( BNew, UOIndexOld.Length );

                                        DataOld.Read( BOld^, UOIndexOld.Length );
                                        DataNew.Read( BNew^, UOIndexOld.Length );

                                        for m := 0 to UOIndexOld.Length-1 do begin
                                                if BOld^[ m ] <> BNew^[ m ] then begin
                                                        Identisch := False;
                                                        Break;
                                                end;
                                        end;

                                        FreeMem( BOld );
                                        FreeMem( BNew );
                                end;

                                if Identisch and (UOIndexNew.Offset <> -1) and (UOIndexOld.Offset = -1) then begin
                                        Identisch := False;
                                end;

                                if not Identisch then begin
                                        Index.Lookup := IndexNew.Position - 12;
                                        Index.Length := UOIndexNew.Length;
                                        Index.Tag := UOIndexNew.Extra;
                                        Index.Typ := typ_gump;

                                        if cbME.Checked then begin
                                                TmpRecord.Offset := Index.Lookup;
                                                TmpRecord.Length := Index.Length;
                                                TmpRecord.Extra := Index.Tag;
                                                MulCrypt.EncryptIndexRecordGump( Index.Typ, TmpRecord );
                                                Index.Lookup := TmpRecord.Offset;
                                                Index.Length := TmpRecord.Length;
                                                Index.Tag := TmpRecord.Extra;
                                        end;

                                        MStream.Write( Index, sizeof( TIndex ) );

                                        if UOIndexNew.Offset <> -1 then begin
                                                DataNew.Seek( UOIndexNew.Offset, soFrombeginning );
                                                MStream.CopyFrom( DataNew, UOIndexNew.Length );
                                        end;
                                        Inc( J );
                                        if J mod 10 = 0 then
                                                Application.ProcessMessages;
                                end;
                        end;
                        DataNew.Free;
                        DataOld.Free;
                        IndexOld.Free;
                        IndexNew.Free;
                        State.Caption := '';
                        Memo.Lines.Add( inttostr( j ) + ' IDs gepatcht.' );
                end;
                //texmaps.mul
                if fn = 'texidx.mul' then begin
                        memo.Lines.Add( 'Erstelle Patch fr Texturen.' );
                        IndexNew := TFileStream.Create( listbox.Items[i], fmOpenRead );
                        IndexOld := TFileStream.Create( editUOPath.Text + 'texidx.mul', fmOpenRead );
                        J := 0;
                        K := 0;
                        IndexNew.Seek( 0, soFromBeginning );
                        IndexOld.Seek( 0, soFromBeginning );

                        DataNew := TFileStream.Create( ExtractFilePath( listbox.Items[i] ) + 'texmaps.mul', fmOpenRead );
                        DataOld := TFileStream.Create( editUOPath.Text + 'texmaps.mul', fmOpenRead );

                        while IndexNew.Position < IndexNew.Size do begin
                                if IndexOld.Position < IndexOld.Size then begin
                                        IndexOld.Read( UOIndexOld, 12 );
                                        if cbME.Checked then begin
                                                MulCrypt.DecryptIndexRecordTex( (IndexOld.Position-12) div 12, UOIndexOld );
                                        end;
                                end
                                else begin
                                        UOIndexOld.Offset := -1;
                                        UOIndexOld.Length := -1;
                                        UOIndexOld.Extra := 0;
                                end;
                                
                                IndexNew.Read( UOIndexNew, 12 );
                                if cbME.Checked then begin
                                        MulCrypt.DecryptIndexRecordTex( (IndexNew.Position-12) div 12, UOIndexNew );
                                end;
                                Inc( K );

                                if K mod 100 = 0 then begin
                                        State.Caption := Inttostr( trunc( 100 * IndexNew.Position / IndexNew.Size ) ) + '%';
                                        Application.ProcessMessages;
                                end;

                                Identisch := ( UOIndexOld.Length = UOIndexNew.Length ) and ( UOIndexOld.Extra = UOIndexNew.Extra );

                                if Identisch and (UOIndexNew.Offset <> -1) and (UOIndexOld.Offset <> -1) then begin
                                        DataOld.Seek( UOIndexOld.Offset, soFromBeginning );
                                        DataNew.Seek( UOIndexNew.Offset, soFromBeginning );

                                        GetMem( BOld, UOIndexOld.Length );
                                        GetMem( BNew, UOIndexOld.Length );

                                        DataOld.Read( BOld^, UOIndexOld.Length );
                                        DataNew.Read( BNew^, UOIndexOld.Length );

                                        for m := 0 to UOIndexOld.Length-1 do begin
                                                if BOld^[ m ] <> BNew^[ m ] then begin
                                                        Identisch := False;
                                                        Break;
                                                end;
                                        end;

                                        FreeMem( BOld );
                                        FreeMem( BNew );
                                end;

                                if Identisch and (UOIndexNew.Offset <> -1) and (UOIndexOld.Offset = -1) then begin
                                        Identisch := False;
                                end;

                                if not Identisch then begin
                                        Index.Lookup := IndexNew.Position - 12;
                                        Index.Length := UOIndexNew.Length;
                                        Index.Tag := UOIndexNew.Extra;
                                        Index.Typ := typ_tex;

                                        if cbME.Checked then begin
                                                TmpRecord.Offset := Index.Lookup;
                                                TmpRecord.Length := Index.Length;
                                                TmpRecord.Extra := Index.Tag;
                                                MulCrypt.EncryptIndexRecordTex( Index.Typ, TmpRecord );
                                                Index.Lookup := TmpRecord.Offset;
                                                Index.Length := TmpRecord.Length;
                                                Index.Tag := TmpRecord.Extra;
                                        end;

                                        MStream.Write( Index, sizeof( TIndex ) );

                                        if UOIndexNew.Offset <> -1 then begin
                                                DataNew.Seek( UOIndexNew.Offset, soFrombeginning );
                                                MStream.CopyFrom( DataNew, UOIndexNew.Length );
                                        end;
                                        Inc( J );
                                        if J mod 10 = 0 then
                                                Application.ProcessMessages;
                                end;
                        end;
                        DataNew.Free;
                        DataOld.Free;
                        IndexOld.Free;
                        IndexNew.Free;
                        State.Caption := '';
                        Memo.Lines.Add( inttostr( j ) + ' IDs gepatcht.' );
                end;
                //statics0.mul
                if fn = 'staidx0.mul' then begin
                        memo.Lines.Add( 'Erstelle Patch fr Statics.' );
                        IndexNew := TFileStream.Create( listbox.Items[i], fmOpenRead );
                        IndexOld := TFileStream.Create( editUOPath.Text + 'staidx0.mul', fmOpenRead );
                        j := 0;
                        k := 0;
                        IndexNew.Seek( 0, soFromBeginning );
                        IndexOld.Seek( 0, soFromBeginning );

                        DataNew := TFileStream.Create( ExtractFilePath( listbox.Items[i] ) + 'statics0.mul', fmOpenRead );
                        while ( IndexOld.Position < IndexOld.Size ) and ( IndexNew.Position < IndexNew.Size ) do begin
                                IndexOld.Read( UOIndexOld, sizeof( TUOIndex ) );
                                IndexNew.Read( UOIndexNew, sizeof( TUOIndex ) );
                                inc( k );

                                if k mod 100 = 0 then
                                        state.Caption := inttostr( trunc( 100 * IndexNew.Position / IndexNew.Size ) ) + '%';

                                identisch := true;
                                if ( UOIndexOld.Length <> UOIndexNew.Length ) then begin
                                                identisch := False;
                                end
                                else begin
                                        DataOld := TFileStream.Create( editUOPath.Text + 'statics0.mul', fmOpenRead );
                                        DataOld.Seek( UOIndexOld.Offset, soFromBeginning );
                                        DataNew.Seek( UOIndexNew.Offset, soFromBeginning );

                                        while DataOld.Position < UOIndexOld.Offset+UOIndexOld.Length do begin
                                                DataOld.Read( ItemOld, 7 );
                                                DataNew.Read( ItemNew, 7 );

                                                if (ItemOld.Id <> ItemNew.Id) or (ItemOld.X <> ItemNew.X) or (ItemOld.Y <> ItemNew.Y) or (ItemOld.Z <> ItemNew.Z) or (ItemOld.Color <> ItemNew.Color) then begin
                                                        identisch := False;
                                                        break;
                                                end;
                                        end;
                                        DataOld.Free;
                                end;

                                if not identisch then begin //or ( UOIndexOld.Extra <> UOIndexNew.Extra ) then begin
                                        Index.Lookup := IndexNew.Position - 12;
                                        Index.Length := UOIndexNew.Length;
                                        Index.Tag := UOIndexNew.Extra;
                                        Index.Typ := typ_static;
                                        MStream.Write( Index, sizeof( TIndex ) );

                                        if UOIndexNew.Offset <> -1 then begin
                                                DataNew.Seek( UOIndexNew.Offset, soFrombeginning );
                                                GetMem( buf, UOIndexNew.Length );
                                                DataNew.Read( buf^, UOIndexNew.Length );
                                                MStream.Write( buf^, UOIndexNew.Length );
                                                FreeMem( buf, UOIndexNew.Length );
                                        end;
                                        inc( j );
                                        //if j > 100 then break;
                                end;

                                if k mod 1000 = 0 then
                                        Application.ProcessMessages;
                        end;
                        DataNew.Free;
                        IndexOld.Free;
                        IndexNew.Free;
                        state.caption := '';
                        memo.lines.Add( inttostr( j ) + ' IDs gepatcht.' );
                end;
                //statics2.mul
                if fn = 'staidx2.mul' then begin
                        memo.Lines.Add( 'Erstelle Patch fr Statics2.' );
                        IndexNew := TFileStream.Create( listbox.Items[i], fmOpenRead );
                        IndexOld := TFileStream.Create( editUOPath.Text + 'staidx2.mul', fmOpenRead );
                        j := 0;
                        k := 0;
                        IndexNew.Seek( 0, soFromBeginning );
                        IndexOld.Seek( 0, soFromBeginning );

                        DataNew := TFileStream.Create( ExtractFilePath( listbox.Items[i] ) + 'statics2.mul', fmOpenRead );
                        while ( IndexOld.Position < IndexOld.Size ) and ( IndexNew.Position < IndexNew.Size ) do begin
                                IndexOld.Read( UOIndexOld, sizeof( TUOIndex ) );
                                IndexNew.Read( UOIndexNew, sizeof( TUOIndex ) );
                                inc( k );

                                if k mod 100 = 0 then
                                        state.Caption := inttostr( trunc( 100 * IndexNew.Position / IndexNew.Size ) ) + '%';

                                identisch := true;
                                if ( UOIndexOld.Length <> UOIndexNew.Length ) then begin
                                                identisch := False;
                                end
                                else begin
                                        DataOld := TFileStream.Create( editUOPath.Text + 'statics2.mul', fmOpenRead );
                                        DataOld.Seek( UOIndexOld.Offset, soFromBeginning );
                                        DataNew.Seek( UOIndexNew.Offset, soFromBeginning );

                                        while DataOld.Position < UOIndexOld.Offset+UOIndexOld.Length do begin
                                                DataOld.Read( ItemOld, 7 );
                                                DataNew.Read( ItemNew, 7 );

                                                if (ItemOld.Id <> ItemNew.Id) or (ItemOld.X <> ItemNew.X) or (ItemOld.Y <> ItemNew.Y) or (ItemOld.Z <> ItemNew.Z) or (ItemOld.Color <> ItemNew.Color) then begin
                                                        identisch := False;
                                                        break;
                                                end;
                                        end;
                                        DataOld.Free;
                                end;

                                if not identisch then begin //or ( UOIndexOld.Extra <> UOIndexNew.Extra ) then begin
                                        Index.Lookup := IndexNew.Position - 12;
                                        Index.Length := UOIndexNew.Length;
                                        Index.Tag := UOIndexNew.Extra;
                                        Index.Typ := typ_static2;
                                        MStream.Write( Index, sizeof( TIndex ) );

                                        if UOIndexNew.Offset <> -1 then begin
                                                DataNew.Seek( UOIndexNew.Offset, soFrombeginning );
                                                GetMem( buf, UOIndexNew.Length );
                                                DataNew.Read( buf^, UOIndexNew.Length );
                                                MStream.Write( buf^, UOIndexNew.Length );
                                                FreeMem( buf, UOIndexNew.Length );
                                        end;
                                        inc( j );
                                        //if j > 100 then break;
                                end;

                                if k mod 1000 = 0 then
                                        Application.ProcessMessages;
                        end;
                        DataNew.Free;
                        IndexOld.Free;
                        IndexNew.Free;
                        state.caption := '';
                        memo.lines.Add( inttostr( j ) + ' IDs gepatcht.' );
                end;
                //statics3.mul
                if fn = 'staidx3.mul' then begin
                        memo.Lines.Add( 'Erstelle Patch fr Statics3.' );
                        IndexNew := TFileStream.Create( listbox.Items[i], fmOpenRead );
                        IndexOld := TFileStream.Create( editUOPath.Text + 'staidx3.mul', fmOpenRead );
                        j := 0;
                        k := 0;
                        IndexNew.Seek( 0, soFromBeginning );
                        IndexOld.Seek( 0, soFromBeginning );

                        DataNew := TFileStream.Create( ExtractFilePath( listbox.Items[i] ) + 'statics3.mul', fmOpenRead );
                        while ( IndexOld.Position < IndexOld.Size ) and ( IndexNew.Position < IndexNew.Size ) do begin
                                IndexOld.Read( UOIndexOld, sizeof( TUOIndex ) );
                                IndexNew.Read( UOIndexNew, sizeof( TUOIndex ) );
                                inc( k );

                                if k mod 100 = 0 then
                                        state.Caption := inttostr( trunc( 100 * IndexNew.Position / IndexNew.Size ) ) + '%';

                                identisch := true;
                                if ( UOIndexOld.Length <> UOIndexNew.Length ) then begin
                                                identisch := False;
                                end
                                else begin
                                        DataOld := TFileStream.Create( editUOPath.Text + 'statics3.mul', fmOpenRead );
                                        DataOld.Seek( UOIndexOld.Offset, soFromBeginning );
                                        DataNew.Seek( UOIndexNew.Offset, soFromBeginning );

                                        while DataOld.Position < UOIndexOld.Offset+UOIndexOld.Length do begin
                                                DataOld.Read( ItemOld, 7 );
                                                DataNew.Read( ItemNew, 7 );

                                                if (ItemOld.Id <> ItemNew.Id) or (ItemOld.X <> ItemNew.X) or (ItemOld.Y <> ItemNew.Y) or (ItemOld.Z <> ItemNew.Z) or (ItemOld.Color <> ItemNew.Color) then begin
                                                        identisch := False;
                                                        break;
                                                end;
                                        end;
                                        DataOld.Free;
                                end;

                                if not identisch then begin //or ( UOIndexOld.Extra <> UOIndexNew.Extra ) then begin
                                        Index.Lookup := IndexNew.Position - 12;
                                        Index.Length := UOIndexNew.Length;
                                        Index.Tag := UOIndexNew.Extra;
                                        Index.Typ := typ_static3;
                                        MStream.Write( Index, sizeof( TIndex ) );

                                        if UOIndexNew.Offset <> -1 then begin
                                                DataNew.Seek( UOIndexNew.Offset, soFrombeginning );
                                                GetMem( buf, UOIndexNew.Length );
                                                DataNew.Read( buf^, UOIndexNew.Length );
                                                MStream.Write( buf^, UOIndexNew.Length );
                                                FreeMem( buf, UOIndexNew.Length );
                                        end;
                                        inc( j );
                                        //if j > 100 then break;
                                end;

                                if k mod 1000 = 0 then
                                        Application.ProcessMessages;
                        end;
                        DataNew.Free;
                        IndexOld.Free;
                        IndexNew.Free;
                        state.caption := '';
                        memo.lines.Add( inttostr( j ) + ' IDs gepatcht.' );
                end;
                //statics4.mul
                if fn = 'staidx4.mul' then begin
                        memo.Lines.Add( 'Erstelle Patch fr Statics4.' );
                        IndexNew := TFileStream.Create( listbox.Items[i], fmOpenRead );
                        IndexOld := TFileStream.Create( editUOPath.Text + 'staidx4.mul', fmOpenRead );
                        j := 0;
                        k := 0;
                        IndexNew.Seek( 0, soFromBeginning );
                        IndexOld.Seek( 0, soFromBeginning );

                        DataNew := TFileStream.Create( ExtractFilePath( listbox.Items[i] ) + 'statics4.mul', fmOpenRead );
                        while ( IndexOld.Position < IndexOld.Size ) and ( IndexNew.Position < IndexNew.Size ) do begin
                                IndexOld.Read( UOIndexOld, sizeof( TUOIndex ) );
                                IndexNew.Read( UOIndexNew, sizeof( TUOIndex ) );
                                inc( k );

                                if k mod 100 = 0 then
                                        state.Caption := inttostr( trunc( 100 * IndexNew.Position / IndexNew.Size ) ) + '%';

                                identisch := true;
                                if ( UOIndexOld.Length <> UOIndexNew.Length ) then begin
                                                identisch := False;
                                end
                                else begin
                                        DataOld := TFileStream.Create( editUOPath.Text + 'statics4.mul', fmOpenRead );
                                        DataOld.Seek( UOIndexOld.Offset, soFromBeginning );
                                        DataNew.Seek( UOIndexNew.Offset, soFromBeginning );

                                        while DataOld.Position < UOIndexOld.Offset+UOIndexOld.Length do begin
                                                DataOld.Read( ItemOld, 7 );
                                                DataNew.Read( ItemNew, 7 );

                                                if (ItemOld.Id <> ItemNew.Id) or (ItemOld.X <> ItemNew.X) or (ItemOld.Y <> ItemNew.Y) or (ItemOld.Z <> ItemNew.Z) or (ItemOld.Color <> ItemNew.Color) then begin
                                                        identisch := False;
                                                        break;
                                                end;
                                        end;
                                        DataOld.Free;
                                end;

                                if not identisch then begin //or ( UOIndexOld.Extra <> UOIndexNew.Extra ) then begin
                                        Index.Lookup := IndexNew.Position - 12;
                                        Index.Length := UOIndexNew.Length;
                                        Index.Tag := UOIndexNew.Extra;
                                        Index.Typ := typ_static4;
                                        MStream.Write( Index, sizeof( TIndex ) );

                                        if UOIndexNew.Offset <> -1 then begin
                                                DataNew.Seek( UOIndexNew.Offset, soFrombeginning );
                                                GetMem( buf, UOIndexNew.Length );
                                                DataNew.Read( buf^, UOIndexNew.Length );
                                                MStream.Write( buf^, UOIndexNew.Length );
                                                FreeMem( buf, UOIndexNew.Length );
                                        end;
                                        inc( j );
                                        //if j > 100 then break;
                                end;

                                if k mod 1000 = 0 then
                                        Application.ProcessMessages;
                        end;
                        DataNew.Free;
                        IndexOld.Free;
                        IndexNew.Free;
                        state.caption := '';
                        memo.lines.Add( inttostr( j ) + ' IDs gepatcht.' );
                end;
                //anim.mul
                if fn = 'anim.idx' then begin
                        memo.Lines.Add( 'Erstelle Patch fr Anims.' );
                        IndexNew := TFileStream.Create( listbox.Items[i], fmOpenRead );
                        IndexOld := TFileStream.Create( editUOPath.Text + 'anim.idx', fmOpenRead );
                        J := 0;
                        K := 0;
                        IndexNew.Seek( 0, soFromBeginning );
                        IndexOld.Seek( 0, soFromBeginning );

                        DataNew := TFileStream.Create( ExtractFilePath( listbox.Items[i] ) + 'anim.mul', fmOpenRead );
                        DataOld := TFileStream.Create( editUOPath.Text + 'anim.mul', fmOpenRead );

                        while IndexNew.Position < IndexNew.Size do begin
                                if IndexOld.Position < IndexOld.Size then begin
                                        IndexOld.Read( UOIndexOld, 12 );
                                        if cbME.Checked then begin
                                                MulCrypt.DecryptIndexRecordAnim( (IndexOld.Position-12) div 12, UOIndexOld );
                                        end;
                                end
                                else begin
                                        UOIndexOld.Offset := -1;
                                        UOIndexOld.Length := -1;
                                        UOIndexOld.Extra := 0;
                                end;
                                
                                IndexNew.Read( UOIndexNew, 12 );
                                if cbME.Checked then begin
                                        MulCrypt.DecryptIndexRecordAnim( (IndexNew.Position-12) div 12, UOIndexNew );
                                end;
                                Inc( K );

                                if K mod 100 = 0 then begin
                                        State.Caption := Inttostr( trunc( 100 * IndexNew.Position / IndexNew.Size ) ) + '%';
                                        Application.ProcessMessages;
                                end;

                                Identisch := ( UOIndexOld.Length = UOIndexNew.Length ) and ( UOIndexOld.Extra = UOIndexNew.Extra );

                                if Identisch and (UOIndexNew.Offset <> -1) and (UOIndexOld.Offset <> -1) then begin
                                        DataOld.Seek( UOIndexOld.Offset, soFromBeginning );
                                        DataNew.Seek( UOIndexNew.Offset, soFromBeginning );

                                        GetMem( BOld, UOIndexOld.Length );
                                        GetMem( BNew, UOIndexOld.Length );

                                        DataOld.Read( BOld^, UOIndexOld.Length );
                                        DataNew.Read( BNew^, UOIndexOld.Length );

                                        for m := 0 to UOIndexOld.Length-1 do begin
                                                if BOld^[ m ] <> BNew^[ m ] then begin
                                                        Identisch := False;
                                                        Break;
                                                end;
                                        end;

                                        FreeMem( BOld );
                                        FreeMem( BNew );
                                end;

                                if Identisch and (UOIndexNew.Offset <> -1) and (UOIndexOld.Offset = -1) then begin
                                        Identisch := False;
                                end;

                                if not Identisch then begin
                                        Index.Lookup := IndexNew.Position - 12;
                                        Index.Length := UOIndexNew.Length;
                                        Index.Tag := UOIndexNew.Extra;
                                        Index.Typ := typ_anim;

                                        if cbME.Checked then begin
                                                TmpRecord.Offset := Index.Lookup;
                                                TmpRecord.Length := Index.Length;
                                                TmpRecord.Extra := Index.Tag;
                                                MulCrypt.EncryptIndexRecordAnim( Index.Typ, TmpRecord );
                                                Index.Lookup := TmpRecord.Offset;
                                                Index.Length := TmpRecord.Length;
                                                Index.Tag := TmpRecord.Extra;
                                        end;

                                        MStream.Write( Index, sizeof( TIndex ) );

                                        if (UOIndexNew.Offset <> -1) and (UOIndexNew.Length > 0) then begin
                                                DataNew.Seek( UOIndexNew.Offset, soFrombeginning );
                                                MStream.CopyFrom( DataNew, UOIndexNew.Length );
                                        end;
                                        Inc( J );
                                        if J mod 10 = 0 then
                                                Application.ProcessMessages;
                                end;
                        end;
                        DataNew.Free;
                        DataOld.Free;
                        IndexOld.Free;
                        IndexNew.Free;
                        State.Caption := '';
                        Memo.Lines.Add( inttostr( j ) + ' IDs gepatcht.' );
                end;
                //anim2.mul
                if fn = 'anim2.idx' then begin
                        memo.Lines.Add( 'Erstelle Patch fr Anims2.' );
                        IndexNew := TFileStream.Create( listbox.Items[i], fmOpenRead );
                        IndexOld := TFileStream.Create( editUOPath.Text + 'anim2.idx', fmOpenRead );
                        j := 0;
                        k := 0;
                        IndexNew.Seek( 0, soFromBeginning );
                        IndexOld.Seek( 0, soFromBeginning );

                        DataNew := TFileStream.Create( ExtractFilePath( listbox.Items[i] ) + 'anim2.mul', fmOpenRead );
                        while ( IndexNew.Position < IndexNew.Size ) do begin
                                if IndexNew.Position < IndexOld.Size then begin
                                        IndexOld.Read( UOIndexOld, sizeof( TUOIndex ) );
                                end
                                else begin
                                        UOIndexOld.Offset := -1;
                                        UOIndexOld.Length := -1;
                                        UOIndexOld.Extra := -1;
                                end;
                                IndexNew.Read( UOIndexNew, sizeof( TUOIndex ) );
                                inc( k );

                                if k mod 100 = 0 then
                                        state.Caption := inttostr( trunc( IndexNew.Position * ( 100 / IndexNew.Size ) ) ) + '%';

                                if ( UOIndexOld.Length <> UOIndexNew.Length ) then begin
                                        Index.Lookup := IndexNew.Position - 12;
                                        Index.Length := UOIndexNew.Length;
                                        Index.Tag := UOIndexNew.Extra;
                                        Index.Typ := typ_anim2;
                                        MStream.Write( Index, sizeof( TIndex ) );

                                        if UOIndexNew.Offset <> -1 then begin
                                                DataNew.Seek( UOIndexNew.Offset, soFromBeginning );
                                                GetMem( buf, UOIndexNew.Length );
                                                DataNew.Read( buf^, UOIndexNew.Length );
                                                MStream.Write( buf^, UOIndexNew.Length );
                                                FreeMem( buf, UOIndexNew.Length );
                                        end;
                                        inc( j );
                                        if j mod 10 = 0 then
                                                Application.ProcessMessages;
                                        //if j > 100 then break;
                                end;
                        end;
                        DataNew.Free;
                        IndexOld.Free;
                        IndexNew.Free;
                        state.caption := '';
                        memo.lines.Add( inttostr( j ) + ' IDs gepatcht.' );
                end;
                //anim3.mul
                if fn = 'anim3.idx' then begin
                        memo.Lines.Add( 'Erstelle Patch fr Anims3.' );
                        IndexNew := TFileStream.Create( listbox.Items[i], fmOpenRead );
                        IndexOld := TFileStream.Create( editUOPath.Text + 'anim3.idx', fmOpenRead );
                        j := 0;
                        k := 0;
                        IndexNew.Seek( 0, soFromBeginning );
                        IndexOld.Seek( 0, soFromBeginning );

                        DataNew := TFileStream.Create( ExtractFilePath( listbox.Items[i] ) + 'anim3.mul', fmOpenRead );
                        while ( IndexNew.Position < IndexNew.Size ) do begin
                                if IndexNew.Position < IndexOld.Size then begin
                                        IndexOld.Read( UOIndexOld, sizeof( TUOIndex ) );
                                end
                                else begin
                                        UOIndexOld.Offset := -1;
                                        UOIndexOld.Length := -1;
                                        UOIndexOld.Extra := -1;
                                end;
                                IndexNew.Read( UOIndexNew, sizeof( TUOIndex ) );
                                inc( k );

                                if k mod 100 = 0 then
                                        state.Caption := inttostr( trunc( IndexNew.Position * ( 100 / IndexNew.Size ) ) ) + '%';

                                if ( UOIndexOld.Length <> UOIndexNew.Length ) then begin
                                        Index.Lookup := IndexNew.Position - 12;
                                        Index.Length := UOIndexNew.Length;
                                        Index.Tag := UOIndexNew.Extra;
                                        Index.Typ := typ_anim3;
                                        MStream.Write( Index, sizeof( TIndex ) );

                                        if UOIndexNew.Offset <> -1 then begin
                                                DataNew.Seek( UOIndexNew.Offset, soFromBeginning );
                                                GetMem( buf, UOIndexNew.Length );
                                                DataNew.Read( buf^, UOIndexNew.Length );
                                                MStream.Write( buf^, UOIndexNew.Length );
                                                FreeMem( buf, UOIndexNew.Length );
                                        end;
                                        inc( j );
                                        if j mod 10 = 0 then
                                                Application.ProcessMessages;
                                        //if j > 100 then break;
                                end;
                        end;
                        DataNew.Free;
                        IndexOld.Free;
                        IndexNew.Free;
                        state.caption := '';
                        memo.lines.Add( inttostr( j ) + ' IDs gepatcht.' );
                end;
                //anim4.mul
                if fn = 'anim4.idx' then begin
                        memo.Lines.Add( 'Erstelle Patch fr Anims4.' );
                        IndexNew := TFileStream.Create( listbox.Items[i], fmOpenRead );
                        IndexOld := TFileStream.Create( editUOPath.Text + 'anim4.idx', fmOpenRead );
                        j := 0;
                        k := 0;
                        IndexNew.Seek( 0, soFromBeginning );
                        IndexOld.Seek( 0, soFromBeginning );

                        DataNew := TFileStream.Create( ExtractFilePath( listbox.Items[i] ) + 'anim4.mul', fmOpenRead );
                        while ( IndexNew.Position < IndexNew.Size ) do begin
                                if IndexNew.Position < IndexOld.Size then begin
                                        IndexOld.Read( UOIndexOld, sizeof( TUOIndex ) );
                                end
                                else begin
                                        UOIndexOld.Offset := -1;
                                        UOIndexOld.Length := -1;
                                        UOIndexOld.Extra := -1;
                                end;
                                IndexNew.Read( UOIndexNew, sizeof( TUOIndex ) );
                                inc( k );

                                if k mod 100 = 0 then
                                        state.Caption := inttostr( trunc( IndexNew.Position * ( 100 / IndexNew.Size ) ) ) + '%';

                                if ( UOIndexOld.Length <> UOIndexNew.Length ) then begin
                                        Index.Lookup := IndexNew.Position - 12;
                                        Index.Length := UOIndexNew.Length;
                                        Index.Tag := UOIndexNew.Extra;
                                        Index.Typ := typ_anim4;
                                        MStream.Write( Index, sizeof( TIndex ) );

                                        if UOIndexNew.Offset <> -1 then begin
                                                DataNew.Seek( UOIndexNew.Offset, soFromBeginning );
                                                GetMem( buf, UOIndexNew.Length );
                                                DataNew.Read( buf^, UOIndexNew.Length );
                                                MStream.Write( buf^, UOIndexNew.Length );
                                                FreeMem( buf, UOIndexNew.Length );
                                        end;
                                        inc( j );
                                        if j mod 10 = 0 then
                                                Application.ProcessMessages;
                                        //if j > 100 then break;
                                end;
                        end;
                        DataNew.Free;
                        IndexOld.Free;
                        IndexNew.Free;
                        state.caption := '';
                        memo.lines.Add( inttostr( j ) + ' IDs gepatcht.' );
                end;
                //anim5.mul
                if fn = 'anim5.idx' then begin
                        memo.Lines.Add( 'Erstelle Patch fr Anims5.' );
                        IndexNew := TFileStream.Create( listbox.Items[i], fmOpenRead );
                        IndexOld := TFileStream.Create( editUOPath.Text + 'anim5.idx', fmOpenRead );
                        j := 0;
                        k := 0;
                        IndexNew.Seek( 0, soFromBeginning );
                        IndexOld.Seek( 0, soFromBeginning );

                        DataNew := TFileStream.Create( ExtractFilePath( listbox.Items[i] ) + 'anim5.mul', fmOpenRead );
                        while ( IndexOld.Position < IndexOld.Size ) and ( IndexNew.Position < IndexNew.Size ) do begin
                                IndexOld.Read( UOIndexOld, sizeof( TUOIndex ) );
                                IndexNew.Read( UOIndexNew, sizeof( TUOIndex ) );
                                inc( k );

                                if k mod 100 = 0 then
                                        state.Caption := inttostr( trunc( IndexNew.Position * ( 100 / IndexNew.Size ) ) ) + '%';

                                if ( UOIndexOld.Length <> UOIndexNew.Length ) then begin
                                        Index.Lookup := IndexNew.Position - 12;
                                        Index.Length := UOIndexNew.Length;
                                        Index.Tag := UOIndexNew.Extra;
                                        Index.Typ := typ_anim5;
                                        MStream.Write( Index, sizeof( TIndex ) );

                                        if UOIndexNew.Offset <> -1 then begin
                                                DataNew.Seek( UOIndexNew.Offset, soFromBeginning );
                                                GetMem( buf, UOIndexNew.Length );
                                                DataNew.Read( buf^, UOIndexNew.Length );
                                                MStream.Write( buf^, UOIndexNew.Length );
                                                FreeMem( buf, UOIndexNew.Length );
                                        end;
                                        inc( j );
                                        if j mod 10 = 0 then
                                                Application.ProcessMessages;
                                        //if j > 100 then break;
                                end;
                        end;
                        DataNew.Free;
                        IndexOld.Free;
                        IndexNew.Free;
                        state.caption := '';
                        memo.lines.Add( inttostr( j ) + ' IDs gepatcht.' );
                end;
                //sound.mul
                if fn = 'soundidx.mul' then begin
                        memo.Lines.Add( 'Erstelle Patch fr Sounds.' );
                        IndexNew := TFileStream.Create( listbox.Items[i], fmOpenRead );
                        IndexOld := TFileStream.Create( editUOPath.Text + 'soundidx.mul', fmOpenRead );
                        j := 0;
                        k := 0;
                        IndexNew.Seek( 0, soFromBeginning );
                        IndexOld.Seek( 0, soFromBeginning );

                        DataNew := TFileStream.Create( ExtractFilePath( listbox.Items[i] ) + 'sound.mul', fmOpenRead );
                        while ( IndexOld.Position < IndexOld.Size ) and ( IndexNew.Position < IndexNew.Size ) do begin
                                IndexOld.Read( UOIndexOld, sizeof( TUOIndex ) );
                                IndexNew.Read( UOIndexNew, sizeof( TUOIndex ) );
                                inc( k );

                                if k mod 100 = 0 then
                                        state.Caption := inttostr( trunc( 100 * IndexNew.Position / IndexNew.Size ) ) + '%';

                                if ( UOIndexOld.Length <> UOIndexNew.Length ) or ( UOIndexOld.Extra <> UOIndexNew.Extra ) then begin
                                        //Bugfix fr fehler im patcher:
                                        if ( UOIndexOld.Offset <> -1 ) or ( UOIndexNew.Offset <> -1 ) then begin
                                                Index.Lookup := IndexNew.Position - 12;
                                                Index.Length := UOIndexNew.Length;
                                                Index.Tag := UOIndexNew.Extra;
                                                Index.Typ := typ_sound;
                                                MStream.Write( Index, sizeof( TIndex ) );

                                                if (UOIndexNew.Offset <> -1) and (UOIndexNew.Length <> -1) then begin
                                                        DataNew.Seek( UOIndexNew.Offset, soFrombeginning );
                                                        GetMem( buf, UOIndexNew.Length );
                                                        DataNew.Read( buf^, UOIndexNew.Length );
                                                        MStream.Write( buf^, UOIndexNew.Length );
                                                        FreeMem( buf, UOIndexNew.Length );
                                                end;
                                                inc( j );
                                                if j mod 10 = 0 then
                                                        Application.ProcessMessages;
                                                //if j > 100 then break;
                                        end;
                                end;
                        end;
                        DataNew.Free;
                        IndexOld.Free;
                        IndexNew.Free;
                        state.caption := '';
                        memo.lines.Add( inttostr( j ) + ' IDs gepatcht.' );
                end;
                //Radarcol
                if fn = 'radarcol.mul' then begin
                        memo.Lines.Add( 'Erstelle Patch fr Radarcol.' );
                        IndexNew := TFileStream.Create( listbox.Items[i], fmOpenRead );
                        IndexOld := TFileStream.Create( editUOPath.Text + 'radarcol.mul', fmOpenRead );
                        j := 0;
                        IndexNew.Seek( 0, soFromBeginning );
                        IndexOld.Seek( 0, soFromBeginning );

                        Index.Lookup := MStream.Position + sizeof( TIndex );
                        Index.Length := IndexNew.Size;
                        Index.Tag := 0;
                        Index.Typ := typ_radarcol;
                        MStream.Write( Index, sizeof( TIndex ) );

                        while ( IndexNew.Position < IndexNew.Size ) and ( IndexOld.Position < IndexOld.Size ) do begin
                                IndexOld.Read( ColorOld, 2 );
                                IndexNew.Read( ColorNew, 2 );

                                if ColorOld <> ColorNew then
                                        inc( j )
                                else
                                        ColorNew := 0;

                                MStream.Write( ColorNew, 2 );

                                state.Caption := inttostr( trunc( 100 * IndexNew.Position / IndexNew.Size ) ) + '%';
                                Application.ProcessMessages;
                        end;
                        IndexOld.Free;
                        IndexNew.Free;
                        state.caption := '';
                        memo.lines.Add( inttostr( j ) + ' Colors gepatcht.' );
                end;
                //Tiledata
                if fn = 'tiledata.mul' then begin
                        memo.Lines.Add( 'Erstelle Patch fr Tiledata.' );
                        IndexNew := TFileStream.Create( listbox.Items[i], fmOpenRead );
                        IndexOld := TFileStream.Create( editUOPath.Text + 'tiledata.mul', fmOpenRead );
                        j := 0;
                        IndexNew.Seek( 0, soFromBeginning );
                        IndexOld.Seek( 0, soFromBeginning );

                        Count := ( ( IndexNew.Size - 512 * ( 32 * sizeof( TLandTile ) + 4 ) ) div ( 32*sizeof( TStaticTile ) + 4 ) );

                        Index.Lookup := MStream.Position + sizeof( TIndex );
                        Index.Length := 512 * 32 * sizeof( TLandTile ) + Count* 32 * sizeof( TStaticTile );
                        Index.Tag := 0;
                        Index.Typ := typ_tiledata_variabel;
                        MStream.Write( Index, sizeof( TIndex ) );

                        for l := 1 to 512 do begin
                                IndexOld.Read( Offset, 4 );
                                IndexNew.Read( Offset, 4 );

                                for k := 1 to 32 do begin
                                        IndexOld.Read( LandTileOld, 26 );
                                        IndexNew.Read( LandTileNew, 26 );

                                        NameOld := LandTileOld.Name;
                                        NameNew := LandTileNew.Name;
                                        if ( LandTileOld.Flags <> LandTileNew.Flags ) or ( LandTileOld.TexID <> LandTileNew.TexID ) or ( NameOld <> NameNew ) then begin
                                                inc( j );
                                        end
                                        else begin
                                                LandTileNew.Flags := 0;
                                                LandTileNew.TexID := 0;
                                                lstrcpy( LandTileNew.Name, PChar( '' ) );
                                        end;
                                        MStream.Write( LandTileNew, 26 );
                                end;
                                state.Caption := inttostr( trunc( 100 * IndexNew.Position / IndexNew.Size ) ) + '%';
                                Application.ProcessMessages;
                        end;
                        
                        MStream.Write( Count, 4 );
                        for l := 1 to Count do begin
                                if IndexOld.Position+3 < IndexOld.Size then
                                        IndexOld.Read( Offset, 4 );
                                IndexNew.Read( Offset, 4 );

                                for k := 1 to 32 do begin
                                        if IndexOld.Position+36 < IndexOld.Size then
                                                IndexOld.Read( StaticTileOld, 37 )
                                        else begin
                                                StaticTileOld.Flags := 0;
                                                StaticTileOld.Weight := 0;
                                                StaticTileOld.Quality := 0;
                                                StaticTileOld.Unknown := 0;
                                                StaticTileOld.Unknown2 := 0;
                                                StaticTileOld.Quantity := 0;
                                                StaticTileOld.AnimID := 0;
                                                StaticTileOld.Unknown3 := 0;
                                                StaticTileOld.Hue := 0;
                                                StaticTileOld.Unknown4 := 0;
                                                StaticTileOld.Unknown5 := 0;
                                                StaticTileOld.Height := 0;
                                                lstrcpy( StaticTileOld.Name, PChar( '' ) );
                                        end;
                                        IndexNew.Read( StaticTileNew, 37 );

                                        NameOld := StaticTileOld.Name;
                                        NameNew := StaticTileNew.Name;

                                        if ( StaticTileOld.Flags <> StaticTileNew.Flags ) or ( NameOld <> NameNew ) or ( StaticTileOld.Weight <> StaticTileNew.Weight ) or ( StaticTileOld.Quality <> StaticTileNew.Quality ) or ( StaticTileOld.Quantity <> StaticTileNew.Quantity ) or ( StaticTileOld.AnimID <> StaticTileNew.AnimID ) or ( StaticTileOld.Hue <> StaticTileNew.Hue ) or ( StaticTileOld.Height <> StaticTileNew.Height ) or ( StaticTileOld.Unknown <> StaticTileNew.Unknown ) or ( StaticTileOld.Unknown2 <> StaticTileNew.Unknown2 ) or ( StaticTileOld.Unknown3 <> StaticTileNew.Unknown3 ) or ( StaticTileOld.Unknown4 <> StaticTileNew.Unknown4 ) or ( StaticTileOld.Unknown5 <> StaticTileNew.Unknown5 ) then begin
                                                inc( j );
                                        end
                                        else begin
                                                StaticTileNew.Flags := 0;
                                                StaticTileNew.Weight := 0;
                                                StaticTileNew.Quality := 0;
                                                StaticTileNew.Unknown := 0;
                                                StaticTileNew.Unknown2 := 0;
                                                StaticTileNew.Quantity := 0;
                                                StaticTileNew.AnimID := 0;
                                                StaticTileNew.Unknown3 := 0;
                                                StaticTileNew.Hue := 0;
                                                StaticTileNew.Unknown4 := 0;
                                                StaticTileNew.Unknown5 := 0;
                                                StaticTileNew.Height := 0;
                                                lstrcpy( StaticTileNew.Name, PChar( '' ) );
                                        end;
                                        MStream.Write( StaticTileNew , 37 );
                                end;
                                state.Caption := inttostr( trunc( 100 * IndexNew.Position / IndexNew.Size ) ) + '%';
                                Application.ProcessMessages;
                        end;

                        IndexOld.Free;
                        IndexNew.Free;
                        state.caption := '';
                        memo.lines.Add( inttostr( j ) + ' Tiles gepatcht.' );
                end;
                //Map
                if fn = 'map0.mul' then begin
                        memo.Lines.Add( 'Erstelle Patch fr Map.' );
                        IndexNew := TFileStream.Create( listbox.Items[i], fmOpenRead );
                        IndexOld := TFileStream.Create( editUOPath.Text + 'map0.mul', fmOpenRead );
                        j := 0;
                        IndexNew.Seek( 0, soFromBeginning );
                        IndexOld.Seek( 0, soFromBeginning );

                        if (IndexOld.Size = 768*512*(64*3+4)) and (IndexNew.Size = 768*512*(64*3+4)) then begin
                                Index.Lookup := MStream.Position + sizeof( TIndex );
                                Index.Length := 768*512*64*3;
                                Index.Tag := 0;
                                Index.Typ := typ_map;
                                MStream.Write( Index, sizeof( TIndex ) );

                                for l := 1 to 768*512 do begin
                                        IndexOld.Read( Offset, 4 );
                                        IndexNew.Read( Offset, 4 );

                                        for k := 0 to 63 do begin
                                                IndexOld.Read( MapTileOld, sizeof( TMapTile ) );
                                                IndexNew.Read( MapTileNew, sizeof( TMapTile ) );

                                                if ( MapTileOld.Tile <> MapTileNew.Tile ) or ( MapTileOld.Hoehe <> MapTileNew.Hoehe ) then
                                                        inc( j )
                                                else begin
                                                        MapTileNew.Tile := 0;
                                                        MapTileNew.Hoehe := 0;
                                                end;
                                                MStream.Write( MapTileNew , sizeof( TMapTile ) );
                                        end;
                                        state.Caption := inttostr( trunc( 100 * IndexNew.Position / IndexNew.Size ) ) + '%';
                                        Application.ProcessMessages;
                                end;
                        end
                        else begin
                                Count := IndexNew.Size div (64*3+4);

                                Index.Lookup := MStream.Position + sizeof( TIndex );
                                Index.Length := Count*64*3;
                                Index.Tag := 0;
                                Index.Typ := typ_map_variabel;
                                MStream.Write( Index, sizeof( TIndex ) );

                                for l := 1 to Count do begin
                                        if IndexOld.Position + 64*3+4 < IndexOld.Size then begin
                                                IndexOld.Read( Offset, 4 );
                                                IndexNew.Read( Offset, 4 );

                                                for k := 0 to 63 do begin
                                                        IndexOld.Read( MapTileOld, sizeof( TMapTile ) );
                                                        IndexNew.Read( MapTileNew, sizeof( TMapTile ) );

                                                        if ( MapTileOld.Tile <> MapTileNew.Tile ) or ( MapTileOld.Hoehe <> MapTileNew.Hoehe ) then
                                                                inc( j )
                                                        else begin
                                                                MapTileNew.Tile := 0;
                                                                MapTileNew.Hoehe := 0;
                                                        end;
                                                        MStream.Write( MapTileNew , sizeof( TMapTile ) );
                                                end;
                                        end
                                        else begin
                                                IndexNew.Read( Offset, 4 );

                                                for k := 0 to 63 do begin
                                                        IndexNew.Read( MapTileNew, sizeof( TMapTile ) );
                                                        MStream.Write( MapTileNew , sizeof( TMapTile ) );
                                                        
                                                        Inc( j );
                                                end;
                                        end;

                                        state.Caption := inttostr( trunc( 100 * IndexNew.Position / IndexNew.Size ) ) + '%';
                                        Application.ProcessMessages;
                                end;

                        end;
                        IndexOld.Free;
                        IndexNew.Free;
                        state.caption := '';
                        memo.lines.Add( inttostr( j ) + ' Tiles gepatcht.' );
                end;
                //Map2
                if fn = 'map2.mul' then begin
                        memo.Lines.Add( 'Erstelle Patch fr Map2.' );
                        IndexNew := TFileStream.Create( listbox.Items[i], fmOpenRead );
                        IndexOld := TFileStream.Create( editUOPath.Text + 'map2.mul', fmOpenRead );
                        j := 0;
                        IndexNew.Seek( 0, soFromBeginning );
                        IndexOld.Seek( 0, soFromBeginning );

                        Index.Lookup := MStream.Position + sizeof( TIndex );
                        Index.Length := 288*200*64*3;
                        Index.Tag := 0;
                        Index.Typ := typ_map2;
                        MStream.Write( Index, sizeof( TIndex ) );

                        for l := 1 to 288*200 do begin
                                IndexOld.Read( Offset, 4 );
                                IndexNew.Read( Offset, 4 );

                                for k := 0 to 63 do begin
                                        IndexOld.Read( MapTileOld, sizeof( TMapTile ) );
                                        IndexNew.Read( MapTileNew, sizeof( TMapTile ) );

                                        if ( MapTileOld.Tile <> MapTileNew.Tile ) or ( MapTileOld.Hoehe <> MapTileNew.Hoehe ) then
                                                inc( j )
                                        else begin
                                                MapTileNew.Tile := 0;
                                                MapTileNew.Hoehe := 0;
                                                end;
                                        MStream.Write( MapTileNew , sizeof( TMapTile ) );
                                end;
                                state.Caption := inttostr( trunc( 100 * IndexNew.Position / IndexNew.Size ) ) + '%';
                                Application.ProcessMessages;
                        end;
                        IndexOld.Free;
                        IndexNew.Free;
                        state.caption := '';
                        memo.lines.Add( inttostr( j ) + ' Tiles gepatcht.' );
                end;
                //Map3
                if fn = 'map3.mul' then begin
                        memo.Lines.Add( 'Erstelle Patch fr Map3.' );
                        IndexNew := TFileStream.Create( listbox.Items[i], fmOpenRead );
                        IndexOld := TFileStream.Create( editUOPath.Text + 'map3.mul', fmOpenRead );
                        j := 0;
                        IndexNew.Seek( 0, soFromBeginning );
                        IndexOld.Seek( 0, soFromBeginning );

                        Index.Lookup := MStream.Position + sizeof( TIndex );
                        Index.Length := 320*256*64*3;
                        Index.Tag := 0;
                        Index.Typ := typ_map3;
                        MStream.Write( Index, sizeof( TIndex ) );

                        for l := 1 to 320*256 do begin
                                IndexOld.Read( Offset, 4 );
                                IndexNew.Read( Offset, 4 );

                                for k := 0 to 63 do begin
                                        IndexOld.Read( MapTileOld, sizeof( TMapTile ) );
                                        IndexNew.Read( MapTileNew, sizeof( TMapTile ) );

                                        if ( MapTileOld.Tile <> MapTileNew.Tile ) or ( MapTileOld.Hoehe <> MapTileNew.Hoehe ) then
                                                inc( j )
                                        else begin
                                                MapTileNew.Tile := 0;
                                                MapTileNew.Hoehe := 0;
                                                end;
                                        MStream.Write( MapTileNew , sizeof( TMapTile ) );
                                end;
                                state.Caption := inttostr( trunc( 100 * IndexNew.Position / IndexNew.Size ) ) + '%';
                                Application.ProcessMessages;
                        end;
                        IndexOld.Free;
                        IndexNew.Free;
                        state.caption := '';
                        memo.lines.Add( inttostr( j ) + ' Tiles gepatcht.' );
                end;
                //Map4
                if fn = 'map4.mul' then begin
                        memo.Lines.Add( 'Erstelle Patch fr Map4.' );
                        IndexNew := TFileStream.Create( listbox.Items[i], fmOpenRead );
                        IndexOld := TFileStream.Create( editUOPath.Text + 'map4.mul', fmOpenRead );
                        j := 0;
                        IndexNew.Seek( 0, soFromBeginning );
                        IndexOld.Seek( 0, soFromBeginning );

                        Index.Lookup := MStream.Position + sizeof( TIndex );
                        Index.Length := 181*181*64*3;
                        Index.Tag := 0;
                        Index.Typ := typ_map4;
                        MStream.Write( Index, sizeof( TIndex ) );

                        for l := 1 to 181*181 do begin
                                IndexOld.Read( Offset, 4 );
                                IndexNew.Read( Offset, 4 );

                                for k := 0 to 63 do begin
                                        IndexOld.Read( MapTileOld, sizeof( TMapTile ) );
                                        IndexNew.Read( MapTileNew, sizeof( TMapTile ) );

                                        if ( MapTileOld.Tile <> MapTileNew.Tile ) or ( MapTileOld.Hoehe <> MapTileNew.Hoehe ) then
                                                inc( j )
                                        else begin
                                                MapTileNew.Tile := 0;
                                                MapTileNew.Hoehe := 0;
                                                end;
                                        MStream.Write( MapTileNew , sizeof( TMapTile ) );
                                end;
                                state.Caption := inttostr( trunc( 100 * IndexNew.Position / IndexNew.Size ) ) + '%';
                                Application.ProcessMessages;
                        end;
                        IndexOld.Free;
                        IndexNew.Free;
                        state.caption := '';
                        memo.lines.Add( inttostr( j ) + ' Tiles gepatcht.' );
                end;
        end;

        Application.ProcessMessages;
    end;

    Memo.Lines.Add( 'Schreibe eventuelle Befehle.' );

    if cbEncrypt.Checked then begin
        Index.Lookup := 0;
        Index.Length := 0;
        Index.Tag := 0;
        Index.Typ := typ_encrypt;
        MStream.Write( Index, sizeof( TIndex ) );
    end;

    if cbReIndexAnim.Checked then begin
        Index.Lookup := 0;
        Index.Length := 0;
        Index.Tag := ReIndex_Anim;
        Index.Typ := typ_befehl;
        MStream.Write( Index, sizeof( TIndex ) );
    end;

    if cbReIndexArt.Checked then begin
        Index.Lookup := 0;
        Index.Length := 0;
        Index.Tag := ReIndex_Art;
        Index.Typ := typ_befehl;
        MStream.Write( Index, sizeof( TIndex ) );
    end;

    if cbReIndexGumps.Checked then begin
        Index.Lookup := 0;
        Index.Length := 0;
        Index.Tag := ReIndex_Gumps;
        Index.Typ := typ_befehl;
        MStream.Write( Index, sizeof( TIndex ) );
    end;

    if cbReIndexSound.Checked then begin
        Index.Lookup := 0;
        Index.Length := 0;
        Index.Tag := ReIndex_Sound;
        Index.Typ := typ_befehl;
        MStream.Write( Index, sizeof( TIndex ) );
    end;

    if cbReIndexStatics.Checked then begin
        Index.Lookup := 0;
        Index.Length := 0;
        Index.Tag := ReIndex_Statics;
        Index.Typ := typ_befehl;
        MStream.Write( Index, sizeof( TIndex ) );
    end;

    if cbReIndexAnim.Checked then begin
        Index.Lookup := 0;
        Index.Length := 0;
        Index.Tag := ReIndex_Textures;
        Index.Typ := typ_befehl;
        MStream.Write( Index, sizeof( TIndex ) );
    end;

    if eJumpTo.Text <> '' then begin
        Index.Lookup := StrToInt( eJumpTo.Text );
        Index.Length := 0;
        Index.Tag := JumpTo;
        Index.Typ := typ_befehl;
        MStream.Write( Index, sizeof( TIndex ) );                
    end;

    if cbCHMap.Checked or cbCHStatics.Checked then begin
        MinX := StrToInt( eXMin.Text );
        MinY := StrToInt( eYMin.Text );
        MaxX := StrToInt( eXMax.Text );
        MaxY := StrToInt( eYMax.Text );

        MapNr := StrToInt( eMapNr.Text );
        MapHoehe := StrToInt( eMapHoehe.Text );
        Delta := StrToInt( eCH.Text );

        if cbCHMap.Checked then
                ChangeMap := 1
        else
                ChangeMap := 0;

        if cbCHStatics.Checked then
                ChangeStatic := 1
        else
                ChangeStatic := 0;

        Index.Lookup := 0;
        Index.Length := 0;
        Index.Tag := ChangeHeight;
        Index.Typ := typ_befehl;
        MStream.Write( Index, sizeof( TIndex ) );

        MStream.Write( MinX, 4 );
        MStream.Write( MinY, 4 );
        MStream.Write( MaxX, 4 );
        MStream.Write( MaxY, 4 );

        MStream.Write( MapNr, 1 );
        MStream.Write( MapHoehe, 2 );
        MStream.Write( ChangeMap, 1 );
        MStream.Write( ChangeStatic, 1 );
        MStream.Write( Delta, 4 );
    end;

    Memo.Lines.Add( 'Komprimiere und speichere Datei.' );

    FStream := TFileStream.Create( filename, fmCreate );
    FStream.Seek( 0, soFromBeginning );
    MStream.Seek( 0, soFromBeginning );
    TotalSize := MStream.Size;
    PowerArcCompress( MStream, FStream, 0, '', ProgressCallback );
    FStream.Write( TotalSize, 4 );

    FStream.Free;
    MStream.Free;
    DeleteFile( filename+'2' );
    Memo.Lines.Add( 'Schreibe Datenfile.' );
    Data := TStringList.Create;
    if FileExists( ExtractFilePath( filename ) + 'patchdata.txt' ) then
        Data.LoadFromFile( ExtractFilePath( filename ) + 'patchdata.txt' );

    Data.Add( Format( '%s %s %s', [DateToStr( Date ), TimeToStr( Time ), MD5DigestToStr( MD5File( filename ) )] ) );

    if FileExists( ExtractFilePath( filename ) + 'patchdata.txt' ) then
        DeleteFile( ExtractFilePath( filename ) + 'patchdata.txt' );
    Data.SaveToFile( ExtractFilePath( filename ) + 'patchdata.txt' );
    
    Memo.Lines.Add( 'Fertig.' );
end;

procedure Ttdvpm.ProgressCallback(Current: integer);
begin
        state.Caption := inttostr( trunc(100*(Current/Totalsize) ) ) + ' %';
        Application.ProcessMessages;
end;

procedure Ttdvpm.Delete1Click(Sender: TObject);
begin
        if listbox.ItemIndex <> -1 then
                listbox.Items.Delete( listbox.ItemIndex );
end;

procedure Ttdvpm.AddConfigFileClick(Sender: TObject);
var Opendialog : TOpendialog;
    i : integer;
    name : string;
begin
    Opendialog := TOpendialog.Create( nil );

    if not Opendialog.Execute then
    begin
      Opendialog.Free;
      Exit;
    end;

    if not FileExists(Opendialog.FileName) then
    begin
      Application.MessageBox( 'Diese Datei ist nicht existent. Bitte whlen sie einen gltigen Dateinamen.', 'Datei nicht gefunden', MB_OK+MB_ICONERROR );
      Opendialog.Free;
      Exit;
    end;

    if listbox.Items.Count > 0 then begin
        for i:=0 to listbox.Count-1 do
                if listbox.Items[i] = Opendialog.FileName then begin
                        Opendialog.Free;
                        Application.MessageBox( 'Jede Datei kann nur einmal ausgewhlt werden.', 'Datei schon ausgewhlt', MB_OK+MB_ICONERROR );
                        exit;
                end;
    end;

    listbox.Items.Add( Opendialog.FileName );

    name := LowerCase( ExtractFileName( Opendialog.FileName ) );

    patchlist.Add( Pointer( 2 ) );

    Opendialog.Free;
end;

procedure Ttdvpm.AddScriptClick(Sender: TObject);
var Opendialog : TOpendialog;
    i : integer;
    name : string;
begin
    Opendialog := TOpendialog.Create( nil );

    if not Opendialog.Execute then
    begin
      Opendialog.Free;
      Exit;
    end;

    if not FileExists(Opendialog.FileName) then
    begin
      Application.MessageBox( 'Diese Datei ist nicht existent. Bitte whlen sie einen gltigen Dateinamen.', 'Datei nicht gefunden', MB_OK+MB_ICONERROR );
      Opendialog.Free;
      Exit;
    end;

    if listbox.Items.Count > 0 then begin
        for i:=0 to listbox.Count-1 do
                if listbox.Items[i] = Opendialog.FileName then begin
                        Opendialog.Free;
                        Application.MessageBox( 'Jede Datei kann nur einmal ausgewhlt werden.', 'Datei schon ausgewhlt', MB_OK+MB_ICONERROR );
                        exit;
                end;
    end;

    listbox.Items.Add( Opendialog.FileName );

    name := LowerCase( ExtractFileName( Opendialog.FileName ) );

    patchlist.Add( Pointer( 3 ) );

    Opendialog.Free;
end;

procedure Ttdvpm.cbMEClick(Sender: TObject);
var     UserName, PassWord : String;
begin
        if cbME.Checked then begin
                if MulCrypt <> nil then
                        MulCrypt.Free;

                UserName := '';
                if not InputQuery( 'Username', 'Username', UserName ) then begin
                        cbME.Checked := False;
                        Exit;
                end;

                PassWord := '';
                if not InputQuery( 'Password', 'Password', PassWord ) then begin
                        cbME.Checked := False;
                        Exit;
                end;

                MulCrypt := TMulCrypt.Create( UserName, PassWord, 4 );
        end;
end;

procedure Ttdvpm.FormDestroy(Sender: TObject);
begin
        if MulCrypt <> nil then
                MulCrypt.Free;
end;

end.
