unit uLoaderAnimations;

interface

uses Classes, SysUtils, uUtilities, Dialogs, uLoaderHues, uTexCache, dglOpenGL,
        uLog, uLoaderVerdata, uRenderer, uByteCache;

const   MaxAnimFrames = 20;

type    TAnimObject = Class( TTexObject )
                public
                        CenterX : SmallInt;
                        CenterY : SmallInt;
                        Frames : Word;
                        constructor Create;
                        destructor Free;
        end;

type    TAnimations = Class
                private
                        idxBaseStream, mulBaseStream, idxShardStream, mulShardStream : TFileStream;
                        idxBaseStream2, mulBaseStream2, idxShardStream2, mulShardStream2 : TFileStream;
                        idxBaseStream3, mulBaseStream3, idxShardStream3, mulShardStream3 : TFileStream;
                        idxBaseStream4, mulBaseStream4, idxShardStream4, mulShardStream4 : TFileStream;
                        idxBaseStream5, mulBaseStream5, idxShardStream5, mulShardStream5 : TFileStream;                                                                       
                        Cache : TTexCache;
                        SitDownCache : TTexCache;
                        function AddEmptyTexture( Id : LongWord; Anim : Word; Frame : Word; Hue : Integer ) : TAnimObject;
                        function AddEmptySitDownTexture( Id : LongWord; Anim : Word; Hue : Integer ) : TAnimObject;
                        function LoadAnimation( Id : LongWord; Anim : Word; Frame : Word; Hue : Integer; Grayify : Boolean = False ) : TAnimObject;
                        function LoadSitDownAnimation( Id : LongWord; Hue : Integer; Grayify : Boolean ) : TAnimObject;
                        function GetRealId( BaseId : LongWord; Anim : Word; FileNr : Byte ) : LongWord;
                public
                        constructor Create( baseDir, shardDir : String );
                        destructor Free;
                        function GetAnimFrameObject( BaseId : LongWord; Anim : Word; Hue : Integer; Frame : Word; Grayify : Boolean = False ) : TAnimObject;
                        function GetAnimSitDownFrameObject( BaseId : LongWord; Hue : Integer; Grayify : Boolean = False ) : TAnimObject;
                        function GetCorpseID( Id : Word; Nr : Word = 0 ) : Word;
                        procedure IncCache( BaseId : LongWord;  Anim : Word; Hue : Integer; Frame : Word; Grayify : Boolean = False );
                        procedure DecCache( BaseId : LongWord;  Anim : Word; Hue : Integer; Frame : Word; Grayify : Boolean = False );
                        procedure Poll;
        end;

implementation

uses    uPalanthir, uShard;

constructor TAnimObject.Create;
begin
        inherited Create( Tex_Anim );
        CenterX := 0;
        CenterY := 0;
        Frames := 0;
end;

destructor TAnimObject.Free;
begin
        inherited Free;
end;

constructor TAnimations.Create( baseDir, shardDir : String );
begin
        idxBaseStream := TFileStream.Create( baseDir + 'Anim.idx', fmOpenRead + fmShareDenyNone );
        mulBaseStream := TFileStream.Create( baseDir + 'Anim.mul', fmOpenRead + fmShareDenyNone );
        if FileExists( shardDir + 'Anim.idx' ) then
                idxShardStream := TFileStream.Create( shardDir + 'Anim.idx', fmOpenRead + fmShareDenyNone )
        else
                idxShardStream := nil;
        if FileExists( shardDir + 'Anim.mul' ) then
                mulShardStream := TFileStream.Create( shardDir + 'Anim.mul', fmOpenRead + fmShareDenyNone )
        else
                mulShardStream := nil;


        if FileExists( baseDir + 'Anim2.idx' ) then
                idxBaseStream2 := TFileStream.Create( baseDir + 'Anim2.idx', fmOpenRead + fmShareDenyNone )
        else
                idxBaseStream2 := nil;
        if FileExists( baseDir + 'Anim2.mul' ) then
                mulBaseStream2 := TFileStream.Create( baseDir + 'Anim2.mul', fmOpenRead + fmShareDenyNone )
        else
                mulBaseStream2 := nil;
        if FileExists( shardDir + 'Anim2.idx' ) then
                idxShardStream2 := TFileStream.Create( shardDir + 'Anim2.idx', fmOpenRead + fmShareDenyNone )
        else
                idxShardStream2 := nil;
        if FileExists( shardDir + 'Anim2.mul' ) then
                mulShardStream2 := TFileStream.Create( shardDir + 'Anim2.mul', fmOpenRead + fmShareDenyNone )
        else
                mulShardStream2 := nil;


        if FileExists( baseDir + 'Anim3.idx' ) then
                idxBaseStream3 := TFileStream.Create( baseDir + 'Anim3.idx', fmOpenRead + fmShareDenyNone )
        else
                idxBaseStream3 := nil;
        if FileExists( baseDir + 'Anim3.mul' ) then
                mulBaseStream3 := TFileStream.Create( baseDir + 'Anim3.mul', fmOpenRead + fmShareDenyNone )
        else
                mulBaseStream3 := nil;
        if FileExists( shardDir + 'Anim3.idx' ) then
                idxShardStream3 := TFileStream.Create( shardDir + 'Anim3.idx', fmOpenRead + fmShareDenyNone )
        else
                idxShardStream3 := nil;
        if FileExists( shardDir + 'Anim3.mul' ) then
                mulShardStream3 := TFileStream.Create( shardDir + 'Anim3.mul', fmOpenRead + fmShareDenyNone )
        else
                mulShardStream3 := nil;

        if FileExists( baseDir + 'Anim4.idx' ) then
                idxBaseStream4 := TFileStream.Create( baseDir + 'Anim4.idx', fmOpenRead + fmShareDenyNone )
        else
                idxBaseStream4 := nil;
        if FileExists( baseDir + 'Anim4.mul' ) then
                mulBaseStream4 := TFileStream.Create( baseDir + 'Anim4.mul', fmOpenRead + fmShareDenyNone )
        else
                mulBaseStream4 := nil;
        if FileExists( shardDir + 'Anim4.idx' ) then
                idxShardStream4 := TFileStream.Create( shardDir + 'Anim4.idx', fmOpenRead + fmShareDenyNone )
        else
                idxShardStream4 := nil;
        if FileExists( shardDir + 'Anim4.mul' ) then
                mulShardStream4 := TFileStream.Create( shardDir + 'Anim4.mul', fmOpenRead + fmShareDenyNone )
        else
                mulShardStream4 := nil;

        if FileExists( baseDir + 'Anim5.idx' ) then
                idxBaseStream5 := TFileStream.Create( baseDir + 'Anim5.idx', fmOpenRead + fmShareDenyNone )
        else
                idxBaseStream5 := nil;
        if FileExists( baseDir + 'Anim5.mul' ) then
                mulBaseStream5 := TFileStream.Create( baseDir + 'Anim5.mul', fmOpenRead + fmShareDenyNone )
        else
                mulBaseStream5 := nil;
        if FileExists( shardDir + 'Anim5.idx' ) then
                idxShardStream5 := TFileStream.Create( shardDir + 'Anim5.idx', fmOpenRead + fmShareDenyNone )
        else
                idxShardStream5 := nil;
        if FileExists( shardDir + 'Anim5.mul' ) then
                mulShardStream5 := TFileStream.Create( shardDir + 'Anim5.mul', fmOpenRead + fmShareDenyNone )
        else
                mulShardStream5 := nil;

        Cache := TTexCache.Create;
        SitDownCache := TTexCache.Create;
end;

destructor TAnimations.Free;
begin
        idxBaseStream.Free;
        mulBaseStream.Free;
        if idxShardStream <> nil then
                idxShardStream.Free;
        if mulShardStream <> nil then
                mulShardStream.Free;


        if idxBaseStream2 <> nil then
                idxBaseStream2.Free;
        if mulBaseStream2 <> nil then
                mulBaseStream2.Free;
        if idxShardStream2 <> nil then
                idxShardStream2.Free;
        if mulShardStream2 <> nil then
                mulShardStream2.Free;


        if idxBaseStream3 <> nil then
                idxBaseStream3.Free;
        if mulBaseStream3 <> nil then
                mulBaseStream3.Free;
        if idxShardStream3 <> nil then
                idxShardStream3.Free;
        if mulShardStream3 <> nil then
                mulShardStream3.Free;

        if idxBaseStream4 <> nil then
                idxBaseStream4.Free;
        if mulBaseStream4 <> nil then
                mulBaseStream4.Free;
        if idxShardStream4 <> nil then
                idxShardStream4.Free;
        if mulShardStream4 <> nil then
                mulShardStream4.Free;

        if idxBaseStream5 <> nil then
                idxBaseStream5.Free;
        if mulBaseStream5 <> nil then
                mulBaseStream5.Free;
        if idxShardStream5 <> nil then
                idxShardStream5.Free;
        if mulShardStream5 <> nil then
                mulShardStream5.Free;

        Cache.Free;
        SitDownCache.Free;
end;

function TAnimations.GetRealId( BaseId : LongWord; Anim : Word; FileNr : Byte ) : LongWord;
begin
        Result := 0;

        Case FileNr of
                0, 2, 4, 5 : begin
                        if BaseId < 200 then
                                Result := BaseId*110 + Anim
                        else if BaseId < 400 then
                                Result := ( BaseId - 200 )*65 + 22000 + Anim
                        else
                                Result := ( BaseId - 400 )*175 + 35000 + Anim;
                end;
                3 : begin
                        if BaseId < 420 then
                                Result := BaseId*110 + Anim
                        else if BaseId < 490 then
                                Result := ( BaseId - 420 )*65 + 46200 + Anim
                        else
                                Result := ( BaseId - 490 )*175 + 50750 + Anim;
                end;
        end;
end;

function TAnimations.AddEmptyTexture( Id : LongWord; Anim : Word; Frame : Word; Hue : Integer ) : TAnimObject;
begin
        Result := TAnimObject.Create;
        Result.ID := Id*175 + Anim;
        Result.Frame := Frame;
        Result.Hue := Hue;
        Result.Hoehe := 0;
        Result.Breite := 0;
        Result.Count := 0;
        Result.Frames := 1;
        Result.ZeroTime := CustomGetTickCount;

        Cache.AddObject( Result );
end;

function TAnimations.AddEmptySitDownTexture( Id : LongWord; Anim : Word; Hue : Integer ) : TAnimObject;
begin
        Result := TAnimObject.Create;
        Result.ID := Id*175 + Anim;
        Result.Frame := 0;
        Result.Hue := Hue;
        Result.Hoehe := 0;
        Result.Breite := 0;
        Result.Count := 0;
        Result.Frames := 1;
        Result.ZeroTime := CustomGetTickCount;

        SitDownCache.AddObject( Result );
end;

function TAnimations.LoadAnimation( Id : LongWord; Anim : Word; Frame : Word; Hue : Integer; Grayify : Boolean ) : TAnimObject;
var     RealId : LongWord;
        Anims, BaseId : Word;
        Frames : LongWord;
        Texture : TAnimObject;
        Palette : Array[0..255] of Word;
        IndexRecord : TIndexRecord;
        LookupList : PIntegerArray;
        Header : LongWord;
        Start : Integer;
        Hoehe, Breite : Word;
        xRun, xOffset, yOffset : Integer;
        RunPixels : PByteArray;
        I, K : Integer;
        PartialHue : Boolean;
        PX, PY : Integer;
        Color, RealHue : Word;
        Red, Green, Blue : Byte;
        CenterX, CenterY : SmallInt;
        mulStream : TStream;
        Gefunden : Boolean;
        FileNr : Byte;
        VerdataEntry : TVerdataEntry;
        ByteCache : TByteCache;
begin
        Result := nil;

        FileNr := Palanthir.Shard.GetAnimRecord( Id ).FileNr;
        BaseId := Palanthir.Shard.GetAnimRecord( Id ).Id;

        RealId := GetRealId( BaseId, Anim, FileNr );
        Case FileNr of
                0, 2, 4, 5 : begin
                        if BaseId < 200 then
                                Anims := 110
                        else if BaseId < 400 then
                                Anims := 65
                        else
                                Anims := 175;
                end;
                3 : begin
                        if BaseId < 420 then
                                Anims := 110
                        else if BaseId < 490 then
                                Anims := 65
                        else
                                Anims := 175;
                end;
        end;
        if Anim >= Anims then begin
                Result := nil;
                Exit;
        end;

        if Hue > 0 then begin
                RealHue := Hue and $7FFF;
                PartialHue := ( ( Hue and $8000 ) = $8000 );
        end
        else begin
                if Palanthir.Shard.GetAnimRecord( Id ).Color > 0 then begin
                        RealHue := Palanthir.Shard.GetAnimRecord( Id ).Color and $7FFF;
                        PartialHue := ( ( Palanthir.Shard.GetAnimRecord( Id ).Color and $8000 ) = $8000 );
                end
                else begin
                        RealHue := 0;
                        PartialHue := False;
                end;
        end;

        if FileNr = 0 then begin
                VerdataEntry := Palanthir.Data.Verdata.GetAnim( RealId );
                if VerdataEntry <> nil then begin
                        IndexRecord := VerdataEntry.IndexRecord;
                        if (IndexRecord.Offset = -1) or (IndexRecord.Length = -1) then begin
                                Result := AddEmptyTexture( Id, Anim, Frame, Hue );
                                exit;
                        end;
                        mulStream := VerdataEntry.mulStream;
                end
                else begin
                        Gefunden := False;
                        if (idxShardStream <> nil) and (mulShardStream <> nil) and (RealId*12 < idxShardStream.Size) then begin
                                idxShardStream.Seek( RealId*12, soFromBeginning );
                                idxShardStream.Read( IndexRecord, 12 );

                                if Palanthir.MulEncryption then begin
                                        if Palanthir.Data.MulCrypt.DecryptIndexRecordAnim( RealId, IndexRecord ) then begin
                                                if (IndexRecord.Offset <> -1) and (IndexRecord.Length <> -1) then begin
                                                        Gefunden := True;
                                                        if mulShardStream <> nil then
                                                                mulStream := mulShardStream
                                                        else
                                                                mulStream := mulBaseStream;
                                                end;
                                        end
                                        else begin
                                                Log.Write( 'Not able to decrypt Anim.' );
                                                Result := nil;
                                                Exit;
                                        end;
                                end
                                else begin
                                        if (IndexRecord.Offset <> -1) and (IndexRecord.Length <> -1) then begin
                                                Gefunden := True;
                                                if mulShardStream <> nil then
                                                        mulStream := mulShardStream
                                                else
                                                        mulStream := mulBaseStream;
                                        end;
                                end;
                        end;

                        if (not Gefunden) and (idxBaseStream <> nil) and (mulBaseStream <> nil) then begin
                                if RealId*12 >= idxBaseStream.Size then begin
                                        Result := AddEmptyTexture( Id, Anim, Frame, Hue );
                                        exit;
                                end;

                                idxBaseStream.Seek( RealId*12, soFromBeginning );
                                idxBaseStream.Read( IndexRecord, 12 );

                                if (IndexRecord.Offset = -1) or (IndexRecord.Length = -1) then begin
                                        Result := AddEmptyTexture( Id, Anim, Frame, Hue );
                                        exit;
                                end;

                                mulStream := mulBaseStream;
                        end
                        else if (not Gefunden) then begin
                                Result := AddEmptyTexture( Id, Anim, Frame, Hue );
                                exit;
                        end;
                end;
        end
        else if FileNr = 2 then begin
                Gefunden := False;
                if (idxShardStream2 <> nil) and (mulShardStream2 <> nil) and (RealId*12 < idxShardStream2.Size) then begin
                        idxShardStream2.Seek( RealId*12, soFromBeginning );
                        idxShardStream2.Read( IndexRecord, 12 );
                        if (IndexRecord.Offset <> -1) and (IndexRecord.Length <> -1) then begin
                                Gefunden := True;
                                mulStream := mulShardStream2;
                        end;
                end;

                if (not Gefunden) and (idxBaseStream2 <> nil) and (mulBaseStream2 <> nil) then begin
                        if RealId*12 >= idxBaseStream2.Size then begin
                                Result := AddEmptyTexture( Id, Anim, Frame, Hue );
                                exit;
                        end;

                        idxBaseStream2.Seek( RealId*12, soFromBeginning );
                        idxBaseStream2.Read( IndexRecord, 12 );

                        if (IndexRecord.Offset = -1) or (IndexRecord.Length = -1) then begin
                                Result := AddEmptyTexture( Id, Anim, Frame, Hue );
                                exit;
                        end;

                        mulStream := mulBaseStream2;
                end
                else if (not Gefunden) then begin
                        Result := AddEmptyTexture( Id, Anim, Frame, Hue );
                        exit;
                end;
        end
        else if FileNr = 3 then begin
                Gefunden := False;
                if (idxShardStream3 <> nil) and (mulShardStream3 <> nil) and (RealId*12 < idxShardStream3.Size) then begin
                        idxShardStream3.Seek( RealId*12, soFromBeginning );
                        idxShardStream3.Read( IndexRecord, 12 );
                        if (IndexRecord.Offset <> -1) and (IndexRecord.Length <> -1) then begin
                                Gefunden := True;
                                mulStream := mulShardStream3;
                        end;
                end;

                if (not Gefunden) and (idxBaseStream3 <> nil) and (mulBaseStream3 <> nil) then begin
                        if RealId*12 >= idxBaseStream3.Size then begin
                                Result := AddEmptyTexture( Id, Anim, Frame, Hue );
                                exit;
                        end;

                        idxBaseStream3.Seek( RealId*12, soFromBeginning );
                        idxBaseStream3.Read( IndexRecord, 12 );

                        if (IndexRecord.Offset = -1) or (IndexRecord.Length = -1) then begin
                                Result := AddEmptyTexture( Id, Anim, Frame, Hue );
                                exit;
                        end;

                        mulStream := mulBaseStream3;
                end
                else if (not Gefunden) then begin
                        Result := AddEmptyTexture( Id, Anim, Frame, Hue );
                        exit;
                end;
        end
        else if FileNr = 4 then begin
                Gefunden := False;
                if (idxShardStream4 <> nil) and (mulShardStream4 <> nil) and (RealId*12 < idxShardStream4.Size) then begin
                        idxShardStream4.Seek( RealId*12, soFromBeginning );
                        idxShardStream4.Read( IndexRecord, 12 );
                        if (IndexRecord.Offset <> -1) and (IndexRecord.Length <> -1) then begin
                                Gefunden := True;
                                mulStream := mulShardStream4;
                        end;
                end;

                if (not Gefunden) and (idxBaseStream4 <> nil) and (mulBaseStream4 <> nil) then begin
                        if RealId*12 >= idxBaseStream4.Size then begin
                                Result := AddEmptyTexture( Id, Anim, Frame, Hue );
                                exit;
                        end;

                        idxBaseStream4.Seek( RealId*12, soFromBeginning );
                        idxBaseStream4.Read( IndexRecord, 12 );

                        if (IndexRecord.Offset = -1) or (IndexRecord.Length = -1) then begin
                                Result := AddEmptyTexture( Id, Anim, Frame, Hue );
                                exit;
                        end;

                        mulStream := mulBaseStream4;
                end
                else if (not Gefunden) then begin
                        Result := AddEmptyTexture( Id, Anim, Frame, Hue );
                        exit;
                end;
        end
        else if FileNr = 5 then begin
                Gefunden := False;
                if (idxShardStream5 <> nil) and (mulShardStream5 <> nil) and (RealId*12 < idxShardStream5.Size) then begin
                        idxShardStream5.Seek( RealId*12, soFromBeginning );
                        idxShardStream5.Read( IndexRecord, 12 );
                        if (IndexRecord.Offset <> -1) and (IndexRecord.Length <> -1) then begin
                                Gefunden := True;
                                mulStream := mulShardStream5;
                        end;
                end;

                if (not Gefunden) and (idxBaseStream5 <> nil) and (mulBaseStream5 <> nil) then begin
                        if RealId*12 >= idxBaseStream5.Size then begin
                                Result := AddEmptyTexture( Id, Anim, Frame, Hue );
                                exit;
                        end;

                        idxBaseStream5.Seek( RealId*12, soFromBeginning );
                        idxBaseStream5.Read( IndexRecord, 12 );

                        if (IndexRecord.Offset = -1) or (IndexRecord.Length = -1) then begin
                                Result := AddEmptyTexture( Id, Anim, Frame, Hue );
                                exit;
                        end;

                        mulStream := mulBaseStream5;
                end
                else if (not Gefunden) then begin
                        Result := AddEmptyTexture( Id, Anim, Frame, Hue );
                        exit;
                end;
        end
        else begin
                Result := AddEmptyTexture( Id, Anim, Frame, Hue );
                exit;
        end;

        mulStream.Seek( IndexRecord.Offset, soFromBeginning );
        mulStream.Read( Palette, 512 );
        Start := mulStream.Position;
        mulStream.Read( Frames, 4 );

        if (Frames = 0) or (Frames > MaxAnimFrames) then begin
                Result := AddEmptyTexture( Id, Anim, Frame, Hue );
                exit;
        end;

        GetMem( LookupList, Frames*4 );
        mulStream.Read( LookupList^, Frames*4 );

        for I := 0 to Frames-1 do begin
                if Start + LookupList^[ I ] > mulStream.Size then begin
                        Continue;
                end;

                mulStream.Seek( Start + LookupList^[ I ], soFromBeginning );
                mulStream.Read( CenterX, 2 );
                mulStream.Read( CenterY, 2 );
                mulStream.Read( Breite, 2 );
                mulStream.Read( Hoehe, 2 );

                Texture := TAnimObject.Create;
                Texture.ID := Id*175 + Anim;
                Texture.Frame := I;
                Texture.Hue := Hue;
                Texture.Hoehe := Hoehe;
                Texture.Breite := Breite;
                Texture.Count := 0;
                Texture.Frames := Frames;
                Texture.ZeroTime := CustomGetTickCount;

                if (Breite = 0) or (Hoehe = 0) then begin
                        Texture.TexID := 0;
                        Cache.AddObject( Texture );
                        exit;
                end;

                ByteCache := TByteCache.Create( Breite, Hoehe );
                
                mulStream.Read( Header, 4 );
                while ( Header <> $7FFF7FFF ) do begin
                        xRun := Header and $FFF;
                        xOffset := ( Header shr 22 ) and 1023;
                        yOffset := ( Header shr 12 ) and 1023;

                        if ( xOffset and 512 ) = 512 then
                                xOffset := xOffset or ( $FFFFFFFF - 511 );
                        if ( yOffset and 512 ) = 512 then
                                yOffset := yOffset or ( $FFFFFFFF - 511 );

                        PX := xOffset + CenterX;
                        PY := yOffset + CenterY + Hoehe;

                        GetMem( RunPixels, xRun );
                        mulStream.Read( RunPixels^, xRun );
                        for K := 0 to xRun-1 do begin
                                if ( PX < Breite ) and ( PY < Hoehe ) and ( PX >= 0 ) and ( PY >= 0 ) then begin
                                        Color := Palette[ RunPixels^[ K ] ];
                                        if Grayify then begin
                                                Red := Color15toRed( Color );
                                                ByteCache.Pixels[PX,PY].Red := Red;
                                                ByteCache.Pixels[PX,PY].Green := Red;
                                                ByteCache.Pixels[PX,PY].Blue := Red;
                                        end
                                        else begin
                                                if RealHue > 0 then begin
                                                        Red := Color15toRed( Color );
                                                        Green := Color15toGreen( Color );
                                                        Blue := Color15toBlue( Color );
                                                        if ( PartialHue and (Red = Blue) and (Red = Green) ) or ( not PartialHue ) then begin
                                                                Red := Red div 8;
                                                                ByteCache.Pixels[PX,PY].Red := Color15toRed( Hues.GetColor( RealHue, Red ) );
                                                                ByteCache.Pixels[PX,PY].Green := Color15toGreen( Hues.GetColor( RealHue, Red ) );
                                                                ByteCache.Pixels[PX,PY].Blue := Color15toBlue( Hues.GetColor( RealHue, Red ) );
                                                        end
                                                        else begin
                                                                ByteCache.Pixels[PX,PY].Red := Color15toRed( Color );
                                                                ByteCache.Pixels[PX,PY].Green := Color15toGreen( Color );
                                                                ByteCache.Pixels[PX,PY].Blue := Color15toBlue( Color );
                                                        end;
                                                end
                                                else begin
                                                        ByteCache.Pixels[PX,PY].Red := Color15toRed( Color );
                                                        ByteCache.Pixels[PX,PY].Green := Color15toGreen( Color );
                                                        ByteCache.Pixels[PX,PY].Blue := Color15toBlue( Color );
                                                end;
                                        end;
                                        ByteCache.Pixels[PX,PY].Alpha := 255;
                                end;
                                Inc( PX );
                        end;
                        FreeMem( RunPixels, xRun );
                        mulStream.Read( Header, 4 );
                end;
                Texture.CenterX := CenterX;
                Texture.CenterY := CenterY;

                glGenTextures( 1, @Texture.TexID );
                glBindTexture( GL_TEXTURE_2D, Texture.TexID );
                glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST );
                glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST );
                glTexImage2D( GL_TEXTURE_2D, 0, GL_RGBA, GetNextBit( Breite ), GetNextBit( Hoehe ), 0, GL_RGBA, GL_UNSIGNED_BYTE, ByteCache.GetData );
                Texture.InitBitMask32( ByteCache.GetData );

                Renderer.CurrentTexID := Texture.TexID;

                ByteCache.Free;

                if I = Frame then
                        Result := Texture;

                Cache.AddObject( Texture );
        end;

        FreeMem( LookupList );
end;

function TAnimations.LoadSitDownAnimation( Id : LongWord; Hue : Integer; Grayify : Boolean ) : TAnimObject;
var     RealId : LongWord;
        Anim, BaseId : Word;
        Frames : LongWord;
        Texture : TAnimObject;
        Palette : Array[0..255] of Word;
        IndexRecord : TIndexRecord;
        LookupList : PIntegerArray;
        Header : LongWord;
        Start : Integer;
        Hoehe, Breite : Word;
        xRun, xOffset, yOffset : Integer;
        RunPixels : PByteArray;
        ByteCache, NewByteCache : TByteCache;
        I, K : Integer;
        PartialHue : Boolean;
        PX, PY, NewPY, NewPX : Integer;
        Color, RealHue : Word;
        Red, Green, Blue : Byte;
        CenterX, CenterY : SmallInt;
        mulStream : TStream;
        Gefunden : Boolean;
        FileNr : Byte;
        VerdataEntry : TVerdataEntry;
begin
        Result := nil;

        Anim := 21;

        FileNr := Palanthir.Shard.GetAnimRecord( Id ).FileNr;
        BaseId := Palanthir.Shard.GetAnimRecord( Id ).Id;

        RealId := GetRealId( BaseId, Anim, FileNr );

        if Hue > 0 then begin
                RealHue := Hue and $7FFF;
                PartialHue := ( ( Hue and $8000 ) = $8000 );
        end
        else begin
                if Palanthir.Shard.GetAnimRecord( Id ).Color > 0 then begin
                        RealHue := Palanthir.Shard.GetAnimRecord( Id ).Color and $7FFF;
                        PartialHue := ( ( Palanthir.Shard.GetAnimRecord( Id ).Color and $8000 ) = $8000 );
                end
                else begin
                        RealHue := 0;
                        PartialHue := False;
                end;
        end;

        if FileNr = 0 then begin
                VerdataEntry := Palanthir.Data.Verdata.GetAnim( RealId );
                if VerdataEntry <> nil then begin
                        IndexRecord := VerdataEntry.IndexRecord;
                        if (IndexRecord.Offset = -1) or (IndexRecord.Length = -1) then begin
                                Result := AddEmptySitDownTexture( Id, Anim, Hue );
                                exit;
                        end;
                        mulStream := VerdataEntry.mulStream;
                end
                else begin
                        Gefunden := False;
                        if (idxShardStream <> nil) and (mulShardStream <> nil) and (RealId*12 < idxShardStream.Size) then begin
                                idxShardStream.Seek( RealId*12, soFromBeginning );
                                idxShardStream.Read( IndexRecord, 12 );

                                if Palanthir.MulEncryption then begin
                                        if Palanthir.Data.MulCrypt.DecryptIndexRecordAnim( RealId, IndexRecord ) then begin
                                                if (IndexRecord.Offset <> -1) and (IndexRecord.Length <> -1) then begin
                                                        Gefunden := True;
                                                        mulStream := mulShardStream;
                                                end;
                                        end
                                        else begin
                                                Log.Write( 'Not able to decrypt Anim.' );
                                                Result := nil;
                                                Exit;                                                
                                        end;
                                end
                                else begin
                                        if (IndexRecord.Offset <> -1) and (IndexRecord.Length <> -1) then begin
                                                Gefunden := True;
                                                mulStream := mulShardStream;
                                        end;
                                end;
                        end;

                        if (not Gefunden) and (idxBaseStream <> nil) and (mulBaseStream <> nil) then begin
                                if RealId*12 >= idxBaseStream.Size then begin
                                        Result := AddEmptySitDownTexture( Id, Anim, Hue );
                                        exit;
                                end;

                                idxBaseStream.Seek( RealId*12, soFromBeginning );
                                idxBaseStream.Read( IndexRecord, 12 );

                                if (IndexRecord.Offset = -1) or (IndexRecord.Length = -1) then begin
                                        Result := AddEmptySitDownTexture( Id, Anim, Hue );
                                        exit;
                                end;

                                mulStream := mulBaseStream;
                        end
                        else if (not Gefunden) then begin
                                Result := AddEmptySitDownTexture( Id, Anim, Hue );
                                exit;
                        end;
                end;
        end
        else if FileNr = 2 then begin
                Gefunden := False;
                if (idxShardStream2 <> nil) and (mulShardStream2 <> nil) and (RealId*12 < idxShardStream2.Size) then begin
                        idxShardStream2.Seek( RealId*12, soFromBeginning );
                        idxShardStream2.Read( IndexRecord, 12 );
                        if (IndexRecord.Offset <> -1) and (IndexRecord.Length <> -1) then begin
                                Gefunden := True;
                                mulStream := mulShardStream2;
                        end;
                end;

                if (not Gefunden) and (idxBaseStream2 <> nil) and (mulBaseStream2 <> nil) then begin
                        if RealId*12 >= idxBaseStream2.Size then begin
                                Result := AddEmptySitDownTexture( Id, Anim, Hue );
                                exit;
                        end;

                        idxBaseStream2.Seek( RealId*12, soFromBeginning );
                        idxBaseStream2.Read( IndexRecord, 12 );

                        if (IndexRecord.Offset = -1) or (IndexRecord.Length = -1) then begin
                                Result := AddEmptySitDownTexture( Id, Anim, Hue );
                                exit;
                        end;

                        mulStream := mulBaseStream2;
                end
                else if (not Gefunden) then begin
                        Result := AddEmptySitDownTexture( Id, Anim, Hue );
                        exit;
                end;
        end
        else if FileNr = 3 then begin
                Gefunden := False;
                if (idxShardStream3 <> nil) and (mulShardStream3 <> nil) and (RealId*12 < idxShardStream3.Size) then begin
                        idxShardStream3.Seek( RealId*12, soFromBeginning );
                        idxShardStream3.Read( IndexRecord, 12 );
                        if (IndexRecord.Offset <> -1) and (IndexRecord.Length <> -1) then begin
                                Gefunden := True;
                                mulStream := mulShardStream3;
                        end;
                end;

                if (not Gefunden) and (idxBaseStream3 <> nil) and (mulBaseStream3 <> nil) then begin
                        if RealId*12 >= idxBaseStream3.Size then begin
                                Result := AddEmptySitDownTexture( Id, Anim, Hue );
                                exit;
                        end;

                        idxBaseStream3.Seek( RealId*12, soFromBeginning );
                        idxBaseStream3.Read( IndexRecord, 12 );

                        if (IndexRecord.Offset = -1) or (IndexRecord.Length = -1) then begin
                                Result := AddEmptySitDownTexture( Id, Anim, Hue );
                                exit;
                        end;

                        mulStream := mulBaseStream3;
                end
                else if (not Gefunden) then begin
                        Result := AddEmptySitDownTexture( Id, Anim, Hue );
                        exit;
                end;
        end
        else if FileNr = 4 then begin
                Gefunden := False;
                if (idxShardStream4 <> nil) and (mulShardStream4 <> nil) and (RealId*12 < idxShardStream4.Size) then begin
                        idxShardStream4.Seek( RealId*12, soFromBeginning );
                        idxShardStream4.Read( IndexRecord, 12 );
                        if (IndexRecord.Offset <> -1) and (IndexRecord.Length <> -1) then begin
                                Gefunden := True;
                                mulStream := mulShardStream4;
                        end;
                end;

                if (not Gefunden) and (idxBaseStream4 <> nil) and (mulBaseStream4 <> nil) then begin
                        if RealId*12 >= idxBaseStream4.Size then begin
                                Result := AddEmptySitDownTexture( Id, Anim, Hue );
                                exit;
                        end;

                        idxBaseStream4.Seek( RealId*12, soFromBeginning );
                        idxBaseStream4.Read( IndexRecord, 12 );

                        if (IndexRecord.Offset = -1) or (IndexRecord.Length = -1) then begin
                                Result := AddEmptySitDownTexture( Id, Anim, Hue );
                                exit;
                        end;

                        mulStream := mulBaseStream4;
                end
                else if (not Gefunden) then begin
                        Result := AddEmptySitDownTexture( Id, Anim, Hue );
                        exit;
                end;
        end
        else if FileNr = 5 then begin
                Gefunden := False;
                if (idxShardStream5 <> nil) and (mulShardStream5 <> nil) and (RealId*12 < idxShardStream5.Size) then begin
                        idxShardStream5.Seek( RealId*12, soFromBeginning );
                        idxShardStream5.Read( IndexRecord, 12 );
                        if (IndexRecord.Offset <> -1) and (IndexRecord.Length <> -1) then begin
                                Gefunden := True;
                                mulStream := mulShardStream5;
                        end;
                end;

                if (not Gefunden) and (idxBaseStream5 <> nil) and (mulBaseStream5 <> nil) then begin
                        if RealId*12 >= idxBaseStream5.Size then begin
                                Result := AddEmptySitDownTexture( Id, Anim, Hue );
                                exit;
                        end;

                        idxBaseStream5.Seek( RealId*12, soFromBeginning );
                        idxBaseStream5.Read( IndexRecord, 12 );

                        if (IndexRecord.Offset = -1) or (IndexRecord.Length = -1) then begin
                                Result := AddEmptySitDownTexture( Id, Anim, Hue );
                                exit;
                        end;

                        mulStream := mulBaseStream5;
                end
                else if (not Gefunden) then begin
                        Result := AddEmptySitDownTexture( Id, Anim, Hue );
                        exit;
                end;
        end
        else begin
                Result := AddEmptySitDownTexture( Id, Anim, Hue );
                exit;
        end;

        mulStream.Seek( IndexRecord.Offset, soFromBeginning );
        mulStream.Read( Palette, 512 );
        Start := mulStream.Position;
        mulStream.Read( Frames, 4 );

        if (Frames = 0) or (Frames > MaxAnimFrames) then begin
                Result := AddEmptySitDownTexture( Id, Anim, Hue );
                exit;
        end;

        GetMem( LookupList, Frames*4 );
        mulStream.Read( LookupList^, Frames*4 );

        //Wir brauchen nur den 0. Frame
        for I := 0 to 0 do begin
                mulStream.Seek( Start + LookupList^[ I ], soFromBeginning );
                mulStream.Read( CenterX, 2 );
                mulStream.Read( CenterY, 2 );
                mulStream.Read( Breite, 2 );
                mulStream.Read( Hoehe, 2 );

                Texture := TAnimObject.Create;
                Texture.ID := Id*175;
                Texture.Frame := I;
                Texture.Hue := Hue;
                Texture.Hoehe := Hoehe;
                Texture.Breite := Breite;
                Texture.Count := 1;
                Texture.Frames := 1;

                if (Breite = 0) or (Hoehe = 0) then begin
                        Texture.TexID := 0;
                        Cache.AddObject( Texture );
                        exit;
                end;

                ByteCache := TByteCache.Create( Breite, Hoehe );

                mulStream.Read( Header, 4 );
                while ( Header <> $7FFF7FFF ) do begin
                        xRun := Header and $FFF;
                        xOffset := ( Header shr 22 ) and 1023;
                        yOffset := ( Header shr 12 ) and 1023;

                        if ( xOffset and 512 ) = 512 then
                                xOffset := xOffset or ( $FFFFFFFF - 511 );
                        if ( yOffset and 512 ) = 512 then
                                yOffset := yOffset or ( $FFFFFFFF - 511 );

                        PX := xOffset + CenterX;
                        PY := yOffset + CenterY + Hoehe;

                        GetMem( RunPixels, xRun );
                        mulStream.Read( RunPixels^, xRun );
                        for K := 0 to xRun-1 do begin
                                if ( PX < Breite ) and ( PY < Hoehe ) and ( PX >= 0 ) and ( PY >= 0 ) then begin
                                        Color := Palette[ RunPixels^[ K ] ];
                                        if Grayify then begin
                                                Red := Color15toRed( Color );
                                                ByteCache.Pixels[PX,PY].Red := Red;
                                                ByteCache.Pixels[PX,PY].Green := Red;
                                                ByteCache.Pixels[PX,PY].Blue := Red;
                                        end
                                        else begin
                                                if RealHue > 0 then begin
                                                        Red := Color15toRed( Color );
                                                        Green := Color15toGreen( Color );
                                                        Blue := Color15toBlue( Color );
                                                        if ( PartialHue and (Red = Blue) and (Red = Green) ) or ( not PartialHue ) then begin
                                                                Red := Red div 8;
                                                                ByteCache.Pixels[PX,PY].Red := Color15toRed( Hues.GetColor( RealHue, Red ) );
                                                                ByteCache.Pixels[PX,PY].Green := Color15toGreen( Hues.GetColor( RealHue, Red ) );
                                                                ByteCache.Pixels[PX,PY].Blue := Color15toBlue( Hues.GetColor( RealHue, Red ) );
                                                        end
                                                        else begin
                                                                ByteCache.Pixels[PX,PY].Red := Color15toRed( Color );
                                                                ByteCache.Pixels[PX,PY].Green := Color15toGreen( Color );
                                                                ByteCache.Pixels[PX,PY].Blue := Color15toBlue( Color );
                                                        end;
                                                end
                                                else begin
                                                        ByteCache.Pixels[PX,PY].Red := Color15toRed( Color );
                                                        ByteCache.Pixels[PX,PY].Green := Color15toGreen( Color );
                                                        ByteCache.Pixels[PX,PY].Blue := Color15toBlue( Color );
                                                end;
                                        end;
                                        ByteCache.Pixels[PX,PY].Alpha := 255;
                                end;
                                Inc( PX );
                        end;
                        FreeMem( RunPixels, xRun );
                        mulStream.Read( Header, 4 );
                end;
                Texture.CenterX := CenterX;
                Texture.CenterY := CenterY;

                //Now transformate the Animation...

                Breite := Breite + 10;
                Texture.Breite := Texture.Breite + 10;
                Texture.CenterX := Texture.CenterX + 10;

                NewByteCache := TByteCache.Create( Breite, Hoehe );

                NewPY := 0;
                for PY := 0 to Hoehe-1 do begin
                        Case Hoehe-(PY-CenterY) of
                                20, 25, 30, 35 : begin
                                        Texture.CenterY := Texture.CenterY;
                                        continue;
                                end;
                                21, 22 : begin
                                        PX := 1;
                                end;
                                23, 24 : begin
                                        PX := 2;
                                end;
                                26, 27 : begin
                                        PX := 3;
                                end;
                                28, 29 : begin
                                        PX := 4;
                                end;
                                31, 32 : begin
                                        PX := 5;
                                end;
                                33, 34 : begin
                                        PX := 6;
                                end;
                                36, 37 : begin
                                        PX := 7;
                                end;
                        else
                                if Hoehe-(PY-CenterY) < 20 then
                                        PX := 0
                                else
                                        PX := 8;
                        end;
                        NewByteCache.CopyFrom( ByteCache, PX, NewPY, 0, PY, Breite-10, 1 );
                        Inc( NewPY );
                end;

                glGenTextures( 1, @Texture.TexID );
                glBindTexture( GL_TEXTURE_2D, Texture.TexID );
                glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST );
                glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST );
                glTexImage2D( GL_TEXTURE_2D, 0, GL_RGBA, GetNextBit( Breite ), GetNextBit( Hoehe ), 0, GL_RGBA, GL_UNSIGNED_BYTE, NewByteCache.GetData );
                Texture.InitBitMask32( NewByteCache.GetData );
                Renderer.CurrentTexID := Texture.TexID;

                ByteCache.Free;
                NewByteCache.Free;

                Result := Texture;

                SitDownCache.AddObject( Texture );
        end;

        FreeMem( LookupList );
end;

function TAnimations.GetAnimFrameObject( BaseId : LongWord; Anim : Word; Hue : Integer; Frame : Word; Grayify : Boolean ) : TAnimObject;
var     Id : LongWord;
begin
        Id := BaseId*175 + Anim;
        if Grayify then
                Hue := Color_Grayify;
        Result := TAnimObject( Cache.GetTexObject( Id, Hue, Frame ) );

        if (Result = nil) then
                Result := TAnimObject( Cache.GetTexObject( Id, Hue, 0 ) );

        if (Result = nil) then
                Result := LoadAnimation( BaseId, Anim, Frame, Hue, Grayify );
end;

function TAnimations.GetAnimSitDownFrameObject( BaseId : LongWord; Hue : Integer; Grayify : Boolean = False ) : TAnimObject;
var     Id : LongWord;
begin
        Id := BaseId*175;
        if Grayify then
                Hue := Color_Grayify;
        Result := TAnimObject( SitDownCache.GetTexObject( Id, Hue, 0 ) );

        if (Result = nil) then
                Result := LoadSitDownAnimation( BaseId, Hue, Grayify );
end;

function TAnimations.GetCorpseID( Id, Nr : Word ) : Word;
begin
        Result := 0;

        if Nr = 0 then begin
                Case Palanthir.Shard.GetAnimRecord( Id ).AnimTyp of
                        aHighDetailed : Result := 2;
                        aLowDetailed : Result := 8;
                        aPeople : Result := 21;
                end;
        end
        else begin
                Case Palanthir.Shard.GetAnimRecord( Id ).AnimTyp of
                        aHighDetailed : Result := 3;
                        aLowDetailed : Result := 12;
                        aPeople : Result := 22;
                end;
        end;
end;

procedure TAnimations.IncCache( BaseId : LongWord; Anim : Word; Hue : Integer; Frame : Word; Grayify : Boolean );
var     Id : LongWord;
begin
        Id := BaseId*175 + Anim;
        if Grayify then
                Hue := Color_Grayify;
        Cache.IncCount( Id, Hue, Frame );
end;

procedure TAnimations.DecCache( BaseId : LongWord; Anim : Word; Hue : Integer; Frame : Word; Grayify : Boolean );
var     Id : LongWord;
begin
        Id := BaseId*175 + Anim;
        if Grayify then
                Hue := Color_Grayify;        
        Cache.DecCount( Id, Hue, Frame );
end;

procedure TAnimations.Poll;
begin
        Cache.GarbageCollection;
        SitDownCache.GarbageCollection;
end;

end.
