unit uLoaderAnimdata;

interface

uses    Classes, SysUtils, Dialogs, uLoaderVerdata;

type    TAnimdataRecord = packed record
                Frames : array[0..63] of ShortInt;
                Unknown : Byte;
                Count : Byte;
                FrameInterval : Byte;
                FrameStart : Byte;
        end;

        TAnimdataArray = array[0..1] of TAnimdataRecord;
        PAnimdataArray = ^TAnimdataArray;

type    TAnimdata = Class
                private
                        Cache : PAnimdataArray;
                        CacheCount : Integer;
                public
                        constructor Create( baseDir, shardDir : String );
                        destructor Free;
                        function Exists( Id : Integer ) : Boolean;
                        function GetStartTime( Id : Integer ) : Integer;
                        function GetDelay( Id : Integer ) : Integer;
                        function GetCount( Id : Integer ) : Integer;
                        function GetFrame( Id : Integer; Count : Byte ) : Integer;
        end;

implementation

uses    uPalanthir;

constructor TAnimdata.Create( baseDir, shardDir : String );
var     mulStream : TFileStream;
        AnimdataRecord : TAnimdataRecord;
        Id, I : Integer;
begin
        if FileExists( shardDir + 'Animdata.mul' ) then
                mulStream := TFileStream.Create( shardDir + 'Animdata.mul', fmOpenRead + fmShareDenyNone )
        else
                mulStream := TFileStream.Create( baseDir + 'Animdata.mul', fmOpenRead + fmShareDenyNone );
        mulStream.Seek( 0, soFromBeginning );

        CacheCount := ( mulStream.Size div ( sizeof( TAnimdataRecord )*8+4 ) )*8;
        GetMem( Cache, CacheCount*sizeof( TAnimdataRecord ) );

        Id := 0;
        while mulStream.Position < mulStream.Size do begin
                mulStream.Seek( 4, soFromCurrent );
                for I := 0 to 7 do begin
                        mulStream.Read( AnimdataRecord, sizeof( TAnimdataRecord ) );
                        Cache^[ Id ] := AnimdataRecord;
                        Inc( Id );
                end;
        end;
        mulStream.Free;
end;

destructor TAnimdata.Free;
begin
        FreeMem( Cache );
end;

function TAnimdata.Exists( Id : Integer ) : Boolean;
begin
        Result := ( Cache^[ Id ].Count > 0 ) and ( Cache^[ Id ].FrameInterval > 0 );
end;

function TAnimdata.GetStartTime( Id : Integer ) : Integer;
begin
        Result := Cache^[ Id ].FrameStart;
end;

function TAnimdata.GetDelay( Id : Integer ) : Integer;
begin
        Result := Cache^[ Id ].FrameInterval;
end;

function TAnimdata.GetCount( Id : Integer ) : Integer;
begin
        Result := Cache^[ Id ].Count;
end;

function TAnimdata.GetFrame( Id : Integer; Count : Byte ) : Integer;
begin
        Result := Id + Cache^[ Id ].Frames[ Count ];
end;

end.
