unit uLoaderCliloc;

interface

uses    uConfig, Classes, SysUtils, Dialogs, MD5, uLog;

type    TCliloc = Class
                private
                        enuStream, langStream : TFileStream;
                        enuCache, langCache : TFileStream;
                public
                        constructor Create( baseDir, shardDir : String );
                        destructor Free;
                        function GetClilocMessage( Id : LongWord ) : String;
        end;

implementation

constructor TCliloc.Create( baseDir, shardDir : String );
var     langFileName, enuFileName : String;
        Passt : Boolean;
        H1, H2, H3, H4 : Integer;
        LastId : Integer;
        LookUp, Id, I, Tmp : LongWord;
        Digest : TMD5Digest;
        Group, LastGroup, Count : Word;
        Unknown : Byte;
begin
        enuFileName := 'Cliloc.enu';
        if not ( FileExists( baseDir + enuFileName ) or FileExists( shardDir + enuFileName ) ) then begin
                enuStream := nil;
                enuCache := nil;
        end
        else begin
                if FileExists( shardDir + enuFileName ) then begin
                        Digest := Md5File( shardDir + enuFileName );
                        enuStream := TFileStream.Create( shardDir + enuFileName, fmOpenRead + fmShareDenyNone );
                end
                else if FileExists( baseDir + enuFileName ) then begin
                        Digest := Md5File( baseDir + enuFileName );
                        enuStream := TFileStream.Create( baseDir + enuFileName, fmOpenRead + fmShareDenyNone );
                end
                else begin
                        enuStream := nil;
                        enuCache := nil;
                end;

                if enuStream <> nil then begin
                        Passt := False;
                        if FileExists( shardDir + 'enuClilocCache.bin' ) then begin
                                enuCache := TFileStream.Create( shardDir + 'enuClilocCache.bin', fmOpenRead + fmShareDenyNone );
                                enuCache.Seek( 0, soFromBeginning );
                                enuCache.Read( H1, 4 );
                                enuCache.Read( H2, 4 );
                                enuCache.Read( H3, 4 );
                                enuCache.Read( H4, 4 );

                                if (Digest.A <> H1) or (Digest.B <> H2) or (Digest.C <> H3) or (Digest.D <> H4) then begin
                                        enuCache.Free;
                                        DeleteFile( shardDir + 'enuClilocCache.bin' );
                                end
                                else begin
                                        Passt := True;
                                end;
                        end;

                        if not Passt then begin
                                log.Write( 'Creating Cliloc Cachefile: ' + enuFileName );
                                enuCache := TFileStream.Create( shardDir + 'enuClilocCache.bin', fmCreate );
                                enuCache.Seek( 0, soFromBeginning );
                                enuCache.Write( Digest.A, 4 );
                                enuCache.Write( Digest.B, 4 );
                                enuCache.Write( Digest.C, 4 );
                                enuCache.Write( Digest.D, 4 );

                                LookUp := 28;
                                enuCache.Write( LookUp, 4 );
                                enuCache.Write( LookUp, 4 );
                                enuCache.Write( LookUp, 4 );

                                LastGroup := 1;
                                LastId := -1;

                                enuStream.Seek( 6, soFromBeginning );
                                while enuStream.Position < enuStream.Size do begin
                                        enuStream.Read( Id, 4 );
                                        Group := Id div 500000;
                                        if Group <> LastGroup then begin
                                                LookUp := enuCache.Position;
                                                if Group = 2 then
                                                        enuCache.Seek( 20, soFromBeginning )
                                                else if Group = 6 then
                                                        enuCache.Seek( 24, soFromBeginning )
                                                else
                                                        log.Write( 'Bug loading ' + enuFileName );
                                                enuCache.Write( LookUp, 4 );
                                                enuCache.Seek( 0, soFromEnd );
                                                LastId := -1;
                                        end;
                                        LastGroup := Group;

                                        Id := Id mod 500000;
                                        if Id > LastId+1 then begin
                                                for I := LastId+1 to Id-1 do begin
                                                        Tmp := $FFFFFFFF;
                                                        enuCache.Write( Tmp, 4 );
                                                end;
                                        end;
                                        LastId := Id;
                                        Tmp := enuStream.Position +1;
                                        enuCache.Write( Tmp, 4 );

                                        enuStream.Read( Unknown, 1 );
                                        enuStream.Read( Count, 2 );
                                        enuStream.Seek( Count, soFromCurrent );
                                end;
                        end;
                end;
        end;

        langFileName := 'Cliloc.' + Config.GetString( 'Language' );
        if (not ( FileExists( baseDir + langFileName ) or FileExists( shardDir + langFileName ) )) or (langFileName = enuFileName) then begin
                langStream := nil;
                langCache := nil;
        end
        else begin
                if FileExists( shardDir + langFileName ) then begin
                        Digest := Md5File( shardDir + langFileName );
                        langStream := TFileStream.Create( shardDir + langFileName, fmOpenRead + fmShareDenyNone );
                end
                else if FileExists( baseDir + langFileName ) then begin
                        Digest := Md5File( baseDir + langFileName );
                        langStream := TFileStream.Create( baseDir + langFileName, fmOpenRead + fmShareDenyNone );
                end
                else begin
                        langStream := nil;
                        langCache := nil;
                end;

                if langStream <> nil then begin
                        Passt := False;
                        if FileExists( shardDir + 'langClilocCache.bin' ) then begin
                                langCache := TFileStream.Create( shardDir + 'langClilocCache.bin', fmOpenRead + fmShareDenyNone );
                                DeleteFile( shardDir + 'langClilocCache.bin' );                                
                                langCache.Seek( 0, soFromBeginning );
                                langCache.Read( H1, 4 );
                                langCache.Read( H2, 4 );
                                langCache.Read( H3, 4 );
                                langCache.Read( H4, 4 );

                                if (Digest.A <> H1) or (Digest.B <> H2) or (Digest.C <> H3) or (Digest.D <> H4) then begin
                                        langCache.Free;
                                end
                                else begin
                                        Passt := True;
                                end;
                        end;

                        if not Passt then begin
                                log.Write( 'Creating Cliloc Cachefile: ' + langFileName );
                                langCache := TFileStream.Create( shardDir + 'langClilocCache.bin', fmCreate );
                                langCache.Seek( 0, soFromBeginning );
                                langCache.Write( Digest.A, 4 );
                                langCache.Write( Digest.B, 4 );
                                langCache.Write( Digest.C, 4 );
                                langCache.Write( Digest.D, 4 );

                                LookUp := 28;
                                langCache.Write( LookUp, 4 );
                                langCache.Write( LookUp, 4 );
                                langCache.Write( LookUp, 4 );

                                LastGroup := 1;
                                LastId := -1;

                                langStream.Seek( 6, soFromBeginning );
                                while langStream.Position < langStream.Size do begin
                                        langStream.Read( Id, 4 );
                                        Group := Id div 500000;
                                        if Group <> LastGroup then begin
                                                LookUp := langCache.Position;
                                                if Group = 2 then
                                                        langCache.Seek( 20, soFromBeginning )
                                                else if Group = 6 then
                                                        langCache.Seek( 24, soFromBeginning )
                                                else
                                                        log.Write( 'Bug loading ' + langFileName );
                                                langCache.Write( LookUp, 4 );
                                                langCache.Seek( 0, soFromEnd );
                                                LastId := -1;
                                        end;
                                        LastGroup := Group;

                                        Id := Id mod 500000;
                                        if Id > LastId+1 then begin
                                                for I := LastId+1 to Id-1 do begin
                                                        Tmp := $FFFFFFFF;
                                                        langCache.Write( Tmp, 4 );
                                                end;
                                        end;
                                        LastId := Id;
                                        Tmp := langStream.Position +1;
                                        langCache.Write( Tmp, 4 );

                                        langStream.Read( Unknown, 1 );
                                        langStream.Read( Count, 2 );
                                        langStream.Seek( Count, soFromCurrent );
                                end;
                        end;
                end;
        end;
end;

destructor TCliloc.Free;
begin
        if enuStream <> nil then
                enuStream.Free;
        if langStream <> nil then
                langStream.Free;
        if enuCache <> nil then
                enuCache.Free;
        if langCache <> nil then
                langCache.Free;
end;

function TCliloc.GetClilocMessage( Id : LongWord ) : String;
var     I : Integer;
        Group : Word;
        EffId, LookUp : LongWord;
        Count : Word;
        Gefunden : Boolean;
        Buchstabe : Byte;
begin
        Gefunden := False;
        Result := '';

        Group := Id div 500000;
        EffId := Id mod 500000;

        if langCache <> nil then begin
                case Group of
                        1 : langCache.Seek( 16, soFromBeginning );
                        2 : langCache.Seek( 20, soFromBeginning );
                        6 : langCache.Seek( 24, soFromBeginning );
                else
                        Result := '';
                        Exit;
                end;
                langCache.Read( LookUp, 4 );
                langCache.Seek( LookUp + 4*EffId, soFromBeginning );
                langCache.Read( LookUp, 4 );
                if LookUp <> $FFFFFFFF then begin
                        Gefunden := True;

                        langStream.Seek( LookUp, soFromBeginning );
                        langStream.Read( Count, 2 );

                        I := 0;
                        while I < Count do begin
                                langStream.Read( Buchstabe, 1 );
                                Result := Result + Chr( Buchstabe );
                                Inc( I );
                        end;
                        Result := Utf8Decode( Result );                         
                end;
        end;

        if (enuCache <> nil) and (not Gefunden) then begin
                case Group of
                        1 : enuCache.Seek( 16, soFromBeginning );
                        2 : enuCache.Seek( 20, soFromBeginning );
                        6 : enuCache.Seek( 24, soFromBeginning );
                else
                        Result := '';
                        Exit;                        
                end;
                enuCache.Read( LookUp, 4 );
                enuCache.Seek( LookUp + 4*EffId, soFromBeginning );
                enuCache.Read( LookUp, 4 );
                if LookUp <> $FFFFFFFF then begin

                        enuStream.Seek( LookUp, soFromBeginning );
                        enuStream.Read( Count, 2 );

                        I := 0;
                        while I < Count do begin
                                enuStream.Read( Buchstabe, 1 );
                                Result := Result + Chr( Buchstabe );
                                Inc( I );
                        end;
                        Result := Utf8Decode( Result );
                end;
        end;
end;

end.
