unit uLoaderFonts;

interface

uses    SysUtils, uUtilities, Classes, Dialogs, uLoaderHues, uTexCache, Math,
        uLog, uRenderer;

const   Whitespace = 3;

type    TBuchstabe = Record
                Hoehe, Breite, Header, Nr : Byte;
                Exists : Boolean;
                Image : PByteArray;
        end;

        TBuchstabenImage = Record
                Hoehe, Breite : Byte;
                Image : PByteArray;
        end;

        TLine = Record
                Text : String;
                Breite, Hoehe : Word;
        end;

        TFont = Class
                public
                        Buchstabe : array[0..223] of TBuchstabe;
                        MaxHoehe : Byte;
                        constructor Create;
                        destructor Free;
        end;

        TFonts = Class
                private
                        FontList : TList;
                public
                        constructor Create( baseDir, shardDir : String );
                        destructor Free;
                        function GetFont( Id, Buchstabe : Byte; Hue : Word ) : TBuchstabenImage;
                        function GetBreite( Id, Buchstabe : Byte ) : Word;
                        function GetHoehe( Id, Buchstabe : Byte ) : Word;                        
                        function GetFontMaxHoehe( Id : Byte ) : Byte;
                        function GetAsciiTexture( FontNr : Byte; Text : String; Hue : Word; MaxBreite : Word; MaxLines : Word; DivHeight : Integer ) : TTexObject;
        end;

implementation

constructor TFont.Create;
begin
end;

destructor TFont.Free;
begin
end;

constructor TFonts.Create( baseDir, shardDir : String );
var     Font : TFont;
        I, J, X, Y : Integer;
        mulStream : TFileStream;
        Color : Word;
begin
        FontList := TList.Create;

        if FileExists( shardDir + 'Fonts.mul' ) then
                mulStream := TFileStream.Create( shardDir + 'Fonts.mul', fmOpenRead + fmShareDenyNone )
        else
                mulStream := TFileStream.Create( baseDir + 'Fonts.mul', fmOpenRead + fmShareDenyNone );

        mulStream.Seek( 0, soFromBeginning );

        while mulStream.Position < mulStream.Size do begin
                Font := TFont.Create;
                mulStream.Seek( 1, soFromCurrent );
                Font.MaxHoehe := 0;
                for I := 0 to 223 do begin
                        mulStream.Read( Font.Buchstabe[ I ].Breite, 1 );
                        mulStream.Read( Font.Buchstabe[ I ].Hoehe, 1 );
                        mulStream.Read( Font.Buchstabe[ I ].Header, 1 );

                        if Font.Buchstabe[ I ].Hoehe > Font.MaxHoehe then
                                Font.MaxHoehe := Font.Buchstabe[ I ].Hoehe;

                        Font.Buchstabe[ I ].Nr := I;
                        Font.Buchstabe[ I ].Exists := False;

                        if (Font.Buchstabe[ I ].Hoehe > 0) and (Font.Buchstabe[ I ].Breite > 0) then begin
                                Font.Buchstabe[ I ].Exists := True;                        
                                GetMem( Font.Buchstabe[ I ].Image, Font.Buchstabe[ I ].Hoehe*Font.Buchstabe[ I ].Breite*4 );
                                for J := 0 to Font.Buchstabe[ I ].Hoehe*Font.Buchstabe[ I ].Breite*4-1 do
                                        Font.Buchstabe[ I ].Image^[ J ] := 0;

                                for Y := Font.Buchstabe[ I ].Hoehe-1 downto 0 do
                                        for X := 0 to Font.Buchstabe[ I ].Breite-1 do begin
                                                mulStream.Read( Color, 2 );
                                                if (Color <> 0) then begin
                                                        Font.Buchstabe[ I ].Image^[ (Y * Font.Buchstabe[ I ].Breite + X)*4 ] := Color15toRed( Color );
                                                        Font.Buchstabe[ I ].Image^[ (Y * Font.Buchstabe[ I ].Breite + X)*4+1 ] := Color15toGreen( Color );
                                                        Font.Buchstabe[ I ].Image^[ (Y * Font.Buchstabe[ I ].Breite + X)*4+2 ] := Color15toBlue( Color );
                                                        if Color <> 4196 then
                                                                Font.Buchstabe[ I ].Image^[ (Y * Font.Buchstabe[ I ].Breite + X)*4+3 ] := 255
                                                        else
                                                                Font.Buchstabe[ I ].Image^[ (Y * Font.Buchstabe[ I ].Breite + X)*4+3 ] := 254;
                                                end;
                                        end;
                        end
                        else
                                Font.Buchstabe[ I ].Image := nil;
                end;
                FontList.Add( Font );
        end;
        mulStream.Free;
end;

destructor TFonts.Free;
var     I, J : Integer;
        Font : TFont;
begin
        if FontList.Count > 0 then
                for I := 0 to FontList.Count-1 do begin
                        Font := TFont( FontList.Items[ I ] );
                        for J := 0 to 223 do
                                if Font.Buchstabe[J].Exists then begin
                                        FreeMem( Font.Buchstabe[J].Image );
                                end;
                        Font.Free;
                end;
        FontList.Free;
end;

function TFonts.GetFont( Id, Buchstabe : Byte; Hue : Word ) : TBuchstabenImage;
var     Font : TFont;
        X, Y : Integer;
        Red : Byte;
begin
        Buchstabe := Buchstabe - 32;

        if ( Buchstabe > 96 ) and ( Id < 4 ) then
                Id := 7;

        Font := TFont( FontList.Items[ Id ] );

        if not Font.Buchstabe[ Buchstabe ].Exists then begin
                Result.Hoehe := 0;
                Result.Breite := 0;
                Result.Image := nil;
                exit;
        end;

        Result.Hoehe := Font.Buchstabe[ Buchstabe ].Hoehe;
        Result.Breite := Font.Buchstabe[ Buchstabe ].Breite;
        GetMem( Result.Image, Result.Hoehe*Result.Breite*4 );

        for Y := 0 to Result.Hoehe-1 do begin
                for X := 0 to Result.Breite-1 do begin
                        if Font.Buchstabe[ Buchstabe ].Image^[ (Y*Result.Breite + X)*4 +3 ] <> 0 then begin
                                if (Hue > 0) then begin
                                        Red := Font.Buchstabe[ Buchstabe ].Image^[ (Y*Result.Breite + X)*4 ] div 8;
                                        if Red < 5 then
                                                Red := 0
                                        else
                                                Red := 31;
                                        Result.Image^[ (Y*Result.Breite + X)*4 ] := Color15toRed( Hues.GetColor( Hue, Red ) );
                                        Result.Image^[ (Y*Result.Breite + X)*4 +1 ] := Color15toGreen( Hues.GetColor( Hue, Red ) );
                                        Result.Image^[ (Y*Result.Breite + X)*4 +2 ] := Color15toBlue( Hues.GetColor( Hue, Red ) );
                                end
                                else begin
                                        Result.Image^[ (Y*Result.Breite + X)*4 ] := Font.Buchstabe[ Buchstabe ].Image^[ (Y*Result.Breite + X)*4 ];
                                        Result.Image^[ (Y*Result.Breite + X)*4 +1 ] := Font.Buchstabe[ Buchstabe ].Image^[ (Y*Result.Breite + X)*4 +1 ];
                                        Result.Image^[ (Y*Result.Breite + X)*4 +2 ] := Font.Buchstabe[ Buchstabe ].Image^[ (Y*Result.Breite + X)*4 +2 ];
                                end;
                                Result.Image^[ (Y*Result.Breite + X)*4 +3 ] := 255;
                        end
                        else begin
                                Result.Image^[ (Y*Result.Breite + X)*4 ] := 0;
                                Result.Image^[ (Y*Result.Breite + X)*4 +1 ] := 0;
                                Result.Image^[ (Y*Result.Breite + X)*4 +2 ] := 0;
                                Result.Image^[ (Y*Result.Breite + X)*4 +3 ] := 0;
                        end;
                end;
        end;
end;

function TFonts.GetFontMaxHoehe( Id : Byte ) : Byte;
var     Font : TFont;
begin
        Font := TFont( FontList.Items[ Id ] );

        Result := Font.MaxHoehe;
end;

function TFonts.GetBreite( Id, Buchstabe : Byte ) : Word;
var     Font : TFont;
begin
        Buchstabe := Buchstabe - 32;
        
        if ( Buchstabe > 96 ) and ( Id < 4 ) then
                Id := 7;

        Font := TFont( FontList.Items[ Id ] );

        if not Font.Buchstabe[ Buchstabe ].Exists then begin
                Result := 0;
                Exit;
        end;

        Result := Font.Buchstabe[ Buchstabe ].Breite;
end;

function TFonts.GetHoehe( Id, Buchstabe : Byte ) : Word;
var     Font : TFont;
begin
        Buchstabe := Buchstabe - 32;
        
        if ( Buchstabe > 96 ) and ( Id < 4 ) then
                Id := 7;

        Font := TFont( FontList.Items[ Id ] );

        if not Font.Buchstabe[ Buchstabe ].Exists then begin
                Result := 0;
                Exit;                
        end;

        Result := Font.Buchstabe[ Buchstabe ].Hoehe;
end;

function TFonts.GetAsciiTexture( FontNr : Byte; Text : String; Hue : Word; MaxBreite : Word; MaxLines : Word; DivHeight : Integer ) : TTexObject;
var     CurLine, Breite, Hoehe : Word;
        TmpBreite, TmpHoehe : Word;
        TmpText : String;
        I, J, PX, PY, X, Y : Integer;
        Count, CopyCount, Source, Target : Integer;
        Pixel : PByteArray;
        BImage : TBuchstabenImage;
        Lines : Array of TLine;
        RBreite, RHoehe : Word;
        UsedLines : Word;
        LineCount : Word;
        MinHoehe : Word;
begin
        //Besser mal beschrnken
        MaxLines := Min( MaxLines, 100 );

        if Text = '' then begin
                Result := nil;
                exit;
        end;

        if (MaxLines = 0) or (MaxBreite = 0) then begin
                Result := nil;
                exit;
        end;

        SetLength( Lines, MaxLines );
        Breite := 0;
        Hoehe := 0;

        TmpBreite := 0;
        TmpHoehe := 0;
        TmpText := '';
        CurLine := 0;

        MinHoehe := GetFontMaxHoehe( FontNr ) + DivHeight;

        Lines[ CurLine ].Text := '';
        Lines[ CurLine ].Breite := 2;
        Lines[ CurLine ].Hoehe := MinHoehe;

        I := 1;
        while I <= Length( Text ) do begin
                if Text[ I ] = #10 then begin
                        if CurLine < MaxLines-1 then begin
                                Lines[ CurLine ].Text := Lines[ CurLine ].Text + TmpText;
                                Lines[ CurLine ].Breite := Lines[ CurLine ].Breite + TmpBreite;
                                if Lines[ CurLine ].Hoehe < TmpHoehe then
                                        Lines[ CurLine ].Hoehe := TmpHoehe;

                                TmpText := '';
                                TmpBreite := 0;
                                TmpHoehe := MinHoehe;

                                if Lines[ CurLine ].Breite > Breite then
                                        Breite := Lines[ CurLine ].Breite;
                                        Hoehe := Hoehe + Lines[ CurLine ].Hoehe;

                                Inc( CurLine );
                                Lines[ CurLine ].Text := '';
                                Lines[ CurLine ].Breite := 2;
                                Lines[ CurLine ].Hoehe := MinHoehe;
                        end;
                end
                else if Text[ I ] = ' ' then begin
                        Lines[ CurLine ].Text := Lines[ CurLine ].Text + TmpText;
                        Lines[ CurLine ].Breite := Lines[ CurLine ].Breite + TmpBreite + WhiteSpace;
                        if Lines[ CurLine ].Hoehe < TmpHoehe then
                                Lines[ CurLine ].Hoehe := TmpHoehe;

                        TmpText := '';
                        TmpBreite := 0;
                        TmpHoehe := MinHoehe;

                        if Lines[ CurLine ].Breite + WhiteSpace <= MaxBreite then begin
                                Lines[ CurLine ].Text := Lines[ CurLine ].Text + ' ';
                        end
                        else begin
                                if CurLine < MaxLines-1 then begin
                                        if Lines[ CurLine ].Breite > Breite then
                                                Breite := Lines[ CurLine ].Breite;
                                        Hoehe := Hoehe + Lines[ CurLine ].Hoehe;

                                        Inc( CurLine );
                                        Lines[ CurLine ].Text := '';
                                        Lines[ CurLine ].Breite := 2;
                                        Lines[ CurLine ].Hoehe := MinHoehe;
                                end
                                else begin
                                        if Lines[ CurLine ].Breite > Breite then
                                                Breite := Lines[ CurLine ].Breite;
                                        Hoehe := Hoehe + Lines[ CurLine ].Hoehe;
                                        Break;
                                end;
                        end;
                end
                else begin
                        if Lines[ CurLine ].Breite + TmpBreite + GetBreite( FontNr, Ord( Text[ I ] ) ) > MaxBreite then begin
                                if Lines[ CurLine ].Text = '' then begin
                                        Lines[ CurLine ].Text := TmpText;
                                        Lines[ CurLine ].Breite := Lines[ CurLine ].Breite + TmpBreite + WhiteSpace;
                                        if Lines[ CurLine ].Hoehe < TmpHoehe then
                                                Lines[ CurLine ].Hoehe := TmpHoehe;

                                        TmpText := '';
                                        TmpBreite := 0;
                                        TmpHoehe := MinHoehe;
                                end;

                                if CurLine < MaxLines-1 then begin
                                        if Lines[ CurLine ].Breite > Breite then
                                                Breite := Lines[ CurLine ].Breite;
                                        Hoehe := Hoehe + Lines[ CurLine ].Hoehe;

                                        Inc( CurLine );
                                        Lines[ CurLine ].Text := '';
                                        Lines[ CurLine ].Breite := 2;
                                        Lines[ CurLine ].Hoehe := MinHoehe;
                                end
                                else begin
                                        if TmpText <> '' then begin
                                                Lines[ CurLine ].Text := Lines[ CurLine ].Text + TmpText;
                                                Lines[ CurLine ].Breite := Lines[ CurLine ].Breite + TmpBreite + WhiteSpace;
                                                if Lines[ CurLine ].Hoehe < TmpHoehe then
                                                        Lines[ CurLine ].Hoehe := TmpHoehe;
                                        end;

                                        if Lines[ CurLine ].Breite > Breite then
                                                Breite := Lines[ CurLine ].Breite;
                                        Hoehe := Hoehe + Lines[ CurLine ].Hoehe;
                                        Break;
                                end;
                        end;
                        TmpText := TmpText + Text[ I ];
                        TmpBreite := TmpBreite + GetBreite( FontNr, Ord( Text[ I ] ) );
                        if TmpHoehe < GetHoehe( FontNr, Ord( Text[ I ] ) ) then
                                TmpHoehe := GetHoehe( FontNr, Ord( Text[ I ] ) );
                end;

                if I = Length( Text ) then begin
                        Lines[ CurLine ].Text := Lines[ CurLine ].Text + TmpText;
                        Lines[ CurLine ].Breite := Lines[ CurLine ].Breite + TmpBreite + WhiteSpace;
                        if Lines[ CurLine ].Hoehe < TmpHoehe then
                                Lines[ CurLine ].Hoehe := TmpHoehe;

                        if Lines[ CurLine ].Breite > Breite then
                                Breite := Lines[ CurLine ].Breite;
                        Hoehe := Hoehe + Lines[ CurLine ].Hoehe;
                end;

                Inc( I );
        end;

        UsedLines := CurLine;

        if Breite = 0 then begin
                Result := nil;
                exit;
        end;

        RBreite := GetNextBit( Breite );
        RHoehe := GetNextBit( Hoehe );

        Count := RBreite*RHoehe*4;
        GetMem( Pixel, Count );

        for I := 0 to Count-1 do
                Pixel^[ I ] := 0;

        Y := 0;

        LineCount := 0;
        if Text <> '' then for J := 0 to UsedLines do begin
                if Lines[ J ].Text = '' then begin
                        Inc( LineCount );
                        continue;
                end
                else if (J > 0) then begin
                        Y := Y + LineCount*MinHoehe;
                        LineCount := 0;
                        Y := Y + Lines[ J-1 ].Hoehe + DivHeight;
                end;

                X := 0;
                for I := 1 to Length( Lines[ J ].Text ) do begin
                        if Lines[ J ].Text[ I ] = ' ' then begin
                                X := X + 3;
                                continue;
                        end;

                        BImage := GetFont( FontNr, Ord( Lines[ J ].Text[ I ] ), Hue );

                        if BImage.Image = nil then
                                continue;

                        Source := BImage.Hoehe*BImage.Breite*4;
                        Target := (Y*RBreite + X)*4;
                        CopyCount := BImage.Breite*4;

                        for PY := 0 to BImage.Hoehe-1 do begin
                                if Target + CopyCount >= Count then begin
                                        Log.Write( 'Bug in uLoaderFonts:' );
                                        Log.Write( Format( 'S: Height: %d  Width: %d  PY: %d', [BImage.Hoehe,BImage.Breite,PY] ) );
                                        Log.Write( Format( 'T: Height: %d  Width: %d', [RHoehe,RBreite] ) );
                                        continue;
                                end;

                                Source := Source - BImage.Breite*4;
                                Move( BImage.Image^[ Source+4 ], Pixel^[ Target+4 ], CopyCount-4 );
                                if (Pixel^[ Target+3 ] = 0) then
                                        Move( BImage.Image^[ Source ], Pixel^[ Target ], 4 );

                                Target := Target + RBreite*4;
                        end;
                        X := X + BImage.Breite;
                        FreeMem( BImage.Image );
                end;
        end;

        Result := Renderer.CreateTexture32( Tex_Fonts, Breite, Hoehe, Pixel );
        Renderer.CurrentTexID := Result.TexID;
        FreeMem( Pixel );
end;

end.
