unit uLoaderGump;

interface

uses    Classes, SysUtils, uUtilities, Dialogs, uLoaderHues, uTexCache, dglOpenGL,
        uLog, uBitMask, uLoaderVerdata, uRenderer, uLoaderProgress;

type    TGumps = Class
                private
                        idxBaseStream, mulBaseStream, idxShardStream, mulShardStream : TFileStream;
                        Cache : TTexCache;
                        function LoadGump( Id, Hue : Word ) : TTexObject;
                public
                        constructor Create( baseDir, shardDir : String );
                        destructor Free;
                        function GetGumpObject( Id, Hue : Word ) : TTexObject;
                        function GetRadarcolTexture( Id : Word ) : TTexObject;
                        procedure IncCache( Id, Hue : Word );
                        procedure DecCache( Id, Hue : Word );
        end;

implementation

uses    uPalanthir;

constructor TGumps.Create( baseDir, shardDir : String );
begin
        idxBaseStream := TFileStream.Create( baseDir + 'Gumpidx.mul', fmOpenRead + fmShareDenyNone );
        mulBaseStream := TFileStream.Create( baseDir + 'Gumpart.mul', fmOpenRead + fmShareDenyNone );
        if FileExists( shardDir + 'Gumpidx.mul' ) then
                idxShardStream := TFileStream.Create( shardDir + 'Gumpidx.mul', fmOpenRead + fmShareDenyNone )
        else
                idxShardStream := nil;
        if FileExists( shardDir + 'Gumpart.mul' ) then
                mulShardStream := TFileStream.Create( shardDir + 'Gumpart.mul', fmOpenRead + fmShareDenyNone )
        else
                mulShardStream := nil;
        Cache := TTexCache.Create;
        Cache.AutoDelete := False;
end;

destructor TGumps.Free;
begin
        idxBaseStream.Free;
        mulBaseStream.Free;
        if idxShardStream <> nil then
                idxShardStream.Free;
        if mulShardStream <> nil then
                mulShardStream.Free;
        Cache.Free;
end;

function TGumps.LoadGump( Id, Hue : Word ) : TTexObject;
var     I, J, X, Y, Start, Size : Integer;
        Hoehe, Breite, Color : Word;
        Count : Longword;
        IndexRecord : TIndexRecord;
        LookupList : PIntegerArray;
        Gump : PByteArray;
        Red, Green, Blue : Byte;
        PartialHue : Boolean;
        RealHue : Word;
        Buffer : Array[0..2047] of Record Value, Run : Word; end;
        mulStream : TStream;
        Gefunden : Boolean;
        Position : Integer;
        RBreite, RHoehe : Word;
        VerdataEntry : TVerdataEntry;
        ProgressImage : TProgressImage;
begin
        ProgressImage := Palanthir.Data.Progress.GetGump( Id, Hue );
        if ProgressImage <> nil then begin
                Result := Renderer.CreateTexture32( Tex_Gump, ProgressImage.Width, ProgressImage.Height, ProgressImage.Data, Id, Hue );
                ProgressImage.Free;
                Result.HasAlpha := True;
                Renderer.CurrentTexID := Result.TexID;
                Cache.AddObject( Result );
                Exit;
        end;

        VerdataEntry := Palanthir.Data.Verdata.GetGump( Id );
        if VerdataEntry <> nil then begin
                IndexRecord := VerdataEntry.IndexRecord;
                if (IndexRecord.Offset = -1) or (IndexRecord.Length = -1) then begin
                        Result := nil;
                        exit;
                end;
                mulStream := VerdataEntry.mulStream;
        end
        else begin
                Gefunden := False;
                if (idxShardStream <> nil) and (mulShardStream <> nil) then begin
                        if Id*12 >= idxShardStream.Size then begin
                                Result := nil;
                                exit;
                        end;

                        idxShardStream.Seek( Id*12, soFromBeginning );
                        idxShardStream.Read( IndexRecord, 12 );

                        if Palanthir.MulEncryption then begin
                                if Palanthir.Data.MulCrypt.DecryptIndexRecordGump( Id, IndexRecord ) then begin
                                        if (IndexRecord.Offset <> -1) and (IndexRecord.Length <> -1) then begin
                                                Gefunden := True;
                                                mulStream := mulShardStream;
                                        end
                                        else begin
                                                Result := nil;
                                                exit;
                                        end;
                                end
                                else begin
                                        Log.Write( 'Not able to decrypt Gump.', True );
                                        Halt;
                                end;
                        end
                        else begin
                                if (IndexRecord.Offset <> -1) and (IndexRecord.Length <> -1) then begin
                                        Gefunden := True;
                                        mulStream := mulShardStream;
                                end
                                else begin
                                        Result := nil;
                                        exit;
                                end;
                        end;
                end
                else begin
                        if Id*12 >= idxBaseStream.Size then begin
                                Result := nil;
                                exit;
                        end ;

                        idxBaseStream.Seek( Id*12, soFromBeginning );
                        idxBaseStream.Read( IndexRecord, 12 );
                        if (IndexRecord.Offset = -1) or (IndexRecord.Length = -1) then begin
                                Result := nil;
                                exit;
                        end;

                        mulStream := mulBaseStream;
                end;
                
                {Gefunden := False;
                if (idxShardStream <> nil) and (mulShardStream <> nil) and (Id*12 < idxShardStream.Size) then begin
                        idxShardStream.Seek( Id*12, soFromBeginning );
                        idxShardStream.Read( IndexRecord, 12 );
                        if (IndexRecord.Offset <> -1) and (IndexRecord.Length <> -1) then begin
                                Gefunden := True;
                                mulStream := mulShardStream;
                        end;
                end;

                if (not Gefunden) and (idxBaseStream <> nil) and (mulBaseStream <> nil) then begin
                        if Id*12 >= idxBaseStream.Size then begin
                                Result := nil;
                                exit;
                        end;

                        idxBaseStream.Seek( Id*12, soFromBeginning );
                        idxBaseStream.Read( IndexRecord, 12 );

                        if (IndexRecord.Offset = -1) or (IndexRecord.Length = -1) then begin
                                Result := nil;
                                exit;
                        end;

                        mulStream := mulBaseStream;
                end;}
        end;

        RealHue := Hue mod $4000;
        PartialHue := ( ( Hue and $8000 ) = $8000 );

        Breite := IndexRecord.Extra shr 16;
        Hoehe := IndexRecord.Extra and $FFFF;

        if (Breite = 0) or (Hoehe = 0) then begin
                Result := nil;
                Exit;
        end;

        RBreite := GetNextBit( Breite );
        RHoehe := GetNextBit( Hoehe );

        Count := RBreite*RHoehe*4;

        GetMem( Gump, Count );
        for I := 0 to Count-1 do
                Gump^[I] := 0;

        mulStream.Seek( IndexRecord.Offset, soFromBeginning );
        GetMem( LookupList, Hoehe*4 );
        Start := mulStream.Position;
        mulStream.Read( LookupList^, Hoehe*4 );

        Y := 0;
        while Y < Hoehe do begin
                if Y < Hoehe-1 then
                        Size := LookupList^[Y+1]-LookupList^[Y]
                else
                        Size := IndexRecord.Length div 4 - LookupList^[Y];

                mulStream.Seek( Start + LookupList^[Y]*4, soFromBeginning );

                X := 0;
                mulStream.Read( Buffer, Size*4 );
                for I := 0 to Size-1 do begin
                        J := X + Buffer[I].Run;
                        Position := (Y*RBreite + X)*4;
                        while X < J do begin
                                if (X < Breite) and (Y < Hoehe) and (X >= 0) and (Y >= 0) then begin
                                        Color := Buffer[I].Value;
                                        if Color > 0 then begin
                                                if RealHue > 0 then begin
                                                        Red := Color15toRed( Color );
                                                        Green := Color15toGreen( Color );
                                                        Blue := Color15toBlue( Color );
                                                        if ( PartialHue and (Red = Blue) and (Red = Green) ) or ( not PartialHue ) then begin
                                                                Red := Red div 8;
                                                                Gump^[ Position ] := Color15toRed( Hues.GetColor( RealHue, Red ) );
                                                                Gump^[ Position+1 ] := Color15toGreen( Hues.GetColor( RealHue, Red ) );
                                                                Gump^[ Position+2 ] := Color15toBlue( Hues.GetColor( RealHue, Red ) );
                                                        end
                                                        else begin
                                                                Gump^[ Position ] := Color15toRed( Color );
                                                                Gump^[ Position+1 ] := Color15toGreen( Color );
                                                                Gump^[ Position+2 ] := Color15toBlue( Color );
                                                        end;
                                                end
                                                else begin
                                                        Gump^[ Position ] := Color15toRed( Color );
                                                        Gump^[ Position+1 ] := Color15toGreen( Color );
                                                        Gump^[ Position+2 ] := Color15toBlue( Color );
                                                end;
                                                Gump^[ Position+3 ] := 255;
                                        end;
                                end;
                                Inc( X );
                                Inc( Position, 4 );
                        end;
                end;
                inc( Y );
        end;

        FreeMem( LookupList );


        Result := Renderer.CreateTexture32( Tex_Gump, Breite, Hoehe, Gump, Id, Hue );
        FreeMem( Gump );
        Renderer.CurrentTexID := Result.TexID;
        Cache.AddObject( Result );
end;

function TGumps.GetRadarcolTexture( Id : Word ) : TTexObject;
var     I, J, X, Y, Start, Size : Integer;
        Hoehe, Breite, Color : Word;
        Count : Longword;
        IndexRecord : TIndexRecord;
        LookupList : PIntegerArray;
        Gump : PByteArray;
        Buffer : Array[0..2047] of Record Value, Run : Word; end;
        mulStream : TStream;
        Position : Integer;
        RBreite, RHoehe : Word;
        VerdataEntry : TVerdataEntry;
        Gefunden : Boolean;
begin
        VerdataEntry := Palanthir.Data.Verdata.GetGump( Id );
        if VerdataEntry <> nil then begin
                IndexRecord := VerdataEntry.IndexRecord;
                if (IndexRecord.Offset = -1) or (IndexRecord.Length = -1) then begin
                        Result := nil;
                        exit;
                end;
                mulStream := VerdataEntry.mulStream;
        end
        else begin
                Gefunden := False;
                if (idxShardStream <> nil) and (mulShardStream <> nil) and (Id*12 < idxShardStream.Size) then begin
                        idxShardStream.Seek( Id*12, soFromBeginning );
                        idxShardStream.Read( IndexRecord, 12 );

                        if Palanthir.MulEncryption then begin
                                if Palanthir.Data.MulCrypt.DecryptIndexRecordGump( Id, IndexRecord ) then begin
                                        if (IndexRecord.Offset <> -1) and (IndexRecord.Length <> -1) then begin
                                                Gefunden := True;
                                                mulStream := mulShardStream;
                                        end;
                                end
                                else begin
                                        Log.Write( 'Not able to decrypt Gump.', True );
                                        Halt;
                                end;
                        end
                        else begin
                                if (IndexRecord.Offset <> -1) and (IndexRecord.Length <> -1) then begin
                                        Gefunden := True;
                                        mulStream := mulShardStream;
                                end;
                        end;
                end;

                if (not Gefunden) and (idxBaseStream <> nil) and (mulBaseStream <> nil) then begin
                        if Id*12 >= idxBaseStream.Size then begin
                                Result := nil;
                                exit;
                        end;

                        idxBaseStream.Seek( Id*12, soFromBeginning );
                        idxBaseStream.Read( IndexRecord, 12 );

                        if (IndexRecord.Offset = -1) or (IndexRecord.Length = -1) then begin
                                Result := nil;
                                exit;
                        end;

                        mulStream := mulBaseStream;
                end;
        end;

        Breite := IndexRecord.Extra shr 16;
        Hoehe := IndexRecord.Extra and $FFFF;
        RBreite := GetNextBit( Breite );
        RHoehe := GetNextBit( Hoehe );

        Count := RBreite*RHoehe;

        GetMem( Gump, Count );
        for I := 0 to ( Count-1 ) do
                Gump^[I] := 0;

        mulStream.Seek( IndexRecord.Offset, soFromBeginning );
        GetMem( LookupList, Hoehe*4 );
        Start := mulStream.Position;
        mulStream.Read( LookupList^, Hoehe*4 );

        Y := 0;
        while Y < Hoehe do begin
                if Y < Hoehe-1 then
                        Size := LookupList^[Y+1]-LookupList^[Y]
                else
                        Size := IndexRecord.Length div 4 - LookupList^[Y];

                mulStream.Seek( Start + LookupList^[Y]*4, soFromBeginning );

                X := 0;
                mulStream.Read( Buffer, Size*4 );
                for I := 0 to Size-1 do begin
                        J := X + Buffer[I].Run;
                        Position := Y*RBreite + X;
                        while X < J do begin
                                if (X < Breite) and (Y < Hoehe) and (X >= 0) and (Y >= 0) then begin
                                        Color := Buffer[I].Value;
                                        if ( Color15toRed( Color ) = 8 ) and ( Color15toGreen( Color ) = 8 ) and ( Color15toBlue( Color ) = 8 ) then begin
                                                Gump^[ Position ] := 255;
                                        end;
                                end;
                                Inc( X );
                                Inc( Position );
                        end;
                end;
                inc( Y );
        end;

        FreeMem( LookupList );

        Result := TTexObject.Create( Tex_Gump );
        Result.Hoehe := Hoehe;
        Result.Breite := Breite;
        Result.ID := 0;
        Result.Hue := 0;
        Result.Count := 0;

        glGenTextures( 1, @Result.TexID );
        glBindTexture( GL_TEXTURE_2D, Result.TexID );
        glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST );
        glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST );
        glTexImage2D( GL_TEXTURE_2D, 0, GL_ALPHA, RBreite, RHoehe, 0, GL_ALPHA, GL_UNSIGNED_BYTE, Gump );
        FreeMem( Gump );
        Renderer.CurrentTexID := Result.TexID;        
end;

function TGumps.GetGumpObject( Id, Hue : Word ) : TTexObject;
begin
        Result := Cache.GetTexObject( Id, Hue );

        if Result = nil then
                Result := LoadGump( Id, Hue );
end;

procedure TGumps.IncCache( Id, Hue : Word );
begin
        if Cache.GetTexObject( Id, Hue ) = nil then
                LoadGump( Id, Hue );
        Cache.IncCount( Id, Hue );
end;

procedure TGumps.DecCache( Id, Hue : Word );
begin
        Cache.DecCount( Id, Hue );
end;

end.
