unit uLoaderHues;

interface

uses uUtilities, SysUtils, Classes, Dialogs;

type    THueColorTable = array[0..31] of Word;
        THueName = array[0..19] of Char;

        THueEntry = packed record
                ColorTable : THueColorTable;
                TableStart, TableEnd : Word;
                Name : THueName;
        end;

        THueGroup = packed record
                Header : Integer;
                Entries : Array[0..7] of THueEntry;
        end;

        TColorTableArray = Array[0..1] of THueColorTable;
        PColorTableArray = ^TColorTableArray;

        THues = Class
                private
                        Cache : PColorTableArray;
                        HueCount : Integer;
                public
                        constructor Create( baseDir, shardDir : String );
                        destructor Free;
                        function GetColor( ColorId : Word; SubColor : Byte ) : Word;
        end;

var     Hues : THues;

implementation

constructor THues.Create( baseDir, shardDir : String );
var     mulFile : TFileStream;
        I, J : Integer;
        HueGroup : THueGroup;
begin
        if FileExists( shardDir + 'hues.mul' ) then
                mulFile := TFileStream.Create( shardDir + 'hues.mul', fmOpenRead + fmShareDenyNone )
        else
                mulFile := TFileStream.Create( baseDir + 'hues.mul', fmOpenRead + fmShareDenyNone );        
        HueCount := ( mulFile.Size div sizeof( THueGroup ) )*8;

        GetMem( Cache, sizeof( THueColorTable )*HueCount );
        I := 0;

        mulFile.Seek( 0, soFromBeginning );
        while mulFile.Position < mulFile.Size do begin
                mulFile.Read( HueGroup, sizeof( THueGroup ) );
                for J := 0 to 7 do begin
                        Cache^[ I*8 + J ] := HueGroup.Entries[J].ColorTable;
                end;
                inc( I );
        end;
        mulFile.Free;
end;

destructor THues.Free;
begin
        FreeMem( Cache );
end;

function THues.GetColor( ColorId : Word; SubColor : Byte ) : Word;
begin
        if SubColor > 31 then
                SubColor := 31;

        if (ColorId-1 >= HueCount) or (ColorId = 0) then
                Result := 0
        else
                Result := Cache^[ (ColorId-1) ][ SubColor ];
end;

end.
