unit uLoaderIntloc;

interface

uses    uUtilities, Classes, SysUtils, Dialogs, uConfig, uLog;

const   {IntlocForm = $4d524f46;
	IntlocInfo = $4f464e49;
	IntlocText = $54584554;
	IntlocData = $41544144;
	IntlocLang = $474e414c;}

        IntlocForm = $464f524d;
	IntlocInfo = $494e464f;
	IntlocText = $54455854;
	IntlocData = $44415441;
	IntlocLang = $4c414e47;

type    TIntloc = Class
                private
                        _baseDir, _shardDir : String;
                        Cache : TList;
                public
                        constructor Create( baseDir, shardDir : String );
                        destructor Free;
                        function GetMessage( FileNr : Byte; Id : Word ) : String;
        end;

        TIntlocCache = Class
                private
                        EnuCache, LangCache : TStringList;
                        _FileNr : Byte;
                public
                        property FileNr : Byte read _FileNr;
                        constructor Create( baseDir, shardDir : String; FileNr : Byte );
                        destructor Free;
                        function GetMessage( Id : Word ) : String;
        end;

implementation

constructor TIntloc.Create( baseDir, shardDir : String );
begin
        _baseDir := baseDir;
        _shardDir := shardDir;
        Cache := TList.Create;
end;

destructor TIntloc.Free;
var     I : Integer;
begin
        for I := 0 to Cache.Count-1 do begin
                TIntlocCache( Cache.Items[ I ] ).Free;
        end;
        Cache.Free;
end;

function TIntloc.GetMessage( FileNr : Byte; Id : Word ) : String;
var     I : Integer;
        IntlocCache : TIntlocCache;
begin
        for I := 0 to Cache.Count-1 do begin
                IntlocCache := TIntlocCache( Cache.Items[ I ] );
                if IntlocCache.FileNr = FileNr then begin
                        Result := IntlocCache.GetMessage( Id );
                        Exit;
                end;
        end;

        //not found
        IntlocCache := TIntlocCache.Create( _baseDir, _shardDir, FileNr );
        Cache.Add( IntlocCache );
        Result := IntlocCache.GetMessage( Id );
end;

constructor TIntlocCache.Create( baseDir, shardDir : String; FileNr : Byte );
var     FileStream : TFileStream;
        Typ, Length, StartPos : LongWord;
        Zeile : String;
        B : Byte;
begin
        LangCache := TStringList.Create;
        EnuCache := TStringList.Create;
        _FileNr := FileNr;

        if FileExists( Format( '%sIntloc%.2d.%s', [shardDir,FileNr,Config.GetString( 'Language' )] ) ) then begin
                FileStream := TFileStream.Create( Format( '%sIntloc%.2d.%s', [shardDir,FileNr,Config.GetString( 'Language' )] ), fmOpenRead );
        end else if FileExists( Format( '%sIntloc%.2d.%s', [baseDir,FileNr,Config.GetString( 'Language' )] ) ) then begin
                FileStream := TFileStream.Create( Format( '%sIntloc%.2d.%s', [baseDir,FileNr,Config.GetString( 'Language' )] ), fmOpenRead );
        end else begin
                FileStream := nil;
        end;

        if FileStream <> nil then begin
                FileStream.Seek( 0, soFromBeginning );

                while FileStream.Position < FileStream.Size do begin
                        FileStream.Read( Typ, 4 );
                        Typ := SwapBytes( Typ );

                        Case Typ of
                                IntlocData : begin
                                        continue;
                                        end;
                                IntlocForm : begin
                                        FileStream.Seek( 4, soFromCurrent );
                                        continue;
                                        end;
                                IntlocLang : begin
                                        continue;
                                        end;
                                IntlocInfo : begin
                                        FileStream.Read( Length, 4 );
                                        Length := SwapBytes( Length );
                                        FileStream.Seek( Length, soFromCurrent );
                                        end;
	                        IntlocText : begin
                                        FileStream.Read( Length, 4 );
                                        Length := SwapBytes( Length );
                                        StartPos := FileStream.Position;

                                        while FileStream.Position < StartPos + Length do begin
                                                Zeile := '';
                                                repeat
                                                        FileStream.Read( B, 1 );
                                                        if B > 0 then
                                                                Zeile := Zeile + Chr( B );
                                                until B = 0;

                                                Zeile := Utf8Decode( Zeile );
                                                LangCache.Add( Zeile );
                                        end;
                                        end;
                        end;
                end;

                FileStream.Free;
        end;

        if FileExists( Format( '%sIntloc%.2d.enu', [shardDir,FileNr] ) ) then begin
                FileStream := TFileStream.Create( Format( '%sIntloc%.2d.enu', [shardDir,FileNr] ), fmOpenRead );
        end else if FileExists( Format( '%sIntloc%.2d.enu', [baseDir,FileNr] ) ) then begin
                FileStream := TFileStream.Create( Format( '%sIntloc%.2d.enu', [baseDir,FileNr] ), fmOpenRead );
        end else begin
                FileStream := nil;
        end;

        if FileStream <> nil then begin
                FileStream.Seek( 0, soFromBeginning );

                while FileStream.Position < FileStream.Size do begin
                        FileStream.Read( Typ, 4 );
                        Typ := SwapBytes( Typ );

                        Case Typ of
                                IntlocData : begin
                                        FileStream.Seek( 8, soFromCurrent );      
                                        continue;
                                        end;
                                IntlocForm : begin
                                        FileStream.Seek( 4, soFromCurrent );
                                        continue;
                                        end;
                                IntlocLang : begin
                                        continue;
                                        end;
                                IntlocInfo : begin
                                        FileStream.Read( Length, 4 );
                                        Length := SwapBytes( Length );
                                        FileStream.Seek( Length+1, soFromCurrent );
                                        end;
	                        IntlocText : begin
                                        FileStream.Read( Length, 4 );
                                        Length := SwapBytes( Length );
                                        StartPos := FileStream.Position;

                                        while FileStream.Position < StartPos + Length do begin
                                                Zeile := '';
                                                repeat
                                                        FileStream.Read( B, 1 );
                                                        if B > 0 then
                                                                Zeile := Zeile + Chr( B );
                                                until B = 0;

                                                Zeile := Utf8Decode( Zeile );
                                                EnuCache.Add( Zeile );
                                        end;
                                        end;
                        end;
                end;

                FileStream.Free;
        end;

        Log.Write( Format( 'Intloc%2d loaded.', [FileNr] ) );
end;

destructor TIntlocCache.Free;
begin
        EnuCache.Free;
        LangCache.Free;
end;

function TIntlocCache.GetMessage( Id : Word ) : String;
begin
        if Id < LangCache.Count then begin
                Result := LangCache.Strings[ Id ];
        end else if Id < EnuCache.Count then begin
                Result := EnuCache.Strings[ Id ];
        end else begin
                Result := '';
        end;
end;

end.
