unit uLoaderRadarcol;

interface

uses    Classes, SysUtils, Dialogs;

type    TWordArray = Array[0..0] of Word;
        PWordArray = ^TWordArray;

        TRadarcol = Class
                private
                        Cache : PWordArray;
                        Count : Integer;
                public
                        constructor Create( baseDir, shardDir : String );
                        destructor Free;
                        function GetRadarColor( Id : Word ) : Word;
        end;

implementation

constructor TRadarcol.Create( baseDir, shardDir : String );
var     mulStream : TFileStream;
        I : Integer;
begin
        if FileExists( shardDir + 'Radarcol.mul' ) then
                mulStream := TFileStream.Create( shardDir + 'Radarcol.mul', fmOpenRead + fmShareDenyNone )
        else
                mulStream := TFileStream.Create( baseDir + 'Radarcol.mul', fmOpenRead + fmShareDenyNone );
        mulStream.Seek( 0, soFromBeginning );

        Count := mulStream.Size div 2;
        GetMem( Cache, Count*2 );

        mulStream.Seek( 0, soFromBeginning );
        for I := 0 to Count-1 do begin
                mulStream.Read( Cache^[I], 2 );
        end;
        mulStream.Free;
end;

destructor TRadarcol.Free;
begin
        FreeMem( Cache );
end;

function TRadarcol.GetRadarColor( Id : Word ) : Word;
begin
        if Id < Count then
                Result := Cache^[ Id ]
        else
                Result := 0;
end;

end.
