unit uLoaderSkills;

interface

uses    SysUtils, uUtilities, Classes, Dialogs;

type    TSkill = Class;
        TSkillGroup = Class;
        TSkills = Class
                private
                        Cache, GroupCache : TList;
                        _shardDir : String;
                public
                        constructor Create( baseDir, shardDir : String );
                        destructor Free;
                        function GetSkillName( Id : Word ) : String;
                        function HasButton( Id : Word ) : Boolean;
                        function GetSkill( Id : Word ) : TSkill;
                        function GetSkillGroup( Id : Word ) : Byte;
                        function GetGroupName( Id : Byte ) : String;
                        function GetGroup( Id : Byte ) : TSkillGroup;
                        procedure SetSkillGroup( Id : Word; SkillGroup : Byte );
                        procedure SetGroupName( Id : Byte; Name : String );
                        function AddSkillGroup( Name : String ) : Byte;
                        function GetSkillGroupCount : Byte;
                        function GetSkillCount : Byte;
        end;

        TSkill = Class
                private
                        _HasButton : Boolean;
                        _Name : String;
                        _GroupId : Byte;
                        procedure SetGroupId( SkillGroupId : Byte );
                public
                        property HasButton : Boolean read _HasButton;
                        property Name : String read _Name;
                        property GroupId : Byte read _GroupId write SetGroupId;
                        constructor Create( SkillHasButton : Boolean; SkillName : String );
                        destructor Free;
        end;

        TSkillGroup = Class
                private
                        _Name : String;
                        procedure SetName( GroupName : String );
                public
                        property Name : String read _Name write SetName;
                        constructor Create( GroupName : String );
                        destructor Free;
        end;


implementation

constructor TSkills.Create( baseDir, shardDir : String );
var     Skill : TSkill;
        SkillGroup : TSkillGroup;
        idxStream, mulStream, grpStream : TFileStream;
        IndexRecord : TIndexRecord;
        B : Byte;
        I, J : Integer;
        SkillHasButton : Boolean;
        SkillName : String;
        GroupCount : Integer;
        GroupName : Array[0..16] of Char;
begin
        _shardDir := shardDir;
        Cache := TList.Create;

        GroupCache := TList.Create;
        SkillGroup := TSkillGroup.Create( 'Miscellaneous' );
        GroupCache.Add( SkillGroup );

        if FileExists( shardDir + 'skills.idx' ) and FileExists( shardDir + 'skills.mul' ) then begin
                idxStream := TFileStream.Create( shardDir + 'skills.idx', fmOpenRead );
                mulStream := TFileStream.Create( shardDir + 'skills.mul', fmOpenRead );
        end else if FileExists( baseDir + 'skills.idx' ) and FileExists( baseDir + 'skills.mul' ) then begin
                idxStream := TFileStream.Create( baseDir + 'skills.idx', fmOpenRead );
                mulStream := TFileStream.Create( baseDir + 'skills.mul', fmOpenRead );
        end else begin
                Exit;
        end;

        idxStream.Seek( 0, soFromBeginning );
        while idxStream.Position < idxStream.Size do begin
                idxStream.Read( IndexRecord, 12 );
                if (IndexRecord.Offset <> -1) and (IndexRecord.Length <> -1) then begin
                        mulStream.Seek( IndexRecord.Offset, soFromBeginning );

                        mulStream.Read( B, 1 );
                        SkillHasButton := B = 1;

                        SkillName := '';
                        for I := 1 to IndexRecord.Length-1 do begin
                                mulStream.Read( B, 1 );
                                if B = 0 then begin
                                        break;
                                end;

                                SkillName := SkillName + Chr( B );
                        end;
                        SkillName := Utf8Decode( Skillname );

                        Skill := TSkill.Create( SkillHasButton, SkillName );
                        Cache.Add( Skill );
                end;
        end;
        idxStream.Free;
        mulStream.Free;

        if FileExists( shardDir + 'skillgrp.mul' ) then begin
                grpStream := TFileStream.Create( shardDir + 'skillgrp.mul', fmOpenRead );
        end else if FileExists( baseDir + 'skillgrp.mul' ) then begin
                grpStream := TFileStream.Create( baseDir + 'skillgrp.mul', fmOpenRead );
        end else begin
                Exit;
        end;

        grpStream.Seek( 0, soFromBeginning );
        grpStream.Read( GroupCount, 4 );
        for I := 1 to GroupCount-1 do begin
                grpStream.Read( GroupName, 17 );
                SkillGroup := TSkillGroup.Create( GroupName );
                GroupCache.Add( SkillGroup );
        end;

        I := 0;
        while grpStream.Position < grpStream.Size do begin
                grpStream.Read( J, 4 );
                Skill := GetSkill( I );
                if Skill <> nil then
                        Skill.GroupId := J;
                Inc( I );
        end;
        grpStream.Free;
end;

destructor TSkills.Free;
var     I, J : Integer;
        grpStream : TFileStream;
        GroupName : String;
        B : Byte;
        GroupCount : Integer;
begin
        if FileExists( _shardDir + 'skillgrp.mul' ) then
                DeleteFile( _shardDir + 'skillgrp.mul' );

        GroupCount := GroupCache.Count;
        grpStream := TFileStream.Create( _shardDir + 'skillgrp.mul', fmCreate );
        grpStream.Write( GroupCount, 4 );
        for I := 1 to GroupCache.Count-1 do begin
                GroupName := Utf8Encode( GetGroupName( I ) );
                for J := 1 to 17 do begin
                        if J <= Length( GroupName ) then begin
                                B := Ord( GroupName[J] );
                        end else begin
                                B := 0;
                        end;
                        grpStream.Write( B, 1 );
                end;
        end;

        for I := 0 to GroupCache.Count-1 do begin
                TSkillGroup( GroupCache.Items[ I ] ).Free;
        end;

        for I := 0 to Cache.Count-1 do begin
                J := TSkill( Cache.Items[ I ] ).GroupId;
                grpStream.Write( J, 4 );
                TSkill( Cache.Items[ I ] ).Free;
        end;

        Cache.Free;
        GroupCache.Free;
        grpStream.Free;
end;

function TSkills.GetSkillName( Id : Word ) : String;
begin
        if Id < Cache.Count then begin
                Result := TSkill( Cache.Items[ Id ] ).Name;
        end else begin
                Result := '';
        end;
end;

function TSkills.HasButton( Id : Word ) : Boolean;
begin
        if Id < Cache.Count then begin
                Result := TSkill( Cache.Items[ Id ] ).HasButton;
        end else begin
                Result := False;
        end;
end;

function TSkills.GetSkill( Id : Word ) : TSkill;
begin
        if Id < Cache.Count then begin
                Result := TSkill( Cache.Items[ Id ] );
        end else begin
                Result := nil;
        end;
end;

function TSkills.GetSkillGroup( Id : Word ) : Byte;
begin
        if Id < Cache.Count then begin
                Result := TSkill( Cache.Items[ Id ] ).GroupId;
        end else begin
                Result := 0;
        end;
end;

function TSkills.GetGroupName( Id : Byte ) : String;
begin
        if Id < GroupCache.Count then begin
                Result := TSkillGroup( GroupCache.Items[ Id ] ).Name;
        end else begin
                Result := '';
        end;
end;

function TSkills.GetGroup( Id : Byte ) : TSkillGroup;
begin
        if Id < GroupCache.Count then begin
                Result := TSkillGroup( GroupCache.Items[ Id ] );
        end else begin
                Result := nil;
        end;
end;

procedure TSkills.SetSkillGroup( Id : Word; SkillGroup : Byte );
begin
        if Id < Cache.Count then begin
                TSkill( Cache.Items[ Id ] ).GroupId := SkillGroup;
        end;
end;

procedure TSkills.SetGroupName( Id : Byte; Name : String );
begin
        if Id < GroupCache.Count then begin
                TSkillGroup( GroupCache.Items[ Id ] ).Name := Name;
        end;
end;

function TSkills.AddSkillGroup( Name : String ) : Byte;
var     SkillGroup : TSkillGroup;
begin
        SkillGroup := TSkillGroup.Create( Name );
        GroupCache.Add( SkillGroup );
        Result := GroupCache.Count-1;
end;

function TSkills.GetSkillGroupCount : Byte;
begin
        Result := GroupCache.Count;
end;

function TSkills.GetSkillCount : Byte;
begin
        Result := Cache.Count;
end;

constructor TSkill.Create( SkillHasButton : Boolean; SkillName : String );
begin
        _HasButton := SkillHasButton;
        _Name := SkillName;
end;

destructor TSkill.Free;
begin
end;

procedure TSkill.SetGroupId( SkillGroupId : Byte );
begin
        _GroupId := SkillGroupId;
end;

constructor TSkillGroup.Create( GroupName : String );
begin
        _Name := GroupName;
end;

destructor TSkillGroup.Free;
begin
end;

procedure TSkillGroup.SetName( GroupName : String );
begin
        _Name := GroupName;
end;

end.

