unit uLoaderSounds;

interface

uses    Classes, SysUtils, uUtilities, Dialogs, SDL, SDL_Mixer, uLog,
        uLoaderVerdata;

type    TWaveHeader = packed record
		      RIFF_ID : Array[0..3] of Char;
		      Len : LongWord;
		      WAVE_ID : Array[0..3] of Char;

		      ChunkID : Array[0..3] of Char;
		      ChunkSize : LongWord;

		      wFormatTag : SmallInt;
		      wChannels : Word;
		      dwSamplesPerSec : LongWord;
		      dwAvgBytesPerSec : LongWord;
	  	    wBlockAlign : Word;
		      wBitsPerSample : Word;

		      datachunkID : Array[0..3] of Char;
		      datachunkSize : LongWord;
		      Rawdata : LongWord;
	      end;
        
        PWaveHeader = ^TWaveHeader;

        TSoundHeader = packed record
                Name : Array[0..15] of Char;
                Unk1, Unk2, Unk3, Unk4 : Integer;
        end;

        TSounds = Class
                private
                        idxBaseStream, mulBaseStream, idxShardStream, mulShardStream : TFileStream;
                        Cache : TList;
                        function InternalGetSound( Id : Word ) : PMix_Chunk;
                public
                        constructor Create( baseDir, shardDir : String );
                        destructor Free;
                        function GetSound( Id : Word ) : PMix_Chunk;
                        
        end;

implementation

uses    uPalanthir;

constructor TSounds.Create( baseDir, shardDir : String );
begin
        idxBaseStream := TFileStream.Create( baseDir + 'Soundidx.mul', fmOpenRead + fmShareDenyNone );
        mulBaseStream := TFileStream.Create( baseDir + 'Sound.mul', fmOpenRead + fmShareDenyNone );
        if FileExists( shardDir + 'Soundidx.mul' ) then
                idxShardStream := TFileStream.Create( shardDir + 'Soundidx.mul', fmOpenRead + fmShareDenyNone )
        else
                idxShardStream := nil;
        if FileExists( shardDir + 'Sound.mul' ) then
                mulShardStream := TFileStream.Create( shardDir + 'Sound.mul', fmOpenRead + fmShareDenyNone )
        else
                mulShardStream := nil;
        Cache := TList.Create;
end;

destructor TSounds.Free;
begin
        idxBaseStream.Free;
        mulBaseStream.Free;
        if idxShardStream <> nil then
                idxShardStream.Free;
        if mulShardStream <> nil then
                mulShardStream.Free;
        Cache.Free;
end;

function TSounds.InternalGetSound( Id : Word ) : PMix_Chunk;
var     IndexRecord : TIndexRecord;
        mulStream : TStream;
        SoundHeader : TSoundHeader;
        WData : PWaveHeader;
        DataSize : LongWord;
        Tmp : PSDL_RWops;
        VerdataEntry : TVerdataEntry;
        Gefunden : Boolean;
begin
        VerdataEntry := Palanthir.Data.Verdata.GetSound( Id );
        if VerdataEntry <> nil then begin
                IndexRecord := VerdataEntry.IndexRecord;
                if (IndexRecord.Offset = -1) or (IndexRecord.Length = -1) then begin
                        Result := nil;
                        exit;
                end;
                mulStream := VerdataEntry.mulStream;
        end
        else begin
                Gefunden := False;
                if (idxShardStream <> nil) and (mulShardStream <> nil) and (Id*12 < idxShardStream.Size) then begin
                        idxShardStream.Seek( Id*12, soFromBeginning );
                        idxShardStream.Read( IndexRecord, 12 );
                        if (IndexRecord.Offset <> -1) and (IndexRecord.Length <> -1) then begin
                                Gefunden := True;
                                mulStream := mulShardStream;
                        end;
                end;

                if (not Gefunden) and (idxBaseStream <> nil) and (mulBaseStream <> nil) then begin
                        if Id*12 >= idxBaseStream.Size then begin
                                Result := nil;
                                exit;
                        end;

                        idxBaseStream.Seek( Id*12, soFromBeginning );
                        idxBaseStream.Read( IndexRecord, 12 );

                        if (IndexRecord.Offset = -1) or (IndexRecord.Length = -1) then begin
                                Result := nil;
                                exit;
                        end;

                        mulStream := mulBaseStream;
                end;
        end;

        mulStream.Seek( IndexRecord.Offset, soFromBeginning );
        mulStream.Read( SoundHeader, sizeof( TSoundHeader ) );

        DataSize := IndexRecord.Length - sizeof( TSoundHeader );

        GetMem( WData, DataSize + SizeOf( TWaveHeader ) );
        //Initialize( WData^, DataSize + SizeOf( TWaveHeader ) );
        WData.RIFF_ID := 'RIFF';
        WData.Len := DataSize + 36;
        WData.WAVE_ID := 'WAVE';

        WData.ChunkID := 'fmt ';
        WData.ChunkSize := 16;

        WData.wFormatTag := 1;
        WData.wChannels := 1;
        WData.dwSamplesPerSec := 22050;
        WData.dwAvgBytesPerSec := 88200;
        WData.wBlockAlign := 4;
        WData.wBitsPerSample := 16;

        WData.datachunkID := 'data';
        WData.datachunkSize := DataSize;
        mulStream.Read( WData.Rawdata, DataSize );

        Tmp := SDL_RWFromMem( WData, DataSize + SizeOf( TWaveHeader ) );
        Result := Mix_LoadWAV_RW( Tmp, 1 );

        if Result = nil then
                Log.Write( Mix_GetError );

        FreeMem( WData );
end;

function TSounds.GetSound( Id : Word ) : PMix_Chunk;
begin
        try
                Result := InternalGetSound( Id );
        except
                on E : Exception do begin
                        Log.Write( Format( 'uLoaderSounds: %s' , [E.Message] ) );
                        raise E;
                end;
        end;
end;

end.
