unit uLoaderSpeech;

interface

uses    Classes, SysUtils, Dialogs;

type    TLoaderSpeech = Class
                private
                        Liste : TList;
                public
                        constructor Create( baseDir, shardDir : String );
                        destructor Free;
                        function GetKeyWords( Zeile : String ) : TList;
        end;

        TSpeechEntry = Record
                Text : String;
                Index : Word;
                Start, Ende : Boolean;
        end;

        PSpeechEntry = ^TSpeechEntry;

implementation

constructor TLoaderSpeech.Create( baseDir, shardDir : String );
var     mulStream : TFileStream;
        I : Integer;
        Entry : PSpeechEntry;
        C1, C2 : Byte;
        Count : Word;
        B : Byte;
begin
        Liste := TList.Create;

        if FileExists( shardDir + 'Speech.mul' ) then
                mulStream := TFileStream.Create( shardDir + 'Speech.mul', fmOpenRead + fmShareDenyNone )
        else if FileExists( baseDir + 'Speech.mul' ) then
                mulStream := TFileStream.Create( baseDir + 'Speech.mul', fmOpenRead + fmShareDenyNone )
        else begin
                exit;
        end;
        
        mulStream.Seek( 0, soFromBeginning );

        while mulStream.Position < mulStream.Size do begin
                new( Entry );

                mulStream.Read( C1, 1 );
                mulStream.Read( C2, 1 );
                Entry.Index := (C1 shl 8) + C2;

                mulStream.Read( C1, 1 );
                mulStream.Read( C2, 1 );
                Count := (C1 shl 8) + C2;

                Entry.Text := '';
                for I := 0 to Count-1 do begin
                        mulStream.Read( B, 1 );
                        Entry.Text := Entry.Text + Chr( B );
                end;
                Entry.Text := LowerCase( Utf8Decode( Entry.Text ) );

                if Length( Entry.Text ) > 0 then begin
                        if Entry.Text[ 1 ] = '*' then begin
                                Entry.Start := True;
                                Delete( Entry.Text, 1, 1 );
                        end
                        else
                                Entry.Start := False;

                        if Entry.Text[ Length( Entry.Text ) ] = '*' then begin
                                Entry.Ende := True;
                                Delete( Entry.Text, Length( Entry.Text ), 1 );
                        end
                        else
                                Entry.Ende := False;

                        if Length( Entry.Text ) > 2 then
                                Liste.Add( Entry )
                        else
                                Dispose( Entry );
                end
                else begin
                        Dispose( Entry );
                end;
        end;
end;

destructor TLoaderSpeech.Free;
var     I : Integer;
begin
        for I := 0 to Liste.Count-1 do
                Dispose( Liste.Items[ I ] );
        Liste.Free;
end;

function TLoaderSpeech.GetKeyWords( Zeile : String ) : TList;
var     I, P : Integer;
begin
        Result := TList.Create;

        Zeile := LowerCase( Zeile );

        for I := 0 to Liste.Count-1 do begin
                P := Pos( PSpeechEntry( Liste.Items[ I ] ).Text, Zeile );
                if P > 0 then begin
                        if (not PSpeechEntry( Liste.Items[ I ] ).Start) and (P > 1) then
                                continue;

                        if (not PSpeechEntry( Liste.Items[ I ] ).Ende) and ( P + Length( PSpeechEntry( Liste.Items[ I ] ).Text ) < Length( Zeile ) ) then
                                continue;

                        Result.Add( Pointer( PSpeechEntry( Liste.Items[ I ] ).Index ) );
                end;
        end;
end;

end.
