unit uLoaderTexturen;

interface

uses Classes, SysUtils, uUtilities, Dialogs, uLoaderHues, uTexCache, dglOpenGL,
        uLog, uLoaderVerdata, uRenderer;

type    TTexturen = Class
                private
                        idxBaseStream, mulBaseStream, idxShardStream, mulShardStream : TFileStream;
                        Cache : TTexCache;
                        function LoadTexture( Id, Hue : Word ) : TTexObject;
                public
                        constructor Create( baseDir, shardDir : String );
                        destructor Free;                        
                        function GetTexture( Id, Hue : Word ) : TTexObject;
                        procedure IncTexture( Id, Hue : Word );
                        procedure DecTexture( Id, Hue : Word );
        end;

implementation

uses    uPalanthir;

constructor TTexturen.Create( baseDir, shardDir : String );
begin
        idxBaseStream := TFileStream.Create( baseDir + 'Texidx.mul', fmOpenRead + fmShareDenyNone );
        mulBaseStream := TFileStream.Create( baseDir + 'Texmaps.mul', fmOpenRead + fmShareDenyNone );
        if FileExists( shardDir + 'Texidx.mul' ) then
                idxShardStream := TFileStream.Create( shardDir + 'Texidx.mul', fmOpenRead + fmShareDenyNone )
        else
                idxShardStream := nil;
        if FileExists( shardDir + 'Texmaps.mul' ) then
                mulShardStream := TFileStream.Create( shardDir + 'Texmaps.mul', fmOpenRead + fmShareDenyNone )
        else
                mulShardStream := nil;
        Cache := TTexCache.Create;
        Cache.AutoDelete := False;
end;

destructor TTexturen.Free;
begin
        idxBaseStream.Free;
        mulBaseStream.Free;
        if idxShardStream <> nil then
                idxShardStream.Free;
        if mulShardStream <> nil then
                mulShardStream.Free;
        Cache.Free;
end;

function TTexturen.LoadTexture( Id, Hue : Word ) : TTexObject;
var     IndexRecord : TIndexRecord;
        Y, X, I : Integer;
        Color, Red: Word;
        Textur : PByteArray;
        mulStream : TStream;
        Position : Integer;
        Gefunden : Boolean;
        VerdataEntry : TVerdataEntry;
        Hoehe, Breite : Word;
begin
        VerdataEntry := Palanthir.Data.Verdata.GetArt( Id );
        if VerdataEntry <> nil then begin
                IndexRecord := VerdataEntry.IndexRecord;
                if (IndexRecord.Offset = -1) or (IndexRecord.Length = -1) then begin
                        Result := nil;
                        exit;
                end;
                mulStream := VerdataEntry.mulStream;
        end
        else begin
                Gefunden := False;
                if (idxShardStream <> nil) and (mulShardStream <> nil) and (Id*12 < idxShardStream.Size) then begin
                        idxShardStream.Seek( Id*12, soFromBeginning );
                        idxShardStream.Read( IndexRecord, 12 );

                        if Palanthir.MulEncryption then begin
                                if Palanthir.Data.MulCrypt.DecryptIndexRecordTex( Id, IndexRecord ) then begin
                                        if (IndexRecord.Offset <> -1) and (IndexRecord.Length <> -1) then begin
                                                Gefunden := True;
                                                mulStream := mulShardStream;
                                        end;
                                end
                                else begin
                                        Log.Write( 'Not able to decrypt Tex.' );
                                end;
                        end
                        else begin
                                if (IndexRecord.Offset <> -1) and (IndexRecord.Length <> -1) then begin
                                        Gefunden := True;
                                        mulStream := mulShardStream;
                                end;
                        end;                        
                end;

                if (not Gefunden) and (idxBaseStream <> nil) and (mulBaseStream <> nil) then begin
                        if Id*12 >= idxBaseStream.Size then begin
                                Result := nil;
                                exit;
                        end;

                        idxBaseStream.Seek( Id*12, soFromBeginning );
                        idxBaseStream.Read( IndexRecord, 12 );

                        if (IndexRecord.Offset = -1) or (IndexRecord.Length = -1) then begin
                                Result := nil;
                                exit;
                        end;

                        mulStream := mulBaseStream;
                end;
        end;

        if IndexRecord.Length = 8192 then begin
                Hoehe := 64;
                Breite := 64;
        end
        else begin
                Hoehe := 128;
                Breite := 128;
        end;

        mulStream.Seek( IndexRecord.Offset, soFromBeginning );

        GetMem( Textur, Breite*Hoehe*4 );
        for I := 0 to ( Breite*Hoehe*4-1 ) do
                Textur^[I] := 0;

        for Y := 0 to Hoehe-1 do begin
                Position := Y*Breite*4;
                for X := 0 to Breite-1 do begin
                        mulStream.Read( Color, 2 );
                        if Hue > 0 then begin
                                Red := Color15toRed( Color ) div 8;
                                Textur^[ Position ] := Color15toRed( Hues.GetColor( Hue, Red ) );
                                Textur^[ Position+1 ] := Color15toGreen( Hues.GetColor( Hue, Red ) );
                                Textur^[ Position+2 ] := Color15toBlue( Hues.GetColor( Hue, Red ) );
                        end
                        else begin
                                Textur^[ Position ] := Color15toRed( Color );
                                Textur^[ Position+1 ] := Color15toGreen( Color );
                                Textur^[ Position+2 ] := Color15toBlue( Color );
                        end;
                        Textur^[ Position+3 ] := 255;
                        Inc( Position, 4 );
                end;
        end;

        Result := Renderer.CreateTexture32( Tex_Texture, Breite, Hoehe, Textur, Id, Hue );
        FreeMem( Textur );
        Renderer.CurrentTexID := Result.TexID;

        Cache.AddObject( Result );
end;


function TTexturen.GetTexture( Id, Hue : Word ) : TTexObject;
begin
        try
                Result := Cache.GetTexObject( Id, Hue );

                if Result = nil then
                        Result := LoadTexture( Id, Hue );
        except
                on E : Exception do begin
                        Log.Write( Format( 'uLoaderTexturen: %s Id:%d Hue:%d' , [E.Message,Id,Hue] ) );
                        raise E;
                end;
        end;
end;

procedure TTexturen.IncTexture( Id, Hue : Word );
begin
        Cache.IncCount( Id, Hue );
end;

procedure TTexturen.DecTexture( Id, Hue : Word );
begin
        Cache.DecCount( Id, Hue );
end;

end.
 