unit uLoaderTiledata;

interface

uses    Classes, SysUtils, Dialogs, uLog, uLoaderVerdata;

const   dBACKGROUND = $1;
        dWEAPON = $2;
        dTRANSPARENT = $4;
        dTRANSLUCENT = $8;
        dWALL = $10;
        dDAMAGING = $20;
        dIMPASSABLE = $40;
        dLIQUID = $80;

        dUNKNOWN1 = $100;
        dSURFACE = $200;
        dBRIDGE = $400;
        dGENERIC = $800;
        dWINDOW = $1000;
        dNOSHOOT = $2000;
        dA = $4000;
        dAN = $8000;

        dMONGEN = $10000;
        dFOLIAGE = $20000;
        dPARTIALHUE = $40000;
        dUNKNOWN2 = $80000;
        dMAP = $100000;
        dCONTAINER = $200000;
        dWEARABLE = $400000;
        dLIGHTSOURCE = $800000;

        dANIMATION = $1000000;
        dNODIAGONAL = $2000000;
        dUNKNOWN3 = $4000000;
        dARMOR = $8000000;
        dROOF = $10000000;
        dDOOR = $20000000;
        dSTAIRBACK = $40000000;
        dSTAIRRIGHT = $80000000;

        TiledataFlags : Array[0..31] of String = (
                'BACKGROUND',
                'WEAPON',
                'TRANSPARENT',
                'TRANSLUCENT',
                'WALL',
                'DAMAGING',
                'IMPASSABLE',
                'LIQUID',

                'UNKNOWN1',
                'SURFACE',
                'BRIDGE',
                'GENERIC',
                'WINDOW',
                'NOSHOOT',
                'A',
                'AN',

                'MONGEN',
                'FOLIAGE',
                'PARTIALHUE',
                'UNKNOWN2',
                'MAP',
                'CONTAINER',
                'WEARABLE',
                'LIGHTSOURCE',

                'ANIMATION',
                'NODIAGONAL',
                'UNKNOWN3',
                'ARMOR',
                'ROOF',
                'DOOR',
                'STAIRBACK',
                'STAIRRIGHT' );

type    TLandTileRecord = packed record
             Flags : Longword;
             TexID : Word;
             Name : array[0..19] of char;
        end;

        TStaticTileRecord = packed record
                Flags : Longword;
                Weight, Quality : Byte;
                Unknown1 : Word;
                Unknown2 : Byte;
                Quantity : Byte;
                AnimID : Word;
                Unknown3, Hue, Unknown4, Unknown5, Height : Byte;
                Name : array[0..19] of Char;
        end;

        TLandTileArray = array[0..1] of TLandTileRecord;
        PLandTileArray = ^TLandTileArray;

        TStaticTileArray = array[0..1] of TStaticTileRecord;
        PStaticTileArray = ^TStaticTileArray;

        TTiledata = class
                private
                        LandCache : PLandTileArray;
                        StaticCache : PStaticTileArray;
                        LandCount, StaticCount : LongWord;
                public
                        constructor Create( baseDir, shardDir : String );
                        destructor Free;

                        function GetLandTile( Id : Integer ) : TLandTileRecord;
                        function GetLandName( Id : Integer ) : String;
                        function GetLandFlag( Id : Integer; Flag : LongWord ) : Boolean;
                        function GetLandTexId( Id : Integer ) : Integer;

                        function GetStaticTile( Id : Integer ) : TStaticTileRecord;
                        function GetStaticName( Id : Integer ) : String;
                        function GetStaticAnimId( Id : Integer ) : Integer;
                        function GetStaticHeight( Id : Integer ) : Integer;
                        function GetStaticHue( Id : Integer ) : Integer;
                        function GetStaticQuality( Id : Integer ) : Integer;
                        function GetStaticQuantity( Id : Integer ) : Integer;
                        function GetStaticWeight( Id : Integer ) : Integer;
                        function GetStaticUnknown1( Id : Integer ) : Integer;
                        function GetStaticUnknown2( Id : Integer ) : Integer;
                        function GetStaticUnknown3( Id : Integer ) : Integer;
                        function GetStaticUnknown4( Id : Integer ) : Integer;
                        function GetStaticUnknown5( Id : Integer ) : Integer;
                        function GetStaticFlag( Id : Integer; Flag : LongWord ) : Boolean;
end;

implementation

uses    uUtilities, StrLib, uPalanthir;

constructor TTiledata.Create( baseDir, shardDir : String );
var     I, J, Count : Integer;
        LandTile : TLandTileRecord;
        StaticTile : TStaticTileRecord;
        mulStream : TFileStream;
        VerdataList : TList;
        VerdataEntry : TVerdataEntry;
begin
        if FileExists( shardDir + 'Tiledata.mul' ) then begin
                try
                        mulStream := TFileStream.Create( shardDir + 'Tiledata.mul', fmOpenRead + fmShareDenyNone )
                except
                        Log.Write( 'Could not open tiledata.mul' );
                        Palanthir.State := State_Ending;
                        Exit;
                end;
        end else begin
                try
                        mulStream := TFileStream.Create( baseDir + 'Tiledata.mul', fmOpenRead + fmShareDenyNone );
                except
                        Log.Write( 'Could not open tiledata.mul' );
                        Palanthir.State := State_Ending;
                        Exit;
                end;
        end;

        mulStream.Seek( 0, soFromBeginning );

        LandCount := $4000;
        GetMem( LandCache, $4000*sizeof( TLandTileRecord ) );
        for I := 0 to 511 do begin
                mulStream.Seek( 4, soFromCurrent );
                for J := 0 to 31 do begin
                        mulStream.Read( LandTile, sizeof( TLandTileRecord ) );
                        LandCache^[ I*32 + J ] := LandTile;
                end;
        end;

        Count := Trunc( ( mulStream.Size - mulStream.Position ) / ( sizeof( TStaticTileRecord )*32 + 4 ) )*32;
        StaticCount := Count;
        GetMem( StaticCache, Count*sizeof( TStaticTileRecord ) );
        I := 0;
        while mulStream.Position < mulStream.Size do begin
                mulStream.Seek( 4, soFromCurrent );
                for J := 0 to 31 do begin
                        mulStream.Read( StaticTile, sizeof( TStaticTileRecord ) );
                        StaticCache^[ I*32 + J ] := StaticTile;
                end;
                inc( I );
        end;
        mulStream.Free;

        VerdataList := Palanthir.Data.Verdata.GetTiledataEntries;
        for I := 0 to VerdataList.Count-1 do begin
                VerdataEntry := TVerdataEntry( VerdataList.Items[ I ] );
                VerdataEntry.mulStream.Seek( VerdataEntry.IndexRecord.Offset, soFromBeginning );
                if VerdataEntry.Block < $4000 then begin
                        VerdataEntry.mulStream.Read( LandTile, sizeof( TLandTileRecord ) );
                        LandCache^[ VerdataEntry.Block ] := LandTile;
                end
                else begin
                        VerdataEntry.mulStream.Read( StaticTile, sizeof( TStaticTileRecord ) );
                        StaticCache^[ VerdataEntry.Block ] := StaticTile;
                end;
        end;
        VerdataList.Free;
end;

destructor TTiledata.Free;
begin
        FreeMem( LandCache );
        FreeMem( StaticCache );
end;

function TTiledata.GetLandTile( Id : Integer ) : TLandTileRecord;
begin
        if Id < LandCount then begin
                Result := LandCache^[ Id ];
        end
        else begin
                log.Write( Format( 'Buggy LandTileId %d.', [Id] ) );        
                Result.Flags := 0;
                Result.TexID := 0;
                Result.Name := '';
        end;
end;

function TTiledata.GetStaticTile( Id : Integer ) : TStaticTileRecord;
begin
        if (Id >= 0) and (Id < StaticCount) then begin
                Result := StaticCache^[ Id ];
        end
        else if (Id >= Palanthir.FirstMultiID) and (Id <= Palanthir.LastMultiID) then begin
                //do nothing
        end
        else begin
                log.Write( Format( 'Buggy StaticTileId %d.', [Id] ) );
                Result.Flags := 0;
                Result.Weight := 0;
                Result.Quality := 0;
                Result.Unknown1 := 0;
                Result.Unknown2 := 0;
                Result.Quantity := 0;
                Result.AnimID := 0;
                Result.Unknown3 := 0;
                Result.Hue := 0;
                Result.Unknown4 := 0;
                Result.Unknown5 := 0;
                Result.Height := 0;
                Result.Name := '';
        end;
end;

function TTiledata.GetLandName( Id : Integer ) : String;
var     LandTile : TLandTileRecord;
begin
        LandTile := GetLandTile( Id );
        Result := LandTile.Name;
end;

function TTiledata.GetStaticName( Id : Integer ) : String;
var     StaticTile : TStaticTileRecord;
begin
        StaticTile := GetStaticTile( Id );
        Result := StaticTile.Name;
end;

function TTiledata.GetLandTexId( Id : Integer ) : Integer;
var     LandTile : TLandTileRecord;
begin
        LandTile := GetLandTile( Id );
        Result := LandTile.TexID;
end;

function TTiledata.GetStaticAnimId( Id : Integer ) : Integer;
var     StaticTile : TStaticTileRecord;
begin
        StaticTile := GetStaticTile( Id );
        Result := StaticTile.AnimID;
end;

function TTiledata.GetStaticHeight( Id : Integer ) : Integer;
var     StaticTile : TStaticTileRecord;
begin
        StaticTile := GetStaticTile( Id );
        Result := StaticTile.Height;
end;

function TTiledata.GetStaticHue( Id : Integer ) : Integer;
var     StaticTile : TStaticTileRecord;
begin
        StaticTile := GetStaticTile( Id );
        Result := StaticTile.Hue;
end;

function TTiledata.GetStaticQuality( Id : Integer ) : Integer;
var     StaticTile : TStaticTileRecord;
begin
        StaticTile := GetStaticTile( Id );
        Result := StaticTile.Quality;
end;

function TTiledata.GetStaticQuantity( Id : Integer ) : Integer;
var     StaticTile : TStaticTileRecord;
begin
        StaticTile := GetStaticTile( Id );
        Result := StaticTile.Quantity;
end;

function TTiledata.GetStaticWeight( Id : Integer ) : Integer;
var     StaticTile : TStaticTileRecord;
begin
        StaticTile := GetStaticTile( Id );
        Result := StaticTile.Weight;
end;

function TTiledata.GetStaticUnknown1( Id : Integer ) : Integer;
var     StaticTile : TStaticTileRecord;
begin
        StaticTile := GetStaticTile( Id );
        Result := StaticTile.Unknown1;
end;

function TTiledata.GetStaticUnknown2( Id : Integer ) : Integer;
var     StaticTile : TStaticTileRecord;
begin
        StaticTile := GetStaticTile( Id );
        Result := StaticTile.Unknown2;
end;

function TTiledata.GetStaticUnknown3( Id : Integer ) : Integer;
var     StaticTile : TStaticTileRecord;
begin
        StaticTile := GetStaticTile( Id );
        Result := StaticTile.Unknown3;
end;

function TTiledata.GetStaticUnknown4( Id : Integer ) : Integer;
var     StaticTile : TStaticTileRecord;
begin
        StaticTile := GetStaticTile( Id );
        Result := StaticTile.Unknown4;
end;

function TTiledata.GetStaticUnknown5( Id : Integer ) : Integer;
var     StaticTile : TStaticTileRecord;
begin
        StaticTile := GetStaticTile( Id );
        Result := StaticTile.Unknown5;
end;

function TTiledata.GetLandFlag( Id : Integer; Flag : LongWord ) : Boolean;
var     LandTile : TLandTileRecord;
begin
        LandTile := GetLandTile( Id );
        Result := ( LandTile.Flags and Flag ) = Flag;
end;

function TTiledata.GetStaticFlag( Id : Integer; Flag : LongWord ) : Boolean;
var     StaticTile : TStaticTileRecord;
begin
        StaticTile := GetStaticTile( Id );
        Result := ( StaticTile.Flags and Flag ) = Flag;
end;

end.

