unit uLoaderVerdata;

interface

uses    Classes, SysUtils, uUtilities, Dialogs, SyncObjs;

const   map = 0;
        staidx0 = 1;
        statics0 = 2;
        artidx = 3;
        art = 4;
        animidx = 5;
        anim = 6;
        soundidx = 7;
        sound = 8;
        texidx = 9;
        texmaps = 10;
        gumpidx = 11;
        gumpart = 12;
        multiidx = 13;
        multi = 14;
        skillsidx = 15;
        skills = 16;
        tiledata = 30;
        animdata = 31;

type    TVerdataEntry = Class;

        TVerdata = Class
                private
                        baseStream, shardStream: TFileStream;
                        baseList, shardList : TList;
                        CriticalSection : TCriticalSection;
                        function InternalGetEntry( FileID, Block : LongWord ) : TVerdataEntry;
                        function InternalGetEntryList( FileID : Word ) : TList;
                public
                        constructor Create( baseDir, shardDir : String );
                        destructor Free;
                        function GetGump( Id : LongWord ) : TVerdataEntry;
                        function GetArt( Id : LongWord ) : TVerdataEntry;
                        function GetTexture( Id : LongWord ) : TVerdataEntry;
                        function GetStaticEntry( Id : LongWord ) : TVerdataEntry;
                        function GetAnim( Id : LongWord ) : TVerdataEntry;
                        function GetMulti( Id : LongWord ) : TVerdataEntry;
                        function GetSound( Id : LongWord ) : TVerdataEntry;
                        function GetTiledataEntries : TList;
                        function GetAnimdataEntries : TList;
        end;

        TVerdataEntry = Class
                public
                        FileID, Block : LongWord;
                        IndexRecord : TIndexRecord;
                        mulStream : TMemoryStream;
                        fileStream : TFileStream;
                        constructor Create;
                        destructor Free;
        end;

implementation

constructor TVerdataEntry.Create;
begin
        mulStream := nil;
        fileStream := nil;
end;

destructor TVerdataEntry.Free;
begin
        if mulStream <> nil then
                mulStream.Free;
end;

function TVerdata.InternalGetEntry( FileID, Block : LongWord ) : TVerdataEntry;
var     I : Integer;
begin
        Result := nil;

        if shardList <> nil then begin
                for I := 0 to shardList.Count-1 do begin
                        if (TVerdataEntry( shardList.Items[ I ] ).FileID = FileID) and (TVerdataEntry( shardList.Items[ I ] ).Block = Block) then begin
                                Result := TVerdataEntry( shardList.Items[ I ] );
                                Break;
                        end;
                end;
        end;

        if (Result = nil) and (baseList <> nil) then begin
                for I := 0 to baseList.Count-1 do begin
                        if (TVerdataEntry( baseList.Items[ I ] ).FileID = FileID) and (TVerdataEntry( baseList.Items[ I ] ).Block = Block) then begin
                                Result := TVerdataEntry( baseList.Items[ I ] );
                                Break;
                        end;
                end;
        end;

        if Result <> nil then begin
                if (Result.mulStream = nil) and (Result.fileStream <> nil) then begin
                        Result.mulStream := TMemoryStream.Create;
                        Result.mulStream.Seek( 0, soFromBeginning );

                        CriticalSection.Enter;
                        Result.fileStream.Seek( Result.IndexRecord.Offset, soFromBeginning );
                        Result.mulStream.CopyFrom( Result.fileStream, Result.IndexRecord.Length );
                        CriticalSection.Leave;

                        Result.IndexRecord.Offset := 0;
                        Result.fileStream := nil;
                end;
        end;
end;

function TVerdata.InternalGetEntryList( FileID : Word ) : TList;
var     I, J : Integer;
        Passt : Boolean;
        Entry : TVerdataEntry;
begin
        Result := TList.Create;

        if shardList <> nil then begin
                for I := 0 to shardList.Count-1 do begin
                        if TVerdataEntry( shardList.Items[ I ] ).FileID = FileID then
                                Result.Add( shardList.Items[ I ] );
                end;
        end;

        if baseList <> nil then begin
                for I := 0 to baseList.Count-1 do begin
                        if TVerdataEntry( baseList.Items[ I ] ).FileID = FileID then begin
                                Passt := True;
                                for J := 0 to Result.Count-1 do
                                        if TVerdataEntry( Result.Items[ J ] ).Block = TVerdataEntry( baseList.Items[ I ] ).Block then begin
                                                Passt := False;
                                                break;
                                        end;

                                if Passt then
                                        Result.Add( baseList.Items[ I ] );
                        end;
                end;
        end;

        for I := 0 to Result.Count-1 do begin
                Entry := TVerdataEntry( Result.Items[ I ] );
                if (Entry.mulStream = nil) and (Entry.fileStream <> nil) then begin
                        Entry.mulStream := TMemoryStream.Create;
                        Entry.mulStream.Seek( 0, soFromBeginning );

                        CriticalSection.Enter;
                        Entry.fileStream.Seek( Entry.IndexRecord.Offset, soFromBeginning );
                        Entry.mulStream.CopyFrom( Entry.fileStream, Entry.IndexRecord.Length );
                        CriticalSection.Leave;

                        Entry.IndexRecord.Offset := 0;
                        Entry.fileStream := nil;
                end;
        end;
end;

constructor TVerdata.Create( baseDir, shardDir : String );
var     Count : LongWord;
        I, J : Integer;
        VerdataEntry : TVerdataEntry;
begin
        CriticalSection := TCriticalSection.Create;

        baseStream := nil;
        baseList := nil;

        if FileExists( baseDir + 'Verdata.mul' ) then begin
                baseStream := TFileStream.Create( baseDir + 'Verdata.mul', fmOpenRead );
                baseList := TList.Create;

                baseStream.Seek( 0, soFromBeginning );
                baseStream.Read( Count, 4 );
                for I := 0 to Count-1 do begin
                        VerdataEntry := TVerdataEntry.Create;
                        baseStream.Read( VerdataEntry.FileID, 4 );
                        baseStream.Read( VerdataEntry.Block, 4 );
                        baseStream.Read( VerdataEntry.IndexRecord, 12 );
                        VerdataEntry.fileStream := baseStream;

                        for J := baseList.Count-1 downto 0 do begin
                                if (TVerdataEntry( baseList.Items[ J ] ).Block = VerdataEntry.Block) and (TVerdataEntry( baseList.Items[ J ] ).FileID = VerdataEntry.FileID) then begin
                                        baseList.Delete( J );
                                end;
                        end;

                        baseList.Add( VerdataEntry );
                end;
        end;

        shardStream :=  nil;
        shardList := nil;

        if FileExists( shardDir + 'Verdata.mul' ) then begin
                shardStream := TFileStream.Create( shardDir + 'Verdata.mul', fmOpenRead );
                shardList := TList.Create;

                shardStream.Seek( 0, soFromBeginning );
                shardStream.Read( Count, 4 );
                for I := 0 to Count-1 do begin
                        VerdataEntry := TVerdataEntry.Create;
                        shardStream.Read( VerdataEntry.FileID, 4 );
                        shardStream.Read( VerdataEntry.Block, 4 );
                        shardStream.Read( VerdataEntry.IndexRecord, 12 );
                        VerdataEntry.fileStream := shardStream;

                        for J := shardList.Count-1 downto 0 do begin
                                if (TVerdataEntry( shardList.Items[ J ] ).Block = VerdataEntry.Block) and (TVerdataEntry( shardList.Items[ J ] ).FileID = VerdataEntry.FileID) then begin
                                        shardList.Delete( J );
                                end;
                        end;

                        shardList.Add( VerdataEntry );
                end;
        end;
end;

destructor TVerdata.Free;
var     I : Integer;
begin
        if baseList <> nil then begin
                for I := 0 to baseList.Count-1 do
                        TVerdataEntry( baseList.Items[I] ).Free;
                baseList.Free;
        end;

        if shardList <> nil then begin
                for I := 0 to shardList.Count-1 do
                        TVerdataEntry( shardList.Items[I] ).Free;
                shardList.Free;
        end;

        if baseStream <> nil then begin
                baseStream.Free;
        end;
        if shardStream <> nil then begin
                shardStream.Free;
        end;

        CriticalSection.Free;
end;

function TVerdata.GetGump( Id : LongWord ) : TVerdataEntry;
begin
        Result := InternalGetEntry( gumpart, Id );
end;

function TVerdata.GetArt( Id : LongWord ) : TVerdataEntry;
begin
        Result := InternalGetEntry( art, Id );
end;

function TVerdata.GetTexture( Id : LongWord ) : TVerdataEntry;
begin
        Result := InternalGetEntry( texmaps, Id );
end;

function TVerdata.GetStaticEntry( Id : LongWord ) : TVerdataEntry;
begin
        Result := InternalGetEntry( statics0, Id );
end;

function TVerdata.GetAnim( Id : LongWord ) : TVerdataEntry;
begin
        Result := InternalGetEntry( anim, Id );
end;

function TVerdata.GetMulti( Id : LongWord ) : TVerdataEntry;
begin
        Result := InternalGetEntry( multi, Id );
end;

function TVerdata.GetSound( Id : LongWord ) : TVerdataEntry;
begin
        Result := InternalGetEntry( sound, Id );
end;

function TVerdata.GetTiledataEntries : TList;
begin
        Result := InternalGetEntryList( tiledata );
end;

function TVerdata.GetAnimdataEntries : TList;
begin
        Result := InternalGetEntryList( animdata );
end;

end.
