unit uAutoPatcher;

interface

uses    Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
        Dialogs, rmGauge, StdCtrls, ExtCtrls, uConfig, rmBrowseFor, IdTCPClient,
        IdBaseComponent, IdComponent, IdTCPConnection,  IdHTTP, Inifiles,
        PowerArc, ShellApi, IdFTP, IdIPWatch, jpeg, md5, IdCookieManager, IdCookie,
        uSpecialInput, Math, uMessageForm, uFileCache, StrLib, uMulCrypt, uUtilities;

const   typ_nonpatch = 0;
        typ_anim = 1;
        typ_art = 2;
        typ_gump = 3;
        typ_tex = 4;
        typ_static = 5;
        typ_map = 6;
        typ_tiledata = 7;
        typ_radarcol = 8;
        typ_sound = 9;
        typ_befehl = 10;
        typ_map2 = 11;
        typ_static2 = 12;
        typ_map3 = 13;
        typ_static3 = 14;
        typ_map4 = 15;
        typ_static4 = 16;
        typ_tiledata_variabel = 17;
        typ_anim2 = 18;
        typ_anim3 = 19;
        typ_anim4 = 20;
        typ_anim5 = 21;
        typ_config = 22;
        typ_script = 23;
        typ_encrypt = 24;
        typ_map_variabel = 25;
        typ_progress = 26;

        ReIndex_Anim = 0;
        ReIndex_Art = 1;
        ReIndex_Gumps = 2;
        ReIndex_Sound = 3;
        ReIndex_Statics = 4;
        ReIndex_Textures = 5;
        JumpTo = 6;
        ChangeHeight = 7;

        ProgressTypeStaticArt = 0;
        ProgressTypeGumps = 1;

        LangValueCount = 51;
        LangValues : array[0..LangValueCount-1,0..1] of string = (
                ( 'Starting client', 'Starte Client' ),
                ( 'Creating tempfile', 'Erstelle Tempfile' ),
                ( 'Not enough free disk memory', 'Nicht genug Festplattenspeicher vorhanden' ),
                ( 'Decompressing patch', 'Entpacke Patch' ),
                ( 'Start decompressing', 'Beginne entpacken' ),
                ( 'Decompressing finished', 'Entpacken beendet' ),
                ( 'Starting patch', 'Beginne Patch' ),
                ( 'Installing patch', 'Installiere Patch' ),
                ( 'Next index', 'Nchster Index' ),
                ( 'Creating memorystream', 'Erstelle MemoryStream' ),
                ( 'Saving memoryStream to', 'Speichere MemoryStream nach' ),
                ( 'Index done', 'Index fertig' ),
                ( 'Patching', 'Patche' ),
                ( 'Done', 'Fertig' ),
                ( 'Preparing reindex', 'Bereite Reindizieren vor' ),
                ( 'Start reindication', 'Starte Reindizierungsvorgang' ),
                ( 'Reindexing of', 'Reinidizieren von' ),
                ( 'Patch installed', 'Patch installiert' ),
                ( 'Deleting tempfile', 'Lsche Tempfile' ),
                ( 'Patch done', 'Patch fertig' ),
                ( 'Searching for patcher updates at http://patcher.uodev.de/', 'Suche nach Patcherupdates von http://patcher.uodev.de/' ),
                ( 'New version of this patcher is loading', 'Neue Patcherversion wird geladen' ),
                ( 'New version loaded successfully', 'Neue Patcherversion erfolgreich geladen' ),
                ( 'Please restart patcher', 'Bitte Patcher neu starten' ),
                ( 'Patcher is up to date', 'Patcherversion ist aktuell' ),
                ( 'Could not reach updateserver, going on', 'Server fr Patcherupdates momentan nicht erreichbar, weiter mit Patch.' ),
		( 'Connecting to the server', 'Verbindung zum Server wird aufgebaut' ),
		( 'Checking version', 'berprfe version' ),
		( 'No News existing', 'Keine Infos/News vorhanden' ),
		( 'Local version is up to date', 'Lokale Version ist aktuell' ),
		( 'new patches', 'neue Patches' ),
		( 'No message', 'keine Nachricht' ),
		( 'Wrong login or password', 'Falscher Login oder Falsches Passwort' ),
		( 'Please type in your username', 'Gebt euren Username ein' ),
		( 'Please type in your password', 'Gebt eurer Passwort ein' ),
		( 'Loading patch', 'Lade Patch' ),
		( 'Opening existing patch, please wait', 'ffne vorhandenen Patch, bitte warten' ),
		( 'Patch loaded', 'Patch geladen' ),
		( 'Loading', 'Lade' ),
		( 'Choose your UO directory', 'Whle dein UO-Verzeichnis' ),
                ( 'Local version', 'Lokale Version' ),
                ( 'Server version', 'Server Version' ),
                ( 'Cancel', 'Abbrechen' ),
                ( 'Patcherversion', 'Patcherversion' ),
                ( 'Patch interrupted', 'Patch unterbrochen' ),
                ( 'Current patch', 'Momentaner Patch' ),
                ( 'Whole patching', 'Gesamter Patchvorgang' ),
                ( 'Jumping to', 'Springe zu Patch: ' ),
                ( 'Deleting existing patch, please wait', 'Lsche vorhandenen Patch, bitte warten' ),
                ( 'Renaming downloaded patch, please wait', 'Benenne geladenen Patch um, bitte warten' ),
                ( 'Trying to load patch %d (%d/3)', 'Versuche Patch %d zu laden (%d/3)' ) 
                );

type    TProgressRecord = Record
                Offset : Integer;
                Length : Integer;
                Id : Integer;
                TypeId : Integer;
        end;

        TPatchThread = Class( TThread )
                protected
                        procedure Execute; override;
                        function Entpacken : TFileStream;
                public
                        FPackedStream : TStream;
                        procedure ProgressCallback(Current: integer);                        
        end;

        TPatcher = class(TForm)
                Balken: TrmGauge;
                BalkenGesamt: TrmGauge;
                HTTP: TIdHTTP;
                Memo: TMemo;
                Menge: TLabel;
                Geschw: TLabel;
                btnCancel: TButton;
                Banner: TImage;
                MemoShardinfo: TMemo;
                Version: TLabel;
                CookieMan: TIdCookieManager;
                procedure HTTPWork(Sender: TObject; AWorkMode: TWorkMode; const AWorkCount: Integer);
                procedure HTTPWorkEnd(Sender: TObject; AWorkMode: TWorkMode);
                procedure HTTPWorkBegin(Sender: TObject; AWorkMode: TWorkMode; const AWorkCountMax: Integer);
                procedure btnCancelClick(Sender: TObject);
                procedure CookieManNewCookie(ASender: TObject; ACookie: TIdCookieRFC2109; var VAccept: Boolean);
        private
                { Private declarations }
                SessId : String;
                Ending : Boolean;
                CustomCaption : String;
                Lang : TIniFile;                
        public
                MulEncrypt : Boolean;
                MulCrypt : TMulCrypt;
                ShardConfig : TConfig;
                Path : String;
                SizeLastTick, LastTick, StartSize : Integer;
                PatchThread : TPatchThread;
                FileCache : TFileCache;
                JumpTo : Integer;
                procedure StartPatcher;
                procedure Log( zeile : String );
                procedure ApplyPatch( FPackedStream : TFileStream );
                function SpecialInputBox( const ACaption, APrompt : string; var ADefault: string; Password : Boolean = False ) : Boolean;
                function SpecialInputQuery( const ACaption, APrompt: string; Password : Boolean; var Value: string ) : Boolean;
                function GetLang( Value : String ) : String;
                function GetTypeString( Value : Byte ) : String;
                function DecryptProgressRecord( ProgressRecord : TProgressRecord ) : TProgressRecord;
                function EncryptProgressRecord( ProgressRecord : TProgressRecord ) : TProgressRecord;
                { Public declarations }
        end;

        TIndex = packed record
                Lookup, Length, Tag, Typ : integer;
        end;

        TUOIndex = TIndexRecord;

        TMapTile = packed record
                Tile : word;
                Hoehe : shortint;
        end;

        TMapBlock = packed record
                Header: Cardinal;
                Cells: Array[0..63] of TMapTile;
        end;

        TMapBlockPatch = packed record
                Cells: Array[0..63] of TMapTile;
        end;

        TLandTile = packed record
                Flags : longword;
                TexID : word;
                Name : array[0..19] of char;
        end;

        TStaticTile = packed record
                Flags : longword;
                Weight, Quality : byte;
                Unknown : word;
                Unknown2 : byte;
                Quantity : byte;
                AnimID : word;
                Unknown3, Hue, Unknown4, Unknown5, Height : byte;
                Name : array[0..19] of char;
        end;

var
        Patcher: TPatcher;
        FileSuffix : String;
        TotalSize : Integer;       

implementation

{$R *.dfm}

uses    uShardSelect;

procedure Log( Zeile : String );
begin
        Patcher.Log( Zeile );
end;

function TPatcher.GetTypeString( Value : Byte ) : String;
begin
        Case Value of
                typ_nonpatch : Result := 'copying file';
                typ_anim  : Result := 'animation';
                typ_anim2 : Result := 'animation2';
                typ_anim3 : Result := 'animation3';
                typ_anim4 : Result := 'animation4';
                typ_anim5 : Result := 'animation5';
                typ_art : Result := 'art';
                typ_gump : Result := 'gumpart';
                typ_tex : Result := 'textures';
                typ_static : Result := 'statics';
                typ_map : Result := 'map';
                typ_map_variabel : Result := 'map';
                typ_tiledata : Result := 'tiledata';
                typ_radarcol : Result := 'radarcol';
                typ_sound : Result := 'sound';
                typ_befehl : Result := 'command';
                typ_map2 : Result := 'map2';
                typ_static2 : Result := 'statics2';
                typ_map3 : Result := 'map3';
                typ_static3 : Result := 'statics3';
                typ_map4 : Result := 'map4';
                typ_static4 : Result := 'static4';
                typ_tiledata_variabel : Result := 'variable_length_tiledata';
                typ_encrypt : Result := 'encrypt';
        else
                Result := IntToStr( Value );
        end;
end;

procedure TPatcher.Log( Zeile : String );
var     tFile : TextFile;
begin
        AssignFile( tFile, Path + 'patchlog.txt' );
        if FileExists( Path + 'patchlog.txt' ) then
                Append( tFile )
        else
                Rewrite( tFile );

        Writeln( tFile, zeile );
        CloseFile( tFile );
end;

procedure TPatcher.StartPatcher;
var     MStream : TMemoryStream;
        Ini, Nachrichten, Hashes : TMemIniFile;
        I, Auth, Count : Integer;
        VersionServer, VersionLokal : integer;
        FStream : TFileStream;
        FileName : String;
        Liste : TStringList;
        TmpList : TStringList;
        Value : String;
        EndSize : Integer;
        TmpStream : TMemoryStream;
        PatchURL, PatchHash : String;
begin
        Ending := False;

        Path := ExtractFilePath( Application.ExeName ) + 'shards\' + Config.GetString( 'Shardname' ) + '\';

        ShardConfig := TConfig.Create;
        ShardConfig.Load( Path + 'config.xml' );

        MulEncrypt := False;

        try
                if FileExists( Path + 'log.txt' ) then
                       DeleteFile( Path + 'log.txt' );

                if ShardConfig.GetString( 'DataPath' ) <> '' then
                        Path := ShardConfig.GetString( 'DataPath' );

                if not DirectoryExists( Path + 'data' ) then
                        ForceDirectories( Path + 'data' );

                if not DirectoryExists( Path + 'patches' ) then
                        ForceDirectories( Path + 'patches' );

                if ShardConfig.GetInteger( 'SecToWaitAfterPatching' ) = 0 then
                        ShardConfig.SetInteger( 'SecToWaitAfterPatching', 5 );
                if ShardConfig.GetInteger( 'DoNotStartClientAfterPatching' ) = 0 then
                        ShardConfig.SetInteger( 'DoNotStartClientAfterPatching', 0 );
                if ShardConfig.GetInteger( 'ShowNotAlways' ) = 0 then
                        ShardConfig.SetInteger( 'ShowNotAlways', 0 );


                if ShardConfig.GetInteger( 'ShowNotAlways' ) = 0 then
                        Show;

                Lang := TIniFile.Create( ExtractFilePath( Application.ExeName ) + 'language.ini' );

                for I := 0 to LangValueCount-1 do
                        if not Lang.ValueExists( 'Language', LangValues[I][0] ) then
                                Lang.WriteString( 'Language', LangValues[I][0], LangValues[I][1] );
                btnCancel.Caption := GetLang( 'Cancel' );
                Balken.Hint := GetLang( 'Current patch' );
                BalkenGesamt.Hint := GetLang( 'Whole patching' );

                FileCache := TFileCache.Create( Path + 'data\' );

                CustomCaption := Config.GetString( 'Shardname' ) + ' Patcher';
                Patcher.Caption := CustomCaption;

                if ShardConfig.GetString( 'Banner' ) <> '' then
                        if FileExists( Path + ShardConfig.GetString( 'Banner' ) ) then
                                Banner.Picture.LoadFromFile( Path + ShardConfig.GetString( 'Banner' ) )
                        else
                                ShardConfig.SetString( 'Banner', '' );

                Memo.Lines.Add( GetLang( 'Connecting to the server' ) );

                MStream := TMemoryStream.Create;
                MStream.Seek( 0, soFromBeginning );

                HTTP.RedirectMaximum := 100;
                HTTP.HandleRedirects := True;
                HTTP.AllowCookies := True;
                StartSize := 0;

                HTTP.Request.ContentRangeStart := 0;
                HTTP.Get( ShardConfig.GetString( 'APAddress' ) + 'version.tdv', MStream );
                Memo.Lines.Add( GetLang( 'Checking version' ) );

                MStream.SaveToFile( Path + 'version.tdv' );
                MStream.Free;

                Ini := TMemIniFile.Create( Path + 'version.tdv' );

                DeleteFile( Path + 'version.tdv' );

                FileSuffix := Ini.ReadString( 'TDV', 'FileSuffix', 'tdv' );

                if Ini.ReadInteger( 'TDV', 'ShowPatcherOnlyForPatches', 0 ) > 0 then
                        ShardConfig.SetInteger( 'ShowNotAlways', 1 );

                if Ini.ReadString( 'TDV', 'Shardinfo', '' ) <> '' then begin
                        MemoShardinfo.Clear;

                        TmpList := TStringList.Create;
                        StrLib.Split( Ini.ReadString( 'TDV', 'Shardinfo', '' ), '\n', TmpList );
                        MemoShardinfo.Lines.AddStrings( TmpList );
                        TmpList.Free;
                end
                else
                        MemoShardinfo.Lines.Add( GetLang( 'No News existing' ) );

                if Ini.ReadString( 'TDV', 'Banner', '' ) <> ShardConfig.GetString( 'Banner' ) then begin
                        ShardConfig.SetString( 'Banner', Ini.ReadString( 'TDV', 'Banner', '' ) );
                        if ShardConfig.GetString( 'Banner' ) <> '' then begin
                                MStream := TMemoryStream.Create;
                                MStream.Seek( 0, soFromBeginning );
                                HTTP.Request.ContentRangeStart := 0;
                                HTTP.Get( ShardConfig.GetString( 'APAddress' ) + ShardConfig.GetString( 'Banner' ), MStream );
                                MStream.SaveToFile( Path + ShardConfig.GetString( 'Banner' ) );
                                MStream.Free;
                                Banner.Picture.LoadFromFile( Path + ShardConfig.GetString( 'Banner' ) );
                        end;
                end;

                Auth := Ini.ReadInteger( 'TDV', 'Auth', 0 );

                Memo.Lines.Add( GetLang( 'Local version' ) + ':' + ShardConfig.GetString( 'Versionname' ) );
                Memo.Lines.Add( GetLang( 'Server version' ) + ':' + Ini.ReadString( 'TDV', 'Versionname', '' ) );

                VersionLokal := ShardConfig.GetInteger( 'Version' );
                VersionServer := Ini.ReadInteger( 'TDV', 'Version', 0 );

                Memo.Lines.Add( '' );

                ShardConfig.SetInteger( 'MCrypt', Ini.ReadInteger( 'TDV', 'MCrypt', 0 ) );
                MulCrypt := nil;

                {if Ini.ReadInteger( 'TDV', 'MCrypt', 0 ) > 50 then begin
                        if Config.GetInteger( 'AFD' ) < 1 then begin
                                AFDForm.ShowModal;
                                Config.SetInteger( 'AFD', 1 );
                        end;
                end;}

                if VersionLokal = VersionServer then begin
                        Memo.Lines.Add( GetLang( 'Local version is up to date' ) );
                end
                else begin
                        Show;
                        Memo.Lines.Add( inttostr( VersionServer - VersionLokal ) + ' ' + GetLang( 'new patches' ) );

                        Nachrichten := nil;
                        if Ini.ReadInteger( 'TDV', 'PatchMessages', 0 ) > 0 then begin
                                FileName := Path + 'patches\messages.ini';
                                if FileExists( FileName ) then
                                        DeleteFile( FileName );
                                FStream := TFileStream.Create( FileName, fmCreate );
                                FStream.Seek( 0, soFromBeginning );
                                HTTP.Get( ShardConfig.GetString( 'APAddress' ) + 'messages.ini', FStream );
                                FStream.Free;

                                Nachrichten := TMemIniFile.Create( FileName );
                                DeleteFile( FileName );
                        end;

                        Hashes := nil;
                        if Ini.ReadInteger( 'TDV', 'Hashes', 0 ) > 0 then begin
                                FileName := Path + 'patches\hashes.ini';
                                if FileExists( FileName ) then
                                        DeleteFile( FileName );
                                FStream := TFileStream.Create( FileName, fmCreate );
                                FStream.Seek( 0, soFromBeginning );
                                HTTP.Get( ShardConfig.GetString( 'APAddress' ) + 'hashes.ini', FStream );
                                FStream.Free;

                                Hashes := TMemIniFile.Create( FileName );
                                DeleteFile( FileName );
                        end;

                        I := VersionLokal+1;
                        while I <= VersionServer do begin
                                MulEncrypt := False;

                                if Ending then
                                        break;
                                
                                if Nachrichten <> nil then begin
                                        MemoShardInfo.Clear;
                                        TmpList := TStringList.Create;
                                        StrLib.Split( Nachrichten.ReadString( 'Patch', IntToStr( i ), GetLang( 'No message' ) ), '\n', TmpList );
                                        MemoShardinfo.Lines.AddStrings( TmpList );
                                        TmpList.Free;
                                end;

                                if (Hashes <> nil) and (Hashes.ReadString( 'Patch', IntToStr( I ), '' ) <> '') and FileExists( ExtractFilePath( Application.ExeName ) + 'patches\patch_' + IntToStr( I ) + '.' + FileSuffix ) and (LowerCase(Hashes.ReadString( 'Patch', IntToStr( I ), '' )) <> LowerCase(MD5DigestToStr( MD5File( ExtractFilePath( Application.ExeName ) + 'patches\patch_' + IntToStr( I ) + '.' + FileSuffix )) ) ) then
                                        DeleteFile( ExtractFilePath( Application.ExeName ) + 'patches\patch_' + IntToStr( I ) + '.' + FileSuffix );

                                if Auth > 0 then begin
                                        Count := 0;
                                        SessID := '0';
                                        while Count < 3 do begin
                                                if ShardConfig.GetString( 'APLogin' ) = '' then begin
                                                        Value := '';
                                                        if not SpecialInputQuery( 'Login', 'Type in your Login (Patches)', False, Value ) then begin
                                                                Memo.Lines.SaveToFile( Path + 'patcher.log' );
                                                                ShardSelect.MayStart := False;
                                                                exit;
                                                        end;

                                                        ShardConfig.SetString( 'APLogin', Value );

                                                        Value := '';
                                                        if not SpecialInputQuery( 'Password', 'Type in your Password (Patches)', True, Value ) then begin
                                                                Memo.Lines.SaveToFile( Path + 'patcher.log' );
                                                                ShardSelect.MayStart := False;
                                                                exit;
                                                        end;

                                                        ShardConfig.SetString( 'APPassword', EncryptPassword( Value ) );
                                                end;

                                                HTTP.Request.ContentRangeStart := 0;
                                                HTTP.Response.ProcessHeaders;
                                                HTTP.Get( ShardConfig.GetString( 'APAddress' ) + 'patcher.php?action=authenticate&user=' + ShardConfig.GetString( 'APLogin' ) + '&password=' + LowerCase( Md5DigestToStr( Md5String( DecryptPassword( ShardConfig.GetString( 'APPassword' ) ) ) ) ) );
                                                if HTTP.Response.RawHeaders.Values[ 'patcher-auth' ] = 'ok' then
                                                        break
                                                else begin
                                                        Memo.Lines.Add( GetLang( 'Wrong login or password' ) );
                                                        ShardConfig.SetString( 'APLogin', '' );
                                                        ShardConfig.SetString( 'APPassword', '' );

                                                        if Count < 3 then
                                                                Continue;
                                                        Ini.Free;
                                                        if Nachrichten <> nil then
                                                                Nachrichten.Free;
                                                        if MulCrypt <> nil then
                                                                MulCrypt.Free;
                                                        Sleep( ShardConfig.GetInteger( 'SecToWaitAfterPatching' )*1000 );
                                                        Memo.Lines.SaveToFile( Path + 'patcher.log' );
                                                        ShardSelect.MayStart := False;
                                                        exit;
                                                end;
                                                Inc( Count );
                                        end;

                                        if Ini.ReadInteger( 'TDV', 'MCrypt', 0 ) > 0 then begin
                                                MulEncrypt := I >= Ini.ReadInteger( 'TDV', 'MCrypt', 0 );
                                                if MulCrypt = nil then begin
                                                        MulCrypt := TMulCrypt.Create( ShardConfig.GetString( 'APLogin' ), DecryptPassword( ShardConfig.GetString( 'APPassword' ) ), 1 );
                                                        if not MulCrypt.Test( 0 ) then begin
                                                                ShowMessage( 'Ihr seid nicht freigeschaltet um weiterzupatchen.' );
                                                                Halt;
                                                        end;
                                                end;
                                        end;
                                end;

                                Memo.Lines.Add( GetLang( 'Loading patch' ) + ': ' + IntToStr( I ) );

                                if not FileExists( Path + 'patches\patch_' + inttostr( i ) + '.' + FileSuffix ) then begin
                                        if Auth = 0 then begin
                                                if FileExists( ExtractFilePath( Application.ExeName ) + 'patches\download_' + inttostr( I ) + '.' + FileSuffix ) then
                                                        if Ini.ReadInteger( 'TDV', 'EnableDownloadResume', 0 ) > 0 then begin
                                                                Memo.Lines.Add( GetLang( 'Opening existing patch, please wait' ) );
                                                                FStream := TFileStream.Create( Path+ 'patches\download_' + inttostr( i ) + '.' + FileSuffix, fmOpenWrite );
                                                        end
                                                        else begin
                                                                DeleteFile( Path + 'patches\download_' + inttostr( I ) + '.' + FileSuffix );
                                                                FStream := TFileStream.Create( Path + 'patches\download_' + inttostr( I ) + '.' + FileSuffix, fmCreate );
                                                        end
                                                else
                                                        FStream := TFileStream.Create( Path + 'patches\download_' + inttostr( I ) + '.' + FileSuffix, fmCreate );
                                                FStream.Seek( 0, soFromEnd );
                                                StartSize := FStream.Size;
                                                HTTP.Request.ContentRangeStart := StartSize;
                                                HTTP.Get( ShardConfig.GetString( 'APAddress' ) + 'patch_' + inttostr( i ) + '.' + FileSuffix, FStream );

                                                FStream.Free;
                                                if Ending then begin
                                                        if Ini.ReadInteger( 'TDV', 'EnableDownloadResume', 0 ) = 0 then
                                                                DeleteFile( ExtractFilePath( Application.ExeName ) + 'patches\patch_' + inttostr( i ) + '.' + FileSuffix );
                                                        Ini.Free;
                                                        if Nachrichten <> nil then
                                                                Nachrichten.Free;
                                                        if MulCrypt <> nil then
                                                                MulCrypt.Free;                                                                
                                                        Sleep( ShardConfig.GetInteger( 'SecToWaitAfterPatching' )*1000 );
                                                        Memo.Lines.SaveToFile( Path + 'patcher.log' );
                                                        ShardSelect.MayStart := False;
                                                        exit;
                                                end
                                                else begin
                                                        RenameFile( Path + 'patches\download_' + inttostr( I ) + '.' + FileSuffix,  Path + 'patches\patch_' + inttostr( i ) + '.' + FileSuffix );
                                                end;
                                        end
                                        else begin
                                                Count := 0;
                                                while Count < 3 do begin
                                                        Memo.Lines.Add( Format( GetLang( 'Trying to load patch %d (%d/3)' ), [I,Count+1] ) );

                                                        TmpStream := TMemoryStream.Create;
                                                        HTTP.Get( ShardConfig.GetString( 'APAddress' ) + 'patcher.php?sessionId=' + SessID + '&request=' + 'patch_' + inttostr( i ) + '.' + FileSuffix + '&askformirror=askformirror', TmpStream );
                                                        PatchURL := LowerCase( HTTP.Response.RawHeaders.Values[ 'patch_url' ] );
                                                        PatchHash := LowerCase( HTTP.Response.RawHeaders.Values[ 'patch_verification' ] );
                                                        TmpStream.Free;

                                                        if PatchURL <> '' then begin
                                                                if FileExists( Path + 'patches\download_' + inttostr( I ) + '.' + FileSuffix ) then
                                                                        DeleteFile( Path + 'patches\download_' + inttostr( I ) + '.' + FileSuffix );

                                                                FStream := TFileStream.Create( ( Path + 'patches\download_' + inttostr( I ) + '.' + FileSuffix ), fmCreate );
                                                                HTTP.Get( PatchURL + '/' + 'patch_' + inttostr( I ) + '.' + FileSuffix, FStream );
                                                                EndSize := FStream.Size;

                                                                FStream.Free;
                                                        end
                                                        else begin
                                                                if FileExists( Path + 'patches\download_' + inttostr( I ) + '.' + FileSuffix ) then
                                                                        if Ini.ReadInteger( 'TDV', 'EnableDownloadResume', 0 ) > 0 then begin
                                                                                Memo.Lines.Add( GetLang( 'Opening existing patch, please wait' ) );
                                                                                FStream := TFileStream.Create( Path + 'patches\download_' + inttostr( I ) + '.' + FileSuffix, fmOpenWrite );

                                                                                if FStream.Size < 10*1024*1024 then begin
                                                                                        Memo.Lines.Add( GetLang( 'Deleting existing patch, please wait' ) );
                                                                                        FStream.Free;
                                                                                        DeleteFile( Path + 'patches\download_' + inttostr( I ) + '.' + FileSuffix );
                                                                                        FStream := TFileStream.Create( Path + 'patches\download_' + inttostr( I ) + '.' + FileSuffix, fmCreate );
                                                                                end;
                                                                        end
                                                                        else begin
                                                                                DeleteFile( Path + 'patches\download_' + inttostr( I ) + '.' + FileSuffix );
                                                                                FStream := TFileStream.Create( Path + 'patches\download_' + inttostr( I ) + '.' + FileSuffix, fmCreate );
                                                                        end
                                                                else
                                                                        FStream := TFileStream.Create( Path + 'patches\download_' + inttostr( I ) + '.' + FileSuffix, fmCreate );

                                                                FStream.Seek( 0, soFromEnd );
                                                                StartSize := FStream.Size;
                                                                HTTP.Request.ContentRangeStart := StartSize;
                                                                HTTP.Get( ShardConfig.GetString( 'APAddress' ) + 'patcher.php?sessionId=' + SessID + '&request=' + 'patch_' + inttostr( i ) + '.' + FileSuffix, FStream );
                                                                PatchHash := LowerCase( HTTP.Response.RawHeaders.Values[ 'patch_verification' ] );
                                                                EndSize := FStream.Size;
                                                                FStream.Free;
                                                        end;

                                                        if PatchHash = LowerCase( Md5DigestToStr( Md5File( Path + 'patches\download_' + inttostr( i ) + '.' + FileSuffix ) ) ) then begin
                                                                Memo.Lines.Add( GetLang( 'Renaming downloaded patch, please wait' ) );
                                                                RenameFile( Path + 'patches\download_' + inttostr( i ) + '.' + FileSuffix,  Path + 'patches\patch_' + inttostr( i ) + '.' + FileSuffix );
                                                                break;
                                                        end
                                                        else if Ending then begin
                                                                Memo.Lines.Add( 'Patch patch_' + inttostr( i ) + '.' + FileSuffix + ' seems to be defect, patch stopped.' );
                                                                if Ini.ReadInteger( 'TDV', 'EnableDownloadResume', 0 ) = 0 then
                                                                        DeleteFile( Path + 'patches\patch_' + inttostr( i ) + '.' + FileSuffix );
                                                                Ini.Free;
                                                                if Nachrichten <> nil then
                                                                        Nachrichten.Free;
                                                                if MulCrypt <> nil then
                                                                        MulCrypt.Free;
                                                                Sleep( ShardConfig.GetInteger( 'SecToWaitAfterPatching' )*1000 );
                                                                Memo.Lines.SaveToFile( Path + 'patcher.log' );
                                                                ShardSelect.MayStart := False;
                                                                exit;
                                                        end
                                                        else if HTTP.Response.ContentLength = EndSize then begin
                                                                DeleteFile( Path + 'patches\download_' + inttostr( i ) + '.' + FileSuffix );
                                                                Sleep( ShardConfig.GetInteger( 'SecToWaitAfterPatching' )*1000 );
                                                                Memo.Lines.SaveToFile( Path + 'patcher.log' );
                                                                ShardSelect.MayStart := False;
                                                                Exit;
                                                        end;
                                                        inc( Count );
                                                end;
                                        end;
                                        StartSize := 0;
                                end;

                                Memo.Lines.Add( GetLang( 'Patch loaded' ) );

                                JumpTo := I;

                                FStream := TFileStream.Create( Path + 'patches\patch_' + inttostr( I ) + '.' + FileSuffix, fmOpenRead );
                                ApplyPatch( FStream );

                                FStream.Free;
                                BalkenGesamt.Percent := trunc( 100*(I-VersionLokal)/(VersionServer-VersionLokal) );

                                I := JumpTo;

                                if not Ending then
                                        ShardConfig.SetInteger( 'Version', I );
                                Inc( I );
                        end;

                        if Nachrichten <> nil then
                                Nachrichten.Free;

                        FileCache.Free;

                        if not Ending then
                                ShardConfig.SetString( 'Versionname', Ini.ReadString( 'TDV', 'Versionname', '' ) );

                        Memo.Lines.SaveToFile( Path + 'patcher.log' );
                end;

                Sleep( ShardConfig.GetInteger( 'SecToWaitAfterPatching' )*1000 );
                Hide;

                if Ini.ReadInteger( 'TDV', 'Popup', 0 ) > 0 then begin
                        FileName := ExtractFilePath( Application.ExeName ) + 'temp\popup.txt';
                        if FileExists( FileName ) then
                                DeleteFile( FileName );
                        FStream := TFileStream.Create( FileName, fmCreate );
                        FStream.Seek( 0, soFromBeginning );
                        HTTP.Get( ShardConfig.GetString( 'Servername' ) + 'popup.txt', FStream );
                        FStream.Free;

                        Liste := TStringList.Create;
                        Liste.LoadFromFile( FileName );
                        DeleteFile( FileName );

                        MessageForm.LoadText( Liste );
                        MessageForm.ShowModal;

                        Liste.Free;
                end;

                Ini.Free;
                if MulCrypt <> nil then
                        MulCrypt.Free;
        except
                on E : Exception do begin
                        Memo.Lines.Add( E.Message );
                        Sleep( ShardConfig.GetInteger( 'SecToWaitAfterPatching' )*1000 );
                        Memo.Lines.SaveToFile( Path + 'patcher.log' );
                        ShardSelect.MayStart := False;
                        exit;
                end;
        end;

        ShardConfig.Free;
end;

procedure TPatcher.ApplyPatch( FPackedStream : TFileStream );
begin
        PatchThread := TPatchThread.Create( True );
        PatchThread.FPackedStream := FPackedStream;
        PatchThread.Execute;

        while not PatchThread.Terminated do begin
                Sleep( 10 );
                Application.ProcessMessages;
        end;

        PatchThread.Free;
end;

function TPatchThread.Entpacken : TFileStream;
var     DecompressStream : TPowerArcDecompressStream;
        TempStream : TMemoryStream;
        Len : Integer;
        Buff : Array[0..4095] of Byte;
        Buf : PByteArray;
begin
        Log( Patcher.GetLang( 'Creating tempfile' ) );

        FPackedStream.Seek( FPackedStream.Size-4, soFromBeginning );
        FPackedStream.Read( TotalSize, 4 );

        if TotalSize = 0 then begin
                Log( 'TotalSize: 0' );
                Terminate;
                Result := nil;
                exit;
        end;

        if DiskFree( 0 ) <= TotalSize then
                raise Exception.Create( Patcher.GetLang( 'Not enough free disk memory' ) );

        if FileExists( Patcher.Path + 'patches\temp.' + FileSuffix ) then
                DeleteFile( Patcher.Path + 'patches\temp.' + FileSuffix );

        Result := TFileStream.Create( Patcher.Path + 'patches\temp.' + FileSuffix, fmCreate );
        Result.Seek( 0, soFromBeginning );
        
        FPackedStream.Seek( 0, soFromBeginning );

        TempStream := TMemoryStream.Create;
        TempStream.Seek( 0, soFromBeginning );

        GetMem( Buf, FPackedStream.Size-4 );
        FPackedStream.Read( Buf^, FPackedStream.Size-4 );
        TempStream.Write( Buf^, FPackedStream.Size-4 );
        FreeMem( Buf, FPackedStream.Size-4 );

        TempStream.Seek( 0, soFromBeginning );

        Patcher.Memo.Lines.Add( Patcher.GetLang( 'Decompressing patch' ) );
        Log( Patcher.GetLang( 'Start decompressing' ) );

        DecompressStream := TPowerArcDecompressStream.Create( TempStream );
        try
                DecompressStream.OnProgress := ProgressCallback;
                Len := DecompressStream.Read( Buff[0], 4096 );
                while Len > 0 do begin
                        Result.Write( Buff[0], Len );
                        Len := DecompressStream.Read( Buff[0], 4096 );
                end;
        except
                on E: Exception do
                        raise Exception.Create( E.Message );
        end;
        DecompressStream.Free;
        TempStream.Free;
        Log( Patcher.GetLang( 'Decompressing finished' ) );
end;

procedure TPatchThread.Execute;
var     Index : TIndex;
        MStream, IndexFile, DataFile, FStream : TFileStream;
        MapMul, StaIdx, StaMul : TFileStream;
        Buf : PByteArray;
        Name : array[0..30] of Char;
        NameNew, ReIndexTyp : string;
        UOIndex, IndexRecord : TIndexRecord;
        CryptRecord : TIndexRecord;
        I, J, Pos, Count, Header : Integer;
        LandTile : TLandTile;
        StaticTile, TmpStaticTile : TStaticTile;
        MapTile, Cell : TMapTile;
        MapBlock : TMapBlockPatch;
        MapBlockNew : TMapBlock;
        Changed : Boolean;
        OldIdx, OldMul, NewIdx, NewMul : TFileStream;
        IndexOld, IndexNew : TUOIndex;
        Path : String;
        MinX, MaxX, MinY, MaxY : Integer;
        MapHoehe : Word;
        Delta, X, Y : Integer;
        ChangeMap, ChangeStatic, MapNr : Byte;
        BlockId : LongWord;
        SX, SY, B : Byte;
        SZ : ShortInt;
        Id, Color : Word;
        Rand : Integer;
        ProgressStaticArt : Array[0..$7FFF] of Integer;
        ProgressGumps : Array[0..$FFFF] of Integer;
        ProgressRecord : TProgressRecord;
        ProgressLoaded : Boolean;
begin
        ProgressLoaded := False;
        Path := Patcher.Path;
        Log( Patcher.GetLang( 'Starting patch' ) );
        if Patcher.MulEncrypt then
                Log( 'MulEncryption activated.' );

        try
                MStream := Entpacken;
        except
                on E : Exception do begin
                        raise Exception.Create( E.Message );
                        exit;
                end;
        end;

        if MStream = nil then begin
                Log( Patcher.GetLang( 'Deleting tempfile' ) );
                DeleteFile( ExtractFilePath( Application.ExeName ) + 'patches\temp.' + FileSuffix );
                exit;
        end;

        Patcher.Memo.Lines.Add( Patcher.GetLang( 'Installing patch' ) );

        MStream.Seek( 0, soFromBeginning );

        while MStream.Position < MStream.Size do begin
                if Patcher.Ending then
                        break;
                Patcher.Balken.Percent := Trunc( 100 * MStream.Position / MStream.Size );
                MStream.Read( Index, sizeof( TIndex ) );
                //nonpatch
                Log( Patcher.GetLang( 'Next index' ) + ': ' + Patcher.GetTypeString( Index.Typ ) + ', Id:' + IntToStr( Index.Lookup div 12 ) );
                if Index.Typ = typ_nonpatch then begin
                        MStream.Read( Name, 30 );
                        NameNew := Name;
                        Log( NameNew );
                        Patcher.FileCache.FreeFile( NameNew );
                        if FileExists( Path + 'data\' + NameNew ) then
                                DeleteFile( Path + 'data\' + NameNew );

                        FStream := TFileStream.Create( Path + 'data\' + NameNew, fmCreate );

                        GetMem( Buf, Index.Length );
                        Log( Patcher.GetLang( 'Creating memorystream' ) );
                        MStream.Read( Buf^, Index.Length );
                        Log( Patcher.GetLang( 'Saving memoryStream to' ) + ' data\' + NameNew );
                        FStream.Write( Buf^, Index.Length );
                        FreeMem( Buf, Index.Length );

                        FStream.Free;                        
                        Log( Patcher.GetLang( 'Index done' ) );
                end;
                //Config Files
                if Index.Typ = typ_config then begin
                        MStream.Read( Name, 30 );
                        NameNew := Name;
                        Patcher.FileCache.FreeFile( NameNew );

                        if not DirectoryExists( Path + 'config' ) then
                                ForceDirectories( Path + 'config' );

                        if FileExists( Path + 'config\' + NameNew ) then
                                DeleteFile( Path + 'config\' + NameNew );

                        FStream := TFileStream.Create( Path + 'config\' + NameNew, fmCreate );

                        GetMem( Buf, Index.Length );
                        Log( Patcher.GetLang( 'Creating memorystream' ) );
                        MStream.Read( Buf^, Index.Length );
                        Log( Patcher.GetLang( 'Saving memoryStream to' ) + ' config\' + NameNew );
                        FStream.Write( Buf^, Index.Length );
                        FreeMem( Buf, Index.Length );

                        FStream.Free;                        
                        Log( Patcher.GetLang( 'Index done' ) );
                end;
                //Pythonscript Files
                if Index.Typ = typ_script then begin
                        MStream.Read( Name, 30 );
                        NameNew := Name;
                        Patcher.FileCache.FreeFile( NameNew );

                        if not DirectoryExists( Path + 'script' ) then
                                ForceDirectories( Path + 'script' );

                        if FileExists( Path + 'script\' + NameNew ) then
                                DeleteFile( Path + 'script\' + NameNew );

                        FStream := TFileStream.Create( Path + 'script\' + NameNew, fmCreate );

                        GetMem( Buf, Index.Length );
                        Log( Patcher.GetLang( 'Creating memorystream' ) );
                        MStream.Read( Buf^, Index.Length );
                        Log( Patcher.GetLang( 'Saving memoryStream to' ) + ' script\' + NameNew );
                        FStream.Write( Buf^, Index.Length );
                        FreeMem( Buf, Index.Length );

                        FStream.Free;                        
                        Log( Patcher.GetLang( 'Index done' ) );
                end;
                //Encrypt ArtIdx.mul, GumpIdx.mul and Anim.idx
                if Index.Typ = typ_encrypt then begin
                        {if not Patcher.MulEncrypt then begin
                                continue;
                        end;

                        IndexFile := Patcher.FileCache.GetFileStream( 'artidx.mul' );
                        IndexFile.Seek( 0, soFromBeginning );

                        while IndexFile.Position < IndexFile.Size do begin
                                IndexFile.Read( CryptRecord, 12 );
                                IndexFile.Seek( -12, soFromCurrent );

                                Patcher.MulCrypt.EncryptIndexRecordArt( IndexFile.Position div 12, CryptRecord );
                                IndexFile.Write( CryptRecord, 12 );
                        end;

                        IndexFile := Patcher.FileCache.GetFileStream( 'gumpidx.mul' );
                        IndexFile.Seek( 0, soFromBeginning );

                        while IndexFile.Position < IndexFile.Size do begin
                                IndexFile.Read( CryptRecord, 12 );
                                IndexFile.Seek( -12, soFromCurrent );

                                Patcher.MulCrypt.EncryptIndexRecordGump( IndexFile.Position div 12, CryptRecord );
                                IndexFile.Write( CryptRecord, 12 );
                        end;

                        IndexFile := Patcher.FileCache.GetFileStream( 'texidx.mul' );
                        IndexFile.Seek( 0, soFromBeginning );

                        while IndexFile.Position < IndexFile.Size do begin
                                IndexFile.Read( CryptRecord, 12 );
                                IndexFile.Seek( -12, soFromCurrent );

                                Patcher.MulCrypt.EncryptIndexRecordTex( IndexFile.Position div 12, CryptRecord );
                                IndexFile.Write( CryptRecord, 12 );
                        end;

                        IndexFile := Patcher.FileCache.GetFileStream( 'anim.idx' );
                        IndexFile.Seek( 0, soFromBeginning );

                        while IndexFile.Position < IndexFile.Size do begin
                                IndexFile.Read( CryptRecord, 12 );
                                IndexFile.Seek( -12, soFromCurrent );

                                Patcher.MulCrypt.EncryptIndexRecordAnim( IndexFile.Position div 12, CryptRecord );
                                IndexFile.Write( CryptRecord, 12 );
                        end;  }
                end;
                //Art
                if Index.Typ = typ_art then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'artidx.mul' );

                        if Patcher.MulEncrypt then begin
                                CryptRecord.Lookup := Index.Lookup;
                                CryptRecord.Length := Index.Length;
                                CryptRecord.Tag := Index.Tag;

                                Patcher.MulCrypt.DecryptIndexRecordArt( Index.Typ, CryptRecord );

                                Index.Lookup := CryptRecord.Lookup;
                                Index.Length := CryptRecord.Length;
                                Index.Tag := CryptRecord.Tag;
                        end;

                        if Index.Lookup > IndexFile.Size then begin
                                IndexFile.Seek( ( IndexFile.Size div 12 )*12, soFromBeginning );

                                if Patcher.MulEncrypt then begin
                                        while IndexFile.Size < Index.Lookup do begin
                                                UOIndex.Lookup := -1;
                                                UOIndex.Length := -1;
                                                UOIndex.Tag := -1;
                                                Patcher.MulCrypt.EncryptIndexRecordArt( IndexFile.Position div 12, UOIndex );
                                                IndexFile.Write( UOIndex, sizeof( TUOIndex ) );
                                        end;
                                end
                                else begin
                                        UOIndex.Lookup := -1;
                                        UOIndex.Length := -1;
                                        UOIndex.Tag := -1;
                                        while IndexFile.Size < Index.Lookup do
                                                IndexFile.Write( UOIndex, sizeof( TUOIndex ) );
                                end;
                        end;

                        IndexFile.Seek( Index.Lookup, soFromBeginning );
                        DataFile := Patcher.FileCache.GetFileStream( 'art.mul' );
                        DataFile.Seek( 0, soFromEnd );

                        Rand := Random( 16 );
                        for I := 0 to Rand do begin
                                B := Random( 256 );
                                DataFile.Write( B, 1 );
                        end;

                        UOIndex.Lookup := DataFile.Position;
                        UOIndex.Length := Index.Length;
                        UOIndex.Tag := Index.Tag;

                        Log( Patcher.GetLang( 'Patching' ) + ' Art' );

                        GetMem( Buf, UOIndex.Length );
                        MStream.Read( Buf^, UOIndex.Length );
                        DataFile.Write( Buf^, UOIndex.Length );
                        FreeMem( Buf, UOIndex.Length );

                        if Patcher.MulEncrypt then begin
                                Patcher.MulCrypt.EncryptIndexRecordArt( IndexFile.Position div 12, UOIndex );
                        end;

                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );

                        Log( 'Art ' + Patcher.GetLang( 'Done' ) );
                end;
                //Gumps
                if Index.Typ = typ_gump then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'gumpidx.mul' );

                        if Patcher.MulEncrypt then begin
                                CryptRecord.Lookup := Index.Lookup;
                                CryptRecord.Length := Index.Length;
                                CryptRecord.Tag := Index.Tag;

                                Patcher.MulCrypt.DecryptIndexRecordGump( Index.Typ, CryptRecord );

                                Index.Lookup := CryptRecord.Lookup;
                                Index.Length := CryptRecord.Length;
                                Index.Tag := CryptRecord.Tag;
                        end;

                        if Index.Lookup > IndexFile.Size then begin
                                IndexFile.Seek( ( IndexFile.Size div 12 )*12, soFromBeginning );

                                if Patcher.MulEncrypt then begin
                                        while IndexFile.Size < Index.Lookup do begin
                                                UOIndex.Lookup := -1;
                                                UOIndex.Length := -1;
                                                UOIndex.Tag := -1;
                                                Patcher.MulCrypt.EncryptIndexRecordGump( IndexFile.Position div 12, UOIndex );
                                                IndexFile.Write( UOIndex, sizeof( TUOIndex ) );
                                        end;
                                end
                                else begin
                                        UOIndex.Lookup := -1;
                                        UOIndex.Length := -1;
                                        UOIndex.Tag := -1;
                                        while IndexFile.Size < Index.Lookup do
                                                IndexFile.Write( UOIndex, sizeof( TUOIndex ) );
                                end;
                        end;

                        IndexFile.Seek( Index.Lookup, soFromBeginning );
                        DataFile := Patcher.FileCache.GetFileStream( 'gumpart.mul' );
                        DataFile.Seek( 0, soFromEnd );

                        Rand := Random( 16 );
                        for I := 0 to Rand do begin
                                B := Random( 256 );
                                DataFile.Write( B, 1 );
                        end;

                        UOIndex.Lookup := DataFile.Position;
                        UOIndex.Length := Index.Length;
                        UOIndex.Tag := Index.Tag;
                        Log( Patcher.GetLang( 'Patching' ) + ' Gump' );

                        GetMem( Buf, UOIndex.Length );
                        MStream.Read( Buf^, UOIndex.Length );
                        DataFile.Write( Buf^, UOIndex.Length );
                        FreeMem( Buf, UOIndex.Length );

                        if Patcher.MulEncrypt then begin
                                Patcher.MulCrypt.EncryptIndexRecordGump( IndexFile.Position div 12, UOIndex );
                        end;

                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );

                        Log( 'Gump ' + Patcher.GetLang( 'Done' ) );
                end;
                //Texturen
                if Index.Typ = typ_tex then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'texidx.mul' );

                        if Patcher.MulEncrypt then begin
                                CryptRecord.Lookup := Index.Lookup;
                                CryptRecord.Length := Index.Length;
                                CryptRecord.Tag := Index.Tag;

                                Patcher.MulCrypt.DecryptIndexRecordTex( Index.Typ, CryptRecord );

                                Index.Lookup := CryptRecord.Lookup;
                                Index.Length := CryptRecord.Length;
                                Index.Tag := CryptRecord.Tag;
                        end;

                        if Index.Lookup > IndexFile.Size then begin
                                IndexFile.Seek( ( IndexFile.Size div 12 )*12, soFromBeginning );

                                if Patcher.MulEncrypt then begin
                                        while IndexFile.Size < Index.Lookup do begin
                                                UOIndex.Lookup := -1;
                                                UOIndex.Length := -1;
                                                UOIndex.Tag := -1;
                                                Patcher.MulCrypt.EncryptIndexRecordTex( IndexFile.Position div 12, UOIndex );
                                                IndexFile.Write( UOIndex, sizeof( TUOIndex ) );
                                        end;
                                end
                                else begin
                                        UOIndex.Lookup := -1;
                                        UOIndex.Length := -1;
                                        UOIndex.Tag := -1;
                                        while IndexFile.Size < Index.Lookup do
                                                IndexFile.Write( UOIndex, sizeof( TUOIndex ) );
                                end;
                        end;

                        IndexFile.Seek( Index.Lookup, soFromBeginning );
                        DataFile := Patcher.FileCache.GetFileStream( 'texmaps.mul' );
                        DataFile.Seek( 0, soFromEnd );

                        Rand := Random( 16 );
                        for I := 0 to Rand do begin
                                B := Random( 256 );
                                DataFile.Write( B, 1 );
                        end;

                        UOIndex.Lookup := DataFile.Position;
                        UOIndex.Length := Index.Length;
                        UOIndex.Tag := Index.Tag;
                        Log( Patcher.GetLang( 'Patching' ) + ' Textures' );

                        GetMem( Buf, UOIndex.Length );
                        MStream.Read( Buf^, UOIndex.Length );
                        DataFile.Write( Buf^, UOIndex.Length );
                        FreeMem( Buf, UOIndex.Length );

                        if Patcher.MulEncrypt then begin
                                Patcher.MulCrypt.EncryptIndexRecordTex( IndexFile.Position div 12, UOIndex );
                        end;

                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );

                        Log( 'Textures ' + Patcher.GetLang( 'Done' ) );
                end;
                //Anims
                if Index.Typ = typ_anim then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'anim.idx' );

                        if Patcher.MulEncrypt then begin
                                CryptRecord.Lookup := Index.Lookup;
                                CryptRecord.Length := Index.Length;
                                CryptRecord.Tag := Index.Tag;

                                Patcher.MulCrypt.DecryptIndexRecordAnim( Index.Typ, CryptRecord );

                                Index.Lookup := CryptRecord.Lookup;
                                Index.Length := CryptRecord.Length;
                                Index.Tag := CryptRecord.Tag;
                        end;

                        if Index.Lookup > IndexFile.Size then begin
                                IndexFile.Seek( ( IndexFile.Size div 12 )*12, soFromBeginning );

                                if Patcher.MulEncrypt then begin
                                        while IndexFile.Size < Index.Lookup do begin
                                                UOIndex.Lookup := -1;
                                                UOIndex.Length := -1;
                                                UOIndex.Tag := -1;
                                                Patcher.MulCrypt.EncryptIndexRecordAnim( IndexFile.Position div 12, UOIndex );
                                                IndexFile.Write( UOIndex, sizeof( TUOIndex ) );
                                        end;
                                end
                                else begin
                                        UOIndex.Lookup := -1;
                                        UOIndex.Length := -1;
                                        UOIndex.Tag := -1;
                                        while IndexFile.Size < Index.Lookup do
                                                IndexFile.Write( UOIndex, sizeof( TUOIndex ) );
                                end;
                        end;

                        IndexFile.Seek( Index.Lookup, soFromBeginning );
                        DataFile := Patcher.FileCache.GetFileStream( 'anim.mul' );
                        DataFile.Seek( 0, soFromEnd );

                        Rand := Random( 16 );
                        for I := 0 to Rand do begin
                                B := Random( 256 );
                                DataFile.Write( B, 1 );
                        end;

                        UOIndex.Lookup := DataFile.Position;
                        UOIndex.Length := Index.Length;
                        UOIndex.Tag := Index.Tag;
                        
                        Log( Format( Patcher.GetLang( 'Patching' ) + ' Anim 0x%x', [Index.Lookup div 12] ) );

                        GetMem( Buf, UOIndex.Length );
                        MStream.Read( Buf^, UOIndex.Length );
                        DataFile.Write( Buf^, UOIndex.Length );
                        FreeMem( Buf, UOIndex.Length );

                        if Patcher.MulEncrypt then begin
                                Patcher.MulCrypt.EncryptIndexRecordAnim( IndexFile.Position div 12, UOIndex );
                        end;

                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );

                        Log( 'Anim ' + Patcher.GetLang( 'Done' ) );
                end;
                //Anims2
                if Index.Typ = typ_anim2 then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'anim2.idx' );

                        if Index.Lookup > IndexFile.Size then begin
                                IndexFile.Seek( 0, soFromEnd );
                                UOIndex.Lookup := -1;
                                UOIndex.Length := -1;
                                UOIndex.Tag := -1;
                                while IndexFile.Size < Index.Lookup do
                                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );
                        end;

                        IndexFile.Seek( Index.Lookup, soFromBeginning );
                        DataFile := Patcher.FileCache.GetFileStream( 'anim2.mul' );
                        DataFile.Seek( 0, soFromEnd );
                        UOIndex.Lookup := DataFile.Position;
                        UOIndex.Length := Index.Length;
                        UOIndex.Tag := Index.Tag;
                        Log( Format( Patcher.GetLang( 'Patching' ) + ' Anim2 0x%x', [Index.Lookup div 12] ) );
                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );

                        GetMem( Buf, UOIndex.Length );
                        MStream.Read( Buf^, UOIndex.Length );
                        DataFile.Write( Buf^, UOIndex.Length );
                        FreeMem( Buf, UOIndex.Length );

                        Log( 'Anim2 ' + Patcher.GetLang( 'Done' ) );
                end;
                //Anims3
                if Index.Typ = typ_anim3 then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'anim3.idx' );

                        if Index.Lookup > IndexFile.Size then begin
                                IndexFile.Seek( 0, soFromEnd );
                                UOIndex.Lookup := -1;
                                UOIndex.Length := -1;
                                UOIndex.Tag := -1;
                                while IndexFile.Size < Index.Lookup do
                                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );
                        end;

                        IndexFile.Seek( Index.Lookup, soFromBeginning );
                        DataFile := Patcher.FileCache.GetFileStream( 'anim3.mul' );
                        DataFile.Seek( 0, soFromEnd );
                        UOIndex.Lookup := DataFile.Position;
                        UOIndex.Length := Index.Length;
                        UOIndex.Tag := Index.Tag;
                        Log( Format( Patcher.GetLang( 'Patching' ) + ' Anim3 0x%x', [Index.Lookup div 12] ) );
                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );

                        GetMem( Buf, UOIndex.Length );
                        MStream.Read( Buf^, UOIndex.Length );
                        DataFile.Write( Buf^, UOIndex.Length );
                        FreeMem( Buf, UOIndex.Length );

                        Log( 'Anim3 ' + Patcher.GetLang( 'Done' ) );
                end;
                //Anims4
                if Index.Typ = typ_anim4 then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'anim4.idx' );

                        if Index.Lookup > IndexFile.Size then begin
                                IndexFile.Seek( 0, soFromEnd );
                                UOIndex.Lookup := -1;
                                UOIndex.Length := -1;
                                UOIndex.Tag := -1;
                                while IndexFile.Size < Index.Lookup do
                                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );
                        end;

                        IndexFile.Seek( Index.Lookup, soFromBeginning );
                        DataFile := Patcher.FileCache.GetFileStream( 'anim4.mul' );
                        DataFile.Seek( 0, soFromEnd );
                        UOIndex.Lookup := DataFile.Position;
                        UOIndex.Length := Index.Length;
                        UOIndex.Tag := Index.Tag;
                        Log( Format( Patcher.GetLang( 'Patching' ) + ' Anim4 0x%x', [Index.Lookup div 12] ) );
                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );

                        GetMem( Buf, UOIndex.Length );
                        MStream.Read( Buf^, UOIndex.Length );
                        DataFile.Write( Buf^, UOIndex.Length );
                        FreeMem( Buf, UOIndex.Length );

                        Log( 'Anim4 ' + Patcher.GetLang( 'Done' ) );
                end;
                //Anims5
                if Index.Typ = typ_anim5 then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'anim5.idx' );

                        if Index.Lookup > IndexFile.Size then begin
                                IndexFile.Seek( 0, soFromEnd );
                                UOIndex.Lookup := -1;
                                UOIndex.Length := -1;
                                UOIndex.Tag := -1;
                                while IndexFile.Size < Index.Lookup do
                                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );
                        end;

                        IndexFile.Seek( Index.Lookup, soFromBeginning );
                        DataFile := Patcher.FileCache.GetFileStream( 'anim5.mul' );
                        DataFile.Seek( 0, soFromEnd );
                        UOIndex.Lookup := DataFile.Position;
                        UOIndex.Length := Index.Length;
                        UOIndex.Tag := Index.Tag;
                        Log( Format( Patcher.GetLang( 'Patching' ) + ' Anim5 0x%x', [Index.Lookup div 12] ) );
                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );

                        GetMem( Buf, UOIndex.Length );
                        MStream.Read( Buf^, UOIndex.Length );
                        DataFile.Write( Buf^, UOIndex.Length );
                        FreeMem( Buf, UOIndex.Length );

                        Log( 'Anim5 ' + Patcher.GetLang( 'Done' ) );
                end;
                //Sounds
                if Index.Typ = typ_sound then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'soundidx.mul' );

                        if Index.Lookup > IndexFile.Size then begin
                                IndexFile.Seek( 0, soFromEnd );
                                UOIndex.Lookup := -1;
                                UOIndex.Length := -1;
                                UOIndex.Tag := -1;
                                while IndexFile.Size < Index.Lookup do
                                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );
                        end;

                        IndexFile.Seek( Index.Lookup, soFromBeginning );
                        DataFile := Patcher.FileCache.GetFileStream( 'sound.mul' );
                        DataFile.Seek( 0, soFromEnd );
                        UOIndex.Lookup := DataFile.Position;
                        UOIndex.Length := Index.Length;
                        UOIndex.Tag := Index.Tag;
                        Log( Patcher.GetLang( 'Patching' ) + ' Sound' );
                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );

                        GetMem( Buf, UOIndex.Length );
                        MStream.Read( Buf^, UOIndex.Length );
                        DataFile.Write( Buf^, UOIndex.Length );
                        FreeMem( Buf, UOIndex.Length );

                        Log( 'Sound ' + Patcher.GetLang( 'Done' ) );
                end;
                //Radarcol
                if Index.Typ = typ_radarcol then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'radarcol.mul' );
                        IndexFile.Seek( Index.Lookup, soFromBeginning );

                        Log( Patcher.GetLang( 'Patching' ) + ' Radarcol' );
                        for I := 1 to ( Index.Length div 2 ) do begin
                                MStream.Read( Color, 2 );
                                if Color <> 0 then begin
                                        IndexFile.Seek( (I-1)*2, soFromBeginning );
                                        IndexFile.Write( Color, 2 );
                                end;
                        end;
                        Log( 'Radarcol ' + Patcher.GetLang( 'Done' ) );
                end;
                //Tiledata
                if Index.Typ = typ_tiledata then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'tiledata.mul' );
                        IndexFile.Seek( Index.Lookup, soFromBeginning );

                        Log( Patcher.GetLang( 'Patching' ) + ' Landtiles' );
                        for I := 1 to 512*32 do begin
                                MStream.Read( LandTile, 26 );
                                NameNew := LandTile.Name;
                                if ( LandTile.Flags <> 0 ) or ( LandTile.TexID <> 0 ) or ( NameNew <> '' ) then begin
                                        IndexFile.Seek( (I-1)*26+(((I-1) div 32)+1)*4, soFromBeginning );
                                        IndexFile.Write( LandTile, 26 );
                                end;
                        end;
                        Log( Patcher.GetLang( 'Patching' ) + ' Statictiles' );
                        for I := 1 to 512*32 do begin
                                MStream.Read( StaticTile, 37 );
                                NameNew := StaticTile.Name;
                                if ( StaticTile.Flags <> 0 ) or ( StaticTile.Weight <> 0 ) or ( StaticTile.Quality <> 0 ) or ( StaticTile.Unknown <> 0 ) or ( StaticTile.Unknown2 <> 0 ) or ( StaticTile.Quantity <> 0 ) or ( StaticTile.AnimID <> 0 ) or ( StaticTile.Unknown3 <> 0 ) or ( StaticTile.Hue <> 0 ) or ( StaticTile.Unknown4 <> 0 ) or ( StaticTile.Unknown5 <> 0 ) or ( StaticTile.Height <> 0 ) or ( NameNew <> '' ) then begin
                                        IndexFile.Seek( 512*32*26+512*4+(I-1)*37+(((I-1) div 32)+1)*4, soFromBeginning );
                                        IndexFile.Write( StaticTile, 37 );
                                end;

                        end;
                        Log( 'Tiledata ' + Patcher.GetLang( 'Done' ) );
                end;
                //Tiledata variable Lnge
                if Index.Typ = typ_tiledata_variabel then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'tiledata.mul' );
                        IndexFile.Seek( Index.Lookup, soFromBeginning );

                        Log( Patcher.GetLang( 'Patching' ) + ' Landtiles' );
                        for I := 1 to 512*32 do begin
                                MStream.Read( LandTile, 26 );
                                NameNew := LandTile.Name;
                                if ( LandTile.Flags <> 0 ) or ( LandTile.TexID <> 0 ) or ( NameNew <> '' ) then begin
                                        IndexFile.Seek( (I-1)*26+(((I-1) div 32)+1)*4, soFromBeginning );
                                        IndexFile.Write( LandTile, 26 );
                                end;
                        end;

                        MStream.Read( Count, 4 );
                        Count := Count*32;
                        Log( Patcher.GetLang( 'Patching' ) + ' ' + IntToStr( Count ) + ' Statictiles' );

                        for I := 1 to Count do begin
                                MStream.Read( StaticTile, 37 );
                                NameNew := StaticTile.Name;
                                if ( StaticTile.Flags <> 0 ) or ( StaticTile.Weight <> 0 ) or ( StaticTile.Quality <> 0 ) or ( StaticTile.Unknown <> 0 ) or ( StaticTile.Unknown2 <> 0 ) or ( StaticTile.Quantity <> 0 ) or ( StaticTile.AnimID <> 0 ) or ( StaticTile.Unknown3 <> 0 ) or ( StaticTile.Hue <> 0 ) or ( StaticTile.Unknown4 <> 0 ) or ( StaticTile.Unknown5 <> 0 ) or ( StaticTile.Height <> 0 ) or ( NameNew <> '' ) then begin
                                        Pos := 512*32*26+512*4+(I-1)*37+(((I-1) div 32)+1)*4;
                                        if Pos > IndexFile.Size then begin
                                                FillChar( TmpStaticTile, 37, 0 );
                                                Header := 0;
                                                IndexFile.Seek( 0, soFromEnd );
                                                while Pos > IndexFile.Size do begin
                                                        IndexFile.Write( Header, 4 );
                                                        for J := 0 to 31 do
                                                                IndexFile.Write( TmpStaticTile, 37 );
                                                end;
                                        end;
                                        IndexFile.Seek( Pos, soFromBeginning );
                                        IndexFile.Write( StaticTile, 37 );
                                end;

                        end;
                        Log( 'Tiledata ' + Patcher.GetLang( 'Done' ) );
                end;
                //Statics
                if Index.Typ = typ_static then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'staidx0.mul' );

                        if Index.Lookup > IndexFile.Size then begin
                                IndexFile.Seek( 0, soFromEnd );
                                UOIndex.Lookup := -1;
                                UOIndex.Length := -1;
                                UOIndex.Tag := -1;
                                while IndexFile.Size < Index.Lookup do
                                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );
                        end;

                        IndexFile.Seek( Index.Lookup, soFromBeginning );
                        DataFile := Patcher.FileCache.GetFileStream( 'statics0.mul' );
                        DataFile.Seek( 0, soFromEnd );
                        
                        UOIndex.Lookup := DataFile.Position;
                        UOIndex.Length := Index.Length;
                        UOIndex.Tag := Index.Tag;
                        Log( Patcher.GetLang( 'Patching' ) + ' Statics' );
                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );

                        GetMem( Buf, UOIndex.Length );
                        MStream.Read( Buf^, UOIndex.Length );
                        DataFile.Write( Buf^, UOIndex.Length );
                        FreeMem( Buf, UOIndex.Length );

                        Log( 'Statics ' + Patcher.GetLang( 'Done' ) );
                end;
                //Statics2
                if Index.Typ = typ_static2 then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'staidx2.mul' );

                        if Index.Lookup > IndexFile.Size then begin
                                IndexFile.Seek( 0, soFromEnd );
                                UOIndex.Lookup := -1;
                                UOIndex.Length := -1;
                                UOIndex.Tag := -1;
                                while IndexFile.Size < Index.Lookup do
                                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );
                        end;

                        IndexFile.Seek( Index.Lookup, soFromBeginning );
                        DataFile := Patcher.FileCache.GetFileStream( 'statics2.mul' );
                        DataFile.Seek( 0, soFromEnd );
                        
                        UOIndex.Lookup := DataFile.Position;
                        UOIndex.Length := Index.Length;
                        UOIndex.Tag := Index.Tag;
                        Log( Patcher.GetLang( 'Patching' ) + ' Statics2' );
                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );

                        GetMem( Buf, UOIndex.Length );
                        MStream.Read( Buf^, UOIndex.Length );
                        DataFile.Write( Buf^, UOIndex.Length );
                        FreeMem( Buf, UOIndex.Length );

                        Log( 'Statics2 ' + Patcher.GetLang( 'Done' ) );
                end;
                //Statics3
                if Index.Typ = typ_static3 then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'staidx3.mul' );

                        if Index.Lookup > IndexFile.Size then begin
                                IndexFile.Seek( 0, soFromEnd );
                                UOIndex.Lookup := -1;
                                UOIndex.Length := -1;
                                UOIndex.Tag := -1;
                                while IndexFile.Size < Index.Lookup do
                                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );
                        end;

                        IndexFile.Seek( Index.Lookup, soFromBeginning );
                        DataFile := Patcher.FileCache.GetFileStream( 'statics3.mul' );
                        DataFile.Seek( 0, soFromEnd );
                        
                        UOIndex.Lookup := DataFile.Position;
                        UOIndex.Length := Index.Length;
                        UOIndex.Tag := Index.Tag;
                        Log( Patcher.GetLang( 'Patching' ) + ' Statics3' );
                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );

                        GetMem( Buf, UOIndex.Length );
                        MStream.Read( Buf^, UOIndex.Length );
                        DataFile.Write( Buf^, UOIndex.Length );
                        FreeMem( Buf, UOIndex.Length );

                        Log( 'Statics3 ' + Patcher.GetLang( 'Done' ) );
                end;
                //Statics4
                if Index.Typ = typ_static4 then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'staidx4.mul' );

                        if Index.Lookup > IndexFile.Size then begin
                                IndexFile.Seek( 0, soFromEnd );
                                UOIndex.Lookup := -1;
                                UOIndex.Length := -1;
                                UOIndex.Tag := -1;
                                while IndexFile.Size < Index.Lookup do
                                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );
                        end;

                        IndexFile.Seek( Index.Lookup, soFromBeginning );
                        DataFile := Patcher.FileCache.GetFileStream( 'statics4.mul' );
                        DataFile.Seek( 0, soFromEnd );
                        
                        UOIndex.Lookup := DataFile.Position;
                        UOIndex.Length := Index.Length;
                        UOIndex.Tag := Index.Tag;
                        Log( Patcher.GetLang( 'Patching' ) + ' Statics4' );
                        IndexFile.Write( UOIndex, sizeof( TUOIndex ) );

                        GetMem( Buf, UOIndex.Length );
                        MStream.Read( Buf^, UOIndex.Length );
                        DataFile.Write( Buf^, UOIndex.Length );
                        FreeMem( Buf, UOIndex.Length );

                        Log( 'Statics4 ' + Patcher.GetLang( 'Done' ) );
                end;
                //map
                if Index.Typ = typ_map then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'map0.mul' );
                        IndexFile.Seek( 0, soFromBeginning );

                        Log( Patcher.GetLang( 'Patching' ) + ' Map' );
                        for I := 1 to 768*512 do begin
                                Patcher.Geschw.Caption := IntToStr( trunc( I / ( 768*512/100 ) ) ) + ' %';
                                if I mod 10000 = 0 then
                                        Application.ProcessMessages;
                                MStream.Read( MapBlock, sizeof( TMapBlockPatch ) );
                                IndexFile.Read( MapBlockNew, sizeof( TMapBlock ) );
                                Changed := False;
                                for J := 0 to 63 do begin
                                        if ( MapBlock.Cells[ J ].Tile <> 0 ) or ( MapBlock.Cells[ J ].Hoehe <> 0 ) then begin
                                                MapBlockNew.Cells[ J ].Tile := MapBlock.Cells[ J ].Tile;
                                                MapBlockNew.Cells[ J ].Hoehe := MapBlock.Cells[ J ].Hoehe;
                                                Changed := true;
                                        end;
                                end;
                                if Changed then begin
                                        IndexFile.Seek( -sizeof( TMapBlock ), soFromCurrent );
                                        IndexFile.Write( MapBlockNew, sizeof( TMapBlock ) );
                                end;
                        end;
                        Patcher.Geschw.Caption := '';
                        Log( 'Map ' + Patcher.GetLang( 'Done' ) );
                end;
                //map variabel
                if Index.Typ = typ_map_variabel then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'map0.mul' );
                        IndexFile.Seek( 0, soFromBeginning );

                        Count := Index.Length div (64*3);

                        Log( Patcher.GetLang( 'Patching' ) + ' Map' );
                        for I := 1 to Count do begin
                                Patcher.Geschw.Caption := IntToStr( trunc( I / ( Count/100 ) ) ) + ' %';
                                if I mod 10000 = 0 then
                                        Application.ProcessMessages;
                                MStream.Read( MapBlock, sizeof( TMapBlockPatch ) );

                                if IndexFile.Position < IndexFile.Size then begin
                                        IndexFile.Read( MapBlockNew, sizeof( TMapBlock ) );
                                        Changed := False;
                                        for J := 0 to 63 do begin
                                                if ( MapBlock.Cells[ J ].Tile <> 0 ) or ( MapBlock.Cells[ J ].Hoehe <> 0 ) then begin
                                                        MapBlockNew.Cells[ J ].Tile := MapBlock.Cells[ J ].Tile;
                                                        MapBlockNew.Cells[ J ].Hoehe := MapBlock.Cells[ J ].Hoehe;
                                                        Changed := true;
                                                end;
                                        end;
                                        if Changed then begin
                                                IndexFile.Seek( -sizeof( TMapBlock ), soFromCurrent );
                                                IndexFile.Write( MapBlockNew, sizeof( TMapBlock ) );
                                        end;
                                end
                                else begin
                                        MapBlockNew.Header := 0;
                                        for J := 0 to 63 do begin
                                                MapBlockNew.Cells[ J ].Tile := MapBlock.Cells[ J ].Tile;
                                                MapBlockNew.Cells[ J ].Hoehe := MapBlock.Cells[ J ].Hoehe;
                                        end;
                                        IndexFile.Write( MapBlockNew, sizeof( TMapBlock ) );
                                end;
                        end;
                        Patcher.Geschw.Caption := '';
                        Log( 'Map ' + Patcher.GetLang( 'Done' ) );
                end;
                //map2
                if Index.Typ = typ_map2 then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'map2.mul' );
                        IndexFile.Seek( 0, soFromBeginning );

                        Log( Patcher.GetLang( 'Patching' ) + ' Map2' );
                        for I := 1 to 288*200 do begin
                                Patcher.Geschw.Caption := inttostr( trunc( I / ( 288*200/100 ) ) ) + ' %';
                                if I mod 10000 = 0 then
                                        Application.ProcessMessages;
                                MStream.Read( MapBlock, sizeof( TMapBlockPatch ) );
                                IndexFile.Read( MapBlockNew, sizeof( TMapBlock ) );
                                Changed := false;
                                for J := 0 to 63 do begin
                                        if ( MapBlock.Cells[ J ].Tile <> 0 ) or ( MapBlock.Cells[ J ].Hoehe <> 0 ) then begin
                                                MapBlockNew.Cells[ J ].Tile := MapBlock.Cells[ J ].Tile;
                                                MapBlockNew.Cells[ J ].Hoehe := MapBlock.Cells[ J ].Hoehe;
                                                changed := true;
                                        end;
                                end;
                                if Changed then begin
                                        IndexFile.Seek( -sizeof( TMapBlock ), soFromCurrent );
                                        IndexFile.Write( MapBlockNew, sizeof( TMapBlock ) );
                                end;
                        end;
                        Patcher.Geschw.Caption := '';
                        log( 'Map2 ' + Patcher.GetLang( 'Done' ) );
                end;
                //map3
                if Index.Typ = typ_map3 then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'map3.mul' );
                        IndexFile.Seek( 0, soFromBeginning );

                        Log( Patcher.GetLang( 'Patching' ) + ' Map3' );
                        for I := 1 to 320*256 do begin
                                Patcher.Geschw.Caption := Inttostr( trunc( I / ( 320*256/100 ) ) ) + ' %';
                                if I mod 10000 = 0 then
                                        Application.ProcessMessages;
                                MStream.Read( MapBlock, sizeof( TMapBlockPatch ) );
                                IndexFile.Read( MapBlockNew, sizeof( TMapBlock ) );
                                Changed := False;
                                for J := 0 to 63 do begin
                                        if ( MapBlock.Cells[ J ].Tile <> 0 ) or ( MapBlock.Cells[ J ].Hoehe <> 0 ) then begin
                                                MapBlockNew.Cells[ J ].Tile := MapBlock.Cells[ J ].Tile;
                                                MapBlockNew.Cells[ J ].Hoehe := MapBlock.Cells[ J ].Hoehe;
                                                Changed := true;
                                        end;
                                end;
                                if Changed then begin
                                        IndexFile.Seek( -sizeof( TMapBlock ), soFromCurrent );
                                        IndexFile.Write( MapBlockNew, sizeof( TMapBlock ) );
                                end;
                        end;
                        Patcher.Geschw.Caption := '';
                        Log( 'Map3 ' + Patcher.GetLang( 'Done' ) );
                end;
                //map4
                if Index.Typ = typ_map4 then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'map4.mul' );
                        IndexFile.Seek( 0, soFromBeginning );

                        Log( Patcher.GetLang( 'Patching' ) + ' Map4' );
                        for I := 1 to 181*181 do begin
                                Patcher.geschw.Caption := inttostr( trunc( I / ( 181*181/100 ) ) ) + ' %';
                                if I mod 10000 = 0 then
                                        Application.ProcessMessages;
                                MStream.Read( MapBlock, sizeof( TMapBlockPatch ) );
                                IndexFile.Read( MapBlockNew, sizeof( TMapBlock ) );
                                Changed := False;
                                for J := 0 to 63 do begin
                                        if ( MapBlock.Cells[ J ].Tile <> 0 ) or ( MapBlock.Cells[ J ].Hoehe <> 0 ) then begin
                                                MapBlockNew.Cells[ J ].Tile := MapBlock.Cells[ J ].Tile;
                                                MapBlockNew.Cells[ J ].Hoehe := MapBlock.Cells[ J ].Hoehe;
                                                Changed := true;
                                        end;
                                end;
                                if Changed then begin
                                        IndexFile.Seek( -sizeof( TMapBlock ), soFromCurrent );
                                        IndexFile.Write( MapBlockNew, sizeof( TMapBlock ) );
                                end;
                        end;
                        Patcher.geschw.Caption := '';
                        IndexFile.Free;
                        Log( 'Map4 ' + Patcher.GetLang( 'Done' ) );
                end;

                if Index.Typ = typ_progress then begin
                        IndexFile := Patcher.FileCache.GetFileStream( 'Progress.idx' );
                        DataFile := Patcher.FileCache.GetFileStream( 'Progress.mul' );

                        if not ProgressLoaded then begin
                                for j := 0 to $7FFF do begin
                                        ProgressStaticArt[j] := -1;
                                end;
                                for j := 0 to $FFFF do begin
                                        ProgressGumps[j] := -1;
                                end;

                                IndexFile.Seek( 0, soFromBeginning );
                                while IndexFile.Position < IndexFile.Size do begin
                                        IndexFile.Read( ProgressRecord, sizeof( TProgressRecord ) );
                                        Patcher.DecryptProgressRecord( ProgressRecord );
                                        Case ProgressRecord.TypeId of
                                                ProgressTypeStaticArt: ProgressStaticArt[ProgressRecord.Id] := IndexFile.Position - sizeof( TProgressRecord );
                                                ProgressTypeGumps: ProgressGumps[ProgressRecord.Id] := IndexFile.Position - sizeof( TProgressRecord );
                                        end;
                                end;
                                ProgressLoaded := True;
                        end;

                        MStream.Read( ProgressRecord, sizeof( TProgressRecord ) );
                        Patcher.DecryptProgressRecord( ProgressRecord );

                        Case ProgressRecord.TypeId of
                                ProgressTypeStaticArt: Pos := ProgressStaticArt[ProgressRecord.Id];
                                ProgressTypeGumps: Pos := ProgressGumps[ProgressRecord.Id];
                        else
                                Pos := -1;
                        end;

                        DataFile.Seek( 0, soFromEnd );
                        ProgressRecord.Offset := DataFile.Position;
                        DataFile.CopyFrom( MStream, ProgressRecord.Length );
                        if Pos <> -1 then begin
                                IndexFile.Seek( 0, soFromEnd );
                                Pos := IndexFile.Position;
                                ProgressStaticArt[ProgressRecord.Id] := Pos;
                        end else begin
                                IndexFile.Seek( Pos, soFromBeginning );
                        end;

                        Patcher.EncryptProgressRecord( ProgressRecord );
                        IndexFile.Write( ProgressRecord, sizeof( TProgressRecord ) );
                end;

                if Index.Typ = typ_befehl then begin
                        case Index.Tag of
                                JumpTo : begin
                                        Log( Patcher.GetLang( 'Jumping to' ) + IntToStr( Index.Lookup ) );
                                        Patcher.JumpTo := Index.Lookup;
                                        continue;
                                end;
                                ChangeHeight : begin
                                        MStream.Read( MinX, 4 );
                                        MStream.Read( MinY, 4 );
                                        MStream.Read( MaxX, 4 );
                                        MStream.Read( MaxY, 4 );

                                        MStream.Read( MapNr, 1 );
                                        MStream.Read( MapHoehe, 2 );
                                        MStream.Read( ChangeMap, 1 );
                                        MStream.Read( ChangeStatic, 1 );
                                        MStream.Read( Delta, 4 );

                                        Log( Format( 'CH: %d,%d %d,%d %d %d %d %d %d', [MinX, MinY, MaxX, MaxY, MapNr, MapHoehe, ChangeMap, ChangeStatic, Delta] ) );

                                        MapHoehe := MapHoehe div 8;

                                        if ChangeMap > 0 then
                                                MapMul := Patcher.FileCache.GetFileStream( Format( 'map%d.mul', [MapNr] ) );
                                        if ChangeStatic > 0 then begin
                                                StaIdx := Patcher.FileCache.GetFileStream( Format( 'staidx%d.mul', [MapNr] ) );
                                                StaMul := Patcher.FileCache.GetFileStream( Format( 'statics%d.mul', [MapNr] ) );
                                        end;

                                        for X := MinX to MaxX do begin
                                                for Y := MinY to MaxY do begin
                                                        BlockID := ( X div 8 ) * MapHoehe + ( Y div 8 );

                                                        if ChangeMap > 0 then begin
                                                                MapMul.Seek( BlockId*sizeof( TMapBlock ), soFromBeginning );
                                                                MapMul.Read( MapBlockNew, sizeof( TMapBlock ) );

                                                                MapBlockNew.Cells[ (Y mod 8)*8+(X mod 8) ].Hoehe := MapBlockNew.Cells[ (Y mod 8)*8+(X mod 8) ].Hoehe + Delta;

                                                                MapMul.Seek( BlockId*sizeof( TMapBlock ), soFromBeginning );
                                                                MapMul.Write( MapBlockNew, sizeof( TMapBlock ) );
                                                        end;

                                                        if ChangeStatic > 0 then begin
                                                                StaIdx.Seek( BlockId*12, soFromBeginning );
                                                                StaIdx.Read( IndexRecord, 12 );

                                                                if (IndexRecord.Lookup <> -1) and (IndexRecord.Length <> -1) then begin
                                                                        StaMul.Seek( IndexRecord.Lookup, soFromBeginning );

                                                                        while StaMul.Position < (IndexRecord.Lookup+IndexRecord.Length) do begin
                                                                                StaMul.Read( Id, 2 );
                                                                                StaMul.Read( SX, 1 );
                                                                                StaMul.Read( SY, 1 );
                                                                                StaMul.Read( SZ, 1 );

                                                                                if ((X mod 8) = SX) and ((Y mod 8) = SY) then begin
                                                                                        SZ := SZ + Delta;
                                                                                        StaMul.Seek( -1, soFromCurrent );
                                                                                        StaMul.Write( SZ, 1 );
                                                                                end;

                                                                                StaMul.Read( Color, 2 );
                                                                        end;
                                                                end;
                                                        end;

                                                        Patcher.Geschw.Caption := Format( '%d %', [Round( 100*( (X-MinX)*(MaxY-MinY+1) + (Y-MinY) ) / ( (MaxX-MinX+1)*(MaxY-MinY+1) ) )] );
                                                        Application.ProcessMessages;
                                                end;
                                        end;
                                        Log( Patcher.GetLang( 'Done' ) );
                                        continue;
                                end;
                                {ReIndex_Anim : begin
                                        Log( Patcher.GetLang( 'Preparing reindex' ) );
                                        Log( 'Free Anim' );
                                        Patcher.FileCache.FreeFile( 'anim.idx' );
                                        Patcher.FileCache.FreeFile( 'anim.mul' );

                                        if not FileExists( Path + 'data\' + 'anim.idx' ) then
                                                continue;

                                        if not FileExists( Path + 'data\' + 'anim.mul' ) then
                                                continue;

                                        try
                                                Log( 'Backup Anim' );
                                                if FileExists( Path + 'data\' + 'anim.idx.bak' ) then
                                                        DeleteFile( Path + 'data\' + 'anim.idx.bak' );
                                                RenameFile( Path + 'data\' + 'anim.idx', Config.GetString( 'UOPath' ) + 'anim.idx.bak' );

                                                if FileExists( Path + 'data\' + 'anim.mul.bak' ) then
                                                        DeleteFile( Path + 'data\' + 'anim.mul.bak' );
                                                RenameFile( Path + 'data\' + 'anim.mul', Config.GetString( 'UOPath' ) + 'anim.mul.bak' );

                                                Log( 'Open Files' );
                                                OldIdx := TFileStream.Create( Path + 'data\' + 'anim.idx.bak', fmOpenRead );
                                                NewIdx := TFileStream.Create( Path + 'data\' + 'anim.idx', fmCreate );
                                                OldMul := TFileStream.Create( Path + 'data\' + 'anim.mul.bak', fmOpenRead );
                                                NewMul := TFileStream.Create( Path + 'data\' + 'anim.mul', fmCreate );
                                        except
                                                on E : Exception do
                                                        raise Exception.Create( E.Message );
                                        end;
                                        ReIndexTyp := 'Animations';
                                end;  }
                                ReIndex_Art : begin
                                        Log( Patcher.GetLang( 'Preparing reindex' ) );
                                        Log( 'Free Art' );
                                        Patcher.FileCache.FreeFile( 'artidx.mul' );
                                        Patcher.FileCache.FreeFile( 'art.mul' );

                                        if not FileExists( Path + 'data\' + 'artidx.mul' ) then
                                                continue;

                                        if not FileExists( Path + 'data\' + 'art.mul' ) then
                                                continue;

                                        try
                                                Log( 'Backup Art' );
                                                if FileExists( Path + 'data\' + 'artidx.mul.bak' ) then
                                                        DeleteFile( Path + 'data\' + 'artidx.mul.bak' );
                                                RenameFile( Path + 'data\' + 'artidx.mul', Path + 'data\' + 'artidx.mul.bak' );

                                                if FileExists( Path + 'data\' + 'art.mul.bak' ) then
                                                        DeleteFile( Path + 'data\' + 'art.mul.bak' );
                                                RenameFile( Path + 'data\' + 'art.mul', Path + 'data\' + 'art.mul.bak' );

                                                Log( 'Open Files' );
                                                OldIdx := TFileStream.Create( Path + 'data\' + 'artidx.mul.bak', fmOpenRead );
                                                NewIdx := TFileStream.Create( Path + 'data\' + 'artidx.mul', fmCreate );
                                                OldMul := TFileStream.Create( Path + 'data\' + 'art.mul.bak', fmOpenRead );
                                                NewMul := TFileStream.Create( Path + 'data\' + 'art.mul', fmCreate );
                                        except
                                                on E : Exception do
                                                        raise Exception.Create( E.Message );
                                        end;
                                        ReIndexTyp := 'Art';
                                end;
                                ReIndex_Gumps : begin
                                        Log( Patcher.GetLang( 'Preparing reindex' ) );
                                        Log( 'Free Gumps' );
                                        Patcher.FileCache.FreeFile( 'gumpidx.mul' );
                                        Patcher.FileCache.FreeFile( 'gumpart.mul' );

                                        if not FileExists( Path + 'data\' + 'gumpidx.mul' ) then
                                                continue;

                                        if not FileExists( Path + 'data\' + 'gumpart.mul' ) then
                                                continue;

                                        try
                                                Log( 'Backup Gumps' );
                                                if FileExists( Path + 'data\' + 'gumpidx.mul.bak' ) then
                                                        DeleteFile( Path + 'data\' + 'gumpidx.mul.bak' );
                                                RenameFile( Path + 'data\' + 'gumpidx.mul', Path + 'data\' + 'gumpidx.mul.bak' );

                                                if FileExists( Path + 'data\' + 'gumpart.mul.bak' ) then
                                                        DeleteFile( Path + 'data\' + 'gumpart.mul.bak' );
                                                RenameFile( Path + 'data\' + 'gumpart.mul', Path + 'data\' + 'gumpart.mul.bak' );

                                                Log( 'Open Files' );
                                                OldIdx := TFileStream.Create( Path + 'data\' + 'gumpidx.mul.bak', fmOpenRead );
                                                NewIdx := TFileStream.Create( Path + 'data\' + 'gumpidx.mul', fmCreate );
                                                OldMul := TFileStream.Create( Path + 'data\' + 'gumpart.mul.bak', fmOpenRead );
                                                NewMul := TFileStream.Create( Path + 'data\' + 'gumpart.mul', fmCreate );
                                        except
                                                on E : Exception do
                                                        raise Exception.Create( E.Message );
                                        end;
                                        ReIndexTyp := 'Gumps';
                                end;
                                ReIndex_Sound : begin
                                        Log( Patcher.GetLang( 'Preparing reindex' ) );
                                        Log( 'Free Sound' );
                                        Patcher.FileCache.FreeFile( 'soundidx.mul' );
                                        Patcher.FileCache.FreeFile( 'sound.mul' );

                                        if not FileExists( Path + 'data\' + 'soundidx.mul' ) then
                                                continue;

                                        if not FileExists( Path + 'data\' + 'sound.mul' ) then
                                                continue;

                                        try
                                                Log( 'Backup Sound' );
                                                if FileExists( Path + 'data\' + 'soundidx.mul.bak' ) then
                                                        DeleteFile( Path + 'data\' + 'soundidx.mul.bak' );
                                                RenameFile( Path + 'data\' + 'soundidx.mul', Path + 'data\' + 'soundidx.mul.bak' );

                                                if FileExists( Path + 'data\' + 'sound.mul.bak' ) then
                                                        DeleteFile( Path + 'data\' + 'sound.mul.bak' );
                                                RenameFile( Path + 'data\' + 'sound.mul', Path + 'data\' + 'sound.mul.bak' );

                                                Log( 'Open Files' );
                                                OldIdx := TFileStream.Create( Path + 'data\' + 'soundidx.mul.bak', fmOpenRead );
                                                NewIdx := TFileStream.Create( Path + 'data\' + 'soundidx.mul', fmCreate );
                                                OldMul := TFileStream.Create( Path + 'data\' + 'sound.mul.bak', fmOpenRead );
                                                NewMul := TFileStream.Create( Path + 'data\' + 'sound.mul', fmCreate );
                                        except
                                                on E : Exception do
                                                        raise Exception.Create( E.Message );
                                        end;
                                        ReIndexTyp := 'Sound';
                                end;
                                ReIndex_Statics : begin
                                        Log( Patcher.GetLang( 'Preparing reindex' ) );
                                        Log( 'Free Statics' );
                                        Patcher.FileCache.FreeFile( 'staidx0.mul' );
                                        Patcher.FileCache.FreeFile( 'statics0.mul' );

                                        if not FileExists( Path + 'data\' + 'staidx0.mul' ) then
                                                continue;

                                        if not FileExists( Path + 'data\' + 'statics0.mul' ) then
                                                continue;

                                        try
                                                Log( 'Backup Statics' );
                                                if FileExists( Path + 'data\' + 'staidx0.mul.bak' ) then
                                                        DeleteFile( Path + 'data\' + 'staidx0.mul.bak' );
                                                RenameFile( Path + 'data\' + 'staidx0.mul', Path + 'data\' + 'staidx0.mul.bak' );

                                                if FileExists( Path + 'data\' + 'statics0.mul.bak' ) then
                                                        DeleteFile( Path + 'data\' + 'statics0.mul.bak' );
                                                RenameFile( Path + 'data\' + 'statics0.mul', Path + 'data\' + 'statics0.mul.bak' );

                                                Log( 'Open Files' );
                                                OldIdx := TFileStream.Create( Path + 'data\' + 'staidx0.mul.bak', fmOpenRead );
                                                NewIdx := TFileStream.Create( Path + 'data\' + 'staidx0.mul', fmCreate );
                                                OldMul := TFileStream.Create( Path + 'data\' + 'statics0.mul.bak', fmOpenRead );
                                                NewMul := TFileStream.Create( Path + 'data\' + 'statics0.mul', fmCreate );
                                        except
                                                on E : Exception do
                                                        raise Exception.Create( E.Message );
                                        end;
                                        ReIndexTyp := 'Statics';
                                end;
                                ReIndex_Textures : begin
                                        Log( Patcher.GetLang( 'Preparing reindex' ) );
                                        Log( 'Free Textures' );
                                        Patcher.FileCache.FreeFile( 'texidx.mul' );
                                        Patcher.FileCache.FreeFile( 'texmaps.mul' );

                                        if not FileExists( Path + 'data\' + 'texidx.mul' ) then
                                                continue;

                                        if not FileExists( Path + 'data\' + 'texmaps.mul' ) then
                                                continue;

                                        try
                                                Log( 'Backup Textures' );
                                                if FileExists( Path + 'data\' + 'texidx.mul.bak' ) then
                                                        DeleteFile( Path + 'data\' + 'texidx.mul.bak' );
                                                RenameFile( Path + 'data\' + 'texidx.mul', Path + 'data\' + 'texidx.mul.bak' );

                                                if FileExists( Path + 'data\' + 'texmaps.mul.bak' ) then
                                                        DeleteFile( Path + 'data\' + 'texmaps.mul.bak' );
                                                RenameFile( Path + 'data\' + 'texmaps.mul', Path + 'data\' + 'texmaps.mul.bak' );

                                                Log( 'Open Files' );
                                                OldIdx := TFileStream.Create( Path + 'data\' + 'texidx.mul.bak', fmOpenRead );
                                                NewIdx := TFileStream.Create( Path + 'data\' + 'texidx.mul', fmCreate );
                                                OldMul := TFileStream.Create( Path + 'data\' + 'texmaps.mul.bak', fmOpenRead );
                                                NewMul := TFileStream.Create( Path + 'data\' + 'texmaps.mul', fmCreate );
                                        except
                                                on E : Exception do
                                                        raise Exception.Create( E.Message );
                                        end;
                                        ReIndexTyp := 'Textures';
                                end;
                                else begin
                                        continue;
                                end;
                        end;

                        OldIdx.Seek( 0, soFromBeginning );
                        NewIdx.Seek( 0, soFromBeginning );
                        NewMul.Seek( 0, soFromBeginning );

                        Patcher.Memo.Lines.Add( 'Reindexing ' + ReIndexTyp + '.' );
                        Log( Patcher.GetLang( 'Start reindication' ) );

                        I := 0;
                        while OldIdx.Position < OldIdx.Size do begin
                                if (I mod 100) = 0 then begin
                                        Patcher.Geschw.Caption := IntToStr( Trunc( 100*OldIdx.Position/OldIdx.Size ) ) + '%';
                                        Application.ProcessMessages;
                                end;

                                OldIdx.Read( IndexOld, sizeof( TUOIndex ) );
                                if ( IndexOld.Lookup = -1 ) or ( IndexOld.Length = -1 ) then begin
                                        IndexNew.Lookup := -1;
                                        IndexNew.Length := -1;
                                        IndexNew.Tag := -1;
                                        NewIdx.Write( IndexNew, sizeof( TUOIndex ) );
                                end
                                else begin
                                        IndexNew.Lookup := NewMul.Position;
                                        IndexNew.Length := IndexOld.Length;
                                        IndexNew.Tag := IndexOld.Tag;
                                        NewIdx.Write( IndexNew, sizeof( TUOIndex ) );

                                        OldMul.Seek( IndexOld.Lookup, soFromBeginning );
                                        NewMul.CopyFrom( OldMul, IndexOld.Length );
                                end;
                        end;

                        Patcher.geschw.Caption := '';

                        OldIdx.Free;
                        OldMul.Free;
                        NewIdx.Free;
                        NewMul.Free;

                        Patcher.Memo.Lines.Add( Patcher.GetLang( 'Reindexing of' ) + ' ' + ReIndexTyp + ' ' + Patcher.GetLang( 'Done' ) );
                end;

                Application.ProcessMessages;
        end;

        MStream.Free;
        
        if not Patcher.Ending then begin
                Patcher.Balken.Percent := 100;

                Patcher.Memo.Lines.Add( Patcher.GetLang( 'Patch installed' ) );
                Patcher.Memo.Lines.Add( '' );
        end;

        Log( Patcher.GetLang( 'Deleting tempfile' ) );
        DeleteFile( ExtractFilePath( Application.ExeName ) + 'patches\temp.' + FileSuffix );

        if Patcher.Ending then
                Log( Patcher.GetLang( 'Patch interrupted' ) )
        else
                Log( Patcher.GetLang( 'Patch done' ) );

        Terminate;
end;

procedure TPatcher.HTTPWork(Sender: TObject; AWorkMode: TWorkMode;
  const AWorkCount: Integer);
var TickCount : Integer;
begin
        Balken.Percent := Ceil( 100 * ( (AWorkCount+StartSize) / (HTTP.Response.ContentLength+StartSize) ) );
        Caption := Format( '%d%s %s', [Balken.Percent,'%',CustomCaption] );
        Menge.Caption := inttostr( trunc( (AWorkCount+StartSize)/1024  ) ) + '/' + inttostr( trunc( (HTTP.Response.ContentLength+StartSize)/1024 ) ) + ' kb';

        if LastTick <> 0 then begin
                TickCount := GetTickCount;
                if (TickCount-LastTick) >= 1000 then begin
                        Geschw.Caption := inttostr( trunc( (AWorkCount-SizeLastTick) / (TickCount-LastTick) ) ) + ' kb/s';
                        LastTick := TickCount;
                        SizeLastTick := AWorkCount;
                end;
        end
        else begin
                LastTick := GetTickCount;
                SizeLastTick := AWorkCount;
        end;
        Application.ProcessMessages;
end;

procedure TPatcher.HTTPWorkEnd(Sender: TObject; AWorkMode: TWorkMode);
begin
        Balken.Percent := 0;
        Menge.Caption := '';
        Geschw.Caption := '';
        Caption := CustomCaption;
end;

procedure TPatcher.HTTPWorkBegin(Sender: TObject; AWorkMode: TWorkMode;
  const AWorkCountMax: Integer);
begin
        if HTTP.Response.ContentLength <> 0 then
                if HTTP.Response.ContentLength > 1024 then
                        Memo.Lines.Add( GetLang( 'Loading' ) + ' ' + inttostr( trunc( HTTP.Response.ContentLength/1024 ) ) + ' kb.' );
        SizeLastTick := 0;
        LastTick := 0;
end;

procedure TPatchThread.ProgressCallback(Current: integer);
begin
        Patcher.Balken.Percent := trunc(100*(Current/Totalsize) );
        Application.ProcessMessages;
end;

procedure TPatcher.btnCancelClick(Sender: TObject);
begin
        Ending := True;
        ShardSelect.MayStart := False;
        if Http.Connected then
                Http.Disconnect;
        Application.Terminate;
end;

procedure TPatcher.CookieManNewCookie(ASender: TObject;
  ACookie: TIdCookieRFC2109; var VAccept: Boolean);
var     P : Integer;
begin
        P := Pos( ';', ACookie.CookieText );
        SessID := Copy( ACookie.CookieText, 11, P-11 );
end;

function TPatcher.SpecialInputBox( const ACaption, APrompt : string; var ADefault: string; Password : Boolean = False ) : Boolean;
begin
        Result := SpecialInputQuery( ACaption, APrompt, Password, ADefault );
end;

function TPatcher.SpecialInputQuery( const ACaption, APrompt: string; Password : Boolean; var Value: string ) : Boolean;
begin
        InputForm := TInputForm.Create( Application );
        InputForm.Caption := ACaption;
        InputForm.lPrompt.Caption := APrompt;
        InputForm.ePass.Text := Value;
        if Password then
                InputForm.ePass.PasswordChar := '*'
        else
                InputForm.ePass.PasswordChar := #0;
        if InputForm.ShowModal = mrOK then begin
                Value := InputForm.ePass.Text;
                Result := True;
        end
        else begin
                Value := '';
                Result := False;
        end;
        InputForm.Free;
end;

function TPatcher.GetLang( Value : String ) : String;
begin
        if Lang <> nil then
                Result := Lang.ReadString( 'Language', Value, Value )
        else
                Result := '';
end;

function TPatcher.DecryptProgressRecord( ProgressRecord : TProgressRecord ) : TProgressRecord;
var     IndexRecord : TIndexRecord;
begin
        IndexRecord.Lookup := ProgressRecord.Offset;
        IndexRecord.Length := ProgressRecord.Length;
        IndexRecord.Tag := ProgressRecord.TypeId;

        if MulEncrypt then begin
                if not MulCrypt.DecryptIndexRecordTex( ProgressRecord.Id, IndexRecord ) then begin
                        Exit;
                end;
        end;

        Result.Offset := IndexRecord.Lookup;
        Result.Length := IndexRecord.Length;
        Result.Id := ProgressRecord.Id;
        Result.TypeId := IndexRecord.Tag;
end;

function TPatcher.EncryptProgressRecord( ProgressRecord : TProgressRecord ) : TProgressRecord;
var     IndexRecord : TIndexRecord;
begin
        IndexRecord.Lookup := ProgressRecord.Offset;
        IndexRecord.Length := ProgressRecord.Length;
        IndexRecord.Tag := ProgressRecord.TypeId;

        if MulEncrypt then begin
                if not MulCrypt.EncryptIndexRecordTex( ProgressRecord.Id, IndexRecord ) then begin
                        Exit;
                end;
        end;

        Result.Offset := IndexRecord.Lookup;
        Result.Length := IndexRecord.Length;
        Result.Id := ProgressRecord.Id;
        Result.TypeId := IndexRecord.Tag;
end;

end.
