unit uAutoupdate;

interface

uses    Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
        Dialogs, rmGauge, StdCtrls, IdHTTP, IdComponent, Inifiles, ExtCtrls, MD5,
        ShellAPI, AbBase, AbBrowse, AbZBrows, AbUnzper, uUtilities, uConfig;

const   MirrorCount = 2;
        Mirrors : Array[ 0..MirrorCount-1 ] of String = (
                'http://varan.uodev.de/client/',
                'http://client.uo-mittelerde.ch/'
                );

type    TUpdateThread = Class( TThread )
                private
                        Running : Boolean;
                        Text : String;
                        LastTick, SizeLastTick, TickCount : Integer;
                        HTTP : TIdHTTP;
                protected
                        procedure Execute; override;
                public
                        function IsRunning : Boolean;
                        function GetText : String;
                        procedure SetRunning( Value : Boolean );
                        procedure Work( Sender: TObject; AWorkMode: TWorkMode; const AWorkCount: Integer );
                        procedure WorkEnd( Sender: TObject; AWorkMode: TWorkMode );
                        procedure WorkBegin( Sender: TObject; AWorkMode: TWorkMode; const AWorkCountMax: Integer );
        end;

        TAutoupdate = class(TForm)
                lText: TLabel;
                gDownload: TrmGauge;
                procedure StartUpdate;
                procedure FormDestroy(Sender: TObject);
                private
                        UpdateThread : TUpdateThread;
        end;

var     Autoupdate: TAutoupdate;

implementation

uses uShardSelect;
{$R *.dfm}

procedure TUpdateThread.Execute;
var     FStream : TFileStream;
        Ini : TMemIniFile;
        ServerVersion : Integer;
        FileName : String;
        Unzip : TAbUnZipper;
        Mirror : Integer;
begin
        Running := True;
        Text := 'Searching for newer clients';

        if not DirectoryExists( ExtractFilePath( Application.ExeName ) + 'temp' ) then
                CreateDir( ExtractFilePath( Application.ExeName ) + 'temp' );

        FileName := ExtractFilePath( Application.ExeName ) + 'temp\version.eri';
        if FileExists( FileName ) then
                DeleteFile( FileName );
        FStream := TFileStream.Create( FileName, fmCreate );

        Mirror := 0;
        while Mirror < MirrorCount do begin
                HTTP := TIdHttp.Create( nil );
                HTTP.RedirectMaximum := 100;
                HTTP.HandleRedirects := True;
                HTTP.ConnectTimeout := 500;
                try
                        HTTP.Get( Mirrors[ Mirror ] + 'version.eri', FStream );
                        FStream.Free;
                        Ini := TMemIniFile.Create( FileName );
                        DeleteFile( FileName );

                        ShardSelect.ScriptsVersion := Ini.ReadInteger( 'Autoupdate', 'ScriptsVersion', 0 );
                        ShardSelect.ScriptsPath := Mirrors[ Mirror ] + 'scripts.zip';

                        if Config.GetString( 'DllVersion' ) <> Ini.ReadString( 'Autoupdate', 'DllVersion', '' ) then begin
                                Text := 'Loading new dlls';
                                FileName := ExtractFilePath( Application.ExeName ) + 'temp\Dlls.zip';
                                if FileExists( FileName ) then
                                        DeleteFile( FileName );
                                FStream := TFileStream.Create( FileName, fmCreate );
                                HTTP.OnWork := Work;
                                HTTP.OnWorkBegin := WorkBegin;
                                HTTP.OnWorkEnd := WorkEnd;                                
                                HTTP.Get( Mirrors[ Mirror ] + 'Dlls.zip', FStream );
                                FStream.Free;

                                Unzip := TAbUnZipper.Create( nil );
                                Unzip.FileName := FileName;
                                Unzip.BaseDirectory := ExtractFilePath( Application.ExeName );
                                Unzip.ExtractFiles( '*.*' );
                                Unzip.Free;

                                DeleteFile( FileName );
                                Config.SetString( 'DllVersion', Ini.ReadString( 'Autoupdate', 'DllVersion', '' ) );
                        end;

                        if Config.GetString( 'Palanthir' ) <> Ini.ReadString( 'Autoupdate', 'Palanthir', '' ) then begin
                                Text := 'Loading new Palanthir.exe';
                                FileName := ExtractFilePath( Application.ExeName ) + 'temp\Palanthir.zip';
                                if FileExists( FileName ) then
                                        DeleteFile( FileName );
                                FStream := TFileStream.Create( FileName, fmCreate );
                                HTTP.OnWork := Work;
                                HTTP.OnWorkBegin := WorkBegin;
                                HTTP.OnWorkEnd := WorkEnd;
                                HTTP.Get( Mirrors[ Mirror ] + 'Palanthir.zip', FStream );
                                FStream.Free;

                                Unzip := TAbUnZipper.Create( nil );
                                Unzip.FileName := FileName;
                                Unzip.BaseDirectory := ExtractFilePath( Application.ExeName );
                                Unzip.ExtractFiles( '*.*' );
                                Unzip.Free;

                                DeleteFile( FileName );
                                Config.SetString( 'Palanthir', Ini.ReadString( 'Autoupdate', 'Palanthir', '' ) );
                        end;

                        ServerVersion := Ini.ReadInteger( 'Autoupdate', 'Version', 0 );
                        if ServerVersion > LocalVersion then begin
                                Text := 'Loading new client';
                                FileName := ExtractFilePath( Application.ExeName ) + 'temp\Client.zip';
                                if FileExists( FileName ) then
                                        DeleteFile( FileName );
                                FStream := TFileStream.Create( Filename, fmCreate );
                                HTTP.OnWork := Work;
                                HTTP.OnWorkBegin := WorkBegin;
                                HTTP.OnWorkEnd := WorkEnd;
                                HTTP.Get( Mirrors[ Mirror ] + 'Client.zip', FStream );
                                FStream.Free;

                                Unzip := TAbUnZipper.Create( nil );
                                Unzip.FileName := FileName;
                                Unzip.BaseDirectory := ExtractFilePath( Application.ExeName ) + 'temp\';
                                Unzip.ExtractFiles( '*.*' );
                                Unzip.Free;

                                DeleteFile( FileName );
                                FileName := ExtractFilePath( Application.ExeName ) + Copy( ExtractFileName( Application.ExeName ), 1, Length( ExtractFileName( Application.ExeName ) )-4 ) + '_new.exe';
                                if FileExists( FileName ) then
                                        DeleteFile( FileName );

                                CopyFile( PChar( ExtractFilePath( Application.ExeName ) + 'temp\Client.exe' ), PChar( FileName ), True );
                                if FileExists( ExtractFilePath( Application.ExeName ) + 'temp\Client.exe' ) then
                                        DeleteFile( ExtractFilePath( Application.ExeName ) + 'temp\Client.exe' );

                                if ( not FileExists( ExtractFilePath( Application.ExeName ) + 'updater.exe' ) ) or ( LowerCase( Md5DigestToStr( Md5File( ExtractFilePath( Application.ExeName ) + 'updater.exe' ) ) ) <> LowerCase( Ini.ReadString( 'Autoupdate', 'Updater', '' ) ) ) then begin
                                        Text := 'Loading new updateprogram';
                                        FileName := ExtractFilePath( Application.ExeName ) + 'temp\updater.zip';
                                        if FileExists( FileName ) then
                                                DeleteFile( FileName );
                                        FStream := TFileStream.Create( FileName, fmCreate );
                                        HTTP.Get( Mirrors[ Mirror ] + 'updater.zip', FStream );
                                        FStream.Free;

                                        Unzip := TAbUnZipper.Create( nil );
                                        Unzip.FileName := FileName;
                                        Unzip.BaseDirectory := ExtractFilePath( Application.ExeName ) + 'temp\';
                                        Unzip.ExtractFiles( '*.*' );
                                        Unzip.Free;

                                        DeleteFile( FileName );
                                        FileName := ExtractFilePath( Application.ExeName ) + 'updater.exe';
                                        if FileExists( FileName ) then
                                                DeleteFile( FileName );
                                        CopyFile( PChar( ExtractFilePath( Application.ExeName ) + 'temp\updater.exe' ), PChar( FileName ), True );
                                        if FileExists( ExtractFilePath( Application.ExeName ) + 'temp\updater.exe' ) then
                                                DeleteFile( ExtractFilePath( Application.ExeName ) + 'temp\updater.exe' );
                                end;

                                ShardSelect.MayStart := False;

                                Text := 'Starting update';
                                FileName := Copy( ExtractFileName( Application.ExeName ), 1, Length( ExtractFileName( Application.ExeName ) )-4 );
                                ShellExecute( 0, 'open', PChar( 'updater.exe' ), PChar( Filename ), PChar( ExtractFilePath( Application.ExeName ) ), SW_SHOWNORMAL );
                        end;
                        Ini.Free;
                        Break;
                except
                        try
                                if Mirror = MirrorCount-1 then
                                        showmessage( Format( 'Not able to reach any updateserver, going on.', [Mirrors[Mirror]] ) )
                                else
                                        showmessage( Format( 'Not able to reach %s, trying next updateserver.', [Mirrors[Mirror]] ) );
                        except
                        end;
                        Inc( Mirror );
                end;
                HTTP.Free;
        end;

        Running := False;
end;

function TUpdateThread.IsRunning : Boolean;
begin
        Result := Running;
end;

function TUpdateThread.GetText : String;
begin
        Result := Text;
end;

procedure TUpdateThread.SetRunning( Value : Boolean );
begin
        Running := Value;
end;

procedure TUpdateThread.Work( Sender: TObject; AWorkMode: TWorkMode; const AWorkCount: Integer );
begin
        AutoUpdate.gDownload.Percent := trunc( 100 * ( AWorkCount / HTTP.Response.ContentLength ) );

        if LastTick <> 0 then begin
                TickCount := GetTickCount;
                if (TickCount-LastTick) >= 1000 then begin
                        LastTick := TickCount;
                        SizeLastTick := AWorkCount;
                end;
        end
        else begin
                LastTick := GetTickCount;
                SizeLastTick := AWorkCount;
        end;
end;

procedure TUpdateThread.WorkBegin( Sender: TObject; AWorkMode: TWorkMode; const AWorkCountMax: Integer );
begin
        SizeLastTick := 0;
        LastTick := 0;
end;

procedure TUpdateThread.WorkEnd( Sender: TObject; AWorkMode: TWorkMode );
begin
        AutoUpdate.gDownload.Percent := 0;
end;

procedure TAutoupdate.StartUpdate;
var     I, J : Byte;
        Tick : LongWord;
begin
        Show;
        UpdateThread := TUpdateThread.Create( True );
        UpdateThread.SetRunning( True );
        UpdateThread.Resume;

        I := 0;
        Tick := GetTickCount;
        while UpdateThread.Running do begin
                if GetTickCount - Tick > 1000 then begin
                        Tick := GetTickCount;
                        I := ( I + 1 ) mod 3;
                        lText.Caption := UpdateThread.Text;
                        for J := 0 to I do
                                lText.Caption := lText.Caption + '.';
                end;
                Application.ProcessMessages;
                Sleep( 5 );
        end;
        UpdateThread.Free;
        UpdateThread := nil;
        Hide;
end;

procedure TAutoupdate.FormDestroy(Sender: TObject);
begin
        if UpdateThread <> nil then
                UpdateThread.Free;
end;

end.
