unit uClientForm;

interface

uses    Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls,
        Forms, Dialogs, StdCtrls, ExtCtrls, uPalanthir, uConfig, ScktComp, uLog,
        uRenderer;

type
        TClientForm = class(TForm)
                procedure FormMouseDown( Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer );
                procedure FormMouseMove( Sender: TObject; Shift: TShiftState; X, Y: Integer );
                procedure FormMouseUp( Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer );
                procedure FormCanResize( Sender: TObject; var NewWidth, NewHeight: Integer; var Resize: Boolean );
                procedure FormCreate( Sender: TObject );
                procedure FormClose(Sender: TObject; var Action: TCloseAction);
          private
                { Private declarations }
          public
                { Public declarations }
                AllowResize : Boolean;
                procedure SetResize( Allow : Boolean );
                procedure SetCaption( Text : String );
                procedure CustomResize( NewWidth, NewHeight : Integer );
                procedure BringToFront;                
        end;

var     ClientForm: TClientForm;

implementation

{$R *.dfm}

procedure TClientForm.FormMouseDown( Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer );
begin
        Palanthir.Maus.DownEvent( X, Y, Button );
end;

procedure TClientForm.FormMouseMove( Sender: TObject; Shift: TShiftState; X, Y: Integer );
begin
        Palanthir.Maus.MoveEvent( X, Y );
end;

procedure TClientForm.FormMouseUp( Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer );
begin
        Palanthir.Maus.UpEvent( X, Y, Button );
end;

procedure TClientForm.FormCanResize( Sender: TObject; var NewWidth, NewHeight: Integer; var Resize: Boolean );
begin
        if AllowResize then begin
                Renderer.SetSize( ClientWidth, ClientHeight );
        end
        else begin
                Resize := False;
        end;
end;

procedure TClientForm.FormCreate(Sender: TObject);
begin
        Palanthir := TPalanthir.Create( Application );
        Palanthir.Init;
end;

procedure TClientForm.SetResize( Allow : Boolean );
begin
        AllowResize := Allow;
end;

procedure TClientForm.SetCaption( Text : String );
begin
        Caption := Text;
end;

procedure TClientForm.CustomResize( NewWidth, NewHeight : Integer );
var     OldAllow : Boolean;
begin
        OldAllow := AllowResize;
        AllowResize := True;

        ClientWidth := NewWidth;
        ClientHeight := NewHeight;

        AllowResize := OldAllow;
end;

procedure TClientForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
        Log.Write( 'Closing form' );
        Application.OnMessage := nil;

        if Palanthir.State <> State_Ending then begin
                Palanthir.State := State_Ending;
        end
        else begin
                Palanthir.Free;
        end;
end;

procedure TClientForm.BringToFront;
begin
        SetForeGroundWindow( Self.ClientHandle );
end;

end.
