unit uGlobalSettings;

interface

uses    Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
        Dialogs, StdCtrls, ExtCtrls, uConfig, rmBrowseFor;

type    TGlobalSettings = class(TForm)
                eUOPath: TLabeledEdit;
                btnOK: TButton;
                btnCancel: TButton;
                btnApply: TButton;
                btnBrowseUOPath: TButton;
                eScreenWidth: TLabeledEdit;
                eScreenHeight: TLabeledEdit;
                eGameWidth: TLabeledEdit;
                eGameHeight: TLabeledEdit;
                eSleepMain: TLabeledEdit;
                eSleepNetwork: TLabeledEdit;
                cbDoNotCloseShardSelecton: TCheckBox;
                cbAlwaysOnTop: TCheckBox;
                cbShowDebugConsole: TCheckBox;
                ePacketsToShowInConsole: TLabeledEdit;
                procedure FormActivate(Sender: TObject);
                procedure btnApplyClick(Sender: TObject);
                procedure btnCancelClick(Sender: TObject);
                procedure btnOKClick(Sender: TObject);
                procedure btnBrowseUOPathClick(Sender: TObject);
                private
                public
        end;

var     GlobalSettings: TGlobalSettings;

implementation

{$R *.dfm}

procedure TGlobalSettings.FormActivate(Sender: TObject);
begin
        eUOPath.Text := Config.GetString( 'UOPath' );
        eScreenWidth.Text := IntToStr( Config.GetInteger( 'ScreenWidth' ) );
        eScreenHeight.Text := IntToStr( Config.GetInteger( 'ScreenHeight' ) );
        eGameWidth.Text := IntToStr( Config.GetInteger( 'GameWindowWidth' ) );
        eGameHeight.Text := IntToStr( Config.GetInteger( 'GameWindowHeight' ) );
        eSleepMain.Text := IntToStr( Config.GetInteger( 'WaitInMainloop' ) );
        eSleepNetwork.Text := IntToStr( Config.GetInteger( 'WaitInNetworkloop' ) );

        if Config.GetInteger( 'DoNotCloseShardSelecton' ) <> 0 then
                cbDoNotCloseShardSelecton.Checked := True
        else
                cbDoNotCloseShardSelecton.Checked := False;
        if Config.GetInteger( 'AlwaysOnTop' ) <> 0 then
                cbAlwaysOnTop.Checked := True
        else
                cbAlwaysOnTop.Checked := False;
        if Config.GetInteger( 'ShowDebugConsole' ) <> 0 then
                cbShowDebugConsole.Checked := True
        else
                cbShowDebugConsole.Checked := False;
        ePacketsToShowInConsole.Text := Config.GetString( 'PacketsToShowInConsole' );
end;

procedure TGlobalSettings.btnApplyClick(Sender: TObject);
begin
        eUOPath.Text := IncludeTrailingPathDelimiter( eUOPath.Text );
        Config.SetString( 'UOPath', eUOPath.Text );
        Config.SetInteger( 'ScreenWidth', StrToInt( eScreenWidth.Text ) );
        Config.SetInteger( 'ScreenHeight', StrToInt( eScreenHeight.Text ) );
        Config.SetInteger( 'GameWindowWidth', StrToInt( eGameWidth.Text ) );
        Config.SetInteger( 'GameWindowHeight', StrToInt( eGameHeight.Text ) );
        Config.SetInteger( 'WaitInMainloop', StrToInt( eSleepMain.Text ) );
        Config.SetInteger( 'WaitInNetworkloop', StrToInt( eSleepNetwork.Text ) );
        if cbDoNotCloseShardSelecton.Checked then
                Config.SetInteger( 'DoNotCloseShardSelecton', 1 )
        else
                Config.SetInteger( 'DoNotCloseShardSelecton', 0 );
        if cbAlwaysOnTop.Checked then
                Config.SetInteger( 'AlwaysOnTop', 1 )
        else
                Config.SetInteger( 'AlwaysOnTop', 0 );
        if cbShowDebugConsole.Checked then
                Config.SetInteger( 'ShowDebugConsole', 1 )
        else
                Config.SetInteger( 'ShowDebugConsole', 0 );
        Config.SetString( 'PacketsToShowInConsole', ePacketsToShowInConsole.Text );
end;

procedure TGlobalSettings.btnCancelClick(Sender: TObject);
begin
        Hide;
end;

procedure TGlobalSettings.btnOKClick(Sender: TObject);
begin
        btnApplyClick( Sender );
        Hide;
end;

procedure TGlobalSettings.btnBrowseUOPathClick(Sender: TObject);
var     VerzDialog : TrmBrowseForFolder;
begin
        VerzDialog := TrmBrowseForFolder.create( self );
        VerzDialog.Title := 'Choose your UO Directory';

        if not VerzDialog.Execute then begin
                VerzDialog.Free;
                exit;
        end;

        eUOPath.Text := VerzDialog.Folder + '\';
        VerzDialog.Free;
end;

end.
