unit uIrisConfig;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls, uConfig;

type
  TIrisConfigForm = class(TForm)
    eRoofFadeTime: TLabeledEdit;
    cbScreenType: TComboBox;
    cbCursor: TComboBox;
    tbViewdistance: TTrackBar;
    lViewdistance: TLabel;
    tbMaxZoom: TTrackBar;
    lMaxZoom: TLabel;
    tbMaxAngle: TTrackBar;
    lMaxAngle: TLabel;
    tbBrightness: TTrackBar;
    lBrightness: TLabel;
    rbIsUOX3: TRadioButton;
    rbIsSphere: TRadioButton;
    rbIsSphere55R: TRadioButton;
    rbIsPol: TRadioButton;
    rbIsRunUO: TRadioButton;
    cbAOS: TCheckBox;
    cbPopupMenu: TCheckBox;
    cbAosTooltips: TCheckBox;
    cbMP3: TCheckBox;
    eMouseOverTimer: TLabeledEdit;
    tbSoundVolume: TTrackBar;
    lVolume: TLabel;
    tbMusicVolume: TTrackBar;
    lMusic: TLabel;
    btnOK: TButton;
    btnCancel: TButton;
    btnApply: TButton;
    cbBPP: TComboBox;
    cbZBufferSize: TComboBox;
    cbUseSpeech: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
    procedure btnApplyClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    IrisConfig : TConfig;
  end;

var
  IrisConfigForm: TIrisConfigForm;

implementation

{$R *.dfm}

procedure TIrisConfigForm.FormCreate(Sender: TObject);
begin
        IrisConfig := nil;
end;

procedure TIrisConfigForm.FormShow(Sender: TObject);
var     I : Integer;
        Gefunden : Boolean;
begin
        if IrisConfig = nil then begin
                Hide;
                Exit;
        end;

        if IrisConfig.GetString( 'BPP' ) = '' then
                IrisConfig.SetInteger( 'BPP', 32 );
        Gefunden := False;
        for I := 0 to cbBPP.Items.Count-1 do begin
                if cbBPP.Items[ I ] = IrisConfig.GetString( 'BPP' ) then begin
                        cbBPP.ItemIndex := I;
                        Gefunden := True;
                        Break;
                end;
        end;
        if not Gefunden then begin
                IrisConfig.SetInteger( 'BPP', 32 );
                cbBPP.ItemIndex := 1;
        end;

        if IrisConfig.GetString( 'ZBufferSize' ) = '' then
                IrisConfig.SetInteger( 'ZBufferSize', 16 );
        Gefunden := False;
        for I := 0 to cbZBufferSize.Items.Count-1 do begin
                if cbZBufferSize.Items[ I ] = IrisConfig.GetString( 'ZBufferSize' ) then begin
                        cbZBufferSize.ItemIndex := I;
                        Gefunden := True;
                        Break;
                end;
        end;
        if not Gefunden then begin
                IrisConfig.SetInteger( 'ZBufferSize', 16 );
                cbZBufferSize.ItemIndex := 0;
        end;

        if IrisConfig.GetString( 'RoofFadeTime' ) = '' then
                IrisConfig.SetInteger( 'RoofFadeTime', 1000 );
        eRoofFadeTime.Text := IrisConfig.GetString( 'RoofFadeTime' );

        if IrisConfig.GetString( 'MouseOverTimer' ) = '' then
                IrisConfig.SetInteger( 'MouseOverTimer', 50 );
        eMouseOverTimer.Text := IrisConfig.GetString( 'MouseOverTimer' );

        if (IrisConfig.GetString( 'ScreenType' ) = '') or (IrisConfig.GetInteger( 'ScreenType' ) > 1 ) then
                IrisConfig.SetInteger( 'ScreenType', 0 );
        cbScreenType.ItemIndex := IrisConfig.GetInteger( 'ScreenType' );

        if (IrisConfig.GetString( 'Cursor' ) = '') or (IrisConfig.GetInteger( 'Cursor' ) > 1 ) then
                IrisConfig.SetInteger( 'Cursor', 1 );
        cbCursor.ItemIndex := IrisConfig.GetInteger( 'Cursor' );

        if IrisConfig.GetString( 'UOX3' ) = '' then
                IrisConfig.SetBool( 'UOX3', False );
        rbIsUOX3.Checked := IrisConfig.GetBool( 'UOX3' );
        if IrisConfig.GetString( 'Sphere' ) = '' then
                IrisConfig.SetBool( 'Sphere', False );
        rbIsSphere.Checked := IrisConfig.GetBool( 'Sphere' );
        if IrisConfig.GetString( 'Sphere55R' ) = '' then
                IrisConfig.SetBool( 'Sphere55R', False );
        rbIsSphere55R.Checked := IrisConfig.GetBool( 'Sphere55R' );
        if IrisConfig.GetString( 'Pol' ) = '' then
                IrisConfig.SetBool( 'Pol', False );
        rbIsPol.Checked := IrisConfig.GetBool( 'Pol' );
        if IrisConfig.GetString( 'RunUO' ) = '' then
                IrisConfig.SetBool( 'RunUO', True );
        rbIsRunUO.Checked := IrisConfig.GetBool( 'RunUO' );

        if IrisConfig.GetString( 'AOS' ) = '' then
                IrisConfig.SetBool( 'AOS', True );
        cbAOS.Checked := IrisConfig.GetBool( 'AOS' );
        if IrisConfig.GetString( 'AOSTooltips' ) = '' then
                IrisConfig.SetBool( 'AOSTooltips', True );
        cbAOSTooltips.Checked := IrisConfig.GetBool( 'AOSTooltips' );
        if IrisConfig.GetString( 'PopupMenu' ) = '' then
                IrisConfig.SetBool( 'PopupMenu', True );
        cbPopupMenu.Checked := IrisConfig.GetBool( 'PopupMenu' );
        if IrisConfig.GetString( 'MP3' ) = '' then
                IrisConfig.SetBool( 'MP3', True );
        cbMP3.Checked := IrisConfig.GetBool( 'MP3' );
        if IrisConfig.GetString( 'UseSpeech' ) = '' then
                IrisConfig.SetBool( 'UseSpeech', True );
        cbUseSpeech.Checked := IrisConfig.GetBool( 'UseSpeech' );

        if IrisConfig.GetString( 'ViewDistance' ) = '' then
                IrisConfig.SetInteger( 'ViewDistance', 8 );
        tbViewDistance.Position := IrisConfig.GetInteger( 'ViewDistance' );
        if IrisConfig.GetString( 'MaxZoom' ) = '' then
                IrisConfig.SetInteger( 'MaxZoom', 8 );
        tbMaxZoom.Position := IrisConfig.GetInteger( 'MaxZoom' );
        if IrisConfig.GetString( 'MaxAngle' ) = '' then
                IrisConfig.SetInteger( 'MaxAngle', 80 );
        tbMaxAngle.Position := IrisConfig.GetInteger( 'MaxAngle' );
        if IrisConfig.GetString( 'Brightness' ) = '' then
                IrisConfig.SetInteger( 'Brightness', 8 );
        tbBrightness.Position := IrisConfig.GetInteger( 'Brightness' );
        if IrisConfig.GetString( 'SoundVolume' ) = '' then
                IrisConfig.SetInteger( 'SoundVolume', 90 );
        tbSoundVolume.Position := IrisConfig.GetInteger( 'SoundVolume' );
        if IrisConfig.GetString( 'MusicVolume' ) = '' then
                IrisConfig.SetInteger( 'MusicVolume', 70 );
        tbMusicVolume.Position := IrisConfig.GetInteger( 'MusicVolume' );
end;

procedure TIrisConfigForm.btnOKClick(Sender: TObject);
begin
        btnApplyClick( Sender );
        Hide;
end;

procedure TIrisConfigForm.btnCancelClick(Sender: TObject);
begin
        Hide;
end;

procedure TIrisConfigForm.btnApplyClick(Sender: TObject);
begin
        IrisConfig.SetString( 'BPP', cbBPP.Items[ cbBPP.ItemIndex ] );
        IrisConfig.SetString( 'RoofFadeTime', eRoofFadeTime.Text );
        IrisConfig.SetString( 'ZBufferSize', cbZBufferSize.Items[ cbZBufferSize.ItemIndex ] );
        IrisConfig.SetString( 'MouseOverTimer', eMouseOverTimer.Text );
        IrisConfig.SetInteger( 'ScreenType', cbScreenType.ItemIndex );
        IrisConfig.SetInteger( 'Cursor', cbCursor.ItemIndex );

        IrisConfig.SetBool( 'UOX3', rbIsUOX3.Checked );
        IrisConfig.SetBool( 'Sphere', rbIsSphere.Checked );
        IrisConfig.SetBool( 'Sphere55R', rbIsSphere55R.Checked );
        IrisConfig.SetBool( 'Pol', rbIsPol.Checked );
        IrisConfig.SetBool( 'RunUO', rbIsRunUO.Checked );

        IrisConfig.SetBool( 'AOS', cbAOS.Checked );
        IrisConfig.SetBool( 'AOSTooltips', cbAOSTooltips.Checked );
        IrisConfig.SetBool( 'PopupMenu', cbPopupMenu.Checked );
        IrisConfig.SetBool( 'MP3', cbMP3.Checked );
        IrisConfig.SetBool( 'UseSpeech', cbUseSpeech.Checked );

        IrisConfig.SetInteger( 'ViewDistance', tbViewDistance.Position );
        IrisConfig.SetInteger( 'MaxZoom', tbMaxZoom.Position );
        IrisConfig.SetInteger( 'MaxAngle', tbMaxAngle.Position );
        IrisConfig.SetInteger( 'Brightness', tbBrightness.Position );
        IrisConfig.SetInteger( 'SoundVolume', tbsoundVolume.Position );
        IrisConfig.SetInteger( 'MusicVolume', tbMusicVolume.Position );
end;

end.
