unit uIrisUpdate;

interface

uses    Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls,
        Forms, Dialogs, rmGauge, StdCtrls, IdHTTP, IdComponent, Inifiles,
        ExtCtrls, MD5, ShellAPI, AbBase, AbBrowse, AbZBrows, AbUnzper, AbArcTyp,
        uUtilities, uConfig, uAutoupdate;

type    TIrisUpdateThread = Class( TThread )
                private
                        Running : Boolean;
                        Text : String;
                        LastTick, SizeLastTick, TickCount : Integer;
                        HTTP : TIdHTTP;
                protected
                        procedure Execute; override;
                public
                        function IsRunning : Boolean;
                        function GetText : String;
                        procedure SetRunning( Value : Boolean );
                        procedure Work( Sender: TObject; AWorkMode: TWorkMode; const AWorkCount: Integer );
                        procedure WorkEnd( Sender: TObject; AWorkMode: TWorkMode );
                        procedure WorkBegin( Sender: TObject; AWorkMode: TWorkMode; const AWorkCountMax: Integer );
        end;

        TIrisupdate = class(TForm)
                lText: TLabel;
                gDownload: TrmGauge;
                procedure StartUpdate;
                procedure FormDestroy(Sender: TObject);
                private
                        IrisUpdateThread : TIrisUpdateThread;
                public
                        IrisPath : String;
                        IrisConfig : TConfig;
        end;

var     Irisupdate : TIrisupdate;

implementation

uses uShardSelect;
{$R *.dfm}

procedure TIrisUpdateThread.Execute;
var     FStream : TFileStream;
        Ini : TMemIniFile;
        FileName : String;
        Unzip : TAbUnZipper;
        Mirror : Integer;
begin
        Running := True;
        Text := 'Searching for newer versions of Iris';

        if not DirectoryExists( ExtractFilePath( Application.ExeName ) + 'temp' ) then
                CreateDir( ExtractFilePath( Application.ExeName ) + 'temp' );

        FileName := ExtractFilePath( Application.ExeName ) + 'temp\version.eri';
        if FileExists( FileName ) then
                DeleteFile( FileName );
        FStream := TFileStream.Create( FileName, fmCreate );

        Mirror := 0;
        while Mirror < MirrorCount do begin
                HTTP := TIdHttp.Create( nil );
                HTTP.RedirectMaximum := 100;
                HTTP.HandleRedirects := True;
                HTTP.ConnectTimeout := 500;
                try
                        HTTP.Get( Mirrors[ Mirror ] + 'version.eri', FStream );
                        FStream.Free;
                        Ini := TMemIniFile.Create( FileName );
                        DeleteFile( FileName );

                        if IrisUpdate.IrisConfig.GetString( 'IrisDllsVersion' ) <> Ini.ReadString( 'Autoupdate', 'IrisDllsVersion', '' ) then begin
                                Text := 'Loading new Iris dlls';
                                FileName := ExtractFilePath( Application.ExeName ) + 'temp\irisdlls.zip';
                                if FileExists( FileName ) then
                                        DeleteFile( FileName );
                                FStream := TFileStream.Create( FileName, fmCreate );
                                HTTP.OnWork := Work;
                                HTTP.OnWorkBegin := WorkBegin;
                                HTTP.OnWorkEnd := WorkEnd;                                
                                HTTP.Get( Mirrors[ Mirror ] + 'iris\irisdlls.zip', FStream );
                                FStream.Free;

                                Unzip := TAbUnZipper.Create( nil );
                                Unzip.FileName := FileName;
                                Unzip.BaseDirectory := IrisUpdate.IrisPath;
                                Unzip.ExtractFiles( '*.*' );
                                Unzip.Free;

                                DeleteFile( FileName );
                                IrisUpdate.IrisConfig.SetString( 'IrisDllsVersion', Ini.ReadString( 'Autoupdate', 'IrisDllsVersion', '' ) );
                        end;

                        if IrisUpdate.IrisConfig.GetString( 'IrisVersion' ) <> Ini.ReadString( 'Autoupdate', 'IrisVersion', '' ) then begin
                                Text := 'Loading new Iris.exe';
                                FileName := ExtractFilePath( Application.ExeName ) + 'temp\iris.zip';
                                if FileExists( FileName ) then
                                        DeleteFile( FileName );
                                FStream := TFileStream.Create( FileName, fmCreate );
                                HTTP.OnWork := Work;
                                HTTP.OnWorkBegin := WorkBegin;
                                HTTP.OnWorkEnd := WorkEnd;
                                HTTP.Get( Mirrors[ Mirror ] + 'iris\iris.zip', FStream );
                                FStream.Free;

                                Unzip := TAbUnZipper.Create( nil );
                                Unzip.FileName := FileName;
                                Unzip.BaseDirectory := IrisUpdate.IrisPath;
                                Unzip.ExtractFiles( '*.*' );
                                Unzip.Free;

                                DeleteFile( FileName );
                                IrisUpdate.IrisConfig.SetString( 'IrisVersion', Ini.ReadString( 'Autoupdate', 'IrisVersion', '' ) );
                        end;

                        if IrisUpdate.IrisConfig.GetString( 'IrisScriptsVersion' ) <> Ini.ReadString( 'Autoupdate', 'IrisScriptsVersion', '' ) then begin
                                Text := 'Loading new Iris scripts';
                                FileName := ExtractFilePath( Application.ExeName ) + 'temp\irisscripts.zip';
                                if FileExists( FileName ) then
                                        DeleteFile( FileName );
                                FStream := TFileStream.Create( FileName, fmCreate );
                                HTTP.OnWork := Work;
                                HTTP.OnWorkBegin := WorkBegin;
                                HTTP.OnWorkEnd := WorkEnd;
                                HTTP.Get( Mirrors[ Mirror ] + 'iris\irisscripts.zip', FStream );
                                FStream.Free;

                                Unzip := TAbUnZipper.Create( nil );
                                Unzip.FileName := FileName;
                                Unzip.BaseDirectory := IrisUpdate.IrisPath;
                                Unzip.ExtractOptions := [eoCreateDirs, eoRestorePath];
                                Unzip.ExtractFiles( '*.*' );
                                Unzip.Free;

                                DeleteFile( FileName );
                                IrisUpdate.IrisConfig.SetString( 'IrisScriptsVersion', Ini.ReadString( 'Autoupdate', 'IrisScriptsVersion', '' ) );
                        end;

                        if IrisUpdate.IrisConfig.GetString( 'IrisModelsVersion' ) <> Ini.ReadString( 'Autoupdate', 'IrisModelsVersion', '' ) then begin
                                Text := 'Loading new Iris models';
                                FileName := ExtractFilePath( Application.ExeName ) + 'temp\irismodels.zip';
                                if FileExists( FileName ) then
                                        DeleteFile( FileName );
                                FStream := TFileStream.Create( FileName, fmCreate );
                                HTTP.OnWork := Work;
                                HTTP.OnWorkBegin := WorkBegin;
                                HTTP.OnWorkEnd := WorkEnd;
                                HTTP.Get( Mirrors[ Mirror ] + 'iris\irismodels.zip', FStream );
                                FStream.Free;

                                Unzip := TAbUnZipper.Create( nil );
                                Unzip.FileName := FileName;
                                Unzip.BaseDirectory := IrisUpdate.IrisPath;
                                Unzip.ExtractOptions := [eoCreateDirs, eoRestorePath];
                                Unzip.ExtractFiles( '*.*' );
                                Unzip.Free;

                                DeleteFile( FileName );
                                IrisUpdate.IrisConfig.SetString( 'IrisModelsVersion', Ini.ReadString( 'Autoupdate', 'IrisModelsVersion', '' ) );
                        end;

                        Ini.Free;
                        Break;
                except
                        try
                                if Mirror = MirrorCount-1 then
                                        showmessage( Format( 'Not able to reach any updateserver, going on.', [Mirrors[Mirror]] ) )
                                else
                                        showmessage( Format( 'Not able to reach %s, trying next updateserver.', [Mirrors[Mirror]] ) );
                        except
                        end;
                        Inc( Mirror );
                end;
                HTTP.Free;
        end;

        Running := False;
end;

function TIrisUpdateThread.IsRunning : Boolean;
begin
        Result := Running;
end;

function TIrisUpdateThread.GetText : String;
begin
        Result := Text;
end;

procedure TIrisUpdateThread.SetRunning( Value : Boolean );
begin
        Running := Value;
end;

procedure TIrisUpdateThread.Work( Sender: TObject; AWorkMode: TWorkMode; const AWorkCount: Integer );
begin
        IrisUpdate.gDownload.Percent := trunc( 100 * ( AWorkCount / HTTP.Response.ContentLength ) );

        if LastTick <> 0 then begin
                TickCount := GetTickCount;
                if (TickCount-LastTick) >= 1000 then begin
                        LastTick := TickCount;
                        SizeLastTick := AWorkCount;
                end;
        end
        else begin
                LastTick := GetTickCount;
                SizeLastTick := AWorkCount;
        end;
end;

procedure TIrisUpdateThread.WorkBegin( Sender: TObject; AWorkMode: TWorkMode; const AWorkCountMax: Integer );
begin
        SizeLastTick := 0;
        LastTick := 0;
end;

procedure TIrisUpdateThread.WorkEnd( Sender: TObject; AWorkMode: TWorkMode );
begin
        IrisUpdate.gDownload.Percent := 0;
end;

procedure TIrisupdate.StartUpdate;
var     I, J : Byte;
        Tick : LongWord;
begin
        Show;
        IrisUpdateThread := TIrisUpdateThread.Create( True );
        IrisUpdateThread.SetRunning( True );
        IrisUpdateThread.Resume;

        I := 0;
        Tick := GetTickCount;
        while IrisUpdateThread.Running do begin
                if GetTickCount - Tick > 1000 then begin
                        Tick := GetTickCount;
                        I := ( I + 1 ) mod 3;
                        lText.Caption := IrisUpdateThread.Text;
                        for J := 0 to I do
                                lText.Caption := lText.Caption + '.';
                end;
                Application.ProcessMessages;
                Sleep( 5 );
        end;
        IrisUpdateThread.Free;
        IrisUpdateThread := nil;
        Hide;
end;

procedure TIrisupdate.FormDestroy(Sender: TObject);
begin
        if IrisUpdateThread <> nil then
                IrisUpdateThread.Free;
end;

end.
 