unit uScreenShotForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, rmGauge, uData, uConfig, Math, uBasicTypedefs,
  uTexCache, dglOpenGL, uUtilities, uLoaderTiledata, JPEG, StrUtils;

type    TWorkThread = class( TThread )
                private
                        Data : TData;
                        Len : Integer;
                        gMul, gPaint, gCopy, gAll : LongWord;
                        procedure DrawPixels( X, Y, Transparenz : Integer; Texture : TTexObject );
                        procedure SetGaugeBars;
                protected
                        procedure Execute; override;
                public
                        Active : Boolean;
        end;

        TScreenshotForm = class(TForm)
                LMul: TLabel;
                LPaint: TLabel;
                LCopy: TLabel;
                LAll: TLabel;
                gMul: TrmGauge;
                gPaint: TrmGauge;
                gCopy: TrmGauge;
                gAll: TrmGauge;
                eX1: TLabeledEdit;
                eY1: TLabeledEdit;
                eX2: TLabeledEdit;
                eY2: TLabeledEdit;
                btnStart: TButton;
                btnCancel: TButton;
                rbPieces: TRadioButton;
                rbResize: TRadioButton;
                lImage: TLabel;
                procedure FormHide(Sender: TObject);
                procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
                procedure FormCreate(Sender: TObject);
                procedure btnStartClick(Sender: TObject);
                private
                        Thread : TWorkThread;
                public
                        procedure SetGaugeBars( Mul, Paint, Copy, All : LongWord );
        end;

var     ScreenshotForm: TScreenshotForm;

implementation

uses    uShardSelect;

{$R *.dfm}

procedure TScreenshotForm.FormHide(Sender: TObject);
begin
        ShardSelect.Show;
end;

procedure TScreenshotForm.SetGaugeBars( Mul, Paint, Copy, All : LongWord );
begin
        gAll.Percent := All;
        gCopy.Percent := Copy;
        gMul.Percent := Mul;
        gPaint.Percent := Paint;
end;

procedure TWorkThread.SetGaugeBars;
begin
        ScreenshotForm.SetGaugeBars( gMul, gPaint, gCopy, gAll );
end;

procedure TWorkThread.DrawPixels( X, Y, Transparenz : Integer; Texture : TTexObject );
var     PosXMin, PosXMax, PosYMin, PosYMax : Integer;
        XMin, XMax, YMin, YMax : Integer;
begin
        if Texture = nil then
                exit;

        if ( X >= 1000 ) or ( X + Texture.Breite < 0 ) or ( Y >= 1000 ) or ( Y + Texture.Hoehe < 0 ) then
                exit;

        if Transparenz <> 100 then begin
                glEnable( GL_BLEND );
                glBlendFunc( GL_SRC_ALPHA, GL_DST_COLOR );
        end;

        glBindTexture( GL_TEXTURE_2D, Texture.TexID );

        XMin := Max( X, 0 );
        PosXMin := XMin - X;

        YMin := Max( Y, 0 );
        PosYMin := YMin - Y;

        XMax := Min( X + Texture.Breite, 1000 );
        PosXMax := XMax - X;

        YMax := Min( Y + Texture.Hoehe, 1000 );
        PosYMax := YMax - Y;

        glColor3f( 1, 1, 1 );
        glBegin( gl_Quads );
                gltexcoord2f( PosXMin / GetNextBit( Texture.Breite ), PosYMin / GetNextBit( Texture.Hoehe ) );
                glvertex2f( XMin, YMin );
                gltexcoord2f( PosXMin / GetNextBit( Texture.Breite ), PosYMax / GetNextBit( Texture.Hoehe ) );
                glvertex2f( XMin, YMax );
                gltexcoord2f( PosXMax / GetNextBit( Texture.Breite ), PosYMax / GetNextBit( Texture.Hoehe ) );
                glvertex2f( XMax, YMax );
                gltexcoord2f( PosXMax / GetNextBit( Texture.Breite ), PosYMin / GetNextBit( Texture.Hoehe ) );
                glvertex2f( XMax, YMin );
        glEnd;

        glDisable( GL_BLEND );        
end;

procedure TWorkThread.Execute;
var     X1, Y1, X2, Y2 : Integer;
        X, Y, PX, PY : Integer;
        Breite, Hoehe : Integer;
        ItemListe, SubList : TList;
        I : Integer;
        Panel : TPanel;
        RC : HGLRC;
        DC : HDC;
        Pixel : PByteArray;
        DrawObject : TUODrawObject;
        Texture : TTexObject;
        Transparenz, PosX, PosY : Integer;
        X0M, X1M, X2M, X3M, Y0M, Y1M, Y2M, Y3M : Integer;
        MapItem : TMapItem;
        JPG : TJPEGImage;
        Count : Int64;
        Width, Height : LongWord;
        MinX, MinY, MaxX, MaxY : Integer;
        SubX, SubY, CX, CY : Integer;
        FileName : String;
        Bmp, Bitmap : TBitmap;
        Resize, Cut : Boolean;
        Zoom : Real;
        Shard : TShard;
begin
        Active := True;

        Palanthir.Shard := TShard.Create( ExtractFilePath( Application.ExeName ) + 'shards\' + Config.GetString( 'Shardname' ) + '\' );

        Data := TData.Create;
        Data.Load( Config.GetString( 'UOPath' ), ExtractFilePath( Application.ExeName ) + 'shards\' + Config.GetString( 'Shardname' ) + '\data\' );
        Palanthir.Data := Data;

        X1 := Min( StrToInt( ScreenshotForm.eX1.Text ), StrToInt( ScreenshotForm.eX2.Text ) );
        Y1 := Min( StrToInt( ScreenshotForm.eY1.Text ), StrToInt( ScreenshotForm.eY2.Text ) );
        X2 := Max( StrToInt( ScreenshotForm.eX1.Text ), StrToInt( ScreenshotForm.eX2.Text ) );
        Y2 := Max( StrToInt( ScreenshotForm.eY1.Text ), StrToInt( ScreenshotForm.eY2.Text ) );

        Cut := ScreenshotForm.rbPieces.Checked;
        Resize := ScreenshotForm.rbResize.Checked;

        Breite := X2 - X1;
        Hoehe := Y2 - Y1;

        PX := ( X1 + X2 ) div 2;
        PY := ( Y1 + Y2 ) div 2;

        Width := Max( Breite, Hoehe )*44 + 10*44;
        Height := Max( Breite, Hoehe )*44 + 10*44;

        if Resize then begin
                Bitmap := TBitmap.Create;
                Bitmap.PixelFormat := pf32Bit;
                if Width > 2000 then begin
                        Bitmap.Width := 2000;
                        Bitmap.Height := 2000;
                        Zoom := Width / 1500;
                end
                else begin
                        Bitmap.Height := Height;
                        Bitmap.Width := Width;
                        Zoom := 1;
                end;
        end
        else begin
                Zoom := 1;
        end;
        Len := Trunc( 1000 / Zoom );

        Count := Width*Height;

        Panel := TPanel.Create( nil );
        Panel.Parent := ScreenShotForm;
        Panel.Width := Len;
        Panel.Height := Len;
        Panel.Visible := False;

        InitOpenGL;
        DC := GetDC( Panel.Handle );
        RC := CreateRenderingContext( DC, [opDoubleBuffered], 32, 24, 0, 0, 0, 0 );
        ActivateRenderingContext( DC, RC );
        glViewPort( 0, 0, Len, Len );
        glEnable( GL_TEXTURE_2D );

        gMul := 0;
        gPaint := 0;
        gCopy := 0;
        gAll := 0;

        Synchronize( SetGaugeBars );

        FileName := DateToStr( Date ) + '_' + TimeToStr( Time );
        FileName := AnsiReplaceStr( FileName, ':', '_' );
        FileName := AnsiReplaceStr( FileName, '.', '_' );
        FileName := AnsiReplaceStr( Palanthir.GetShardName +'_'+ FileName, ' ', '_' );

        ItemListe := TList.Create;
        for Y := Y1 to Y2 do begin
                for X := X1 to X2 do begin
                        SubList := Data.WorldCache.GetStaticObjects( X, Y );
                        for I := 0 to SubList.Count-1 do
                                ItemListe.Add( SubList.Items[ I ] );
                        ItemListe.Add( Data.WorldCache.GetMapItem( X, Y ) );
                        SubList.Free;
                end;
                gMul := Ceil( (Y-Y1)*100/Hoehe );
                Synchronize( SetGaugeBars );
        end;

        Palanthir.SortItemListe( ItemListe );

        CX := ( Width div 1000 )+1;
        CY := ( Height div 1000 )+1;
        for Y := 0 to CY do begin
                for X := 0 to CX do begin
                        glLoadIdentity;
                        glClear( GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT );

                        glMatrixMode( GL_PROJECTION );
                        glLoadIdentity;
                        glOrtho( 0, 1000, 1000, 0, -1, 1 );

                        glMatrixMode( GL_TEXTURE );
                        glLoadIdentity;

                        glMatrixMode( GL_MODELVIEW );
                        glLoadIdentity;

                        glEnable( GL_ALPHA_TEST );
                        glAlphaFunc( GL_GREATER, 0.1 );

                        glClearColor( 0, 0, 0, 0 );

                        for I := 0 to ItemListe.Count-1 do begin
                                gPaint := Ceil( I*100/ItemListe.Count );
                                Synchronize( SetGaugeBars );
                                DrawObject := TUODrawObject( ItemListe.Items[ I ] );
                                if DrawObject.IsStatic then begin
                                        if DrawObject.Id = $1 then
                                                continue;

                                        Texture := Data.GetStaticArt( DrawObject.ID, DrawObject.Color );
                                        if Texture = nil then
                                                continue;

                                        if Data.Tiledata.GetStaticFlag( DrawObject.ID, dTRANSLUCENT ) then
                                                Transparenz := 50
                                        else
                                                Transparenz := 100;

                                        PosX := -X*(1000) + (Width div 2) + (DrawObject.Pos.X-PX - DrawObject.Pos.Y+PY) * 22 - ( Texture.Breite div 2 );
                                        PosY := -Y*(1000) + (Height div 2) + (DrawObject.Pos.X-PX + DrawObject.Pos.Y-PY) * 22 - DrawObject.Pos.Z*4 - Texture.Hoehe +44;

                                        DrawPixels( PosX, PosY, Transparenz, Texture );
                                end
                                else if DrawObject.IsMap and ( not TMapItem( DrawObject ).IsStrechted ) then begin
                                        if DrawObject.Id = $2 then
                                                continue;
                                        Texture := Data.GetMapArt( DrawObject.ID,DrawObject.Color );
                                        if Texture = nil then
                                                continue;
                                        PosX := -X*(1000) + (Width div 2) + (DrawObject.Pos.X-PX - DrawObject.Pos.Y+PY) * 22 - 22;
                                        PosY := -Y*(1000) + (Height div 2) + (DrawObject.Pos.X-PX + DrawObject.Pos.Y-PY) * 22 - DrawObject.Pos.Z*4;
                                        DrawPixels( PosX, PosY, 100, Texture );
                                end
                                else if DrawObject.IsMap then begin
                                        if DrawObject.Id = $2 then
                                                continue;
                                        Texture := Data.GetTextureTexture( DrawObject.ID, DrawObject.Color );
                                        if Texture = nil then
                                                continue;
                                        PosX := -X*(1000) + (Width div 2) + (DrawObject.Pos.X-PX - DrawObject.Pos.Y+PY) * 22;
                                        PosY := -Y*(1000) + (Height div 2) + (DrawObject.Pos.X-PX + DrawObject.Pos.Y-PY) * 22;

                                        MapItem := TMapItem( DrawObject );
                                        X0M := 0;
                                        Y0M := 0 - MapItem.Pos.Z*4;
                                        X1M := -22;
                                        Y1M := 22 - MapItem.Z3*4;
                                        X2M := 0;
                                        Y2M := 44 - MapItem.Z4*4;
                                        X3M := 22;
                                        Y3M := 22 - MapItem.Z2*4;

                                        glBindTexture( GL_TEXTURE_2D, Texture.TexID );
                                        glColor3f( 0.8, 0.8, 0.8 );
                                        glBegin( gl_Quads );
                                                gltexcoord2f( 0, 0 );
                                                glvertex2f( PosX + X0M, PosY + Y0M );
                                                gltexcoord2f( 0, 1 );
                                                glvertex2f( PosX + X1M, PosY + Y1M );
                                                gltexcoord2f( 1, 1 );
                                                glvertex2f( PosX + X2M, PosY + Y2M );
                                                gltexcoord2f( 1, 0 );
                                                glvertex2f( PosX + X3M, PosY + Y3M );
                                        glEnd;
                                end;
                        end;
                        SwapBuffers( DC );

                        if Resize then begin
                                for SubY := 0 to Len-1 do begin
                                        GetMem( Pixel, Len*4 );
                                        glReadPixels( 0, SubY, Len, 1, GL_RGBA, GL_UNSIGNED_BYTE, Pixel );
                                        for SubX := 0 to Len-1 do begin
                                                Bitmap.Canvas.Pixels[ X*Len + SubX, Y*Len+(Len-SubY-1) ] := ( Pixel^[SubX*4+2] shl 16 ) + ( Pixel^[SubX*4+1] shl 8 ) + ( Pixel^[SubX*4] );
                                        end;
                                        FreeMem( Pixel );
                                        gCopy := Ceil( SubY*100/(Len-1) );
                                        Synchronize( SetGaugeBars );
                                end;
                        end;

                        if Cut then begin
                                Bmp := TBitmap.Create;
                                Bmp.PixelFormat := pf32Bit;
                                Bmp.Height := 1000;
                                Bmp.Width := 1000;
                                for SubY := 0 to 999 do begin
                                        GetMem( Pixel, 1000*4 );
                                        glReadPixels( 0, SubY, 1000, 1, GL_RGBA, GL_UNSIGNED_BYTE, Pixel );
                                        for SubX := 0 to 999 do begin
                                                Bmp.Canvas.Pixels[ SubX, (1000-SubY-1) ] := ( Pixel^[SubX*4+2] shl 16 ) + ( Pixel^[SubX*4+1] shl 8 ) + ( Pixel^[SubX*4] );
                                        end;
                                        FreeMem( Pixel );
                                        gCopy := Ceil( SubY*100/999 );
                                        Synchronize( SetGaugeBars );
                                end;

                                JPG := TJPEGImage.Create;
                                JPG.CompressionQuality := 100;
                                JPG.Assign( Bmp );
                                JPG.SaveToFile( ExtractFilePath( Application.ExeName ) + 'screens\' + FileName + Format( '_%d_%d.jpg', [Y,X] ) );
                                JPG.Free;

                                Bmp.Free;
                        end;

                        gAll := Ceil( (Y*(CX+1)+(X+1))*100/((CX+1)*(CY+1)) );
                        Synchronize( SetGaugeBars );
                end;
        end;

        if Resize then begin
                JPG := TJPEGImage.Create;
                JPG.CompressionQuality := 100;
                JPG.Assign( Bitmap );
                JPG.SaveToFile( ExtractFilePath( Application.ExeName ) + 'screens\' + FileName + '.jpg' );
                JPG.Free;

                Bitmap.Free;
        end;

        Panel.Free;
        ItemListe.Free;

        Palanthir.Data := nil;
        Data.Free;        
        Palanthir.Shard.Free;
        Palanthir.Shard := nil;
        Active := False;
end;

procedure TScreenshotForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
        if Thread <> nil then
                if Thread.Active then
                        CanClose := False;
end;

procedure TScreenshotForm.FormCreate(Sender: TObject);
begin
        Thread := nil;
end;

procedure TScreenshotForm.btnStartClick(Sender: TObject);
begin
        if Thread = nil then begin
                Thread := TWorkThread.Create( True );
                Thread.Priority := tpIdle;
                Thread.Resume;
        end
        else if not Thread.Active then begin
                Thread.Free;
                Thread := TWorkThread.Create( True );
                Thread.Priority := tpIdle;
                Thread.Resume;
        end;
end;

end.
