unit uShardSelect;

interface

uses    Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
        Dialogs, StdCtrls, GR32_Image, ComCtrls, uConfig, GR32, GR32_Layers,
        uUtilities, GIFImage, Jpeg, ExtCtrls, ShellAPI, rmBrowseFor, AbBase,
        AbBrowse, AbZBrows, AbUnzper, AbArcTyp, IdHTTP, XMLLib, StrAdapterUTF_8,
        StrAdapterISO8859_1, uIrisUpdate;

const   LocalVersion = 83;

type    TSShard = Class
                public
                        ShardConfig : TConfig;
                        IrisConfig : TConfig;
                        Icon : TBitmap32;
                        Image : TImage32;
                        Online : Boolean;
                        Nr : Word;
                        Name : String;
                        constructor Create;
                        destructor Free;
                        procedure DblClick(Sender: TObject);
                        procedure ShardMouseDown( Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer; Layer: TCustomLayer );
        end;

        TShardSelect = class( TForm )
                Background: TImage32;
                CreateShard: TImage32;
                DeleteShard: TImage32;
                EditShard: TImage32;
                LoadShard: TImage32;
                Settings: TImage32;
                Start: TImage32;
                Cancel: TImage32;
                Up: TImage32;
                Down: TImage32;
                lVersion: TLabel;
                StartTimer: TTimer;
                procedure CancelClick(Sender: TObject);
                procedure StartClick(Sender: TObject);
                procedure FormCreate(Sender: TObject);
                procedure FormDestroy(Sender: TObject);
                procedure DeleteShardClick(Sender: TObject);
                procedure UpClick(Sender: TObject);
                procedure DownClick(Sender: TObject);
                procedure CreateShardClick(Sender: TObject);
                procedure EditShardClick(Sender: TObject);
                procedure SettingsClick(Sender: TObject);
                procedure StartTimerTimer(Sender: TObject);
                procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
                private
                        CurrentShard : Integer;
                        ShardList : TList;
                        MinShard : Integer;
                        procedure UpdateIris( Shard : TSShard );
                public
                        MayStart : Boolean;
                        ScriptsPath : String;
                        ScriptsVersion : Integer;
                        procedure DrawShards;                
                        function GetCurrentShard : TSShard;
                        procedure StartStarter;
                        procedure StartClient;
        end;

var     ShardSelect : TShardSelect;

implementation

{$R *.dfm}

uses    uShardSettings, uGlobalSettings, uAutoupdate, uAutoPatcher;

procedure TShardSelect.StartStarter;
var     Shards : TStringList;
        Dir : TSearchRec;
        I : Integer;
        Shard : TSShard;
        GImage : TGIFImage;
        Path : String;
begin
        ScriptsPath := '';
        ScriptsVersion := 0;

        StartTimer.Enabled := False;
        MayStart := True;

        AutoUpdate := TAutoUpdate.Create( nil );
        AutoUpdate.StartUpdate;

        if not MayStart then
                Close;

        if not DirectoryExists( ExtractFilePath( Application.ExeName ) + 'shards' ) then
                ForceDirectories( ExtractFilePath( Application.ExeName ) + 'shards' );        

        lVersion.Caption := Format( 'Version: %d', [LocalVersion] );
        if FindFirst( ExtractFilePath( Application.ExeName ) + 'shards\*', faDirectory, Dir ) <> 0 then begin
                Close;
        end;

        Config.SetString( 'Shardname', '' );

        Shards := TStringList.Create;

        repeat
                if (Dir.Name <> '.') and (Dir.Name <> '..') then
                        if FileExists( ExtractFilePath( Application.ExeName ) + 'shards\' + Dir.Name + '\config.xml' ) then
                                Shards.Add( Dir.Name );
        until FindNext( Dir ) <> 0;
        FindClose( Dir );

        ShardList := TList.Create;
        for I := 0 to Shards.Count-1 do begin
                Shard := TSShard.Create;
                Shard.Nr := I;
                Shard.Name := Shards.Strings[I];
                Shard.ShardConfig.Load( ExtractFilePath( Application.ExeName ) + 'shards\' + Shards.Strings[I] + '\config.xml' );
                Shard.IrisConfig.Load( ExtractFilePath( Application.ExeName ) + 'shards\' + Shards.Strings[I] + '\irisconfig.xml' );
                if Shard.ShardConfig.GetString( 'icon' ) <> '' then
                        Path := Shard.ShardConfig.GetString( 'icon' )
                else
                        Path := ExtractFilePath( Application.ExeName ) + 'logo.gif';
                if Pos( 'gif', Path ) > 0 then begin
                        GImage := TGIFImage.Create;
                        GImage.LoadFromFile( Path );
                        Shard.Icon.Assign( GImage );
                        GImage.Free;
                end
                else begin
                        Shard.Icon.LoadFromFile( Path );;
                end;
                Shard.Image.OnMouseDown := Shard.ShardMouseDown;
                Shard.Image.OnDblClick := Shard.DblClick;
                ShardList.Add( Shard );

                //Encryption Fix
                {if (Shard.ShardConfig.GetString( 'Password' ) <> '') and (Length( Shard.ShardConfig.GetString( 'Password' ) ) <> 16) then begin
                        Shard.ShardConfig.SetString( 'Password', EncryptPassword( Shard.ShardConfig.GetString( 'Password' ) ) );
                end;
                if (Shard.ShardConfig.GetString( 'APPassword' ) <> '') and (Length( Shard.ShardConfig.GetString( 'APPassword' ) ) <> 16) then begin
                        Shard.ShardConfig.SetString( 'APPassword', EncryptPassword( Shard.ShardConfig.GetString( 'APPassword' ) ) );
                end;}                
        end;

        if ShardList.Count > 0 then begin
                Shard := TSShard( ShardList.Items[ 0 ] );
                Config.SetString( 'Shardname', Shard.Name );
                CurrentShard := 0;
        end;

        DrawShards;

        Shards.Free;

        Show;
end;

procedure TShardSelect.StartClient;
var     ShardConfig : TConfig;
        VerzDialog : TrmBrowseForFolder;
        Unzip : TAbUnZipper;
        FileName : String;
        FStream : TFileStream;
        HTTP : TIdHTTP;
begin
        if Config.GetInteger( 'DoNotCloseShardSelecton' ) = 0 then
                Hide;

        ShardConfig := TSShard( ShardList.Items[ CurrentShard ] ).ShardConfig;

        {if Pos( 'ARAHIL', UpperCase( ShardConfig.GetString( 'APLogin' ) ) ) > 0  then begin
                ShowMessage( 'Huhu Bernhard :)' );
                ShowMessage( 'brigens...' );
                ShowMessage( 'So viele Fenster die maln JEDESMAL...' );
                ShowMessage( '...wegclicken muss' );
                ShowMessage( 'Knnen einem ganz schn auf die Nerven gehn.' );
                ShowMessage( ':P' );
                ShowMessage( ':-) :-)' );
        end;}

        if (ShardConfig.GetString( 'UseIris' ) <> '') and ShardConfig.GetBool( 'UseIris' ) then begin
                UpdateIris( TSShard( ShardList.Items[ CurrentShard ] ) );
        end
        else begin
                if ShardConfig.GetInteger( 'ScriptsVersion' ) < ScriptsVersion then begin
                        FileName := ExtractFilePath( Application.ExeName ) + 'temp\scripts.zip';
                        if FileExists( FileName ) then
                                DeleteFile( FileName );

                        FStream := TFileStream.Create( FileName, fmCreate );

                        HTTP := TIdHttp.Create( nil );
                        HTTP.RedirectMaximum := 100;
                        HTTP.HandleRedirects := True;
                        HTTP.ConnectTimeout := 500;
                        HTTP.Get( ScriptsPath, FStream );
                        HTTP.Free;

                        FStream.Free;

                        if not DirectoryExists( ExtractFilePath( Application.ExeName ) + 'shards\' + TSShard( ShardList.Items[ CurrentShard ] ).Name + '\script\' ) then
                                ForceDirectories( ExtractFilePath( Application.ExeName ) + 'shards\' + TSShard( ShardList.Items[ CurrentShard ] ).Name + '\script\' );

                        Unzip := TAbUnZipper.Create( nil );
                        Unzip.FileName := FileName;
                        Unzip.BaseDirectory := ExtractFilePath( Application.ExeName ) + 'shards\' + TSShard( ShardList.Items[ CurrentShard ] ).Name + '\script\';
                        Unzip.ExtractOptions := [eoCreateDirs, eoRestorePath];
                        Unzip.ExtractFiles( '*.*' );
                        Unzip.Free;

                        ShardConfig.SetInteger( 'ScriptsVersion', ScriptsVersion );
                end;
        end;

        if ShardConfig.GetBool( 'UseAutopatcher' ) then begin
                try
                        Patcher := TPatcher.Create( nil );
                        Patcher.StartPatcher;
                        Patcher.Free;
                except
                        on E : Exception do showmessage( E.Message );
                end;
        end;

        if not MayStart then begin
                Close;
                exit;
        end;

        if not DirectoryExists( Config.GetString( 'UOPath' ) ) then begin
                VerzDialog := TrmBrowseForFolder.create( Self );
                VerzDialog.Title := 'Choose your UO Directory';

                if not VerzDialog.Execute then begin
                        VerzDialog.Free;
                        exit;
                end;

                Config.SetString( 'UOPath', VerzDialog.Folder + '\' );
                VerzDialog.Free;
        end;

        if (ShardConfig.GetString( 'UseIris' ) <> '') and ShardConfig.GetBool( 'UseIris' ) then begin
                ShellExecute( 0, 'open', PChar( 'iris.exe' ), nil, PChar( ExtractFilePath( Application.ExeName ) + 'shards\' + TSShard( ShardList.Items[ CurrentShard ] ).Name + '\iris\' ), SW_SHOWNORMAL )
        end
        else begin
                if Config.GetInteger( 'ShowDebugConsole' ) <> 0 then
                        ShellExecute( 0, 'open', PChar( 'Palanthir.exe' ), PChar( '-start -console' ), PChar( ExtractFilePath( Application.ExeName ) ), SW_SHOWNORMAL )
                else
                        ShellExecute( 0, 'open', PChar( 'Palanthir.exe' ), PChar( '-start' ), PChar( ExtractFilePath( Application.ExeName ) ), SW_SHOWNORMAL );
        end;

        if Config.GetInteger( 'DoNotCloseShardSelecton' ) = 0 then
                Close;
end;

procedure TShardSelect.UpdateIris( Shard : TSShard );
var     IrisConfig : TXMLLib;
        Path : String;
        Node : TXMLNode;
begin
        Path := ExtractFilePath( Application.ExeName ) + 'shards\' + Shard.Name + '\iris';

        if not DirectoryExists( Path ) then
                ForceDirectories( Path );

        IrisUpdate := TIrisUpdate.Create( nil );
        IrisUpdate.IrisPath := Path + '\';
        IrisUpdate.IrisConfig := Shard.IrisConfig;
        IrisUpdate.StartUpdate;

        IrisConfig := TXMLLib.Create;
        IrisConfig.LoadFromFile( Path + '\xml\config.xml' );

        if IrisConfig.CreatePathAndNode( 'config.gfx.width', Node ) then begin Node.Value.AsInteger := Config.GetInteger( 'ScreenWidth' ); end;
        if IrisConfig.CreatePathAndNode( 'config.gfx.height', Node ) then begin Node.Value.AsInteger := Config.GetInteger( 'ScreenHeight' ); end;

        if IrisConfig.CreatePathAndNode( 'config.net.server', Node ) then begin Node.Value.AsString := Shard.ShardConfig.GetString( 'IP' ); end;
        if IrisConfig.CreatePathAndNode( 'config.net.port', Node ) then begin Node.Value.AsInteger := Shard.ShardConfig.GetInteger( 'Port' ); end;
        if IrisConfig.CreatePathAndNode( 'config.net.login', Node ) then begin Node.Value.AsString := Shard.ShardConfig.GetString( 'Login' ); end;
        if IrisConfig.CreatePathAndNode( 'config.net.password', Node ) then begin Node.Value.AsString := DecryptPassword( Shard.ShardConfig.GetString( 'Password' ) ); end;

        if IrisConfig.CreatePathAndNode( 'config.uo.mulpath', Node ) then begin Node.Value.AsString := ExcludeTrailingPathDelimiter( Config.GetString( 'UOPath' ) ); end;
        if Shard.ShardConfig.GetString( 'LoginString' ) <> '' then
                if IrisConfig.CreatePathAndNode( 'config.uo.client_identification', Node ) then begin Node.Value.AsString := Shard.ShardConfig.GetString( 'LoginString' ); end;
        if IrisConfig.CreatePathAndNode( 'config.uo.cliloc_language', Node ) then begin Node.Value.AsString := Config.GetString( 'Language' ); end;

        if IrisConfig.CreatePathAndNode( 'config.sound.music', Node ) then begin Node.Value.AsBoolean := Config.GetBool( 'Music' ); end;
        if IrisConfig.CreatePathAndNode( 'config.sound.sound', Node ) then begin Node.Value.AsBoolean := Config.GetBool( 'Sound' ); end;
        if IrisConfig.CreatePathAndNode( 'config.sound.footsteps', Node ) then begin Node.Value.AsBoolean := Config.GetBool( 'Walkingsounds' ); end;

        if IrisConfig.CreatePathAndNode( 'config.gfx.bpp', Node ) then begin Node.Value.AsInteger := Shard.IrisConfig.GetInteger( 'BPP' ); end;
        if IrisConfig.CreatePathAndNode( 'config.gfx.roof_fade_time', Node ) then begin Node.Value.AsInteger := Shard.IrisConfig.GetInteger( 'RoofFadeTime' ); end;
        if IrisConfig.CreatePathAndNode( 'config.gfx.zbuffer_size', Node ) then begin Node.Value.AsInteger := Shard.IrisConfig.GetInteger( 'ZBufferSize' ); end;
        if IrisConfig.CreatePathAndNode( 'config.gfx.fullscreen', Node ) then begin Node.Value.AsInteger := Shard.IrisConfig.GetInteger( 'ScreenType' ); end;
        if IrisConfig.CreatePathAndNode( 'config.gfx.cursor', Node ) then begin Node.Value.AsInteger := Shard.IrisConfig.GetInteger( 'Cursor' ); end;
        if IrisConfig.CreatePathAndNode( 'config.gfx.viewdistance', Node ) then begin Node.Value.AsInteger := Shard.IrisConfig.GetInteger( 'ViewDistance' ); end;
        if IrisConfig.CreatePathAndNode( 'config.gfx.maxzoom', Node ) then begin Node.Value.AsInteger := Shard.IrisConfig.GetInteger( 'MaxZoom' ); end;
        if IrisConfig.CreatePathAndNode( 'config.gfx.maxangle', Node ) then begin Node.Value.AsInteger := Shard.IrisConfig.GetInteger( 'MaxAngle' ); end;
        if IrisConfig.CreatePathAndNode( 'config.gfx.brightness', Node ) then begin Node.Value.AsInteger := Shard.IrisConfig.GetInteger( 'Brightness' ); end;

        if IrisConfig.CreatePathAndNode( 'config.net.is_uox3', Node ) then begin Node.Value.AsBoolean := Shard.IrisConfig.GetBool( 'UOX3' ); end;
        if IrisConfig.CreatePathAndNode( 'config.net.is_sphere', Node ) then begin Node.Value.AsBoolean := Shard.IrisConfig.GetBool( 'Sphere' ); end;
        if IrisConfig.CreatePathAndNode( 'config.net.is_sphere55r', Node ) then begin Node.Value.AsBoolean := Shard.IrisConfig.GetBool( 'Sphere55R' ); end;
        if IrisConfig.CreatePathAndNode( 'config.net.is_pol', Node ) then begin Node.Value.AsBoolean := Shard.IrisConfig.GetBool( 'Pol' ); end;
        if IrisConfig.CreatePathAndNode( 'config.net.is_runuo', Node ) then begin Node.Value.AsBoolean := Shard.IrisConfig.GetBool( 'RunUO' ); end;

        if IrisConfig.CreatePathAndNode( 'config.uo.aos', Node ) then begin Node.Value.AsBoolean := Shard.IrisConfig.GetBool( 'AOS' ); end;
        if IrisConfig.CreatePathAndNode( 'config.uo.aostooltips', Node ) then begin Node.Value.AsBoolean := Shard.IrisConfig.GetBool( 'AOSTooltips' ); end;
        if IrisConfig.CreatePathAndNode( 'config.uo.popup_menu', Node ) then begin Node.Value.AsBoolean := Shard.IrisConfig.GetBool( 'PopupMenu' ); end;
        if IrisConfig.CreatePathAndNode( 'config.uo.use_speech', Node ) then begin Node.Value.AsBoolean := Shard.IrisConfig.GetBool( 'UseSpeech' ); end;

        if IrisConfig.CreatePathAndNode( 'config.sound.mp3', Node ) then begin Node.Value.AsBoolean := Shard.IrisConfig.GetBool( 'MP3' ); end;
        if IrisConfig.CreatePathAndNode( 'config.sound.soundvolume', Node ) then begin Node.Value.AsInteger := Shard.IrisConfig.GetInteger( 'SoundVolume' ); end;
        if IrisConfig.CreatePathAndNode( 'config.sound.musicvolume', Node ) then begin Node.Value.AsInteger := Shard.IrisConfig.GetInteger( 'MusicVolume' ); end;

        if IrisConfig.CreatePathAndNode( 'config.iris.mouseover_timer', Node ) then begin Node.Value.AsInteger := Shard.IrisConfig.GetInteger( 'MouseOverTimer' ); end;

        if not DirectoryExists( Path + '\xml' ) then
                ForceDirectories( Path + '\xml' );        
        IrisConfig.SaveToFile( Path + '\xml\config.xml' );
        IrisConfig.Free;
end;

constructor TSShard.Create;
begin
        ShardConfig := TConfig.Create;
        IrisConfig := TConfig.Create;
        Image := TImage32.Create( ShardSelect.BackGround );
        Image.Parent := ShardSelect.Background;
        Image.Width := 285;
        Image.Height := 80;
        Image.Left := 15;
        Image.Top := 15;
        Image.Visible := False;
        Icon := TBitmap32.Create;
        Icon.SetSize( 60, 60 );
        Icon.Clear( $007F7F7F );
        Online := False;
end;

destructor TSShard.Free;
begin
        ShardConfig.Free;
        IrisConfig.Free;
        Icon.Free;
        Image.Free;
end;

procedure TSShard.DblClick(Sender: TObject);
begin
        ShardSelect.StartClient;
end;

procedure TSShard.ShardMouseDown( Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer; Layer: TCustomLayer );
begin
        ShardSelect.CurrentShard := Nr;
        Config.SetString( 'Shardname', Name );
        ShardSelect.DrawShards;
end;

procedure TShardSelect.FormCreate(Sender: TObject);
begin
        CurrentShard := -1;
        MinShard := 0;
        StartTimer.Enabled := True;
end;

procedure TShardSelect.FormDestroy(Sender: TObject);
var     I : Integer;
begin
        if ShardList <> nil then begin
                for I := 0 to ShardList.Count-1 do
                        TSShard( ShardList.Items[ I ] ).Free;
                ShardList.Free;
        end;
end;

procedure TShardSelect.DrawShards;
var     I : Integer;
        Shard : TSShard;
begin
        if CurrentShard > ShardList.Count-1 then
                CurrentShard := -1;

        for I := 0 to ShardList.Count-1 do begin
                Shard := TSShard( ShardList.Items[ I ] );
                if (I < MinShard) or (I > MinShard+2) then begin
                        Shard.Image.Visible := False;
                end
                else begin
                        Shard.Image.Top := (I-MinShard)*90 + 15;
                        Shard.Image.Bitmap.SetSize( 285, 80 );
                        Shard.Image.Bitmap.Draw( MakeRect( 0, 0, 285, 80 ), MakeRect( 15, Shard.Image.Top, 300, Shard.Image.Top+80 ), Background.Bitmap );
                        if I = CurrentShard then
                                Shard.Image.Bitmap.FrameRectS( 0, 0, 285, 80, Color32( 0, 0, 255, 120 ) )
                        else
                                Shard.Image.Bitmap.FrameRectS( 0, 0, 285, 80, Color32( 255, 255, 255, 120 ) );
                        Shard.Image.Bitmap.Font.Size := 15;
                        Shard.Image.Bitmap.Font.Color := clWhite;
                        Shard.Image.Bitmap.UpdateFont;
                        Shard.Image.Bitmap.TextOut( 10, 10, Shard.Name );
                        Shard.Image.Bitmap.Font.Size := 7;
                        Shard.Image.Bitmap.UpdateFont;
                        Shard.Image.Bitmap.TextOut( 10, 50, Format( '%s:%s', [Shard.ShardConfig.GetString( 'IP' ),Shard.ShardConfig.GetString( 'Port' )] ) );
                        Shard.Image.Bitmap.Draw( 215, 10, Shard.Icon );                        
                        Shard.Image.Visible := True;
                end;
        end;
end;

procedure TShardSelect.CancelClick(Sender: TObject);
begin
        Close;
end;

procedure TShardSelect.StartClick(Sender: TObject);
begin
        if CurrentShard < 0 then
                exit;
        StartClient;
end;

procedure TShardSelect.DeleteShardClick(Sender: TObject);
var     Dir : String;
        I : Integer;
begin
        if Application.MessageBox( PChar( 'Do you really want to delete Shard ' + TSShard( ShardList.Items[ CurrentShard ] ).Name + ' ?' ), PChar( 'Delete Shard' ), MB_YESNO ) = IDNO then begin
                exit;
        end;

        if CurrentShard = -1 then
                exit;
        Dir := ExtractFilePath( Application.ExeName ) + 'shards\' + TSShard( ShardList.Items[ CurrentShard ] ).Name;
        TSShard( ShardList.Items[ CurrentShard ] ).Free;
        ShardList.Delete( CurrentShard );
        for I := 0 to ShardList.Count-1 do
                TSShard( ShardList.Items[ I ] ).Nr := I;
        CurrentShard := -1;
        DrawShards;
        DelDir( Dir );
        RemoveDir( Dir );
end;

procedure TShardSelect.UpClick(Sender: TObject);
begin
        if MinShard > 0 then
                Dec( MinShard );
        DrawShards;
end;

procedure TShardSelect.DownClick(Sender: TObject);
begin
        if MinShard < ShardList.Count-3 then
                Inc( MinShard );
        DrawShards;
end;

procedure TShardSelect.CreateShardClick(Sender: TObject);
var     Shard : TSShard;
        I : Integer;
        Dir, Path : String;
        GImage : TGIFImage;
        SConfig : TStringList;
begin
        Shard := TSShard.Create;

        I := 1;
        Dir := ExtractFilePath( Application.ExeName ) + 'shards';
        if not DirectoryExists( Dir ) then
                CreateDir( Dir );
        Dir := Dir + '\';
        Shard.Name := 'New Shard';
        if DirectoryExists( Dir + Shard.Name ) then begin
                while DirectoryExists( Dir + Shard.Name + IntToStr( I ) ) do
                        Inc( I );
                Shard.Name := Shard.Name + IntToStr( I );
        end;
        CreateDir( Dir + Shard.Name );
        CreateDir( Dir + Shard.Name + '\data' );
        
        SConfig := TStringList.Create;
        SConfig.Add( '<configuration>' );
        SConfig.Add( '</configuration>' );
        SConfig.SaveToFile( Dir + Shard.Name + '\config.xml' );
        SConfig.Free;

        Shard.Nr := ShardList.Count;
        Shard.ShardConfig.Load( ExtractFilePath( Application.ExeName ) + 'shards\' + Shard.Name + '\config.xml' );
        if Shard.ShardConfig.GetString( 'icon' ) <> '' then
                Path := Shard.ShardConfig.GetString( 'icon' )
        else
                Path := ExtractFilePath( Application.ExeName ) + 'logo.gif';
        if Pos( 'gif', Path ) > 0 then begin
                GImage := TGIFImage.Create;
                GImage.LoadFromFile( Path );
                Shard.Icon.Assign( GImage );
                GImage.Free;
        end
        else begin
                Shard.Icon.LoadFromFile( Path );;
        end;
        Shard.Image.OnMouseDown := Shard.ShardMouseDown;
        Shard.Image.OnDblClick := Shard.DblClick;

        Shard.ShardConfig.SetString( 'IP', '000.000.000.000' );
        Shard.ShardConfig.SetString( 'Port', '2593' );

        ShardList.Add( Shard );
        CurrentShard := ShardList.Count-1;
        if MinShard < CurrentShard-2 then
                MinShard := CurrentShard-2;
        Config.SetString( 'Shardname', Shard.Name );
        DrawShards;
end;

procedure TShardSelect.EditShardClick(Sender: TObject);
begin
        if CurrentShard = -1 then
                exit;
        ShardSettings.Hide;
        ShardSettings.Show;
end;

function TShardSelect.GetCurrentShard : TSShard;
begin
        if CurrentShard = -1 then begin
                Result := nil;
                exit;
        end;

        Result := TSShard( ShardList.Items[ CurrentShard ] );
end;

procedure TShardSelect.SettingsClick(Sender: TObject);
begin
        GlobalSettings.Show;
end;

procedure TShardSelect.StartTimerTimer(Sender: TObject);
begin
        StartStarter;
end;

procedure TShardSelect.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
        if ssAlt in Shift then begin
                if LowerCase( Chr( Key ) ) = 'c' then begin
                        CreateShardClick( Sender );
                end
                else if LowerCase( Chr( Key ) ) = 'd' then begin
                        DeleteShardClick( Sender );
                end
                else if LowerCase( Chr( Key ) ) = 'e' then begin
                        EditShardClick( Sender );
                end
                else if LowerCase( Chr( Key ) ) = 'l' then begin
                        ShowMessage( 'Not yet implemented.' );
                end
                else if LowerCase( Chr( Key ) ) = 's' then begin
                        SettingsClick( Sender );
                end;
        end;
end;

end.
