unit uShardSettings;

interface

uses    Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
        Dialogs, StdCtrls, ExtCtrls, uShardSelect, uConfig, uUtilities, Mask,
        rmBrowseFor, uIrisConfig;

const   VersionCount = 29;
        Versions : Array[0..VersionCount-1] of String = (
        '2.00.40', '2.00.50', '2.00.60', '2.00.70', '2.00.80',
        '2.00.90', '3.00.00', '2.00.10', '3.00.20', '3.00.30',
        '3.00.40', '3.00.50', '3.00.60', '3.00.70', '3.00.80',
        '4.00.00', '4.00.10', '4.00.20', '4.00.30', '4.00.40',
        '4.00.50', '4.00.60', '4.00.70', '4.00.80', '4.00.90',
        '4.00.100', '4.00.110', '5.0.0', '5.0.1' );

        Keys : Array[0..VersionCount-1,0..1] of LongWord = (
        ($2df385bd, $a3ed127f),
        ($2c0b97ad, $a310de7f),
        ($2c43ed9d, $a334227f),
        ($2c9bc78d, $a35bfe7f),
        ($2cd3257d, $a37f527f),
        ($2ceb076d, $a363be7f),
        ($2d93a5fd, $a3dd527f),
        ($2DABA7ED, $A3C17E7F),
        ($2DE3ADDD, $A3E5227F),
        ($2D3BB7CD, $A3895E7F),
        ($2D7385BD, $A3AD127F),
        ($2C8B97AD, $A350DE7F),
        ($2CC3ED9D, $A374227F),
        ($2C1BC78D, $A31BFE7F),
        ($2C53257D, $A33F527F),
        ($2E13A5FD, $A21D527F),
        ($2E2BA7ED, $A2017E7F),
        ($2E63ADDD, $A225227F),
        ($2EBBB7CD, $A2495E7F),
        ($2EF385BD, $A26D127F),
        ($2F0B97AD, $A290DE7F),
        ($2F43ED9D, $A2B4227F),
        ($2F9BC78D, $A2DBFE7F),
        ($2FD3257D, $A2FF527F),
        ($2FEB076D, $A2E3BE7F),
        ($2C236D5D, $A300A27F),
        ($2C7B574D, $A32D9E7F),
        ($2E93A5FC, $A25D527F),
        ($2EABA7ED, $A2417E7F)
         );



type    TShardSettings = class(TForm)
                eName: TLabeledEdit;
                eIP: TLabeledEdit;
                ePort: TLabeledEdit;
                eLogin: TLabeledEdit;
                eIcon: TLabeledEdit;
                cbUseAutopatcher: TCheckBox;
                gbAutopatcher: TGroupBox;
                eAPAddress: TLabeledEdit;
                eAPLogin: TLabeledEdit;
                btnOK: TButton;
                btnCancel: TButton;
                btnApply: TButton;
                btnBrowseIcon: TButton;
                ePassword: TMaskEdit;
                lPassword: TLabel;
                lAPPassword: TLabel;
                eAPPassword: TMaskEdit;
                cbUseEncryption: TCheckBox;
                gbEncryption: TGroupBox;
                eEKey1: TLabeledEdit;
                eEKey2: TLabeledEdit;
                cbChooseClientVersion: TComboBox;
                eDataPath: TLabeledEdit;
                btnBrowseDataPath: TButton;
                cbSound: TCheckBox;
                cbMusic: TCheckBox;
                cbClient: TComboBox;
                btnIrisConfig: TButton;
                procedure cbUseAutopatcherClick(Sender: TObject);
                procedure FormActivate(Sender: TObject);
                procedure btnApplyClick(Sender: TObject);
                procedure btnCancelClick(Sender: TObject);
                procedure btnOKClick(Sender: TObject);
                procedure btnBrowseIconClick(Sender: TObject);
                procedure cbUseEncryptionClick(Sender: TObject);
                procedure cbChooseClientVersionChange(Sender: TObject);
                procedure eEKey1Change(Sender: TObject);
                procedure eEKey2Change(Sender: TObject);
                procedure btnBrowseDataPathClick(Sender: TObject);
                procedure btnIrisConfigClick(Sender: TObject);
                private
                        Shard : TSShard;
                        DoNotChangeClientVersion : Boolean;
                public
        end;

var     ShardSettings: TShardSettings;

implementation

{$R *.dfm}

procedure TShardSettings.cbUseAutopatcherClick(Sender: TObject);
begin
        if cbUseAutopatcher.Checked then begin
                gbAutopatcher.Enabled := True;
                eAPAddress.Enabled := True;
                eAPLogin.Enabled := True;
                eAPPassword.Enabled := True;
                lAPPassword.Enabled := True;
        end
        else begin
                gbAutopatcher.Enabled := False;
                eAPAddress.Enabled := False;
                eAPLogin.Enabled := False;
                eAPPassword.Enabled := False;
                lAPPassword.Enabled := False;
        end;
end;

procedure TShardSettings.cbUseEncryptionClick(Sender: TObject);
begin
        if cbUseEncryption.Checked then begin
                gbEncryption.Enabled := True;
                eEKey1.Enabled := True;
                eEKey2.Enabled := True;
                cbChooseClientVersion.Enabled := True;
        end
        else begin
                gbEncryption.Enabled := False;
                eEKey1.Enabled := False;
                eEKey2.Enabled := False;
                cbChooseClientVersion.Enabled := False;
        end;
end;

procedure TShardSettings.FormActivate(Sender: TObject);
var     I : Integer;
begin
        Shard := ShardSelect.GetCurrentShard;

        if Shard = nil then
                exit;

        DoNotChangeClientVersion := True;

        eName.Text := Shard.Name;
        eIP.Text := Shard.ShardConfig.GetString( 'IP' );
        ePort.Text := Shard.ShardConfig.GetString( 'Port' );
        eLogin.Text := Shard.ShardConfig.GetString( 'Login' );
        ePassword.Text := DecryptPassword( Shard.ShardConfig.GetString( 'Password' ) );
        eIcon.Text := Shard.ShardConfig.GetString( 'icon' );
        eDataPath.Text := Shard.ShardConfig.GetString( 'DataPath' );
        eAPAddress.Text := Shard.ShardConfig.GetString( 'APAddress' );
        eAPLogin.Text := Shard.ShardConfig.GetString( 'APLogin' );
        eAPPassword.Text := DecryptPassword( Shard.ShardConfig.GetString( 'APPassword' ) );
        cbUseAutopatcher.Checked := Shard.ShardConfig.GetBool( 'UseAutopatcher' );
        cbUseAutopatcherClick( Sender );
        eEKey1.Text := Shard.ShardConfig.GetString( 'LoginKey1' );
        eEKey2.Text := Shard.ShardConfig.GetString( 'LoginKey2' );
        cbUseEncryption.Checked := Shard.ShardConfig.GetBool( 'ActivateLoginEncryption' );
        cbUseEncryptionClick( Sender );

        if Shard.ShardConfig.GetString( 'Sound' ) = '' then
                Shard.ShardConfig.SetBool( 'Sound', True );
        if Shard.ShardConfig.GetString( 'Music' ) = '' then
                Shard.ShardConfig.SetBool( 'Music', True );

        cbSound.Checked := Shard.ShardConfig.GetBool( 'Sound' );
        cbMusic.Checked := Shard.ShardConfig.GetBool( 'Music' );

        if (Shard.ShardConfig.GetString( 'UseIris' ) <> '') and Shard.ShardConfig.GetBool( 'UseIris' ) then begin
                cbClient.ItemIndex := 1;
                btnIrisConfig.Visible := True;
        end
        else begin
                cbClient.ItemIndex := 0;
                btnIrisConfig.Visible := False;
        end;

        cbChooseClientVersion.Clear;
        cbChooseClientVersion.Items.Add( 'Custom' ) ;
        for I := 0 to VersionCount-1 do begin
                cbChooseClientVersion.Items.Add( Versions[I] );
        end;

        cbChooseClientVersion.ItemIndex := 0;
        for I := 0 to VersionCount-1 do begin
                if (eEKey1.Text = Format( '0x%x', [Keys[I,0]] )) and
                   (eEKey2.Text = Format( '0x%x', [Keys[I,1]] )) then begin
                        cbChooseClientVersion.ItemIndex := I+1;
                        break;
                end;
        end;

        DoNotChangeClientVersion := False;
end;

procedure TShardSettings.btnApplyClick(Sender: TObject);
var     Path : String;
begin
        Shard.ShardConfig.SetString( 'IP', eIP.Text );
        Shard.ShardConfig.SetString( 'Port', ePort.Text );
        Shard.ShardConfig.SetString( 'Login', eLogin.Text );
        Shard.ShardConfig.SetString( 'Password', EncryptPassword( ePassword.Text ) );
        Shard.ShardConfig.SetString( 'icon', eIcon.Text );
        Shard.ShardConfig.SetString( 'DataPath', eDataPath.Text );
        if (eAPAddress.Text <> '') and (eAPAddress.Text[ Length( eAPAddress.Text ) ] <> '/') then
                eAPAddress.Text := eAPAddress.Text + '/';
        Shard.ShardConfig.SetString( 'APAddress', eAPAddress.Text );
        Shard.ShardConfig.SetString( 'APLogin', eAPLogin.Text );
        Shard.ShardConfig.SetString( 'APPassword', EncryptPassword( eAPPassword.Text ) );
        Shard.ShardConfig.SetBool( 'UseAutopatcher', cbUseAutopatcher.Checked );
        Shard.ShardConfig.SetString( 'LoginKey1', eEKey1.Text );
        Shard.ShardConfig.SetString( 'LoginKey2', eEKey2.Text );
        if cbChooseClientVersion.ItemIndex > -1 then begin
                Shard.ShardConfig.SetString( 'LoginString', cbChooseClientVersion.Items[ cbChooseClientVersion.ItemIndex ] );
        end;
        Shard.ShardConfig.SetBool( 'ActivateLoginEncryption', cbUseEncryption.Checked );

        Shard.ShardConfig.SetBool( 'Sound', cbSound.Checked );
        Shard.ShardConfig.SetBool( 'Music', cbMusic.Checked );

        if eName.Text <> Shard.Name then begin
                Path := ExtractFilePath( Application.ExeName ) + 'shards\';
                if DirectoryExists( Path + eName.Text ) then
                        showmessage( 'Could not rename Shard' )
                else begin
                        Shard.ShardConfig.Free;
                        try
                                RenameDir( Path + Shard.Name, Path + eName.Text );
                                try
                                        Shard.ShardConfig := TConfig.Create;
                                        Shard.ShardConfig.Load( Path + eName.Text + '\config.xml' );
                                        Shard.Name := eName.Text;
                                except
                                        ShowMessage( 'Renaming sharddirectory failed.' );
                                        Shard.ShardConfig.Free;
                                        Shard.ShardConfig := TConfig.Create;
                                        Shard.ShardConfig.Load( Path + Shard.Name + '\config.xml' );
                                end;
                        except
                                ShowMessage( 'Renaming sharddirectory failed.' );
                                Shard.ShardConfig := TConfig.Create;
                                Shard.ShardConfig.Load( Path + Shard.Name + '\config.xml' );
                        end;
                end;
        end;

        case cbClient.ItemIndex of
                0 : begin
                        if Shard.ShardConfig.GetString( 'UseIris' ) <> '' then
                                Shard.ShardConfig.SetBool( 'UseIris', False );
                        btnIrisConfig.Visible := False;
                end;
                1 : begin
                        Shard.ShardConfig.SetBool( 'UseIris', True );
                        btnIrisConfig.Visible := True;
                        IrisConfigForm.IrisConfig := Shard.IrisConfig;
                        IrisConfigForm.Show;
                        IrisConfigForm.Hide;                        
                end;
        end;

        ShardSelect.DrawShards;
end;

procedure TShardSettings.btnCancelClick(Sender: TObject);
begin
        Hide;
end;

procedure TShardSettings.btnOKClick(Sender: TObject);
begin
        btnApplyClick( Sender );
        Hide;
end;

procedure TShardSettings.btnBrowseIconClick(Sender: TObject);
var     OpenDialog : TOpenDialog;
begin
        OpenDialog := TOpenDialog.Create( nil );
        OpenDialog.Title := 'Choose your Icon:';

        if not OpenDialog.Execute then begin
                OpenDialog.Free;
                exit;
        end;

        if ( ExtractFileExt( OpenDialog.FileName ) = '.bmp' ) or
           ( ExtractFileExt( OpenDialog.FileName ) = '.jpg' ) or
           ( ExtractFileExt( OpenDialog.FileName ) = '.jpeg' ) or
           ( ExtractFileExt( OpenDialog.FileName ) = '.gif' ) then
                eIcon.Text := OpenDialog.FileName
        else
                showmessage( 'chosen file format is not supported...' );
        OpenDialog.Free;
end;

procedure TShardSettings.cbChooseClientVersionChange(Sender: TObject);
begin
        DoNotChangeClientVersion := True;
        if cbChooseClientVersion.ItemIndex = 0 then begin
                eEKey1.Text := '0x0';
                eEKey2.Text := '0x0';
        end
        else begin
                eEKey1.Text := Format( '0x%x', [Keys[cbChooseClientVersion.ItemIndex-1,0]] );
                eEKey2.Text := Format( '0x%x', [Keys[cbChooseClientVersion.ItemIndex-1,1]] );
        end;
        DoNotChangeClientVersion := False;
end;

procedure TShardSettings.eEKey1Change(Sender: TObject);
begin
        if not DoNotChangeClientVersion then begin
                cbChooseClientVersion.ItemIndex := 0;
        end;
end;

procedure TShardSettings.eEKey2Change(Sender: TObject);
begin
        if not DoNotChangeClientVersion then begin
                cbChooseClientVersion.ItemIndex := 0;
        end;
end;

procedure TShardSettings.btnBrowseDataPathClick(Sender: TObject);
var     VerzDialog : TrmBrowseForFolder;
begin
        VerzDialog := TrmBrowseForFolder.create( self );
        VerzDialog.Title := 'Choose your UO DataPath (has to be different to your UOPath)';

        if not VerzDialog.Execute then begin
                VerzDialog.Free;
                exit;
        end;

        eDataPath.Text := VerzDialog.Folder + '\';
        VerzDialog.Free;
end;

procedure TShardSettings.btnIrisConfigClick(Sender: TObject);
begin
        IrisConfigForm.IrisConfig := Shard.IrisConfig;
        IrisConfigForm.Hide;
        IrisConfigForm.Show;
end;

end.
