unit uUpdateForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ShellAPI;

type    TUpdaterForm = class( TForm )
                lUpdate: TLabel;
                StartTimer: TTimer;
                procedure FormCreate(Sender: TObject);
                procedure StartTimerTimer(Sender: TObject);
                private
                public
        end;

var     UpdaterForm: TUpdaterForm;

implementation

{$R *.dfm}

procedure TUpdaterForm.FormCreate(Sender: TObject);
begin
        StartTimer.Enabled := True;
end;

procedure TUpdaterForm.StartTimerTimer(Sender: TObject);
var     FileName : String;
begin
        StartTimer.Enabled := False;
        if ParamCount = 0 then
                exit;

        FileName := ExtractFilePath( Application.ExeName ) + ParamStr( 1 );
        if FileExists( FileName + '_old.exe' ) then
                DeleteFile( FileName + '_old.exe' );
        if FileExists( FileName + '.exe' ) then
                RenameFile( Filename + '.exe', FileName + '_old.exe' );
        if FileExists( FileName + '_new.exe' ) then
                RenameFile( Filename + '_new.exe', FileName + '.exe' );

        ShellExecute( 0, 'open', PChar( Filename + '.exe' ), nil, PChar( ExtractFilePath( Application.ExeName ) ), SW_SHOWNORMAL );
        Close;
end;

end.
