unit uBook;

interface

uses    uGumps, SysUtils, uRecievePackets, Classes, uTexCache, uSendPackets,
        Dialogs, Math;

type    TBookPage = Class;

        TBook = Class( TGump )
                private
                        _Serial : LongWord;
                        PageCount : Word;
                        Pages : TList;
                        Writable : Byte;
                        Flag : Byte;
                        ForwardButton, BackButton : TGumpButton;
                        CurrentPage : Word;
                        Author, Title : TInputField;
                        By, RightPageNumber, LeftPageNumber : TGumpText;
                        function GetPage( Number : Word ) : TBookPage;
                public
                        constructor Create; override;
                        destructor Free; override;
                        property Serial : LongWord read _Serial;
                        procedure Init( Packet : GetBookTitlePage ); overload;
                        procedure Init( Packet : GetNewBookTitlePage ); overload;
                        procedure Fill( Packet : GetBook );
                        function Draw : Boolean; override;
                        procedure OnButtonClick( ReturnNumber : Integer ); override;
                        procedure OnDblClick( GumpObject : TGumpObject ); override;
        end;

        TBookPage = Class
                public
                        Number : Word;
                        InputField : TInputField;
                        constructor Create( Number : Word );
                        destructor Free;
        end;

implementation

uses    uPalanthir;

constructor TBookPage.Create( Number : Word );
begin
        Self.Number := Number;
        InputField := TInputField.Create( 224, 40, 150, 135, '', 1, 0, $2, (Number div 2)+1, False, False, True );
        InputField.Border := False;
        InputField.MaxLines := 8;
        InputField.SelectionHue := $2;
end;

destructor TBookPage.Free;
begin
        InputField.Free;
end;

function TBook.GetPage( Number : Word ) : TBookPage;
var     I : Integer;
begin
        Result := nil;

        for I := 0 to Pages.Count-1 do begin
                if TBookPage( Pages.Items[ I ] ).Number = Number then begin
                        Result := TBookPage( Pages.Items[ I ] );
                        Break;
                end;
        end;
end;

constructor TBook.Create;
begin
        inherited Create;
        Pages := TList.Create;
        Typ := GumpTyp_Book;
        _Serial := Invalid_Serial;
        CurrentPage := 0;

        AddImage( 0, 0, $1FE, 0, 0 );
        BackButton := TGumpButton.Create( 0, 0, $1FF, $1FF, $1FF, 1, 0 );
        BackButton.Gump := Self;
        ForwardButton := TGumpButton.Create( 356, 0, $200, $200, $200, 2, 0 );
        ForwardButton.Gump := Self;

        Author := TInputField.Create( 40, 70, 25, 150, '', 1, 0, $1, 0 );
        Author.Border := False;
        Author.SelectionHue := $1;
        Author.Gump := Self;

        By := TGumpText.Create( 40, 140, 'by', 1, $1, 0, False );
        By.Gump := Self;

        Title := TInputField.Create( 40, 160, 25, 150, '', 1, 0, $1, 0 );
        Title.Border := False;
        Title.SelectionHue := $1;
        Title.Gump := Self;

        RightPageNumber := TGumpText.Create( 300, 203, '1', 1, $1, 0, False );
        RightPageNumber.Gump := Self;

        LeftPageNumber := TGumpText.Create( 100, 203, '2', 1, $1, 0, False );
        LeftPageNumber.Gump := Self;
end;

destructor TBook.Free;
var     I : Integer;
        UpdateBookPage : TUpdateBookPage;
        Liste : TStringList;
        InputField : TInputField;
        UpdateBook : TUpdateBook;
begin
        if Author.TextChanged or Title.TextChanged then begin
                UpdateBook := TUpdateBook.Create;
                UpdateBook.SetSerial( Serial );
                UpdateBook.SetTitle( Title.Text );
                UpdateBook.SetAuthor( Author.Text );
                Palanthir.SendPacket( UpdateBook );
        end;

        BackButton.Free;
        ForwardButton.Free;
        Author.Free;
        By.Free;
        Title.Free;
        RightPageNumber.Free;
        LeftPageNumber.Free;

        for I := 0 to Min( 8, Pages.Count-1 ) do begin
                if TBookPage( Pages.Items[ I ] ).InputField.TextChanged then begin
                        UpdateBookPage := TUpdateBookPage.Create;
                        UpdateBookPage.SetSerial( Serial );
                        UpdateBookPage.SetPage( TBookPage( Pages.Items[ I ] ).Number );

                        InputField := TBookPage( Pages.Items[ I ] ).InputField;

                        Liste := Palanthir.Data.GetUnicodeLines( InputField.Font, InputField.Text, InputField.Breite, InputField.Border );
                        UpdateBookPage.SetLines( Liste );
                        Liste.Free;

                        Palanthir.SendPacket( UpdateBookPage );
                end;
        end;

        for I := 0 to Pages.Count-1 do
                TBookPage( Pages.Items[ I ] ).Free;
        Pages.Free;

        inherited Free;
end;

procedure TBook.Init( Packet : GetBookTitlePage );
var     I : Integer;
        BookPage : TBookPage;
begin
        _Serial := Packet.GetSerial;
        PageCount := Packet.GetPageCount;

        for I := 0 to PageCount-1 do begin
                BookPage := TBookPage.Create( I+1 );
                BookPage.InputField.Gump := Self;                
                Pages.Add( BookPage );
        end;

        Author.Text := Packet.GetAuthor;
        Author.TextChanged := False;
        Title.Text := Packet.GetTitle;
        Title.TextChanged := False;
        Writable := Packet.GetWritable;
        Flag := Packet.GetFlag;
end;

procedure TBook.Init( Packet : GetNewBookTitlePage );
var     I : Integer;
        BookPage : TBookPage;
begin
        _Serial := Packet.GetSerial;
        PageCount := Packet.GetPageCount;

        for I := 0 to PageCount-1 do begin
                BookPage := TBookPage.Create( I+1 );
                BookPage.InputField.Gump := Self;
                Pages.Add( BookPage );
        end;

        Author.Text := Packet.GetAuthor;
        Title.Text := Packet.GetTitle;
        Writable := Packet.GetWritable;
        Flag := Packet.GetFlag;        
end;

procedure TBook.Fill( Packet : GetBook );
var     Count, Page, LineCount, Line : Word;
        PageNr : Word;
        TmpText : String;
        K : Word;
        B : Byte;
        BookPage : TBookPage;
begin
        Count := Packet.GetPageCout;
        Page := 0;
        K := 9;

        while Page < Count do begin
                PageNr := Packet.GetWord( K );
                Inc( K, 2 );
                LineCount := Packet.GetWord( K );
                Inc( K, 2 );
                Line := 0;
                TmpText := '';

                while Line < LineCount do begin
                        repeat
                                B := Packet.GetByte( K );
                                if B <> 0 then
                                        TmpText := TmpText + Chr( B );
                                Inc( K );
                        until B = 0;
                        Inc( Line );

                        if Line < LineCount then
                                TmpText := TmpText + #10;
                end;

                TmpText := Utf8Decode( TmpText );

                BookPage := GetPage( PageNr );
                if BookPage <> nil then begin
                        BookPage.InputField.Text := TmpText;
                        BookPage.InputField.TextChanged := False;
                end;

                Inc( Page );
        end;
end;

function TBook.Draw : Boolean;
var     BookPage : TBookPage;
begin
        Result := inherited Draw;

        if CurrentPage > 1 then
                BackButton.Draw;

        if CurrentPage < PageCount-1 then
                ForwardButton.Draw;

        if CurrentPage > 0 then begin
                BookPage := GetPage( CurrentPage );
                if BookPage <> nil then begin
                        BookPage.InputField.X := 40;
                        BookPage.InputField.Draw;
                end;

                LeftPageNumber.Text := Format( '%d', [CurrentPage] );
                LeftPageNumber.Draw;

                if CurrentPage+1 < PageCount then begin
                        BookPage := GetPage( CurrentPage+1 );
                        if BookPage <> nil then begin
                                BookPage.InputField.X := 224;
                                BookPage.InputField.Draw;
                        end;

                        RightPageNumber.Text := Format( '%d', [CurrentPage+1] );
                        RightPageNumber.Draw;
                end;
        end
        else begin
                Title.Draw;
                By.Draw;
                Author.Draw;

                BookPage := GetPage( 1 );
                if BookPage <> nil then begin
                        BookPage.InputField.X := 224;
                        BookPage.InputField.Draw;
                end;

                RightPageNumber.Text := Format( '%d', [CurrentPage+1] );
                RightPageNumber.Draw;
        end;
end;

procedure TBook.OnButtonClick( ReturnNumber : Integer );
begin
        Case ReturnNumber of
                0 : begin
                        Palanthir.DeleteGump( Self );
                        Exit;
                end;
                1 : begin
                        if CurrentPage > 1 then
                                Dec( CurrentPage, 2 );
                end;
                2 : begin
                        if CurrentPage < PageCount-1 then
                                Inc( CurrentPage, 2 );
                end;
        end;
end;

procedure TBook.OnDblClick( GumpObject : TGumpObject );
begin
        if GumpObject = BackButton then
                CurrentPage := 0
        else if GumpObject = ForwardButton then
                CurrentPage := PageCount - (PageCount mod 2);
end;

end.
