unit uBuyWindow;

interface

uses    uGumps, uRecievePackets, uChar, uItem, Classes, SysUtils, uUtilities,
        Math, uSendPackets;

type    TBuyWindow = Class( TGump )
                private
                        VendorSerial : LongWord;
                        Liste : TList;
                        FirstBuyItem, FirstBoughtItem, BoughtCount : Integer;
                        MomGold, GesGold : TGumpText;
                        TooltipItem1, TooltipItem2, TooltipItem3 : TGumpTooltip;
                        TooltipBoughtItem1, TooltipBoughtItem2, TooltipBoughtItem3 : TGumpTooltip;
                public
                        constructor Create; override;
                        destructor Free; override;
                        function Draw : Boolean; override;
                        procedure OnScrollBar( GumpObject : TGumpObject ); override;
                        procedure OnClick( X, Y : Word ); override;
                        function OnDblClick( X, Y : Word ) : Boolean; override;
                        procedure Init( Packet : OpenBuyWindow );
        end;

        TBuyItem = Record
                Price : LongWord;
                Description : String;
                Serial : LongWord;
                Amount : Word;
                Id : Word;
                Color : Word;
                ToolTipText : String;

                GODescription : TCroppedText;
                GOAmount : TGumpText;
                GOImage : TTilePic;
                GOSelAmount : TGumpText;
                GOIncButton, GoDecButton : TGumpButton;

                SelectedAmount : Word;
        end;

        PBuyItem = ^TBuyItem;

implementation

uses    uPalanthir;

constructor TBuyWindow.Create;
begin
        inherited Create;
        Liste := TList.Create;

        FirstBuyItem := 0;
        FirstBoughtItem := 0;
        BoughtCount := 0;

        MomGold := TGumpText.Create( 242, 390, '0', 0, 0, 0 );
        MomGold.Gump := Self;
        GesGold := TGumpText.Create( 360, 390, IntToStr( Palanthir.Player.Gold ), 0, 0, 0 );
        GesGold.Gump := Self;

        AddImage( 0, 0, $870, 0, 0 );
        AddImage( 170, 225, $871, 0, 0 );

        AddScrollBar( 240, 60, False, 127, $1F, $1F, 1, 0 );
        AddScrollBar( 410, 290, False, 86, $1F, $1F, 2, 0 );

        TooltipItem1 := AddTooltip( 44, 72, 160, 40, '' );
        TooltipItem2 := AddTooltip( 44, 143, 160, 40, '' );
        TooltipItem3 := AddTooltip( 44, 205, 160, 40, '' );

        TooltipBoughtItem1 := AddTooltip( 208, 288, 160, 30, '' );
        TooltipBoughtItem2 := AddTooltip( 208, 323, 160, 30, '' );
        TooltipBoughtItem3 := AddTooltip( 208, 358, 160, 30, '' );
end;

destructor TBuyWindow.Free;
var     I : Integer;
begin
        for I := 0 to Liste.Count-1 do begin
                PBuyItem( Liste.Items[ I ] ).GODescription.Free;
                PBuyItem( Liste.Items[ I ] ).GOAmount.Free;
                PBuyItem( Liste.Items[ I ] ).GOImage.Free;
                PBuyItem( Liste.Items[ I ] ).GOSelAmount.Free;
                PBuyItem( Liste.Items[ I ] ).GOIncButton.Free;
                PBuyItem( Liste.Items[ I ] ).GoDecButton.Free;                                
                Dispose( Liste.Items[ I ] );
        end;

        inherited Free;
end;

procedure TBuyWindow.Init( Packet : OpenBuyWindow );
var     Char : TChar;
        Item : TItem;
        ContPacket : GetItemsInContainer;
        I, Position : Integer;
        ContItemCount : Word;
        StrLength : Byte;
        BuyItem : PBuyItem;
        ClilocID : LongWord;
begin
        Item := TItem( Palanthir.Data.GlobalObjectList.GetObject( Packet.GetVendorSerial and not $80000000 ) );

        if (Item = nil) or (Item.Container = nil) then begin
                Self.Free;
                exit;
        end;

        VendorSerial := Item.Container.Serial;

        Char := TChar( Palanthir.Data.GlobalObjectList.GetObject( VendorSerial ) );
        if Char = nil then begin
                Self.Free;
                exit;
        end;

        ContPacket := Palanthir.Network.LastContPacket;
        ContItemCount := ContPacket.GetItemCount -1;

        Position := 8;
        for I := 0 to Packet.GetItemCount-1 do begin
                New( BuyItem );
                BuyItem.Price := Packet.GetLongWord( Position );
                StrLength := Packet.getByte( Position+4 );
                BuyItem.Description := Packet.GetAsciiString( Position+5, StrLength );
                Position := Position + 5 + StrLength;

                if (Packet.GetVendorSerial and $80000000) = $80000000 then begin
                        StrLength := Packet.GetByte( Position );
                        BuyItem.ToolTipText := Packet.GetAsciiString( Position + 1, StrLength );
                        Position := Position + 1 + StrLength;
                end
                else begin
                        BuyItem.ToolTipText := '';
                end;

                try
                        ClilocID := StrToInt( BuyItem.Description );
                        BuyItem.Description := Palanthir.Data.GetClilocMessage( ClilocID );
                except
                        //Do nothing;
                end;

                BuyItem.Serial := ContPacket.GetItemSerial( ContItemCount-I );
                BuyItem.Amount := ContPacket.GetAmount( ContItemCount-I );
                BuyItem.SelectedAmount := 0;
                BuyItem.Id := ContPacket.GetItemID( ContItemCount-I );
                BuyItem.Color := ContPacket.GetColor( ContItemCount-I );

                BuyItem.GODescription := TCroppedText.Create( 0, 0, 40, 110, Format( '%s : %d', [BuyItem.Description,BuyItem.Price] ), 0, 0, 0, 2 );
                BuyItem.GODescription.Gump := Self;

                BuyItem.GOAmount := TGumpText.Create( 0, 0, IntToStr( BuyItem.Amount-BuyItem.SelectedAmount ), 0, 0, 0 );
                BuyItem.GOAmount.Gump := Self;

                BuyItem.GOImage := TTilePic.Create( 0, 0, BuyItem.Id, BuyItem.Color, 0 );
                BuyItem.GOImage.Gump := Self;

                BuyItem.GOSelAmount := TGumpText.Create( 0, 0, IntToStr( BuyItem.SelectedAmount ), 0, 0, 0 );
                BuyItem.GOSelAmount.Gump := Self;

                BuyItem.GOIncButton := TGumpButton.Create( 0, 0, $37, $37, $37, Liste.Count*2+2, 0 );
                BuyItem.GOIncButton.Gump := Self;

                BuyItem.GoDecButton := TGumpButton.Create( 0, 0, $38, $38, $38, Liste.Count*2+3, 0 );
                BuyItem.GoDecButton.Gump := Self;

                Liste.Add( BuyItem );
        end;

        Palanthir.AddGump( Self );
        Packet.Free;
end;

function TBuyWindow.Draw : Boolean;
var     I, BuyCount, BCount : Integer;
        BuyItem : PBuyItem;
        Gold : LongWord;
        Promille : Word;
begin
        if FirstBoughtItem > Max( 0, BoughtCount-3 ) then
                FirstBoughtItem := Max( 0, BoughtCount-3 );

        if GetObjectCount = 0 then begin
                Result := True;
                exit;
        end;

        if Liste.Count > 3 then begin
                Promille := TScrollBar( GetObject( 2 ) ).Promille;
                if (Promille <= Trunc(1000*FirstBuyItem/(Liste.Count-3))) or (Promille >= Trunc(1000*(FirstBuyItem+1)/(Liste.Count-3))) then begin
                        TScrollBar( GetObject( 2 ) ).Promille := Trunc(1000*FirstBuyItem/(Liste.Count-3));
                end;
        end;

        if BoughtCount > 3 then begin
                Promille := TScrollBar( GetObject( 3 ) ).Promille;
                if (Promille <= Trunc(1000*FirstBoughtItem/(BoughtCount-3))) or (Promille >= Trunc(1000*(FirstBoughtItem+1)/(BoughtCount-3))) then begin
                        TScrollBar( GetObject( 3 ) ).Promille := Trunc(1000*FirstBoughtItem/(BoughtCount-3));
                end;
        end;

        Result := inherited Draw;

        GesGold.Text := IntToStr( Palanthir.Player.Gold );
        GesGold.Draw;

        BuyCount := 0;
        BCount := 0;
        Gold := 0;

        TooltipItem1.Tooltip := '';
        TooltipItem2.Tooltip := '';
        TooltipItem3.Tooltip := '';

        TooltipBoughtItem1.Tooltip := '';
        TooltipBoughtItem2.Tooltip := '';
        TooltipBoughtItem3.Tooltip := '';

        for I := 0 to Liste.Count-1 do begin
                BuyItem := PBuyItem( Liste.Items[ I ] );

                if (I >= FirstBuyItem) and (BuyCount < 3) then begin
                        BuyItem.GOImage.X := 44;
                        BuyItem.GOImage.Y := 72 + 62*BuyCount;
                        BuyItem.GOImage.Draw;

                        BuyItem.GODescription.X := 92;
                        BuyItem.GODescription.Y := 72 + 62*BuyCount;
                        BuyItem.GODescription.Hoehe := 40;
                        BuyItem.GODescription.Draw;

                        BuyItem.GOAmount.X := 208;
                        BuyItem.GOAmount.Y := 83 + 62*BuyCount;
                        BuyItem.GOAmount.Draw;

                        Inc( BuyCount );

                        Case BuyCount of
                                1 : TooltipItem1.Tooltip := BuyItem.ToolTipText;
                                2 : TooltipItem2.Tooltip := BuyItem.ToolTipText;
                                3 : TooltipItem3.Tooltip := BuyItem.ToolTipText;
                        end;
                end;
                
                if (BCount >= FirstBoughtItem) and (BCount < FirstBoughtItem+3) and (BuyItem.SelectedAmount > 0) then begin
                        BuyItem.GOSelAmount.X := 208;
                        BuyItem.GOSelAmount.Y := 290 + (BCount-FirstBoughtItem)*35;
                        BuyItem.GOSelAmount.Draw;

                        BuyItem.GODescription.X := 228;
                        BuyItem.GODescription.Y := 288 + (BCount-FirstBoughtItem)*35;
                        BuyItem.GODescription.Hoehe := 376 - BuyItem.GODescription.Y;
                        BuyItem.GODescription.Draw;

                        BuyItem.GOIncButton.X := 372;
                        BuyItem.GOIncButton.Y := 291 + (BCount-FirstBoughtItem)*35;
                        BuyItem.GOIncButton.Draw;

                        BuyItem.GoDecButton.X := 392;
                        BuyItem.GoDecButton.Y := 291 + (BCount-FirstBoughtItem)*35;
                        BuyItem.GoDecButton.Draw;
                end;

                if BuyItem.SelectedAmount > 0 then begin
                        Inc( BCount );
                        Gold := Gold + BuyItem.Price*BuyItem.SelectedAmount;

                        Case BCount of
                                1 : TooltipBoughtItem1.Tooltip := BuyItem.ToolTipText;
                                2 : TooltipBoughtItem2.Tooltip := BuyItem.ToolTipText;
                                3 : TooltipBoughtItem3.Tooltip := BuyItem.ToolTipText;
                        end;
                end;
        end;

        MomGold.Text := IntToStr( Gold );
        MomGold.Draw;
end;

procedure TBuyWindow.OnScrollBar( GumpObject : TGumpObject );
begin
        case TScrollBar( GumpObject ).Number of
                1 : begin
                        if Liste.Count > 3 then begin
                                FirstBuyItem := Trunc( TScrollBar( GumpObject ).Promille * (Liste.Count-3) / 1000 );
                        end;
                end;
                2 : begin
                        if BoughtCount > 3 then begin
                                FirstBoughtItem := Trunc( TScrollBar( GumpObject ).Promille * (BoughtCount-3) / 1000 );
                        end;
                end;
        end;
end;

procedure TBuyWindow.OnClick( X, Y : Word );
var     BuyItem : PBuyItem;
        I, K, BCount : Integer;
        SendBuyItems : TSendBuyItems;
begin
        if IsInRect( X, Y, 232, 48, 251, 61 ) then begin
                //Oberer linker Pfeil
                if FirstBuyItem > 0 then
                        Dec( FirstBuyItem );
                exit;
        end
        else if IsInRect( X, Y, 232, 190, 251, 205 ) then begin
                //Unterer linker Pfeil
                if FirstBuyItem < Liste.Count-3 then
                        Inc( FirstBuyItem );
                exit;
        end
        else if IsInRect( X, Y, 404, 275, 423, 289 ) then begin
                //Oberer rechter Pfeil
                if FirstBoughtItem > 0 then
                        Dec( FirstBoughtItem );

                exit;
        end
        else if IsInRect( X, Y, 404, 382, 423, 394 ) then begin
                //Oberer linker Pfeil
                if FirstBoughtItem < BoughtCount-3 then
                        Inc( FirstBoughtItem );

                exit;
        end
        else if IsInRect( X, Y, 202, 410, 225, 434 ) then begin
                //Kauf besttigen
                if BoughtCount > 0 then begin
                        SendBuyItems := TSendBuyItems.Create;
                        SendBuyItems.SetSerial( VendorSerial );

                        for I := 0 to Liste.Count-1 do begin
                                BuyItem := Liste.Items[ I ];
                                if BuyItem.SelectedAmount > 0 then begin
                                        SendBuyItems.AddItem( BuyItem.Serial, BuyItem.SelectedAmount );
                                end;
                        end;

                        Palanthir.SendPacket( SendBuyItems );
                end;

                Palanthir.DeleteGump( Self );
                exit;
        end
        else if IsInRect( X, Y, 377, 410, 397, 434 ) then begin
                //Kauf verwerfen
                Palanthir.DeleteGump( Self );
                exit;
        end;

        for I := 0 to 2 do begin
                if IsInRect( X, Y, 372, 291+I*35, 386, 307+I*35 ) then begin
                        BuyItem := nil;
                        BCount := 0;
                        for K := 0 to Liste.Count-1 do begin
                                if PBuyItem( Liste.Items[ K ] ).SelectedAmount > 0 then begin
                                        if BCount = FirstBoughtItem+I then begin
                                                BuyItem := PBuyItem( Liste.Items[ K ] );
                                                break;
                                        end;
                                        Inc( BCount );
                                end;
                        end;

                        if BuyItem <> nil then begin
                                if BuyItem.Amount > BuyItem.SelectedAmount then begin
                                        if BuyItem.SelectedAmount = 0 then
                                                Inc( BoughtCount );

                                        Inc( BuyItem.SelectedAmount );
                                        BuyItem.GOAmount.Text := IntToStr( BuyItem.Amount - BuyItem.SelectedAmount );
                                        BuyItem.GOSelAmount.Text := IntToStr( BuyItem.SelectedAmount );
                                end;
                        end;
                        exit;
                end
                else if IsInRect( X, Y, 392, 291+I*35, 406, 307+I*35 ) then begin
                        BuyItem := nil;
                        BCount := 0;
                        for K := 0 to Liste.Count-1 do begin
                                if PBuyItem( Liste.Items[ K ] ).SelectedAmount > 0 then begin
                                        if BCount = FirstBoughtItem+I then begin
                                                BuyItem := PBuyItem( Liste.Items[ K ] );
                                                break;
                                        end;
                                        Inc( BCount );
                                end;
                        end;

                        if BuyItem <> nil then begin
                                if BuyItem.SelectedAmount > 0 then begin
                                        if BuyItem.SelectedAmount = 1 then
                                                Dec( BoughtCount );

                                        Dec( BuyItem.SelectedAmount );
                                        BuyItem.GOAmount.Text := IntToStr( BuyItem.Amount - BuyItem.SelectedAmount );
                                        BuyItem.GOSelAmount.Text := IntToStr( BuyItem.SelectedAmount );
                                end;
                        end;
                        exit;
                end;
        end;
end;

function TBuyWindow.OnDblClick( X, Y : Word ) : Boolean;
var     BuyItem : PBuyItem;
        I, K, BCount : Integer;
begin
        Result := True;
        
        if IsInRect( X, Y, 25, 58, 225, 228 ) then begin
                if Y <= 115 then begin
                        if Liste.Count > FirstBuyItem then
                                BuyItem := PBuyItem( Liste.Items[ FirstBuyItem ] )
                        else
                                BuyItem := nil;
                end
                else if Y >= 172 then begin
                        if Liste.Count > FirstBuyItem+2 then
                                BuyItem := PBuyItem( Liste.Items[ FirstBuyItem+2 ] )
                        else
                                BuyItem := nil;
                end
                else begin
                        if Liste.Count > FirstBuyItem+1 then
                                BuyItem := PBuyItem( Liste.Items[ FirstBuyItem+1 ] )
                        else
                                BuyItem := nil;
                end;

                if BuyItem <> nil then begin
                        if BuyItem.Amount > BuyItem.SelectedAmount then begin
                                if BuyItem.SelectedAmount = 0 then
                                        Inc( BoughtCount );

                                Inc( BuyItem.SelectedAmount );
                                BuyItem.GOAmount.Text := IntToStr( BuyItem.Amount - BuyItem.SelectedAmount );
                                BuyItem.GOSelAmount.Text := IntToStr( BuyItem.SelectedAmount );
                        end;
                end;
                exit;
        end;

        for I := 0 to 2 do begin
                if IsInRect( X, Y, 372, 291+I*35, 386, 307+I*35 ) then begin
                        BuyItem := nil;
                        BCount := 0;
                        for K := 0 to Liste.Count-1 do begin
                                if PBuyItem( Liste.Items[ K ] ).SelectedAmount > 0 then begin
                                        if BCount = FirstBoughtItem+I then begin
                                                BuyItem := PBuyItem( Liste.Items[ K ] );
                                                break;
                                        end;
                                        Inc( BCount );
                                end;
                        end;

                        if BuyItem <> nil then begin
                                if BuyItem.Amount > BuyItem.SelectedAmount then begin
                                        Inc( BuyItem.SelectedAmount );
                                        BuyItem.GOAmount.Text := IntToStr( BuyItem.Amount - BuyItem.SelectedAmount );
                                        BuyItem.GOSelAmount.Text := IntToStr( BuyItem.SelectedAmount );
                                end;
                        end;
                        exit;
                end
                else if IsInRect( X, Y, 392, 291+I*35, 406, 307+I*35 ) then begin
                        BuyItem := nil;
                        BCount := 0;
                        for K := 0 to Liste.Count-1 do begin
                                if PBuyItem( Liste.Items[ K ] ).SelectedAmount > 0 then begin
                                        if BCount = FirstBoughtItem+I then begin
                                                BuyItem := PBuyItem( Liste.Items[ K ] );
                                                break;
                                        end;
                                        Inc( BCount );
                                end;
                        end;

                        if BuyItem <> nil then begin
                                if BuyItem.SelectedAmount > 0 then begin
                                        Dec( BuyItem.SelectedAmount );
                                        BuyItem.GOAmount.Text := IntToStr( BuyItem.Amount - BuyItem.SelectedAmount );
                                        BuyItem.GOSelAmount.Text := IntToStr( BuyItem.SelectedAmount );
                                end;
                        end;
                        exit;
                end;
        end;
end;

end.

