unit uCharCreation;

interface

uses    uGumps, uSendPackets, uRecievePackets, IdIPWatch, Classes, StrLib,
        SysUtils, uUtilities, uLoaderHues, Dialogs, uLog;

const   MaxStats = 80;
        MaxSkills = 100;

        SkillCount = 54;
        SkillNames : Array[0..SkillCount-1] of String = (
                'Alchemy',
                'Anatomy',
                'Animallore',
                'Item Identification',
                'Armslore',
                'Parrying',
                'Begging',
                'Blacksmithing',
                'Bowcraft',
                'Peacemaking',
                'Camping',
                'Carpentry',
                'Cartography',
                'Cooking',
                'Detecting Hidden',
                'Enticement',
                'Evaluating Intelligence',
                'Healing',
                'Fishing',
                'Forensics',
                'Herding',
                'Hiding',
                'Provocation',
                'Inscription',
                'Lockpicking',
                'Magery',
                'Magic Resistance',
                'Tactics',
                'Snooping',
                'Musicianship',
                'Poisoning',
                'Archery',
                'Spiritspeak',
                'Stealing',
                'Tailoring',
                'Taming',
                'Taste Identification',
                'Tinkering',
                'Tracking',
                'Veterinary',
                'Swordsmanship',
                'Macefighting',
                'Fencing',
                'Wrestling',
                'Lumberjacking',
                'Mining',
                'Meditation',
                'Stealth',
                'Remove Traps',
                'Necromancy',
                'Focus',
                'Chivalry',
                'Bushido',
                'Ninjitsu' );

        HairCount = 10;
        HairIDs : Array[0..HairCount-1] of Word = (
                $203B, $203C, $203D, $2044, $2045, $2046, $2047, $2048, $2049, 0 );
        HairNames : Array[0..HairCount-1] of String = (
                'Short Hair', 'Long Hair', 'Pony Tail', 'Mohawk',
                'Pageboy', 'Buns Hair', 'Afro', 'Recending Hair',
                '2 pig-tails', 'None' );
        HairGumpIDsMale : Array[0..HairCount-1] of Word = (
                $753, $754, $757, $755, $74F, $752, $751, $758, $74E, 0 );
        HairGumpIDsFemale : Array[0..HairCount-1] of Word = (
                $737, $72D, $734, $733, $734, $730, $72F, $736, $72C, 0 );

        BeardCount = 8;
        BeardIDs : Array[0..BeardCount-1] of Word = (
                $203E, $203F, $2040, $2041, $204B, $204C, $204D, 0 );
        BeardNames : Array[0..BeardCount-1] of String = (
                'Long Beard', 'Short Beard', 'Goatee', 'Mustache',
                'Med Short Beard', 'Med Long Beard', 'Vandyke', 'None' );
        BeardGumpIDs : Array[0..BeardCount-1] of Word = (
                $75B, $75D, $759, $75C, $75E, $75A, $75F, 0 );

type    TCharCreationGump = Class( TGump )
                private
                        Male : Boolean;
                        CurrentChar : Byte;
                        Skills : Array[0..2] of Byte;
                        SkillsChosen : Array[0..2] of Boolean;
                        QuestionDelete, QuestionSkillStat, QuestionChars : TGumpText;
                        StatStr, StatDex, StatInt, StatAll : TGumpText;
                        Skill1, Skill2, Skill3, SkillAll : TGumpText;
                        SkillName1, SkillName2, SkillName3 : TCroppedText;
                        SelectedSkillSlot : Byte;
                        Char, Shirt, Skirt, Shoes, Hair, Beard : TGImage;
                        ColorSkin, ColorShirt, ColorSkirt, ColorShoes, ColorHair, ColorBeard : Word;
                        ButtonSkin, ButtonShirt, ButtonSkirt, ButtonHair, ButtonBeard : THueButton;
                        MaleButton : TGumpButton;
                        ColoredChar, ColoredShirt, ColoredSkirt, ColoredHair, ColoredBeard : TGImage;
                        HairSlot, BeardSlot : SmallInt;
                        HairName, BeardName : TGumpText;
                        BeardText : TGumpText;
                        BeardButton : TGumpButton;
                        ColoredSkirtText, ColoredBeardText : TGumpText;
                        LocationSlot : Byte;
                public
                        MaxChars : Byte;
                        CharButtons : Array of TTextButton;
                        Passwords, CharNames : Array of String;
                        CharSlots : Array of Byte;
                        LocIndex : Array of Byte;
                        LocCities, LocNames : Array of String;
                        constructor Create; override;
                        destructor Free; override;
                        procedure OnButtonClick( ReturnNumber : Integer ); override;
                        procedure OnMoveOverButton( ReturnNumber : Integer ); override;
                        procedure OnScrollBar( GumpObject : TGumpObject ); override;
                        procedure OnDblClick( GumpObject : TGumpObject ); override;
                        function OnKeyReturn( GumpObject : TGumpObject ) : Boolean; override;
                        procedure SendCharCreationPacket;
        end;

implementation

uses uPalanthir;

constructor TCharCreationGump.Create;
var     I, J, PX, PY : Integer;
        Red, Green, Blue : Byte;
        Color : Word;
begin
        inherited Create;

        Typ := GumpTyp_CharCreation;

        CurrentChar := 0;
        SelectedSkillSlot := 0;
        X := 0;
        Y := 0;
        noMove := True;
        ActivePage := 1;
        Male := True;
        HairSlot := 0;
        BeardSlot := BeardCount-1;
        LocationSlot := 0;
        MaxChars := 5;

        ColorSkin := $3EA + Random( 7*8 );
        ColorShirt := 2 + Random( 500 );
        ColorSkirt := 2 + Random( 500 );
        ColorShoes := 0;
        ColorHair := $44E + Random( 48 );
        ColorBeard := $44E + Random( 48 );

        for I := 0 to 2 do begin
                Skills[I] := 255;
                SkillsChosen[I] := False;
        end;

        AddTiledImage( 0, 0, 480, 640, $588, 0, 0 );
        AddImage( 0, 0, $157C, 0, 0 );
        AddImage( 0, 5, $15A0, 0, 0 );

        AddButton( 555, 5, $1589, $158B, $158A, 1, 0 ); //Quit

        //Char Selection (Page 1)
        AddButton( 610, 440, $15A4, $15A6, $15A5, 102, 1 ); //Login with Selected Char

        if not Palanthir.EnabledME then begin
                AddResizeGump( 200, 100, $DAC, 400, 250, 0, 1 );
                AddButton( 230, 370, $159D, $159F, $159E, 110, 1 ); //New Char
                AddButton( 330, 370, $159A, $159C, $159B, 111, 1 ); //Delete Char
        end
        else begin
                AddResizeGump( 200, 100, $BB8, 400, 250, 0, 0, True );
        end;

        //Delete Char (Page 2)
        AddResizeGump( 200, 150, $A28, 300, 200, 0, 2 );
        QuestionDelete := AddText( 240, 180, '', 0, $481, 2 );
        AddButton( 260, 300, $481, $483, $482, 201, 2 );
        AddButton( 410, 300, $47E, $480, $47F, 202, 2 );

        //Char Creation => Choose Profession (Page 3)
        AddButton( 610, 440, $15A4, $15A6, $15A5, 305, 3 ); //Go On
        AddButton( 580, 440, $15A1, $15A3, $15A2, 306, 3 ); //Go Back
                
        AddResizeGump( 50, 150, $BB8, 150, 50, 0, 3 );
        AddText( 60, 155, 'Strength', 0, $481, 3 );
        StatStr := AddText( 150, 155, '10', 0, $481, 3 );
        //ScrollBar Strength
        AddImage( 60, 175, $D5, 0, 3 );
        AddTiledImage( 73, 175, 14, 74, $D6, 0, 3 );
        AddImage( 147, 175, $D7, 0, 3 );
        AddScrollBar( 60, 175, True, 100, $D8, $D8, 301, 3 );

        AddResizeGump( 50, 220, $BB8, 150, 50, 0, 3 );
        AddText( 60, 225, 'Dexterity', 0, $481, 3 );
        StatDex := AddText( 150, 225, '10', 0, $481, 3 );
        //ScrollBar Dexterity
        AddImage( 60, 245, $D5, 0, 3 );
        AddTiledImage( 73, 245, 14, 74, $D6, 0, 3 );
        AddImage( 147, 245, $D7, 0, 3 );
        AddScrollBar( 60, 245, True, 100, $D8, $D8, 302, 3 );

        AddResizeGump( 50, 290, $BB8, 150, 50, 0, 3 );
        AddText( 60, 295, 'Intelligence', 0, $481, 3 );
        StatInt := AddText( 150, 295, '10', 0, $481, 3 );
        //ScrollBar Intelligence
        AddImage( 60, 315, $D5, 0, 3 );
        AddTiledImage( 73, 315, 14, 74, $D6, 0, 3 );
        AddImage( 147, 315, $D7, 0, 3 );
        AddScrollBar( 60, 315, True, 100, $D8, $D8, 303, 3 );

        AddResizeGump( 50, 360, $BB8, 150, 30, 0, 3 );
        AddText( 60, 365, 'All Stats', 0, $481, 3 );
        StatAll := AddText( 133, 365, Format( '30 / %d', [MaxStats] ), 0, $481, 3 );

        AddResizeGump( 300, 150, $BB8, 230, 50, 0, 3 );
        SkillName1 := AddCroppedText( 328, 155, 20, 140, 'Skill1', 0, $481, 3 );
        Skill1 := AddText( 470, 155, '0', 0, $481, 3 );
        AddButton( 310, 157, $15E2, $15E2, $15E2, 307, 3 );
        //ScrollBar Skill1
        AddImage( 310, 175, $D5, 0, 3 );
        AddTiledImage( 323, 175, 14, 174, $D6, 0, 3 );
        AddImage( 497, 175, $D7, 0, 3 );
        AddScrollBar( 310, 175, True, 200, $D8, $D8, 304, 3 );

        AddResizeGump( 300, 220, $BB8, 230, 50, 0, 3 );
        SkillName2 := AddCroppedText( 328, 225, 20, 140, 'Skill2', 0, $481, 3 );
        Skill2 := AddText( 470, 225, '0', 0, $481, 3 );
        AddButton( 310, 227, $15E2, $15E2, $15E2, 308, 3 );
        //ScrollBar Skill2
        AddImage( 310, 245, $D5, 0, 3 );
        AddTiledImage( 323, 245, 14, 174, $D6, 0, 3 );
        AddImage( 497, 245, $D7, 0, 3 );
        AddScrollBar( 310, 245, True, 200, $D8, $D8, 305, 3 );

        AddResizeGump( 300, 290, $BB8, 230, 50, 0, 3 );
        SkillName3 := AddCroppedText( 328, 295, 20, 140, 'Skill3', 0, $481, 3 );
        Skill3 := AddText( 470, 295, '0', 0, $481, 3 );
        AddButton( 310, 297, $15E2, $15E2, $15E2, 309, 3 );
        //ScrollBar Skill3
        AddImage( 310, 315, $D5, 0, 3 );
        AddTiledImage( 323, 315, 14, 174, $D6, 0, 3 );
        AddImage( 497, 315, $D7, 0, 3 );
        AddScrollBar( 310, 315, True, 200, $D8, $D8, 306, 3 );

        AddResizeGump( 300, 360, $BB8, 230, 30, 0, 3 );
        AddText( 310, 365, 'All Skills', 0, $481, 3 );
        SkillAll := AddText( 383, 365, Format( '0 / %d', [MaxSkills] ), 0, $481, 3 );

        //Skill Table (Page 4)
        AddButton( 580, 440, $15A1, $15A3, $15A2, 400, 4 ); //Go Back

        PX := -120;
        PY := 50;

        for I := 0 to SkillCount-1 do begin
                if (I mod 20) = 0 then begin
                        PX := PX + 150;
                        PY := 50;
                end;
                AddTextButton( PX, PY, 401+I, SkillNames[I], 0, 4, 100, $481, 0, 0 );
                Inc( PY, 20 );
        end;

        //Skills or Stats do not fit (Page 5)
        AddResizeGump( 200, 150, $A28, 300, 200, 0, 5 );
        QuestionSkillStat := AddText( 240, 180, '', 0, $481, 5 );
        AddButton( 340, 300, $47E, $480, $47F, 500, 5 );

        //Clothing (Page 6)
        AddImage( 240, 95, $708, 0, 6 );
        AddImage( 242, 70, $70A, 0, 6 );
        AddTiledImage( 250, 70, 16, 214, $70B, 0, 6 );
        AddImage( 464, 70, $70C, 0, 6 );
        AddImage( 282, 50, $709, 0, 6 );
        AddInputField( 250, 67, 20, 200, '', 0, 1, 0, 6 );

        AddButton( 580, 440, $15A1, $15A3, $15A2, 608, 6 ); //Go Back
        AddButton( 610, 440, $15A4, $15A6, $15A5, 609, 6 ); //Go On

        AddResizeGump( 90, 122, $2436, 150, 310, 0, 6 ); //Left Side
        AddText( 100, 140, 'Hair:', 0, $481, 6 );
        AddButton( 100, 167, $15E2, $15E2, $15E2, 601, 6 );
        HairName := AddText( 118, 165, HairNames[HairSlot], 0, $481, 6 );
        BeardText := AddText( 100, 210, 'Beard:', 0, $481, 6 );
        BeardButton := AddButton( 100, 237, $15E2, $15E2, $15E2, 602, 6 );
        BeardName := AddText( 118, 235, BeardNames[BeardSlot], 0, $481, 6 );

        AddResizeGump( 477, 122, $2436, 150, 310, 0, 6 ); //Right Side
        AddText( 492, 142, 'Skin Tone', 0, $481, 6 );
        ButtonSkin := AddHueButton( 492, 160, 120, 24, Color15ToRed( Hues.GetColor( ColorSkin, 20 ) ), Color15ToGreen( Hues.GetColor( ColorSkin, 20 ) ), Color15ToBlue( Hues.GetColor( ColorSkin, 20 ) ), 603, 6 );
        AddText( 492, 192, 'Shirt Color', 0, $481, 6 );
        ButtonShirt := AddHueButton( 492, 210, 120, 24, Color15ToRed( Hues.GetColor( ColorShirt, 20 ) ), Color15ToGreen( Hues.GetColor( ColorShirt, 20 ) ), Color15ToBlue( Hues.GetColor( ColorShirt, 20 ) ), 604, 6 );
        ColoredSkirtText := AddText( 492, 242, 'Pants Color', 0, $481, 6 );
        ButtonSkirt := AddHueButton( 492, 260, 120, 24, Color15ToRed( Hues.GetColor( ColorSkirt, 20 ) ), Color15ToGreen( Hues.GetColor( ColorSkirt, 20 ) ), Color15ToBlue( Hues.GetColor( ColorSkirt, 20 ) ), 605, 6 );
        AddText( 492, 292, 'Hair Color', 0, $481, 6 );
        ButtonHair := AddHueButton( 492, 310, 120, 24, Color15ToRed( Hues.GetColor( ColorHair, 20 ) ), Color15ToGreen( Hues.GetColor( ColorHair, 20 ) ), Color15ToBlue( Hues.GetColor( ColorHair, 20 ) ), 606, 6 );
        ColoredBeardText := AddText( 492, 342, 'Beard Color', 0, $481, 6 );
        ButtonBeard := AddHueButton( 492, 360, 120, 24, Color15ToRed( Hues.GetColor( ColorBeard, 20 ) ), Color15ToGreen( Hues.GetColor( ColorBeard, 20 ) ), Color15ToBlue( Hues.GetColor( ColorBeard, 20 ) ), 607, 6 );

        Char := AddImage( 240, 95, $761, ColorSkin, 6 ); //Female: $760
        Shirt := AddImage( 240, 95, $739, ColorShirt, 6 ); //Female: $714
        Shoes := AddImage( 240, 95, $762, ColorShoes, 6 ); //Female: $763
        Skirt := AddImage( 240, 95, $738, ColorSkirt, 6 ); //Female: $764
        if HairSlot <> HairCount-1 then begin
                Hair := AddImage( 240, 95, HairGumpIDsMale[HairSlot], ColorHair, 6 );
        end
        else begin
                Hair := AddImage( 240, 95, 0, ColorHair, 6 );
                Hair.Visible := False;
        end;
        if BeardSlot <> BeardCount-1 then begin
                Beard := AddImage( 240, 95, BeardGumpIDs[BeardSlot], ColorBeard, 6 );
        end
        else begin
                Beard := AddImage( 240, 95, 0, ColorBeard, 6 );
                Beard.Visible := False;
        end;
        MaleButton := AddButton( 312, 405, $710, $712, $711, 600, 6 );

        //Choose HairStyle (Page 7)
        PX := -120;
        PY := 50;

        for I := 0 to HairCount-1 do begin
                if (I mod 8) = 0 then begin
                        PX := PX + 250;
                        PY := 50;
                end;
                AddTextButton( PX, PY, 701+I, HairNames[I], 0, 7, 100, $481, 0, 0 );
                Inc( PY, 50 );
        end;

        //Choose BeardStyle (Page 8)
        PX := -120;
        PY := 50;

        for I := 0 to BeardCount-1 do begin
                if (I mod 8) = 0 then begin
                        PX := PX + 250;
                        PY := 50;
                end;
                AddTextButton( PX, PY, 801+I, BeardNames[I], 0, 8, 100, $481, 0, 0 );
                Inc( PY, 50 );
        end;

        //Choose SkinColor (Page 9)
        AddImage( 240, 95, $708, 0, 9 );
        AddResizeGump( 477, 122, $2436, 150, 310, 0, 9 );
        ColoredChar := AddImage( 240, 95, $761, ColorSkin, 9 );
        PX := 497-15;
        PY := 138;

        for I := 0 to 8*7-1 do begin
                if (I mod 8) = 0 then begin
                        PX := PX + 15;
                        PY := 138;
                end;

                Red := Color15toRed( Hues.GetColor( $3EA + I, 20 ) );
                Green := Color15toGreen( Hues.GetColor( $3EA + I, 20 ) );
                Blue := Color15toBlue( Hues.GetColor( $3EA + I, 20 ) );

                AddHueButton( PX, PY, 17, 35, Red, Green, Blue, 900+I, 9 );
                Inc( PY, 35 );
        end;

        //Choose ShirtColor (Page 10)
        AddImage( 240, 95, $708, 0, 10 );
        AddResizeGump( 477, 122, $2436, 150, 310, 0, 10 );
        ColoredShirt := AddImage( 240, 95, $739, ColorShirt, 10 );

        PY := 138-5;

        for I := 0 to 46 do begin
                PY := PY + 5;
                PX := 490;

                Case ((I+1) mod 4) of
                        0 : Color := 102 + (I div 4);
                        1 : Color := 202 + (I div 4);
                        2 : Color := 402 + (I div 4);
                        3 : Color := 802 + (I div 4);
                else
                        Color := 0;
                end;

                for J := 0 to 19 do begin
                        Red := Color15toRed( Hues.GetColor( Color, 20 ) );
                        Green := Color15toGreen( Hues.GetColor( Color, 20 ) );
                        Blue := Color15toBlue( Hues.GetColor( Color, 20 ) );

                        AddHueButton( PX, PY, 6, 5, Red, Green, Blue, 1000+Color, 10 );
                        Inc( PX, 6 );
                        Inc( Color, 5 );
                end;
        end;

        //Choose SkirtColor (Page 11)
        AddImage( 240, 95, $708, 0, 11 );
        AddResizeGump( 477, 122, $2436, 150, 310, 0, 11 );
        ColoredSkirt := AddImage( 240, 95, $738, ColorSkirt, 11 );

        PY := 138-5;

        for I := 0 to 46 do begin
                PY := PY + 5;
                PX := 490;

                Case ((I+1) mod 4) of
                        0 : Color := 102 + (I div 4);
                        1 : Color := 202 + (I div 4);
                        2 : Color := 402 + (I div 4);
                        3 : Color := 802 + (I div 4);
                end;

                for J := 0 to 19 do begin
                        Red := Color15toRed( Hues.GetColor( Color, 20 ) );
                        Green := Color15toGreen( Hues.GetColor( Color, 20 ) );
                        Blue := Color15toBlue( Hues.GetColor( Color, 20 ) );

                        AddHueButton( PX, PY, 6, 5, Red, Green, Blue, 2000+Color, 11 );
                        Inc( PX, 6 );
                        Inc( Color, 5 );
                end;
        end;

        //Choose HairColor (Page 12)
        AddImage( 240, 95, $708, 0, 12 );
        AddResizeGump( 477, 122, $2436, 150, 310, 0, 12 );
        ColoredHair := AddImage( 240, 95, HairGumpIDsMale[HairSlot], ColorHair, 12 );
        if HairSlot = HairCount-1 then
                ColoredHair.Visible := False;

        PX := 495-20;
        PY := 138;

        for I := 0 to 8*6-1 do begin
                if (I mod 8) = 0 then begin
                        PX := PX + 20;
                        PY := 138;
                end;

                Red := Color15toRed( Hues.GetColor( $44E + I, 20 ) );
                Green := Color15toGreen( Hues.GetColor( $44E + I, 20 ) );
                Blue := Color15toBlue( Hues.GetColor( $44E + I, 20 ) );

                AddHueButton( PX, PY, 20, 35, Red, Green, Blue, 3000+I, 12 );
                Inc( PY, 35 );
        end;

        //Choose BeardColor (Page 13)
        AddImage( 240, 95, $708, 0, 13 );
        AddResizeGump( 477, 122, $2436, 150, 310, 0, 13 );
        ColoredBeard := AddImage( 240, 95, BeardGumpIDs[BeardSlot], ColorBeard, 13 );
        if BeardSlot = BeardCount-1 then
                ColoredBeard.Visible := False;

        PX := 495-20;
        PY := 138;

        for I := 0 to 8*6-1 do begin
                if (I mod 8) = 0 then begin
                        PX := PX + 20;
                        PY := 138;
                end;

                Red := Color15toRed( Hues.GetColor( $44E + I, 20 ) );
                Green := Color15toGreen( Hues.GetColor( $44E + I, 20 ) );
                Blue := Color15toBlue( Hues.GetColor( $44E + I, 20 ) );

                AddHueButton( PX, PY, 20, 35, Red, Green, Blue, 3100+I, 13 );
                Inc( PY, 35 );
        end;

        //Corrupt Name (Page 14)
        AddResizeGump( 200, 150, $A28, 300, 200, 0, 14 );
        AddText( 240, 180, 'Name is too short.', 0, $481, 14 );
        AddButton( 340, 300, $47E, $480, $47F, 3200, 14 );

        //Starting Locations (Page 15)
        AddButton( 580, 440, $15A1, $15A3, $15A2, 3300, 15 ); //Go Back

        //Too much Chars (Page 16)
        AddResizeGump( 200, 150, $A28, 300, 200, 0, 16 );
        QuestionChars := AddText( 240, 180, Format( 'You already have %d Chars.', [MaxChars] ), 0, $481, 16 );
        AddButton( 340, 300, $47E, $480, $47F, 3400, 16 );
end;

destructor TCharCreationGump.Free;
begin
        inherited Free;
end;

procedure TCharCreationGump.OnButtonClick( ReturnNumber : Integer );
var     LoginCharacter : TLoginCharacter;
        IPWatch : TIdIPWatch;
        Liste : TStringList;
        IP : LongWord;
        IP1, IP2, IP3, IP4 : LongWord;
        SendDeleteChar : TSendDeleteChar;
begin
        Case ReturnNumber of
                1: begin
                        Log.Write( 'ReturnToLoginGump: Charcreation' );                
                        Palanthir.ReturnToLoginGump;
                        end;
                102: begin
                        if Length( CharSlots ) = 0 then begin
                                ActivePage := 3;
                        end
                        else begin
                                Liste := TStringList.Create;
                                IPWatch := TIdIPWatch.Create( nil );
                                StrLib.Split( IPWatch.LocalIP, '.', Liste );

                                IP1 := StrToInt( Liste.Strings[ 0 ] );
                                IP2 := StrToInt( Liste.Strings[ 1 ] );
                                IP3 := StrToInt( Liste.Strings[ 2 ] );
                                IP4 := StrToInt( Liste.Strings[ 3 ] );

                                IP := ( IP1 shl 24 ) +
                                      ( IP2 shl 16 ) +
                                      ( IP3 shl 8 ) +
                                      IP4;

                                Liste.Free;
                                IPWatch.Free;

                                Palanthir.Name := CharNames[ CurrentChar ];
                                LoginCharacter := TLoginCharacter.Create;
                                LoginCharacter.SetSlot( CharSlots[CurrentChar] );
                                LoginCharacter.SetCharName( CharNames[ CurrentChar ] );
                                LoginCharacter.SetClientIP( IP );
                                Palanthir.NetClient.Send( LoginCharacter );

                                Palanthir.DeleteGump( Self );
                        end;
                        end;
                103..108: begin
                        CharButtons[ CurrentChar ].BackUpId := 0;
                        CharButtons[ CurrentChar ].BackDownId := 0;
                        CharButtons[ CurrentChar ].BackMoveOverId := 0;
                        CharButtons[ CurrentChar ].BackUpHue := 0;
                        CharButtons[ CurrentChar ].BackDownHue := 0;
                        CharButtons[ CurrentChar ].BackMoveOverHue := 0;

                        CurrentChar := ReturnNumber-103;
                        CharButtons[ CurrentChar ].BackUpId := $BB8;
                        CharButtons[ CurrentChar ].BackDownId := $BB8;
                        CharButtons[ CurrentChar ].BackMoveOverId := $BB8;
                        CharButtons[ CurrentChar ].BackUpHue := $481;
                        CharButtons[ CurrentChar ].BackDownHue := $481;
                        CharButtons[ CurrentChar ].BackMoveOverHue := $481;
                        end;
                110 : begin
                        if Length( CharSlots ) = MaxChars then begin
                                QuestionChars.Text := Format( 'You already have %d Chars.', [MaxChars] );
                                ActivePage := 16;
                        end
                        else begin
                                ActivePage := 3;
                        end;
                end;
                111 : begin
                        ActivePage := 2;
                        QuestionDelete.Text := Format( 'Permanently Delete %s?', [CharNames[CurrentChar]] );
                end;
                201 : begin
                        Liste := TStringList.Create;
                        IPWatch := TIdIPWatch.Create( nil );
                        StrLib.Split( IPWatch.LocalIP, '.', Liste );

                        IP1 := StrToInt( Liste.Strings[ 0 ] );
                        IP2 := StrToInt( Liste.Strings[ 1 ] );
                        IP3 := StrToInt( Liste.Strings[ 2 ] );
                        IP4 := StrToInt( Liste.Strings[ 3 ] );

                        IP := ( IP1 shl 24 ) +
                              ( IP2 shl 16 ) +
                              ( IP3 shl 8 ) +
                              IP4;

                        Liste.Free;
                        IPWatch.Free;

                        SendDeleteChar := TSendDeleteChar.Create;
                        SendDeleteChar.SetPassword( Passwords[CurrentChar] );
                        SendDeleteChar.SetCharIndex( CharSlots[CurrentChar] );
                        SendDeleteChar.SetClientIP( IP );
                        Palanthir.SendPacket( SendDeleteChar );

                        ActivePage := 1;
                end;
                202 : begin
                        ActivePage := 1;
                end;
                305 : begin
                        if (not SkillsChosen[0]) or (not SkillsChosen[1]) or (not SkillsChosen[2]) then begin
                                QuestionSkillStat.Text := 'Choose your Skills first.';
                                ActivePage := 5;
                        end
                        else if StrToInt( StatStr.Text ) + StrToInt( StatDex.Text ) + StrToInt( StatInt.Text ) <> MaxStats then begin
                                QuestionSkillStat.Text := 'Your Statvalues do not fit.';
                                ActivePage := 5;
                        end
                        else if StrToInt( Skill1.Text ) + StrToInt( Skill2.Text ) + StrToInt( Skill3.Text ) <> MaxSkills then begin
                                QuestionSkillStat.Text := 'Your Skillvalues do not fit.';                        
                                ActivePage := 5;
                        end
                        else begin
                                ActivePage := 6;
                        end;
                end;
                306 : begin
                        ActivePage := 1;
                end;
                307 : begin
                        SelectedSkillSlot := 0;
                        ActivePage := 4;
                end;
                308 : begin
                        SelectedSkillSlot := 1;
                        ActivePage := 4;
                end;
                309 : begin
                        SelectedSkillSlot := 2;
                        ActivePage := 4;
                end;
                400 : begin
                        ActivePage := 3;
                end;
                401..401+SkillCount : begin
                        Case SelectedSkillSlot of
                                0 : begin
                                        if (Skills[1] <> ReturnNumber-401) and (Skills[2] <> ReturnNumber-401) then begin
                                                SkillsChosen[SelectedSkillSlot] := True;
                                                Skills[SelectedSkillSlot] := ReturnNumber-401;
                                                SkillName1.Text := SkillNames[ReturnNumber-401];
                                                ActivePage := 3;                                                
                                        end
                                        else begin
                                                QuestionSkillStat.Text := 'Choose each Skill only once.';
                                                ActivePage := 5;
                                        end;
                                end;
                                1 : begin
                                        if (Skills[0] <> ReturnNumber-401) and (Skills[2] <> ReturnNumber-401) then begin
                                                SkillsChosen[SelectedSkillSlot] := True;
                                                Skills[SelectedSkillSlot] := ReturnNumber-401;
                                                SkillName2.Text := SkillNames[ReturnNumber-401];
                                                ActivePage := 3;
                                        end
                                        else begin
                                                QuestionSkillStat.Text := 'Choose each Skill only once.';
                                                ActivePage := 5;
                                        end;
                                end;
                                2 : begin
                                        if (Skills[0] <> ReturnNumber-401) and (Skills[1] <> ReturnNumber-401) then begin
                                                SkillsChosen[SelectedSkillSlot] := True;
                                                Skills[SelectedSkillSlot] := ReturnNumber-401;
                                                SkillName3.Text := SkillNames[ReturnNumber-401];
                                                ActivePage := 3;
                                        end
                                        else begin
                                                QuestionSkillStat.Text := 'Choose each Skill only once.';
                                                ActivePage := 5;
                                        end;
                                end;
                        end;
                end;
                500 : begin
                        ActivePage := 3;
                end;
                600 : begin
                        if Male then begin
                                if HairSlot <> HairCount-1 then begin
                                        Hair.Id := HairGumpIDsFemale[HairSlot];
                                        ColoredHair.Id := HairGumpIDsFemale[HairSlot];
                                end;

                                Beard.Visible := False;
                                BeardText.Visible := False;
                                BeardButton.Visible := False;
                                BeardName.Visible := False;

                                ColoredBeardText.Visible := False;
                                ColoredBeard.Visible := False;
                                ButtonBeard.Visible := False;

                                Char.Id := $760;
                                ColoredChar.Id := $760;
                                Shirt.Id := $714;
                                ColoredShirt.Id := $714;
                                Skirt.Id := $764;
                                ColoredSkirt.Id := $764;
                                ColoredSkirtText.Text := 'Skirt Color';
                                Shoes.Id := $763;
                                MaleButton.UpId := $70D;
                                MaleButton.DownId := $70F;
                                MaleButton.MoveOverId := $70E;
                                Male := False;
                        end
                        else begin
                                if HairSlot <> HairCount-1 then begin
                                        Hair.Id := HairGumpIDsMale[HairSlot];
                                        ColoredHair.Id := HairGumpIDsMale[HairSlot];
                                end;

                                if BeardSlot <> BeardCount-1 then
                                        Beard.Visible := True;
                                BeardText.Visible := True;
                                BeardButton.Visible := True;
                                BeardName.Visible := True;

                                if BeardSlot <> BeardCount-1 then begin
                                        ColoredBeardText.Visible := True;
                                        ColoredBeard.Visible := True;
                                        ButtonBeard.Visible := True;
                                end;

                                Char.Id := $761;
                                ColoredChar.Id := $761;
                                Shirt.Id := $739;
                                ColoredShirt.Id := $739;
                                Skirt.Id := $738;
                                ColoredSkirt.Id := $738;
                                ColoredSkirtText.Text := 'Pants Color';                                
                                Shoes.Id := $762;
                                MaleButton.UpId := $710;
                                MaleButton.DownId := $712;
                                MaleButton.MoveOverId := $711;
                                Male := True;
                        end;
                end;
                601 : begin
                        ActivePage := 7;
                end;
                602 : begin
                        ActivePage := 8;
                end;
                603 : begin
                        ActivePage := 9;
                end;
                604 : begin
                        ActivePage := 10;
                end;
                605 : begin
                        ActivePage := 11;
                end;
                606 : begin
                        ActivePage := 12;
                end;
                607 : begin
                        ActivePage := 13;
                end;
                608 : begin
                        ActivePage := 3;
                end;
                609 : begin
                        if Length( GetInputText( 1 ) ) < 3 then begin
                                ActivePage := 14;
                        end
                        else if Length( LocCities ) < 2 then begin
                                SendCharCreationPacket;
                                Palanthir.DeleteGump( Self );
                        end
                        else begin
                                ActivePage := 15;
                        end;
                end;
                701..701+HairCount-1 : begin
                        HairSlot := ReturnNumber - 701;
                        if HairSlot <> HairCount-1 then begin
                                if Male then
                                        Hair.Id := HairGumpIDsMale[HairSlot]
                                else
                                        Hair.Id := HairGumpIDsFemale[HairSlot];
                                Hair.Visible := True;

                                if Male then
                                        ColoredHair.Id := HairGumpIDsMale[HairSlot]
                                else
                                        ColoredHair.Id := HairGumpIDsFemale[HairSlot];
                                ColoredHair.Visible := True;
                        end
                        else begin
                                Hair.Visible := False;
                                ColoredHair.Visible := False;
                        end;
                        HairName.Text := HairNames[HairSlot];

                        ActivePage := 6;
                end;
                801..801+BeardCount-1 : begin
                        BeardSlot := ReturnNumber - 801;
                        if BeardSlot <> BeardCount-1 then begin
                                Beard.Id := BeardGumpIDs[BeardSlot];

                                if Male then
                                        Beard.Visible := True;

                                ColoredBeard.Id := BeardGumpIDs[BeardSlot];

                                if Male then begin
                                        ColoredBeardText.Visible := True;
                                        ColoredBeard.Visible := True;
                                        ButtonBeard.Visible := True;
                                end;
                        end
                        else begin
                                Beard.Visible := False;
                                ColoredBeard.Visible := False;
                        end;
                        BeardName.Text := BeardNames[BeardSlot];

                        ActivePage := 6;
                end;
                900..955 : begin
                        ColorSkin := $3EA + ReturnNumber - 900;

                        Char.Hue := ColorSkin;
                        ColoredChar.Hue := ColorSkin;
                        ButtonSkin.SetColor( ColorSkin );

                        ActivePage := 6;
                end;
                1000..1999 : begin
                        ColorShirt := ReturnNumber - 1000;

                        Shirt.Hue := ColorShirt;
                        ColoredShirt.Hue := ColorShirt;
                        ButtonShirt.SetColor( ColorShirt );

                        ActivePage := 6;
                end;
                2000..2999 : begin
                        ColorSkirt := ReturnNumber - 2000;

                        Skirt.Hue := ColorSkirt;
                        ColoredSkirt.Hue := ColorSkirt;
                        ButtonSkirt.SetColor( ColorSkirt );

                        ActivePage := 6;
                end;
                3000..3047 : begin
                        ColorHair := $44E + ReturnNumber - 3000;

                        Hair.Hue := ColorHair;
                        ColoredHair.Hue := ColorHair;
                        ButtonHair.SetColor( ColorHair );

                        ActivePage := 6;
                end;
                3100..3147 : begin
                        ColorBeard := $44E + ReturnNumber - 3100;

                        Beard.Hue := ColorBeard;
                        ColoredBeard.Hue := ColorBeard;
                        ButtonBeard.SetColor( ColorBeard );

                        ActivePage := 6;
                end;
                3200 : begin
                        ActivePage := 6;
                end;
                3300 : begin
                        ActivePage := 6;
                end;
                3301..3350 : begin
                        LocationSlot := ReturnNumber - 3301;
                        SendCharCreationPacket;
                        Palanthir.DeleteGump( Self );
                end;
                3400 : begin
                        ActivePage := 1;
                end;
        end;
end;

procedure TCharCreationGump.OnMoveOverButton( ReturnNumber : Integer );
begin
        Case ReturnNumber of
                900..955 : begin
                        ColoredChar.Hue := $3EA + ReturnNumber - 900;
                end;
                1000..1999 : begin
                        ColoredShirt.Hue := ReturnNumber - 1000;
                end;
                2000..2999 : begin
                        ColoredSkirt.Hue := ReturnNumber - 2000;
                end;
                3000..3047 : begin
                        ColoredHair.Hue := $44E + ReturnNumber - 3000;
                end;
                3100..3147 : begin
                        ColoredBeard.Hue := $44E + ReturnNumber - 3100;
                end;
        end;
end;

procedure TCharCreationGump.OnScrollBar( GumpObject : TGumpObject );
begin
        Case TScrollBar( GumpObject ).Number of
                301: StatStr.Text := Format( '%d', [10+Round(TScrollBar( GumpObject ).Promille/20)] );
                302: StatDex.Text := Format( '%d', [10+Round(TScrollBar( GumpObject ).Promille/20)] );
                303: StatInt.Text := Format( '%d', [10+Round(TScrollBar( GumpObject ).Promille/20)] );
                304: Skill1.Text := Format( '%d', [Round(TScrollBar( GumpObject ).Promille/20)] );
                305: Skill2.Text := Format( '%d', [Round(TScrollBar( GumpObject ).Promille/20)] );
                306: Skill3.Text := Format( '%d', [Round(TScrollBar( GumpObject ).Promille/20)] );
        end;
        StatAll.Text := Format( '%d / %d', [StrToInt( StatStr.Text ) + StrToInt( StatDex.Text ) + StrToInt( StatInt.Text ),MaxStats] );
        SkillAll.Text := Format( '%d / %d', [StrToInt( Skill1.Text ) + StrToInt( Skill2.Text ) + StrToInt( Skill3.Text ),MaxSkills] );
end;

procedure TCharCreationGump.OnDblClick( GumpObject : TGumpObject );
var     LoginCharacter : TLoginCharacter;
        IPWatch : TIdIPWatch;
        Liste : TStringList;
        IP : LongWord;
begin
        if (GumpObject.Typ = gt_TextButton) then begin
                Case TTextButton( GumpObject ).ReturnNumber of
                        103..108: begin
                                Liste := TStringList.Create;
                                IPWatch := TIdIPWatch.Create( nil );
                                StrLib.Split( IPWatch.LocalIP, '.', Liste );
                                IP := ( StrToInt( Liste.Strings[ 0 ] ) shl 24 ) +
                                      ( StrToInt( Liste.Strings[ 1 ] ) shl 16 ) +
                                      ( StrToInt( Liste.Strings[ 2 ] ) shl 8 ) +
                                      StrToInt( Liste.Strings[ 3 ] );
                                Liste.Free;
                                IPWatch.Free;

                                Palanthir.Name := TTextButton( GumpObject ).Text;
                                LoginCharacter := TLoginCharacter.Create;
                                LoginCharacter.SetSlot( CharSlots[TTextButton( GumpObject ).ReturnNumber - 103] );
                                LoginCharacter.SetCharName( TTextButton( GumpObject ).Text );
                                LoginCharacter.SetClientIP( IP );
                                Palanthir.NetClient.Send( LoginCharacter );

                                Palanthir.DeleteGump( Self );
                        end;
                end;
        end;
end;

function TCharCreationGump.OnKeyReturn( GumpObject : TGumpObject ) : Boolean;
begin
        if Self.ActivePage = 1 then begin
                OnButtonClick( 102 );
                Result := True;
        end
        else begin
                Result := False;
        end;
end;

procedure TCharCreationGump.SendCharCreationPacket;
var     CreateChar : TCreateChar;
        IPWatch : TIdIPWatch;
        Liste : TStringList;
        IP : LongWord;
        J : Integer;
        Erlaubt : Boolean;
        Slot : Word;
begin
        Liste := TStringList.Create;
        IPWatch := TIdIPWatch.Create( nil );
        StrLib.Split( IPWatch.LocalIP, '.', Liste );
        IP := ( StrToInt( Liste.Strings[ 0 ] ) shl 24 ) +
              ( StrToInt( Liste.Strings[ 1 ] ) shl 16 ) +
              ( StrToInt( Liste.Strings[ 2 ] ) shl 8 ) +
              StrToInt( Liste.Strings[ 3 ] );
        Liste.Free;
        IPWatch.Free;

        for Slot := 0 to MaxChars-1 do begin
                Erlaubt := True;
                for J := 0 to Length( CharSlots )-1 do begin
                        if CharSlots[J] = Slot then begin
                                Erlaubt := False;
                                break;
                        end;
                end;

                if Erlaubt then
                        break;
        end;

        if not Erlaubt then begin
                QuestionChars.Text :=  Format( 'You already have %d Chars.', [MaxChars] );
                ActivePage := 16;
                exit;
        end;

        CreateChar := TCreateChar.Create;
        CreateChar.SetCharName( GetInputText( 1 ) );
        CreateChar.SetPassword( '' );
        if Male then
                CreateChar.SetSex( 0 )
        else
                CreateChar.SetSex( 1 );
        CreateChar.SetStr( StrToInt( StatStr.Text ) );
        CreateChar.SetDex( StrToInt( StatDex.Text ) );
        CreateChar.SetInt( StrToInt( StatInt.Text ) );
        CreateChar.SetSkill1( Skills[0] );
        CreateChar.SetSkill1Value( StrToInt( Skill1.Text ) );
        CreateChar.SetSkill2( Skills[1] );
        CreateChar.SetSkill2Value( StrToInt( Skill2.Text ) );
        CreateChar.SetSkill3( Skills[2] );
        CreateChar.SetSkill3Value( StrToInt( Skill3.Text ) );
        CreateChar.SetSkinColor( ColorSkin );
        if HairSlot <> HairCount-1 then begin
                CreateChar.SetHairStyle( HairIDs[HairSlot] );
        end
        else begin
                CreateChar.SetHairStyle( 0 );
        end;
        CreateChar.SetHairColor( ColorHair );
        if BeardSlot <> BeardCount-1 then begin
                CreateChar.SetFacialHairStyle( BeardIDs[BeardSlot] );
        end
        else begin
                CreateChar.SetFacialHairStyle( 0 );
        end;
        CreateChar.SetFacialHairColor( ColorBeard );
        CreateChar.SetLocation( LocationSlot );
        CreateChar.SetSlot( Slot );
        CreateChar.SetClientIP( IP );
        CreateChar.SetShirtColor( ColorShirt );
        CreateChar.SetSkirtColor( ColorSkirt );

        Palanthir.SendPacket( CreateChar );        
end;

end.
 