unit uCustomGumps;

interface

uses    uGumps, Dialogs, SysUtils, uSendPackets, Classes, Math, StrLib,
        uClient, uLog, uUtilities, uRecievePackets, uCounter, uTexCache,
        uRenderer, uTimer, uLoaderHues, uLoaderTiledata, dglOpenGL;

type    TDisconnectConfirm = Class( TGump )
                public
                        constructor Create; reintroduce;
                        procedure OnButtonClick( ReturnNumber : Integer ); override;
        end;

        TGameWindow = Class( TGump )
                public
                        MX, MY : Integer;
                        destructor Free; override;
                        function OnMove( GumpObject : TGumpObject ) : Boolean; override;
        end;

        TDisconnectMessageGump = Class( TGump )
                public
                        constructor Create( Text : String ); reintroduce;
                        procedure OnButtonClick( ReturnNumber : Integer ); override;
        end;

        TDynamicGump = Class( TGump )
                public
                        Serial : LongWord;
                        procedure OnButtonClick( ReturnNumber : Integer ); override;
        end;

        TClientStatus = Class( TGump )
                public
                        procedure Init;
        end;

        TInvisListStatus = Class( TGump )
                public
                        procedure Init;
                        procedure OnButtonClick( ReturnNumber : Integer ); override;
        end;

        TTimerGump = Class( TGump )
                public
                        procedure Init;
        end;

        TDyeGump = Class( TGump )
                public
                        Serial : LongWord;
                        HueList : TList;
                        Image : TTilePic;
                        constructor Create( Serial : LongWord; Model : Word ); reintroduce;
                        destructor Free; override;
                        procedure OnMoveOverButton( ReturnNumber : Integer ); override;
                        procedure OnButtonClick( ReturnNumber : Integer ); override;
                        procedure OnScrollBar( GumpObject : TGumpObject ); override;
        end;

        TAboutGump = Class( TGump )
                public
                        constructor Create; override;
        end;

        TMapInfoGump = Class( TGump )
                public
                        constructor Create( Id : Word; PX, PY, PZ : Integer; Z2, Z3, Z4 : Integer ); reintroduce;
        end;

        TStaticInfoGump = Class( TGump )
                public
                        constructor Create( Id, Hue : Word; PX, PY, PZ : Integer ); reintroduce;
        end;

        TDirectionArrowGump = Class( TGump )
                private
                        X, Y : Word;
                        Phi : Real;
                        Texture : TTexObject;
                        StartTimer, UpdateTimer : LongWord;
                        procedure UpdatePhi;
                public
                        constructor Create( X, Y : Word ); reintroduce;
                        destructor Free; override;
                        function Draw : Boolean; override;
        end;

implementation

uses    uPalanthir;

constructor TDisconnectConfirm.Create;
begin
        inherited Create;

        if Palanthir.EnabledME then begin
                AddImage( 0, 0, $816, 0, 0 );
                AddButton( 25, 74, $22E, $22D, $22E, 0, 0 );
                AddButton( 109, 74, $75, $74, $75, 1, 0 );
                AddText( 35, 27, 'Quit', 0, $481, 0 );
                AddText( 35, 42, 'Ultima Online?', 0, $481, 0 );
        end
        else begin
                AddImage( 0, 0, $816, 0, 0 );
                AddButton( 36, 78, $817, $818, $819, 0, 0 );
                AddButton( 99, 78, $81A, $81B, $81C, 1, 0 );
                AddText( 35, 27, 'Quit', 0, 0, 0 );
                AddText( 35, 42, 'Ultima Online?', 0, 0, 0 );
        end;
end;

procedure TDisconnectConfirm.OnButtonClick( ReturnNumber : Integer );
begin
        Case ReturnNumber of
                1 : begin
                        Palanthir.NetClient.Disconnect;
                        exit;
                end;
        end;
        inherited OnButtonClick( ReturnNumber );
end;

destructor TGameWindow.Free;
begin
        Palanthir.Player.CharConfig.SetInteger( 'GameWindowX', X );
        Palanthir.Player.CharConfig.SetInteger( 'GameWindowY', Y );

        inherited Free;
end;

function TGameWindow.OnMove( GumpObject : TGumpObject ) : Boolean;
var     I : Integer;
        Gefunden : Boolean;
        NewX, NewY : Integer;
begin
        Gefunden := False;
        for I := 0 to 3 do
                if GetObject( I ) = GumpObject then begin
                        Gefunden := True;
                        break;
                end;

        if not Gefunden then begin
                Result := False;
                exit;
        end;

        NewX := X - ( Palanthir.Maus.MX - Palanthir.Maus.AktX );
        NewY := Y - ( Palanthir.Maus.MY - Palanthir.Maus.AktY );

        if (NewY < 0) or (NewX < 0) or (NewY + Hoehe > Palanthir.GetWindowHoehe) or (NewX + Breite > Palanthir.GetWindowBreite) then begin
                Result := False;
                exit;
        end;
        {TTiledImage( ObjektListe.Items[ 4 ] ).X := -X;
        TTiledImage( ObjektListe.Items[ 4 ] ).Y := -Y;
        TTiledImage( ObjektListe.Items[ 4 ] ).Hoehe := Y;
        TTiledImage( ObjektListe.Items[ 4 ] ).Breite := Palanthir.GetWindowBreite - Max( Palanthir.GetWindowBreite - X - Breite, 0 );

        TTiledImage( ObjektListe.Items[ 5 ] ).X := -X;
        TTiledImage( ObjektListe.Items[ 5 ] ).Y := Max( 0, Y )-Y;
        TTiledImage( ObjektListe.Items[ 5 ] ).Hoehe := Palanthir.GetWindowHoehe - Max( 0, Y );
        TTiledImage( ObjektListe.Items[ 5 ] ).Breite := X;

        TTiledImage( ObjektListe.Items[ 6 ] ).X := Max( 0, -X );
        TTiledImage( ObjektListe.Items[ 6 ] ).Y := Hoehe;
        TTiledImage( ObjektListe.Items[ 6 ] ).Hoehe := Palanthir.GetWindowHoehe - Hoehe - Y;
        TTiledImage( ObjektListe.Items[ 6 ] ).Breite := Palanthir.GetWindowBreite - Max( 0, X );

        TTiledImage( ObjektListe.Items[ 7 ] ).X := Breite;
        TTiledImage( ObjektListe.Items[ 7 ] ).Y := Min( -Y, 0 );
        TTiledImage( ObjektListe.Items[ 7 ] ).Hoehe := Hoehe + Max( 0, Y );
        TTiledImage( ObjektListe.Items[ 7 ] ).Breite := Palanthir.GetWindowBreite - Min( 0, X ) - Breite;}

        MX := X + Breite div 2;
        MY := Y + Hoehe div 2;
        Result := True;
end;

procedure TDynamicGump.OnButtonClick( ReturnNumber : Integer );
var     Reply : TGumpMenuReply;
        Count, SaveLength : Word;
        I : Integer;
        InputField : TInputField;
        TextLength : Word;
begin
        if ClearTick < $FFFFFFFF then
                exit;

        Reply := TGumpMenuReply.Create;
        Reply.SetSerial( Serial );
        Reply.SetType( Typ );
        Reply.SetReturnNumber( ReturnNumber );

        Count := 0;
        for I := 0 to GetObjectCount-1 do begin
                if GetObject( I ).Typ = gt_Checkbox then begin
                        if TCheckBox( GetObject( I ) ).Checked then begin
                                Reply.SetLength( Reply.getLength+4 );
                                Reply.SetLongWord( Reply.getLength-4, TCheckBox( GetObject( I ) ).ReturnNumber );
                                Inc( Count );
                        end;
                end
                else if TGumpObject( GetObject( I ) ).Typ = gt_RadioButton then begin
                        if TRadioButton( GetObject( I ) ).Checked then begin
                                Reply.SetLength( Reply.getLength+4 );
                                Reply.SetLongWord( Reply.getLength-4, TRadioButton( GetObject( I ) ).ReturnNumber );
                                Inc( Count );
                        end;
                end;
        end;
        Reply.SetLongWord( 15, Count );

        SaveLength := Reply.getLength;
        Reply.SetLength( Reply.getLength+4 );
        Count := 0;
        for I := 0 to GetObjectCount-1 do begin
                if TGumpObject( GetObject( I ) ).Typ = gt_InputField then begin
                        InputField := TInputField( GetObject( I ) );
                        TextLength := Length( InputField.Text );
                        Reply.SetLength( Reply.getLength+4 );
                        Reply.SetWord( Reply.getLength-4, InputField.TextId );
                        Reply.SetWord( Reply.getLength-2, TextLength );
                        Reply.SetLength( Reply.getLength + TextLength*2 );
                        Reply.SetUnicodeString( InputField.Text, Reply.getLength - TextLength*2, TextLength );
                        Inc( Count );
                end;
        end;
        Reply.SetLongWord( SaveLength, Count );
        Reply.SetWord( 1, Reply.getLength );
        Palanthir.NetClient.Send( Reply );

        if not noAutoClose then
                Palanthir.RemoveGump( Self );
end;

procedure TClientStatus.Init;
var     I, PY, Page : Integer;
begin
        Counter.Update;

        Log.Write( 'Counter:' );

        AddResizeGump( 0, 0, $BB8, 200, 300, 0, 0 );

        Page := 0;
        PY := 20;

        for I := 0 to Counter.GetTypeCount-1 do begin
                if I mod 8 = 0 then begin
                        if Page <> 0 then
                                AddPageButton( 70, 270, $15A4, $15A6, Page+1, Page );

                        Inc( Page );
                        if Page <> 1 then
                                AddPageButton( 30, 270, $15A1, $15A3, Page-1, Page ); 

                        PY := 20;
                end;

                AddText( 20, PY, Format( '%d %s', [Counter.GetCount( I ),Counter.GetName( I )] ), 0, 0, Page );
                Inc( PY, 30 );

                Log.Write( Format( '%d %s', [Counter.GetCount( I ),Counter.GetName( I )] ) );
        end;
end;

procedure TInvisListStatus.Init;
var     I, PY, Page : Integer;
begin
        AddResizeGump( 0, 0, $BB8, 200, 300, 0, 0 );
        AddText( 20, 10, 'Invislist', 0, 0, 0 );

        Page := 0;
        PY := 60;

        for I := 0 to Palanthir.GetInvisListCount-1 do begin
                if I mod 4 = 0 then begin
                        if Page <> 0 then
                                AddPageButton( 70, 270, $15A4, $15A6, Page+1, Page );

                        Inc( Page );
                        if Page <> 1 then
                                AddPageButton( 30, 270, $15A1, $15A3, Page-1, Page ); 

                        PY := 60;
                end;

                AddButton( 20, PY, $93A, $93A, I+1, Page );
                AddText( 40, PY-5, Palanthir.Data.Tiledata.GetStaticName( Palanthir.GetInvisListId( I ) ), 0, 0, Page );
                AddTilePic( 140, PY-22, Palanthir.GetInvisListId( I ), 0, Page );

                Inc( PY, 60 );
        end;
end;


procedure TInvisListStatus.OnButtonClick( ReturnNumber : Integer );
var     InvisListStatus : TInvisListStatus;
begin
        if ReturnNumber = 0 then begin
                Inherited OnButtonClick( ReturnNumber );
        end
        else begin
                Palanthir.RemoveFromInvisListByNumber( ReturnNumber-1 );
                InvisListStatus := TInvisListStatus.Create;
                InvisListStatus.Init;
                InvisListStatus.X := X;
                InvisListStatus.Y := Y;
                Palanthir.AddGump( InvisListStatus );

                Palanthir.DeleteGump( Self );
        end;
end;

procedure TTimerGump.Init;
var     I, Y, Page : Integer;
begin
        AddResizeGump( 0, 0, $BB8, 250, 300, 0, 0 );

        Page := 0;
        Y := 20;

        for I := 0 to Timer_Count-1 do begin
                if I mod 8 = 0 then begin
                        if Page <> 0 then
                                AddPageButton( 70, 270, $15A4, $15A6, Page+1, Page );

                        Inc( Page );
                        if Page <> 1 then
                                AddPageButton( 30, 270, $15A1, $15A3, Page-1, Page ); 

                        Y := 20;
                end;

                AddText( 20, Y, Format( '%-10s  %4.2f', [TimerNames[ I ],Timer.GetMeanTime( I )] ) , 0, 0, Page );
                Inc( Y, 30 );
        end;
end;

constructor TDyeGump.Create( Serial : LongWord; Model : Word );
var     I, J, PX, PY : Integer;
        HueButton : THueButton;
        Color : Word;
        ScrollBar : TScrollBar;
        Red, Green, Blue : Byte;
begin
        inherited Create;

        HueList := TList.Create;
        Self.Serial := Serial;

        AddImage( 0, 0, $906, 0, 0 );
        AddButton( 207, 138, $907, $908, $909, 1, 0 );
        ScrollBar := AddScrollBar( 35, 142, True, 155, $845, $846, 2, 0 );
        ScrollBar.Promille := Round( 1000*20/32 );
        Image := AddTilePic( 210, 64, Model, 0, 0 );

        PX := 34;
        PY := 34;
        Color := 3;

        for I := 0 to 9 do begin
                for J := 0 to 19 do begin
                        Red := Color15toRed( Hues.GetColor( Color, 20 ) );
                        Green := Color15toGreen( Hues.GetColor( Color, 20 ) );
                        Blue := Color15toBlue( Hues.GetColor( Color, 20 ) );

                        HueButton := AddHueButton( PX, PY, 8, 8, Red, Green, Blue, 1000+Color, 0 );
                        HueList.Add( HueButton );
                        Inc( PX, 8 );
                        Inc( Color, 5 );
                end;
                PX := 34;
                Inc( PY, 8 );
        end;
end;

destructor TDyeGump.Free;
begin
        HueList.Free;
        inherited Free;
end;

procedure TDyeGump.OnMoveOverButton( ReturnNumber : Integer );
begin
        //Die Funktion brauchts hier wahrscheinlich doch net...
end;

procedure TDyeGump.OnButtonClick( ReturnNumber : Integer );
var     SendDyeRequest : TSendDyeRequest;
begin
        Case ReturnNumber of
                0 : begin
                        inherited OnButtonClick( ReturnNumber );
                end;
                1 : begin
                        SendDyeRequest := TSendDyeRequest.Create;
                        SendDyeRequest.SetSerial( Serial );
                        SendDyeRequest.SetModel( Image.Id );
                        SendDyeRequest.SetColor( Image.Hue );
                        Palanthir.SendPacket( SendDyeRequest );
                        Palanthir.DeleteGump( Self );
                end;
                1000..1999: Image.Hue := ReturnNumber - 1000;
        end;
end;

procedure TDyeGump.OnScrollBar( GumpObject : TGumpObject );
var     SubColor : Byte;
        I, J : Integer;
        Red, Green, Blue : Byte;
        HueButton : THueButton;
        Color : Word;
begin
        SubColor := Round( TScrollBar( GumpObject ).Promille * 32 / 1000 );

        Color := 3;
        for I := 0 to 9 do begin
                for J := 0 to 19 do begin
                        HueButton := THueButton( HueList.Items[ I*20 + J ] );
                        Red := Color15toRed( Hues.GetColor( Color, SubColor ) );
                        Green := Color15toGreen( Hues.GetColor( Color, SubColor ) );
                        Blue := Color15toBlue( Hues.GetColor( Color, SubColor ) );

                        HueButton.Red := Red;
                        HueButton.Green := Green;
                        HueButton.Blue := Blue;

                        Inc( Color, 5 );
                end;
        end;
end;

constructor TAboutGump.Create;
begin
        inherited Create;

        AddResizeGump( 0, 0, $BB8, 400, 300, 0, 0 );
end;

constructor TMapInfoGump.Create( Id : Word; PX, PY, PZ : Integer; Z2, Z3, Z4 : Integer );
var     Flag : LongWord;
        I, Y : Integer;
        Height : Word;
begin
        inherited Create;

        Flag := 1;
        Height := 140;
        for I := 0 to 31 do begin
                if Palanthir.Data.Tiledata.GetLandFlag( Id, Flag ) then begin
                        Inc( Height, 20 );
                end;
                Flag := Flag shl 1;
        end;

        AddResizeGump( 0, 0, $BB8, 260, Height, 0, 0 );

        AddText( 10, 10, 'Name:', 0, $481, 0 );
        AddText( 60, 10, Format( '%s', [Palanthir.Data.Tiledata.GetLandName( Id )] ), 0, $481, 0 );
        AddText( 10, 40, 'Id:', 0, $481, 0 );
        AddText( 60, 40, Format( '%d', [Id] ), 0, $481, 0 );
        AddText( 10, 70, 'Pos:', 0, $481, 0 );
        AddText( 80, 70, Format( '%d %d %d', [PX,PY,PZ] ), 0, $481, 0 );
        AddText( 10, 100, 'ZLevel:', 0, $481, 0 );
        AddText( 80, 100, Format( '%d %d %d', [Z2,Z3,Z4] ), 0, $481, 0 );
        AddText( 10, 130, 'Flags:', 0, $481, 0 );

        AddLandTilePic( 180, 40, Id, 0, 0 );

        Y := 130;
        Flag := 1;

        for I := 0 to 31 do begin
                if Palanthir.Data.Tiledata.GetLandFlag( Id, Flag ) then begin
                        Addtext( 60, Y, LowerCase( TiledataFlags[ I ] ), 0, $481, 0 );
                        Inc( Y, 20 );
                end;
                Flag := Flag shl 1;
        end;
end;

constructor TStaticInfoGump.Create( Id, Hue : Word; PX, PY, PZ : Integer );
var     Flag : LongWord;
        I, Y : Integer;
        Height : Word;
begin
        inherited Create;

        Flag := 1;
        Height := 290;
        for I := 0 to 31 do begin
                if Palanthir.Data.Tiledata.GetStaticFlag( Id, Flag ) then begin
                        Inc( Height, 20 );
                end;
                Flag := Flag shl 1;
        end;

        AddResizeGump( 0, 0, $BB8, 260, Height, 0, 0 );
        AddCheckerTrans( 2, 2, Height-2, 256, 0 );

        AddText( 10, 10, 'Name:', 0, $481, 0 );
        AddText( 80, 10, Format( '%s', [Palanthir.Data.Tiledata.GetStaticName( Id )] ), 0, $481, 0 );        
        AddText( 10, 40, 'Id:', 0, $481, 0 );
        AddText( 60, 40, Format( '0x%x', [Id] ), 0, $481, 0 );
        AddText( 10, 70, 'Hue:', 0, $481, 0 );
        AddText( 60, 70, Format( '0x%x', [Hue] ), 0, $481, 0 );
        AddText( 10, 100, 'Height:', 0, $481, 0 );
        AddText( 80, 100, Format( '%d', [Palanthir.Data.Tiledata.GetStaticHeight( Id )] ), 0, $481, 0 );
        AddText( 10, 130, 'THue:', 0, $481, 0 );
        AddText( 80, 130, Format( '%d', [Palanthir.Data.Tiledata.GetStaticHue( Id )] ), 0, $481, 0 );
        AddText( 10, 160, 'Quality:', 0, $481, 0 );
        AddText( 80, 160, Format( '%d', [Palanthir.Data.Tiledata.GetStaticQuality( Id )] ), 0, $481, 0 );
        AddText( 10, 190, 'Quantity:', 0, $481, 0 );
        AddText( 80, 190, Format( '%d', [Palanthir.Data.Tiledata.GetStaticQuantity( Id )] ), 0, $481, 0 );
        AddText( 10, 220, 'Weight:', 0, $481, 0 );
        AddText( 80, 220, Format( '%d', [Palanthir.Data.Tiledata.GetStaticWeight( Id )] ), 0, $481, 0 );
        AddText( 10, 250, 'Pos:', 0, $481, 0 );
        AddText( 80, 250, Format( '%d %d %d', [PX,PY,PZ] ), 0, $481, 0 );
        AddText( 10, 280, 'Flags:', 0, $481, 0 );

        AddTilePic( 180, 40, Id, 0, 0 );

        Y := 280;
        Flag := 1;

        for I := 0 to 31 do begin
                if Palanthir.Data.Tiledata.GetStaticFlag( Id, Flag ) then begin
                        Addtext( 80, Y, LowerCase( TiledataFlags[ I ] ), 0, $481, 0 );
                        Inc( Y, 20 );
                end;
                Flag := Flag shl 1;
        end;
end;

constructor TDisconnectMessageGump.Create( Text : String );
begin
        inherited Create;
        noMove := True;
        noClose := True;
        AddResizeGump( 0, 0, $A28, 400, 300, 0, 0 );

        AddText( 50, 50, Text, 0, 0, 0 );
        AddButton( 180, 250, $481, $483, $482, 0, 0 );
end;

procedure TDisconnectMessageGump.OnButtonClick( ReturnNumber : Integer );
begin
        Log.Write( 'ReturnToLoginGump: DisconnectMessage' );        
        Palanthir.ReturnToLoginGump;
end;

constructor TDirectionArrowGump.Create( X, Y : Word );
begin
        inherited Create;

        Typ := GumpTyp_DirectionArrow;

        StartTimer := CustomGetTickCount;

        Texture := Palanthir.Data.GetGumpTexture( $119C, 0 );
        if Texture <> nil then begin
                Palanthir.Data.IncGumpCache( $119C, 0 );
        end
        else begin
                Texture := nil;
                Exit;
        end;

        Self.X := X;
        Self.Y := Y;

        UpdatePhi;
end;

destructor TDirectionArrowGump.Free;
begin
        if Texture <> nil then
                Palanthir.Data.DecGumpCache( $119C, 0 );

        inherited Free;
end;

function TDirectionArrowGump.Draw : Boolean;
var     PosXMin, PosYMin, PosXMax, PosYMax : Integer;
        MX, MY, X1, Y1, X2, Y2, X3, Y3, X4, Y4, TmpX, TmpY : Integer;
begin
        if Texture = nil then begin
                Result := False;
                Exit;
        end;

        if StartTimer + 10000 < CustomGetTickCount then begin
                Result := False;
                Exit;
        end;

        if UpdateTimer + 100 < CustomGetTickCount then begin
                UpdatePhi;
        end;

        PosXMin := Palanthir.GameWindow.X + Palanthir.GameWindow.Breite div 2 - Texture.Breite div 2;
        PosYMin := Palanthir.GameWindow.Y + Palanthir.GameWindow.Hoehe div 2 - Texture.Hoehe div 2;
        PosXMax := PosXMin + Texture.Breite;
        PosYMax := PosYMin + Texture.Hoehe;

        MX := PosXMin + ( PosXMax - PosXMin ) div 2;
        MY := PosYMin + ( PosYMax - PosYMin ) div 2;

        TmpX := PosXMin - MX;
        TmpY := PosYMin - MY;
        X1 := MX + Round( TmpX * Cos( Phi ) - TmpY * Sin( Phi ) );
        Y1 := MY + Round( TmpX * Sin( Phi ) + TmpY * Cos( Phi ) );

        TmpX := PosXMax - MX;
        TmpY := PosYMin - MY;
        X2 := MX + Round( TmpX * Cos( Phi ) - TmpY * Sin( Phi ) );
        Y2 := MY + Round( TmpX * Sin( Phi ) + TmpY * Cos( Phi ) );

        TmpX := PosXMax - MX;
        TmpY := PosYMax - MY;
        X3 := MX + Round( TmpX * Cos( Phi ) - TmpY * Sin( Phi ) );
        Y3 := MY + Round( TmpX * Sin( Phi ) + TmpY * Cos( Phi ) );

        TmpX := PosXMin - MX;
        TmpY := PosYMax - MY;
        X4 := MX + Round( TmpX * Cos( Phi ) - TmpY * Sin( Phi ) );
        Y4 := MY + Round( TmpX * Sin( Phi ) + TmpY * Cos( Phi ) );

        if Renderer.CurrentTexID <> Texture.TexID then begin
                glBindTexture( GL_TEXTURE_2D, Texture.TexID );
                Renderer.CurrentTexID := Texture.TexID;
        end;

        glBegin( gl_Quads );
                gltexcoord2f( 0, 0 );
                glvertex2f( X1, Y1 );
                gltexcoord2f( 0, Texture.Hoehe / GetNextBit( Texture.Hoehe ) );
                glvertex2f( X2, Y2 );
                gltexcoord2f( Texture.Breite / GetNextBit( Texture.Breite ), Texture.Hoehe / GetNextBit( Texture.Hoehe ) );
                glvertex2f( X3, Y3 );
                gltexcoord2f( Texture.Breite / GetNextBit( Texture.Breite ), 0 );
                glvertex2f( X4, Y4 );
        glEnd;

        Result := True;
end;

procedure TDirectionArrowGump.UpdatePhi;
var     DiffX, DiffY, PosX, PosY : Integer;
begin
        UpdateTimer := CustomGetTickCount;

        DiffX := X - Palanthir.Player.Pos.X;
        DiffY := Y - Palanthir.Player.Pos.Y;

        PosX := ( DiffX - DiffY )*44;
        PosY := ( DiffX + DiffY )*44;

        if PosX = 0 then begin
                Phi := Pi / 2;
        end
        else begin
                Phi := ArcTan( PosY / PosX );
        end;

        if Phi < 0 then
                Phi := Pi + Phi;

        if (PosY > 0) or ( (PosX > 0) and (PosY = 0) ) then
                Phi := Pi + Phi;

        Phi := Phi - Pi / 2;
        if Phi < 0 then
                Phi := Phi + 2*Pi;
end;

end.
