unit uGumps;

interface

uses    Classes, uLoaderFonts, Dialogs, SysUtils, uSpeech, uBasicDrawObject,
        uTexCache, uRenderer, uLoaderTiledata, uUtilities, Math, uCounter, uLog,
        uLoaderHues, dglOpenGL, uPixelBuffer, SyncObjs, Jpeg, IdHTTP, Graphics,
        Python;

const   gt_Button = 0;
        gt_PageButton = 1;
        gt_Image = 2;
        gt_TiledImage = 3;
        gt_TilePic = 4;
        gt_Text = 5;
        gt_ResizeGump = 6;
        gt_CroppedText = 7;
        gt_HtmlGump = 8;
        gt_XmfHtmlGump = 9;
        gt_CheckerTrans = 10;
        gt_InputField = 11;
        gt_Checkbox = 12;
        gt_RadioButton = 13;
        gt_TextButton = 14;
        gt_GumpItem = 15;
        gt_GumpStaticItem = 16;
        gt_ScrollBar = 17;
        gt_HueButton = 18;
        gt_ProgressBar = 19;
        gt_ExtImage = 20;
        gt_LandTilePic = 21;
        gt_GumpToolTip = 22;
        gt_None = 23;

        GumpTyp_Paperdoll = 7;
        GumpTyp_Container = 8;
        GumpTyp_Status = 9;
        GumpTyp_SecureTrading = 10;
        GumpTyp_Options = 11;
        GumpTyp_GrabItem = 12;
        GumpTyp_Radar = 13;
        GumpTyp_Profile = 14;
        GumpTyp_CharCreation = 15;
        GumpTyp_Book = 16;
        GumpTyp_FightGump = 17;
        GumpTyp_DirectionArrow = 18;
        GumpTyp_PythonGump = 19;

type    TGumpObject = Class;
        TGumpButton = Class;
        TTextButton = Class;
        TPageButton = Class;
        TGImage = Class;
        TTiledImage = Class;
        TTilePic = Class;
        TLandTilePic = Class;
        TResizeGump = Class;
        TGumpText = Class;
        TCroppedText = Class;
        TInputField = Class;
        TCheckBox = Class;
        TRadioButton = Class;
        THtmlGump = Class;
        TXmfHtmlGump = Class;
        TCheckerTrans = Class;
        TGumpItem = Class;
        TGumpStaticItem = Class;
        TScrollBar = Class;
        THueButton = Class;
        TProgressBar = Class;
        TExtImage = Class;
        TGumpTooltip = Class;
        TGump = Class
                private
                        SpeechCache : TList;                             
                        ObjektListe : TList;
                        ClearPercent : Byte;
                        FadeBuffer : TPixelBuffer;
                        function InternalDraw( PX, PY : Integer ) : Boolean;
                public
                        ClearTick : LongWord;                
                        Typ, InternalID : Longword;
                        X, Y : SmallInt;
                        Breite, Hoehe : Word;
                        ActivePage : Word;
                        noMove, noClose, noDispose, noAutoClose : Boolean;
                        BBX, BBY, BBWidth, BBHeight : Integer;
                        BBEnabled : Boolean;
                        GlobalAlpha : Byte;

                        constructor Create; virtual;
                        destructor Free; virtual;
                        function AddButton( X, Y : Integer; UpId, DownId, MoveOverId : Word; ReturnNumber : Integer; Page : Word; CheckCompleteRectangle : Boolean = False ) : TGumpButton; overload;
                        function AddButton( X, Y : Integer; UpId, DownId : Word; ReturnNumber : Integer; Page : Word ) : TGumpButton; overload;
                        function AddTextButton( X, Y : Integer; ReturnNumber : Integer; Text : String; Font : Byte; Page : Word; Breite : Word; UpHue : Word = 0; DownHue : Word = 0; MoveOverHue : Word = 0; BackgroundUpId : Word = 0; BackgroundDownId : Word = 0; BackgroundMoveOverId : Word = 0; BackgroundUpHue : Word = 0; BackgroundDownHue : Word = 0; BackgroundMoveOverHue : Word = 0; Hoehe : Word = 0; IsPageButton : Boolean = False; PageId : Word = 0; Border : Boolean = True ) : TTextButton;
                        function AddPageButton( X, Y : Integer; UpId, DownId, PageId, Page : Word ) : TPageButton;
                        function AddImage( X, Y : Integer; Id, Hue, Page : Word ) : TGImage;
                        function AddTiledImage( X, Y : Integer; Hoehe, Breite : Integer; Id, Hue, Page : Word ) : TTiledImage;
                        function AddTilePic( X, Y : Integer; Id, Hue, Page : Word ) : TTilePic;
                        function AddLandTilePic( X, Y : Integer; Id, Hue, Page : Word ) : TLandTilePic;                        
                        function AddText( X, Y : Integer; Text : String; Font : Byte; Hue, Page : Word; Border : Boolean = True ) : TGumpText;
                        function AddResizeGump( X, Y : Integer; Id : Word; Breite, Hoehe : Integer; Hue, Page : Word; OnlyBorder : Boolean = False ) : TResizeGump;
                        function AddCroppedText( X, Y : Integer; Hoehe, Breite : Integer; Text : String; Font : Byte; Hue, Page : Word; MaxLines : Word = 1; Border : Boolean = True; DivHeight : Integer = 0 ) : TCroppedText;
                        function AddInputField( X, Y : Integer; Hoehe, Breite : Integer; Text : String; Font : Byte; TextId : Integer; Hue, Page : Word; AllowOnlyNumbers : Boolean = False; Stars : Boolean = False; AllowMultiLines : Boolean = False ) : TInputField;
                        function AddCheckBox( X, Y : Integer; TrueId, FalseId : Word; Checked : Boolean; ReturnNumber : Integer; Page : Word ) : TCheckBox;
                        function AddRadioButton( X, Y : Integer; TrueId, FalseId : Word; Checked : Boolean; ReturnNumber : Integer; Group : Word; Page : Word ) : TRadioButton;
                        function AddHtmlGump( X, Y : Integer; Text : String; Breite, Hoehe : Integer; hasBack, canScroll : Boolean; Page : Word ) : THtmlGump;
                        function AddXmfHtmlGump( X, Y : Integer; ClilocID : LongWord; Breite, Hoehe : Integer; hasBack, canScroll : Boolean; Color : Word; Page : Word ) : TXmfHtmlGump;
                        function AddCheckerTrans( X, Y, Hoehe, Breite : Integer; Page : Word ) : TCheckerTrans;
                        function AddGumpItem( X, Y : Integer; ItemSerial : LongWord; Pos : Integer = -1; Page : Word = 0 ) : TGumpItem; overload;
                        function AddGumpItem( X, Y : Integer; InternalId, InternalHue, InternalLayer : Word; Pos : Integer; Page : Word ) : TGumpItem; overload;
                        function AddStaticItem( X, Y : Integer; ItemSerial : LongWord; Page : Word = 0 ) : TGumpStaticItem;
                        function AddScrollBar( X, Y : Integer; Horizontal : Boolean; Length, UpId, MoveOverId : Word; Number : Integer; Page : Word ) : TScrollBar;
                        function AddHueButton( X, Y : Integer; Breite, Hoehe : Word; Red, Green, Blue : Byte; ReturnNumber : Integer; Page : Word ) : THueButton;
                        function AddProgressBar( X, Y : Integer; Breite, Hoehe : Word; Current, Max, BackLeftColor, BackRightColor, LeftColor, RightColor : LongWord; Text, Align : String; TextColor : LongWord; Waagerecht : Boolean; Page : Word ) : TProgressBar;
                        function AddExtImage( X, Y : Integer; Breite, Hoehe : Word; URL : String; Page : Word = 0 ) : TExtImage;
                        function AddTooltip( X, Y : Integer; Breite, Hoehe : Word; Text : String; Page : Word = 0 ) : TGumpTooltip;     

                        function GetInputText( ReturnNumber : Integer ) : String;
                        function GetCheckBox( ReturnNumber : Integer ) : Boolean;
                        function GetRadioButton( Group : Word ) : Integer;
                        function GetObject( Index : Integer ) : TGumpObject;
                        procedure DeleteObject( Index : Integer ); overload;
                        procedure DeleteObject( GumpObject : TGumpObject ); overload;
                        function GetObjectCount : Integer;
                        function GetButton( ReturnNumber : Integer ) : TGumpObject;

                        procedure OnButtonClick( ReturnNumber : Integer ); virtual;
                        procedure OnClick( X, Y : Word ); virtual;
                        procedure OnDblClick( GumpObject : TGumpObject ); overload; virtual;
                        function OnDblClick( X, Y : Word ) : Boolean; overload; virtual;
                        procedure OnCheckBoxChange( CheckBox : TCheckBox ); virtual;
                        procedure OnScrollBar( GumpObject : TGumpObject ); virtual;
                        procedure OnMoveOverButton( ReturnNumber : Integer ); virtual;
                        function OnMove( GumpObject : TGumpObject ) : Boolean; virtual;
                        function Draw : Boolean; virtual;
                        function OnKeyReturn( GumpObject : TGumpObject ) : Boolean; virtual;
                        function OnKeyTab( GumpObject : TGumpObject ) : Boolean; virtual;
                        procedure OnInputFieldChange( InputField : TInputField ); virtual;
                        procedure OnScrollBarRelease( ScrollBar : TScrollBar ); virtual;
                        procedure OnBeforeDraw; virtual;
                        procedure OnAfterDraw; virtual;
                        procedure OnDelete; virtual;
                        procedure OnMouseUp( GumpObject : TGumpObject ); virtual;
                        procedure OnMouseDown( GumpObject : TGumpObject ); virtual;
                        function GetBreite : Word;
                        function GetHoehe : Word;
                        procedure StartDecay;
                        procedure CheckTooltip( GumpObject : TGumpObject );
                        procedure SendBack( GumpObject : TGumpObject );
                        procedure SendFront( GumpObject : TGumpObject );
                        procedure SetBoundingBox( X, Y, Width, Height : Integer );
        end;

        TGumpObject = Class( TBasicDrawObject )
                private
                public
                        CustomVars : PPyObject;                
                        X, Y : Integer;
                        InternalID : LongWord;
                        LastClickX, LastClickY : Word;
                        Typ : Byte;
                        Page : Word;
                        Gump : TGump;
                        Speech : TSpeech;
                        Visible : Boolean;
                        DoMouseCheck : Boolean;
                        constructor Create; override;
                        destructor Free; override;
                        function IsGump : Boolean; override;
                        procedure Draw; virtual;
                        procedure onDown; virtual;
                        procedure onUp; virtual;
                        procedure OnMove; virtual;
                        procedure SetOver( Over : Boolean ); virtual;
                        procedure onClick( X, Y : Word ); virtual;
                        procedure onDblClick( X, Y : Word ); virtual;
                        function onKeyReturn : Boolean; virtual;
                        function onKeyTab : Boolean; virtual;
                        function GetHoehe : Word; virtual;
                        function GetBreite : Word; virtual;
        end;

        P_GumpObject = ^TGumpObject;

        TGumpButton = Class( TGumpObject )
                private
                        _UpId, _DownId, _MoveOverId : Word;
                        Down, MausOver : Boolean;
                        _Hue : Word;
                        procedure SetUpId( Id : Word );
                        procedure SetDownId( Id : Word );
                        procedure SetMoveOverId( Id : Word );
                        procedure SetHue( Hue : Word );
                public
                        CheckCompleteRectangle : Boolean;
                        ReturnNumber : Integer;                        
                        ScrollBar : TScrollBar;
                        property UpId : Word read _UpId write SetUpId;
                        property DownId : Word read _DownId write SetDownId;
                        property MoveOverId : Word read _MoveOverId write SetMoveOverId;
                        property Hue : Word read _Hue write SetHue;
                        constructor Create; overload; override;
                        constructor Create( X, Y : Integer; UpId, DownId, MoveOverId : Word; ReturnNumber : Integer; Page : Word; CheckCompleteRectangle : Boolean = False ); reintroduce; overload;
                        destructor Free; override;
                        procedure Draw; override;
                        procedure onDown; override;
                        procedure onUp; override;
                        procedure SetOver( Over : Boolean ); override;
                        procedure onClick( X, Y : Word ); override;
                        function GetHoehe : Word; override;
                        function GetBreite : Word; override;
                        function IsDown : Boolean;
                        function IsMausOver : Boolean;
        end;

        THueButton = Class( TGumpObject )
                private
                        _Red, _Green, _Blue : Byte;
                        MausOver : Boolean;
                        procedure SetRed( Value : Byte );
                        procedure SetGreen( Value : Byte );
                        procedure SetBlue( Value : Byte );
                public
                        Breite, Hoehe : Word;
                        ReturnNumber : Integer;
                        property Red : Byte read _Red write SetRed;
                        property Green : Byte read _Green write SetGreen;
                        property Blue : Byte read _Blue write SetBlue;
                        constructor Create; overload; override;
                        constructor Create( X, Y : Integer; Breite, Hoehe : Word; Red, Green, Blue : Byte; ReturnNumber : Integer; Page : Word ); reintroduce; overload;
                        destructor Free; override;
                        procedure Draw; override;
                        procedure SetOver( Over : Boolean ); override;
                        procedure onClick( X, Y : Word ); override;
                        procedure SetColor( Color : Word );
                        function GetHoehe : Word; override;
                        function GetBreite : Word; override;
                        function IsMausOver : Boolean;
        end;

        TTextButton = Class( TGumpObject )
                private
                        _Text : String;
                        _Border : Boolean;
                        _UpHue, _DownHue, _MoveOverHue : Word;
                        BackUp, BackDown, BackMoveOver : TResizeGump;
                        _BackUpHue, _BackDownHue, _BackMoveOverHue : Word;
                        _BackUpId, _BackDownId, _BackMoveOverId : Word;
                        Down, MausOver : Boolean;
                        Texture : TTexObject;
                        procedure SetText( Value : String );
                        procedure SetUpHue( Hue : Word );
                        procedure SetDownHue( Hue : Word );
                        procedure SetMoveOverHue( Hue : Word );
                        procedure SetBackUpHue( Hue : Word );
                        procedure SetBackDownHue( Hue : Word );
                        procedure SetBackMoveOverHue( Hue : Word );
                        procedure SetBackUpId( Id : Word );
                        procedure SetBackDownId( Id : Word );
                        procedure SetBackMoveOverId( Id : Word );
                        procedure SetBorder( Border : Boolean );
                        procedure GetTexture;
                public
                        ReturnNumber : Integer;
                        PageId : Word;
                        Font : Byte;
                        IsPageButton : Boolean;
                        Breite, Hoehe : Word;
                        property Border : Boolean read _Border write SetBorder;
                        property Text : String read _Text write SetText;
                        property UpHue : Word read _UpHue write SetUpHue;
                        property DownHue : Word read _DownHue write SetDownHue;
                        property MoveOverHue : Word read _MoveOverHue write SetMoveOverHue;
                        property BackUpHue : Word read _BackUpHue write SetBackUpHue;
                        property BackDownHue : Word read _BackDownHue write SetBackDownHue;
                        property BackMoveOverHue : Word read _BackMoveOverHue write SetBackMoveOverHue;
                        property BackUpId : Word read _BackUpId write SetBackUpId;
                        property BackDownId : Word read _BackDownId write SetBackDownId;
                        property BackMoveOverId : Word read _BackMoveOverId write SetBackMoveOverId;
                        constructor Create; overload; override;
                        constructor Create( X, Y : Integer; ReturnNumber : Integer; Text : String; Font : Byte; Page : Word; Breite : Word; UpHue : Word = 0; DownHue : Word = 0; MoveOverHue : Word = 0; IsPageButton : Boolean = False; PageId : Word = 0; Border : Boolean = True ); reintroduce; overload;
                        destructor Free; override;
                        procedure Draw; override;
                        procedure onDown; override;
                        procedure onUp; override;
                        procedure SetOver( Over : Boolean ); override;
                        procedure onClick( X, Y : Word ); override;
                        function GetTextureBreite : Word;
                        function GetTextureHoehe : Word;                        
                        function GetHoehe : Word; override;
                        function GetBreite : Word; override;
                        function IsMausOver : Boolean;                        
        end;       

        TPageButton = Class( TGumpObject )
                private
                        _UpId, _DownId : Word;
                        procedure SetUpId( Id : Word );
                        procedure SetDownId( Id : Word );
                public
                        Down : Boolean;
                        PageId : Word;
                        property UpId : Word read _UpId write SetUpId;
                        property DownId : Word read _DownId write SetDownId;
                        constructor Create; overload; override;
                        constructor Create( X, Y : Integer; UpId, DownId, PageId, Page : Word ); reintroduce; overload;
                        destructor Free; override;
                        procedure Draw; override;
                        procedure onDown; override;
                        procedure onUp; override;
                        procedure onClick( X, Y : Word ); override;
                        function GetHoehe : Word; override;
                        function GetBreite : Word; override;
        end;

        TGImage = Class( TGumpObject )
                private
                        _Id, _Hue : Word;
                        procedure SetId( Value : Word );
                        procedure SetHue( Value : Word );
                public
                        Breite, Hoehe : Word;
                        KeepProportions : Boolean;
                        property Id : Word read _Id write SetId;
                        property Hue : Word read _Hue write SetHue;
                        constructor Create; overload; override;
                        constructor Create( X, Y : Integer; Id, Hue, Page : Word ); reintroduce; overload;
                        destructor Free; override;
                        procedure Draw; override;
                        function GetHoehe : Word; override;
                        function GetBreite : Word; override;
        end;

        TTiledImage = Class( TGumpObject )
                private
                        _Id, _Hue : Word;
                        procedure SetId( Value : Word );
                        procedure SetHue( Value : Word );
                public
                        Breite, Hoehe : Word;
                        property Id : Word read _Id write SetId;
                        property Hue : Word read _Hue write SetHue;
                        constructor Create; overload; override;
                        constructor Create( X, Y : Integer; Hoehe, Breite : Integer; Id, Hue, Page : Word ); reintroduce; overload;
                        destructor Free; override;
                        procedure Draw; override;
                        function GetHoehe : Word; override;
                        function GetBreite : Word; override;
        end;

        TTilePic = Class( TGumpObject )
                private
                        _Id, _Hue : Word;
                        Texture : TTexObject;
                        Multi : TPixelBuffer;
                        MultiId, MultiColor : Word;
                        procedure SetId( Value : Word );
                        procedure SetHue( Value : Word );
                public
                        Breite, Hoehe : Word;
                        property Id : Word read _Id write SetId;
                        property Hue : Word read _Hue write SetHue;
                        constructor Create; overload; override;
                        constructor Create( X, Y : Integer; Id, Hue, Page : Word ); reintroduce; overload;
                        destructor Free; override;
                        procedure Draw; override;
                        function GetHoehe : Word; override;
                        function GetBreite : Word; override;
                        function GetTextureBreite : Word;
                        function GetTextureHoehe : Word;
        end;

        TLandTilePic = Class( TGumpObject )
                private
                        _Id, _Hue : Word;
                        Texture : TTexObject;                        
                        procedure SetId( Value : Word );
                        procedure SetHue( Value : Word );
                public
                        Breite, Hoehe : Word;
                        property Id : Word read _Id write SetId;
                        property Hue : Word read _Hue write SetHue;
                        constructor Create; overload; override;
                        constructor Create( X, Y : Integer; Id, Hue, Page : Word ); reintroduce; overload;
                        destructor Free; override;
                        procedure Draw; override;
                        function GetHoehe : Word; override;
                        function GetBreite : Word; override;
                        function GetTextureBreite : Word;
                        function GetTextureHoehe : Word; 
        end;

        TResizeGump = Class( TGumpObject )
                private
                        _Id, _Hue : Word;
                        procedure SetId( Value : Word );
                        procedure SetHue( Value : Word );
                public
                        OnlyBorder : Boolean;
                        Breite, Hoehe : Word;
                        property Id : Word read _Id write SetId;
                        property Hue : Word read _Hue write SetHue;
                        constructor Create; overload; override;
                        constructor Create( X, Y : Integer; Id : Word; Breite, Hoehe : Integer; Hue, Page : Word ); reintroduce; overload;
                        destructor Free; override;
                        procedure Draw; override;
                        function GetHoehe : Word; override;
                        function GetBreite : Word; override;
        end;

        TGumpText = Class( TGumpObject )
                private
                        _Border : Boolean;
                        _Font : Byte;
                        _Hue : Word;
                        _Text : String;
                        Texture : TTexObject;
                        procedure SetBorder( Value : Boolean );
                        procedure SetFont( Value : Byte );
                        procedure SetHue( Value : Word );
                        procedure SetText( Value : String );
                public
                        property Border : Boolean read _Border write SetBorder;
                        property Text : String read _Text write SetText;
                        property Font : Byte read _Font write SetFont;
                        property Hue : Word read _Hue write SetHue;
                        constructor Create; overload; override;
                        constructor Create( X, Y : Integer; Text : String; Font : Byte; Hue, Page : Word; Border : Boolean = True ); reintroduce; overload;
                        destructor Free; override;
                        procedure Draw; override;
                        procedure GetTexture;
                        function GetTextureBreite : Word;
                        function GetTextureHoehe : Word;
                        function GetHoehe : Word; override;
                        function GetBreite : Word; override;
        end;

        TCroppedText = Class( TGumpObject )
                private
                        _Border : Boolean;
                        _Font : Byte;
                        _Hue : Word;
                        _Text : String;
                        _DivHeight : Integer;
                        Texture : TTexObject;
                        procedure SetBorder( Value : Boolean );
                        procedure SetFont( Value : Byte );
                        procedure SetHue( Value : Word );
                        procedure SetText( Value : String );
                        procedure SetDivHeight( Value : Integer );
                public
                        Breite, Hoehe : Word;
                        MaxLines : Word;
                        MinX, MinY : Integer;
                        property Border : Boolean read _Border write SetBorder;
                        property Text : String read _Text write SetText;
                        property Font : Byte read _Font write SetFont;
                        property Hue : Word read _Hue write SetHue;
                        property DivHeight : Integer read _DivHeight write SetDivHeight;
                        constructor Create; overload; override;
                        constructor Create( X, Y : Integer; Hoehe, Breite : Integer; Text : String; Font : Byte; Hue, Page : Word; MaxLines : Word = 1; Border : Boolean = True; DivHeight : Integer = 0 ); reintroduce; overload;
                        destructor Free; override;
                        procedure Draw; override;
                        procedure GetTexture;
                        function GetTextureHoehe : Word;
                        function GetHoehe : Word; override;
                        function GetBreite : Word; override;
        end;

        TInputField = Class( TGumpObject )
                private
                        _Border : Boolean;
                        _Font : Byte;
                        _Hue : Word;
                        _Text : String;
                        _SelectedPos : SmallInt;
                        procedure SetBorder( Value : Boolean );
                        procedure SetFont( Value : Byte );
                        procedure SetHue( Value : Word );
                        procedure SetText( Value : String );
                        procedure SetSelectedPos( Value : SmallInt );
                public
                        Texture : TTexObject;
                        HasStars, AllowOnlyNumbers, AllowMultiLines : Boolean;
                        Breite, Hoehe, TextId : Word;
                        MinX, MinY : Word;
                        MaxLines : Word;
                        SelectionHue : Word;
                        TextChanged : Boolean;
                        DeleteTextOnNextChange : Boolean;          
                        property Border : Boolean read _Border write SetBorder;
                        property Text : String read _Text write SetText;
                        property Font : Byte read _Font write SetFont;
                        property Hue : Word read _Hue write SetHue;
                        property SelectedPos : SmallInt read _SelectedPos write SetSelectedPos;
                        constructor Create; overload; override;
                        constructor Create( X, Y : Integer; Hoehe, Breite : Integer; Text : String; Font : Byte; TextId : Integer; Hue, Page : Word; AllowOnlyNumbers : Boolean = False; Stars : Boolean = False; AllowMultiLines : Boolean = False ); reintroduce; overload;
                        destructor Free; override;
                        procedure Draw; override;
                        procedure onClick( X, Y : Word ); override;
                        procedure GetTexture;
                        function onKeyReturn : Boolean; override;
                        procedure OnChange;
                        function GetTextureBreite : Word;
                        function GetTextureHoehe : Word;
                        function GetHoehe : Word; override;
                        function GetBreite : Word; override;
                        function GetLines : TStringList;
        end;

        TCheckBox = Class( TGumpObject )
                private
                        _TrueId, _FalseId : Word;
                        procedure SetTrueId( Id : Word );
                        procedure SetFalseId( Id : Word );
                public
                        Checked : Boolean;
                        ReturnNumber : Integer;
                        property TrueId : Word read _TrueId write SetTrueId;
                        property FalseId : Word read _FalseId write SetFalseId;
                        constructor Create; override;
                        destructor Free; override;
                        procedure Draw; override;
                        procedure onClick( X, Y : Word ); override;
                        function GetHoehe : Word; override;
                        function GetBreite : Word; override;
        end;

        TRadioButton = Class( TGumpObject )
                        _TrueId, _FalseId : Word;
                        procedure SetTrueId( Id : Word );
                        procedure SetFalseId( Id : Word );
                public
                        Checked : Boolean;
                        ReturnNumber : Integer;
                        Group : Word;
                        property TrueId : Word read _TrueId write SetTrueId;
                        property FalseId : Word read _FalseId write SetFalseId;
                        constructor Create; override;
                        destructor Free; override;
                        procedure Draw; override;
                        procedure onClick( X, Y : Word ); override;
                        function GetHoehe : Word; override;
                        function GetBreite : Word; override;
        end;

        THtmlGump = Class( TGumpObject )
                private
                        _Text : String;
                        Texture : TTexObject;
                        BackGround : TResizeGump;
                        ScrollBar : TScrollBar;
                        ScrollUp, ScrollDown : TGumpButton;
                        ScrollBackGround : TTiledImage;
                        procedure SetText( Value : String );
                public
                        Breite, Hoehe : Integer;
                        hasBack, canScroll : Boolean;
                        StartPos : Integer;
                        property Text : String read _Text write SetText;
                        constructor Create; override;
                        destructor Free; override;
                        procedure Draw; override;
                        procedure GetTexture;
                        function GetHoehe : Word; override;
                        function GetBreite : Word; override;
                        function GetTextureBreite : Word;
                        function GetTextureHoehe : Word;
        end;

        TXmfHtmlGump = Class( TGumpObject )
                private
                        _Text : String;
                        _ClilocID : LongWord;
                        _Color : Word;
                        Texture : TTexObject;
                        BackGround : TResizeGump;
                        procedure SetClilocID( Value : LongWord );
                        procedure SetColor( Value : Word );
                public
                        Breite, Hoehe : Integer;
                        hasBack, canScroll : Boolean;
                        property Text : String read _Text;
                        property ClilocID : LongWord read _ClilocID write SetClilocID;
                        property Color : Word read _Color write SetColor;
                        constructor Create; override;
                        destructor Free; override;
                        procedure Draw; override;
                        procedure GetTexture;
                        function GetHoehe : Word; override;
                        function GetBreite : Word; override;
        end;

        TCheckerTrans = Class( TGumpObject )
                public
                        Breite, Hoehe : Integer;
                        Texture, ClearTexture : TTexObject;
                public
                        constructor Create; override;
                        destructor Free; override;
                        procedure Resize( Breite, Hoehe : Integer );
                        procedure InitDraw;
                        procedure Draw; override;
                        function GetHoehe : Word; override;
                        function GetBreite : Word; override;
        end;

        TGumpItem = Class( TGumpObject )
                private
                        InternalId, InternalHue, InternalLayer : Word;
                        ItemSerial : LongWord;                        
                        Texture : TTexObject;
                public
                        Blendfactor : Byte;
                        HasItem : Boolean;
                        constructor Create; override;
                        destructor Free; override;
                        procedure Draw; override;
                        procedure onDblClick( X, Y : Word ); override;
                        procedure onClick( X, Y : Word ); override;
                        function GetId : Word;
                        function GetHue : Word;
                        function GetLayer : Word;
                        function GetSerial : LongWord;
                        procedure SetId( Id : Word );
                        procedure SetHue( Hue : Word );
                        procedure SetLayer( Layer : Word );
                        procedure SetSerial( Serial : LongWord );
        end;

        TGumpStaticItem = Class( TGumpObject )
                private
                        Texture : TTexObject;
                        Multi, SelectedMulti : TPixelBuffer;
                        MultiId, MultiColor : Word;
                public
                        ItemSerial : LongWord;
                        constructor Create; override;
                        destructor Free; override;
                        procedure Draw; override;
                        procedure onDblClick( X, Y : Word ); override;
                        procedure onClick( X, Y : Word ); override;
        end;

        TScrollBar = Class( TGumpObject )
                private
                        _UpId, _MoveOverId : Word;
                        MausOver : Boolean;
                        procedure SetUpId( Id : Word );
                        procedure SetMoveOverId( Id : Word );
                public
                        Fixed : Boolean;
                        Promille : Word;
                        Hoehe, Breite : Word;
                        Horizontal : Boolean; //Otherwise its vertical
                        Number : Word;
                        UpButton, DownButton : TGumpButton;
                        HtmlGump : THtmlGump;
                        property UpId : Word read _UpId write SetUpId;
                        property MoveOverId : Word read _MoveOverId write SetMoveOverId;
                        constructor Create; override;
                        destructor Free; override;
                        procedure SetOver( Over : Boolean ); override;
                        procedure onUp; override;
                        procedure Draw; override;
                        function OnButton( Button : TGumpButton ) : Boolean;
                        function GetTexHoehe : Word;
                        procedure Change;
                        function GetHoehe : Word; override;
                        function GetBreite : Word; override;
        end;

        TProgressBar = Class( TGumpObject )
                private
                        _Text, TmpText : String;
                        _TextColor, TmpTextColor : LongWord;
                        Texture : TTexObject;
                        procedure SetText( Text : String );
                        procedure SetTextColor( Color : LongWord );
                public
                        Waagerecht : Boolean;
                        Hoehe, Breite : Word;
                        Align : String;
                        BackLeftColor, BackRightColor, LeftColor, RightColor : LongWord;
                        Max, Current : LongWord;
                        property Text : String read _Text write SetText;
                        property TextColor : LongWord read _TextColor write SetTextColor;
                        constructor Create; overload; override;
                        constructor Create( X, Y : Integer; Breite, Hoehe : Word; Current, Max, BackLeftColor, BackRightColor, LeftColor, RightColor : LongWord; Text, Align : String; TextColor : LongWord; Waagerecht : Boolean; Page : Word ); reintroduce; overload;
                        destructor Free; override;
                        procedure Draw; override;
                        function GetHoehe : Word; override;
                        function GetBreite : Word; override;
                        procedure GetTexture;
        end;

        TExtImageLoadThread = Class;
        TExtImage = Class( TGumpObject )
                private
                        Texture : TTexObject;
                        CriticalSection : TCriticalSection;
                        Thread : TExtImageLoadThread;
                        LoadingTextures : Array[0..3] of TTexObject;
                        LoadingTimer : LongWord;
                        LoadingStep : Byte;
                        Pixel : PByteArray;
                public
                        Hoehe, Breite : Word;
                        constructor Create; overload; override;
                        constructor Create( X, Y : Integer; Breite, Hoehe : Word; Location : String ); reintroduce; overload;
                        destructor Free; override;
                        procedure Draw; override;
                        function GetHoehe : Word; override;
                        function GetBreite : Word; override;
                        function GetTexture : TTexObject;
                        procedure SetTexture( Breite, Hoehe : Word; Pixel : PByteArray );
        end;

        TExtImageLoadThread = Class( TThread )
                private
                        ExtImage : TExtImage;
                        URL : String;
                        Dir : String;
                        CriticalSection : TCriticalSection;
                protected
                        procedure Execute; override;
                public
                        constructor Create( CreateSuspended : Boolean; ExtImage : TExtImage; Dir, URL : String );
                        destructor Free;
                        procedure SetExtImage( ExtImage : TExtImage );
        end;

        TGumpTooltip = Class( TGumpObject )
                public
                        Breite, Hoehe : Word;
                        constructor Create; overload; override;
                        constructor Create( X, Y : Integer; Breite, Hoehe : Word; Text : String; Page : Word ); reintroduce; overload;
        end;

implementation

uses    uPalanthir, uItem, uBasicTypedefs, uChar, uSpecialGumps;

constructor TGumpObject.Create;
begin
        inherited Create;

        Speech := nil;
        Gump := nil;
        LastClickX := 0;
        LastClickY := 0;
        Typ := gt_None;
        Visible := True;
        CustomVars := nil;
        DoMouseCheck := True;
        InternalID := Palanthir.GetNewGumpObjectId;

        Palanthir.GlobalGumpObjectList.Add( Self );
end;

destructor TGumpObject.Free;
var     I : Integer;
begin
        for I := 0 to Palanthir.GlobalGumpObjectList.Count-1 do begin
                if TGumpObject( Palanthir.GlobalGumpObjectList.Items[ I ] ) = Self then begin
                        Palanthir.GlobalGumpObjectList.Delete( I );
                        Break;
                end;
        end;

        if CustomVars <> nil then begin
                Py_XDECREF( CustomVars );
                CustomVars := nil;
        end;

        if Self = Palanthir.Maus.SelectedGumpObject then
                Palanthir.Maus.SelectedGumpObject := nil;
        if Self = Palanthir.Maus.SelectedDownLGumpObject then
                Palanthir.Maus.SelectedDownLGumpObject := nil;
        if Self = Palanthir.Maus.SelectedDownRGumpObject then
                Palanthir.Maus.SelectedDownRGumpObject := nil;
        if Self = Palanthir.Keyboard.SelectedGumpObject then begin
                Palanthir.Keyboard.KeyboardMode := KB_Speech;
                Palanthir.Keyboard.Typ := KB_Speech_Regular;
                Palanthir.Keyboard.SelectedGumpObject := nil;
        end;
        if Self = Palanthir.Maus.MObject then
                Palanthir.Maus.MObject := nil;

        inherited Free;
end;

function TGumpObject.IsGump : Boolean;
begin
        Result := True;
end;

procedure TGumpObject.Draw;
begin
end;

procedure TGumpObject.onDown;
begin
end;

procedure TGumpObject.onUp;
begin
end;

procedure TGumpObject.OnMove;
begin
end;

procedure TGumpObject.SetOver( Over : Boolean );
begin
end;

procedure TGumpObject.onClick( X, Y : Word );
begin
        if Gump <> nil then begin
                if Typ in [ gt_Image, gt_TiledImage, gt_TilePic, gt_Text, gt_ResizeGump, gt_CroppedText, gt_HtmlGump, gt_XmfHtmlGump, gt_CheckerTrans, gt_InputField ] then
                        if Gump <> Palanthir.GameWindow then
                                Palanthir.SetForeGroundGump( Gump );
                LastClickX := X;
                LastClickY := Y;

                Gump.OnClick( Self.X + X, Self.Y + Y );
        end;
end;

procedure TGumpObject.onDblClick( X, Y : Word );
begin
        if Gump <> nil then begin
                if Gump.OnDblClick( Self.X + X, Self.Y + Y ) then
                        Gump.OnDblClick( Self )
                else
                        Palanthir.DeleteGump( Self.Gump );
        end;
end;

function TGumpObject.onKeyReturn : Boolean;
begin
        if Gump <> nil then begin
                Result := Gump.OnKeyReturn( Self );
        end else begin
                Result := False;
        end;
end;

function TGumpObject.onKeyTab : Boolean;
begin
        if Gump <> nil then begin
                Result := Gump.OnKeyTab( Self );
        end else begin
                Result := False;
        end;
end;

function TGumpObject.GetHoehe : Word;
begin
        Result := 0;
end;

function TGumpObject.GetBreite : Word;
begin
        Result := 0;
end;

constructor TGumpButton.Create;
begin
        inherited Create;
        _UpId := Invalid_ID;
        _DownId := Invalid_ID;
        _MoveOverId := Invalid_ID;
        _Hue := 0;
        ScrollBar := nil;
        Typ := gt_Button;
        CheckCompleteRectangle := False;
end;

constructor TGumpButton.Create( X, Y : Integer; UpId, DownId, MoveOverId : Word; ReturnNumber : Integer; Page : Word; CheckCompleteRectangle : Boolean );
begin
        Self := TGumpButton.Create;

        Self.X := X;
        Self.Y := Y;
        Self.UpId := UpId;
        Self.DownId := DownId;
        Self.MoveOverId := MoveOverId;
        Self.ReturnNumber := ReturnNumber;
        Self.Page := Page;
        Self.Gump := nil;
        Self.Down := False;
        Self.CheckCompleteRectangle := CheckCompleteRectangle;

        Palanthir.Data.IncGumpCache( UpId, Hue );
        Palanthir.Data.IncGumpCache( DownId, Hue );
        Palanthir.Data.IncGumpCache( MoveOverId, Hue );
end;

destructor TGumpButton.Free;
begin
        if UpId <> Invalid_ID then
                Palanthir.Data.DecGumpCache( UpId, Hue );
        if DownId <> Invalid_ID then
                Palanthir.Data.DecGumpCache( DownId, Hue );
        if MoveOverId <> Invalid_ID then
                Palanthir.Data.DecGumpCache( MoveOverId, Hue );
        inherited Free;
end;

procedure TGumpButton.Draw;
var     Texture : TTexObject;
begin
        if Down then
                Texture := Palanthir.Data.GetGumpTexture( DownId, Hue )
        else begin
                if MausOver then
                        Texture := Palanthir.Data.GetGumpTexture( MoveOverId, Hue )
                else
                        Texture := Palanthir.Data.GetGumpTexture( UpId, Hue );
        end;
        if Texture = nil then
                exit;

        Renderer.DrawPixels( Gump.X+X, Gump.Y+Y, Texture );

        if DoMouseCheck then begin
                if CheckCompleteRectangle then begin
                        Palanthir.Maus.CheckGump( Gump.X+X, Gump.Y+Y, Texture.Breite, Texture.Hoehe, Self, nil, True );
                end
                else begin
                        Palanthir.Maus.CheckGump( Gump.X+X, Gump.Y+Y, Texture.Breite, Texture.Hoehe, Self, Texture );
                end;
        end;
end;

procedure TGumpButton.SetUpId( Id : Word );
begin
        if UpId <> Id then begin
                if UpId <> Invalid_ID then
                        Palanthir.Data.DecGumpCache( UpId, Hue );
                _UpId := Id;
                if MoveOverId = Invalid_ID then
                        MoveOverID := UpId;
                Palanthir.Data.IncGumpCache( UpId, Hue );
        end;
end;

procedure TGumpButton.SetDownId( Id : Word );
begin
        if DownId <> Id then begin
                if DownId <> Invalid_ID then
                        Palanthir.Data.DecGumpCache( DownId, Hue );
                _DownId := Id;
                Palanthir.Data.IncGumpCache( DownId, Hue );
        end;
end;

procedure TGumpButton.SetMoveOverId( Id : Word );
begin
        if MoveOverId <> Id then begin
                if MoveOverId <> Invalid_ID then
                        Palanthir.Data.DecGumpCache( MoveOverId, Hue );
                _MoveOverId := Id;
                Palanthir.Data.IncGumpCache( MoveOverId, Hue );
        end;
end;

procedure TGumpButton.SetHue( Hue : Word );
begin
        if _Hue <> Hue then begin
                if UpId <> Invalid_ID then
                        Palanthir.Data.DecGumpCache( UpId, Hue );
                if DownId <> Invalid_ID then
                        Palanthir.Data.DecGumpCache( DownId, Hue );
                if MoveOverId <> Invalid_ID then
                        Palanthir.Data.DecGumpCache( MoveOverId, Hue );

                _Hue := Hue;

                Palanthir.Data.IncGumpCache( UpId, Hue );
                Palanthir.Data.IncGumpCache( DownId, Hue );
                Palanthir.Data.IncGumpCache( MoveOverId, Hue );                
        end;
end;

procedure TGumpButton.onDown;
begin
        Down := True;
end;

procedure TGumpButton.onUp;
begin
        Down := False;
end;

procedure TGumpButton.SetOver( Over : Boolean );
begin
        MausOver := Over;
end;

procedure TGumpButton.onClick( X, Y : Word );
begin
        inherited onClick( X, Y );

        if ScrollBar <> nil then begin
                if ScrollBar.OnButton( Self ) then
                        exit;
        end;
        Gump.OnButtonClick( ReturnNumber );
end;

function TGumpButton.GetHoehe : Word;
var     Texture : TTexObject;
begin
        Result := 0;       
        if Down then
                Texture := Palanthir.Data.GetGumpTexture( DownId, Hue )
        else begin
                if MausOver then
                        Texture := Palanthir.Data.GetGumpTexture( MoveOverId, Hue )
                else
                        Texture := Palanthir.Data.GetGumpTexture( UpId, Hue );
        end;
        if Texture = nil then
                exit;
        Result := Texture.Hoehe;
end;

function TGumpButton.GetBreite : Word;
var     Texture : TTexObject;
begin
        Result := 0;
        if Down then
                Texture := Palanthir.Data.GetGumpTexture( DownId, Hue )
        else begin
                if MausOver then
                        Texture := Palanthir.Data.GetGumpTexture( MoveOverId, Hue )
                else
                        Texture := Palanthir.Data.GetGumpTexture( UpId, Hue );
        end;
        if Texture = nil then
                exit;
        Result := Texture.Breite;
end;

function TGumpButton.IsDown : Boolean;
begin
        Result := Down;
end;

function TGumpButton.IsMausOver : Boolean;
begin
        Result := MausOver;
end;

procedure THueButton.SetRed( Value : Byte );
begin
        _Red := Value;
end;

procedure THueButton.SetGreen( Value : Byte );
begin
        _Green := Value;
end;

procedure THueButton.SetBlue( Value : Byte );
begin
        _Blue := Value;
end;

constructor THueButton.Create;
begin
        inherited Create;
        _Red := 0;
        _Green := 0;
        _Blue := 0;
        MausOver := False;
        Breite := 0;
        Hoehe := 0;
        Typ := gt_HueButton;
end;

constructor THueButton.Create( X, Y : Integer; Breite, Hoehe : Word; Red, Green, Blue : Byte; ReturnNumber : Integer; Page : Word );
begin
        Self := THueButton.Create;
        Self.X := X;
        Self.Y := Y;
        Self.Breite := Breite;
        Self.Hoehe := Hoehe;
        Self.Red := Red;
        Self.Green := Green;
        Self.Blue := Blue;
        Self.ReturnNumber := ReturnNumber;
        Self.Page := Page;
        Self.Gump := nil;
end;

destructor THueButton.Free;
begin
        inherited Free;
end;

procedure THueButton.Draw;
begin
        Renderer.DrawRectangle( Gump.X + X, Gump.Y + Y, Hoehe, Breite, Red, Green, Blue );
        if DoMouseCheck then begin
                Palanthir.Maus.CheckGump( Gump.X + X, Gump.Y + Y, Breite, Hoehe, Self, nil, True );
        end;
end;

procedure THueButton.SetOver( Over : Boolean );
begin
        MausOver := Over;
        if Over then
                Gump.OnMoveOverButton( ReturnNumber );        
end;

procedure THueButton.onClick( X, Y : Word );
begin
        inherited onClick( X, Y );
        Gump.OnButtonClick( ReturnNumber );
end;

procedure THueButton.SetColor( Color : Word );
begin
        Red := Color15ToRed( Hues.GetColor( Color, 20 ) );
        Green := Color15ToGreen( Hues.GetColor( Color, 20 ) );
        Blue := Color15ToBlue( Hues.GetColor( Color, 20 ) );        
end;

function THueButton.GetHoehe : Word;
begin
        Result := Hoehe;
end;

function THueButton.GetBreite : Word;
begin
        Result := Breite;
end;

function THueButton.IsMausOver : Boolean;
begin
        Result := MausOver;
end;

constructor TTextButton.Create;
begin
        inherited Create;
        _Text := '';
        Breite := 0;
        Hoehe := 0;
        Texture := nil;
        BackUp := nil;
        BackDown := nil;
        BackMoveOver := nil;
        Typ := gt_TextButton;
        Border := True;

        BackDownHue := 0;
        BackUpHue := 0;
        BackMoveOverHue := 0;
end;

constructor TTextButton.Create( X, Y : Integer; ReturnNumber : Integer; Text : String; Font : Byte; Page : Word; Breite : Word; UpHue : Word; DownHue : Word; MoveOverHue : Word; IsPageButton : Boolean; PageId : Word; Border : Boolean );
begin
        Self := TTextButton.Create;
        Self.IsPageButton := IsPageButton;

        Self.X := X;
        Self.Y := Y;
        Self.UpHue := UpHue;
        Self.DownHue := DownHue;
        Self.MoveOverHue := MoveOverHue;
        Self.Breite := Breite;
        Self.Text := Text;
        Self.Page := Page;
        Self.PageId := PageId;
        Self.Font := Font;
        Self.ReturnNumber := ReturnNumber;
        Self.Down := False;
        Self.MausOver := False;
        Self.Border := Border;
        Self.GetTexture;
        Self.Gump := nil;
end;

destructor TTextButton.Free;
begin
        if Texture <> nil then
                Texture.Free;
        if BackUp <> nil then
                BackUp.Free;
        if BackDown <> nil then
                BackDown.Free;
        if BackMoveOver <> nil then
                BackMoveOver.Free;
        inherited Free;
end;

procedure TTextButton.Draw;
begin
        if Down and (BackDown <> nil) then begin
                BackDown.Draw;
        end else if Down and (_BackDownHue <> 0) then begin
                Renderer.DrawRectangle( Gump.X + X - 3, Gump.Y + Y, Hoehe + 4, Breite + 6, Color15toRed( Hues.GetColor( BackDownHue, 28 ) ), Color15toGreen( Hues.GetColor( BackDownHue, 28 ) ), Color15toBlue( Hues.GetColor( BackDownHue, 28 ) ) );
        end;

        if (not Down) and MausOver and (BackMoveOver <> nil) then begin
                BackMoveOver.Draw;
        end else if (not Down) and MausOver and (BackMoveOverHue <> 0) then begin
                Renderer.DrawRectangle( Gump.X + X - 3, Gump.Y + Y, Hoehe + 4, Breite + 6, Color15toRed( Hues.GetColor( BackMoveOverHue, 28 ) ), Color15toGreen( Hues.GetColor( BackMoveOverHue, 28 ) ), Color15toBlue( Hues.GetColor( BackMoveOverHue, 28 ) ) );
        end;

        if (not Down) and (not MausOver) and (BackUp <> nil) then begin
                BackUp.Draw;
        end else if (not Down) and (not MausOver) and (BackUpHue <> 0) then begin
                Renderer.DrawRectangle( Gump.X + X - 3, Gump.Y + Y, Hoehe + 4, Breite + 6, Color15toRed( Hues.GetColor( BackUpHue, 28 ) ), Color15toGreen( Hues.GetColor( BackUpHue, 28 ) ), Color15toBlue( Hues.GetColor( BackUpHue, 28 ) ) );
        end;

        if Texture = nil then
                exit;

        Renderer.DrawPixels( Gump.X+X, Gump.Y+Y, Texture );
        if DoMouseCheck then begin
                Palanthir.Maus.CheckGump( Gump.X+X, Gump.Y+Y, Texture.Breite, Texture.Hoehe, Self, nil, True );
        end;
end;

procedure TTextButton.GetTexture;
begin
        if Texture <> nil then
                Texture.Free;

        if Down then
                Texture := Palanthir.Data.GetUnicodeTexture( Font, Text, DownHue, Breite, 1, -1, Border )
        else if MausOver then
                Texture := Palanthir.Data.GetUnicodeTexture( Font, Text, MoveOverHue, Breite, 1, -1, Border )
        else
                Texture := Palanthir.Data.GetUnicodeTexture( Font, Text, UpHue, Breite, 1, -1, Border )
end;

procedure TTextButton.SetBorder( Border : Boolean );
begin
        if _Border = Border then
                exit;

        _Border := Border;

        GetTexture;
end;

procedure TTextButton.SetText( Value : String );
begin
        if _Text = Value then
                exit;

        _Text := Value;

        GetTexture;
end;

procedure TTextButton.SetUpHue( Hue : Word );
begin
        if UpHue <> Hue then begin
                _UpHue := Hue;
                if not ( Down or MausOver ) then
                        GetTexture;
        end;
end;

procedure TTextButton.SetDownHue( Hue : Word );
begin
        if DownHue <> Hue then begin
                _DownHue := Hue;
                if Down then
                        GetTexture;
        end;
end;

procedure TTextButton.SetMoveOverHue( Hue : Word );
begin
        if MoveOverHue <> Hue then begin
                _MoveOverHue := Hue;
                if ( not Down ) and MausOver then
                        GetTexture;
        end;
end;

procedure TTextButton.SetBackUpHue( Hue : Word );
begin
        if BackUpHue <> Hue then begin
                _BackUpHue := Hue;
                if (BackUp <> nil) and (BackUp.Hue <> BackUpHue) then
                        BackUp.Hue := BackUpHue;
        end;
end;

procedure TTextButton.SetBackDownHue( Hue : Word );
begin
        if BackDownHue <> Hue then begin
                _BackDownHue := Hue;
                if (BackUp <> nil) and (BackDown.Hue <> BackDownHue) then
                        BackDown.Hue := BackDownHue;
        end;
end;

procedure TTextButton.SetBackMoveOverHue( Hue : Word );
begin
        if BackMoveOverHue <> Hue then begin
                _BackMoveOverHue := Hue;
                if (BackUp <> nil) and (BackMoveOver.Hue <> BackMoveOverHue) then
                        BackMoveOver.Hue := BackMoveOverHue;
        end;
end;

procedure TTextButton.SetBackUpId( Id : Word );
begin
        if BackUpId <> Id then begin
                _BackUpId := Id;
                if (Id = 0) and (BackUp <> nil) then begin
                        BackUp.Free;
                        BackUp := nil;
                end
                else if BackUp = nil then begin
                        BackUp := TResizeGump.Create( -5 + X, -5 + Y, BackUpId, Breite+5, Hoehe+5, BackUpHue, Page );
                        BackUp.Gump := Gump;
                end
                else if BackUp.Id <> BackUpId then
                        BackUp.Id := BackUpId;
        end;
end;

procedure TTextButton.SetBackDownId( Id : Word );
begin
        if BackDownId <> Id then begin
                _BackDownId := Id;
                if (Id = 0) and (BackDown <> nil) then begin
                        BackDown.Free;
                        BackDown := nil;
                end
                else if BackDown = nil then begin
                        BackDown := TResizeGump.Create( -5 + X, -5 + Y, BackDownId, Breite+5, Hoehe+5, BackDownHue, Page );
                        BackDown.Gump := Gump;
                end
                else if BackDown.Id <> BackDownId then
                        BackDown.Id := BackDownId;
        end;
end;

procedure TTextButton.SetBackMoveOverId( Id : Word );
begin
        if BackMoveOverId <> Id then begin
                _BackMoveOverId := Id;
                if (Id = 0) and (BackMoveOver <> nil) then begin
                        BackMoveOver.Free;
                        BackMoveOver := nil;
                end
                else if BackMoveOver = nil then begin
                        BackMoveOver := TResizeGump.Create( -5 + X, -5 + Y, BackMoveOverId, Breite+5, Hoehe+5, BackMoveOverHue, Page );
                        BackMoveOver.Gump := Gump;
                end
                else if BackMoveOver.Id <> BackMoveOverId then
                        BackMoveOver.Id := BackMoveOverId;
        end;
end;

procedure TTextButton.onDown;
begin
        Down := True;
        GetTexture;
end;

procedure TTextButton.onUp;
begin
        Down := False;
        GetTexture;
end;

procedure TTextButton.SetOver( Over : Boolean );
begin
        MausOver := Over;
        GetTexture;        
end;

procedure TTextButton.onClick( X, Y : Word );
begin
        if IsPageButton then begin
                if Typ in [ gt_Image, gt_TiledImage, gt_TilePic, gt_Text, gt_ResizeGump, gt_CroppedText, gt_HtmlGump, gt_XmfHtmlGump, gt_CheckerTrans, gt_InputField ] then
                        if Gump <> Palanthir.GameWindow then
                                Palanthir.SetForeGroundGump( Gump );
                LastClickX := X;
                LastClickY := Y;

                Gump.ActivePage := PageId;
        end
        else begin
                inherited onClick( X, Y );
                Gump.OnButtonClick( ReturnNumber );
        end;
end;

function TTextButton.GetHoehe : Word;
begin
        Result := Hoehe;
end;

function TTextButton.GetBreite : Word;
begin
        Result := Breite;
end;

function TTextButton.GetTextureHoehe : Word;
begin
        if Texture = nil then
                Result := 0
        else
                Result := Texture.Hoehe;
end;

function TTextButton.GetTextureBreite : Word;
begin
        if Texture = nil then
                Result := 0
        else
                Result := Texture.Breite;
end;

function TTextButton.IsMausOver : Boolean;
begin
        Result := MausOver;
end;

constructor TPageButton.Create;
begin
        inherited Create;
        _UpId := Invalid_ID;
        _DownId := Invalid_ID;
        Typ := gt_PageButton;
end;

constructor TPageButton.Create( X, Y : Integer; UpId, DownId, PageId, Page : Word );
begin
        Self := TPageButton.Create;

        Self.X := X;
        Self.Y := Y;
        Self.UpId := UpId;
        Self.DownId := DownId;
        Self.Page := Page;
        Self.PageId := PageId;
        Self.Down := False;
        Self.Gump := nil;
        Palanthir.Data.IncGumpCache( UpId );
        Palanthir.Data.IncGumpCache( DownId );
end;

destructor TPageButton.Free;
begin
        if UpId <> Invalid_ID then
                Palanthir.Data.DecGumpCache( UpId );
        if DownId <> Invalid_ID then
                Palanthir.Data.DecGumpCache( DownId );
        inherited Free;
end;

procedure TPageButton.Draw;
var     Texture : TTexObject;
begin
        if Down then
                Texture := Palanthir.Data.GetGumpTexture( DownId )
        else
                Texture := Palanthir.Data.GetGumpTexture( UpId );
        
        if Texture = nil then
                exit;

        Renderer.DrawPixels( Gump.X+X, Gump.Y+Y, Texture );
        if DoMouseCheck then begin
                Palanthir.Maus.CheckGump( Gump.X+X, Gump.Y+Y, Texture.Breite, Texture.Hoehe, Self, Texture );
        end;
end;

procedure TPageButton.SetUpId( Id : Word );
begin
        if Id <> UpId then begin
                if UpId <> Invalid_ID then
                        Palanthir.Data.DecGumpCache( UpId );
                _UpId := Id;
                Palanthir.Data.IncGumpCache( UpId );
        end;
end;

procedure TPageButton.SetDownId( Id : Word );
begin
        if Id <> DownId then begin
                if DownId <> Invalid_ID then
                        Palanthir.Data.DecGumpCache( DownId );
                _DownId := Id;
                Palanthir.Data.IncGumpCache( DownId );
        end;
end;

procedure TPageButton.onDown;
begin
        Down := True;
end;

procedure TPageButton.onUp;
begin
        Down := False;
end;

procedure TPageButton.onClick( X, Y : Word );
begin
        if Typ in [ gt_Image, gt_TiledImage, gt_TilePic, gt_Text, gt_ResizeGump, gt_CroppedText, gt_HtmlGump, gt_XmfHtmlGump, gt_CheckerTrans, gt_InputField ] then
                if Gump <> Palanthir.GameWindow then
                        Palanthir.SetForeGroundGump( Gump );
        LastClickX := X;
        LastClickY := Y;

        Gump.ActivePage := PageId;
end;

function TPageButton.GetHoehe : Word;
var     Texture : TTexObject;
begin
        Result := 0;
        if Down then
                Texture := Palanthir.Data.GetGumpTexture( DownId )
        else
                Texture := Palanthir.Data.GetGumpTexture( UpId );

        if Texture = nil then
                exit;

        Result := Texture.Hoehe;
end;

function TPageButton.GetBreite : Word;
var     Texture : TTexObject;
begin
        Result := 0;
        if Down then
                Texture := Palanthir.Data.GetGumpTexture( DownId )
        else
                Texture := Palanthir.Data.GetGumpTexture( UpId );

        if Texture = nil then
                exit;

        Result := Texture.Breite;
end;

constructor TGImage.Create;
begin
        inherited Create;
        _Id := Invalid_ID;
        _Hue := 0;
        Typ := gt_Image;
        Breite := $FFFF;
        Hoehe := $FFFF;
        KeepProportions := False;
end;

constructor TGImage.Create( X, Y : Integer; Id, Hue, Page : Word );
begin
        Self := TGImage.Create;

        Self.X := X;
        Self.Y := Y;
        Self.Id := Id;
        Self.Hue := Hue;
        Self.Page := Page;
        Self.Typ := gt_Image;
        Self.Gump := nil;
        Palanthir.Data.IncGumpCache( Id, Hue );
end;

destructor TGImage.Free;
begin
        if ID <> Invalid_ID then
                Palanthir.Data.DecGumpCache( Id, Hue );
        inherited Free;
end;

procedure TGImage.Draw;
var     Texture : TTexObject;
        B, H : Word;
        Fac : Real;
begin
        Texture := Palanthir.Data.GetGumpTexture( Id, Hue );

        if Texture = nil then
                exit;

        if (Breite = $FFFF) and (Hoehe = $FFFF) then begin
                Renderer.DrawPixels( Gump.X+X, Gump.Y+Y, Texture );
                if DoMouseCheck then begin
                        Palanthir.Maus.CheckGump( Gump.X+X, Gump.Y+Y, Texture.Breite, Texture.Hoehe, Self, Texture );
                end;
        end else begin
                if KeepProportions then begin
                        Fac := Breite / Texture.Breite;
                        if Hoehe / Texture.Hoehe < Fac then
                                Fac := Hoehe / Texture.Hoehe;

                        B := Round( Texture.Breite * Fac );
                        H := Round( Texture.Hoehe * Fac );
                end else begin
                        if Breite = $FFFF then begin
                                B := Texture.Breite;
                        end else begin
                                B := Breite;
                        end;
                        if Hoehe = $FFFF then begin
                                H := Texture.Hoehe;
                        end else begin
                                H := Hoehe;
                        end;
                end;
                Renderer.DrawPixelsHoeheBreite( Gump.X+X, Gump.Y+Y, Texture, H, B, False );
                if DoMouseCheck then begin
                        Palanthir.Maus.CheckGump( Gump.X+X, Gump.Y+Y, Texture.Breite, Texture.Hoehe, Self, Texture );
                end;
        end;
end;

procedure TGImage.SetId( Value : Word );
begin
        if Value <> Id then begin
                if ID <> Invalid_ID then
                        Palanthir.Data.DecGumpCache( Id, Hue );
                _Id := Value;
                Palanthir.Data.IncGumpCache( Id, Hue );
        end;
end;

procedure TGImage.SetHue( Value : Word );
begin
        if Value <> Hue then begin
                if Id <> Invalid_ID then
                        Palanthir.Data.DecGumpCache( Id, Hue );
                _Hue := Value;
                if Id <> Invalid_ID then
                        Palanthir.Data.IncGumpCache( Id, Hue );
        end;
end;

function TGImage.GetHoehe : Word;
var     Texture : TTexObject;
begin
        if Hoehe <> $FFFF then begin
                Result := Hoehe;
                Exit;
        end;
        Result := 0;

        Texture := Palanthir.Data.GetGumpTexture( Id, Hue );
        if Texture = nil then
                exit;

        Result := Texture.Hoehe;
end;

function TGImage.GetBreite : Word;
var     Texture : TTexObject;
begin
        if Breite <> $FFFF then begin
                Result := Breite;
                Exit;
        end;
        Result := 0;

        Texture := Palanthir.Data.GetGumpTexture( Id, Hue );
        if Texture = nil then
                exit;

        Result := Texture.Breite;
end;

constructor TTiledImage.Create;
begin
        inherited Create;
        _Id := Invalid_ID;
        _Hue := 0;
        Typ := gt_TiledImage;
end;

constructor TTiledImage.Create( X, Y : Integer; Hoehe, Breite : Integer; Id, Hue, Page : Word );
begin
        Self := TTiledImage.Create;
        Self.X := X;
        Self.Y := Y;
        Self.Id := Id;
        Self.Hue := Hue;
        Self.Breite := Breite;
        Self.Hoehe := Hoehe;
        Self.Page := Page;
        Self.Gump := nil;
        Palanthir.Data.IncGumpCache( Id, Hue );
end;

destructor TTiledImage.Free;
begin
        if ID <> Invalid_ID then
                Palanthir.Data.DecGumpCache( Id, Hue );
        inherited Free;
end;

procedure TTiledImage.Draw;
var     Texture : TTexObject;
        K, L : Integer;
begin
        Texture := Palanthir.Data.GetGumpTexture( Id, Hue );

        if Texture = nil then
                exit;

        for K := 0 to ( Breite div Texture.Breite )+1 do
                for L := 0 to ( Hoehe div Texture.Hoehe )+1 do begin
                        Renderer.DrawPixelsMax( Gump.X+X+K*Texture.Breite, Gump.Y+Y+L*Texture.Hoehe, Texture, Gump.X+X+Breite, Gump.Y+Y+Hoehe );
                        if DoMouseCheck then begin
                                Palanthir.Maus.CheckGump( Gump.X+X+K*Texture.Breite, Gump.Y+Y+L*Texture.Hoehe, Texture.Breite, Texture.Hoehe, Self, Texture, False, Gump.X+X+Breite, Gump.Y+Y+Hoehe );
                        end;
                end;
end;

procedure TTiledImage.SetId( Value : Word );
begin
        if Value <> Id then begin
                if ID <> Invalid_ID then
                        Palanthir.Data.DecGumpCache( Id, Hue );
                _Id := Value;
                Palanthir.Data.IncGumpCache( Id, Hue );
        end;
end;

procedure TTiledImage.SetHue( Value : Word );
begin
        if Value <> Hue then begin
                if Id <> Invalid_ID then
                        Palanthir.Data.DecGumpCache( Id, Hue );
                _Hue := Value;
                if Id <> Invalid_ID then
                        Palanthir.Data.IncGumpCache( Id, Hue );
        end;
end;

function TTiledImage.GetHoehe : Word;
begin
        Result := Hoehe;
end;

function TTiledImage.GetBreite : Word;
begin
        Result := Breite;
end;

constructor TTilePic.Create;
begin
        inherited Create;
        _Id := Invalid_ID;
        _Hue := 0;
        Typ := gt_TilePic;
        Texture := nil;
        MultiId := 0;
        MultiColor := 0;
        Multi := nil;
        Breite := $FFFF;
        Hoehe := $FFFF;
end;

constructor TTilePic.Create( X, Y : Integer; Id, Hue, Page : Word );
begin
        Self := TTilePic.Create;
        Self.X := X;
        Self.Y := Y;
        Self.Id := Id;
        Self.Hue := Hue;
        Self.Page := Page;
        Self.Gump := nil;
        Texture := Palanthir.Data.GetStaticArt( Id, Hue );
        if Texture <> nil then
                Palanthir.Data.IncStaticArt( Texture.Id-$4000, Texture.Hue );
end;

destructor TTilePic.Free;
begin
        if Texture <> nil then
                Palanthir.Data.DecStaticArt( Texture.Id-$4000, Texture.Hue );

        if Multi <> nil then
                Multi.Free;

        inherited Free;
end;

procedure TTilePic.Draw;
begin
        Renderer.SetBoundingBox( Gump.X + X, Gump.Y + Y, Breite, Hoehe );
        if (ID >= Palanthir.FirstMultiID) and (ID <= Palanthir.LastMultiID) then begin
                if (Multi = nil) or (MultiId <> Id) or (MultiColor <> Hue) then begin
                        if Multi <> nil then begin
                                Multi.Free;
                                Multi := nil;
                        end;

                        Multi := Palanthir.Data.GetMultiAsPixelBuffer( Id-Palanthir.FirstMultiID, Hue );
                        if Multi = nil then begin
                                exit;
                        end;

                        MultiId := Id;
                        MultiColor := Hue;
                end;

                Multi.Bind;

                glColor3f( 1, 1, 1 );

                glBegin( gl_Quads );
                        glTexCoord2f( 0, 0 );
                        glVertex2f( Gump.X+X, Gump.Y+Y );
                        glTexCoord2f( 0, 1 );
                        glVertex2f( Gump.X+X, Gump.Y+Y + Multi.Height );
                        glTexCoord2f( 1, 1 );
                        glVertex2f( Gump.X+X + Multi.Width, Gump.Y+Y + Multi.Height );
                        glTexCoord2f( 1, 0 );
                        glVertex2f( Gump.X+X + Multi.Width, Gump.Y+Y );
                glEnd;

                Multi.Release;
                if DoMouseCheck then begin
                        Palanthir.Maus.CheckGump( Gump.X+X, Gump.Y+Y, Multi.Width, Multi.Height, Self, Multi.BitMask );
                end;
        end
        else begin
                if (Texture = nil) or (Texture.ID <> Id) or (Texture.Hue <> Hue) then begin
                        if Texture <> nil then
                                Palanthir.Data.DecStaticArt( Texture.Id-$4000, Texture.Hue );

                        Texture := Palanthir.Data.GetStaticArt( Id, Hue );

                        if Texture <> nil then
                                Palanthir.Data.IncStaticArt( Texture.Id-$4000, Texture.Hue );
                end;

                if Texture = nil then
                        exit;

                Renderer.DrawPixels( Gump.X+X, Gump.Y+Y, Texture );
                if DoMouseCheck then begin
                        Palanthir.Maus.CheckGump( Gump.X+X, Gump.Y+Y, Texture.Breite, Texture.Hoehe, Self, Texture );
                end;
        end;
        Renderer.ReleaseBoundingBox;
end;

procedure TTilePic.SetId( Value : Word );
begin
        if Value <> Id then begin;
                _Id := Value;
        end;
end;

procedure TTilePic.SetHue( Value : Word );
begin
        if Value <> Hue then begin
                _Hue := Value;
        end;
end;

function TTilePic.GetHoehe : Word;
begin
        if Hoehe <> $FFFF then begin
                Result := Hoehe;
                exit;
        end;

        Result := 0;
        if Texture = nil then
                exit;

        Result := Texture.Hoehe;
end;

function TTilePic.GetBreite : Word;
begin
        if Breite <> $FFFF then begin
                Result := Breite;
                exit;
        end;

        Result := 0;
        if Texture = nil then
                exit;

        Result := Texture.Breite;
end;

function TTilePic.GetTextureHoehe : Word;
begin
        Result := Palanthir.Data.GetStaticArtHeight( Id );
end;

function TTilePic.GetTextureBreite : Word;
begin
        Result := Palanthir.Data.GetStaticArtWidth( Id );
end;

constructor TLandTilePic.Create;
begin
        inherited Create;
        _Id := Invalid_ID;
        _Hue := 0;
        Typ := gt_LandTilePic;
        Texture := nil;
        Breite := $FFFF;
        Hoehe := $FFFF;
end;

constructor TLandTilePic.Create( X, Y : Integer; Id, Hue, Page : Word );
begin
        Self := TLandTilePic.Create;
        Self.X := X;
        Self.Y := Y;
        Self.Id := Id;
        Self.Hue := Hue;
        Self.Page := Page;
        Self.Gump := nil;
        Texture := Palanthir.Data.GetMapArt( Id, Hue );
        if Texture <> nil then
                Palanthir.Data.IncMapArt( Texture.Id, Texture.Hue );
end;

destructor TLandTilePic.Free;
begin
        if Texture <> nil then
                Palanthir.Data.DecMapArt( Texture.Id, Texture.Hue );
        inherited Free;
end;

procedure TLandTilePic.Draw;
begin
        Renderer.SetBoundingBox( Gump.X + X, Gump.Y + Y, Breite, Hoehe );
        if (Texture = nil) or (Texture.ID <> Id) or (Texture.Hue <> Hue) then begin
                if Texture <> nil then
                        Palanthir.Data.DecMapArt( Texture.Id, Texture.Hue );

                Texture := Palanthir.Data.GetMapArt( Id, Hue );

                if Texture <> nil then
                        Palanthir.Data.IncMapArt( Texture.Id, Texture.Hue );
        end;

        if Texture = nil then
                exit;

        Renderer.DrawPixels( Gump.X+X, Gump.Y+Y, Texture );
        if DoMouseCheck then begin
                Palanthir.Maus.CheckGump( Gump.X+X, Gump.Y+Y, Texture.Breite, Texture.Hoehe, Self, Texture );
        end;
        Renderer.ReleaseBoundingBox;
end;

procedure TLandTilePic.SetId( Value : Word );
begin
        if Value <> Id then begin
                _Id := Value;
        end;
end;

procedure TLandTilePic.SetHue( Value : Word );
begin
        if Value <> Hue then begin
                _Hue := Value;
        end;
end;

function TLandTilePic.GetHoehe : Word;
begin
        if Hoehe <> $FFFF then begin
                Result := Hoehe;
                exit;
        end;

        Result := 0;
        if Texture = nil then
                exit;

        Result := Texture.Hoehe;
end;

function TLandTilePic.GetBreite : Word;
begin
        if Breite <> $FFFF then begin
                Result := Breite;
                exit;
        end;

        Result := 0;
        if Texture = nil then
                exit;

        Result := Texture.Breite;
end;

function TLandTilePic.GetTextureHoehe : Word;
begin
        if Texture = nil then
                Result := 0
        else
                Result := Texture.Hoehe;
end;

function TLandTilePic.GetTextureBreite : Word;
begin
        if Texture = nil then
                Result := 0
        else
                Result := Texture.Breite;
end;

constructor TResizeGump.Create;
begin
        inherited Create;
        _Id := Invalid_ID;
        _Hue := 0;
        Typ := gt_ResizeGump;
end;

constructor TResizeGump.Create( X, Y : Integer; Id : Word; Breite, Hoehe : Integer; Hue, Page : Word );
var     I : Integer;
begin
        Self := TResizeGump.Create;
        Self.X := X;
        Self.Y := Y;
        Self.Id := Id;
        Self.Breite := Breite;
        Self.Hoehe := Hoehe;
        Self.Hue := Hue;
        Self.Page := Page;
        Self.Gump := nil;
        for I := 0 to 8 do
                Palanthir.Data.IncGumpCache( Id + I, Hue );
end;

destructor TResizeGump.Free;
var     I : Integer;
begin
        if ID <> Invalid_ID then
                for I := 0 to 8 do
                        Palanthir.Data.DecGumpCache( Id + I, Hue );
        inherited Free;
end;

procedure TResizeGump.Draw;
var     B_LO, B_MO, B_RO, B_LM, B_MM, B_RM, B_LU, B_MU, B_RU : TTexObject;
        K, L : Integer;
begin
        B_LO := Palanthir.Data.GetGumpTexture( Id, Hue );
        B_MO := Palanthir.Data.GetGumpTexture( Id+1, Hue );
        B_RO := Palanthir.Data.GetGumpTexture( Id+2, Hue );
        B_LM := Palanthir.Data.GetGumpTexture( Id+3, Hue );
        B_MM := Palanthir.Data.GetGumpTexture( Id+4, Hue );
        B_RM := Palanthir.Data.GetGumpTexture( Id+5, Hue );
        B_LU := Palanthir.Data.GetGumpTexture( Id+6, Hue );
        B_MU := Palanthir.Data.GetGumpTexture( Id+7, Hue );
        B_RU := Palanthir.Data.GetGumpTexture( Id+8, Hue );

        if (B_LO = nil) or (B_MO = nil) or (B_RO = nil) or
           (B_LM = nil) or (B_MM = nil) or (B_RM = nil) or
           (B_LU = nil) or (B_MU = nil) or (B_RU = nil) then
                exit;

        Renderer.DrawPixels( Gump.X+X, Gump.Y+Y, B_LO );
        if DoMouseCheck then begin
                Palanthir.Maus.CheckGump( Gump.X+X, Gump.Y+Y, B_LO.Breite, B_LO.Hoehe, Self, B_LO );
        end;

        Renderer.DrawPixels( Gump.X+X+Breite-B_RO.Breite, Gump.Y+Y, B_RO );
        if DoMouseCheck then begin
                Palanthir.Maus.CheckGump( Gump.X+X+Breite-B_RO.Breite, B_RO.Breite, B_RO.Hoehe, B_RO.Hoehe, Self, B_RO );
        end;

        Renderer.DrawPixels( Gump.X+X, Gump.Y+Y+Hoehe-B_LU.Hoehe, B_LU );
        if DoMouseCheck then begin
                Palanthir.Maus.CheckGump( Gump.X+X, Gump.Y+Y+Hoehe-B_LU.Hoehe, B_LU.Breite, B_LU.Hoehe, Self, B_LU );
        end;

        Renderer.DrawPixels( Gump.X+X+Breite-B_RU.Breite, Gump.Y+Y+Hoehe-B_RU.Hoehe, B_RU );
        if DoMouseCheck then begin
                Palanthir.Maus.CheckGump( Gump.X+X+Breite-B_RU.Breite, Gump.Y+Y+Hoehe-B_RU.Hoehe, B_RU.Breite, B_RU.Hoehe, Self, B_RU );
        end;

        for K := 0 to (( Hoehe-B_LO.Hoehe-B_LU.Hoehe ) div B_LM.Hoehe )+1 do begin
                Renderer.DrawPixelsMax( Gump.X+X, Gump.Y+Y+B_LO.Hoehe+K*B_LM.Hoehe, B_LM, Gump.X+X+B_LM.Breite, Gump.Y+Y+Hoehe-B_LU.Hoehe );
                if DoMouseCheck then begin
                        Palanthir.Maus.CheckGump( Gump.X+X, Gump.Y+Y+B_LO.Hoehe+K*B_LM.Hoehe, B_LM.Breite, B_LM.Hoehe, Self, B_LM, False, Gump.X+X+B_LM.Breite, Gump.Y+Y+Hoehe-B_LU.Hoehe );
                end;
        end;
        for K := 0 to (( Hoehe-B_RO.Hoehe-B_RU.Hoehe ) div B_RM.Hoehe )+1 do begin
                Renderer.DrawPixelsMax( Gump.X+X+Breite-B_RM.Breite, Gump.Y+Y+B_RO.Hoehe+K*B_RM.Hoehe, B_RM, Gump.X+X+Breite, Gump.Y+Y+Hoehe-B_RU.Hoehe );
                if DoMouseCheck then begin
                        Palanthir.Maus.CheckGump( Gump.X+X+Breite-B_RM.Breite, Gump.Y+Y+B_RO.Hoehe+K*B_RM.Hoehe, B_RM.Breite, B_RM.Hoehe, Self, B_RM, False, Gump.X+X+Breite, Gump.Y+Y+Hoehe-B_RU.Hoehe );
                end;
        end;
        for L := 0 to (( Breite-B_LO.Breite-B_RO.Breite ) div B_MO.Breite )+1 do begin
                Renderer.DrawPixelsMax( Gump.X+X+B_LO.Breite+L*B_MO.Breite, Gump.Y+Y, B_MO, Gump.X+X+Breite-B_RO.Breite, Gump.Y+Y+Hoehe );
                if DoMouseCheck then begin
                        Palanthir.Maus.CheckGump( Gump.X+X+B_LO.Breite+L*B_MO.Breite, Gump.Y+Y, B_MO.Breite, B_MO.Hoehe, Self, B_MO, False, Gump.X+X+Breite-B_RO.Breite );
                end;
        end;
        for L := 0 to (( Breite-B_LU.Breite-B_RU.Breite ) div B_MU.Breite )+1 do begin
                Renderer.DrawPixelsMax( Gump.X+X+B_LU.Breite+L*B_MU.Breite, Gump.Y+Y+Hoehe-B_MU.Hoehe, B_MU, Gump.X+X+Breite-B_RU.Breite, Gump.Y+Y+Hoehe );
                if DoMouseCheck then begin
                        Palanthir.Maus.CheckGump( Gump.X+X+B_LU.Breite+L*B_MU.Breite, Gump.Y+Y+Hoehe-B_MU.Hoehe, B_MU.Breite, B_MU.Hoehe, Self, B_MU, False, Gump.X+X+Breite-B_RU.Breite );
                end;
        end;

        if not OnlyBorder then begin
                for K := 0 to (( Breite-B_LM.Breite-B_RM.Breite ) div B_MM.Breite )+1 do
                        for L := 0 to (( Hoehe-B_MO.Hoehe-B_MU.Hoehe ) div B_MM.Hoehe )+1 do begin
                                Renderer.DrawPixelsMax( Gump.X+X+B_LM.Breite+K*B_MM.Breite, Gump.Y+Y+B_MO.Hoehe+L*B_MM.Hoehe, B_MM, Gump.X+X+Breite-B_RM.Breite, Gump.Y+Y+Hoehe-B_MU.Hoehe );
                                if DoMouseCheck then begin
                                        Palanthir.Maus.CheckGump( Gump.X+X+B_LM.Breite+K*B_MM.Breite, Gump.Y+Y+B_MO.Hoehe+L*B_MM.Hoehe, B_MM.Breite, B_MM.Hoehe, Self, B_MM, False, Gump.X+X+Breite-B_RM.Breite, Gump.Y+Y+Hoehe-B_MU.Hoehe );
                                end;
                        end;
        end;
end;

procedure TResizeGump.SetId( Value : Word );
var     I : Integer;
begin
        if Value <> Id then begin
                if Id <> Invalid_ID then
                        for I := 0 to 8 do
                                Palanthir.Data.DecGumpCache( Id + I, Hue );
                _Id := Value;
                for I := 0 to 8 do
                        Palanthir.Data.IncGumpCache( Id + I, Hue );
        end;
end;

procedure TResizeGump.SetHue( Value : Word );
var     I : Integer;
begin
        if Value <> Hue then begin
                if Id <> Invalid_ID then
                        for I := 0 to 8 do
                                Palanthir.Data.DecGumpCache( Id + I, Hue );
                _Hue := Value;
                if Id <> Invalid_ID then
                        for I := 0 to 8 do
                                Palanthir.Data.IncGumpCache( Id + I, Hue );
        end;
end;

function TResizeGump.GetHoehe : Word;
begin
        Result := Hoehe;
end;

function TResizeGump.GetBreite : Word;
begin
        Result := Breite;
end;

constructor TGumpText.Create;
begin
        inherited Create;
        _Text := '';
        _Hue := 0;
        _Font := 0;
        Texture := nil;
        Typ := gt_Text;
end;

constructor TGumpText.Create( X, Y : Integer; Text : String; Font : Byte; Hue, Page : Word; Border : Boolean );
begin
        Self := TGumpText.Create;
        Self.X := X;
        Self.Y := Y;
        Self.Hue := Hue;
        Self.Font := Font;
        Self.Page := Page;
        Self.Border := Border;        
        Self.Text := Text;
        Self.Gump := nil;
end;

destructor TGumpText.Free;
begin
        if Texture <> nil then
                Texture.Free;
        inherited Free;
end;

procedure TGumpText.Draw;
begin
        if Texture = nil then
                exit;

        Renderer.DrawPixelsStartMax( Gump.X+X, Gump.Y+Y, Texture, 0, 0, $FFFF, $FFFF );
        if DoMouseCheck then begin
                Palanthir.Maus.CheckGump( Gump.X+X, Gump.Y+Y, Texture.Breite, Texture.Hoehe, Self, nil, True );
        end;
end;

procedure TGumpText.SetBorder( Value : Boolean );
begin
        if Value <> Border then begin
                _Border := Value;
                GetTexture;
        end;
end;

procedure TGumpText.SetFont( Value : Byte );
begin
        if Value <> Font then begin
                _Font := Value;
                GetTexture;
        end;
end;

procedure TGumpText.SetHue( Value : Word );
begin
        if Value <> Hue then begin
                _Hue := Value;
                GetTexture;
        end;
end;

procedure TGumpText.SetText( Value : String );
begin
        if Text <> Value then begin
                _Text := Value;
                GetTexture;
        end;
end;

procedure TGumpText.GetTexture;
begin
        if Texture <> nil then
                Texture.Free;

        Texture := Palanthir.Data.GetUnicodeTexture( Font, Text, Hue, 500, 1, -1, Border );
end;

function TGumpText.GetTextureBreite : Word;
begin
        if Texture = nil then
                Result := 0
        else
                Result := Texture.Breite;
end;

function TGumpText.GetTextureHoehe : Word;
begin
        if Texture = nil then
                Result := 0
        else
                Result := Texture.Hoehe;
end;

function TGumpText.GetBreite : Word;
begin
        Result := 0;

        if Texture = nil then
                exit;

        Result := Texture.Breite;
end;

function TGumpText.GetHoehe : Word;
begin
        Result := 0;

        if Texture = nil then
                exit;

        Result := Texture.Hoehe;
end;

constructor TCroppedText.Create;
begin
        inherited Create;
        _Text := '';
        _Hue := 0;
        _Font := 0;
        _Border := True;
        _DivHeight := 0;
        Breite := 0;
        Hoehe := 0;
        Texture := nil;
        MinX := 0;
        MinY := 0;
        MaxLines := 1;
        Typ := gt_CroppedText;
end;

constructor TCroppedText.Create( X, Y : Integer; Hoehe, Breite : Integer; Text : String; Font : Byte; Hue, Page : Word; MaxLines : Word; Border : Boolean; DivHeight : Integer );
begin
        Self := TCroppedText.Create;
        Self.X := X;
        Self.Y := Y;
        Self.Text := Text;
        Self.Hue := Hue;
        Self.Page := Page;
        Self.Font := Font;
        Self.Breite := Breite;
        Self.Hoehe := Hoehe;
        Self.MaxLines := MaxLines;
        Self.Border := Border;
        Self.DivHeight := DivHeight;
        Self.GetTexture;
        Self.Gump := nil;
end;

destructor TCroppedText.Free;
begin
        if Texture <> nil then
                Texture.Free;
        inherited Free;
end;

procedure TCroppedText.Draw;
begin
        if Texture = nil then
                exit;

        Renderer.DrawPixelsStartMax( Gump.X+X, Gump.Y+Y, Texture, MinX, MinY, Gump.X+X+Breite, Gump.Y+Y+Hoehe );
        if DoMouseCheck then begin
                Palanthir.Maus.CheckGump( Gump.X+X, Gump.Y+Y, Texture.Breite, Texture.Hoehe, Self, nil, True );
        end;
end;

procedure TCroppedText.SetBorder( Value : Boolean );
begin
        if Value <> Border then begin
                _Border := Value;
                GetTexture;
        end;
end;

procedure TCroppedText.SetFont( Value : Byte );
begin
        if Value <> Font then begin
                _Font := Value;
                GetTexture;
        end;
end;

procedure TCroppedText.SetHue( Value : Word );
begin
        if Value <> Hue then begin
                _Hue := Value;
                GetTexture;
        end;
end;

procedure TCroppedText.SetText( Value : String );
begin
        if Text <> Value then begin
                _Text := Value;
                GetTexture;
        end;
end;

procedure TCroppedText.SetDivHeight( Value : Integer );
begin
        if DivHeight <> Value then begin
                _DivHeight := Value;
                GetTexture;
        end;
end;

procedure TCroppedText.GetTexture;
begin
        if Texture <> nil then
                Texture.Free;

        Texture := Palanthir.Data.GetUnicodeTexture( Font, Text, Hue, Breite, MaxLines, -1, Border, False, DivHeight );
end;

function TCroppedText.GetTextureHoehe : Word;
begin
        if Texture = nil then
                Result := 0
        else
                Result := Texture.Hoehe;
end;

function TCroppedText.GetHoehe : Word;
begin
        Result := Hoehe;
end;

function TCroppedText.GetBreite : Word;
begin
        Result := Breite;
end;

constructor TInputField.Create;
begin
        inherited Create;
        Typ := gt_InputField;
        _Text := '';
        _Hue := 0;
        _Font := 0;
        Breite := 0;
        Hoehe := 0;
        SelectedPos := -1;
        Texture := nil;
        MinX := 0;
        MinY := 0;
        Border := True;
        MaxLines := 1;
        SelectionHue := $1B;
        TextChanged := False;
        DeleteTextOnNextChange := False;
end;

constructor TInputField.Create( X, Y : Integer; Hoehe, Breite : Integer; Text : String; Font : Byte; TextId : Integer; Hue, Page : Word; AllowOnlyNumbers : Boolean; Stars : Boolean; AllowMultiLines : Boolean );
begin
        Self := TInputField.Create;
        Self.X := X;
        Self.Y := Y;
        Self.Text := Text;
        Self.Hue := Hue;
        Self.Page := Page;
        Self.Font := Font;
        Self.Breite := Breite;
        Self.Hoehe := Hoehe;
        Self.TextId := TextId;
        Self.SelectedPos := Length( Self.Text );
        Self.HasStars := Stars;
        Self.AllowOnlyNumbers := AllowOnlyNumbers;
        Self.AllowMultiLines := AllowMultiLines;
        Self.GetTexture;
        Self.Gump := nil;
end;

destructor TInputField.Free;
begin
        if Texture <> nil then
                Texture.Free;
        inherited Free;
end;

procedure TInputField.Draw;
begin
        if (SelectedPos <> -1) and (Palanthir.Keyboard.SelectedGumpObject <> Self) then begin
                SelectedPos := -1;
                GetTexture;
        end;
        if (Palanthir.Keyboard.SelectedGumpObject = Self) and (SelectedPos = -1) then begin
                SelectedPos := Length( Text )+1;
                GetTexture;
        end;

        if Texture <> nil then begin
                if MinY > Texture.Hoehe then
                        Exit;
                Renderer.DrawPixelsStartMax( Gump.X+X, Gump.Y+Y, Texture, MinX, MinY, Gump.X+X+Breite, Gump.Y+Y+Min( Hoehe, Texture.Hoehe-MinY ) );
        end;
        if DoMouseCheck then begin
                Palanthir.Maus.CheckGump( Gump.X+X, Gump.Y+Y, Breite, Hoehe, Self, nil, True );
        end;
end;

procedure TInputField.SetBorder( Value : Boolean );
begin
        if Value <> Border then begin
                _Border := Value;
                GetTexture;
        end;
end;

procedure TInputField.SetFont( Value : Byte );
begin
        if Value <> Font then begin
                _Font := Value;
                GetTexture;
        end;
end;

procedure TInputField.SetHue( Value : Word );
begin
        if Value <> Hue then begin
                _Hue := Value;
                GetTexture;
        end;
end;

procedure TInputField.SetText( Value : String );
begin
        if Text <> Value then begin
                _Text := Value;
                GetTexture;
                OnChange;
                TextChanged := True;
        end;
end;

procedure TInputField.SetSelectedPos( Value : SmallInt );
begin
        if SelectedPos <> Value then begin
                _SelectedPos := Value;
                GetTexture;
                OnChange;
        end;
end;

procedure TInputField.GetTexture;
var     TempText : String;
        I : Integer;
begin
        if Texture <> nil then begin
                Texture.Free;
                Texture := nil;
        end;

        if HasStars then begin
                TempText := '';
                for I := 0 to Length( Text )-1 do
                        TempText := TempText + '*';
        end
        else begin
                TempText := Text;
        end;

        //MaxLines := Max( Hoehe div 18, 1 );
        if AllowMultiLines then begin
                if MaxLines = 1 then
                        MaxLines := $FF;
        end
        else begin
                MaxLines := 1;
        end;

        if Palanthir.Keyboard.SelectedGumpObject = Self then
                Texture := Palanthir.Data.GetUnicodeTexture( Font, TempText, SelectionHue, Breite, MaxLines, SelectedPos, Border )
        else
                Texture := Palanthir.Data.GetUnicodeTexture( Font, TempText, Hue, Breite, MaxLines, SelectedPos, Border );
end;

procedure TInputField.onClick( X, Y : Word );
var     I, Laenge : Byte;
begin
        inherited onClick( X, Y );
        Palanthir.Keyboard.SelectedGumpObject := Self;
        Palanthir.Keyboard.KeyboardMode := KB_Gump;

        if Length( Text ) = 0 then begin
                SelectedPos := 1;
                GetTexture;
                exit;
        end;

        if MaxLines > 1 then begin
                SelectedPos := Length( Text )+1;
                GetTexture;
                exit;
        end;

        Laenge := 0;
        I := 1;
        while ( Laenge < X ) and ( I <= Length( Text ) ) do begin
                Laenge := Laenge + Palanthir.Data.GetBuchstabenBreite( Font, Ord( Text[ I ] ) ) -1;
                Inc( I );
        end;

        if Laenge >= X then
                SelectedPos := I-1
        else
                SelectedPos := I;
        GetTexture;
end;

function TInputField.onKeyReturn : Boolean;
begin
        if MaxLines > 1 then begin
                SetText( Text + #10 );
                if SelectedPos >= 0 then
                        SelectedPos := SelectedPos + 1;
                Result := True;
        end
        else
                Result := inherited onKeyReturn;
end;

procedure TInputField.OnChange;
begin
        if Gump <> nil then
                Gump.OnInputFieldChange( Self );
end;

function TInputField.GetHoehe : Word;
begin
        Result := Hoehe;
end;

function TInputField.GetBreite : Word;
begin
        Result := Breite;
end;

function TInputField.GetTextureBreite : Word;
begin
        if Texture = nil then
                Result := 0
        else
                Result := Texture.Breite;
end;

function TInputField.GetTextureHoehe : Word;
begin
        if Texture = nil then
                Result := 0
        else
                Result := Texture.Hoehe;
end;

function TInputField.GetLines : TStringList;
begin
        if Text <> '' then begin
                Result := Palanthir.Data.GetUnicodeLines( Font, Text, Breite, Border );
        end else begin
                Result := TStringList.Create;
        end;
end;

constructor TCheckBox.Create;
begin
        inherited Create;
        TrueId := Invalid_Id;
        FalseId := Invalid_Id;
        Typ := gt_CheckBox;
end;

destructor TCheckBox.Free;
begin
        if TrueId <> Invalid_Id then
                Palanthir.Data.DecGumpCache( TrueId );
        if FalseId <> Invalid_Id then
                Palanthir.Data.DecGumpCache( FalseId );
        inherited Free;
end;

procedure TCheckBox.Draw;
var     Texture : TTexObject;
begin
        if Checked then
                Texture := Palanthir.Data.GetGumpTexture( TrueId )
        else
                Texture := Palanthir.Data.GetGumpTexture( FalseId );
        
        if Texture = nil then
                exit;

        Renderer.DrawPixels( Gump.X+X, Gump.Y+Y, Texture );
        if DoMouseCheck then begin
                Palanthir.Maus.CheckGump( Gump.X+X, Gump.Y+Y, Texture.Breite, Texture.Hoehe, Self, Texture );
        end;
end;

procedure TCheckBox.SetTrueId( Id : Word );
begin
        if TrueId <> Invalid_Id then
                Palanthir.Data.DecGumpCache( TrueId );
        _TrueId := Id;
        Palanthir.Data.IncGumpCache( TrueId );
end;

procedure TCheckBox.SetFalseId( Id : Word );
begin
        if FalseId <> Invalid_Id then
                Palanthir.Data.DecGumpCache( FalseId );
        _FalseId := Id;
        Palanthir.Data.IncGumpCache( FalseId );
end;

procedure TCheckBox.onClick( X, Y : Word );
begin
        inherited onClick( X, Y );
        Checked := not Checked;
        Gump.OnCheckBoxChange( Self );
end;

function TCheckBox.GetHoehe : Word;
var     Texture : TTexObject;
begin
        Result := 0;
        if Checked then
                Texture := Palanthir.Data.GetGumpTexture( TrueId )
        else
                Texture := Palanthir.Data.GetGumpTexture( FalseId );

        if Texture = nil then
                exit;

        Result := Texture.Hoehe;
end;

function TCheckBox.GetBreite : Word;
var     Texture : TTexObject;
begin
        Result := 0;
        if Checked then
                Texture := Palanthir.Data.GetGumpTexture( TrueId )
        else
                Texture := Palanthir.Data.GetGumpTexture( FalseId );

        if Texture = nil then
                exit;

        Result := Texture.Breite;
end;

constructor TRadioButton.Create;
begin
        inherited Create;
        TrueId := Invalid_Id;
        FalseId := Invalid_Id;
        Typ := gt_RadioButton;
end;

destructor TRadioButton.Free;
begin
        if TrueId <> Invalid_Id then
                Palanthir.Data.DecGumpCache( TrueId );
        if FalseId <> Invalid_Id then
                Palanthir.Data.DecGumpCache( FalseId );
        inherited Free;
end;

procedure TRadioButton.Draw;
var     Texture : TTexObject;
begin
        if Checked then
                Texture := Palanthir.Data.GetGumpTexture( TrueId )
        else
                Texture := Palanthir.Data.GetGumpTexture( FalseId );

        if Texture = nil then
                exit;

        Renderer.DrawPixels( Gump.X+X, Gump.Y+Y, Texture );
        if DoMouseCheck then begin
                Palanthir.Maus.CheckGump( Gump.X+X, Gump.Y+Y, Texture.Breite, Texture.Hoehe, Self, Texture );
        end;
end;

procedure TRadioButton.SetTrueId( Id : Word );
begin
        if TrueId <> Invalid_Id then
                Palanthir.Data.DecGumpCache( TrueId );
        _TrueId := Id;
        Palanthir.Data.IncGumpCache( TrueId );
end;

procedure TRadioButton.SetFalseId( Id : Word );
begin
        if FalseId <> Invalid_Id then
                Palanthir.Data.DecGumpCache( FalseId );
        _FalseId := Id;
        Palanthir.Data.IncGumpCache( FalseId );
end;

procedure TRadioButton.onClick( X, Y : Word );
var     I : Integer;
        GumpObject : TGumpObject;
        RadioButton : TRadioButton;
begin
        inherited onClick( X, Y );
        Checked := not Checked;
        if Checked then begin
                for I := 0 to Gump.ObjektListe.Count-1 do begin
                        GumpObject := TGumpObject( Gump.ObjektListe.Items[I] );
                        if GumpObject.Typ = gt_RadioButton then begin
                                RadioButton := TRadioButton( GumpObject );
                                if (RadioButton.Group = Group) and (RadioButton <> Self) then
                                        RadioButton.Checked := False;
                        end;
                end;
        end;
end;

function TRadioButton.GetHoehe : Word;
var     Texture : TTexObject;
begin
        Result := 0;
        if Checked then
                Texture := Palanthir.Data.GetGumpTexture( TrueId )
        else
                Texture := Palanthir.Data.GetGumpTexture( FalseId );

        if Texture = nil then
                exit;

        Result := Texture.Hoehe;
end;

function TRadioButton.GetBreite : Word;
var     Texture : TTexObject;
begin
        Result := 0;
        if Checked then
                Texture := Palanthir.Data.GetGumpTexture( TrueId )
        else
                Texture := Palanthir.Data.GetGumpTexture( FalseId );

        if Texture = nil then
                exit;

        Result := Texture.Breite;
end;

constructor THtmlGump.Create;
begin
        inherited Create;
        _Text := '';
        Texture := nil;
        BackGround := nil;
        ScrollBar := nil;
        ScrollUp := nil;
        ScrollDown := nil;
        ScrollBackGround := nil;
        StartPos := 0;
        Typ := gt_HtmlGump;
end;

destructor THtmlGump.Free;
begin
        if Texture <> nil then
                Texture.Free;
        if BackGround <> nil then
                BackGround.Free;
        if ScrollBar <> nil then
                ScrollBar.Free;
        if ScrollUp <> nil then
                ScrollUp.Free;
        if ScrollDown <> nil then
                ScrollDown.Free;
        if ScrollBackGround <> nil then
                ScrollBackGround.Free;
        inherited Free;
end;

procedure THtmlGump.Draw;
begin
        if Texture = nil then
                exit;

        if canScroll then begin
                if ScrollBar = nil then begin
                        ScrollBar := TScrollBar.Create;
                        ScrollBar.Hoehe := Hoehe - 60;
                        ScrollBar.Breite := 20;
                        ScrollBar.X := X + Breite - 24;
                        ScrollBar.Y := Y + 30;
                        ScrollBar.UpId := $FE;
                        ScrollBar.MoveOverId := $FE;
                        ScrollBar.Promille := 0;
                        ScrollBar.Horizontal := False;
                        ScrollBar.Number := 1;
                        ScrollBar.Typ := gt_ScrollBar;
                        ScrollBar.Gump := Gump;
                        ScrollBar.HtmlGump := Self;
                        GetTexture;

                        ScrollBackGround := TTiledImage.Create( X + Breite - 25, Y + 30, Hoehe - 60, 17, $100, 0, 0 );
                        ScrollBackGround.Gump := Gump;

                        ScrollUp := TGumpButton.Create( X + Breite - 25, Y + 10, $FA, $FB, $FA, $7FFFFFFF, 0 );
                        ScrollUp.Gump := Gump;
                        ScrollUp.ScrollBar := ScrollBar;
                        ScrollBar.UpButton := ScrollUp;

                        ScrollDown := TGumpButton.Create( X + Breite - 25, Y + Hoehe - 30, $FC, $FD, $FC, $7FFFFFFF, 0 );
                        ScrollDown.Gump := Gump;
                        ScrollDown.ScrollBar := ScrollBar;
                        ScrollBar.DownButton := ScrollDown;
                end
                else begin
                        ScrollBar.X := X + Breite - 24;
                        ScrollBar.Y := Y + 30;
                        ScrollBackGround.X := X + Breite - 25;
                        ScrollBackGround.Y := Y + 30;
                        ScrollUp.X := X + Breite - 25;
                        ScrollUp.Y := Y + 10;
                        ScrollDown.X := X + Breite - 25;
                        ScrollDown.Y := Y + Hoehe - 30;
                end;
                ScrollBackGround.Draw;
                ScrollUp.Draw;
                ScrollDown.Draw;
                ScrollBar.Draw;
        end;

        if hasBack then begin
                if BackGround = nil then begin
                        BackGround := TResizeGump.Create;
                        BackGround.X := X;
                        BackGround.Y := Y;
                        BackGround.Breite := Breite;
                        BackGround.Hoehe := Hoehe;
                        BackGround.Gump := Gump;
                        BackGround.Id := $BB8;
                        BackGround.Typ := gt_ResizeGump;

                        Breite := Breite - 6;
                        Hoehe := Hoehe - 6;
                        GetTexture;
                end
                else begin
                        BackGround.X := X;
                        BackGround.Y := Y;
                end;
                BackGround.Draw;
        end;

        Renderer.DrawPixelsStartMax( Gump.X+X+3, Gump.Y+Y+3, Texture, 0, StartPos, Gump.X+X+Breite, Gump.Y+Y+Hoehe );
        if DoMouseCheck then begin
                Palanthir.Maus.CheckGump( Gump.X+X+3, Gump.Y+Y+3, Texture.Breite, Texture.Hoehe, Self, nil, True );
        end;
end;

procedure THtmlGump.SetText( Value : String );
begin
        if Text <> Value then begin
                _Text := Value;
                GetTexture;
        end;
end;

procedure THtmlGump.GetTexture;
begin
        if Texture <> nil then
                Texture.Free;
        if CanScroll then
                Texture := Palanthir.Data.GetUnicodeHtmlTexture( 1, Text, Breite-30 )
        else
                Texture := Palanthir.Data.GetUnicodeHtmlTexture( 1, Text, Breite );
end;

function THtmlGump.GetHoehe : Word;
begin
        Result := Hoehe;
end;

function THtmlGump.GetBreite : Word;
begin
        Result := Breite;
end;

function THtmlGump.GetTextureBreite : Word;
begin
        if Texture = nil then begin
                Result := 0;
        end
        else begin
                Result := Texture.Breite;
        end;
end;

function THtmlGump.GetTextureHoehe : Word;
begin
        if Texture = nil then begin
                Result := 0;
        end
        else begin
                Result := Texture.Hoehe;
        end;
end;

constructor TXmfHtmlGump.Create;
begin
        inherited Create;
        _Text := '';
        _ClilocID := 0;
        _Color := 0;
        Texture := nil;
        BackGround := nil;
        Typ := gt_XmfHtmlGump;
end;

destructor TXmfHtmlGump.Free;
begin
        if Texture <> nil then
                Texture.Free;
        if BackGround <> nil then
                BackGround.Free;
        inherited Free;
end;

procedure TXmfHtmlGump.Draw;
begin
        if Texture = nil then
                exit;

        if hasBack then begin
                if BackGround = nil then begin
                        BackGround := TResizeGump.Create;
                        BackGround.X := X;
                        BackGround.Y := Y;
                        BackGround.Breite := Breite;
                        BackGround.Hoehe := Hoehe;
                        BackGround.Gump := Gump;
                        BackGround.Id := $BB8;
                        BackGround.Typ := gt_ResizeGump;                        

                        Breite := Breite - 6;
                        Hoehe := Hoehe - 6;
                        GetTexture;
                end;
                BackGround.Draw;
        end;

        Renderer.DrawPixelsMax( Gump.X+X+3, Gump.Y+Y+3, Texture, Gump.X+X+Breite, Gump.Y+Y+Hoehe );
        if DoMouseCheck then begin
                Palanthir.Maus.CheckGump( Gump.X+X+3, Gump.Y+Y+3, Texture.Breite, Texture.Hoehe, Self, nil, True );
        end;
end;

procedure TXmfHtmlGump.SetClilocID( Value : LongWord );
begin
        if Value <> ClilocID then begin
                _ClilocID := Value;
                _Text := Palanthir.Data.GetClilocMessage( ClilocID );
                GetTexture;
        end;
end;

procedure TXmfHtmlGump.SetColor( Value : Word );
begin
        if Value <> Color then begin
                _Color := Value;
                if _Text <> '' then
                        GetTexture;
        end;
end;

procedure TXmfHtmlGump.GetTexture;
begin
        if Texture <> nil then
                Texture.Free;
        Texture := Palanthir.Data.GetUnicodeHtmlTexture( 1, Text, Breite, Color );
end;

function TXmfHtmlGump.GetHoehe : Word;
begin
        Result := Hoehe;
end;

function TXmfHtmlGump.GetBreite : Word;
begin
        Result := Breite;
end;

constructor TCheckerTrans.Create;
begin
        inherited Create;

        Breite := 0;
        Hoehe := 0;
        Texture := nil;
        Gump := nil;
        Typ := gt_CheckerTrans;
end;

destructor TCheckerTrans.Free;
begin
        if Texture <> nil then
                Texture.Free;

        inherited Free;
end;

procedure TCheckerTrans.Resize( Breite, Hoehe : Integer );
var     PX, PY : Integer;
        ClearPixel, Pixel : PByteArray;
        Count, TmpCount : LongWord;
begin
        if (Breite < 0) or (Breite > $FFFF) or (Hoehe < 0) or (Hoehe > $FFFF) then begin
                Log.Write( Format( 'Resize CheckerTrans: Illegal Size Height %d Width %d', [Hoehe,Breite] ) );
                exit;
        end;

        Self.Breite := Breite;
        Self.Hoehe := Hoehe;

        if Texture <> nil then begin
                Texture.Free;
                Texture := nil;
        end;
        if ClearTexture <> nil then begin
                ClearTexture.Free;
                ClearTexture := nil;
        end;

        Count := GetNextBit( Breite )*GetNextBit( Hoehe )*4;
        GetMem( Pixel, Count );

        for PY := 0 to Hoehe-1 do begin
                for PX := 0 to Breite-1 do begin
                        TmpCount := (PY*GetNextBit( Breite )+PX)*4;
                        if (PX mod 2 = 1) and (PY mod 2 = 1) then begin
                                Pixel^[ TmpCount ] := 255;
                                Pixel^[ TmpCount+1 ] := 255;
                                Pixel^[ TmpCount+2 ] := 255;
                                Pixel^[ TmpCount+3 ] := 255;
                        end
                        else begin
                                Pixel^[ TmpCount ] := 0;
                                Pixel^[ TmpCount+1 ] := 0;
                                Pixel^[ TmpCount+2 ] := 0;
                                Pixel^[ TmpCount+3 ] := 0;
                        end;
                end;
        end;

        Texture := Renderer.CreateTexture32( Tex_Checker, Breite, Hoehe, Pixel );
        FreeMem( Pixel );

        GetMem( ClearPixel, Count );
        for PY := 0 to Hoehe-1 do begin
                for PX := 0 to Breite-1 do begin
                        TmpCount := (PY*GetNextBit( Breite )+PX)*4;
                        ClearPixel^[ TmpCount ] := 0;
                        ClearPixel^[ TmpCount+1 ] := 0;
                        ClearPixel^[ TmpCount+2 ] := 0;
                        ClearPixel^[ TmpCount+3 ] := 255;
                end;
        end;

        ClearTexture := Renderer.CreateTexture32( Tex_Checker, Breite, Hoehe, ClearPixel );
        FreeMem( ClearPixel );
end;

procedure TCheckerTrans.InitDraw;
begin
        if Texture = nil then
                exit;

        glColorMask( False, False, False, False );

        glStencilFunc( GL_ALWAYS, 1, 1 );
	glStencilOp( GL_KEEP, GL_KEEP, GL_REPLACE );

        Renderer.DrawPixels( Gump.X + X, Gump.Y + Y, Texture );

        glColorMask( True, True, True, True );
	glStencilOp( GL_KEEP, GL_KEEP, GL_KEEP );
        glStencilFunc( GL_NOTEQUAL, 1, 1 );
end;

procedure TCheckerTrans.Draw;
begin
        if ClearTexture = nil then
                exit;

        glColorMask( False, False, False, False );

        glStencilFunc( GL_ALWAYS, 1, 1 );
	glStencilOp( GL_KEEP, GL_KEEP, GL_ZERO );

        Renderer.DrawPixels( Gump.X + X, Gump.Y + Y, ClearTexture );

        glColorMask( True, True, True, True );
	glStencilOp( GL_KEEP, GL_KEEP, GL_KEEP );
        glStencilFunc( GL_NOTEQUAL, 1, 1 );
end;

function TCheckerTrans.GetHoehe : Word;
begin
        Result := Hoehe;
end;

function TCheckerTrans.GetBreite : Word;
begin
        Result := Breite;
end;

constructor TGumpItem.Create;
begin
        inherited Create;
        ItemSerial := Invalid_Serial;
        Typ := gt_GumpItem;
        Texture := nil;
        Blendfactor := 255;
        HasItem := True;
end;

destructor TGumpItem.Free;
begin
        if Texture <> nil then
                Palanthir.Data.DecGumpCache( Texture.ID, Texture.Hue );
        inherited Free;
end;

procedure TGumpItem.Draw;
var     Id, Hue : Word;
        Item : TItem;
        Char : TChar;
        Weiblich : Boolean;
begin
        if HasItem then begin
                if ItemSerial = Invalid_Serial then begin
                        exit;
                end;

                Item := TItem( Palanthir.Data.GlobalObjectList.GetObject( ItemSerial ) );
                if Item = nil then
                        exit;

                Weiblich := False;
                if (Item.Container <> nil) and Item.Container.IsChar then begin
                        Char := TChar( Item.Container );
                        if (Char.GetAnimId = $191) or (Char.GetAnimId = $24B) or (Char.GetAnimId = $24D) or (Char.GetAnimId = $24F) or (Char.GetAnimId = $251) or (Char.GetAnimId = $253) or (Char.GetAnimId = $255) or (Char.GetAnimId = $257) then begin
                                Weiblich := True;
                        end;
                end;

                if Palanthir.Data.Tiledata.GetStaticFlag( Item.ID, dPARTIALHUE ) then
                        Hue := Item.Color+$8000
                else
                        Hue := Item.Color;

                if Weiblich then begin
                        Id := Palanthir.Data.Tiledata.GetStaticAnimId( Item.ID ) + 60000;

                        if (Texture = nil) or (Texture.ID <> Id) or (Texture.Hue <> Hue) then begin
                                if Texture <> nil then
                                        Palanthir.Data.DecGumpCache( Texture.ID, Texture.Hue );

                                Texture := Palanthir.Data.GetGumpTexture( Id, Hue );

                                if Texture = nil then begin
                                        Id := Palanthir.Data.Tiledata.GetStaticAnimId( Item.ID ) + 50000;
                                        Texture := Palanthir.Data.GetGumpTexture( Id, Hue );
                                end;

                                if Texture <> nil then
                                        Palanthir.Data.IncGumpCache( Texture.ID, Texture.Hue );
                        end;
                end
                else begin
                        Id := Palanthir.Data.Tiledata.GetStaticAnimId( Item.ID ) + 50000;

                        if (Texture = nil) or (Texture.ID <> Id) or (Texture.Hue <> Hue) then begin
                                if Texture <> nil then
                                        Palanthir.Data.DecGumpCache( Texture.ID, Texture.Hue );

                                Texture := Palanthir.Data.GetGumpTexture( Id, Hue );

                                if Texture <> nil then
                                        Palanthir.Data.IncGumpCache( Texture.ID, Texture.Hue );
                        end;
                end;

                if Texture = nil then
                        exit;

                if Item.Speech <> nil then begin
                        if Speech <> nil then begin
                                Speech.Free;
                        end;

                        Speech := TSpeech.Create;
                        Speech.SetGumpObjectType;
                        Speech.UObject := Self;

                        Speech.AddSpeech( Item.Speech );
                        Palanthir.RemoveSpeech( Item.Speech );
                        Item.Speech.Free;
                end;
        end
        else begin
                Weiblich := False;
                if (Gump <> nil) and (Gump.Typ = GumpTyp_Paperdoll) then begin
                        Char := TChar( Palanthir.Data.GlobalObjectList.GetObject( TPaperdoll( Gump ).CharSerial ) );

                        if (Char <> nil) and ((Char.ID = $191) or (Char.ID = $24B) or (Char.ID = $24D) or (Char.ID = $24F) or (Char.ID = $251) or (Char.ID = $253) or (Char.ID = $255) or (Char.ID = $257)) then begin
                                Weiblich := True;
                        end;
                end;

                if Palanthir.Data.Tiledata.GetStaticFlag( InternalID, dPARTIALHUE ) then
                        Hue := InternalHue+$8000
                else
                        Hue := InternalHue;

                if Weiblich then begin
                        Id := Palanthir.Data.Tiledata.GetStaticAnimId( InternalID ) + 60000;

                        if (Texture = nil) or (Texture.ID <> Id) or (Texture.Hue <> Hue) then begin
                                if Texture <> nil then
                                        Palanthir.Data.DecGumpCache( Texture.ID, Texture.Hue );

                                Texture := Palanthir.Data.GetGumpTexture( Id, Hue );

                                if Texture = nil then begin
                                        Id := Palanthir.Data.Tiledata.GetStaticAnimId( InternalID ) + 50000;
                                        Texture := Palanthir.Data.GetGumpTexture( Id, Hue );
                                end;

                                if Texture <> nil then
                                        Palanthir.Data.IncGumpCache( Texture.ID, Texture.Hue );
                        end;
                end
                else begin
                        Id := Palanthir.Data.Tiledata.GetStaticAnimId( InternalID ) + 50000;

                        if (Texture = nil) or (Texture.ID <> Id) or (Texture.Hue <> Hue) then begin
                                if Texture <> nil then
                                        Palanthir.Data.DecGumpCache( Texture.ID, Texture.Hue );

                                Texture := Palanthir.Data.GetGumpTexture( Id, Hue );

                                if Texture <> nil then
                                        Palanthir.Data.IncGumpCache( Texture.ID, Texture.Hue );
                        end;
                end;

                if Texture = nil then
                        exit;                
        end;

        Renderer.DrawPixelsTransp( Gump.X+X, Gump.Y+Y, Texture, BlendFactor );
        if DoMouseCheck then begin
                Palanthir.Maus.CheckGump( Gump.X+X, Gump.Y+Y, Texture.Breite, Texture.Hoehe, Self, Texture );
        end;
end;

procedure TGumpItem.onDblClick( X, Y : Word );
var     Item : TItem;
begin
        Item := TItem( Palanthir.Data.GlobalObjectList.GetObject( ItemSerial ) );
        if Item = nil then
                exit;

        Item.OnDblClick;
end;

procedure TGumpItem.onClick( X, Y : Word );
var     Item : TItem;
begin
        inherited onClick( X, Y );
        
        Item := TItem( Palanthir.Data.GlobalObjectList.GetObject( ItemSerial ) );
        if Item = nil then
                exit;

        Palanthir.SetForeGroundGump( Gump );

        Item.OnClick;
end;

function TGumpItem.GetId : Word;
var     Item : TItem;
begin
        if HasItem then begin
                Item := TItem( Palanthir.Data.GlobalObjectList.GetObject( ItemSerial ) );
                if Item <> nil then begin
                        Result := Item.ID;
                end else begin
                        Result := InternalId;
                end;
        end
        else begin
                Result := InternalId;
        end;
end;

function TGumpItem.GetHue : Word;
var     Item : TItem;
begin
        if HasItem then begin
                Item := TItem( Palanthir.Data.GlobalObjectList.GetObject( ItemSerial ) );
                if Item <> nil then begin
                        Result := Item.Color;
                end else begin
                        Result := InternalHue;
                end;
        end
        else begin
                Result := InternalHue;
        end;
end;

function TGumpItem.GetLayer : Word;
var     Item : TItem;
begin
        if HasItem then begin
                Item := TItem( Palanthir.Data.GlobalObjectList.GetObject( ItemSerial ) );
                if Item <> nil then begin
                        Result := Item.Layer;
                end else begin
                        Result := InternalLayer;
                end;
        end
        else begin
                Result := InternalLayer;
        end;
end;

function TGumpItem.GetSerial : LongWord;
var     Item : TItem;
begin
        if HasItem then begin
                Item := TItem( Palanthir.Data.GlobalObjectList.GetObject( ItemSerial ) );
                if Item <> nil then begin
                        Result := Item.Serial;
                end else begin
                        Result := Invalid_Serial;
                end;
        end
        else begin
                Result := Invalid_Serial;
        end;
end;

procedure TGumpItem.SetId( Id : Word );
begin
        InternalId :=Id;
end;

procedure TGumpItem.SetHue( Hue : Word );
begin
        InternalHue := Hue;
end;

procedure TGumpItem.SetLayer( Layer : Word );
begin
        InternalLayer := Layer;
end;

procedure TGumpItem.SetSerial( Serial : LongWord );
begin
        ItemSerial := Serial;
end;

constructor TGumpStaticItem.Create;
begin
        inherited Create;
        ItemSerial := Invalid_Serial;
        Typ := gt_GumpStaticItem;
        Texture := nil;
        MultiId := Invalid_Id;
        MultiColor := 0;
        Multi := nil;
        SelectedMulti := nil;
end;

destructor TGumpStaticItem.Free;
begin
        if Texture <> nil then
                Palanthir.Data.DecStaticArt( Texture.Id-$4000, Texture.Hue );

        if Multi <> nil then
                Multi.Free;

        if SelectedMulti <> nil then
                SelectedMulti.Free;

        inherited Free;
end;

procedure TGumpStaticItem.Draw;
var     Hue, AmountId, DrawId : Word;
        Item : TItem;
begin
        if ItemSerial = Invalid_Serial then begin
                exit;
        end;

        Item := TItem( Palanthir.Data.GlobalObjectList.GetObject( ItemSerial ) );
        if Item = nil then
                exit;

        if (Item.ID >= Palanthir.FirstMultiID) and (Item.ID <= Palanthir.LastMultiID) then begin
                if (Multi = nil) or (MultiId <> Item.Id) or (MultiColor <> Item.Color) then begin
                        if Multi <> nil then begin
                                Multi.Free;
                                Multi := nil;
                        end;

                        Multi := Palanthir.Data.GetMultiAsPixelBuffer( Item.Id-Palanthir.FirstMultiID, Item.Color );
                        if Multi = nil then begin
                                exit;
                        end;

                        SelectedMulti := Palanthir.Data.GetMultiAsPixelBuffer( Item.Id-Palanthir.FirstMultiID, SelectionColor );

                        MultiId := Item.Id;
                        MultiColor := Item.Color;
                end;

                if Palanthir.Maus.SelectedGumpObject = Self then
                        SelectedMulti.Bind
                else
                        Multi.Bind;

                glColor3f( 1, 1, 1 );

                glBegin( gl_Quads );
                        glTexCoord2f( 0, 0 );
                        glVertex2f( Gump.X+X, Gump.Y+Y );
                        glTexCoord2f( 0, 1 );
                        glVertex2f( Gump.X+X, Gump.Y+Y + Multi.Height );
                        glTexCoord2f( 1, 1 );
                        glVertex2f( Gump.X+X + Multi.Width, Gump.Y+Y + Multi.Height );
                        glTexCoord2f( 1, 0 );
                        glVertex2f( Gump.X+X + Multi.Width, Gump.Y+Y );
                glEnd;

                if Palanthir.Maus.SelectedGumpObject = Self then
                        SelectedMulti.Release
                else
                        Multi.Release;

                if DoMouseCheck then begin
                        Palanthir.Maus.CheckGump( Gump.X+X, Gump.Y+Y, Multi.Width, Multi.Height, Self, Multi.BitMask );
                end;
        end
        else begin
                if Palanthir.Maus.SelectedGumpObject = Self then
                        Hue := SelectionColor
                else
                        Hue := Item.Color;

                DrawId := Item.Id;

                if Item.Amount > 1 then begin
                        AmountId := Palanthir.Shard.GetAmountId( Item.ID, Item.Amount );
                        if AmountId > 0 then
                                DrawId := AmountId;
                end;

                if (Texture = nil) or (DrawId <> Texture.Id) or (Hue <> Texture.Hue) then begin
                        if Texture <> nil then begin
                                Palanthir.Data.DecStaticArt( Texture.ID-$4000, Texture.Hue );
                                Palanthir.Data.DecStaticArt( Texture.ID-$4000, SelectionColor );
                        end;

                        Texture := Palanthir.Data.GetStaticArt( DrawId, Hue );

                        if Texture <> nil then begin
                                Palanthir.Data.IncStaticArt( Texture.Id-$4000, Texture.Hue );
                                Palanthir.Data.IncStaticArt( texture.Hue-$4000, SelectionColor );
                        end;
                end;

                if Texture = nil then
                        exit;

                if (Item.Amount = 1) or (AmountId > 0) then begin
                        Renderer.DrawPixels( Gump.X+X, Gump.Y+Y, Texture );
                        if DoMouseCheck then begin
                                Palanthir.Maus.CheckGump( Gump.X+X, Gump.Y+Y, Texture.Breite, Texture.Hoehe, Self, Texture );
                        end;
                end
                else begin
                        Renderer.DrawPixels( Gump.X+X-2, Gump.Y+Y-5, Texture );
                        Renderer.DrawPixels( Gump.X+X+3, Gump.Y+Y, Texture );
                        if DoMouseCheck then begin
                                Palanthir.Maus.CheckGump( Gump.X+X-2, Gump.Y+Y-5, Texture.Breite, Texture.Hoehe, Self, Texture );
                                Palanthir.Maus.CheckGump( Gump.X+X+3, Gump.Y+Y, Texture.Breite, Texture.Hoehe, Self, Texture );
                        end;
                end;
        end;

        if Item.Speech <> nil then begin
                if Speech <> nil then begin
                        Speech.Free;
                end;

                Speech := TSpeech.Create;
                Speech.SetGumpObjectType;
                Speech.UObject := Self;

                Speech.AddSpeech( Item.Speech );
                Palanthir.RemoveSpeech( Item.Speech );
                Item.Speech.Free;
        end;
end;

procedure TGumpStaticItem.onDblClick( X, Y : Word );
var     Item : TItem;
begin
        Item := TItem( Palanthir.Data.GlobalObjectList.GetObject( ItemSerial ) );
        if Item = nil then
                exit;
        
        Item.OnDblClick;
end;

procedure TGumpStaticItem.onClick( X, Y : Word );
var     Item : TItem;
begin
        inherited onClick( X, Y );

        Item := TItem( Palanthir.Data.GlobalObjectList.GetObject( ItemSerial ) );
        if Item = nil then
                exit;

        Palanthir.SetForeGroundGump( Gump );

        Item.OnClick;
end;

procedure TScrollBar.SetUpId( Id : Word );
begin
        if UpId <> Id then begin
                if UpId <> Invalid_ID then
                        Palanthir.Data.DecGumpCache( UpId );
                _UpId := Id;
                if MoveOverId = Invalid_ID then
                        MoveOverID := UpId;
                Palanthir.Data.IncGumpCache( UpId );
        end;
end;

procedure TScrollBar.SetMoveOverId( Id : Word );
begin
        if MoveOverId <> Id then begin
                if MoveOverId <> Invalid_ID then
                        Palanthir.Data.DecGumpCache( MoveOverId );
                _MoveOverId := Id;
                Palanthir.Data.IncGumpCache( MoveOverId );
        end;
end;

constructor TScrollBar.Create;
begin
        inherited Create;
        
        _UpId := Invalid_Id;
        _MoveOverId := Invalid_Id;
        Promille := 0;
        Horizontal := False;
        Fixed := False;
        UpButton := nil;
        DownButton := nil;
        HtmlGump := nil;
        Typ := gt_ScrollBar;
end;

destructor TScrollBar.Free;
begin
        if UpId <> Invalid_ID then
                Palanthir.Data.DecGumpCache( UpId );
        if MoveOverId <> Invalid_ID then
                Palanthir.Data.DecGumpCache( MoveOverId );
        inherited Free;
end;

procedure TScrollBar.SetOver( Over : Boolean );
begin
        MausOver := Over;
end;

procedure TScrollBar.onUp;
begin
        Gump.OnScrollBarRelease( Self );
end;

procedure TScrollBar.Draw;
var     Texture : TTexObject;
        PX, PY : Integer;
begin
        if MausOver then
                Texture := Palanthir.Data.GetGumpTexture( MoveOverId )
        else
                Texture := Palanthir.Data.GetGumpTexture( UpId );

        if Texture = nil then
                exit;

        if Horizontal then begin
                PX := Gump.X + X + Round( ( Breite - Texture.Breite )*Promille / 1000 );
                PY := Gump.Y + Y;
        end
        else begin
                PX := Gump.X + X;
                PY := Gump.Y + Y + Round( ( Hoehe - Texture.Hoehe )*Promille / 1000 );
        end;

        Renderer.DrawPixels( PX, PY, Texture );
        if DoMouseCheck then begin
                Palanthir.Maus.CheckGump( PX, PY, Texture.Breite, Texture.Hoehe, Self, Texture );
        end;
end;

function TScrollBar.OnButton( Button : TGumpButton ) : Boolean;
begin
        if Button = UpButton then begin
                if Promille > 0 then
                        Promille := Max( Promille - 50, 0 );
                Change;
                Result := True;
        end
        else if Button = DownButton then begin
                if Promille < 1000 then
                        Promille := Min( Promille + 50, 1000 );
                Change;
                Result := True;
        end
        else begin
                Result := True;
        end;
end;

function TScrollBar.GetTexHoehe : Word;
var     Texture : TTexObject;
begin
        if MausOver then
                Texture := Palanthir.Data.GetGumpTexture( MoveOverId )
        else
                Texture := Palanthir.Data.GetGumpTexture( UpId );

        if Texture = nil then
                Result := 0
        else
                Result := Texture.Hoehe;
end;

procedure TScrollBar.Change;
begin
        if HtmlGump <> nil then begin
                HtmlGump.StartPos := Min( Max( HtmlGump.Texture.Hoehe - HtmlGump.Hoehe, 0 ), Max( 0, Round((HtmlGump.Texture.Hoehe - HtmlGump.Hoehe)*Promille/1000) ) );
        end
        else begin
                Gump.OnScrollBar( Self );
        end;
end;

function TScrollBar.GetHoehe : Word;
begin
        Result := Hoehe;
end;

function TScrollBar.GetBreite : Word;
begin
        Result := Breite;
end;

procedure TProgressBar.SetText( Text : String );
begin
        if _Text <> Text then begin
                TmpText := Text;
        end;
end;

procedure TProgressBar.SetTextColor( Color : LongWord );
begin
        if _TextColor <> Color then begin
                TmpTextColor := Color;
        end;
end;

constructor TProgressBar.Create;
begin
        inherited Create;
        Typ := gt_ProgressBar;
        Hoehe := 0;
        Breite := 0;
        _Text := '';
        TmpText := '';
        _TextColor := 0;
        TmpTextColor := 0;
        Texture := nil;
        BackLeftColor := 0;
        BackRightColor := 0;
        LeftColor := 0;
        RightColor := 0;
        Waagerecht := True;
        Align := 'LEFT';
        Current := 0;
        Max := 0;
end;

constructor TProgressBar.Create( X, Y : Integer; Breite, Hoehe : Word; Current, Max, BackLeftColor, BackRightColor, LeftColor, RightColor : LongWord; Text, Align : String; TextColor : LongWord; Waagerecht : Boolean; Page : Word );
begin
        Self := TProgressBar.Create;
        Self.X := X;
        Self.Y := Y;
        Self.Breite := Breite;
        Self.Hoehe := Hoehe;
        Self.BackLeftColor := BackLeftColor;
        Self.BackRightColor := BackRightColor;        
        Self.LeftColor := LeftColor;
        Self.RightColor := RightColor;
        Self.Text := Text;
        Self.TextColor := TextColor;
        Self.Align := Align;
        Self.Page := Page;
        Self.Waagerecht := Waagerecht;
        Self.Max := Max;
        if Current > Max then
                Self.Current := Max
        else
                Self.Current := Current;
end;

destructor TProgressBar.Free;
begin
        if Texture <> nil then
                Texture.Free;

        inherited Free;
end;

procedure TProgressBar.Draw;
begin
        if (TmpTextColor <> TextColor) or (TmpText <> Text) then begin
                _TextColor := TmpTextColor;
                _Text := TmpText;        
                GetTexture;
        end;

        if (BackLeftColor <> 0) and (BackRightColor <> 0) then begin
                if Waagerecht then begin
                        Renderer.DrawRectangleGradientHorizontal( Gump.X + X, Gump.Y + Y, Hoehe, Breite, (BackLeftColor and $00FF0000) shr 16, (BackLeftColor and $0000FF00) shr 8, BackLeftColor and $000000FF, (BackRightColor and $00FF0000) shr 16, (BackRightColor and $0000FF00) shr 8, BackRightColor and $000000FF );
                end
                else begin
                        Renderer.DrawRectangleGradientVertical( Gump.X + X, Gump.Y + Y, Hoehe, Breite, (BackLeftColor and $00FF0000) shr 16, (BackLeftColor and $0000FF00) shr 8, BackLeftColor and $000000FF, (BackRightColor and $00FF0000) shr 16, (BackRightColor and $0000FF00) shr 8, BackRightColor and $000000FF );
                end;
        end;

        if Waagerecht then begin
                Renderer.DrawRectangleGradientHorizontal( Gump.X + X, Gump.Y + Y, Hoehe, Round( Breite * Current / Max ), (LeftColor and $00FF0000) shr 16, (LeftColor and $0000FF00) shr 8, LeftColor and $000000FF, (RightColor and $00FF0000) shr 16, (RightColor and $0000FF00) shr 8, RightColor and $000000FF );
        end
        else begin
                Renderer.DrawRectangleGradientVertical( Gump.X + X, Gump.Y + Y, Round( Hoehe * Current / Max ), Breite, (LeftColor and $00FF0000) shr 16, (LeftColor and $0000FF00) shr 8, LeftColor and $000000FF, (RightColor and $00FF0000) shr 16, (RightColor and $0000FF00) shr 8, RightColor and $000000FF );
        end;

        if Texture <> nil then begin
                if UpperCase( Align ) = 'RIGHT' then begin
                        Renderer.DrawPixels( Gump.X + X + Breite - Texture.Breite, Gump.Y + Y + Ceil(( Hoehe - Texture.Hoehe ) / 2), Texture );
                end
                else if UpperCase( Align ) = 'CENTER' then begin
                        Renderer.DrawPixels( Gump.X + X + ((Breite - Texture.Breite) div 2), Gump.Y + Y + Ceil(( Hoehe - Texture.Hoehe ) / 2), Texture );
                end
                else begin      //Left
                        Renderer.DrawPixels( Gump.X + X, Gump.Y + Y + Ceil(( Hoehe - Texture.Hoehe ) / 2), Texture );
                end;
        end;

        if DoMouseCheck then begin
                Palanthir.Maus.CheckGump( X, Y, Breite, Hoehe, Self, nil, True );
        end;
end;

function TProgressBar.GetHoehe : Word;
begin
        Result := Hoehe;
end;

function TProgressBar.GetBreite : Word;
begin
        Result := Breite;
end;

procedure TProgressBar.GetTexture;
var     TempText : String;
begin
        if Texture <> nil then
                Texture.Free;

        TempText := Format( '<BASEFONT COLOR=#%.6x>%s</BASEFONT>', [TextColor,Text] );

        Texture := Palanthir.Data.GetUnicodeHtmlTexture( 0, TempText, Breite );
end;

constructor TExtImage.Create;
begin
        inherited Create;
        Texture := nil;
        CriticalSection := TCriticalSection.Create;
        Thread := nil;
        Typ := gt_ExtImage;
        Pixel := nil;

        LoadingStep := 0;
        LoadingTimer := CustomGetTickCount;

        LoadingTextures[0] := Palanthir.Data.GetUnicodeTexture( 0, 'Loading', $481, 200 );
        LoadingTextures[1] := Palanthir.Data.GetUnicodeTexture( 0, 'Loading.', $481, 200 );
        LoadingTextures[2] := Palanthir.Data.GetUnicodeTexture( 0, 'Loading..', $481, 200 );
        LoadingTextures[3] := Palanthir.Data.GetUnicodeTexture( 0, 'Loading...', $481, 200 );
end;

constructor TExtImage.Create( X, Y : Integer; Breite, Hoehe : Word; Location : String );
begin
        Self := TExtImage.Create;
        Self.X := X;
        Self.Y := Y;
        Self.Breite := Breite;
        Self.Hoehe := Hoehe;
        Thread := TExtImageLoadThread.Create( True, Self, Palanthir.Shard.Dir + 'images\', Location );
        Thread.Resume;
end;

destructor TExtImage.Free;
begin
        if Thread <> nil then begin
                Thread.SetExtImage( nil );
        end;

        if Texture <> nil then
                Texture.Free;
        CriticalSection.Free;

        inherited Free;
end;

procedure TExtImage.Draw;
var     LoadTex : TTexObject;
begin
        if Texture = nil then begin
                if CustomGetTickCount > LoadingTimer + 1000 then begin
                        LoadingTimer := CustomGetTickCount;
                        LoadingStep := ( LoadingStep + 1 ) mod 4;
                end;

                LoadTex := LoadingTextures[LoadingStep];
                Renderer.DrawPixels( Gump.X + X, Gump.Y + Y, LoadTex );
                if DoMouseCheck then begin
                        Palanthir.Maus.CheckGump( Gump.X + X, Gump.Y + Y, LoadTex.Breite, LoadTex.Hoehe, Self, LoadTex );
                end;
        end
        else begin
                if Pixel <> nil then begin
                        Texture := Renderer.CreateTexture32( Tex_ExtArt, Breite, Hoehe, Pixel );
                        FreeMem( Pixel );
                        Pixel := nil;
                end;

                Renderer.DrawPixels( Gump.X + X, Gump.Y + Y, Texture );
                if DoMouseCheck then begin
                        Palanthir.Maus.CheckGump( Gump.X + X, Gump.Y + Y, Texture.Breite, Texture.Hoehe, Self, Texture, True );
                end;
        end;
end;

function TExtImage.GetHoehe : Word;
begin
        Result := Hoehe;
end;

function TExtImage.GetBreite : Word;
begin
        Result := Breite;
end;

function TExtImage.GetTexture : TTexObject;
begin
        CriticalSection.Enter;
        Result := Texture;
        CriticalSection.Leave;
end;

procedure TExtImage.SetTexture( Breite, Hoehe : Word; Pixel : PByteArray );
begin
        CriticalSection.Enter;
        Self.Breite := Breite;
        Self.Hoehe := Hoehe;
        Self.Pixel := Pixel;
        CriticalSection.Leave;
end;

constructor TExtImageLoadThread.Create( CreateSuspended : Boolean; ExtImage : TExtImage; Dir, URL : String );
begin
        inherited Create( CreateSuspended );
        Self.ExtImage := ExtImage;
        Self.URL := URL;
        Self.Dir := Dir;
        CriticalSection := TCriticalSection.Create;
end;

destructor TExtImageLoadThread.Free;
begin
        CriticalSection.Free;
        inherited Free;
end;

procedure TExtImageLoadThread.Execute;
var     Bitmap : TBitmap;
        JPG : TJPEGImage;
        Typ : String;
        FileName : String;
        Pixel : PByteArray;
        RBreite, RHoehe : Integer;
        X, Y, Count, I : Integer;
        Color : TColor;
        HTTP : TIdHTTP;
        FStream : TFileStream;
        Loaded : Boolean;
begin
        if Pos( 'http', LowerCase( URL ) ) = 1 then begin
                Loaded := True;

                HTTP := TIdHTTP.Create( nil );
                HTTP.RedirectMaximum := 100;
                HTTP.HandleRedirects := True;

                HTTP.Request.ContentRangeStart := 0;
                Typ := LowerCase( ExtractFileExt( URL ) );

                I := 0;
                while FileExists( Format( '%stemp%d%s', [Dir,I,Typ] ) ) do begin
                        Inc( I );
                end;
                FileName := Format( '%stemp%d%s', [Dir,I,Typ] );

                FStream := TFileStream.Create( FileName, fmCreate );
                FStream.Seek( 0, soFromBeginning );
                try
                        HTTP.Get( URL, FStream );
                except
                        FStream.Free;
                        DeleteFile( FileName );
                        HTTP.Free;
                        Exit;
                end;

                FStream.Free;
        end
        else begin
                Loaded := False;
                FileName := Dir + URL;
        end;

        Typ := LowerCase( ExtractFileExt( FileName ) );

        Bitmap := TBitmap.Create;

        if Typ = '.bmp' then begin
                try
                        Bitmap.LoadFromFile( FileName );
                except
                        Bitmap.Free;
                        Exit;
                end;
        end
        else if (Typ = '.jpg') or (Typ = '.jpeg') then begin
                JPG := TJPEGImage.Create;
                try
                        JPG.LoadFromFile( FileName );

                        Bitmap.Width := JPG.Width;
                        Bitmap.Height := JPG.Height;
                        Bitmap.Canvas.Draw( 0, 0, JPG );
                        JPG.Free;
                except
                        JPG.Free;
                        Bitmap.Free;
                        Exit;
                end;
        end;

        RBreite := GetNextBit( Bitmap.Width );
        RHoehe := GetNextBit( Bitmap.Height );
        GetMem( Pixel, RBreite*RHoehe*4 );

        for Y := 0 to Bitmap.Height-1 do begin
                for X := 0 to Bitmap.Width-1 do begin
                        Color := Bitmap.Canvas.Pixels[X,Y];
                        Count := (Y*RBreite + X)*4;

                        Pixel^[ Count ] := Color and $FF;
                        Pixel^[ Count+1 ] := ( Color and $FF00 ) shr 8;
                        Pixel^[ Count+2 ] := ( Color and $FF0000 ) shr 16;
                        Pixel^[ Count+3 ] := 255;
                end;
        end;

        CriticalSection.Enter;
        if ExtImage <> nil then begin
                ExtImage.SetTexture( Bitmap.Width, Bitmap.Height, Pixel );
        end;
        CriticalSection.Leave;

        Bitmap.Free;

        if Loaded then begin
                DeleteFile( FileName );
        end;
end;

procedure TExtImageLoadThread.SetExtImage( ExtImage : TExtImage );
begin
        CriticalSection.Enter;
        Self.ExtImage := ExtImage;
        CriticalSection.Leave;
end;

constructor TGumpTooltip.Create;
begin
        inherited Create;
        Typ := gt_GumpTooltip;
        Breite := 0;
        Hoehe := 0;
end;

constructor TGumpTooltip.Create( X, Y : Integer; Breite, Hoehe : Word; Text : String; Page : Word );
begin
        Self := TGumpTooltip.Create;
        Self.X := X;
        Self.Y := Y;
        Self.Breite := Breite;
        Self.Hoehe := Hoehe;
        Self.Tooltip := Text;
        Self.Page := Page;
        Self.Gump := nil;
end;

constructor TGump.Create;
begin
        InternalID := Palanthir.GetNewGumpId;
        ObjektListe := TList.Create;
        SpeechCache := TList.Create;
        ActivePage := 1;
        noMove := False;
        noClose := False;
        noDispose := False;
        X := Palanthir.GumpDefaultX;
        Y := Palanthir.GumpDefaultY;
        ClearPercent := 0;
        ClearTick := $FFFFFFFF;
        FadeBuffer := nil;
        BBEnabled := False;
        GlobalAlpha := 255;

        Counter.IncCount( Count_Gump );

        Palanthir.GlobalGumpList.Add( Self );
end;

destructor TGump.Free;
var     I : Integer;
begin
        for I := 0 to Palanthir.GlobalGumpList.Count-1 do begin
                if TGump( Palanthir.GlobalGumpList.Items[ I ] ) = Self then begin
                        Palanthir.GlobalGumpList.Delete( I );
                        Break;
                end;
        end;

        Counter.DecCount( Count_Gump );

        while ObjektListe.Count > 0 do begin
                TGumpObject( ObjektListe.Items[0] ).Free;
                ObjektListe.Delete( 0 );
        end;
        
        ObjektListe.Free;
        SpeechCache.Free;

        if FadeBuffer <> nil then
                FadeBuffer.Destroy;
end;

function TGump.AddButton( X, Y : Integer; UpId, DownId, MoveOverId : Word; ReturnNumber : Integer; Page : Word; CheckCompleteRectangle : Boolean ) : TGumpButton;
var     Button : TGumpButton;
begin
        Button := TGumpButton.Create;
        Button.X := X;
        Button.Y := Y;
        Button.UpId := UpId;
        Button.DownId := DownId;
        Button.MoveOverId := MoveOverId;
        Button.Page := Page;
        Button.ReturnNumber := ReturnNumber;
        Button.Typ := gt_Button;
        Button.Down := False;
        Button.CheckCompleteRectangle := CheckCompleteRectangle;
        Button.Gump := Self;
        ObjektListe.Add( Button );
        Result := Button;
end;

function TGump.AddButton( X, Y : Integer; UpId, DownId : Word; ReturnNumber : Integer; Page : Word ) : TGumpButton;
var     Button : TGumpButton;
begin
        Button := TGumpButton.Create;
        Button.X := X;
        Button.Y := Y;
        Button.UpId := UpId;
        Button.DownId := DownId;
        Button.MoveOverId := UpId;
        Button.Page := Page;
        Button.ReturnNumber := ReturnNumber;
        Button.Typ := gt_Button;
        Button.Down := False;
        Button.MausOver := False;
        Button.Gump := Self;
        ObjektListe.Add( Button );
        Result := Button;
end;

function TGump.AddTextButton( X, Y : Integer; ReturnNumber : Integer; Text : String; Font : Byte; Page : Word; Breite : Word; UpHue, DownHue, MoveOverHue, BackgroundUpId, BackgroundDownId, BackgroundMoveOverId, BackgroundUpHue, BackgroundDownHue, BackgroundMoveOverHue, Hoehe : Word; IsPageButton : Boolean; PageId : Word; Border : Boolean ) : TTextButton;
var     Button : TTextButton;
begin
        Button := TTextButton.Create;
        Button.Gump := Self;        
        Button.IsPageButton := IsPageButton;
        Button.X := X;
        Button.Y := Y;
        Button.Breite := Breite;
        Button.Hoehe := Hoehe;        
        Button.UpHue := UpHue;
        Button.DownHue := DownHue;
        Button.MoveOverHue := MoveOverHue;
        Button.Text := Text;
        Button.Page := Page;
        Button.Font := Font;
        Button.ReturnNumber := ReturnNumber;
        Button.PageId := PageId;
        Button.Typ := gt_TextButton;
        Button.Down := False;
        Button.MausOver := False;
        Button.BackUpId := BackgroundUpId;
        Button.BackDownId := BackgroundDownId;
        Button.BackMoveOverId := BackgroundMoveOverId;
        Button.BackUpHue := BackgroundUpHue;
        Button.BackDownHue := BackgroundDownHue;
        Button.BackMoveOverHue := BackgroundMoveOverHue;
        Button.Border := Border;
        Button.GetTexture;
        ObjektListe.Add( Button );
        Result := Button;
end;

function TGump.AddPageButton( X, Y : Integer; UpId, DownId, PageId, Page : Word ) : TPageButton;
var     Button : TPageButton;
begin
        Button := TPageButton.Create;
        Button.X := X;
        Button.Y := Y;
        Button.UpId := UpId;
        Button.DownId := DownId;
        Button.Page := Page;
        Button.PageId := PageId;
        Button.Typ := gt_PageButton;
        Button.Down := False;
        Button.Gump := Self;
        ObjektListe.Add( Button );
        Result := Button;
end;

function TGump.AddImage( X, Y : Integer; Id, Hue, Page : Word ) : TGImage;
var     Image : TGImage;
begin
        Image := TGImage.Create;
        Image.X := X;
        Image.Y := Y;
        Image.Id := Id;
        Image.Hue := Hue;
        Image.Page := Page;
        Image.Typ := gt_Image;
        Image.Gump := Self;
        ObjektListe.Add( Image );
        Result := Image;
end;

function TGump.AddTiledImage( X, Y : Integer; Hoehe, Breite : Integer; Id, Hue, Page : Word ) : TTiledImage;
var     Image : TTiledImage;
begin
        Image := TTiledImage.Create;
        Image.X := X;
        Image.Y := Y;
        Image.Id := Id;
        Image.Hue := Hue;
        Image.Breite := Breite;
        Image.Hoehe := Hoehe;
        Image.Page := Page;
        Image.Typ := gt_TiledImage;
        Image.Gump := Self;
        ObjektListe.Add( Image );
        Result := Image;
end;

function TGump.AddTilePic( X, Y : Integer; Id, Hue, Page : Word ) : TTilePic;
var     Image : TTilePic;
begin
        Image := TTilePic.Create;
        Image.X := X;
        Image.Y := Y;
        Image.Id := Id;
        Image.Hue := Hue;
        Image.Page := Page;
        Image.Gump := Self;
        ObjektListe.Add( Image );
        Result := Image;
end;

function TGump.AddLandTilePic( X, Y : Integer; Id, Hue, Page : Word ) : TLandTilePic;
var     Image : TLandTilePic;
begin
        Image := TLandTilePic.Create;
        Image.X := X;
        Image.Y := Y;
        Image.Id := Id;
        Image.Hue := Hue;
        Image.Page := Page;
        Image.Gump := Self;
        ObjektListe.Add( Image );
        Result := Image;
end;

function TGump.AddResizeGump( X, Y : Integer; Id : Word; Breite, Hoehe : Integer; Hue, Page : Word; OnlyBorder : Boolean ) : TResizeGump;
var     ResizePic : TResizeGump;
begin
        ResizePic := TResizeGump.Create;
        ResizePic.X := X;
        ResizePic.Y := Y;
        ResizePic.Id := Id;
        ResizePic.Breite := Breite;
        ResizePic.Hoehe := Hoehe;
        ResizePic.Hue := Hue;
        ResizePic.Typ := gt_ResizeGump;
        ResizePic.Page := Page;
        ResizePic.OnlyBorder := OnlyBorder;
        ResizePic.Gump := Self;
        ObjektListe.Add( ResizePic );
        Result := ResizePic;
end;

function TGump.AddCroppedText( X, Y : Integer; Hoehe, Breite : Integer; Text : String; Font : Byte; Hue, Page : Word; MaxLines : Word; Border : Boolean; DivHeight : Integer ) : TCroppedText;
var     CroppedText : TCroppedText;
begin
        CroppedText := TCroppedText.Create;
        CroppedText.X := X;
        CroppedText.Y := Y;
        CroppedText.Text := Text;
        CroppedText.Hue := Hue;
        CroppedText.Typ := gt_CroppedText;
        CroppedText.Page := Page;
        CroppedText.Font := Font;
        CroppedText.Breite := Breite;
        CroppedText.Hoehe := Hoehe;
        CroppedText.MaxLines := MaxLines;
        CroppedText.Border := Border;
        CroppedText.DivHeight := DivHeight;
        CroppedText.GetTexture;
        CroppedText.Gump := Self;
        ObjektListe.Add( CroppedText );
        Result := CroppedText;
end;

function TGump.AddText( X, Y : Integer; Text : String; Font : Byte; Hue, Page : Word; Border : Boolean ) : TGumpText;
var     GText : TGumpText;
begin
        GText := TGumpText.Create;
        GText.X := X;
        GText.Y := Y;
        GText.Hue := Hue;
        GText.Font := Font;
        GText.Typ := gt_Text;
        GText.Page := Page;
        GText.Border := Border;
        GText.Text := Text;
        GText.GetTexture;
        GText.Gump := Self;
        ObjektListe.Add( GText );
        Result := GText;
end;

function TGump.AddInputField( X, Y : Integer; Hoehe, Breite : Integer; Text : String; Font : Byte; TextId : Integer; Hue : Word; Page : Word; AllowOnlyNumbers : Boolean; Stars : Boolean; AllowMultiLines : Boolean ) : TInputField;
var     InputField : TInputField;
begin
        InputField := TInputField.Create;
        InputField.X := X;
        InputField.Y := Y;
        InputField.Text := Text;
        InputField.Hue := Hue;
        InputField.Typ := gt_InputField;
        InputField.Page := Page;
        InputField.Font := Font;
        InputField.Breite := Breite;
        InputField.Hoehe := Hoehe;
        InputField.TextId := TextId;
        InputField.SelectedPos := Length( InputField.Text );
        InputField.HasStars := Stars;
        InputField.AllowOnlyNumbers := AllowOnlyNumbers;
        InputField.AllowMultiLines := AllowMultiLines;
        InputField.GetTexture;
        InputField.Gump := Self;
        ObjektListe.Add( InputField );
        Result := InputField;
end;

function TGump.AddCheckBox( X, Y : Integer; TrueId, FalseId : Word; Checked : Boolean; ReturnNumber : Integer; Page : Word ) : TCheckBox;
var     Checkbox : TCheckbox;
begin
        Checkbox := TCheckbox.Create;
        Checkbox.X := X;
        Checkbox.Y := Y;
        Checkbox.TrueId := TrueId;
        Checkbox.FalseId := FalseId;
        Checkbox.Typ := gt_Checkbox;
        Checkbox.Page := Page;
        Checkbox.ReturnNumber := ReturnNumber;
        Checkbox.Gump := Self;
        Checkbox.Checked := Checked;
        ObjektListe.Add( Checkbox );
        Result := CheckBox;
end;

function TGump.AddRadioButton( X, Y : Integer; TrueId, FalseId : Word; Checked : Boolean; ReturnNumber : Integer; Group : Word; Page : Word ) : TRadioButton;
var     RadioButton : TRadioButton;
begin
        RadioButton := TRadioButton.Create;
        RadioButton.X := X;
        RadioButton.Y := Y;
        RadioButton.TrueId := TrueId;
        RadioButton.FalseId := FalseId;
        RadioButton.Typ := gt_RadioButton;
        RadioButton.Page := Page;
        RadioButton.ReturnNumber := ReturnNumber;
        RadioButton.Checked := Checked;
        RadioButton.Group := Group;
        RadioButton.Gump := Self;
        ObjektListe.Add( RadioButton );
        Result := RadioButton;
end;

function TGump.AddHtmlGump( X, Y : Integer; Text : String; Breite, Hoehe : Integer; hasBack, canScroll : Boolean; Page : Word ) : THtmlGump;
var     HtmlGump : THtmlGump;
begin
        HtmlGump := THtmlGump.Create;
        HtmlGump.X := X;
        HtmlGump.Y := Y;
        HtmlGump.Breite := Breite;
        HtmlGump.Hoehe := Hoehe;        
        HtmlGump.Text := Text;
        HtmlGump.Typ := gt_HtmlGump;
        HtmlGump.Page := Page;
        HtmlGump.hasBack := hasBack;
        HtmlGump.canScroll := canScroll;
        HtmlGump.GetTexture;
        HtmlGump.Gump := Self;
        ObjektListe.Add( HtmlGump );
        Result := HtmlGump;
end;

function TGump.AddXmfHtmlGump( X, Y : Integer; ClilocID : LongWord; Breite, Hoehe : Integer; hasBack, canScroll : Boolean; Color : Word; Page : Word ) : TXmfHtmlGump;
var     XmfHtmlGump : TXmfHtmlGump;
begin
        XmfHtmlGump := TXmfHtmlGump.Create;
        XmfHtmlGump.X := X;
        XmfHtmlGump.Y := Y;
        XmfHtmlGump.Breite := Breite;
        XmfHtmlGump.Hoehe := Hoehe;
        XmfHtmlGump.Color := Color;
        XmfHtmlGump.ClilocID := ClilocID;
        XmfHtmlGump.Typ := gt_XmfHtmlGump;
        XmfHtmlGump.Page := Page;
        XmfHtmlGump.hasBack := hasBack;
        XmfHtmlGump.canScroll := canScroll;
        XmfHtmlGump.GetTexture;
        XmfHtmlGump.Gump := Self;
        ObjektListe.Add( XmfHtmlGump );
        Result := XmfHtmlGump;
end;

function TGump.AddCheckerTrans( X, Y, Hoehe, Breite : Integer; Page : Word ) : TCheckerTrans;
var     CheckerTrans : TCheckerTrans;
begin
        CheckerTrans := TCheckerTrans.Create;
        CheckerTrans.X := X;
        CheckerTrans.Y := Y;
        CheckerTrans.Resize( Breite, Hoehe );
        CheckerTrans.Page := Page;
        CheckerTrans.Typ := gt_CheckerTrans;
        CheckerTrans.Gump := Self;
        ObjektListe.Add( CheckerTrans );
        Result := CheckerTrans;
end;

function TGump.AddGumpItem( X, Y : Integer; ItemSerial : LongWord; Pos : Integer; Page : Word ) : TGumpItem;
var     GumpItem : TGumpItem;
begin
        if ItemSerial <> Invalid_Serial then begin
                GumpItem := TGumpItem.Create;
                GumpItem.ItemSerial := ItemSerial;
                GumpItem.X := X;
                GumpItem.Y := Y;
                GumpItem.Typ := gt_GumpItem;
                GumpItem.Gump := Self;
                GumpItem.Page := Page;
                if Pos >= 0 then
                        ObjektListe.Insert( Pos, GumpItem )
                else
                        ObjektListe.Add( GumpItem );
                Result := GumpItem;
        end
        else
                Result := nil;
end;

function TGump.AddGumpItem( X, Y : Integer; InternalId, InternalHue, InternalLayer : Word; Pos : Integer; Page : Word ) : TGumpItem;
var     GumpItem : TGumpItem;
begin
        GumpItem := TGumpItem.Create;
        GumpItem.ItemSerial := Invalid_Serial;
        GumpItem.X := X;
        GumpItem.Y := Y;
        GumpItem.HasItem := False;
        GumpItem.Typ := gt_GumpItem;
        GumpItem.InternalId := InternalId;
        GumpItem.InternalHue := InternalHue;
        GumpItem.InternalLayer := InternalLayer;
        GumpItem.Blendfactor := 120;        
        GumpItem.Gump := Self;
        GumpItem.Page := Page;
        if Pos >= 0 then
                ObjektListe.Insert( Pos, GumpItem )
        else
                ObjektListe.Add( GumpItem );
        Result := GumpItem;
end;

function TGump.AddStaticItem( X, Y : Integer; ItemSerial : LongWord; Page : Word ) : TGumpStaticItem;
var     GumpStaticItem : TGumpStaticItem;
begin
        if ItemSerial <> Invalid_Serial then begin
                GumpStaticItem := TGumpStaticItem.Create;
                GumpStaticItem.ItemSerial := ItemSerial;
                GumpStaticItem.X := X;
                GumpStaticItem.Y := Y;
                GumpStaticItem.Gump := Self;
                GumpStaticItem.Page := Page;
                GumpStaticItem.Typ := gt_GumpStaticItem;
                ObjektListe.Add( GumpStaticItem );
                Result := GumpStaticItem;
        end
        else
                Result := nil;
end;

function TGump.AddScrollBar( X, Y : Integer; Horizontal : Boolean; Length, UpId, MoveOverId : Word; Number : Integer; Page : Word ) : TScrollBar;
var     ScrollBar : TScrollBar;
begin
        ScrollBar := TScrollbar.Create;
        ScrollBar.X := X;
        ScrollBar.Y := Y;
        ScrollBar.Horizontal := Horizontal;
        if Horizontal then begin
                ScrollBar.Breite := Length;
                ScrollBar.Hoehe := 0;
        end
        else begin
                ScrollBar.Breite := 0;
                Scrollbar.Hoehe := Length;
        end;
        ScrollBar.UpId := UpId;
        ScrollBar.MoveOverId := MoveOverId;
        ScrollBar.Page := Page;
        ScrollBar.Number := Number;
        ScrollBar.Typ := gt_Scrollbar;
        ScrollBar.Gump := Self;

        ObjektListe.Add( ScrollBar );
        Result := ScrollBar;
end;

function TGump.AddHueButton( X, Y : Integer; Breite, Hoehe : Word; Red, Green, Blue : Byte; ReturnNumber : Integer; Page : Word ) : THueButton;
var     HueButton : THueButton;
begin
        HueButton := THueButton.Create( X, Y, Breite, Hoehe, Red, Green, Blue, ReturnNumber, Page );
        HueButton.Typ := gt_HueButton;
        HueButton.Gump := Self;

        ObjektListe.Add( HueButton );
        Result := HueButton;
end;

function TGump.AddProgressBar( X, Y : Integer; Breite, Hoehe : Word; Current, Max, BackLeftColor, BackRightColor, LeftColor, RightColor : LongWord; Text, Align : String; TextColor : LongWord; Waagerecht : Boolean; Page : Word ) : TProgressBar;
var     ProgressBar : TProgressBar;
begin
        ProgressBar := TProgressBar.Create( X, Y, Breite, Hoehe, Current, Max, BackLeftColor, BackRightColor, LeftColor, RightColor, Text, Align, TextColor, Waagerecht, Page );
        ProgressBar.Gump := Self;

        ObjektListe.Add( ProgressBar );
        Result := ProgressBar;
end;

function TGump.AddExtImage( X, Y : Integer; Breite, Hoehe : Word; URL : String; Page : Word ) : TExtImage;
var     ExtImage : TExtImage;
begin
        ExtImage := TExtImage.Create( X, Y, Breite, Hoehe, URL );
        ExtImage.Gump := Self;
        ExtImage.Page := Page;

        ObjektListe.Add( ExtImage );
        Result := ExtImage;
end;

function TGump.AddTooltip( X, Y : Integer; Breite, Hoehe : Word; Text : String; Page : Word ) : TGumpTooltip;
var     GumpTooltip : TGumpTooltip;
begin
        GumpTooltip := TGumpTooltip.Create( X, Y, Breite, Hoehe, Text, Page );
        GumpTooltip.Gump := Self;

        ObjektListe.Add( GumpTooltip );
        Result := GumpTooltip;
end;

procedure TGump.OnButtonClick( ReturnNumber : Integer );
begin
        if (ReturnNumber = 0) and (not noAutoClose) then
                Palanthir.DeleteGump( Self );
end;

procedure TGump.OnClick( X, Y : Word );
begin
end;

procedure TGump.OnScrollBar( GumpObject : TGumpObject );
begin
end;

procedure TGump.OnMoveOverButton( ReturnNumber : Integer );
begin
end;

procedure TGump.OnBeforeDraw;
begin
end;

procedure TGump.OnAfterDraw;
begin
end;

procedure TGump.OnDelete;
begin
end;

procedure TGump.OnMouseUp( GumpObject : TGumpObject );
begin
end;

procedure TGump.OnMouseDown( GumpObject : TGumpObject );
begin
end;

function TGump.OnMove( GumpObject : TGumpObject ) : Boolean;
var     NPromille : Integer;
begin
        if GumpObject.Typ = gt_Scrollbar then begin
                if not TScrollBar( GumpObject ).Fixed then begin
                        if TScrollBar( GumpObject ).Horizontal then begin
                                Palanthir.Maus.MX := Palanthir.Maus.AktX;

                                NPromille := Round( ( Palanthir.Maus.AktX - GumpObject.X - GumpObject.Gump.X )*1000 / TScrollbar( GumpObject ).Breite );
                        end
                        else begin
                                Palanthir.Maus.MY := Palanthir.Maus.AktY;

                                NPromille := Round( ( Palanthir.Maus.AktY - GumpObject.Y - GumpObject.Gump.Y )*1000 / TScrollbar( GumpObject ).Hoehe );
                        end;
                        NPromille := Min( 1000, Max( 0, NPromille ) );
                        TScrollBar( GumpObject ).Promille := NPromille;
                        TScrollBar( GumpObject ).Change;
                        Result := False;
                end;
        end
        else if GumpObject.Typ in [ gt_Image, gt_TiledImage, gt_TilePic, gt_Text, gt_ResizeGump, gt_CroppedText, gt_HtmlGump, gt_XmfHtmlGump, gt_CheckerTrans, gt_InputField ] then
                Result := True
        else
                Result := False;
end;

procedure TGump.OnDblClick( GumpObject : TGumpObject );
begin
end;

function TGump.OnDblClick( X, Y : Word ) : Boolean;
begin
        Result := True;
        //Has to be false, if Gump should be deleted afterwards
end;

procedure TGump.OnCheckBoxChange( CheckBox : TCheckBox );
begin
end;

function TGump.GetInputText( ReturnNumber : Integer ) : String;
var     I : Integer;
begin
        Result := '';

        if ObjektListe.Count = 0 then
                exit;

        for I := 0 to ObjektListe.Count-1 do
                if TGumpObject( ObjektListe.Items[I] ).Typ = gt_InputField then
                        if TInputField( ObjektListe.Items[I] ).TextId = ReturnNumber then begin
                                Result := TInputField( ObjektListe.Items[I] ).Text;
                                break;
                        end;
end;

function TGump.GetCheckBox( ReturnNumber : Integer ) : Boolean;
var     I : Integer;
begin
        Result := False;

        if ObjektListe.Count = 0 then
                exit;

        for I := 0 to ObjektListe.Count-1 do
                if TGumpObject( ObjektListe.Items[I] ).Typ = gt_CheckBox then
                        if TCheckBox( ObjektListe.Items[I] ).ReturnNumber = ReturnNumber then begin
                                Result := TCheckBox( ObjektListe.Items[I] ).Checked;
                                break;
                        end;
end;

function TGump.GetRadioButton( Group : Word ) : Integer;
var     I : Integer;
begin
        Result := 0;

        if ObjektListe.Count = 0 then
                exit;

        for I := 0 to ObjektListe.Count-1 do
                if TGumpObject( ObjektListe.Items[I] ).Typ = gt_RadioButton then
                        if TRadioButton( ObjektListe.Items[I] ).Group = Group then
                                if TRadioButton( ObjektListe.Items[I] ).Checked then begin
                                        Result := TRadioButton( ObjektListe.Items[I] ).ReturnNumber;
                                        break;
                                end;
end;

function TGump.GetObject( Index : Integer ) : TGumpObject;
begin
        if Index < ObjektListe.Count then
                Result := TGumpObject( ObjektListe.Items[ Index ] )
        else
                Result := nil;
end;

procedure TGump.DeleteObject( Index : Integer );
begin
        if Index < ObjektListe.Count then begin
                if ObjektListe.Items[ Index ] <> nil then
                        TGumpObject( ObjektListe.Items[ Index ] ).Free;
                ObjektListe.Delete( Index );
        end;
end;

procedure TGump.DeleteObject( GumpObject : TGumpObject );
var     I : Integer;
begin
        for I := 0 to GetObjectCount-1 do begin
                if GetObject( I ) = GumpObject then begin
                        ObjektListe.Delete( I );
                        break;
                end;
        end;
end;

function TGump.GetObjectCount : Integer;
begin
        Result := ObjektListe.Count;
end;

function TGump.GetButton( ReturnNumber : Integer ) : TGumpObject;
var     I : Integer;
begin
        Result := nil;

        if ObjektListe.Count = 0 then
                exit;

        for I := 0 to ObjektListe.Count-1 do begin
                if (TGumpObject( ObjektListe.Items[I] ).Typ = gt_Button) then begin
                        if TGumpButton( ObjektListe.Items[I] ).ReturnNumber = ReturnNumber then begin
                                Result := ObjektListe.Items[I];
                                break;
                        end;
                end
                else if (TGumpObject( ObjektListe.Items[I] ).Typ = gt_TextButton) then begin
                        if TTextButton( ObjektListe.Items[I] ).ReturnNumber = ReturnNumber then begin
                                Result := ObjektListe.Items[I];
                                break;
                        end;
                end;
        end;
end;

function TGump.InternalDraw( PX, PY : Integer ) : Boolean;
var     I : Integer;
        GumpObject : TGumpObject;
        TmpX, TmpY : Integer;
begin
        TmpX := X;
        TmpY := Y;

        X := PX;
        Y := PY;

        glEnable( GL_STENCIL_TEST );

        for I := 0 to ObjektListe.Count-1 do
                if (TGumpObject( ObjektListe.Items[ I ] ).Page = 0) or (TGumpObject( ObjektListe.Items[ I ] ).Page = ActivePage) then begin
                        if TGumpObject( ObjektListe.Items[ I ] ).Typ = gt_CheckerTrans then begin
                                TCheckerTrans( ObjektListe.Items[ I ] ).InitDraw;
                        end;
                end;

        for I := 0 to ObjektListe.Count-1 do
                if (TGumpObject( ObjektListe.Items[ I ] ).Page = 0) or (TGumpObject( ObjektListe.Items[ I ] ).Page = ActivePage) then begin
                        if GetObject( I ) <> nil then begin
                                if GetObject( I ).Visible then begin
                                        GetObject( I ).Draw;
                                end;
                        end
                        else begin
                                DeleteObject( I );
                        end;
                end;

        for I := 0 to ObjektListe.Count-1 do begin
                GumpObject := GetObject( I );
                if (GumpObject.Page = 0) or (GumpObject.Page = ActivePage) then begin
                        if GumpObject.Speech <> nil then begin
                                GumpObject.Speech.X := PX + GumpObject.X + GumpObject.LastClickX;
                                GumpObject.Speech.Y := PY + GumpObject.Y + GumpObject.LastClickY;
                                GumpObject.Speech.Visible := True;
                                if not GumpObject.Speech.Draw then
                                        GumpObject.Speech.Free;
                        end;
                end;
        end;

        glDisable( GL_STENCIL_TEST );

        X := TmpX;
        Y := TmpY;

        Result := True;
end;

function TGump.Draw : Boolean;
begin
        if BBEnabled then begin
                glEnable( GL_SCISSOR_TEST );
                glScissor( BBX, Renderer.GetWindowHoehe-BBY-BBHeight, BBWidth, BBHeight );
        end;

        if (ClearTick <> $FFFFFFFF) then begin
                if ClearTick + 10 < CustomGetTickCount then begin
                        ClearTick := CustomGetTickCount;
                        if ClearPercent = 100 then begin
                                Result := False;
                                exit;
                        end;

                        Inc( ClearPercent, 2 );
                end;

                if FadeBuffer = nil then begin
                        FadeBuffer := TPixelBuffer.Create( GetNextBit( GetBreite ), GetNextBit( GetHoehe ), Renderer.DC, Renderer.RC, nil );
                        if FadeBuffer.Init then begin
                                wglShareLists( Renderer.RC, FadeBuffer.RC );
                        end
                        else begin
                                FadeBuffer.Destroy;
                                FadeBuffer := nil;
                                Result := False;
                                exit;
                        end;

                        FadeBuffer.Enable;

                        glEnable( GL_TEXTURE_2D );

                        glMatrixMode( GL_PROJECTION );
                        glLoadIdentity;
                        glViewPort( 0, 0, FadeBuffer.Width, FadeBuffer.Height );

                        glMatrixMode( GL_MODELVIEW );
                        glLoadIdentity;
                        glOrtho( 0, FadeBuffer.Width, 0, FadeBuffer.Height, -1, 1 );

                        glClearColor( 0, 0, 0, 0 );
                        glClear( GL_COLOR_BUFFER_BIT or GL_STENCIL_BUFFER_BIT );

                        glEnable( GL_ALPHA_TEST );
                        glAlphaFunc( GL_GREATER, 0.1 );

                        glColor3f( 1, 1, 1 );

                        InternalDraw( 0, 0 );

                        FadeBuffer.Disable;
                end;

                FadeBuffer.Bind;

                glEnable( GL_BLEND );
                glBlendFunc( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA );
                glColor4f( 1, 1, 1, 1 - ClearPercent/100 );

                Breite := GetBreite;
                Hoehe := GetHoehe;

                glBegin( gl_Quads );
                        glTexCoord2f( 0, 0 );
                        glVertex2f( X, Y );
                        glTexCoord2f( 0, Hoehe / FadeBuffer.Height );
                        glVertex2f( X, Y + Hoehe );
                        glTexCoord2f( Breite / FadeBuffer.Width, Hoehe / FadeBuffer.Height );
                        glVertex2f( X + Breite, Y + Hoehe );
                        glTexCoord2f( Breite / FadeBuffer.Width, 0 );
                        glVertex2f( X + Breite, Y );
                glEnd;

                glDisable( GL_BLEND );

                FadeBuffer.Release;

                Result := True;
        end else if GlobalAlpha <> 255 then begin
                if (FadeBuffer <> nil) and ((GetNextBit( GetBreite ) > FadeBuffer.Width) or (GetNextBit( GetHoehe ) > FadeBuffer.Height)) then begin
                        FadeBuffer.Destroy;
                        FadeBuffer := nil;
                end;

                if FadeBuffer = nil then begin
                        FadeBuffer := TPixelBuffer.Create( GetNextBit( GetBreite ), GetNextBit( GetHoehe ), Renderer.DC, Renderer.RC, nil );
                        if FadeBuffer.Init then begin
                                wglShareLists( Renderer.RC, FadeBuffer.RC );
                        end
                        else begin
                                FadeBuffer.Destroy;
                                FadeBuffer := nil;
                                Result := True;
                                GlobalAlpha := 255;
                                Exit;
                        end;
                end;

                FadeBuffer.Enable;

                glEnable( GL_TEXTURE_2D );

                glMatrixMode( GL_PROJECTION );
                glLoadIdentity;
                glViewPort( 0, 0, FadeBuffer.Width, FadeBuffer.Height );

                glMatrixMode( GL_MODELVIEW );
                glLoadIdentity;
                glOrtho( 0, FadeBuffer.Width, 0, FadeBuffer.Height, -1, 1 );

                glClearColor( 0, 0, 0, 0 );
                glClear( GL_COLOR_BUFFER_BIT or GL_STENCIL_BUFFER_BIT );

                glEnable( GL_ALPHA_TEST );
                glAlphaFunc( GL_GREATER, 0.1 );

                glColor3f( 1, 1, 1 );

                InternalDraw( 0, 0 );

                FadeBuffer.Disable;

                FadeBuffer.Bind;

                glEnable( GL_BLEND );
                glBlendFunc( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA );
                glColor4f( 1, 1, 1, GlobalAlpha/255 );

                Breite := GetBreite;
                Hoehe := GetHoehe;

                glBegin( gl_Quads );
                        glTexCoord2f( 0, 0 );
                        glVertex2f( X, Y );
                        glTexCoord2f( 0, Hoehe / FadeBuffer.Height );
                        glVertex2f( X, Y + Hoehe );
                        glTexCoord2f( Breite / FadeBuffer.Width, Hoehe / FadeBuffer.Height );
                        glVertex2f( X + Breite, Y + Hoehe );
                        glTexCoord2f( Breite / FadeBuffer.Width, 0 );
                        glVertex2f( X + Breite, Y );
                glEnd;

                glDisable( GL_BLEND );

                FadeBuffer.Release;

                Result := True;
        end else begin
                Result := InternalDraw( X, Y );
        end;

        if BBEnabled then begin
                glDisable( GL_SCISSOR_TEST );
        end;
end;

function TGump.OnKeyReturn( GumpObject : TGumpObject ) : Boolean;
begin
        Result := False;
end;

function TGump.OnKeyTab( GumpObject : TGumpObject ) : Boolean;
var     I, P : Integer;
begin
        if Palanthir.Keyboard.SelectedGumpObject <> nil then begin
                for P := 0 to Palanthir.Keyboard.SelectedGumpObject.Gump.ObjektListe.Count-1 do
                        if TGumpObject( Palanthir.Keyboard.SelectedGumpObject.Gump.ObjektListe.Items[ P ] ) = Palanthir.Keyboard.SelectedGumpObject then
                                break;

                for I := P+1 to Palanthir.Keyboard.SelectedGumpObject.Gump.ObjektListe.Count-1 do
                        if TGumpObject( Palanthir.Keyboard.SelectedGumpObject.Gump.ObjektListe.Items[ I ] ).Typ = gt_InputField then begin
                                Palanthir.Keyboard.SelectedGumpObject := TGumpObject( Palanthir.Keyboard.SelectedGumpObject.Gump.ObjektListe.Items[ I ] );
                                Result := True;
                                exit;
                        end;

                for I := 0 to Palanthir.Keyboard.SelectedGumpObject.Gump.ObjektListe.Count-1 do
                        if TGumpObject( Palanthir.Keyboard.SelectedGumpObject.Gump.ObjektListe.Items[ I ] ).Typ = gt_InputField then begin
                                Palanthir.Keyboard.SelectedGumpObject := TGumpObject( Palanthir.Keyboard.SelectedGumpObject.Gump.ObjektListe.Items[ I ] );
                                Result := True;
                                exit;
                        end;
        end;
        Result := False;
end;

procedure TGump.OnInputFieldChange( InputField : TInputField );
begin
end;

procedure TGump.OnScrollBarRelease( ScrollBar : TScrollBar );
begin
end;

function TGump.GetBreite : Word;
var     I : Integer;
begin
        Result := 0;
        for I := 0 to ObjektListe.Count-1 do
                if (TGumpObject( ObjektListe.Items[ I ] ).Page = 0) or (TGumpObject( ObjektListe.Items[ I ] ).Page = ActivePage) then begin
                        if GetObject( I ) <> nil then begin
                                if GetObject( I ).Visible then
                                        if GetObject( I ).X + GetObject( I ).GetBreite > Result then
                                                Result := GetObject( I ).X + GetObject( I ).GetBreite;
                        end;
                end;
end;

function TGump.GetHoehe : Word;
var     I : Integer;
begin
        Result := 0;
        for I := 0 to ObjektListe.Count-1 do
                if (TGumpObject( ObjektListe.Items[ I ] ).Page = 0) or (TGumpObject( ObjektListe.Items[ I ] ).Page = ActivePage) then begin
                        if GetObject( I ) <> nil then begin
                                if GetObject( I ).Visible then
                                        if GetObject( I ).Y + GetObject( I ).GetHoehe > Result then
                                                Result := GetObject( I ).Y + GetObject( I ).GetHoehe;
                        end;
                end;
end;

procedure TGump.StartDecay;
begin
        ClearTick := CustomGetTickCount;
end;

procedure TGump.CheckTooltip( GumpObject : TGumpObject );
var     I : Integer;
        GumpTooltip : TGumpTooltip;
begin
        for I := 0 to GetObjectCount-1 do begin
                if GetObject( I ).Typ = gt_GumpToolTip then begin
                        GumpTooltip := TGumpTooltip( GetObject( I ) );
                        if IsInRect( Palanthir.Maus.AktX, Palanthir.Maus.AktY, X+GumpTooltip.X, Y+GumpTooltip.Y, X+GumpTooltip.X+GumpTooltip.Breite, Y+GumpTooltip.Y+GumpTooltip.Hoehe ) then begin
                                Palanthir.Tooltip.SetTarget( GumpTooltip );
                                Exit;
                        end;
                end;
        end;

        Palanthir.Tooltip.SetTarget( GumpObject );
end;

procedure TGump.SendBack( GumpObject : TGumpObject );
var     I : Integer;
begin
        for I := 0 to GetObjectCount-1 do begin
                if GetObject( I ) = GumpObject then begin
                        ObjektListe.Delete( I );
                        ObjektListe.Insert( 0, GumpObject );
                        break;
                end;
        end;
end;

procedure TGump.SendFront( GumpObject : TGumpObject );
var     I : Integer;
begin
        for I := 0 to GetObjectCount-1 do begin
                if GetObject( I ) = GumpObject then begin
                        ObjektListe.Delete( I );
                        ObjektListe.Add( GumpObject );
                        break;
                end;
        end;
end;

procedure TGump.SetBoundingBox( X, Y, Width, Height : Integer );
begin
        BBX := X;
        BBY := Y;
        BBWidth := Width;
        BBHeight := Height;
end;

end.
