unit uJournal;

interface

uses    uGumps, Dialogs, SysUtils, uSendPackets, Classes, Math, StrLib, uChar,
        uItem, uTexCache, uRenderer, uLog, uUtilities, uConfig;

type    TJournal = Class( TGump )
                private
                        RollenGump, Zeiger : TGImage;
                        Schloss : TGumpButton;                        
                        Closed, Fix : Boolean;
                        TextPos, TextHoehe : Integer;
                        Cache : TList;
                        TextBorder : Boolean;
                public
                        DefaultColor : Word;                
                        UseDefaultColor : Boolean;                
                        Visible : Boolean;
                        Rolle : Boolean;
                        constructor Create; override;
                        destructor Free; override;
                        procedure Clear;
                        function Draw : Boolean; override;
                        function OnMove( GumpObject : TGumpObject ) : Boolean; override;
                        procedure OnButtonClick( ReturnNumber : Integer ); override;
                        procedure OnClick( X, Y : Word ); override;
                        procedure OnDblClick( GumpObject : TGumpObject ); override;
                        procedure FixGumpObjects;
                        procedure AddText( Font : Byte; Color : Word; Text : String; System : Boolean = False );
                        procedure ChangeBorder( Border : Boolean );
        end;

        TJournalText = Class
                public
                        _Font, _Color : Word;
                        _Text : String;
                        _System : Boolean;
                        _Border : Boolean;
                        Texture : TTexObject;
                        Count : Integer;
                        constructor Create( Font : Byte; Color : Word; Text : String; System : Boolean; Border : Boolean );
                        destructor Free;
                        procedure Recreate;
        end;

implementation

uses    uPalanthir;

constructor TJournal.Create;
begin
        inherited Create;
        Visible := False;
        Rolle := False;
        X := 200;
        Y := 200;
        Hoehe := 200;
        TextPos := 0;
        TextHoehe := 0;
        Closed := False;
        Cache := TList.Create;

        DefaultColor := Config.GetInteger( 'JournalDefaultCustomColor' );
        UseDefaultColor := Config.GetBool( 'JournalEnableCustomColor' );
        TextBorder := Config.GetBool( 'JournalTextBorder' );

        RollenGump := TGImage.Create;
        RollenGump.X := 0;
        RollenGump.Y := 0;
        RollenGump.Id := $830;
        RollenGump.Gump := Self;
        RollenGump.Typ := gt_Image;

        Zeiger := TGImage.Create;
        Zeiger.X := 257;
        Zeiger.Y := 80;
        Zeiger.Id := $1F;
        Zeiger.Gump := Self;
        Zeiger.Typ := gt_Image;

        Schloss := TGumpButton.Create;
        Schloss.X := 233;
        Schloss.Y := 60+Hoehe-19;
        Schloss.UpId := $82C;
        Schloss.DownId := $82C;
        Schloss.Gump := Self;
        Schloss.ReturnNumber := 3;
        Schloss.Typ := gt_Button;

        //Hintergrund
        AddImage( 0, 23, $820, 0, 0 );
        AddImage( 17, 60+Hoehe, $823, 0, 0 );

        //Wimpel oben
        AddButton( 137, 0, $82D, $82D, 2, 0 );

        //Verzierungen
        AddImage( 30, 59, $82B, 0, 0 );
        AddImage( 31, 60+Hoehe-14, $82B, 0, 0 );

        //Text dazwischen, also von 60 bis 60+Hoehe-15

        //Journal Schriftzug
        AddImage( 111, 35, $82A, 0, 0 );

        //Pfeile rechts oben und unten
        AddImage( 249, 57, $824, 0, 0 );
        AddImage( 250, 60+Hoehe-17, $825, 0, 0 );

        //Button Unten
        AddButton( 137, 60+Hoehe+32, $82E, $82F, 1, 0 );

        FixGumpObjects;
end;

destructor TJournal.Free;
begin
        Clear;

        RollenGump.Free;
        Zeiger.Free;
        Schloss.Free;
        Palanthir.Player.Journal := nil;

        inherited Free;
end;

procedure TJournal.Clear;
var     I : Integer;
begin
        for I := 0 to Cache.Count-1 do begin
                TJournalText( Cache.Items[ I ] ).Free;
        end;
        Cache.Clear;
end;

procedure TJournal.FixGumpObjects;
var     I : Integer;
begin
        while GetObjectCount > 9 do begin
                DeleteObject( 9 );
        end;

        TGImage( GetObject( 1 ) ).Y := 60 + Hoehe;
        TGImage( GetObject( 4 ) ).Y := 60 + Hoehe - 14;
        TGImage( GetObject( 7 ) ).Y := 60 + Hoehe - 17;
        TGumpButton( GetObject( 8 ) ).Y := 60 + Hoehe + 32;

        for I := 0 to (Hoehe div 60)-1 do begin
                if (I mod 2) = 0 then
                        AddImage( 17, 60+I*60, $821, 0, 0 )
                else
                        AddImage( 17, 60+I*60, $822, 0, 0 );
        end;
        AddTiledImage( 17, 60+60*(Hoehe div 60), Hoehe mod 60, 262, $822, 0, 0 );

        Schloss.Y := 60+Hoehe-19;
        
        Fix := False;
end;

function TJournal.Draw : Boolean;
var     I, TmpHoehe : Integer;
        Entry : TJournalText;
begin
        Result := True;
        if not Visible then begin
                exit;
        end;

        if Fix then
                FixGumpObjects;

        if Rolle then begin
                RollenGump.Draw;
        end
        else begin
                for I := 9 to GetObjectCount-1 do
                        if (GetObject( I ).Page = 0) or (GetObject( I ).Page = ActivePage) then
                                GetObject( I ).Draw;

                for I := 0 to Min( GetObjectCount-1, 8 ) do
                        if (GetObject( I ).Page = 0) or (GetObject( I ).Page = ActivePage) then
                                GetObject( I ).Draw;

                TmpHoehe := 0;
                for I := 0 to Cache.Count-1 do begin
                        Entry := TJournalText( Cache.Items[ I ] );
                        if TmpHoehe + Entry.Texture.Hoehe > TextPos then begin
                                if TmpHoehe > TextPos + Hoehe - 20 then
                                        break;
                                Renderer.DrawPixelsMinMaxY( X+36, Y+75+TmpHoehe - TextPos, Entry.Texture, Y+70, Y+60 + Hoehe - 15 );
                        end;
                        TmpHoehe := TmpHoehe + Entry.Texture.Hoehe + 2;
                end;

                if Closed then
                        Schloss.Draw;                
                Zeiger.Draw;
        end;
end;

procedure TJournal.OnButtonClick( ReturnNumber : Integer );
begin
        case ReturnNumber of
                0 : Visible := False;
                2 : Rolle := True;
                3 : begin
                        Closed := False;
                        TextPos := Max( TextHoehe - ( Hoehe - 30 ), 0 );
                        Zeiger.Y := 70 + Trunc( (Hoehe - 55)*(TextPos/(TextHoehe-(Hoehe-30))) );
                end;
        end;
end;

procedure TJournal.OnClick( X, Y : Word );
var     TmpY : Word;
begin
        if IsInRect( X, Y, 249, 57, 264, 72 ) then begin
                TmpY := Zeiger.Y - 5;
                if (TmpY >= 70) and (TmpY <= 70+Hoehe-55) then begin
                        Closed := True;
                        Zeiger.Y := TmpY;
                        TextPos := Trunc( (TextHoehe-(Hoehe-30))*(Zeiger.Y-70)/(Hoehe-55) );
                end;
        end
        else if IsInRect( X, Y, 250, 60+Hoehe-17, 265, 60+Hoehe-2 ) then begin
                TmpY := Zeiger.Y + 5;
                if (TmpY >= 70) and (TmpY <= 70+Hoehe-55) then begin
                        Closed := True;
                        Zeiger.Y := TmpY;
                        TextPos := Trunc( (TextHoehe-(Hoehe-30))*(Zeiger.Y-70)/(Hoehe-55) );
                end;
        end;
end;

procedure TJournal.OnDblClick( GumpObject : TGumpObject );
begin
        if Rolle then
                Rolle := False;
end;

function TJournal.OnMove( GumpObject : TGumpObject ) : Boolean;
var     TmpHoehe, TmpY : Word;
begin
        if GumpObject.Typ = gt_Button then begin
                if TGumpButton( GumpObject ).ReturnNumber = 1 then begin
                        TmpHoehe := Hoehe - ( Palanthir.Maus.MY - Palanthir.Maus.AktY );
                        Palanthir.Maus.MY := Palanthir.Maus.AktY;
                        Palanthir.Maus.MX := Palanthir.Maus.AktX;
                        if (TmpHoehe > 80) and (TmpHoehe < 700) then begin
                                Hoehe := TmpHoehe;
                                Fix := True;
                                if not Closed then begin
                                        TextPos := Max( TextHoehe - ( Hoehe - 30 ), 0 );
                                        Zeiger.Y := 70 + Trunc( (Hoehe - 55)*(TextPos/(TextHoehe-(Hoehe-30))) );
                                end;
                        end;
                end;
                Result := False;
        end
        else if GumpObject = Zeiger then begin
                if TextHoehe < Hoehe - 20 then begin
                        Result := False;
                        exit;
                end;
                TmpY := Zeiger.Y - ( Palanthir.Maus.MY - Palanthir.Maus.AktY );
                Palanthir.Maus.MY := Palanthir.Maus.AktY;
                if (TmpY >= 70) and (TmpY <= 70+Hoehe-55) then begin
                        Closed := True;
                        Zeiger.Y := TmpY;
                        TextPos := Trunc( (TextHoehe-(Hoehe-30))*(Zeiger.Y-70)/(Hoehe-55) );
                end;
                Result := False;
        end
        else begin
                Result := inherited OnMove( GumpObject );
        end;
end;

procedure TJournal.AddText( Font : Byte; Color : Word; Text : String; System : Boolean );
var     Entry : TJournalText;
begin
        Log.Write( LOG_SPEECH, Text );

        if UseDefaultColor then begin
                Color := DefaultColor;
        end;

        if (Cache.Count > 0) and (TJournalText( Cache.Items[ Cache.Count-1 ] )._Text = Text) and (TJournalText( Cache.Items[ Cache.Count-1 ] )._Color = Color) then begin
                Inc( TJournalText( Cache.Items[ Cache.Count-1 ] ).Count );
                Exit;
        end;

        Entry := TJournalText.Create( Font, Color, Text, System, TextBorder );
        if Entry.Texture = nil then begin
                Entry.Free;
                Exit;
        end;

        Cache.Add( Entry );
        TextHoehe := TextHoehe + Entry.Texture.Hoehe + 2;
        if not Closed then begin
                TextPos := Max( TextHoehe - ( Hoehe - 30 ), 0 );
                Zeiger.Y := 70 + Trunc( (Hoehe - 55)*(TextPos/(TextHoehe-(Hoehe-30))) );
        end;

        while TextHoehe > 2000 do begin
                TextHoehe := TextHoehe - TJournalText( Cache.Items[ 0 ] ).Texture.Hoehe - 2;
                TextPos := TextPos - TJournalText( Cache.Items[ 0 ] ).Texture.Hoehe - 2;
                if TextPos < 0 then begin
                        TextPos := 0;
                        Zeiger.Y := 70 + Trunc( (Hoehe - 55)*(TextPos/(TextHoehe-(Hoehe-30))) );
                end;
                TJournalText( Cache.Items[ 0 ] ).Free;
                Cache.Delete( 0 );
        end;

        FixGumpObjects;
end;

procedure TJournal.ChangeBorder( Border : Boolean );
var     Entry : TJournalText;
        I : Integer;
begin
        if Border = TextBorder then begin
                Exit;
        end;

        TextBorder := Border;

        TextHoehe := 0;
        for I := 0 to Cache.Count-1 do begin
                Entry := TJournalText( Cache.Items[ I ] );
                Entry._Border := Border;
                Entry.Recreate;
                TextHoehe := TextHoehe + Entry.Texture.Hoehe + 2;
        end;

        Closed := False;
        TextPos := Max( TextHoehe - ( Hoehe - 30 ), 0 );
        Zeiger.Y := 70 + Trunc( (Hoehe - 55)*(TextPos/(TextHoehe-(Hoehe-30))) );
end;

constructor TJournalText.Create( Font : Byte; Color : Word; Text : String; System : Boolean; Border : Boolean );
begin
        _Font := Font;
        _Color := Color;
        _Text := Text;
        _System := System;
        _Border := Border;
        Count := 0;
        Texture := Palanthir.Data.GetUnicodeTexture( Font, Text, Color, 200, $FFFF, -1, Border, System );
end;

destructor TJournalText.Free;
begin
        if Texture <> nil then
                Texture.Free;
end;

procedure TJournalText.Recreate;
begin
        if Texture <> nil then
                Texture.Free;

        if (Count > 0) and Palanthir.ShowSpeechCount then begin
                Texture := Palanthir.Data.GetUnicodeTexture( _Font, _Text, _Color, 200, $FFFF, -1, _Border, _System );
        end else begin
                Texture := Palanthir.Data.GetUnicodeTexture( _Font, Format( '%s (%d)', [_Text,Count] ), _Color, 200, $FFFF, -1, _Border, _System );
        end;
end;

end.
