unit uPartyGump;

interface

uses    uGumps, Math, SysUtils, uSendPackets;

type    TPartyGump = Class( TGump )
                private
                        UpdateNextDraw : Boolean;
                public
                        Visible : Boolean;                
                        constructor Create; override;
                        destructor Free; override;
                        procedure Update;
                        function Draw : Boolean; override;
                        procedure OnButtonClick( ReturnNumber : Integer ); override;
        end;

implementation

uses    uPalanthir, uParty;

constructor TPartyGump.Create;
begin
        inherited Create;
        Visible := False;
        UpdateNextDraw := False;
end;

destructor TPartyGump.Free;
begin
        Palanthir.Player.Party.Gump := nil;
end;

procedure TPartyGump.Update;
var     I : Integer;
        Page : Word;
        Party : TParty;
        PY : Integer;
begin
        while GetObjectCount > 0 do
                DeleteObject( 0 );

        Party := Palanthir.Player.Party;

        AddResizeGump( 0, 0, $BB8, 300, 500, 0, 0 );
        AddText( 100, 10, 'Party Manifest', 0, 0, 0 );
        AddText( 20, 25, 'Tell', 0, 0, 0 );
        AddText( 60, 25, 'Kick', 0, 0, 0 );

        AddButton( 20, 380, $FBD, $FBF, $FBE, 1, 0 );
        AddText( 60, 380, 'Send the party a message', 0, 0, 0 );
        if Party.CanLoot then begin
                AddButton( 20, 410, $FA9, $FA9, $FA9, 2, 0 );
                AddText( 60, 410, 'Party can loot me', 0, 0, 0 );
        end
        else begin
                AddButton( 20, 410, $FA2, $FA2, $FA2, 2, 0 );
                AddText( 60, 410, 'Party CANNOT loot me', 0, 0, 0 );
        end;

        if Party.PartyLeaderSerial = Palanthir.Player.Serial then begin
                AddButton( 20, 440, $FAE, $FB0, $FAF, 3, 0 );
                AddText( 60, 440, 'Disband the party', 0, 0, 0 );
                AddButton( 20, 470, $FA8, $FAA, $FA9, 4, 0 );
                AddText( 60, 470, 'Add New Member', 0, 0, 0 );
        end
        else begin
                AddButton( 20, 440, $FAE, $FB0, $FAF, 3, 0 );
                AddText( 60, 440, 'Leave the party', 0, 0, 0 );
        end;

        Page := 0;
        for I := 0 to Max( Party.GetMemberCount-1, 9 ) do begin
                if I mod 10 = 0 then begin
                        if Page <> 0 then
                                AddPageButton( 170, 355, $15A4, $15A6, Page+1, Page );

                        Inc( Page );
                        if Page <> 1 then
                                AddPageButton( 130, 355, $15A1, $15A3, Page-1, Page );

                        PY := 60;
                end;

                AddButton( 20, PY, $FBD, $FBF, $FBE, (I+100)*2, Page );
                if Party.PartyLeaderSerial = Palanthir.Player.Serial then
                        AddButton( 60, PY, $FB1, $FB3, $FB2, (I+100)*2+1, Page );
                if Party.GetMemberNameByIndex( I ) <> '' then
                        AddText( 100, PY, Format( '[%s]', [Party.GetMemberNameByIndex( I )] ), 0, 0, Page )
                else
                        AddText( 100, PY, Format( '[%d]', [I] ), 0, 0, Page );

                Inc( PY, 30 );
        end;
end;

function TPartyGump.Draw : Boolean;
begin
        Result := True;

        if not Visible then
                exit;

        if UpdateNextDraw then begin
                UpdateNextDraw := False;
                Update;
        end;

        Result := inherited Draw;
end;

procedure TPartyGump.OnButtonClick( ReturnNumber : Integer );
var     SendAddPartyMember : TSendAddPartyMember;
        SendRemovePartyMember : TSendRemovePartyMember;
        SendPartyCanLoot : TSendPartyCanLoot;
        Party : TParty;
begin
        if ReturnNumber = 0 then begin
                Visible := False;
        end
        else if ReturnNumber = 1 then begin
                Palanthir.Keyboard.SpeechText := '';
                Palanthir.Keyboard.Typ := KB_Speech_Party;
        end
        else if ReturnNumber = 2 then begin
                Party := Palanthir.Player.Party;
                Party.CanLoot := not Party.CanLoot;
                SendPartyCanLoot := TSendPartyCanLoot.Create;
                SendPartyCanLoot.SetCanLoot( Party.CanLoot );
                Palanthir.SendPacket( SendPartyCanLoot );
                UpdateNextDraw := True;
        end
        else if ReturnNumber = 3 then begin
                SendRemovePartyMember := TSendRemovePartyMember.Create;
                SendRemovePartyMember.SetSerial( Palanthir.Player.Serial );
                Palanthir.SendPacket( SendRemovePartyMember );
        end
        else if ReturnNumber = 4 then begin
                SendAddPartyMember := TSendAddPartyMember.Create;
                SendAddPartyMember.SetSerial( 0 );
                Palanthir.SendPacket( SendAddPartyMember );
        end 
        else if ReturnNumber > 100 then begin
                if ReturnNumber mod 2 = 0 then
                        Palanthir.Player.Party.TalkTo( (ReturnNumber div 2)-100 )
                else
                        Palanthir.Player.Party.DeleteMember( ((ReturnNumber-1) div 2)-100 );
        end;
end;


end.
