unit uProfile;

interface

uses    uGumps, Dialogs, SysUtils, uSendPackets, Classes, Math, StrLib,
        uRecievePackets, uUtilities;

type    TProfile = Class( TGump )
                private
                        RollenGump : TGImage;
                        Title, StaticText, Text : String;
                        TitleField : TGumpText;
                        StaticTextField : TCroppedText;
                        Fix : Boolean;
                        Entry : TInputField;
                        TextHoehe : Integer;
                        StartPos : Integer;
                        ScrollBar : TScrollBar;                                               
                public
                        CharSerial : LongWord;
                        Rolle : Boolean;
                        constructor Create; override;
                        destructor Free; override;
                        function Draw : Boolean; override;
                        function OnMove( GumpObject : TGumpObject ) : Boolean; override;
                        procedure OnButtonClick( ReturnNumber : Integer ); override;
                        procedure OnDblClick( GumpObject : TGumpObject ); override;
                        procedure OnClick( X, Y : Word ); override;
                        procedure FixGumpObjects;
                        function Init( Packet : GetProfile ) : Boolean;
                        procedure OnScrollBar( GumpObject : TGumpObject ); override;
                        procedure OnInputFieldChange( InputField : TInputField ); override;
        end;

implementation

uses    uPalanthir;

constructor TProfile.Create;
begin
        inherited Create;

        StartPos := 0;

        Typ := GumpTyp_Profile;
        Rolle := False;
        X := 200;
        Y := 200;
        Hoehe := 200;

        RollenGump := TGImage.Create;
        RollenGump.X := 0;
        RollenGump.Y := 0;
        RollenGump.Id := $9D4;
        RollenGump.Gump := Self;
        RollenGump.Typ := gt_Image;

        ScrollBar := AddScrollBar( 257, 70, False, Hoehe-35, $1F, $1F, 1, 0 );

        StaticTextField := TCroppedText.Create;
        StaticTextField.X := 50;
        StaticTextField.Y := 90;
        StaticTextField.MinX := 0;
        StaticTextField.MinY := 0;
        StaticTextField.Font := 0;
        StaticTextField.Hue := $481;
        StaticTextField.MaxLines := $FF;
        StaticTextField.Breite := 200;
        StaticTextField.Gump := Self;
        StaticTextField.Typ := gt_CroppedText;
        StaticTextField.Border := False;
        StaticTextField.DoMouseCheck := False;

        TitleField := TGumpText.Create;
        TitleField.X := 50;
        TitleField.Y := 70;
        TitleField.Font := 0;
        TitleField.Hue := 1;
        TitleField.Gump := Self;
        TitleField.Typ := gt_Text;

        Entry := TInputField.Create;
        Entry.Gump := Self;
        Entry.X := 50;
        Entry.Y := 90;
        Entry.HasStars := False;
        Entry.Typ := gt_InputField;
        Entry.AllowOnlyNumbers := False;
        Entry.AllowMultiLines := True;
        Entry.Breite := 200;
        Entry.Hoehe := 160;
        Entry.MinX := 0;
        Entry.MinY := 0;
        Entry.TextId := 0;
        Entry.Border := False;
        Entry.Hue := $481;

        //Hintergrund
        AddImage( 0, 23, $820, 0, 0 );
        AddImage( 17, 60+Hoehe, $823, 0, 0 );

        //Wimpel oben
        AddButton( 137, 0, $82D, $82D, 2, 0 );

        //Verzierungen
        AddImage( 30, 59, $82B, 0, 0 );

        //Pfeile rechts oben und unten
        AddImage( 249, 57, $824, 0, 0 );
        AddImage( 250, 60+Hoehe-17, $825, 0, 0 );

        //Button Unten
        AddButton( 137, 60+Hoehe+32, $82E, $82F, 1, 0 );

        FixGumpObjects;
end;

destructor TProfile.Free;
begin
        RollenGump.Free;
        StaticTextField.Free;
        TitleField.Free;
        Entry.Free;

        inherited Free;
end;

function TProfile.Draw : Boolean;
var     I : Integer;
begin
        Result := True;

        if Fix then
                FixGumpObjects;

        if Rolle then begin
                RollenGump.Draw;
        end
        else begin
                for I := 7 to GetObjectCount-1 do
                        if (GetObject( I ) <> nil) and ((GetObject( I ).Page = 0) or (GetObject( I ).Page = ActivePage)) then
                                GetObject( I ).Draw;

                for I := 0 to Min( GetObjectCount-1, 6 ) do
                        if (GetObject( I ) <> nil) and ((GetObject( I ).Page = 0) or (GetObject( I ).Page = ActivePage)) then
                                GetObject( I ).Draw;

                StartPos := Max( Round( (TextHoehe - Hoehe + 45)*ScrollBar.Promille/1000 ), 0 );
                TitleField.Draw;
                StaticTextField.MinY := StartPos;
                StaticTextField.Y := 90;
                StaticTextField.Hoehe := Min( Max( 0, StaticTextField.GetTextureHoehe - StartPos ), Hoehe - 40 );
                StaticTextField.Draw;

                if StaticTextField.Hoehe > 0 then begin
                        Entry.Y := 90 + StaticTextField.Hoehe + 20;
                        Entry.MinY := Max( 0, StartPos - StaticTextField.GetTextureHoehe - 20 );
                end else begin
                        Entry.Y := 90;
                        Entry.MinY := StartPos;
                end;
                Entry.Hoehe := Max( 0, Hoehe - Entry.Y + 50 );
                Entry.Draw;
        end;
end;

function TProfile.OnMove( GumpObject : TGumpObject ) : Boolean;
var     TmpHoehe : Word;
begin
        if GumpObject.Typ = gt_Button then begin
                if TGumpButton( GumpObject ).ReturnNumber = 1 then begin
                        TmpHoehe := Hoehe - ( Palanthir.Maus.MY - Palanthir.Maus.AktY );
                        Palanthir.Maus.MY := Palanthir.Maus.AktY;
                        Palanthir.Maus.MX := Palanthir.Maus.AktX;
                        if (TmpHoehe > 80) and (TmpHoehe < 700) then begin
                                Hoehe := TmpHoehe;
                                Fix := True;

                                if Hoehe > TextHoehe then begin
                                        StartPos := 0;
                                end;

                                //Entry.Hoehe := Max( 0, Hoehe - 45 - StaticTextField.GetTextureHoehe - 20 - StartPos );

                                ScrollBar.Hoehe := Hoehe - 35;
                        end;
                end;
                Result := False;
        end
        else begin
                Result := inherited OnMove( GumpObject );
        end;
end;

procedure TProfile.OnButtonClick( ReturnNumber : Integer );
var     SendProfileUpdateRequest : TSendProfileUpdateRequest;
begin
        case ReturnNumber of
                0 : begin
                        SendProfileUpdateRequest := TSendProfileUpdateRequest.Create;
                        SendProfileUpdateRequest.SetSerial( CharSerial );
                        SendProfileUpdateRequest.SetText( Entry.Text );
                        Palanthir.SendPacket( SendProfileUpdateRequest );

                        if (Palanthir.Keyboard.SelectedGumpObject <> nil) and (Self = Palanthir.Keyboard.SelectedGumpObject.Gump) then begin
                                Palanthir.Keyboard.KeyboardMode := KB_Speech;
                                Palanthir.Keyboard.Typ := KB_Speech_Regular;
                                Palanthir.Keyboard.SelectedGumpObject := nil;
                        end;

                        Palanthir.DeleteGump( Self );
                        end;
                2 : Rolle := True;
        end;
end;

procedure TProfile.OnClick( X, Y : Word );
begin
        if IsInRect( X, Y, 249, 57, 264, 72 ) then begin
                if ScrollBar.Promille > 100 then
                        ScrollBar.Promille := ScrollBar.Promille - 100;
        end
        else if IsInRect( X, Y, 250, 60+Hoehe-17, 265, 60+Hoehe-2 ) then begin
                if ScrollBar.Promille < 900 then
                        ScrollBar.Promille := ScrollBar.Promille + 100;
        end;
end;

procedure TProfile.OnDblClick( GumpObject : TGumpObject );
begin
        if Rolle then
                Rolle := False;
end;

procedure TProfile.FixGumpObjects;
var     I : Integer;
begin
        while GetObjectCount > 8 do begin
                DeleteObject( 8 );
        end;

        TGImage( GetObject( 2 ) ).Y := 60 + Hoehe;
        TGImage( GetObject( 6 ) ).Y := 60 + Hoehe - 17;
        TGumpButton( GetObject( 7 ) ).Y := 60 + Hoehe + 32;

        for I := 0 to (Hoehe div 60)-1 do begin
                if (I mod 2) = 0 then
                        AddImage( 17, 60+I*60, $821, 0, 0 )
                else
                        AddImage( 17, 60+I*60, $822, 0, 0 );
        end;
        AddTiledImage( 17, 60+60*(Hoehe div 60), Hoehe mod 60, 262, $822, 0, 0 );
end;

function TProfile.Init( Packet : GetProfile ) : Boolean;
var     K : Word;
        B : Byte;
        W : Word;
begin
        CharSerial := Packet.GetSerial;

        Title := '';
        K := 7;
        B := Packet.GetByte( K );

        while B <> 0 do begin
                Title := Title + Chr( B );
                Inc( K );
                B := Packet.GetByte( K );
        end;
        Title := Utf8Decode( Title );
        Inc( K );

        StaticText := '';
        W := Packet.GetWord( K );

        while W <> 0 do begin
                StaticText := StaticText + WideChar( W );
                Inc( K, 2 );
                W := Packet.GetWord( K );
        end;

        Inc( K, 2 );
        Text := '';
        W := Packet.GetWord( K );

        while W <> 0 do begin
                Text := Text + WideChar( W );
                Inc( K, 2 );
                W := Packet.GetWord( K );
        end;

        TitleField.Text := Title;
        StaticTextField.Text := StaticText;

        if Text = '' then begin
                TextHoehe := StaticTextField.GetTextureHoehe + 20;
        end else begin
                Entry.Text := Text;
        end;

        Result := True;
end;

procedure TProfile.OnScrollBar( GumpObject : TGumpObject );
begin
        StartPos := Max( Round( (TextHoehe - Hoehe + 45)*TScrollBar( GumpObject ).Promille/1000 ), 0 );
end;

procedure TProfile.OnInputFieldChange( InputField : TInputField );
begin
        if (Entry.Texture = nil) or (Entry.Texture.Hoehe = 0) then begin
                TextHoehe := StaticTextField.GetTextureHoehe;
        end else begin
                TextHoehe := StaticTextField.GetTextureHoehe + Entry.Texture.Hoehe + 20;
        end;

        if InputField.SelectedPos = Length( InputField.Text ) then begin
                StartPos := Max( (TextHoehe - Hoehe + 45), 0 );

                if StaticTextField.GetTextureHoehe > 0 then begin
                        Entry.Hoehe := Max( 0, Hoehe - 45 - StaticTextField.GetTextureHoehe - 20 - StartPos );
                end else begin
                        Entry.Hoehe := Max( 0, Hoehe - 45 - StartPos );
                end;
        end;
end;

end.
