unit uPythonGump;

interface

uses    uGumps, uPythonFunction, Python;

type    TPythonGump = Class( TGump )
                private
                        OnButtonClickEvent,
                        OnClickEventXY,
                        OnDblClickEvent,
                        OnDblClickEventXY,
                        OnCheckBoxChangeEvent,
                        OnScrollBarChangeEvent,
                        OnMoveOverButtonEvent,
                        OnMoveEvent,
                        OnDrawEvent,
                        OnKeyReturnEvent,
                        OnKeyTabEvent,
                        OnInputFieldChangeEvent,
                        OnScrollBarReleaseEvent,
                        OnBeforeDrawEvent,
                        OnAfterDrawEvent,
                        OnDeleteEvent,
                        OnMouseDownEvent,
                        OnMouseUpEvent : TPythonFunction;
                public
                        CustomVars : PPyObject;
                        constructor Create; override;
                        destructor Free; override;
                        procedure OnButtonClick( ReturnNumber : Integer ); override;
                        procedure OnClick( X, Y : Word ); override;
                        procedure OnDblClick( GumpObject : TGumpObject ); overload; override;
                        function OnDblClick( X, Y : Word ) : Boolean; overload; override;
                        procedure OnCheckBoxChange( CheckBox : TCheckBox ); override;
                        procedure OnScrollBar( GumpObject : TGumpObject ); override;
                        procedure OnMoveOverButton( ReturnNumber : Integer ); override;
                        function OnMove( GumpObject : TGumpObject ) : Boolean; override;
                        function Draw : Boolean; override;
                        function OnKeyReturn( GumpObject : TGumpObject ) : Boolean; override;
                        function OnKeyTab( GumpObject : TGumpObject ) : Boolean; override;
                        procedure OnInputFieldChange( InputField : TInputField ); override;
                        procedure OnScrollBarRelease( ScrollBar : TScrollBar ); override;
                        procedure OnBeforeDraw; override;
                        procedure OnAfterDraw; override;
                        procedure OnDelete; override;
                        procedure OnMouseDown( GumpObject : TGumpObject ); override;                        
                        procedure OnMouseUp( GumpObject : TGumpObject ); override;

                        procedure SetOnButtonClickEvent( Event : PPyObject );
                        procedure SetOnClickEventXY( Event : PPyObject );
                        procedure SetOnDblClickEvent( Event : PPyObject );
                        procedure SetOnDblClickEventXY( Event : PPyObject );
                        procedure SetOnCheckBoxChangeEvent( Event : PPyObject );
                        procedure SetOnScrollBarChangeEvent( Event : PPyObject );
                        procedure SetOnMoveOverButtonEvent( Event : PPyObject );
                        procedure SetOnMoveEvent( Event : PPyObject );
                        procedure SetOnDrawEvent( Event : PPyObject );
                        procedure SetOnKeyReturnEvent( Event : PPyObject );
                        procedure SetOnKeyTabEvent( Event : PPyObject );
                        procedure SetOnInputFieldChangeEvent( Event : PPyObject );
                        procedure SetOnScrollBarReleaseEvent( Event : PPyObject );
                        procedure SetOnBeforeDrawEvent( Event : PPyObject );
                        procedure SetOnAfterDrawEvent( Event : PPyObject );
                        procedure SetOnDeleteEvent( Event : PPyObject );
                        procedure SetOnMouseDown( Event : PPyObject );
                        procedure SetOnMouseUp( Event : PPyObject );
        end;

        P_PythonGump = ^TPythonGump;

implementation

uses    uPyGump, uPyGumpObject;

constructor TPythonGump.Create;
begin
        inherited Create;
        Typ := GumpTyp_PythonGump;

        CustomVars := nil;
        OnButtonClickEvent := nil;
        OnClickEventXY := nil;
        OnDblClickEvent := nil;
        OnDblClickEventXY := nil;
        OnCheckBoxChangeEvent := nil;
        OnScrollBarChangeEvent := nil;
        OnMoveOverButtonEvent := nil;
        OnMoveEvent := nil;
        OnDrawEvent := nil;
        OnKeyReturnEvent := nil;
        OnKeyTabEvent := nil;
        OnInputFieldChangeEvent := nil;
        OnScrollBarReleaseEvent := nil;
        OnBeforeDrawEvent := nil;
        OnAfterDrawEvent := nil;
        OnDeleteEvent := nil;
        OnMouseDownEvent := nil;
        OnMouseUpEvent := nil;
end;

destructor TPythonGump.Free;
begin
        if CustomVars <> nil then begin
                Py_XDECREF( CustomVars );
                CustomVars := nil;
        end;

        if OnButtonClickEvent <> nil then
                OnButtonClickEvent.Free;

        if OnClickEventXY <> nil then
                OnClickEventXY.Free;

        if OnDblClickEvent <> nil then
                OnDblClickEvent.Free;

        if OnDblClickEventXY <> nil then
                OnDblClickEventXY.Free;

        if OnCheckBoxChangeEvent <> nil then
                OnCheckBoxChangeEvent.Free;

        if OnScrollBarChangeEvent <> nil then
                OnScrollBarChangeEvent.Free;

        if OnMoveOverButtonEvent <> nil then
                OnMoveOverButtonEvent.Free;

        if OnMoveEvent <> nil then
                OnMoveEvent.Free;

        if OnDrawEvent <> nil then
                OnDrawEvent.Free;

        if OnKeyReturnEvent <> nil then
                OnKeyReturnEvent.Free;

        if OnKeyTabEvent <> nil then
                OnKeyTabEvent.Free;

        if OnInputFieldChangeEvent <> nil then
                OnInputFieldChangeEvent.Free;

        if OnScrollBarReleaseEvent <> nil then
                OnScrollBarReleaseEvent.Free;

        if OnDeleteEvent <> nil then
                OnDeleteEvent.Free;

        if OnMouseDownEvent <> nil then
                OnMouseDownEvent.Free;

        if OnMouseUpEvent <> nil then
                OnMouseUpEvent.Free;

        inherited Free;
end;

procedure TPythonGump.OnButtonClick( ReturnNumber : Integer );
var     Args : PPyObject;
begin
        if OnButtonClickEvent <> nil then begin
                Args := Py_BuildValue( '(O&i)', [@pyGetGump,Self,ReturnNumber] );
                if OnButtonClickEvent.CallFunction( Args ) then begin
                        Exit;
                end;
                Py_XDECREF( Args );
        end;

        inherited OnButtonClick( ReturnNumber );
end;

procedure TPythonGump.OnClick( X, Y : Word );
var     Args : PPyObject;
begin
        if OnClickEventXY <> nil then begin
                Args := Py_BuildValue( '(O&hh)', [@pyGetGump,Self,X,Y] );
                if OnClickEventXY.CallFunction( Args ) then begin
                        Exit;
                end;
                Py_XDECREF( Args );
        end;

        inherited OnClick( X, Y );
end;

procedure TPythonGump.OnDblClick( GumpObject : TGumpObject );
var     Args : PPyObject;
begin
        if OnDblClickEvent <> nil then begin
                Args := Py_BuildValue( '(O&O&)', [@pyGetGump,Self,@pyGetGumpObject,GumpObject] );
                if OnDblClickEvent.CallFunction( Args ) then begin
                        Exit;
                end;
                Py_XDECREF( Args );
        end;

        inherited OnDblClick( GumpObject );
end;

function TPythonGump.OnDblClick( X, Y : Word ) : Boolean;
var     Args : PPyObject;
begin
        if OnDblClickEventXY <> nil then begin
                Args := Py_BuildValue( '(O&ii)', [@pyGetGump,Self,X,Y] );
                if OnDblClickEventXY.CallFunction( Args ) then begin
                        Result := False;
                        Exit;
                end;
                Py_XDECREF( Args );
        end;

        Result := inherited OnDblClick( X, Y );
end;

procedure TPythonGump.OnCheckBoxChange( CheckBox : TCheckBox );
var     Args : PPyObject;
begin
        if OnCheckBoxChangeEvent <> nil then begin
                Args := Py_BuildValue( '(O&O&)', [@pyGetGump,Self,@pyGetGumpObject,CheckBox] );
                if OnCheckBoxChangeEvent.CallFunction( Args ) then begin
                        Exit;
                end;
                Py_XDECREF( Args );
        end;

        inherited OnCheckBoxChange( CheckBox );
end;

procedure TPythonGump.OnScrollBar( GumpObject : TGumpObject );
var     Args : PPyObject;
        ScrollBar : TScrollBar;
begin
        ScrollBar := TScrollBar( GumpObject );

        if OnScrollBarChangeEvent <> nil then begin
                Args := Py_BuildValue( '(O&O&)', [@pyGetGump,Self,@pyGetGumpObject,ScrollBar] );
                if OnScrollBarChangeEvent.CallFunction( Args ) then begin
                        Exit;
                end;
                Py_XDECREF( Args );
        end;

        inherited OnScrollBar( GumpObject );
end;

procedure TPythonGump.OnMoveOverButton( ReturnNumber : Integer );
var     Args : PPyObject;
begin
        if OnMoveOverButtonEvent <> nil then begin
                Args := Py_BuildValue( '(O&i)', [@pyGetGump,Self,ReturnNumber] );
                if OnMoveOverButtonEvent.CallFunction( Args ) then begin
                        Exit;
                end;
                Py_XDECREF( Args );
        end;

        inherited OnMoveOverButton( ReturnNumber );
end;

function TPythonGump.OnMove( GumpObject : TGumpObject ) : Boolean;
var     Args : PPyObject;
begin
        if OnMoveEvent <> nil then begin
                Args := Py_BuildValue( '(O&O&)', [@pyGetGump,Self,@pyGetGumpObject,GumpObject] );
                if OnMoveEvent.CallFunction( Args ) then begin
                        Result := False;
                        Exit;
                end;
                Py_XDECREF( Args );
        end;

        Result := inherited OnMove( GumpObject );
end;

function TPythonGump.Draw : Boolean;
var     Args : PPyObject;
begin
        if OnDrawEvent <> nil then begin
                Args := Py_BuildValue( '(O&)', [@pyGetGump,Self] );
                if OnDrawEvent.CallFunction( Args ) then begin
                        Result := True;
                        Exit;
                end;
                Py_XDECREF( Args );
        end;

        Result := inherited Draw;
end;

function TPythonGump.OnKeyReturn( GumpObject : TGumpObject ) : Boolean;
var     Args : PPyObject;
begin
        if OnKeyReturnEvent <> nil then begin
                Args := Py_BuildValue( '(O&O&)', [@pyGetGump,Self,@pyGetGumpObject,GumpObject] );
                if OnKeyReturnEvent.CallFunction( Args ) then begin
                        Result := True;
                        Exit;
                end;
                Py_XDECREF( Args );
        end;

        Result := inherited OnKeyReturn( GumpObject );
end;

function TPythonGump.OnKeyTab( GumpObject : TGumpObject ) : Boolean;
var     Args : PPyObject;
begin
        if OnKeyTabEvent <> nil then begin
                Args := Py_BuildValue( '(O&O&)', [@pyGetGump,Self,@pyGetGumpObject,GumpObject] );
                if OnKeyTabEvent.CallFunction( Args ) then begin
                        Result := True;                
                        Exit;
                end;
                Py_XDECREF( Args );
        end;

        Result := inherited OnKeyTab( GumpObject );
end;

procedure TPythonGump.OnInputFieldChange( InputField : TInputField );
var     Args : PPyObject;
begin
        if OnInputFieldChangeEvent <> nil then begin
                Args := Py_BuildValue( '(O&O&)', [@pyGetGump,Self,@pyGetGumpObject,InputField] );
                if OnInputFieldChangeEvent.CallFunction( Args ) then begin
                        Exit;
                end;
                Py_XDECREF( Args );
        end;

        inherited OnInputFieldChange( InputField );
end;

procedure TPythonGump.OnScrollBarRelease( ScrollBar : TScrollBar );
var     Args : PPyObject;
begin
        if OnScrollBarReleaseEvent <> nil then begin
                Args := Py_BuildValue( '(O&O&)', [@pyGetGump,Self,@pyGetGumpObject,ScrollBar] );
                if OnScrollBarReleaseEvent.CallFunction( Args ) then begin
                        Exit;
                end;
                Py_XDECREF( Args );
        end;

        inherited OnScrollBarRelease( ScrollBar );
end;

procedure TPythonGump.OnBeforeDraw;
var     Args : PPyObject;
begin
        if OnBeforeDrawEvent <> nil then begin
                Args := Py_BuildValue( '(O&)', [@pyGetGump,Self] );
                if OnBeforeDrawEvent.CallFunction( Args ) then begin
                        Exit;
                end;
                Py_XDECREF( Args );
        end;
end;

procedure TPythonGump.OnAfterDraw;
var     Args : PPyObject;
begin
        if OnAfterDrawEvent <> nil then begin
                Args := Py_BuildValue( '(O&)', [@pyGetGump,Self] );
                if OnAfterDrawEvent.CallFunction( Args ) then begin
                        Exit;
                end;
                Py_XDECREF( Args );
        end;
end;

procedure TPythonGump.OnDelete;
var     Args : PPyObject;
begin
        if OnDeleteEvent <> nil then begin
                Args := Py_BuildValue( '(O&)', [@pyGetGump,Self] );
                if OnDeleteEvent.CallFunction( Args ) then begin
                        Exit;
                end;
                Py_XDECREF( Args );
        end;
end;

procedure TPythonGump.OnMouseDown( GumpObject : TGumpObject );
var     Args : PPyObject;
begin
        if OnMouseDownEvent <> nil then begin
                Args := Py_BuildValue( '(O&O&)', [@pyGetGump,Self,@pyGetGumpObject,GumpObject] );
                if OnMouseDownEvent.CallFunction( Args ) then begin
                        Exit;
                end;
                Py_XDECREF( Args );
        end;
end;

procedure TPythonGump.OnMouseUp( GumpObject : TGumpObject );
var     Args : PPyObject;
begin
        if OnMouseUpEvent <> nil then begin
                Args := Py_BuildValue( '(O&O&)', [@pyGetGump,Self,@pyGetGumpObject,GumpObject] );
                if OnMouseUpEvent.CallFunction( Args ) then begin
                        Exit;
                end;
                Py_XDECREF( Args );
        end;
end;

procedure TPythonGump.SetOnButtonClickEvent( Event : PPyObject );
begin
        if OnButtonClickEvent <> nil then
                OnButtonClickEvent.Free;

        OnButtonClickEvent := TPythonFunction.Create( Event );
end;

procedure TPythonGump.SetOnClickEventXY( Event : PPyObject );
begin
        if OnClickEventXY <> nil then
                OnClickEventXY.Free;

        OnClickEventXY := TPythonFunction.Create( Event );
end;

procedure TPythonGump.SetOnDblClickEvent( Event : PPyObject );
begin
        if OnDblClickEvent <> nil then
                OnDblClickEvent.Free;

        OnDblClickEvent := TPythonFunction.Create( Event );
end;

procedure TPythonGump.SetOnDblClickEventXY( Event : PPyObject );
begin
        if OnDblClickEventXY <> nil then
                OnDblClickEventXY.Free;

        OnDblClickEventXY := TPythonFunction.Create( Event );
end;

procedure TPythonGump.SetOnCheckBoxChangeEvent( Event : PPyObject );
begin
        if OnCheckBoxChangeEvent <> nil then
                OnCheckBoxChangeEvent.Free;

        OnCheckBoxChangeEvent := TPythonFunction.Create( Event );
end;

procedure TPythonGump.SetOnScrollBarChangeEvent( Event : PPyObject );
begin
        if OnScrollBarChangeEvent <> nil then
                OnScrollBarChangeEvent.Free;

        OnScrollBarChangeEvent := TPythonFunction.Create( Event );
end;

procedure TPythonGump.SetOnMoveOverButtonEvent( Event : PPyObject );
begin
        if OnMoveOverButtonEvent <> nil then
                OnMoveOverButtonEvent.Free;

        OnMoveOverButtonEvent := TPythonFunction.Create( Event );
end;

procedure TPythonGump.SetOnMoveEvent( Event : PPyObject );
begin
        if OnMoveEvent <> nil then
                OnMoveEvent.Free;

        OnMoveEvent := TPythonFunction.Create( Event );
end;

procedure TPythonGump.SetOnDrawEvent( Event : PPyObject );
begin
        if OnDrawEvent <> nil then
                OnDrawEvent.Free;

        OnDrawEvent := TPythonFunction.Create( Event );
end;

procedure TPythonGump.SetOnKeyReturnEvent( Event : PPyObject );
begin
        if OnKeyReturnEvent <> nil then
                OnKeyReturnEvent.Free;

        OnKeyReturnEvent := TPythonFunction.Create( Event );
end;

procedure TPythonGump.SetOnKeyTabEvent( Event : PPyObject );
begin
        if OnKeyTabEvent <> nil then
                OnKeyTabEvent.Free;

        OnKeyTabEvent := TPythonFunction.Create( Event );
end;

procedure TPythonGump.SetOnInputFieldChangeEvent( Event : PPyObject );
begin
        if OnInputFieldChangeEvent <> nil then
                OnInputFieldChangeEvent.Free;

        OnInputFieldChangeEvent := TPythonFunction.Create( Event );
end;

procedure TPythonGump.SetOnScrollBarReleaseEvent( Event : PPyObject );
begin
        if OnScrollBarReleaseEvent <> nil then
                OnScrollBarReleaseEvent.Free;

        OnScrollBarReleaseEvent := TPythonFunction.Create( Event );
end;

procedure TPythonGump.SetOnBeforeDrawEvent( Event : PPyObject );
begin
        if OnBeforeDrawEvent <> nil then
                OnBeforeDrawEvent.Free;

        OnBeforeDrawEvent := TPythonFunction.Create( Event );
end;

procedure TPythonGump.SetOnAfterDrawEvent( Event : PPyObject );
begin
        if OnAfterDrawEvent <> nil then
                OnAfterDrawEvent.Free;

        OnAfterDrawEvent := TPythonFunction.Create( Event );
end;

procedure TPythonGump.SetOnDeleteEvent( Event : PPyObject );
begin
        if OnDeleteEvent <> nil then
                OnDeleteEvent.Free;

        OnDeleteEvent := TPythonFunction.Create( Event );
end;

procedure TPythonGump.SetOnMouseDown( Event : PPyObject );
begin
        if OnMouseDownEvent <> nil then
                OnMouseDownEvent.Free;

        OnMouseDownEvent := TPythonFunction.Create( Event );
end;

procedure TPythonGump.SetOnMouseUp( Event : PPyObject );
begin
        if OnMouseUpEvent <> nil then
                OnMouseUpEvent.Free;

        OnMouseUpEvent := TPythonFunction.Create( Event );
end;

end.
