unit uSecureTrading;

interface

uses    uGumps, uSpecialGumps, uSendPackets;

type    TSecureTradingContainer = Class;

        TSecureTradingGump = Class( TGump )
                public
                        PartnerSerial : LongWord;
                        PartnerName : String;
                        Cont1, Cont2 : TSecureTradingContainer;
                        constructor Create; override;
                        destructor Free; override;
                        function Draw : Boolean; override;
                        procedure SetButton1( Value : Boolean );
                        procedure SetButton2( Value : Boolean );
                        procedure OnCheckBoxChange( CheckBox : TCheckBox ); override;
                        procedure OnButtonClick( ReturnNumber : Integer ); override;
                        function OnMove( GumpObject : TGumpObject ) : Boolean; override;
        end;

        TSecureTradingContainer = Class( TContainer )
                public
                        TradingGump : TSecureTradingGump;
                        BackGround : TTiledImage;
                        constructor Create; override;
                        function OnMove( GumpObject : TGumpObject ) : Boolean; override;
        end;

implementation

uses    uPalanthir;

constructor TSecureTradingGump.Create;
begin
        inherited Create;
        Typ := GumpTyp_SecureTrading;
        X := 200;
        Y := 200;

        if Palanthir.EnabledME then begin
                Cont1 := TSecureTradingContainer.Create;
                Cont1.X := X+44;
                Cont1.Y := Y+81;

                Cont1.Typ := GumpTyp_Container;
                Cont1.BackGround := Cont1.AddTiledImage( 0, 0, 68, 113, $588, 1, 0 );
                //Cont1.AddCheckerTrans( 0, 0, 68, 113, 0 );
                Cont1.TradingGump := Self;

                Cont2 := TSecureTradingContainer.Create;
                Cont2.X := X + 192;
                Cont2.Y := Y + 65;
                Cont2.Typ := GumpTyp_Container;
                Cont2.BackGround := Cont2.AddTiledImage( 0, 0, 68, 113, $588, 1, 0 );
                //Cont2.AddCheckerTrans( 0, 0, 68, 113, 0 );
                Cont2.TradingGump := Self;

                AddImage( 0, 0, $866, 0, 0 );
                AddImage( 252, 149, $208, 0, 0 );
                AddCheckBox( 37, 18, $208, $209, False, 1, 0 );
                AddText( 87, 30, '', 0, $481, 0 );
                AddText( 262, 160, '', 0, $481, 0 );
        end
        else begin
                Cont1 := TSecureTradingContainer.Create;
                Cont1.X := X+44;
                Cont1.Y := Y+85;

                Cont1.Typ := GumpTyp_Container;
                Cont1.BackGround := Cont1.AddTiledImage( 0, 0, 67, 121, $588, 0, 0 );
                Cont1.TradingGump := Self;

                Cont2 := TSecureTradingContainer.Create;
                Cont2.X := X + 192;
                Cont2.Y := Y + 69;
                Cont2.Typ := GumpTyp_Container;
                Cont2.BackGround := Cont2.AddTiledImage( 0, 0, 67, 121, $588, 0, 0 );
                Cont2.TradingGump := Self;

                AddImage( 0, 0, $866, 0, 0 );
                AddImage( 269, 158, $867, 0, 0 );
                AddCheckBox( 52, 31, $869, $867, False, 1, 0 );
                AddText( 87, 36, '', 0, 0, 0 );
                AddText( 262, 166, '', 0, 0, 0 );
        end;
end;

destructor TSecureTradingGump.Free;
var     I : Integer;
begin
        for I := 0 to Cont1.GetObjectCount-1 do begin
                if Cont1.GetObject( I ) = Palanthir.Maus.SelectedGumpObject then begin
                        Palanthir.Maus.SelectedGumpObject := nil;
                end;
                if Cont1.GetObject( I ) = Palanthir.Keyboard.SelectedGumpObject then begin
                        Palanthir.Keyboard.SelectedGumpObject := nil;
                        if Palanthir.GameWindow <> nil then
                                Palanthir.Keyboard.KeyboardMode := KB_Speech
                        else
                                Palanthir.Keyboard.KeyboardMode := KB_None;
                end;
        end;

        for I := 0 to Cont2.GetObjectCount-1 do begin
                if Cont2.GetObject( I ) = Palanthir.Maus.SelectedGumpObject then begin
                        Palanthir.Maus.SelectedGumpObject := nil;
                end;
                if Cont2.GetObject( I ) = Palanthir.Keyboard.SelectedGumpObject then begin
                        Palanthir.Keyboard.SelectedGumpObject := nil;
                        if Palanthir.GameWindow <> nil then
                                Palanthir.Keyboard.KeyboardMode := KB_Speech
                        else
                        Palanthir.Keyboard.KeyboardMode := KB_None;
                end;
        end;

        Cont1.Free;
        Cont2.Free;
        inherited Free;
end;

function TSecureTradingGump.Draw : Boolean;
begin
        TGumpText( GetObject( 3 ) ).Text := Palanthir.Player.Name;
        TGumpText( GetObject( 4 ) ).Text := PartnerName;
        if TGumpText( GetObject( 4 ) ).Text <> '' then
                TGumpText( GetObject( 4 ) ).X := 262 - TGumpText( GetObject( 4 ) ).GetTextureBreite;

        Result := inherited Draw;

        Cont1.Draw;
        Cont2.Draw;
end;

procedure TSecureTradingGump.SetButton1( Value : Boolean );
begin
        if Value then
                TGImage( GetObject( 1 ) ).Id := $208
        else
                TGImage( GetObject( 1 ) ).Id := $209;
end;

procedure TSecureTradingGump.SetButton2( Value : Boolean );
begin
        TCheckBox( GetObject( 2 ) ).Checked := Value;
end;

procedure TSecureTradingGump.OnCheckBoxChange( CheckBox : TCheckBox );
var     Trading : TSendSecureTrading;
begin
        if CheckBox.ReturnNumber = 1 then begin
                Trading := TSendSecureTrading.Create;
                Trading.SetAction( 2 );
                Trading.SetSerial1( Cont1.ItemSerial );
                if CheckBox.Checked then
                        Trading.SetSerial2( 1 )
                else
                        Trading.SetSerial2( 0 );
                Trading.SetSerial3( 0 );
                Palanthir.SendPacket( Trading );
        end;
end;

procedure TSecureTradingGump.OnButtonClick( ReturnNumber : Integer );
var     Trading : TSendEndSecureTrading;
begin
        if ReturnNumber = 0 then begin
                Trading := TSendEndSecureTrading.Create;
                Trading.SetAction( 1 );
                Trading.SetSerial1( Cont1.ItemSerial );
                Palanthir.SendPacket( Trading );
        end;
end;

function TSecureTradingGump.OnMove( GumpObject : TGumpObject ) : Boolean;
var     DX, DY : Integer;
begin
        DX := - ( Palanthir.Maus.MX - Palanthir.Maus.AktX );
        Dy := - ( Palanthir.Maus.MY - Palanthir.Maus.AktY );
        Palanthir.Maus.MX := Palanthir.Maus.AktX;
        Palanthir.Maus.MY := Palanthir.Maus.AktY;

        X := X + DX;
        Y := Y + DY;
        Cont1.X := Cont1.X + DX;
        Cont1.Y := Cont1.Y + DY;
        Cont2.X := Cont2.X + DX;
        Cont2.Y := Cont2.Y + DY;

        Result := False;
end;

constructor TSecureTradingContainer.Create;
begin
        inherited Create;
        noClose := True;
end;

function TSecureTradingContainer.OnMove( GumpObject : TGumpObject ) : Boolean;
begin
        Result := TradingGump.OnMove( GumpObject );
end;

end.
