unit uSellWindow;

interface

uses    uGumps, uRecievePackets, uChar, uItem, Classes, SysUtils, uUtilities,
        Math, uSendPackets;

type    TSellWindow = Class( TGump )
                private
                        VendorSerial : LongWord;
                        Liste : TList;
                        FirstSellItem, FirstSoldItem, SoldCount : Integer;
                        MomGold : TGumpText;
                public
                        constructor Create; override;
                        destructor Free; override;
                        function Draw : Boolean; override;
                        procedure OnScrollBar( GumpObject : TGumpObject ); override;
                        procedure OnClick( X, Y : Word ); override;
                        function OnDblClick( X, Y : Word ) : Boolean; override;
                        procedure Init( Packet : GetSellList );
        end;

        TSellItem = Record
                Price : LongWord;
                Description : String;
                Serial : LongWord;
                Amount : Word;
                Id : Word;
                Color : Word;
                ToolTipText : String;

                GODescription : TCroppedText;
                GOAmount : TGumpText;
                GOImage : TTilePic;
                GOSelAmount : TGumpText;
                GOIncButton, GoDecButton : TGumpButton;

                SelectedAmount : Word;
        end;

        PSellItem = ^TSellItem;

implementation

uses    uPalanthir;

constructor TSellWindow.Create;
begin
        inherited Create;
        Liste := TList.Create;

        FirstSellItem := 0;
        FirstSoldItem := 0;
        SoldCount := 0;

        MomGold := TGumpText.Create( 360, 390, '0', 0, 0, 0 );
        MomGold.Gump := Self;

        AddImage( 0, 0, $872, 0, 0 );
        AddImage( 170, 225, $873, 0, 0 );

        AddScrollBar( 240, 60, False, 127, $1F, $1F, 1, 0 );
        AddScrollBar( 410, 290, False, 86, $1F, $1F, 2, 0 );
end;

destructor TSellWindow.Free;
var     I : Integer;
begin
        for I := 0 to Liste.Count-1 do begin
                PSellItem( Liste.Items[ I ] ).GODescription.Free;
                PSellItem( Liste.Items[ I ] ).GOAmount.Free;
                PSellItem( Liste.Items[ I ] ).GOImage.Free;
                PSellItem( Liste.Items[ I ] ).GOSelAmount.Free;
                PSellItem( Liste.Items[ I ] ).GOIncButton.Free;
                PSellItem( Liste.Items[ I ] ).GoDecButton.Free;                                
                Dispose( Liste.Items[ I ] );
        end;

        inherited Free;
end;

procedure TSellWindow.Init( Packet : GetSellList );
var     Char : TChar;
        I, Position : Integer;
        StrLength : Word;
        SellItem : PSellItem;
        ClilocID : LongWord;
begin
        VendorSerial := Packet.GetVendorSerial;

        Char := TChar( Palanthir.Data.GlobalObjectList.GetObject( VendorSerial ) );
        if Char = nil then begin
                Self.Free;
                exit;
        end;

        Position := 9;
        for I := 0 to Packet.GetItemCount-1 do begin
                New( SellItem );

                SellItem.Serial := Packet.GetLongWord( Position );
                SellItem.Id := Packet.GetWord( Position + 4 );
                SellItem.Color := Packet.GetWord( Position + 6 );
                SellItem.Amount := Packet.GetWord( Position + 8 );
                SellItem.Price := Packet.GetWord( Position + 10 );
                SellItem.SelectedAmount := 0;

                StrLength := Packet.GetWord( Position + 12 );
                SellItem.Description := Packet.GetAsciiString( Position + 14, StrLength );

                try
                        ClilocID := StrToInt( SellItem.Description );
                        SellItem.Description := Palanthir.Data.GetClilocMessage( ClilocID );
                except
                        //Do nothing;
                end;

                Position := Position + 14 + StrLength;

                SellItem.GODescription := TCroppedText.Create( 0, 0, 40, 110, Format( '%s : %d', [SellItem.Description,SellItem.Price] ), 0, 0, 0, 2 );
                SellItem.GODescription.Gump := Self;

                SellItem.GOAmount := TGumpText.Create( 0, 0, IntToStr( SellItem.Amount-SellItem.SelectedAmount ), 0, 0, 0 );
                SellItem.GOAmount.Gump := Self;

                SellItem.GOImage := TTilePic.Create( 0, 0, SellItem.Id, SellItem.Color, 0 );
                SellItem.GOImage.Gump := Self;

                SellItem.GOSelAmount := TGumpText.Create( 0, 0, IntToStr( SellItem.SelectedAmount ), 0, 0, 0 );
                SellItem.GOSelAmount.Gump := Self;

                SellItem.GOIncButton := TGumpButton.Create( 0, 0, $37, $37, $37, Liste.Count*2+2, 0 );
                SellItem.GOIncButton.Gump := Self;

                SellItem.GoDecButton := TGumpButton.Create( 0, 0, $38, $38, $38, Liste.Count*2+3, 0 );
                SellItem.GoDecButton.Gump := Self;

                Liste.Add( SellItem );
        end;

        Palanthir.AddGump( Self );
        Packet.Free;
end;

function TSellWindow.Draw : Boolean;
var     I, SellCount, SCount : Integer;
        SellItem : PSellItem;
        Gold : LongWord;
        Promille : Word;
begin
        if FirstSoldItem > Max( 0, SoldCount-3 ) then
                FirstSoldItem := Max( 0, SoldCount-3 );

        if GetObjectCount = 0 then begin
                Result := True;
                exit;
        end;

        if Liste.Count > 3 then begin
                Promille := TScrollBar( GetObject( 2 ) ).Promille;
                if (Promille <= Trunc(1000*FirstSellItem/(Liste.Count-3))) or (Promille >= Trunc(1000*(FirstSellItem+1)/(Liste.Count-3))) then begin
                        TScrollBar( GetObject( 2 ) ).Promille := Trunc(1000*FirstSellItem/(Liste.Count-3));
                end;
        end;

        if SoldCount > 3 then begin
                Promille := TScrollBar( GetObject( 3 ) ).Promille;
                if (Promille <= Trunc(1000*FirstSoldItem/(SoldCount-3))) or (Promille >= Trunc(1000*(FirstSoldItem+1)/(SoldCount-3))) then begin
                        TScrollBar( GetObject( 3 ) ).Promille := Trunc(1000*FirstSoldItem/(SoldCount-3));
                end;
        end;

        Result := inherited Draw;

        SellCount := 0;
        SCount := 0;
        Gold := 0;

        for I := 0 to Liste.Count-1 do begin
                SellItem := PSellItem( Liste.Items[ I ] );

                if (I >= FirstSellItem) and (SellCount < 3) then begin
                        SellItem.GOImage.X := 44;
                        SellItem.GOImage.Y := 72 + 62*SellCount;
                        SellItem.GOImage.Draw;

                        SellItem.GODescription.X := 92;
                        SellItem.GODescription.Y := 72 + 62*SellCount;
                        SellItem.GODescription.Hoehe := 40;
                        SellItem.GODescription.Draw;

                        SellItem.GOAmount.X := 208;
                        SellItem.GOAmount.Y := 83 + 62*SellCount;
                        SellItem.GOAmount.Draw;

                        Inc( SellCount );
                end;

                if (SCount >= FirstSoldItem) and (SCount < FirstSoldItem+3) and (SellItem.SelectedAmount > 0) then begin
                        SellItem.GOSelAmount.X := 208;
                        SellItem.GOSelAmount.Y := 290 + (SCount-FirstSoldItem)*35;
                        SellItem.GOSelAmount.Draw;

                        SellItem.GODescription.X := 228;
                        SellItem.GODescription.Y := 288 + (SCount-FirstSoldItem)*35;
                        SellItem.GODescription.Hoehe := 376 - SellItem.GODescription.Y;
                        SellItem.GODescription.Draw;

                        SellItem.GOIncButton.X := 372;
                        SellItem.GOIncButton.Y := 291 + (SCount-FirstSoldItem)*35;
                        SellItem.GOIncButton.Draw;

                        SellItem.GoDecButton.X := 392;
                        SellItem.GoDecButton.Y := 291 + (SCount-FirstSoldItem)*35;
                        SellItem.GoDecButton.Draw;
                end;

                if SellItem.SelectedAmount > 0 then begin
                        Inc( SCount );
                        Gold := Gold + SellItem.Price*SellItem.SelectedAmount;
                end;
        end;

        MomGold.Text := IntToStr( Gold );
        MomGold.Draw;
end;

procedure TSellWindow.OnScrollBar( GumpObject : TGumpObject );
begin
        case TScrollBar( GumpObject ).Number of
                1 : begin
                        if Liste.Count > 3 then begin
                                FirstSellItem := Trunc( TScrollBar( GumpObject ).Promille * (Liste.Count-3) / 1000 );
                        end;
                end;
                2 : begin
                        if SoldCount > 3 then begin
                                FirstSoldItem := Trunc( TScrollBar( GumpObject ).Promille * (SoldCount-3) / 1000 );
                        end;
                end;
        end;
end;

procedure TSellWindow.OnClick( X, Y : Word );
var     SellItem : PSellItem;
        I, K, SCount : Integer;
        SendSellItems : TSendSellItems;
begin
        if IsInRect( X, Y, 232, 48, 251, 61 ) then begin
                //Oberer linker Pfeil
                if FirstSellItem > 0 then
                        Dec( FirstSellItem );
                exit;
        end
        else if IsInRect( X, Y, 232, 190, 251, 205 ) then begin
                //Unterer linker Pfeil
                if FirstSellItem < Liste.Count-3 then
                        Inc( FirstSellItem );
                exit;
        end
        else if IsInRect( X, Y, 404, 275, 423, 289 ) then begin
                //Oberer rechter Pfeil
                if FirstSoldItem > 0 then
                        Dec( FirstSoldItem );

                exit;
        end
        else if IsInRect( X, Y, 404, 382, 423, 394 ) then begin
                //Oberer linker Pfeil
                if FirstSoldItem < SoldCount-3 then
                        Inc( FirstSoldItem );

                exit;
        end
        else if IsInRect( X, Y, 202, 410, 225, 434 ) then begin
                //Verkauf besttigen
                if SoldCount > 0 then begin
                        SendSellItems := TSendSellItems.Create;
                        SendSellItems.SetSerial( VendorSerial );

                        for I := 0 to Liste.Count-1 do begin
                                SellItem := Liste.Items[ I ];
                                if SellItem.SelectedAmount > 0 then begin
                                        SendSellItems.AddItem( SellItem.Serial, SellItem.SelectedAmount );
                                end;
                        end;

                        Palanthir.SendPacket( SendSellItems );
                end;

                Palanthir.DeleteGump( Self );
                exit;
        end
        else if IsInRect( X, Y, 377, 410, 397, 434 ) then begin
                //Verkauf verwerfen
                Palanthir.DeleteGump( Self );
                exit;
        end;

        for I := 0 to 2 do begin
                if IsInRect( X, Y, 372, 291+I*35, 386, 307+I*35 ) then begin
                        SellItem := nil;
                        SCount := 0;
                        for K := 0 to Liste.Count-1 do begin
                                if PSellItem( Liste.Items[ K ] ).SelectedAmount > 0 then begin
                                        if SCount = FirstSoldItem+I then begin
                                                SellItem := PSellItem( Liste.Items[ K ] );
                                                break;
                                        end;
                                        Inc( SCount );
                                end;
                        end;

                        if SellItem <> nil then begin
                                if SellItem.Amount > SellItem.SelectedAmount then begin
                                        if SellItem.SelectedAmount = 0 then
                                                Inc( SoldCount );

                                        Inc( SellItem.SelectedAmount );
                                        SellItem.GOAmount.Text := IntToStr( SellItem.Amount - SellItem.SelectedAmount );
                                        SellItem.GOSelAmount.Text := IntToStr( SellItem.SelectedAmount );
                                end;
                        end;
                        exit;
                end
                else if IsInRect( X, Y, 392, 291+I*35, 406, 307+I*35 ) then begin
                        SellItem := nil;
                        SCount := 0;
                        for K := 0 to Liste.Count-1 do begin
                                if PSellItem( Liste.Items[ K ] ).SelectedAmount > 0 then begin
                                        if SCount = FirstSoldItem+I then begin
                                                SellItem := PSellItem( Liste.Items[ K ] );
                                                break;
                                        end;
                                        Inc( SCount );
                                end;
                        end;

                        if SellItem <> nil then begin
                                if SellItem.SelectedAmount > 0 then begin
                                        if SellItem.SelectedAmount = 1 then
                                                Dec( SoldCount );

                                        Dec( SellItem.SelectedAmount );
                                        SellItem.GOAmount.Text := IntToStr( SellItem.Amount - SellItem.SelectedAmount );
                                        SellItem.GOSelAmount.Text := IntToStr( SellItem.SelectedAmount );
                                end;
                        end;
                        exit;
                end;
        end;
end;

function TSellWindow.OnDblClick( X, Y : Word ) : Boolean;
var     SellItem : PSellItem;
        I, K, SCount : Integer;
begin
        Result := True;

        if IsInRect( X, Y, 25, 58, 225, 228 ) then begin
                if Y <= 115 then begin
                        if Liste.Count > FirstSellItem then
                                SellItem := PSellItem( Liste.Items[ FirstSellItem ] )
                        else
                                SellItem := nil;
                end
                else if Y >= 172 then begin
                        if Liste.Count > FirstSellItem+2 then
                                SellItem := PSellItem( Liste.Items[ FirstSellItem+2 ] )
                        else
                                SellItem := nil;
                end
                else begin
                        if Liste.Count > FirstSellItem+1 then
                                SellItem := PSellItem( Liste.Items[ FirstSellItem+1 ] )
                        else
                                SellItem := nil;
                end;

                if SellItem <> nil then begin
                        if SellItem.Amount > SellItem.SelectedAmount then begin
                                if SellItem.SelectedAmount = 0 then
                                        Inc( SoldCount );

                                Inc( SellItem.SelectedAmount );
                                SellItem.GOAmount.Text := IntToStr( SellItem.Amount - SellItem.SelectedAmount );
                                SellItem.GOSelAmount.Text := IntToStr( SellItem.SelectedAmount );
                        end;
                end;
                exit;
        end;

        for I := 0 to 2 do begin
                if IsInRect( X, Y, 372, 291+I*35, 386, 307+I*35 ) then begin
                        SellItem := nil;
                        SCount := 0;
                        for K := 0 to Liste.Count-1 do begin
                                if PSellItem( Liste.Items[ K ] ).SelectedAmount > 0 then begin
                                        if SCount = FirstSoldItem+I then begin
                                                SellItem := PSellItem( Liste.Items[ K ] );
                                                break;
                                        end;
                                        Inc( SCount );
                                end;
                        end;

                        if SellItem <> nil then begin
                                if SellItem.Amount > SellItem.SelectedAmount then begin
                                        if SellItem.SelectedAmount = 0 then
                                                Inc( SoldCount );

                                        Inc( SellItem.SelectedAmount );
                                        SellItem.GOAmount.Text := IntToStr( SellItem.Amount - SellItem.SelectedAmount );
                                        SellItem.GOSelAmount.Text := IntToStr( SellItem.SelectedAmount );
                                end;
                        end;
                        exit;
                end
                else if IsInRect( X, Y, 392, 291+I*35, 406, 307+I*35 ) then begin
                        SellItem := nil;
                        SCount := 0;
                        for K := 0 to Liste.Count-1 do begin
                                if PSellItem( Liste.Items[ K ] ).SelectedAmount > 0 then begin
                                        if SCount = FirstSoldItem+I then begin
                                                SellItem := PSellItem( Liste.Items[ K ] );
                                                break;
                                        end;
                                        Inc( SCount );
                                end;
                        end;

                        if SellItem <> nil then begin
                                if SellItem.SelectedAmount > 0 then begin
                                        if SellItem.SelectedAmount = 1 then
                                                Dec( SoldCount );

                                        Dec( SellItem.SelectedAmount );
                                        SellItem.GOAmount.Text := IntToStr( SellItem.Amount - SellItem.SelectedAmount );
                                        SellItem.GOSelAmount.Text := IntToStr( SellItem.SelectedAmount );
                                end;
                        end;
                        exit;
                end;
        end;
end;

end.
