unit uSpecialGumps;

interface

uses    uGumps, Dialogs, SysUtils, uSendPackets, Classes, Math, StrLib, uChar,
        uItem, uUObject, uCustomGumps, uLog, uConfig, uUtilities, uLoaderHues,
        uPartyGump, uLoaderTiledata;

type    TPaperdoll = Class( TGump )
                public
                        CharSerial : LongWord;
                        Text : String;
                        Flag : Byte;
                        BackGround, AnimGump : TGImage;
                        Kopf, Torso, Beine, ArmLinks, ArmRechts, HandLinks, HandRechts : TGImage;
                        constructor Create; override;
                        destructor Free; override;
                        procedure Init( NewChar : TChar; NewText : String );
                        procedure OnButtonClick( ReturnNumber : Integer ); override;
                        procedure OnDblClick( GumpObject : TGumpObject ); override;
                        function Draw : Boolean; override;
                        procedure SetWarMode( WarMode : Boolean );
        end;

        TContainer = Class( TGump )
                public
                        ItemSerial : LongWord;
                        GumpId : Word;
                        Rolle : TGImage;
                        Small : Boolean;
                        constructor Create; override;
                        destructor Free; override;
                        procedure Init( NewItem : TItem; NewGumpId : Word );
                        procedure OnButtonClick( ReturnNumber : Integer ); override;
                        procedure OnDblClick( GumpObject : TGumpObject ); override;
                        function Draw : Boolean; override;
                        procedure OnClick( X, Y : Word ); override;
        end;

        TStatusGump = Class( TGump )
                public
                        CharSerial : LongWord;
                        StatusTyp : Byte;     //0 : short, 1 : oldplayer, 2 : newplayer
                        NameChange : Boolean;
                        Image : TGImage;
                        Name : TCroppedText;
                        HealthBackGround : TGImage;
                        HealthBar : TTiledImage;
                        ManaBackGround : TGImage;
                        ManaBar : TTiledImage;
                        StaminaBackGround : TGImage;
                        StaminaBar : TTiledImage;
                        Str, Dex, Int, Sex, Armor, Gold, Weight : TGumpText;
                        Health, MaxHealth, Stamina, MaxStamina, Mana, MaxMana : TGumpText;
                        StatCap, MaxWeight, Pets, Damage : TGumpText;
                        ResFire, ResCold, ResPoison, ResEnergy : TGumpText;
                        Volume, MaxVolume, Level, Luck : TGumpText;
                        XP : TTiledImage;
                        constructor Create( Flag : Byte ); reintroduce;
                        destructor Free; override;
                        function Draw : Boolean; override;
                        procedure OnClick( X, Y : Word ); override;
                        procedure OnButtonClick( ReturnNumber : Integer ); override;
                        procedure OnDblClick( GumpObject : TGumpObject ); override;
        end;

        TOptionsGump = Class( TGump )
                private
                        SpeechButton, EmoteButton : TTextButton;
                        SpeechColor, EmoteColor : TGumpText;
                        ScrollMusic, ScrollSound : TScrollBar;                        
                public
                        constructor Create; override;
                        procedure OnButtonClick( ReturnNumber : Integer ); override;
                        procedure OnMoveOverButton( ReturnNumber : Integer ); override;
        end;

        TGrabItemGump = Class( TGump )
                public
                        HasAlreadyChanged : Boolean;
                        ItemSerial : LongWord;
                        InputField : TInputField;
                        procedure Init( Item : TItem );
                        function Draw : Boolean; override;
                        procedure OnButtonClick( ReturnNumber : Integer ); override;
                        procedure OnScrollBar( GumpObject : TGumpObject ); override;
                        function OnKeyReturn( GumpObject : TGumpObject ) : Boolean; override;
                        procedure OnInputFieldChange( InputField : TInputField ); override;
        end;

implementation

uses    uPalanthir;

constructor TPaperdoll.Create;
begin
        inherited Create;
        BackGround := nil;
        AnimGump := nil;
end;

destructor TPaperdoll.Free;
begin
        if BackGround <> nil then
                BackGround.Free;
        if AnimGump <> nil then
                AnimGump.Free;

        if (Palanthir.Player <> nil) and (Palanthir.Player.CharConfig <> nil) then begin
                if (Palanthir.State = State_Ending) or (Palanthir.State = State_ReturnToLogin) then begin
                        Palanthir.Player.CharConfig.SetBool( 'PaperdollOpen', True );
                end
                else begin
                        Palanthir.Player.CharConfig.SetBool( 'PaperdollOpen', False );
                end;
                Palanthir.Player.CharConfig.SetInteger( 'PaperdollX', X );
                Palanthir.Player.CharConfig.SetInteger( 'PaperdollY', Y );
        end;
        

        inherited Free;
end;

procedure TPaperdoll.Init( NewChar : TChar; NewText : String );
begin
        noClose := False;
        CharSerial := NewChar.Serial;
        Text := NewText;

        if CharSerial = Palanthir.Player.Serial then begin
                if Palanthir.Player.CharConfig.GetInteger( 'PaperdollX' ) <> 0 then
                        X := Max( 0, Min( Palanthir.Player.CharConfig.GetInteger( 'PaperdollX' ), Palanthir.GetWindowBreite - 100 ) );
                if Palanthir.Player.CharConfig.GetInteger( 'PaperdollY' ) <> 0 then
                        Y := Max( 0, Min( Palanthir.Player.CharConfig.GetInteger( 'PaperdollY' ), Palanthir.GetWindowHoehe - 100 ) );
        end;

        BackGround := TGImage.Create;
        BackGround.X := 0;
        BackGround.Y := 0;
        BackGround.Hue := 0;
        BackGround.Typ := gt_Image;
        BackGround.Page := 0;
        BackGround.Gump := Self;
        if NewChar = Palanthir.Player then
                BackGround.Id := $7D0
        else
                BackGround.Id := $7D1;

        AnimGump := TGImage.Create;
        AnimGump.X := 10;
        AnimGump.Y := 20;
        AnimGump.Typ := gt_Image;
        AnimGump.Page := 1;
        AnimGump.Gump := Self;
        AnimGump.Hue := NewChar.Color;

        AddCroppedText( 40, 260, 40, 180, Text, 0, 0, 0, 2 );

        AddButton( 20, 195, $7D2, $7D2, $7D2, 9, 0 );    //Profile
        if NewChar = Palanthir.Player then begin
                AddButton( 185, 205, $7E5, $7E6, $7E7, 2, 0 );   //Peace, War: 7E8,7E9,7EA
                AddButton( 185, 177, $7E2, $7E3, $7E4, 3, 0 );   //Chat
                AddButton( 185, 149, $7DF, $7E0, $7E1, 4, 0 );   //Skills
                AddButton( 185, 121, $7DC, $7DD, $7DE, 5, 0 );   //Journal
                AddButton( 185, 93, $7D9, $7DA, $7DB, 6, 0 );    //Quit
                AddButton( 185, 65, $7D6, $7D7, $7D8, 7, 0 );    //Optionen
                AddButton( 185, 37, $7EF, $7F0, $7F1, 8, 0 );    //Help
                AddButton( 34, 195, $7D2, $7D2, $7D2, 10, 0 );   //Partysys
        end;
        AddButton( 185, 233, $7EB, $7EC, $7ED, 1, 0 );  //Status

        Typ := GumpTyp_Paperdoll;

        if Palanthir.EnabledME and (CharSerial = Palanthir.Player.Serial) then begin
                AddButton( 160, 40, $20A, $20A, $20A, 11, 0 );

                Kopf := AddImage( 0, 0, $B8, 0, 2 );
                Torso := AddImage( 0, 0, $B9, 0, 2 );
                Beine := AddImage( 0, 0, $B2, 0, 2 );
                ArmLinks := AddImage( 0, 0, $B0, 0, 2 );
                ArmRechts := AddImage( 0, 0, $B1, 0, 2 );
                HandLinks := AddImage( 0, 0, $B5, 0, 2 );
                HandRechts := AddImage( 0, 0, $B6, 0, 2 );
        end
        else begin
                Kopf := nil;
                Torso := nil;
                Beine := nil;
                ArmLinks := nil;
                ArmRechts := nil;
                HandLinks := nil;
                HandRechts := nil;
        end;

        ActivePage := 1;
end;

procedure TPaperdoll.SetWarMode( WarMode : Boolean );
begin
        if TGumpObject( GetObject( 3 ) ).Typ = gt_Button then begin
                if WarMode then begin
                        TGumpButton( GetObject( 2 ) ).UpId := $7E8;
                        TGumpButton( GetObject( 2 ) ).DownId := $7E9;
                        TGumpButton( GetObject( 2 ) ).MoveOverId := $7EA;
                end
                else begin
                        TGumpButton( GetObject( 2 ) ).UpId := $7E5;
                        TGumpButton( GetObject( 2 ) ).DownId := $7E6;
                        TGumpButton( GetObject( 2 ) ).MoveOverId := $7E7;
                end;
        end;
end;

procedure TPaperdoll.OnButtonClick( ReturnNumber : Integer );
var     HelpRequest : THelpRequest;
        GetCharStatus : TGetCharStatus;
        Char : TChar;
        SendWarMode : TSendWarMode;
        OptionsGump : TOptionsGump;
        I : Integer;
        RequestSkills : TRequestSkills;
        DisconnectConfirm : TDisconnectConfirm;
begin
        case ReturnNumber of
                0 : begin
                        Palanthir.DeleteGump( Self );
                        end;
                1 : begin
                        Char := TChar( Palanthir.Data.GlobalObjectList.GetObject( CharSerial ) );
                        if Char = nil then begin
                                Palanthir.DeleteGump( Self );
                                exit;
                        end;
                        GetCharStatus := TGetCharStatus.Create;
                        GetCharStatus.SetPlayer( CharSerial );
                        Palanthir.SendPacket( GetCharStatus );
                        Char.StatusVisible := True;
                        end;
                2 : begin
                        SendWarMode := TSendWarMode.Create( not Palanthir.Player.WarMode );
                        Palanthir.SendPacket( SendWarMode );
                        end;
                4 : begin
                        RequestSkills := TRequestSkills.Create;
                        RequestSkills.SetSerial( CharSerial );
                        Palanthir.SendPacket( RequestSkills );
                end;
                5 : begin
                        Palanthir.Player.Journal.Visible := True;
                        Palanthir.Player.Journal.Rolle := False;
                        end;
                6 : begin
                        DisconnectConfirm := TDisconnectConfirm.Create;
                        Palanthir.AddGump( DisconnectConfirm );
                        end;
                7 : begin
                        for I := 0 to Palanthir.GetGumpCount-1 do
                                if Palanthir.GetGump( I ).Typ = GumpTyp_Options then
                                        exit;
                        OptionsGump := TOptionsGump.Create;
                        Palanthir.AddGump( OptionsGump );
                        end;
                8 : begin
                        HelpRequest := THelpRequest.Create;
                        Palanthir.SendPacket( HelpRequest );
                        end;
                11 : begin
                        if ActivePage = 1 then
                                ActivePage := 2
                        else
                                ActivePage := 1;
                end;
        end;
end;

procedure TPaperdoll.OnDblClick( GumpObject : TGumpObject );
var     ProfileRequest : TSendProfileRequest;
begin
        if (GumpObject.Typ = gt_Button) then begin
                Case TGumpButton( GumpObject ).ReturnNumber of
                        9 : begin
                                ProfileRequest := TSendProfileRequest.Create;
                                ProfileRequest.SetSerial( CharSerial );
                                Palanthir.SendPacket( ProfileRequest );
                                end;
                        10 : begin
                                if Palanthir.Player.Party.Gump = nil then begin
                                        Palanthir.Player.Party.Gump := TPartyGump.Create;
                                        Palanthir.AddGump( Palanthir.Player.Party.Gump );
                                end;
                                Palanthir.Player.Party.Gump.Visible := True;
                                Palanthir.Player.Party.Gump.Update;                                
                                Palanthir.SetForeGroundGump( Palanthir.Player.Party.Gump );
                                end;
                end;
        end;
end;

function TPaperdoll.Draw : Boolean;
var     Item : TItem;
        I, J : Integer;
        Liste : Array[0..99] of Boolean;
        Gefunden : Boolean;
        Char : TChar;
        AnimGumpId : Integer;
        MouseOver : TGumpItem;
        LayerExists : Boolean;
begin
        Char := TChar( Palanthir.Data.GlobalObjectList.GetObject( CharSerial ) );
        if Char = nil then begin
                Result := False;
                exit;
        end;

        if Palanthir.EnabledME and (Palanthir.Player = Char) then begin
                if Kopf <> nil then
                        Kopf.Hue := Palanthir.Player.Wounds[0];
                if Torso <> nil then
                        Torso.Hue := Palanthir.Player.Wounds[1];
                if Beine <> nil then
                        Beine.Hue := Palanthir.Player.Wounds[2];
                if ArmLinks <> nil then
                        ArmLinks.Hue := Palanthir.Player.Wounds[3];
                if ArmRechts <> nil then
                        ArmRechts.Hue := Palanthir.Player.Wounds[4];
                if HandLinks <> nil then
                        HandLinks.Hue := Palanthir.Player.Wounds[5];
                if HandRechts <> nil then
                        HandRechts.Hue := Palanthir.Player.Wounds[6];
        end;

        AnimGumpId := Palanthir.Shard.GetAnimGumpId( Char.GetAnimId );
        if AnimGumpId >= 0 then
                AnimGump.Id := AnimGumpId
        else
                AnimGump.Id := 0;
        AnimGump.Hue := Char.Color;

        TGumpText( GetObject( 0 ) ).Text := Text;

        for I := 0 to 99 do
                Liste[ I ] := False;

        for I := GetObjectCount-1 downto 0 do
                if GetObject( I ).Typ = gt_GumpItem then begin
                        Gefunden := False;
                        for J := 0 to Char.Content.Count-1 do begin
                                if TGumpItem( GetObject( I ) ).GetSerial = TItem( Char.Content.Items[ J ] ).Serial then begin
                                        Gefunden := True;
                                        Liste[ J ] := True;
                                        break;
                                end;
                        end;
                        if not Gefunden then begin
                                DeleteObject( I );
                        end;
                end;

        for I := 0 to Char.Content.Count-1 do begin
                if not Liste[ I ] then begin
                        Item := TItem( Char.Content.Items[ I ] );
                        if (Item.Layer > 0) and (Item.Layer < 25) then begin
                                Gefunden := False;
                                for J := 0 to GetObjectCount-1 do begin
                                        if GetObject( J ).Typ = gt_GumpItem then
                                                if PrioList[ 8, TGumpItem( GetObject( J ) ).GetLayer ] >= PrioList[ 8, Item.Layer ] then begin
                                                        AddGumpItem( 10, 20, Item.Serial, J, 1 );
                                                        Gefunden := True;
                                                        break;
                                                end;
                                end;
                                if not Gefunden then
                                        AddGumpItem( 10, 20, Item.Serial, -1, 1 );
                        end;
                end;
        end;

        MouseOver := nil;
        if (Palanthir.Maus.SelectedGumpObject <> nil) and (Palanthir.Maus.SelectedGumpObject.Gump = Self) and (Palanthir.Maus.DragSerial <> Invalid_Serial) then begin
                LayerExists := False;

                if (Palanthir.Data.Tiledata.GetStaticFlag( Palanthir.Maus.DragId, dWEARABLE ) or Palanthir.Data.Tiledata.GetStaticFlag( Palanthir.Maus.DragId, dWEAPON )) and (Palanthir.Maus.DragLayer > 0) and (Palanthir.Maus.DragLayer < 25) then begin
                        Gefunden := False;
                        for J := 0 to GetObjectCount-1 do begin
                                if GetObject( J ).Typ = gt_GumpItem then begin
                                        if TGumpItem( GetObject( J ) ).GetLayer = Palanthir.Maus.DragLayer then begin
                                                LayerExists := True;
                                        end;

                                        if PrioList[ 8, TGumpItem( GetObject( J ) ).GetLayer ] >= PrioList[ 8, Palanthir.Maus.DragLayer ] then begin
                                                MouseOver := AddGumpItem( 10, 20, Palanthir.Maus.DragId, Palanthir.Maus.DragColor, Palanthir.Maus.DragLayer, J, 1 );
                                                Gefunden := True;
                                        end;
                                end;
                        end;

                        if Gefunden and LayerExists then begin
                                DeleteObject( MouseOver );
                                MouseOver := nil;
                        end;

                        if (not Gefunden) and (not LayerExists) then
                                MouseOver := AddGumpItem( 10, 20, Palanthir.Maus.DragId, Palanthir.Maus.DragColor, Palanthir.Maus.DragLayer, -1, 1 );
                end;
        end;

        BackGround.Draw;
        if (AnimGumpId >= 0) and (AnimGump.Page = ActivePage) then
                AnimGump.Draw;

        Result := inherited Draw;

        if MouseOver <> nil then begin
                DeleteObject( MouseOver );
        end;
end;

constructor TContainer.Create;
begin
        inherited Create;

        Rolle := TGImage.Create( 0, 0, $50, 0, 0 );
        Rolle.Gump := Self;
        Small := False;
end;

destructor TContainer.Free;
var     Item : TItem;
begin
        Rolle.Free;

        Item := TItem( Palanthir.Data.GlobalObjectList.GetObject( ItemSerial ) );
        if (Item <> nil) and (Item.Container <> nil) and (Item.Container.Serial = Palanthir.Player.Serial) and (Item.Layer = Layer_BackPack) then begin
                if Palanthir.Player.CharConfig <> nil then begin
                        Palanthir.Player.CharConfig.SetInteger( 'BackPackX', X );
                        Palanthir.Player.CharConfig.SetInteger( 'BackPackY', Y );

                        if (Palanthir.State = State_Ending) or (Palanthir.State = State_ReturnToLogin) then begin
                                Palanthir.Player.CharConfig.SetBool( 'BackPackOpen', True );
                        end
                        else begin
                                Palanthir.Player.CharConfig.SetBool( 'BackPackOpen', False );
                        end;
                end;
        end;

        inherited Free;
end;

procedure TContainer.Init( NewItem : TItem; NewGumpId : Word );
begin
        NoClose := False;
        GumpId := NewGumpId;
        ItemSerial := NewItem.Serial;
        AddImage( 0, 0, GumpId, 0, 0 );
        Typ := GumpTyp_Container;

        if (NewItem.Container <> nil) and (NewItem.Container = Palanthir.Player) and (NewItem.Layer = Layer_BackPack) then begin
                X := Max( 0, Min( Palanthir.Player.CharConfig.GetInteger( 'BackPackX' ), Palanthir.GetWindowBreite-100 ) );
                Y := Max( 0, Min( Palanthir.Player.CharConfig.GetInteger( 'BackPackY' ), Palanthir.GetWindowHoehe-100 ) );
        end;
end;

procedure TContainer.OnButtonClick( ReturnNumber : Integer );
var     I : Integer;
        Item, Cont : TUObject;
begin
        if ReturnNumber = 0 then begin
                for I := Palanthir.GetGumpCount-1 downto 0 do begin
                        if Palanthir.GetGump( I ).Typ = GumpTyp_Container then begin
                                Item := Palanthir.Data.GlobalObjectList.GetObject( TContainer( Palanthir.GetGump( I ) ).ItemSerial );

                                if Item = nil then
                                        continue;

                                Cont := Item.Container;

                                while Cont <> nil do begin
                                        if Cont.Serial = ItemSerial then begin
                                                Palanthir.DeleteGump( I );
                                                Break;
                                        end;
                                        Cont := Cont.Container;
                                end;
                        end;
                end;

                Palanthir.DeleteGump( Self );
        end;
end;

procedure TContainer.OnDblClick( GumpObject : TGumpObject );
begin
        if Small then
                Small := False;
end;

procedure TContainer.OnClick( X, Y : Word );
begin
        if GumpId = $3C then begin
                if IsInRect( X, Y, 100, 160, 120, 180 ) then begin
                        Small := True;
                end;
        end;
end;

function TContainer.Draw : Boolean;
var     ContItem, Item : TItem;
        I, J : Integer;
        Liste : Array[0..$FFFF] of Boolean;
        Gefunden : Boolean;
begin
        Item := TItem( Palanthir.Data.GlobalObjectList.GetObject( ItemSerial ) );
        if Item = nil then begin
                Result := False;
                exit;
        end;

        if (Item.Container = nil) and ( not Item.Pos.IsInRechteckRange( Palanthir.Player.Pos, 3 ) ) then begin
                Result := False;
                exit;
        end;

        if Small then begin
                Rolle.Draw;        
                Result := True;
        end
        else begin
                for I := 0 to $FFFF do
                        Liste[ I ] := False;

                for I := GetObjectCount-1 downto 0 do
                        if GetObject( I ).Typ = gt_GumpStaticItem then begin
                                Gefunden := False;
                                for J := 0 to Min( Item.Content.Count-1, $FFFF ) do begin
                                        if TGumpStaticItem( GetObject( I ) ).ItemSerial = TItem( Item.Content.Items[ J ] ).Serial then begin
                                                TGumpStaticItem( GetObject( I ) ).X := TItem( Item.Content.Items[ J ] ).Pos.X;
                                                TGumpStaticItem( GetObject( I ) ).Y := TItem( Item.Content.Items[ J ] ).Pos.Y;
                                                Gefunden := True;
                                                Liste[ J ] := True;
                                                break;
                                        end;
                                end;
                                if not Gefunden then begin
                                        DeleteObject( I );
                                end;
                        end;

                for I := 0 to Min( Item.Content.Count-1, $FFFF ) do begin
                        if not Liste[ I ] then begin
                                ContItem := TItem( Item.Content.Items[ I ] );
                                AddStaticItem( ContItem.Pos.X, ContItem.Pos.Y, ContItem.Serial );
                        end;
                end;

                Result := inherited Draw;
        end;
end;

constructor TStatusGump.Create( Flag : Byte );
begin
        inherited Create;
        Typ := GumpTyp_Status;
        StatusTyp := Flag;
        ActivePage := 1;

        Image := nil;
        Name := nil;
        HealthBackGround := nil;
        HealthBar := nil;
        ManaBackGround := nil;
        ManaBar := nil;
        StaminaBackGround := nil;
        StaminaBar := nil;
        Str := nil;
        Dex := nil;
        Int := nil;
        Sex := nil;
        Armor := nil;
        Gold := nil;
        Weight := nil;
        Health := nil;
        MaxHealth := nil;
        Stamina := nil;
        MaxStamina := nil;
        Mana := nil;
        MaxMana := nil;
        StatCap := nil;
        MaxWeight := nil;
        Pets := nil;
        Damage := nil;
        ResFire := nil;
        ResCold := nil;
        ResPoison := nil;
        ResEnergy := nil;
        Luck := nil;
        Volume := nil;
        MaxVolume := nil;
        Level := nil;
        XP := nil;

        Case Flag of
                0 : begin
                        Image := AddImage( 0, 0, $804, 0, 1 );
                        Name := AddCroppedText( 16, 14, 30, 100, '', 0, 0, 1 );
                        HealthBackGround := AddImage( 34, 38, $805, 0, 1 );
                        HealthBar := AddTiledImage( 34, 38, 11, 109, $806, 0, 1 );
                end;

                1 : begin
                        Image := AddImage( 0, 0, $802, 0, 1 );
                        Name := AddCroppedText( 90, 39, 30, 100, '', 0, 0, 1 );

                        Str := AddText( 85, 57, '', 0, 0, 1 );
                        Dex := AddText( 85, 69, '', 0, 0, 1 );
                        Int := AddText( 85, 81, '', 0, 0, 1 );
                        Sex := AddText( 85, 93, '', 0, 0, 1 );

                        Armor := AddText( 85, 105, '', 0, 0, 1 );

                        Health := AddText( 175, 57, '', 0, 0, 1 );
                        Stamina := AddText( 175, 69, '', 0, 0, 1 );
                        Mana := AddText( 175, 81, '', 0, 0, 1 );
                        Gold := AddText( 175, 93, '', 0, 0, 1 );
                        Weight := AddText( 175, 105, '', 0, 0, 1 );
                end;
                3, 4 : begin
                        Image := AddImage( 0, 0, $2A6C, 0, 1 );
                        Name := AddCroppedText( 80, 48, 30, 100, '', 1, 0, 1 );

                        Str := AddText( 90, 73, '', 1, 0, 1 );
                        Dex := AddText( 90, 101, '', 1, 0, 1 );
                        Int := AddText( 90, 129, '', 1, 0, 1 );

                        Health := AddText( 155, 66, '', 1, 0, 1 );
                        MaxHealth := AddText( 155, 79, '', 1, 0, 1 );
                        Stamina := AddText( 155, 94, '', 1, 0, 1 );
                        MaxStamina := AddText( 155, 107, '', 1, 0, 1 );
                        Mana := AddText( 155, 122, '', 1, 0, 1 );
                        MaxMana := AddText( 155, 135, '', 1, 0, 1 );

                        StatCap := AddText( 222, 73, '', 1, 0, 1 );
                        Weight := AddText( 222, 122, '', 1, 0, 1 );
                        MaxWeight := AddText( 222, 135, '', 1, 0, 1 );

                        Gold := AddText( 287, 101, '', 1, 0, 1 );
                        Pets := AddText( 287, 129, '', 1, 0, 1 );

                        Damage := AddText( 282, 73, '0 - 0', 1, 0, 1 );
                        Luck := AddText( 222, 101, '0', 1, 0, 1 );

                        Armor := AddText( 357, 70, '0', 1, 0, 1 );
                        ResFire := AddText( 357, 87, '0', 1, 0, 1 );
                        ResCold := AddText( 357, 102, '0', 1, 0, 1 );
                        ResPoison := AddText( 357, 115, '0', 1, 0, 1 );
                        ResEnergy := AddText( 357, 129, '0', 1, 0, 1 );

                        AddImage( 0, 0, $803, 0, 2 );
                        HealthBackGround := AddImage( 34, 10, $805, 0, 2 );
                        HealthBar := AddTiledImage( 34, 10, 11, 109, $806, 0, 2 );
                        ManaBackGround := AddImage( 34, 24, $805, 0, 2 );
                        ManaBar := AddTiledImage( 34, 24, 11, 109, $806, 0, 2 );
                        StaminaBackGround := AddImage( 34, 38, $805, 0, 2 );
                        StaminaBar := AddTiledImage( 34, 38, 11, 109, $806, 0, 2 );
                end;
                $1F : begin
                        Image := AddImage( 0, 0, $802, 0, 1 );

                        Name := AddCroppedText( 51, 30, 30, 100, '', 0, $481, 1 );
                        Health := AddText( 51, 62, '', 0, $481, 1 );
                        MaxHealth := AddText( 116, 62, '', 0, $481, 1 );
                        AddTooltip( 45, 60, 115, 25, 'Trefferpunkte', 1 );
                        Stamina := AddText( 51, 94, '', 0, $481, 1 );
                        MaxStamina := AddText( 116, 94, '', 0, $481, 1 );
                        AddTooltip( 45, 90, 115, 25, 'Ausdauer', 1 );
                        Gold := AddText( 51, 126, '', 0, $481, 1 );
                        AddTooltip( 45, 125, 115, 25, 'Gold', 1 );

                        Volume := AddText( 213, 30, '', 0, $481, 1 );
                        MaxVolume := AddText( 278, 30, '', 0, $481, 1 );
                        AddTooltip( 210, 25, 115, 25, 'Volumen', 1 );
                        Weight := AddText( 213, 62, '', 0, $481, 1 );
                        MaxWeight := AddText( 278, 62, '', 0, $481, 1 );
                        AddTooltip( 210, 60, 115, 25, 'Gewicht', 1 );
                        Level := AddText( 213, 96, '', 0, $481, 1 );
                        AddTooltip( 210, 93, 50, 25, 'Level', 1 );
                        XP := AddTiledImage( 209, 133, 8, 0, $28, $A8, 1 );
                        AddTooltip( 205, 130, 105, 25, 'XP', 1 );
                end;
        end;
end;

destructor TStatusGump.Free;
begin
        if (Palanthir.Player <> nil) and (Palanthir.Player.CharConfig <> nil) then begin
                if (Palanthir.State = State_Ending) or (Palanthir.State = State_ReturnToLogin) then
                        Palanthir.Player.CharConfig.SetBool( 'StatusOpen', True )
                else
                        Palanthir.Player.CharConfig.SetBool( 'StatusOpen', False );
                Palanthir.Player.CharConfig.SetInteger( 'StatusX', X );
                Palanthir.Player.CharConfig.SetInteger( 'StatusY', Y );
        end;

        inherited Free;
end;

procedure TStatusGump.OnClick( X, Y : Word );
begin
        if (StatusTyp = $1F) and IsInRect( X, Y, 313, 142, 325, 154 ) then begin
                Palanthir.DeleteGump( Self );
        end
        else if ((StatusTyp = 3) or (StatusTyp = 4)) and IsInRect( X, Y, 385, 145, 407, 169 ) then begin
                ActivePage := 2;
        end;
end;

procedure TStatusGump.OnButtonClick( ReturnNumber : Integer);
var     CloseGump : TCloseStatusGump;
        Char : TChar;
begin
        if ReturnNumber = 0 then begin
                CloseGump := TCloseStatusGump.Create;
                CloseGump.SetPlayer( CharSerial );
                Palanthir.NetClient.Send( CloseGump );

                Char := TChar( Palanthir.Data.GlobalObjectList.GetObject( CharSerial ) );
                if Char <> nil then
                        Char.StatusVisible := False;

                Palanthir.DeleteGump( Self );                        
        end;
end;

function TStatusGump.Draw : Boolean;
var     Char : TChar;
begin
        Char := TChar( Palanthir.Data.GlobalObjectList.GetObject( CharSerial ) );
        if Char <> nil then begin
                Char.StatusPos.X := X;
                Char.StatusPos.Y := Y;
        end
        else
                Palanthir.DeleteGump( Self );
        Result := inherited Draw;
end;

procedure TStatusGump.OnDblClick( GumpObject : TGumpObject );
var     Char : TChar;
        SendAttack : TSendAttack;
begin
        if Activepage = 2 then begin
                ActivePage := 1;
        end;

        Char := TChar( Palanthir.Data.GlobalObjectList.GetObject( CharSerial ) );
        if Char <> nil then begin
                if Palanthir.Player.WarMode then begin
                        SendAttack := TSendAttack.Create;
                        SendAttack.SetAttackTarget( Char.Serial );
                        Palanthir.SendPacket( SendAttack );
                end
                else begin
                        Char.RequestPaperdoll;
                end;
        end;
end;

constructor TOptionsGump.Create;
var     Page, Color : Word;
        PY, PX, I, J : Integer;
        Red, Blue, Green : Byte;
begin
        inherited Create;

        X := 100;
        Y := 100;

        Typ := GumpTyp_Options;

        AddResizeGump( 0, 0, $A28, 280, 350, 0, 0 );

        Page := 1;
        AddButton( 50, 310, $994, $993, $992, 1, Page ); //OK
        AddButton( 120, 310, $997, $996, $995, 0, Page ); //Cancel
        AddCheckBox( 23, 30, $D3, $D2, Palanthir.SoundManager.RunSound, 3, Page );
        AddText( 50, 30, 'Enable Sound', 0, 0, Page );
        AddCheckBox( 23, 60, $D3, $D2, Palanthir.SoundManager.RunMusic, 4, Page );
        AddText( 50, 60, 'Enable Music', 0, 0, Page );
        AddCheckBox( 23, 90, $D3, $D2, Config.GetBool( 'PacketLog' ), 5, Page );
        AddText( 50, 90, 'Enable PacketLog', 0, 0, Page );
        AddCheckBox( 23, 120, $D3, $D2, Config.GetBool( 'SpeechLog' ), 6, Page );
        AddText( 50, 120, 'Enable SpeechLog', 0, 0, Page );
        AddResizeGump( 22, 148, $BB8, 50, 25, 0, Page );
        AddInputField( 28, 150, 20, 40, IntToStr( Config.GetInteger( 'GumpDefaultX' ) ), 0, 1, 0, Page, True );
        AddText( 75, 150, 'Default GumpPosition (X)', 0, 0, Page );
        AddResizeGump( 22, 178, $BB8, 50, 25, 0, Page );
        AddInputField( 28, 180, 20, 40, IntToStr( Config.GetInteger( 'GumpDefaultY' ) ), 0, 2, 0, Page, True );
        AddText( 75, 180, 'Default GumpPosition (Y)', 0, 0, Page );
        AddResizeGump( 22, 208, $BB8, 50, 25, 0, Page );
        AddInputField( 28, 210, 20, 40, IntToStr( Config.GetInteger( 'Viewrange' ) ), 0, 3, 0, Page, True );
        AddText( 75, 210, 'Viewrange', 0, 0, Page );
        AddCheckBox( 23, 240, $D3, $D2, Config.GetBool( 'AlwaysHightlight' ), 7, Page );
        AddText( 50, 240, 'Always Highlight dynamic Items', 0, 0, Page );
        AddCheckBox( 23, 270, $D3, $D2, Palanthir.FadeGumps, 8, Page );
        AddText( 50, 270, 'Fade out Gumps', 0, 0, Page );

        AddPageButton( 215, 310, $15A4, $15A6, Page+1, Page );
        //AddPageButton( 190, 310, $15A1, $15A3, Page-1, Page );

        Page := 2;
        AddButton( 50, 310, $994, $993, $992, 1, Page ); //OK
        AddButton( 120, 310, $997, $996, $995, 0, Page ); //Cancel        
        SpeechButton := AddTextButton( 30, 30, 2, 'SpeechColor', 0, Page, 200, Palanthir.Keyboard.SpeechColor, Palanthir.Keyboard.SpeechColor, Palanthir.Keyboard.SpeechColor );
        EmoteButton := AddTextButton( 30, 60, 3, 'EmoteColor', 0, Page, 200, Palanthir.Keyboard.EmoteColor, Palanthir.Keyboard.EmoteColor, Palanthir.Keyboard.EmoteColor );

        AddText( 23, 90, 'SoundVolume', 0, 0, Page );
        AddImage( 23, 110, $D5, 0, Page );
        AddTiledImage( 36, 110, 14, 174, $D6, 0, Page );
        AddImage( 210, 110, $D7, 0, Page );
        ScrollSound := AddScrollBar( 23, 110, True, 200, $D8, $D8, 1, Page );
        ScrollSound.Promille := Trunc( 1000 * Config.GetInteger( 'SoundVolume' ) / 256 );
        AddText( 23, 140, 'MusicVolume', 0, 0, Page );
        AddImage( 23, 160, $D5, 0, Page );
        AddTiledImage( 36, 160, 14, 174, $D6, 0, Page );
        AddImage( 210, 160, $D7, 0, Page );
        ScrollMusic := AddScrollBar( 23, 160, True, 200, $D8, $D8, 2, Page );
        ScrollMusic.Promille := Trunc( 1000 * Config.GetInteger( 'MusicVolume' ) / 256 );
        AddCheckBox( 23, 190, $D3, $D2, Palanthir.Movement.DisablePermanentMovement, 9, Page );
        AddText( 50, 190, 'DisablePermanentMovement', 0, 0, Page );
        AddResizeGump( 22, 218, $BB8, 50, 25, 0, Page );
        AddInputField( 28, 220, 20, 40, IntToStr( Config.GetInteger( 'DClickTime' ) ), 0, 4, 0, Page, True );
        AddText( 75, 220, 'DClickTime', 0, 0, Page );
        AddCheckBox( 23, 250, $D3, $D2, Palanthir.ShowSpeechCount, 10, Page );
        AddText( 50, 250, 'ShowSpeechCount', 0, 0, Page );
        AddCheckBox( 23, 280, $D3, $D2, Palanthir.Walkingsounds, 11, Page );
        AddText( 50, 280, 'Walkingsounds', 0, 0, Page );

        AddPageButton( 215, 310, $15A4, $15A6, Page+1, Page );
        AddPageButton( 190, 310, $15A1, $15A3, Page-1, Page );

        Page := 3;
        AddButton( 50, 310, $994, $993, $992, 1, Page ); //OK
        AddButton( 120, 310, $997, $996, $995, 0, Page ); //Cancel
        AddCheckBox( 23, 30, $D3, $D2, Palanthir.ShowNames, 12, Page );
        AddText( 50, 30, 'Show Names', 0, 0, Page );
        AddCheckBox( 23, 60, $D3, $D2, Config.GetBool( 'JournalTextBorder' ), 13, Page );
        AddText( 50, 60, 'Journaltext has border', 0, 0, Page );
        AddCheckBox( 23, 90, $D3, $D2, Config.GetBool( 'JournalEnableDefaultColor' ), 14, Page );
        AddText( 50, 90, 'Journaltext has default color', 0, 0, Page );
        AddText( 50, 120, 'Button for contextmenues', 0, 0, Page );

        if not ( Config.GetBool( 'ContextMenuButtonNone' ) or Config.GetBool( 'ContextMenuButtonCtrl' ) or
                 Config.GetBool( 'ContextMenuButtonAlt' ) or Config.GetBool( 'ContextMenuButtonShift' ) ) then
                 Config.SetBool( 'ContextMenuButtonNone', True );

        AddRadioButton( 23, 145, $D3, $D2, Config.GetBool( 'ContextMenuButtonNone' ), 15, 7, Page );
        AddText( 58, 145, 'None', 0, 0, Page );
        AddRadioButton( 120, 145, $D3, $D2, Config.GetBool( 'ContextMenuButtonCtrl' ), 16, 7, Page );
        AddText( 145, 145, 'Ctrl', 0, 0, Page );
        AddRadioButton( 23, 170, $D3, $D2, Config.GetBool( 'ContextMenuButtonAlt' ), 17, 7, Page );
        AddText( 58, 170, 'Alt', 0, 0, Page );
        AddRadioButton( 120, 170, $D3, $D2, Config.GetBool( 'ContextMenuButtonShift' ), 18, 7, Page );
        AddText( 145, 170, 'Shift', 0, 0, Page );

        //AddPageButton( 215, 310, $15A4, $15A6, Page+1, Page );
        AddPageButton( 190, 310, $15A1, $15A3, Page-1, Page );

        Page := 100;
        SpeechColor := AddText( 50, 30, 'SpeechColor', 0, Palanthir.Keyboard.SpeechColor, Page );
        PX := 50;
        PY := 60;
        Color := 3;

        for I := 0 to 9 do begin
                for J := 0 to 19 do begin
                        Red := Color15toRed( Hues.GetColor( Color, 20 ) );
                        Green := Color15toGreen( Hues.GetColor( Color, 20 ) );
                        Blue := Color15toBlue( Hues.GetColor( Color, 20 ) );

                        AddHueButton( PX, PY, 8, 8, Red, Green, Blue, 1000+Color, Page );
                        Inc( PX, 8 );
                        Inc( Color, 5 );
                end;
                PX := 50;
                Inc( PY, 8 );
        end;

        Page := 101;
        EmoteColor := AddText( 50, 30, 'EmoteColor', 0, Palanthir.Keyboard.EmoteColor, Page );
        PX := 50;
        PY := 60;
        Color := 3;

        for I := 0 to 9 do begin
                for J := 0 to 19 do begin
                        Red := Color15toRed( Hues.GetColor( Color, 20 ) );
                        Green := Color15toGreen( Hues.GetColor( Color, 20 ) );
                        Blue := Color15toBlue( Hues.GetColor( Color, 20 ) );

                        AddHueButton( PX, PY, 8, 8, Red, Green, Blue, 2000+Color, Page );
                        Inc( PX, 8 );
                        Inc( Color, 5 );
                end;
                PX := 50;
                Inc( PY, 8 );
        end;
end;

procedure TOptionsGump.OnButtonClick( ReturnNumber : Integer );
var     Color : Word;
begin
        case ReturnNumber of
                0 : begin
                        Palanthir.DeleteGump( Self );
                        end;
                1 : begin
                        Palanthir.SoundManager.SetSound( GetCheckBox( 3 ) );
                        Palanthir.SoundManager.SetMusic( GetCheckBox( 4 ) );
                        Config.SetBool( 'Sound', GetCheckBox( 3 ) );
                        Config.SetBool( 'Music', GetCheckBox( 4 ) );

                        Palanthir.SoundManager.SetSoundVolume( Trunc( 256*ScrollSound.Promille / 1000 ) );
                        Palanthir.SoundManager.SetMusicVolume( Trunc( 256*ScrollMusic.Promille / 1000 ) );
                        Config.SetInteger( 'SoundVolume', Trunc( 256*ScrollSound.Promille / 1000 ) );
                        Config.SetInteger( 'MusicVolume', Trunc( 256*ScrollMusic.Promille / 1000 ) );                        

                        if GetCheckBox( 5 ) then begin
                                Config.SetBool( 'PacketLog', True );
                                Log.EnableLog( LOG_PACKET );
                        end
                        else begin
                                Config.SetBool( 'PacketLog', False );
                                Log.DisableLog( LOG_PACKET );
                        end;
                        if GetCheckBox( 6 ) then begin
                                Config.SetBool( 'SpeechLog', True );
                                Log.EnableLog( LOG_SPEECH );
                        end
                        else begin
                                Config.SetBool( 'SpeechLog', False );
                                Log.DisableLog( LOG_SPEECH );
                        end;
                        Config.SetBool( 'AlwaysHightlight', GetCheckBox( 7 ) );
                        Config.SetBool( 'NotFadeGumps', not GetCheckBox( 8 ) );
                        Palanthir.FadeGumps := GetCheckBox( 8 );

                        Palanthir.Movement.DisablePermanentMovement := GetCheckBox( 9 );
                        Config.SetBool( 'DisablePermanentMovement', GetCheckBox( 9 ) );

                        Config.SetBool( 'ShowSpeechCount', GetCheckBox( 10 ) );
                        Palanthir.ShowSpeechCount := GetCheckBox( 10 );

                        Config.SetBool( 'Walkingsounds', GetCheckBox( 11 ) );
                        Palanthir.Walkingsounds := GetCheckBox( 11 );

                        Config.SetBool( 'ShowNames', GetCheckBox( 12 ) );
                        Palanthir.ShowNames := GetCheckBox( 12 );

                        Config.SetBool( 'JournalTextBorder', GetCheckBox( 13 ) );
                        if Palanthir.Player.Journal <> nil then begin
                                Palanthir.Player.Journal.ChangeBorder( GetCheckBox( 13 ) );
                        end;

                        Config.SetBool( 'JournalEnableDefaultColor', GetCheckBox( 14 ) );
                        if Palanthir.Player.Journal <> nil then begin
                                Palanthir.Player.Journal.UseDefaultColor := GetCheckBox( 14 );
                        end;

                        Config.SetBool( 'ContextMenuButtonNone', GetRadioButton( 7 ) = 15 );
                        Config.SetBool( 'ContextMenuButtonCtrl', GetRadioButton( 7 ) = 16 );
                        Config.SetBool( 'ContextMenuButtonAlt', GetRadioButton( 7 ) = 17 );
                        Config.SetBool( 'ContextMenuButtonShift', GetRadioButton( 7 ) = 18 );

                        Palanthir.Keyboard.SpeechColor := SpeechColor.Hue;
                        Palanthir.Keyboard.EmoteColor := EmoteColor.Hue;

                        if Palanthir.Player.CharConfig <> nil then begin
                                Palanthir.Player.CharConfig.SetInteger( 'SpeechColor', Palanthir.Keyboard.SpeechColor );
                                Palanthir.Player.CharConfig.SetInteger( 'EmoteColor', Palanthir.Keyboard.EmoteColor );
                        end;

                        try
                                Config.SetInteger( 'GumpDefaultX', StrToInt( GetInputText( 1 ) ) );
                                Config.SetInteger( 'GumpDefaultY', StrToInt( GetInputText( 2 ) ) );
                                Config.SetInteger( 'Viewrange', StrToInt( GetInputText( 3 ) ) );
                                Config.SetInteger( 'DClickTime', StrToInt( GetInputText( 4 ) ) );
                                Palanthir.GumpDefaultX := Config.GetInteger( 'GumpDefaultX' );
                                Palanthir.GumpDefaultY := Config.GetInteger( 'GumpDefaultY' );
                                Palanthir.Player.VisRange := Config.GetInteger( 'Viewrange' );
                                Palanthir.DClickTime := Config.GetInteger( 'DClickTime' );
                        except
                        end;

                        Palanthir.DeleteGump( Self );
                        end;
                2 : begin
                        ActivePage := 100;
                end;
                3 : begin
                        ActivePage := 101;
                end;
                1000..1999 : begin
                        Color := ReturnNumber - 1000;
                        SpeechButton.UpHue := Color;
                        SpeechButton.DownHue := Color;
                        SpeechButton.MoveOverHue := Color;
                        SpeechColor.Hue := Color;

                        ActivePage := 2;
                end;
                2000..2999 : begin
                        Color := ReturnNumber - 2000;
                        EmoteButton.UpHue := Color;
                        EmoteButton.DownHue := Color;
                        EmoteButton.MoveOverHue := Color;
                        EmoteColor.Hue := Color;

                        ActivePage := 2;
                end;
        end;
end;

procedure TOptionsGump.OnMoveOverButton( ReturnNumber : Integer );
var     Color : Word;
begin
        case ReturnNumber of
                1000..1999 : begin
                        Color := ReturnNumber - 1000;
                        SpeechButton.UpHue := Color;
                        SpeechButton.DownHue := Color;
                        SpeechButton.MoveOverHue := Color;
                        SpeechColor.Hue := Color;
                end;
                2000..2999 : begin
                        Color := ReturnNumber - 2000;
                        EmoteButton.UpHue := Color;
                        EmoteButton.DownHue := Color;
                        EmoteButton.MoveOverHue := Color;
                        EmoteColor.Hue := Color;
                end;
        end;
end;

procedure TGrabItemGump.Init( Item : TItem );
begin
        Typ := GumpTyp_GrabItem;
        ItemSerial := Item.Serial;
        HasAlreadyChanged := True;

        AddImage( 0, 0, $85C, 0, 0 );
        AddButton( 102, 37, $85D, $85E, $81C, 1, 0 );
        InputField := AddInputField( 29, 38, 18, 62, IntToStr( Item.Amount ), 0, 1, 0, 0, True );
        AddScrollBar( 25, 15, True, 110, $845, $846, 1, 0 );
end;

function TGrabItemGump.Draw : Boolean;
var     Item : TItem;
        Promille : Word;
begin
        Item := TItem( Palanthir.Data.GlobalObjectList.GetObject( ItemSerial ) );
        if Item = nil then begin
                Result := False;
                exit;
        end;

        try
                if GetInputText( 1 ) = '' then
                        Promille := 0
                else
                        Promille := StrToInt( GetInputText( 1 ) );
                TScrollBar( GetObject( 3 ) ).Promille := Round( Promille*1000 / Item.Amount );
        except
                TInputField( GetObject( 2 ) ).Text := '';
                TScrollBar( GetObject( 3 ) ).Promille := 0;
        end;

        inherited Draw;
        Result := True;
end;

procedure TGrabItemGump.OnButtonClick( ReturnNumber : Integer );
var     Request : TItemPickupRequest;
        Item : TItem;
        Amount : Word;
begin
        if ReturnNumber = 1 then begin
                Item := TItem( Palanthir.Data.GlobalObjectList.GetObject( ItemSerial ) );
                if Item = nil then begin
                        exit;
                end;

                try
                        Amount := StrToInt( GetInputText( 1 ) );
                except
                        Amount := 1;
                end;

                Palanthir.Maus.DragSerial := Item.Serial;
                Palanthir.Maus.DragId := Item.Id;
                Palanthir.Maus.DragColor := Item.Color;
                Palanthir.Maus.DragAmount := Amount;
                Palanthir.Maus.DragLayer := Palanthir.Data.Tiledata.GetStaticQuality( Item.ID );

                Request := TItemPickupRequest.Create;
                Request.SetSerial( ItemSerial );
                Request.SetAmount( Amount );
                Palanthir.NetClient.Send( Request );

                Palanthir.DeleteGump( Self );
                exit;
        end;

        inherited OnButtonClick( ReturnNumber );
end;

procedure TGrabItemGump.OnScrollBar( GumpObject : TGumpObject );
var     Item : TItem;
begin
        Item := TItem( Palanthir.Data.GlobalObjectList.GetObject( ItemSerial ) );
        if Item = nil then begin
                exit;
        end;

        TInputField( GetObject( 2 ) ).Text := IntToStr( Round( Item.Amount*TScrollBar( GumpObject ).Promille / 1000 ) );
end;

function TGrabItemGump.OnKeyReturn( GumpObject : TGumpObject ) : Boolean;
begin
        OnButtonClick( 1 );
        Result := True;
end;

procedure TGrabItemGump.OnInputFieldChange( InputField : TInputField );
begin
        if not HasAlreadyChanged then begin
                HasAlreadyChanged := True;
                if InputField.SelectedPos = Length( InputField.Text ) + 1 then begin
                        InputField.Text := InputField.Text[ Length( InputField.Text ) ];
                        InputField.SelectedPos := 1;
                end;
        end;
end;


end.
