unit uSpecialRadar;

interface

uses    uGumps, Dialogs, SysUtils, uSendPackets, Classes, Math, StrLib,
        uUtilities, uTexCache, uRenderer, dglOpenGL;

type    TSpecialRadar = Class( TGump )
                private
                public
                        Map : TTexObject;                
                        constructor Create; override;
                        destructor Free; override;
                        function Draw : Boolean; override;
                        function OnDblClick( X, Y : Word ) : Boolean; override;
        end;

implementation

uses    uPalanthir;

constructor TSpecialRadar.Create;
begin
        inherited Create;
        
        Map := Palanthir.Data.GetWorldRadar;

        if Map = nil then begin
                exit;
        end;
        AddResizeGump( 0, 0, $BB8, Map.Breite+8, Map.Hoehe+8, 0, 0 );
end;

destructor TSpecialRadar.Free;
begin
end;

function TSpecialRadar.Draw : Boolean;
begin
        Result := inherited Draw;

        Renderer.DrawPixels( X+4, Y+4, Map );

        glDisable( GL_TEXTURE_2D );

        glBegin( GL_Points );
                glVertex2f( X + 4 + Palanthir.Player.Pos.X div 16, Y + 4 + Palanthir.Player.Pos.Y div 16 );
                glVertex2f( X + 4 + 1 + Palanthir.Player.Pos.X div 16, Y + 4 + Palanthir.Player.Pos.Y div 16 );
                glVertex2f( X + 4 + 1 + Palanthir.Player.Pos.X div 16, Y + 4 + Palanthir.Player.Pos.Y div 16 );
                glVertex2f( X + 4 - 1 + Palanthir.Player.Pos.X div 16, Y + 4 + Palanthir.Player.Pos.Y div 16 );
                glVertex2f( X + 4 + Palanthir.Player.Pos.X div 16, Y + 4 + 1 + Palanthir.Player.Pos.Y div 16 );
                glVertex2f( X + 4 + Palanthir.Player.Pos.X div 16, Y + 4 - 1 + Palanthir.Player.Pos.Y div 16 );
        glEnd;

        glEnable( GL_TEXTURE_2D );
end;

function TSpecialRadar.OnDblClick( X, Y : Word ) : Boolean;
var     SpeechRequest : TSendSpeechRequest;
begin
        Result := True;

        SpeechRequest := TSendSpeechRequest.Create;
        SpeechRequest.SetType( Palanthir.Keyboard.Typ );
        SpeechRequest.SetColor( Palanthir.Keyboard.SpeechColor );
        SpeechRequest.SetMsg( Format( '#go %d %d %d', [X*16,Y*16,Palanthir.Data.GetMapHeight(X*16,Y*16)] ) );
        SpeechRequest.SetFont( 3 );
        SpeechRequest.SetLanguage( Palanthir.Keyboard.Language );
        Palanthir.SendPacket( SpeechRequest );
end;


end.
