unit uClient;

interface

uses    ScktComp, Classes, Dialogs, SysUtils, Windows, uPacket, uRecievePackets,
        uSendPackets, ubTree, uCryptLogin, uUtilities, uConfig, uLog,
        uCryptGameTwofish, SyncObjs;

type    TClient = class( TThread )
                private
                        Client : TClientSocket;
                        SendList, RecieveList : TList;
                        Cache : PByteArray;
                        CacheLen : Integer;
                        Tree, ReadCur : TbTree;
                        ReadBits : Integer;
                        ReadValue : Word;
                        LoginCrypt : TLoginCrypt;
                        ClientEncryption : Byte;
                        Twofish : TGameCryptTwofish;
                        CriticalSection : TCriticalSection;
                        TrafficSend, TrafficRecieved : LongWord;
                protected
                        procedure Execute; override;
                public
                        constructor Create( CreateSuspended : Boolean );
                        destructor Free;
                        procedure Init( Address : String; Port : Integer );
                        procedure InitClientEncryption( Key1, Key2, Seed : LongWord; Typ : Byte );
                        procedure InitTwofishEncryption( Seed : LongWord );
                        procedure Close;
                        procedure Send( Packet : UOPacket );
                        function GetPacketCount : Integer;
                        function GetPacket : UOPacket;
                        function Active : Boolean;
                        procedure OnDisconnect( Sender: TObject; Socket: TCustomWinSocket );
                        procedure OnError( Sender: TObject; Socket: TCustomWinSocket; ErrorEvent: TErrorEvent; var ErrorCode: Integer );
                        procedure Poll;
                        procedure Disconnect;
                        function GetTrafficSend : LongWord;
                        function GetTrafficRecieved : LongWord;
                        function GetTraffic : LongWord;
        end;

implementation

uses    uPalanthir;

procedure TClient.Execute;
var     ReadLen : Integer;
        Buffer, NewCache : PByteArray;
        ReadIndex, WriteIndex: Integer;
        OutBuffer: array[0..$FFFF] of Byte;
        SendPacket : UOPacket;
        TmpBuffer : PByteArray;
begin
        while not Terminated do begin
                //erst schreiben, dann lesen

                if Client.Active then begin
                        while SendList.Count > 0 do begin
                                if Client.Active then begin
                                        CriticalSection.Enter;
                                        SendPacket := UOPacket( SendList.Items[ 0 ] );
                                        SendList.Delete( 0 );
                                        CriticalSection.Leave;

                                        if SendPacket.getPacketType <> $73 then begin   //$73 = Ping
                                                if SendPacket.Dump <> nil then begin
                                                        Log.Write( LOG_PACKET, 'Send' + SendPacket.GetInternalName );
                                                        Log.Write( LOG_PACKET, SendPacket.Dump );
                                                end;
                                        end;

                                        TrafficSend := TrafficSend + SendPacket.getLength;

                                        if SendPacket.ForceUnencrypted then begin
                                                SendPacket.CopyRawToEncrypted;
                                        end
                                        else begin
                                                case ClientEncryption of
                                                        Encrypt_None : begin
                                                                SendPacket.CopyRawToEncrypted;
                                                        end;
                                                        Encrypt_Login : begin
                                                                SendPacket.EncryptedPacket := LoginCrypt.Encrypt( SendPacket.RawPacket, SendPacket.getLength );
                                                        end;
                                                        Encrypt_Twofish : begin
                                                                SendPacket.EncryptedPacket := Twofish.Encrypt( SendPacket.RawPacket, SendPacket.getLength );
                                                        end;
                                                end;
                                        end;

                                        //        log.Write( 'encrypted packet' );
                                        //        log.Write( SendPacket.DumpEncrypted );

                                        if Client.Socket.Connected then
                                                Client.Socket.SendBuf( SendPacket.EncryptedPacket^, SendPacket.GetLength );
                                        SendPacket.Free;
                                end;
                        end;

                        GetMem( Buffer, 65536 );
                        if Client.Socket.Connected then
                                ReadLen := Client.Socket.ReceiveBuf( Buffer^, 65536 )
                        else
                                ReadLen := 0;

                        case ClientEncryption of
                                Encrypt_None : begin
                                        //no encryption
                                        end;
                                Encrypt_Login : begin
                                        //no encryption
                                        end;
                                Encrypt_Twofish : begin
                                        TmpBuffer := Twofish.Decrypt( Buffer, ReadLen );
                                        Move( TmpBuffer^[0], Buffer^[0], ReadLen );
                                        FreeMem( TmpBuffer );
                                end;
                        end;

                        if ReadLen > 0 then begin
                                TrafficRecieved := TrafficRecieved + ReadLen;

                                if Palanthir.State = State_LoggingIn then begin
                                        GetMem( NewCache, CacheLen+ReadLen );
                                        if CacheLen > 0 then begin
                                                Move( Cache^[0], NewCache^[0], CacheLen );
                                                FreeMem( Cache );
                                        end;
                                        Move( Buffer^[0], NewCache^[CacheLen], ReadLen );
                                        Cache := NewCache;
                                        CacheLen := CacheLen + ReadLen;
                                end
                                else begin
                                        ReadIndex := 0;
                                        WriteIndex := 0;

                                        while ( ReadIndex < ReadLen ) do begin
                                                if ( ReadBits <= 0 ) then begin
                                                        ReadValue := Buffer^[ ReadIndex ];
                                                        Inc( ReadIndex );
                                                        ReadBits := 8;
                                                end;

                                                repeat
                                                        Dec( ReadBits );
                                                        if ( ReadValue and ( 1 shl ReadBits ) ) <> 0 then
                                                                ReadCur := ReadCur.One
                                                        else
                                                                ReadCur := ReadCur.Zero;
                                                        if ( ReadCur.Hit ) then begin
                                                                if ( ReadCur.Value = 256 ) then begin
                                                                        ReadBits := 0;
                                                                        ReadCur := Tree;
                                                                end else begin
                                                                        OutBuffer[ WriteIndex ] := ReadCur.Value;
                                                                        Inc( WriteIndex );
                                                                end;
                                                                ReadCur := Tree;
                                                        end;
                                                until Readbits <= 0;
                                        end;

                                        GetMem( NewCache, CacheLen+WriteIndex );
                                        if CacheLen > 0 then begin
                                                Move( Cache^[0], NewCache^[0], CacheLen );
                                                FreeMem( Cache );
                                        end;
                                        Move( OutBuffer[0], NewCache^[CacheLen], WriteIndex );
                                        Cache := NewCache;
                                        CacheLen := CacheLen + WriteIndex;
                                end;
                        end;
                        FreeMem( Buffer );
                end;

                Poll;
        end;
end;

procedure TClient.Poll;
var     Cmd : Byte;
        Length : Word;
        NewCache, Buffer : PByteArray;
        Packet : UOPacket;
begin
        while CacheLen > 0 do begin
                Cmd := Cache^[0];
                Length := PacketLengths[ Cmd ];

                //fixes for sphere...
                if ( Cmd = $BC ) then
                        if ( CacheLen = 2 ) or ( Cache^[ 2 ] > 1 ) then
                                Length := 2; 

                if Length = 0 then begin
                        if CacheLen < 3 then begin
                                //Error
                                exit;
                        end
                        else begin
                                Length := Cache^[2] + ( Cache^[1] shl 8 );
                        end;
                end;

                if CacheLen < Length then begin
                        //Error
                        exit;
                end;

                GetMem( Buffer, Length );
                Move( Cache^[0], Buffer^[0], Length );

                Case Cmd of
                        $11 : Packet := StatWindow.Create( Buffer );
                        $1A : Packet := GetItem.Create( Buffer );
                        $1B : Packet := GetCharLocation.Create( Buffer );
                        $1C : Packet := GetSpeech.Create( Buffer );
                        $1D : Packet := DeleteObject.Create( Buffer );
                        $20 : Packet := DrawGamePlayer.Create( Buffer );
                        $21 : Packet := DenyMove.Create( Buffer );
                        $22 : Packet := AcceptMove.Create( Buffer );
                        $24 : Packet := OpenContainer.Create( Buffer );
                        $25 : Packet := AddContainerItem.Create( Buffer );
                        $26 : Packet := KickPlayer.Create( Buffer );
                        $27 : Packet := RejectItemMoveRequest.Create( Buffer );
                        $28 : Packet := ClearSquare.Create( Buffer );
                        $2D : Packet := GetCharAttributes.Create( Buffer );
                        $2E : Packet := GetWornItem.Create( Buffer );
                        $2F : Packet := ShowBattle.Create( Buffer );
                        $33 : Packet := PauseClient.Create( Buffer );
                        $3A : Packet := GetSkills.Create( Buffer );
                        $3B : Packet := GetBuyItems.Create( Buffer );
                        $3C : Packet := GetItemsInContainer.Create( Buffer );
                        $4E : Packet := GetGlow.Create( Buffer );
                        $4F : Packet := GetLightLevel.Create( Buffer );
                        $53 : Packet := IdleWarning.Create( Buffer );
                        $54 : Packet := PlaySound.Create( Buffer );
                        $55 : Packet := LoginComplete.Create( Buffer );
                        $5B : Packet := GetTime.Create( Buffer );
                        $65 : Packet := GetWeather.Create( Buffer );
                        $66 : Packet := GetBook.Create( Buffer );
                        $6C : Packet := CreateTargetCursor.Create( Buffer );
                        $6D : Packet := PlayMidi.Create( Buffer );
                        $6E : Packet := DoCharAnimation.Create( Buffer );
                        $6F : Packet := GetSecureTrading.Create( Buffer );
                        $70 : Packet := OldEffect.Create( Buffer );
                        $71 : Packet := GetBulletinBoard.Create( Buffer );
                        $72 : Packet := GetChangeWarMode.Create( Buffer );
                        $74 : Packet := OpenBuyWindow.Create( Buffer );
                        $76 : Packet := GetSubServer.Create( Buffer );
                        $77 : Packet := UpdatePlayer.Create( Buffer );
                        $78 : Packet := DrawObject.Create( Buffer );
                        $7C : Packet := OpenDialogBox.Create( Buffer );
                        $85 : Packet := GetCharDeleteDeny.Create( Buffer );
                        $88 : Packet := OpenPaperdoll.Create( Buffer );
                        $89 : Packet := GetCorpseEquipment.Create( Buffer );
                        $90 : Packet := GetMapMessage.Create( Buffer );
                        $93 : Packet := GetBookTitlePage.Create( Buffer );
                        $95 : Packet := OpenDyeWindow.Create( Buffer );
                        $97 : Packet := ForceMove.Create( Buffer );
                        $99 : Packet := PlaceMulti.Create( Buffer );
                        $9A : Packet := GetConsoleTextEntry.Create( Buffer );
                        $9E : Packet := GetSellList.Create( Buffer );
                        $A1 : Packet := UpdateHealth.Create( Buffer );
                        $A2 : Packet := UpdateMana.Create( Buffer );
                        $A3 : Packet := UpdateStamina.Create( Buffer );
                        $A5 : Packet := OpenWebbrowser.Create( Buffer );
                        $A6 : Packet := GetTipWindow.Create( Buffer );
                        $A9 : Packet := CharTownList.Create( Buffer );
                        $AA : Packet := AttackResponse.Create( Buffer );
                        $AB : Packet := GetGumpTextEntry.Create( Buffer );
                        $AE : Packet := GetUnicodeMessage.Create( Buffer );
                        $AF : Packet := DeathAction.Create( Buffer );
                        $B0 : Packet := GumpMenuDialog.Create( Buffer );
                        $B8 : Packet := GetProfile.Create( Buffer );
                        $B9 : Packet := EnableClientFeatures.Create( Buffer );
                        $BA : Packet := GetQuestPointer.Create( Buffer );
                        $BC : Packet := GetSeason.Create( Buffer );
                        $BD : Packet := VersionRequest.Create( Buffer );
                        $BF : Packet := GetMultiCommand.Create( Buffer );
                        $C0 : Packet := Effect.Create( Buffer );
                        $C1 : Packet := GetClilocMessage.Create( Buffer );
                        $C2 : Packet := GetUnicodeTextEntry.Create( Buffer );
                        $C4 : Packet := GetSemiVisible.Create( Buffer );
                        $C7 : Packet := ParticleEffect.Create( Buffer );
                        $C8 : Packet := GetViewRange.Create( Buffer );
                        $CC : Packet := GetClilocAffix.Create( Buffer );
                        $D4 : Packet := GetNewBookTitlePage.Create( Buffer );
                        $D6 : Packet := GetTooltipList.Create( Buffer );
                        $F5 : Packet := GetMEInfo.Create( Buffer );
                else begin
                        Packet := UOPacket.Create( Buffer );
                        end;
                end;

                if Packet <> nil then begin
                        CriticalSection.Enter;
                        RecieveList.Add( Packet );
                        CriticalSection.Leave;
                end;

                if CacheLen = Length then begin
                        FreeMem( Cache );
                        CacheLen := 0;
                end
                else begin
                        GetMem( NewCache, CacheLen - Length );
                        Move( Cache^[Length], NewCache^[0], CacheLen-Length );
                        FreeMem( Cache );
                        Cache := NewCache;
                        CacheLen := CacheLen - Length;
                end;
        end;
        if Config <> nil then
                sleep( Palanthir.WaitInNetworkloop )        
        else
                sleep( 20 );
end;

constructor TClient.Create( CreateSuspended : Boolean );
begin
        inherited Create( CreateSuspended );
        Client := TClientSocket.Create( nil );
        Client.OnDisconnect := OnDisconnect;
        Client.OnError := OnError;
        LoginCrypt := TLoginCrypt.Create;
        Twofish := TGameCryptTwofish.Create;
        RecieveList := TList.Create;
        SendList := TList.Create;
        CacheLen := 0;
        CriticalSection := TCriticalSection.Create;
        TrafficSend := 0;
        TrafficRecieved := 0;
end;

destructor TClient.Free;
begin
        Terminate;
        Sleep( 10 );
        Client.Close;
        Client.Free;
        RecieveList.Free;
        SendList.Free;
        LoginCrypt.Free;
        Twofish.Free;
        CriticalSection.Free;
end;

procedure TClient.InitClientEncryption( Key1, Key2, Seed : LongWord; Typ : Byte );
begin
        case Typ of
                Encrypt_Login : begin
                        ClientEncryption := Encrypt_Login;
                        LoginCrypt.Init( Key1, Key2, Seed );
                end;
        end;
end;

procedure TClient.InitTwofishEncryption( Seed : LongWord );
begin
        ClientEncryption := Encrypt_Twofish;
        Twofish.Init( Seed );
end;

procedure TClient.Init( Address : String; Port : Integer );
var     Cur : TbTree;
        Bit, Val : Word;
        I : Integer;
begin
        //Shutdown old connection
        Client.Close;
        RecieveList.Clear;
        SendList.Clear;
        CacheLen := 0;
        ClientEncryption := Encrypt_None;

        try
                //Start new connection
                Client.Host := Address;
                Client.Port := Port;
                Client.ClientType := ctNonBlocking;
                Client.Active := True;
        except
                showmessage( 'Server could not be reached.' );
                exit;
        end;

        Tree := TbTree.Create;
        ReadCur := Tree;
        ReadBits := 0;
        ReadValue := 0;
        for I := 0 to 256 do begin
                Cur := Tree;
                Bit := BitTable[ I, 0 ];
                Val := BitTable[ I, 1 ];
                while Bit > 0 do begin
                        Dec( Bit );
                        if ( Val and ( 1 shl Bit ) ) <> 0 then begin
                                if not Assigned( Cur.One ) then
                                        Cur.One := TbTree.Create;
                                Cur := Cur.One;
                        end else begin
                                if not Assigned( Cur.Zero ) then
                                        Cur.Zero := TbTree.Create;
                                Cur := Cur.Zero;
                        end;
                end;
                Cur.Hit := True;
                Cur.Value := I;
        end;
end;

procedure TClient.Close;
begin
        Client.Close;
end;

procedure TClient.Send( Packet : UOPacket );
begin
        CriticalSection.Enter;
        SendList.Add( Packet );
        CriticalSection.Leave;
end;

function TClient.GetPacketCount : Integer;
begin
        CriticalSection.Enter;
        Result := RecieveList.Count;
        CriticalSection.Leave;
end;

function TClient.GetPacket : UOPacket;
begin
        CriticalSection.Enter;
        Result := UOPacket( RecieveList.Items[0] );
        RecieveList.Delete( 0 );
        CriticalSection.Leave;
end;

function TClient.Active : Boolean;
begin
        Result := Client.Active;
end;

procedure TClient.OnDisconnect( Sender: TObject; Socket: TCustomWinSocket );
var     ReadLen: Integer;
        Buffer, NewCache : PByteArray;
        ReadIndex, WriteIndex: Integer;
        OutBuffer: array[0..32767] of Byte;
begin
        try
                GetMem( Buffer, 65536 );
                ReadLen := Client.Socket.ReceiveBuf( Buffer^, 65536 );
                if ReadLen > 0 then begin
                        if Palanthir.State = State_LoggingIn then begin
                                GetMem( NewCache, CacheLen+ReadLen );
                                if CacheLen > 0 then begin
                                        Move( Cache^[0], NewCache^[0], CacheLen );
                                        FreeMem( Cache );
                                end;
                                Move( Buffer^[0], NewCache^[CacheLen], ReadLen );
                                Cache := NewCache;
                                CacheLen := CacheLen + ReadLen;
                        end
                        else begin
                                ReadIndex := 0;
                                WriteIndex := 0;

                                while ( ReadIndex < ReadLen ) do begin
                                        if ( ReadBits <= 0 ) then begin
                                                ReadValue := Buffer^[ ReadIndex ];
                                                Inc( ReadIndex );
                                                ReadBits := 8;
                                        end;

                                        repeat
                                                Dec( ReadBits );
                                                if ( ReadValue and ( 1 shl ReadBits ) ) <> 0 then
                                                        ReadCur := ReadCur.One
                                                else
                                                        ReadCur := ReadCur.Zero;
                                                if ( ReadCur.Hit ) then begin
                                                        if ( ReadCur.Value = 256 ) then begin
                                                                ReadBits := 0;
                                                                ReadCur := Tree;
                                                        end else begin
                                                                OutBuffer[ WriteIndex ] := ReadCur.Value;
                                                                Inc( WriteIndex );
                                                        end;
                                                        ReadCur := Tree;
                                                end;
                                        until Readbits <= 0;
                                end;

                                GetMem( NewCache, CacheLen+WriteIndex );
                                if CacheLen > 0 then begin
                                        Move( Cache^[0], NewCache^[0], CacheLen );
                                        FreeMem( Cache );
                                end;
                                Move( OutBuffer[0], NewCache^[CacheLen], WriteIndex );
                                Cache := NewCache;
                                CacheLen := CacheLen + WriteIndex;
                        end;
                end;
                FreeMem( Buffer );
        except
        end;
end;

procedure TClient.OnError( Sender: TObject; Socket: TCustomWinSocket; ErrorEvent: TErrorEvent; var ErrorCode: Integer );
begin
        ErrorCode := 0;
        if Palanthir.State = State_LoggingIn then begin
                Palanthir.State := State_CannotReachServer;
        end
        else begin
                Palanthir.State := State_Disconnect;
        end;

        Client.OnDisconnect := nil;
end;

procedure TClient.Disconnect;
begin
        Client.Active := False;
end;

function TClient.GetTrafficSend : LongWord;
begin
        Result := TrafficSend;
end;

function TClient.GetTrafficRecieved : LongWord;
begin
        Result := TrafficRecieved;
end;

function TClient.GetTraffic : LongWord;
begin
        Result := TrafficSend + TrafficRecieved;
end;

end.
