unit uCryptGameTwofish;

interface

uses    SysUtils, MD5, Dialogs, uLog, DCPtwofish, Classes;

type    TDecryptTable = Array[0..$F] of Byte;
const   CryptTableLength = $100;

type    TGameCryptTwofish = Class
                private
                        Twofish : TDCP_twofish;
                        Seed : LongWord;
                        InternalBuffer : Array[0..CryptTableLength-1] of Byte;
                        ReceivePos, SendPos : Word;
                        DecryptTable : TDecryptTable;
                public
                        constructor Create;
                        destructor Free;
                        procedure Init( NewSeed : LongWord );
                        function Encrypt( InBuffer : PByteArray; Length : LongWord ) : PByteArray;                        
                        function Decrypt( InBuffer : PByteArray; Length : LongWord ) : PByteArray;
        end;

implementation

constructor TGameCryptTwofish.Create;
begin
        Twofish := TDCP_twofish.Create( nil );
end;

destructor TGameCryptTwofish.Free;
begin
        Twofish.Free;
end;

procedure TGameCryptTwofish.Init( NewSeed : LongWord );
var     I : Integer;
        cSeed : LongWord;
        Key : Array[0..15] of Byte;
        InitVektor : PByteArray;
        Md5 : TMD5Digest;
begin
        Seed := NewSeed;
        cSeed := Seed;
        for I := 0 to 3 do begin
                Key[ I*4 ] := ( cSeed and $FF000000 ) shr 24;
                Key[ I*4+1 ] := ( cSeed and $00FF0000 ) shr 16;
                Key[ I*4+2 ] := ( cSeed and $0000FF00 ) shr 8;
                Key[ I*4+3 ] := ( cSeed and $000000FF );
        end;

        GetMem( InitVektor, 16 );
        FillChar( InitVektor^, 16, 0 );

        Twofish.Init( Key, sizeof( Key )*8, InitVektor );
        FreeMem( InitVektor );

        for I := 0 to CryptTableLength-1 do
                InternalBuffer[ I ] := I;

        for I := 0 to (CryptTableLength div $10)-1 do
                Twofish.EncryptECB( InternalBuffer[I*$10], InternalBuffer[I*$10] );
        ReceivePos := 0;

        Md5 := MD5Buffer( InternalBuffer, CryptTableLength );
        for I := 0 to 15 do begin
                DecryptTable[ I ] := Md5.v[ I ];
        end;

        SendPos := 0;
end;

function TGameCryptTwofish.Encrypt( InBuffer : PByteArray; Length : LongWord ) : PByteArray;
var     I, J : Integer;
begin
        GetMem( Result, Length );
        for I := 0 to Length-1 do begin
                if ReceivePos >= CryptTableLength then begin
                        for J := 0 to (CryptTableLength div $10)-1 do
                                Twofish.EncryptECB( InternalBuffer[J*$10], InternalBuffer[J*$10] );
                        ReceivePos := 0;
                end;
                Result^[ I ] := InBuffer^[ I ] xor InternalBuffer[ ReceivePos ];
                Inc( ReceivePos );
        end;
end;

function TGameCryptTwofish.Decrypt( InBuffer : PByteArray; Length : LongWord ) : PByteArray;
var     I : Integer;
begin
        GetMem( Result, Length );
        for I := 0 to Length-1 do begin
                if SendPos >= $10 then
                        SendPos := 0;
                Result^[ I ] := InBuffer^[ I ] xor DecryptTable[ SendPos ];
                Inc( SendPos );
        end;
end;


end.
