unit uCryptLogin;

interface

uses    SysUtils, uCryptLoginKeys;

type    TLoginCrypt = Class
                private
                        BaseKey1, BaseKey2 : LongWord;
                        WorkKey1, WorkKey2 : LongWord;
                        Seed : LongWord;
                        function SwapBytes( Src : LongWord ) : LongWord;
                public
                        constructor Create;
                        destructor Free;
                        procedure Init( Key1, Key2, NewSeed : LongWord );
                        function Encrypt( InBuffer : PByteArray; Length : LongWord ) : PByteArray;
        end;

implementation

constructor TLoginCrypt.Create;
begin
end;

destructor TLoginCrypt.Free;
begin
end;

function TLoginCrypt.SwapBytes( Src : LongWord ) : LongWord;
begin
        Result := ( Src and $FF000000 ) shr 24;
        Result := Result + ( Src and $00FF0000 ) shr 8;
        Result := Result + ( Src and $0000FF00 ) shl 8;
        Result := Result + ( Src and $000000FF ) shl 24;
end;

procedure TLoginCrypt.Init( Key1, Key2, NewSeed : LongWord );
var     cSeed : LongWord;
begin
        BaseKey1 := Key1;
        BaseKey2 := Key2;
        Seed := NewSeed;

        cSeed := SwapBytes( Seed );
        WorkKey1 := (((not cSeed) xor $00001357 ) shl 16) or
                    ((cSeed xor $FFFFAAAA) and $0000FFFF);
        WorkKey2 := ((cSeed xor $43210000) shr 16) or
                    (((not cSeed) xor ($ABCDFFFF)) and $FFFF0000);
end;

function TLoginCrypt.Encrypt( InBuffer : PByteArray; Length : LongWord ) : PByteArray;
var     I : Integer;
        Table1, Table2 : LongWord;
begin
        GetMem( Result, Length );
        for I := 0 to Length-1 do begin
                Result^[ I ] := InBuffer^[ I ] xor ( WorkKey1 and $000000FF );

                Table1 := WorkKey1;
                Table2 := WorkKey2;

                WorkKey1 := ((Table1 shr 1) or (Table2 shl 31)) xor BaseKey2;
                Table2 := ((Table2 shr 1) or (Table1 shl 31)) xor BaseKey1;
                WorkKey2 := ((Table2 shr 1) or (Table1 shl 31)) xor BaseKey1;
        end;
end;

end.
