unit uNetwork;

interface

uses    Classes, SysUtils, uPacket, uRecievePackets, uSendPackets, Dialogs,
        uCustomGumps, uPlayer, uLog, uUObject, uItem, uChar, uObjectListe,
        uGumps, uSpecialGumps, uCursors, uUtilities, uEffect, uClient, Math,
        uTexCache, uBuyWindow, uSellWindow, uSpeech, uProfile, uCharCreation,
        uMEProfile, uBook, uFightGump, IdIPWatch, StrLib, uConfig,
        uBasicTypedefs, uWorldCache;

const   MaxIdleTime = 1000*30;

type    TNetwork = Class
                private
                        LastAction : LongWord;
                        function LogPacketToConsole( PacketId : Byte ) : Boolean;
                public
                        LastContPacket : GetItemsInContainer;                
                        constructor Create;
                        destructor Free;

                        procedure Poll( NetClient : TClient );
                        procedure SetActionDone;

                        //Packets
                        procedure HandleUpdateCharList( Packet : UpdateCharList );
                        procedure HandleGetGameServer( Packet : GetGameServer );
                        procedure HandleStatWindow( Packet : StatWindow );
                        procedure HandleGetItem( Packet : GetItem );
                        procedure HandleGetLocation( Packet : GetCharLocation );
                        procedure HandleGetSpeech( Packet : GetSpeech );
                        procedure HandleDeleteObject( Packet : DeleteObject );
                        procedure HandleDrawGamePlayer( Packet : DrawGamePlayer );
                        procedure HandleDenyMove( Packet : DenyMove );
                        procedure HandleAcceptMove( Packet : AcceptMove );
                        procedure HandleOpenContainer( Packet : OpenContainer );
                        procedure HandleAddContainerItem( Packet : AddContainerItem );
                        procedure HandleKickPlayer( Packet : KickPlayer );
                        procedure HandleRejectItemMoveRequest( Packet : RejectItemMoveRequest );
                        procedure HandleClearSquare( Packet : ClearSquare );
                        procedure HandleGetCharAttributes( Packet : GetCharAttributes );
                        procedure HandleGetWornItem( Packet : GetWornItem );
                        procedure HandleShowBattle( Packet : ShowBattle );
                        procedure HandlePauseClient( Packet : PauseClient );
                        procedure HandleGetSkills( Packet : GetSkills );
                        procedure HandleGetBuyItems( Packet : GetBuyItems );
                        procedure HandleGetItemsInContainer( Packet : GetItemsInContainer );
                        procedure HandleGetGlow( Packet : GetGlow );
                        procedure HandleGetLightLevel( Packet : GetLightLevel );
                        procedure HandlePlaySound( Packet : PlaySound );
                        procedure HandleLoginComplete( Packet : LoginComplete );
                        procedure HandleGetTime( Packet : GetTime );
                        procedure HandleGetWeather( Packet : GetWeather );
                        procedure HandleGetBook( Packet : GetBook );
                        procedure HandleCreateTargetCursor( Packet : CreateTargetCursor );
                        procedure HandlePlayMidi( Packet : PlayMidi );
                        procedure HandleDoCharAnimation( Packet : DoCharAnimation );
                        procedure HandleGetSecureTrading( Packet : GetSecureTrading );
                        procedure HandleOldEffect( Packet : OldEffect );
                        procedure HandleGetBulletinBoard( Packet : GetBulletinBoard );
                        procedure HandleGetChangeWarMode( Packet : GetChangeWarMode );
                        procedure HandleOpenBuyWindow( Packet : OpenBuyWindow );
                        procedure HandleGetSubServer( Packet : GetSubServer );
                        procedure HandleUpdatePlayer( Packet : UpdatePlayer );
                        procedure HandleDrawObject( Packet : DrawObject );
                        procedure HandleOpenPaperdoll( Packet : OpenPaperdoll );
                        procedure HandleGetCorpseEquipment( Packet : GetCorpseEquipment );
                        procedure HandleGetMapMessage( Packet : GetMapMessage );
                        procedure HandleGetBookTitlePage( Packet : GetBookTitlePage );
                        procedure HandleOpenDyeWindow( Packet : OpenDyeWindow );
                        procedure HandleForceMove( Packet : ForceMove );
                        procedure HandlePlaceMulti( Packet : PlaceMulti );
                        procedure HandleGetConsoleTextEntry( Packet : GetConsoleTextEntry );
                        procedure HandleGetSellList( Packet : GetSellList );
                        procedure HandleUpdateHealth( Packet : UpdateHealth );
                        procedure HandleUpdateMana( Packet : UpdateMana );
                        procedure HandleUpdateStamina( Packet : UpdateStamina );
                        procedure HandleOpenWebbrowser( Packet : OpenWebbrowser );
                        procedure HandleGetTipWindow( Packet : GetTipWindow );
                        procedure HandleAttackResponse( Packet : AttackResponse );
                        procedure HandleEnableClientFeatures( Packet : EnableClientFeatures );
                        procedure HandleGetUnicodeMessage( Packet : GetUnicodeMessage );
                        procedure HandleDeathAction( Packet : DeathAction );
                        procedure HandleGumpMenuDialog( Packet : GumpMenuDialog );
                        procedure HandleGetProfile( Packet : GetProfile );
                        procedure HandleCharTownList( Packet : CharTownList );
                        procedure HandleGetQuestPointer( Packet : GetQuestPointer );
                        procedure HandleGetSeason( Packet : GetSeason );
                        procedure HandleVersionRequest( Packet : VersionRequest );
                        procedure HandleGetMultiCommand( Packet : GetMultiCommand );
                        procedure HandleEffect( Packet : Effect );
                        procedure HandleGetClilocMessage( Packet : GetClilocMessage );
                        procedure HandleGetUnicodeTextEntry( Packet : GetUnicodeTextEntry );
                        procedure HandleGetSemiVisible( Packet : GetSemiVisible );
                        procedure HandleParticleEffect( Packet : ParticleEffect );
                        procedure HandleGetViewRange( Packet : GetViewRange );
                        procedure HandleGetClilocAffix( Packet : GetClilocAffix );
                        procedure HandleGetNewBookTitlePage( Packet : GetNewBookTitlePage );
                        procedure HandleGetTooltipList( Packet : GetTooltipList );
                        procedure HandleGetMEInfo( Packet : GetMEInfo );
        end;

implementation

uses    uPalanthir;

constructor TNetwork.Create;
begin
        LastAction := CustomGetTickCount;
        LastContPacket := nil;
end;

destructor TNetwork.Free;
begin
        if LastContPacket <> nil then
                LastContPacket.Free;
end;

function TNetwork.LogPacketToConsole( PacketId : Byte ) : Boolean;
var     Packets : String;
        Packet : String;
begin
        Packets := Config.GetString( 'PacketsToShowInConsole' );
        Packet := Format( '0x%x', [PacketId] );

        if Pos( Packet + ',', Packets ) > 0 then begin
                Result := True;
        end
        else if (Pos( Packet, Packets) > 0) and (Pos( Packet, Packets ) = Length( Packets ) - Length( Packet ) + 1) then begin
                Result := True;
        end
        else begin
                Result := False;
        end;
end;

procedure TNetwork.SetActionDone;
begin
        LastAction := CustomGetTickCount;
end;

procedure TNetwork.Poll( NetClient : TClient );
var     Client : TClient;
        Packet : UOPacket;
        Ping : TSendPing;
begin
        if NetClient <> nil then begin
                Client := NetClient;

                if Client.Active then begin
                        if Palanthir.State <> State_Playing then
                                LastAction := CustomGetTickCount
                        else if LastAction + MaxIdleTime < CustomGetTickCount then begin
                                Ping := TSendPing.Create;
                                Client.Send( Ping );
                                LastAction := CustomGetTickCount;
                        end;
                end;

                while Client.GetPacketCount > 0 do begin
                        Packet := Client.GetPacket;

                        if (Packet.getPacketType <> $73) or (not Packet.ToDump) then begin   //$73 = Ping
                                Log.Write( LOG_PACKET, 'Recieved' + Packet.GetInternalName );
                                Log.Write( LOG_PACKET, Packet.Dump );

                                if LogPacketToConsole( Packet.getPacketType ) then begin
                                        Log.WriteConsole( Packet.GetInternalName );
                                        Log.WriteConsole( Packet.Dump );
                                end;
                        end;

                        if (Packet.getPacketType <> $73) and Palanthir.ScriptManager.OnRecievePacket( Packet ) then begin
                                Log.Write( 'Pythonengine: discarding packet' );
                                Packet.Free;
                                Continue;
                        end;

                        Case Packet.getPacketType of
                                $11: HandleStatWindow( StatWindow( Packet ) );
                                $1A: HandleGetItem( GetItem( Packet ) );
                                $1B: HandleGetLocation( GetCharLocation( Packet ) );
                                $1C: HandleGetSpeech( GetSpeech( Packet ) );
                                $1D: HandleDeleteObject( DeleteObject( Packet ) );
                                $20: HandleDrawGamePlayer( DrawGamePlayer( Packet ) );
                                $21: HandleDenyMove( DenyMove( Packet ) );
                                $22: HandleAcceptMove( AcceptMove( Packet ) );
                                $24: HandleOpenContainer( OpenContainer( Packet ) );
                                $25: HandleAddContainerItem( AddContainerItem( Packet ) );
                                $26: HandleKickPlayer( KickPlayer( Packet ) );
                                $27: HandleRejectItemMoveRequest( RejectItemMoveRequest( Packet ) );
                                $28: HandleClearSquare( ClearSquare( Packet ) );
                                $2D: HandleGetCharAttributes( GetCharAttributes( Packet ) );
                                $2E: HandleGetWornItem( GetWornItem( Packet ) );
                                $2F: HandleShowBattle( ShowBattle( Packet ) );
                                $33: HandlePauseClient( PauseClient( Packet ) );
                                $3A: HandleGetSkills( GetSkills( Packet ) );
                                $3B: HandleGetBuyItems( GetBuyItems( Packet ) );
                                $3C: HandleGetItemsInContainer( GetItemsInContainer( Packet ) );
                                $4E: HandleGetGlow( GetGlow( Packet ) );
                                $4F: HandleGetLightLevel( GetLightLevel( Packet ) );
                                //$53: Done by Python
                                $54: HandlePlaySound( PlaySound( Packet ) );
                                $55: HandleLoginComplete( LoginComplete( Packet ) );
                                $5B: HandleGetTime( GetTime( Packet ) );
                                $65: HandleGetWeather( GetWeather( Packet ) );
                                $66: HandleGetBook( GetBook( Packet ) );
                                $6C: HandleCreateTargetCursor( CreateTargetCursor( Packet ) );
                                $6D: HandlePlayMidi( PlayMidi( Packet ) );
                                $6E: HandleDoCharAnimation( DoCharAnimation( Packet ) );
                                $6F: HandleGetSecureTrading( GetSecureTrading( Packet ) );
                                $70: HandleOldEffect( OldEffect( Packet ) );
                                $71: HandleGetBulletinBoard( GetBulletinBoard( Packet ) );
                                $72: HandleGetChangeWarMode( GetChangeWarMode( Packet ) );
                                $73: Packet.Free; //Ping
                                $74: HandleOpenBuyWindow( OpenBuyWindow( Packet ) );
                                $76: HandleGetSubServer( GetSubServer( Packet ) );
                                $77: HandleUpdatePlayer( UpdatePlayer( Packet ) );
                                $78: HandleDrawObject( DrawObject( Packet ) );
                                //$7C: Done by Python
                                //$82: Done by Python
                                //$85: Done by Python
                                $86: HandleUpdateCharList( UpdateCharList( Packet ) );
                                $88: HandleOpenPaperdoll( OpenPaperdoll( Packet ) );
                                $89: HandleGetCorpseEquipment( GetCorpseEquipment( Packet ) );
                                $8C: HandleGetGameServer( GetGameServer( Packet ) );
                                $90: HandleGetMapMessage( GetMapMessage( Packet ) );
                                $93: HandleGetBookTitlePage( GetBookTitlePage( Packet ) );
                                $95: HandleOpenDyeWindow( OpenDyeWindow( Packet ) );
                                $97: HandleForceMove( ForceMove( Packet ) );
                                $99: HandlePlaceMulti( PlaceMulti( Packet ) );
                                $9A: HandleGetConsoleTextEntry( GetConsoleTextEntry( Packet ) );
                                $9E: HandleGetSellList( GetSellList( Packet ) );
                                $A1: HandleUpdateHealth( UpdateHealth( Packet ) );
                                $A2: HandleUpdateMana( UpdateMana( Packet ) );
                                $A3: HandleUpdateStamina( UpdateStamina( Packet ) );
                                $A5: HandleOpenWebbrowser( OpenWebbrowser( Packet ) );
                                $A6: HandleGetTipWindow( GetTipWindow( Packet ) );
                                //$A8: Done by Python
                                $A9: HandleCharTownList( CharTownList( Packet ) );
                                $AA: HandleAttackResponse( AttackResponse( Packet ) );
                                //$AB: Done by Python
                                $AE: HandleGetUnicodeMessage( GetUnicodeMessage( Packet ) );
                                $AF: HandleDeathAction( DeathAction( Packet ) );
                                $B0: HandleGumpMenuDialog( GumpMenuDialog( Packet ) );
                                $B8: HandleGetProfile( GetProfile( Packet ) );
                                $B9: HandleEnableClientFeatures( EnableClientFeatures( Packet ) );
                                $BA: HandleGetQuestPointer( GetQuestPointer( Packet ) );
                                $BC: HandleGetSeason( GetSeason( Packet ) );
                                $BD: HandleVersionRequest( VersionRequest( Packet ) );
                                $BF: HandleGetMultiCommand( GetMultiCommand( Packet ) );
                                $C0: HandleEffect( Effect( Packet ) );
                                $C1: HandleGetClilocMessage( GetClilocMessage( Packet ) );
                                $C2: HandleGetUnicodeTextEntry( GetUnicodeTextEntry( Packet ) );
                                $C4: HandleGetSemiVisible( GetSemiVisible( Packet ) );
                                $C7: HandleParticleEffect( ParticleEffect( Packet ) );
                                $C8: HandleGetViewRange( GetViewRange( Packet ) );
                                $CC: HandleGetClilocAffix( GetClilocAffix( Packet ) );
                                $D4: HandleGetNewBookTitlePage( GetNewBookTitlePage( Packet ) );
                                $D6: HandleGetTooltipList( GetTooltipList( Packet ) );
                                $F5: HandleGetMEInfo( GetMEInfo( Packet ) );
                        else begin
                                Log.Write( Format( 'Unknown Game Packet. Type: %x Length: %d', [Packet.GetPacketType,Packet.GetLength] ) );
                                Log.Write( Packet.Dump );
                                Packet.Free;
                                end;
                        end;
                end;
        end;
end;

procedure TNetwork.HandleGetGameServer( Packet : GetGameServer );
var     Player : TPlayer;
        LoginGameServer : TLoginGameServer;
        EncryptionPacket : TEncryptionPacket;
        IP : String;
begin
        Player := Palanthir.Player;
        Palanthir.State := State_EnterGame;

        IP := Format( '%d.%d.%d.%d', [Packet.GetIP(0),Packet.GetIP(1),Packet.GetIP(2),Packet.GetIP(3)] );

        if (Packet.GetKey = $7F000001) or (( Packet.GetKey <> $FFFFFFFF ) and not Palanthir.NetClient.Active) or ( Packet.GetPort <> Palanthir.Shard.ShardConfig.GetInteger( 'Port' ) ) then begin
                Palanthir.NetClient.Close;
                Sleep( 500 );
                Palanthir.NetClient.Init( IP, Packet.GetPort );
                Palanthir.NetClient.Resume;

                EncryptionPacket := TEncryptionPacket.Create( Packet.GetKey );
                EncryptionPacket.ForceUnencrypted := True;
                Palanthir.NetClient.Send( EncryptionPacket );
        end;
        if Palanthir.Shard.ShardConfig.GetBool( 'ActivateLoginEncryption' ) then
                Palanthir.NetClient.InitTwofishEncryption( Packet.GetKey );

        LoginGameServer := TLoginGameServer.Create;
        LoginGameServer.SetKey( Packet.GetKey );
        LoginGameServer.SetUserID( Player.Login );
        LoginGameServer.SetPassword( Player.Password );
        Palanthir.NetClient.Send( LoginGameServer );

        Packet.Free;
end;

//Game Server Packets
procedure TNetwork.HandleGetLocation( Packet : GetCharLocation );
begin
        Palanthir.Player.Init( Packet );
        Packet.Free;
end;

procedure TNetwork.HandleEnableClientFeatures( Packet : EnableClientFeatures );
begin
        Log.Write( Format( 'Unused Packet EnableClientFeatures Type: %x Length: %d', [Packet.GetPacketType,Packet.GetLength] ) );
        Log.Write( Packet.Dump );
        Packet.Free;
end;

procedure TNetwork.HandleCharTownList( Packet : CharTownList );
var     I, Count, Pos : Integer;
        Gump : TCharCreationGump;
        LoginCharacter : TLoginCharacter;
        IPWatch : TIdIPWatch;
        Liste : TStringList;
        IP : LongWord;                  
        IP1, IP2, IP3, IP4 : LongWord;
begin
        if Palanthir.EnabledME then begin
                Count := 0;
                Pos := 0;
                for I := 0 to Packet.GetCharCount-1 do begin
                        if Packet.GetCharName( I ) <> '' then begin
                                Inc( Count );
                                Pos := I;
                        end;
                end;

                if Count = 1 then begin
                        Liste := TStringList.Create;
                        IPWatch := TIdIPWatch.Create( nil );
                        StrLib.Split( IPWatch.LocalIP, '.', Liste );

                        IP1 := StrToInt( Liste.Strings[ 0 ] );
                        IP2 := StrToInt( Liste.Strings[ 1 ] );
                        IP3 := StrToInt( Liste.Strings[ 2 ] );
                        IP4 := StrToInt( Liste.Strings[ 3 ] );

                        IP := ( IP1 shl 24 ) +
                              ( IP2 shl 16 ) +
                              ( IP3 shl 8 ) +
                              IP4;

                        Liste.Free;
                        IPWatch.Free;

                        LoginCharacter := TLoginCharacter.Create;
                        LoginCharacter.SetCharName( Packet.GetCharName( Pos ) );
                        LoginCharacter.SetSlot( Pos );
                        LoginCharacter.SetClientIP( IP );
                        Palanthir.NetClient.Send( LoginCharacter );
                        Palanthir.Name := Packet.GetCharName( Pos );
                        Exit;
                end;
        end;

        Gump := TCharCreationGump.Create;

        SetLength( Gump.CharNames, Packet.GetCharCount );
        SetLength( Gump.PassWords, Packet.GetCharCount );
        SetLength( Gump.CharButtons, Packet.GetCharCount );
        SetLength( Gump.CharSlots, Packet.GetCharCount );

        Count := 0;

        //Max 6 Shards
        for I := 0 to Gump.MaxChars-1 do begin
                if Packet.GetCharName( I ) <> '' then begin
                        Gump.CharButtons[ Count ] := Gump.AddTextButton( 230, 120+Count*30, Count+103, Packet.GetCharName( I ), 0, 1, 250, 0, $481, $481, 0, 0, 0, 0, 0, 0, 25 );
                        Gump.CharNames[ Count ] := Packet.GetCharName( I );
                        Gump.Passwords[ Count ] := Packet.GetPassword( I );
                        Gump.CharSlots[ Count ] := I;

                        Inc( Count );
                end;
        end;

        SetLength( Gump.LocIndex, Packet.GetTownCount );
        SetLength( Gump.LocCities, Packet.GetTownCount );
        SetLength( Gump.LocNames, Packet.GetTownCount );

        for I := 0 to Packet.GetTownCount-1 do begin
                Gump.AddTextButton( 30, 50+I*30, 3301+I, Packet.GetGeneralName( I ), 0, 15, 100, $481, $2, $2, $BB8, $BB8, $BB8, 0, 0, 0, 25 );
                Gump.LocIndex[ I ] := Packet.GetTownIndex( I );
                Gump.LocCities[ I ] := Packet.GetGeneralName( I );
                Gump.LocNames[ I ] := Packet.GetExactName( I );
        end;

        Palanthir.AddGump( Gump );
        Packet.Free;
end;

procedure TNetwork.HandleUpdateCharList( Packet : UpdateCharList );
var     I, Count : Integer;
        Gump : TCharCreationGump;
begin
        Gump := nil;
        for I := 0 to Palanthir.GetGumpCount-1 do begin
                if Palanthir.GetGump( I ).Typ = GumpTyp_CharCreation then begin
                        Gump := TCharCreationGump( Palanthir.GetGump( I ) );
                        break;
                end;
        end;

        if Gump = nil then begin
                Packet.Free;
                exit;
        end;

        for I := 0 to Length( Gump.CharButtons )-1 do
                Gump.DeleteObject( Gump.CharButtons[ I ] );

        SetLength( Gump.CharNames, Packet.GetCount );
        SetLength( Gump.PassWords, Packet.GetCount );
        SetLength( Gump.CharButtons, Packet.GetCount );
        SetLength( Gump.CharSlots, Packet.GetCount );

        Count := 0;

        //Max 6 Shards
        for I := 0 to Gump.MaxChars-1 do begin
                if Packet.GetName( I ) <> '' then begin
                        Gump.CharButtons[ Count ] := Gump.AddTextButton( 230, 120+Count*30, Count+103, Packet.GetName( I ), 5, 1, 250, 0, $481, $481, 0, 0, 0, $481, $481, $481, 25 );
                        Gump.CharNames[ Count ] := Packet.GetName( I );
                        Gump.Passwords[ Count ] := Packet.GetPassword( I );
                        Gump.CharSlots[ Count ] := I;

                        Inc( Count );
                end;
        end;

        Palanthir.SendGumpBack( Gump );
        Packet.Free;
end;

procedure TNetwork.HandleGetSeason( Packet : GetSeason );
begin
        Log.Write( Format( 'Unused Packet GetSeason Type: %x Length: %d', [Packet.GetPacketType,Packet.GetLength] ) );
        Log.Write( Packet.Dump );
        Packet.Free;
end;

procedure TNetwork.HandleGetViewRange( Packet : GetViewRange );
begin
        Log.Write( Format( 'Unused Packet GetViewRange Type: %x Length: %d', [Packet.GetPacketType,Packet.GetLength] ) );
        Log.Write( Packet.Dump );
        Packet.Free;
end;

procedure TNetwork.HandleDrawGamePlayer( Packet : DrawGamePlayer );
var     Player : TPlayer;
begin
        Player := Palanthir.Player;
        if Packet.getSerial <> Player.Serial then begin
                Packet.Free;
                exit;
        end;
        Player.Update( Packet );
        Packet.Free;
end;

procedure TNetwork.HandleGetLightLevel( Packet : GetLightLevel );
begin
        Palanthir.GlobalLight := Packet.GetLevel;
        Packet.Free;
end;

procedure TNetwork.HandleGetSubServer( Packet : GetSubServer );
begin
        Log.Write( Format( 'Unused Packet GetSubServer Type: %x Length: %d', [Packet.GetPacketType,Packet.GetLength] ) );
        Log.Write( Packet.Dump );
        Packet.Free;
end;

procedure TNetwork.HandleDrawObject( Packet : DrawObject );
var     UObject : TUObject;
        Char : TChar;
        SendSingleClick : TSendSingleClick;
begin
        if ( ( Packet.getSerial and $40000000 ) <> $40000000 ) then begin
                UObject := Palanthir.Data.GlobalObjectList.GetObject( Packet.getSerial );
                if UObject = nil then begin
                        Char := TChar.Create;
                        Char.Serial := Packet.getSerial;
                        Char.DrawChar( Packet );

                        if Palanthir.ShowNames then begin
                                SendSingleClick := TSendSingleClick.Create;
                                SendSingleClick.SetSerial( Char.Serial );
                                Palanthir.NetClient.Send( SendSingleClick );
                        end;
                end
                else begin
                        Char := TChar( UObject );
                        Char.DrawChar( Packet );
                end;
        end;
        Packet.Free;
end;

procedure TNetwork.HandleGetWornItem( Packet : GetWornItem );
var     Char : TChar;
        Item : TItem;
        SendDoubleClick : TSendDoubleClick;
begin
        Char := TChar( Palanthir.Data.GlobalObjectList.GetObject( Packet.getWearer and $7FFFFFFF ) );
        Item := TItem( Palanthir.Data.GlobalObjectList.GetObject( Packet.getSerial and $7FFFFFFF ) );

        if ( Char = nil ) then begin
                Packet.Free;
                exit;
        end;

        if Item = nil then begin
                Item := TItem.Create;
                Item.Serial := Packet.getSerial and $7FFFFFFF;
        end;

        Item.Layer := Packet.getLayer;
        Item.Id := Packet.getModel;
        Item.Color := Packet.getColor;

        if Item.Container <> nil then
                Item.RemoveFromCont;

        if Item.Registered then
                Item.UnRegisterObject;

        Item.Container := Char;

        Item.RegisterObject;

        Char.AddItem( Item );        

        Packet.Free;

        if (Char = Palanthir.Player) and (Item.Layer = Layer_BackPack) then begin
                if Palanthir.Player.CharConfig.GetBool( 'BackPackOpen' ) then begin
                        SendDoubleClick := TSendDoubleClick.Create;
                        SendDoubleClick.SetSerial( Item.Serial );
                        Palanthir.NetClient.Send( SendDoubleClick );
                end;
        end;
end;

procedure TNetwork.HandleUpdateHealth( Packet : UpdateHealth );
var     I : Integer;
        Gump : TStatusGump;
begin
        for I := Palanthir.GetGumpCount-1 downto 0 do
                if TGump( Palanthir.GetGump( I ) ).Typ = GumpTyp_Status then begin
                        Gump := TStatusGump( Palanthir.GetGump( I ) );
                        if Gump.CharSerial = Packet.getSerial then begin
                                case Gump.StatusTyp of
                                        0 : begin
                                                if Gump.HealthBar <> nil then
                                                        Gump.HealthBar.Breite := Trunc( 109*Min( Packet.getCurrentHealth / Packet.getMaxHealth, 1 ) );
                                                end;
                                        1 : begin
                                                if Gump.Health <> nil then
                                                        Gump.Health.Text := Format( '%d / %d', [Packet.getCurrentHealth, Packet.getMaxHealth] );
                                                end;
                                        3,4 : begin
                                                if Gump.Health <> nil then
                                                        Gump.Health.Text := Format( '%d', [Packet.getCurrentHealth] );
                                                if Gump.MaxHealth <> nil then
                                                        Gump.MaxHealth.Text := Format( '%d', [Packet.getMaxHealth] );
                                                if Gump.HealthBar <> nil then
                                                        Gump.HealthBar.Breite := Trunc( 109*Min( Packet.getCurrentHealth / Packet.getMaxHealth, 1 ) );                                                        
                                                end;
                                        $1F : begin
                                                if Gump.Health <> nil then
                                                        Gump.Health.Text := Format( '%d', [Packet.getCurrentHealth] );
                                                if Gump.MaxHealth <> nil then
                                                        Gump.MaxHealth.Text := Format( '%d', [Packet.getMaxHealth] );
                                        end;
                                end;
                        end;
                end;
        Packet.Free;
end;

procedure TNetwork.HandleUpdateMana( Packet : UpdateMana );
var     I : Integer;
        Gump : TStatusGump;
begin
        for I := Palanthir.GetGumpCount-1 downto 0 do
                if TGump( Palanthir.GetGump( I ) ).Typ = GumpTyp_Status then begin
                        Gump := TStatusGump( Palanthir.GetGump( I ) );
                        if Gump.CharSerial = Packet.getSerial then begin
                                case Gump.StatusTyp of
                                        1 : begin
                                                if Gump.Mana <> nil then
                                                        Gump.Mana.Text := Format( '%d / %d', [Packet.getCurrentMana, Packet.getMaxMana] );
                                                end;
                                        3,4 : begin
                                                if Gump.Mana <> nil then
                                                        Gump.Mana.Text := Format( '%d', [Packet.getCurrentMana] );
                                                if Gump.MaxMana <> nil then
                                                        Gump.MaxMana.Text := Format( '%d', [Packet.getMaxMana] );
                                                if Gump.ManaBar <> nil then
                                                        Gump.ManaBar.Breite := Trunc( 109*Min( Packet.getCurrentMana / Packet.getMaxMana, 1 ) );
                                                end;
                                end;
                        end;
                end;
        Packet.Free;
end;

procedure TNetwork.HandleUpdateStamina( Packet : UpdateStamina );
var     I : Integer;
        Gump : TStatusGump;
begin
        for I := Palanthir.GetGumpCount-1 downto 0 do
                if TGump( Palanthir.GetGump( I ) ).Typ = GumpTyp_Status then begin
                        Gump := TStatusGump( Palanthir.GetGump( I ) );
                        if Gump.CharSerial = Packet.getSerial then begin
                                case Gump.StatusTyp of
                                        1 : begin
                                                if Gump.Stamina <> nil then
                                                        Gump.Stamina.Text := Format( '%d / %d', [Packet.getCurrentStamina, Packet.getMaxStamina] );
                                                end;
                                        3,4 : begin
                                                if Gump.Stamina <> nil then
                                                        Gump.Stamina.Text := Format( '%d', [Packet.getCurrentStamina] );
                                                if Gump.MaxStamina <> nil then
                                                        Gump.MaxStamina.Text := Format( '%d', [Packet.getMaxStamina] );
                                                if Gump.StaminaBar <> nil then
                                                        Gump.StaminaBar.Breite := Trunc( 109*Min( Packet.getCurrentStamina / Packet.getMaxStamina, 1 ) );
                                                end;
                                        $1F : begin
                                                if Gump.Stamina <> nil then
                                                        Gump.Stamina.Text := Format( '%d', [Packet.getCurrentStamina] );
                                                if Gump.MaxStamina <> nil then
                                                        Gump.MaxStamina.Text := Format( '%d', [Packet.getMaxStamina] );
                                                end;
                                end;
                        end;
                end;
        Packet.Free;
end;

procedure TNetwork.HandleOpenWebbrowser( Packet : OpenWebbrowser );
var     URL : String;
begin
        URL := Packet.GetAdress;
        if Pos( 'http', URL ) <> 1 then
                URL := 'http://' + URL;
        OpenProg( URL );
        Packet.Free;
end;

procedure TNetwork.HandleGetChangeWarMode( Packet : GetChangeWarMode );
begin
        Palanthir.Player.ChangeWarMode( Packet );
        Packet.Free;
end;

procedure TNetwork.HandleLoginComplete( Packet : LoginComplete );
begin
        //We dont use this packet yet
        Packet.Free;
end;

procedure TNetwork.HandleGetTime( Packet : GetTime );
begin
        Log.Write( Format( 'Unused Packet GetTime Type: %x Length: %d', [Packet.GetPacketType,Packet.GetLength] ) );
        Log.Write( Packet.Dump );
        Packet.Free;
end;

procedure TNetwork.HandleStatWindow( Packet : StatWindow );
var     Char : TChar;
        I : Integer;
        Status : TStatusGump;
        OldX, OldY : SmallInt;
        Texture : TTexObject;
begin
        Palanthir.Player.Party.CheckName( Packet.getSerial, Packet.getName );

        Char := TChar( Palanthir.Data.GlobalObjectList.GetObject( Packet.getSerial ) );
        if Char <> nil then
                Char.Name := Packet.getName;

        if (Char <> nil) and (Packet.getFlag <> 0) and (Packet.getLength > 44) and (Char.Serial = Palanthir.Player.Serial) then
                Palanthir.Player.Gold := Packet.getGold;

        if (Char = nil) or (not Char.StatusVisible) then begin
                Packet.Free;
                exit;
        end;

        OldX := Char.StatusPos.X;
        OldY := Char.StatusPos.Y;
        for I := Palanthir.GetGumpCount-1 downto 0 do
                if TGump( Palanthir.GetGump( I ) ).Typ = GumpTyp_Status then
                        if TStatusGump( Palanthir.GetGump( I ) ).CharSerial = Packet.getSerial then begin
                                OldX := TGump( Palanthir.GetGump( I ) ).X;
                                OldY := TGump( Palanthir.GetGump( I ) ).Y;
                                Palanthir.DeleteGump( Palanthir.GetGump( I ) );
                        end;

        Status := TStatusGump.Create( Packet.getFlag );
        Status.CharSerial := Packet.getSerial;
        Status.NameChange := Packet.getNameChangeFlag <> 0;
        Status.StatusTyp := Packet.getFlag;
        Status.X := OldX;
        Status.Y := OldY;
        if Packet.getFlag = 0 then begin
                //if Status.Image <> nil then
                //        Status.Image.Id := $804;
                if Status.Name <> nil then
                        Status.Name.Text := Packet.getName;
                //if Status.HealthBackGround <> nil then
                //        Status.HealthBackGround.Id := $805;
                if Status.HealthBar <> nil then
                        Status.HealthBar.Breite := Trunc( 109*Min( Packet.getCurrentHealth / Packet.getMaxHealth, 1 ) );
                {Status.AddImage( 0, 0, $804, 0, 0 );
                Status.AddText( 16, 14, Packet.getName, 0, 0, 0 );
                Status.AddImage( 34, 38, $805, 0, 0 );
                Status.AddTiledImage( 34, 38, 11, Trunc( 109*Min( Packet.getCurrentHealth / Packet.getMaxHealth, 1 ) ), $806, 0, 0 );}
        end
        else if (Packet.getFlag = 1) and (Packet.getLength > 44) then begin
                Palanthir.Player.Gold := Packet.getGold;
                //if Status.Image <> nil then
                //        Status.Image.Id := $802;
                if Status.Name <> nil then
                        Status.Name.Text := Packet.getName;

                if Status.Str <> nil then
                        Status.Str.Text := Format( '%d', [Packet.getStr] );
                if Status.Dex <> nil then
                        Status.Dex.Text := Format( '%d', [Packet.getDex] );
                if Status.Int <> nil then
                        Status.Int.Text := Format( '%d', [Packet.getInt] );

                if Status.Sex <> nil then begin
                        Case Packet.getSex of
                                0 : Status.Sex.Text := 'm';
                        else
                                Status.Sex.Text := 'w';
                        end;
                end;
                if Status.Armor <> nil then
                        Status.Armor.Text := Format( '%d', [Packet.getArmorClass] );

                if Status.Health <> nil then
                        Status.Health.Text := Format( '%d / %d', [Packet.getCurrentHealth, Packet.getMaxHealth] );
                if Status.Stamina <> nil then
                        Status.Stamina.Text := Format( '%d / %d', [Packet.getCurrentStamina, Packet.getMaxStamina] );
                if Status.Mana <> nil then
                        Status.Mana.Text := Format( '%d / %d', [Packet.getCurrentMana, Packet.getMaxMana] );
                if Status.Gold <> nil then
                        Status.Gold.Text := Format( '%d', [Packet.getGold] );
                if Status.Weight <> nil then
                        Status.Weight.Text := Format( '%d', [Packet.getWeight] );
        end
        else if (Packet.getFlag = 3) or (Packet.getFlag = 4) then begin
                Palanthir.Player.Gold := Packet.getGold;
                //if Status.Image <> nil then
                //        Status.Image.Id := $2A6C;
                if Status.Name <> nil then
                        Status.Name.Text := Packet.getName;

                if Status.Str <> nil then
                        Status.Str.Text := Format( '%d', [Packet.getStr] );
                if Status.Dex <> nil then
                        Status.Dex.Text := Format( '%d', [Packet.getDex] );
                if Status.Int <> nil then
                        Status.Int.Text := Format( '%d', [Packet.getInt] );

                if Status.Health <> nil then
                        Status.Health.Text := Format( '%d', [Packet.getCurrentHealth] );
                if Status.MaxHealth <> nil then
                        Status.MaxHealth.Text := Format( '%d', [Packet.getMaxHealth] );
                if Status.Stamina <> nil then
                        Status.Stamina.Text := Format( '%d', [Packet.getCurrentStamina] );
                if Status.MaxStamina <> nil then
                        Status.MaxStamina.Text := Format( '%d', [Packet.getMaxStamina] );
                if Status.Mana <> nil then
                        Status.Mana.Text := Format( '%d', [Packet.getCurrentMana] );
                if Status.MaxMana <> nil then
                        Status.MaxMana.Text := Format( '%d', [Packet.getMaxMana] );

                if Status.HealthBar <> nil then
                        Status.HealthBar.Breite := Trunc( 109*Min( Packet.getCurrentHealth / Packet.getMaxHealth, 1 ) );
                if Status.ManaBar <> nil then
                        Status.ManaBar.Breite := Trunc( 109*Min( Packet.getCurrentMana / Packet.getMaxMana, 1 ) );
                if Status.StaminaBar <> nil then
                        Status.StaminaBar.Breite := Trunc( 109*Min( Packet.getCurrentStamina / Packet.getMaxStamina, 1 ) );

                if Status.StatCap <> nil then
                        Status.StatCap.Text := Format( '%d', [Packet.getStatCap] );
                if Status.Weight <> nil then
                        Status.Weight.Text := Format( '%d', [Packet.getWeight] );
                if Status.MaxWeight <> nil then
                        Status.MaxWeight.Text := Format( '%d', [40+Trunc(Packet.getStr*35/10)] );

                if Status.Gold <> nil then
                        Status.Gold.Text := Format( '%d', [Packet.getGold] );
                if Status.Pets <> nil then
                        Status.Pets.Text := Format( '%d / %d', [Packet.getCurrentPets,Packet.getMaxPets] );

                if Packet.getFlag = 3 then begin
                        if Status.Damage <> nil then
                                Status.Damage.Text := '0 - 0';
                        if Status.Luck <> nil then
                                Status.Luck.Text := '0';

                        if Status.Armor <> nil then
                                Status.Armor.Text := '0';
                        if Status.ResFire <> nil then
                                Status.ResFire.Text := '0';
                        if Status.ResCold <> nil then
                                Status.ResCold.Text := '0';
                        if Status.ResPoison <> nil then
                                Status.ResPoison.Text := '0';
                        if Status.ResEnergy <> nil then
                                Status.ResEnergy.Text := '0';
                end
                else begin
                        if Status.Damage <> nil then
                                Status.Damage.Text := Format( '%d - %d', [Packet.getMinDamage,Packet.getMaxDamage] );
                        if Status.Luck <> nil then
                                Status.Luck.Text := Format( '%d', [Packet.getLuck] );

                        if Status.Armor <> nil then
                                Status.Armor.Text := Format( '%d', [Packet.getArmorClass] );
                        if Status.ResFire <> nil then
                                Status.ResFire.Text := Format( '%d', [Packet.getResistFire] );
                        if Status.ResCold <> nil then
                                Status.ResCold.Text := Format( '%d', [Packet.getResistCold] );
                        if Status.ResPoison <> nil then
                                Status.ResPoison.Text := Format( '%d', [Packet.getResistPoison] );
                        if Status.ResEnergy <> nil then
                                Status.ResEnergy.Text := Format( '%d', [Packet.getResistEnergy] );
                end;
        end
        else if Packet.getFlag = $1F then begin   //ME Spezial
                Palanthir.Player.Gold := Packet.GetLongWord( 58 );
                //if Status.Image <> nil then
                //        Status.Image.Id := $802;
                //MEPacket :
                // normal packet, followed by:
                //
                //Word Ausdauer
                //Word AusdauerMax
                //Word XP prozentual
                //Byte Level
                //Word Gewicht
                //Word GewichtMax
                //Word Volumen
                //Word VolumenMax
                //LongWord Geld

                if Status.Name <> nil then
                        Status.Name.Text := Packet.getName;
                if Status.Health <> nil then
                        Status.Health.Text := IntToStr( Packet.getCurrentHealth );
                if Status.MaxHealth <> nil then
                        Status.MaxHealth.Text := IntToStr( Packet.getMaxHealth );
                if Status.Stamina <> nil then
                        Status.Stamina.Text := IntToStr( Packet.getMEAusdauer );
                if Status.MaxStamina <> nil then
                        Status.MaxStamina.Text := IntToStr( Packet.getMEAusdauerMax );
                if Status.Gold <> nil then
                        Status.Gold.Text := IntToStr( Packet.getMEGold );

                if Status.Volume <> nil then
                        Status.Volume.Text := IntToStr( Packet.getMEVolumen );
                if Status.MaxVolume <> nil then
                        Status.MaxVolume.Text := IntToStr( Packet.getMEVolumenMax );
                if Status.Weight <> nil then
                        Status.Weight.Text := IntToStr( Packet.getMEGewicht );
                if Status.MaxWeight <> nil then
                        Status.MaxWeight.Text := IntToStr( Packet.getMEGewichtMax );
                if Status.Level <> nil then
                        Status.Level.Text := IntToStr( Packet.getMELevel );
                if Status.XP <> nil then
                        Status.XP.Breite := Trunc( 96*Min( Max( Packet.getMEXP, 1 ), 100 ) / 100 );
        end
        else begin
                Log.Write( Format( 'Invalid Status Packet: Flag 0x%x', [Packet.GetFlag] ) );
                Log.Write( Packet.Dump );
                Status.Free;
                Packet.Free;
                exit;
        end;

        Palanthir.AddGump( Status );
        Packet.Free;

        if Status.GetObject( 0 ) <> nil then
                Texture := Palanthir.Data.GetGumpTexture( TGImage( Status.GetObject( 0 ) ).Id )
        else
                Texture := nil;

        if (Texture <> nil) and
           (Palanthir.Maus.AktX >= Status.X) and (Palanthir.Maus.AktY >= Status.Y) and
           (Palanthir.Maus.AktX < Status.X+Texture.Breite) and (Palanthir.Maus.AktY < Status.Y+Texture.Hoehe) then begin
                Palanthir.Maus.SelectedGumpObject := Status.GetObject( 0 );
                Palanthir.Maus.SelectedDownLGumpObject := Status.GetObject( 0 );
                Palanthir.Maus.SelectedUObject := nil;
                Palanthir.Maus.SelectedDownLUObject := nil;
        end;
end;

procedure TNetwork.HandleGetItem( Packet : GetItem );
var     UObject : TUObject;
        Item : TItem;
begin
        UObject := Palanthir.Data.GlobalObjectList.GetObject( Packet.getSerial and $7FFFFFFF );
        if UObject = nil then begin
                Item := TItem.Create;
                Item.Serial := Packet.getSerial and $7FFFFFFF;
                Item.Update( Packet );
        end
        else begin
                Item := TItem( UObject );
                Item.Update( Packet );
        end;
        Packet.Free;
end;

procedure TNetwork.HandleGetSpeech( Packet : GetSpeech );
begin
        Palanthir.AddSpeech( Packet );
        Packet.Free;
end;

procedure TNetwork.HandleDeleteObject( Packet : DeleteObject );
var     UObject : TUObject;
begin
        UObject := Palanthir.Data.GlobalObjectList.GetObject( Packet.getSerial );
        if UObject = Palanthir.Player then begin
                Packet.Free;
                exit;
        end;

        if UObject <> nil then
                UObject.Free;
        Packet.Free;
end;

procedure TNetwork.HandleDenyMove( Packet : DenyMove );
begin
        Palanthir.Player.DenyMove( Packet );
        Packet.Free;
end;

procedure TNetwork.HandleAcceptMove( Packet : AcceptMove );
begin
        Palanthir.Player.AcceptMove( Packet );
        Packet.Free;
end;

procedure TNetwork.HandleOpenContainer( Packet : OpenContainer );
var     I : Integer;
        Gump : TGump;
        Container, TmpCont : TContainer;
        Item : TItem;
        UObject : TUObject;
        Passt : Boolean;
begin
        for I := 0 to Palanthir.GetGumpCount-1 do begin
                Gump := Palanthir.GetGump( I );
                if (Gump.Typ = GumpTyp_Container) and (TContainer( Gump ).ItemSerial = Packet.GetSerial) then begin
                        TContainer( Gump ).GumpId := Packet.GumpId;
                        Palanthir.SetForeGroundGump( Gump );
                        Packet.Free;
                        exit;
                end;
        end;

        UObject := Palanthir.Data.GlobalObjectList.GetObject( Packet.GetSerial );

        if UObject = nil then begin
                Packet.Free;
                exit;
        end;

        if (not UObject.IsItem) then begin
                Packet.Free;
                exit;
        end;

        Item := TItem( UObject );

        Container := TContainer.Create;
        Container.Init( Item, Packet.GumpId );
        Palanthir.AddGump( Container );        

        repeat
                Passt := True;
                for I := 0 to Palanthir.GetGumpCount-1 do begin
                        if (Palanthir.GetGump( I ) <> Container) and (Palanthir.GetGump( I ).Typ = GumpTyp_Container) then begin
                                TmpCont := TContainer( Palanthir.GetGump( I ) );
                                if (TmpCont.X = Container.X) and (TmpCont.Y = Container.Y) then begin
                                        Inc( Container.X, 20 );
                                        Inc( Container.Y, 20 );
                                        Passt := False;
                                        Break;
                                end;
                        end;
                end;
        until Passt;

        Packet.Free;
end;

procedure TNetwork.HandleAddContainerItem( Packet : AddContainerItem );
var     Cont : TItem;
        Item : TItem;
begin
        Cont := TItem( Palanthir.Data.GlobalObjectList.GetObject( Packet.GetContainerSerial and $7FFFFFFF ) );
        Item := TItem( Palanthir.Data.GlobalObjectList.GetObject( Packet.GetItemSerial and $7FFFFFFF ) );

        if ( Cont = nil ) then begin
                Packet.Free;
                exit;
        end;

        if Item = nil then begin
                Item := TItem.Create;
                Item.Serial := Packet.getItemSerial and $7FFFFFFF;
        end else begin
                if Item.Container <> nil then
                        Item.RemoveFromCont;
                
                Item.UnRegisterObject;
        end;

        Item.Pos.X := Packet.GetX;  //44-142
        Item.Pos.Y := Packet.GetY;  //65-127
        Item.Id := Packet.GetId;
        Item.Amount := Packet.GetAmount;
        Item.Color := Packet.getColor;

        Item.Container := Cont;

        Item.RegisterObject;

        Cont.AddItem( Item );

        Packet.Free;
end;

procedure TNetwork.HandleKickPlayer( Packet : KickPlayer );
begin
        Log.Write( Format( 'Unused Packet KickPlayer Type: %x Length: %d', [Packet.GetPacketType,Packet.GetLength] ) );
        Log.Write( Packet.Dump );
        Packet.Free;
end;

procedure TNetwork.HandleRejectItemMoveRequest( Packet : RejectItemMoveRequest );
begin
        if Palanthir.Maus.DragSerial <> Invalid_Serial then begin
                Palanthir.Maus.DragSerial := Invalid_Serial;
                Palanthir.Maus.LDown := False;
        end;
        Packet.Free;
end;

procedure TNetwork.HandleClearSquare( Packet : ClearSquare );
begin
        Log.Write( Format( 'Unused Packet ClearSquare Type: %x Length: %d', [Packet.GetPacketType,Packet.GetLength] ) );
        Log.Write( Packet.Dump );
        Packet.Free;
end;

procedure TNetwork.HandleGetCharAttributes( Packet : GetCharAttributes );
var     Char : TChar;
begin
        Char := TChar( Palanthir.Data.GlobalObjectList.GetObject( Packet.GetSerial ) );

        if Char = nil then begin
                Packet.Free;
                exit;
        end;

        Char.MaxHitpoints := Packet.GetMaxHits;
        Char.Hitpoints := Packet.GetHits;
        Char.MaxMana := Packet.GetMaxMana;
        Char.Mana := Packet.GetMana;
        Char.MaxStamina := Packet.GetMaxStamina;
        Char.Stamina := Packet.GetStamina;

        Packet.Free;
end;

procedure TNetwork.HandleShowBattle( Packet : ShowBattle );
begin
        Log.Write( Format( 'Unused Packet ShowBattle Type: %x Length: %d', [Packet.GetPacketType,Packet.GetLength] ) );
        Log.Write( Packet.Dump );
        Packet.Free;
end;

procedure TNetwork.HandlePauseClient( Packet : PauseClient );
begin
        Log.Write( Format( 'Unused Packet PauseClient Type: %x Length: %d', [Packet.GetPacketType,Packet.GetLength] ) );
        Log.Write( Packet.Dump );
        Packet.Free;
end;

procedure TNetwork.HandleGetSkills( Packet : GetSkills );
begin
        Log.Write( Format( 'Unused Packet GetSkills Type: %x Length: %d', [Packet.GetPacketType,Packet.GetLength] ) );
        Log.Write( Packet.Dump );
        Packet.Free;
end;

procedure TNetwork.HandleGetBuyItems( Packet : GetBuyItems );
begin
        //not sure this packet is ever send by the server
        Log.Write( Format( 'Unused Packet GetBuyItems Type: %x Length: %d', [Packet.GetPacketType,Packet.GetLength] ) );
        Log.Write( Packet.Dump );
        Packet.Free;
end;

procedure TNetwork.HandleGetItemsInContainer( Packet : GetItemsInContainer );
var     Cont : TItem;
        Item : TItem;
        I : Integer;
begin
        for I := 0 to Packet.GetItemCount-1 do begin
                Cont := TItem( Palanthir.Data.GlobalObjectList.GetObject( Packet.GetContainerSerial( I ) ) );
                if Cont = nil then begin
                        continue;
                end;

                Item := TItem( Palanthir.Data.GlobalObjectList.GetObject( Packet.GetItemSerial( I ) ) );
                if Item = nil then begin
                        Item := TItem.Create;
                        Item.Serial := Packet.getItemSerial( I );
                end
                else begin
                        if Item.Container <> nil then
                                Item.RemoveFromCont;
                        
                        Item.UnRegisterObject;
                end;

                Item.Pos.X := Packet.GetX( I );  //44-142
                Item.Pos.Y := Packet.GetY( I );  //65-127
                Item.Id := Packet.GetItemID( I );
                Item.Amount := Packet.GetAmount( I );
                Item.Color := Packet.getColor( I );

                Item.Container := Cont;

                Item.RegisterObject;

                Cont.AddItem( Item );
        end;

        if LastContPacket <> nil then
                LastContPacket.Free;

        LastContPacket := Packet;
end;

procedure TNetwork.HandleGetGlow( Packet : GetGlow );
var     UObject : TUObject;
begin
        UObject := Palanthir.Data.GlobalObjectList.GetObject( Packet.GetSerial );
        if UObject <> nil then begin
                UObject.PersonalLightLevel := Packet.GetLevel;
        end;
        Packet.Free;
end;

procedure TNetwork.HandlePlaySound( Packet : PlaySound );
begin
        Palanthir.SoundManager.PlaySound( Packet.GetSound, Packet.Unkown3, Packet.GetX, Packet.GetY, Packet.GetZ );
        Packet.Free;
end;

procedure TNetwork.HandleGetWeather( Packet : GetWeather );
begin
        Log.Write( Format( 'Unused Packet GetWeather Type: %x Length: %d', [Packet.GetPacketType,Packet.GetLength] ) );
        Log.Write( Packet.Dump );
        Packet.Free;
end;

procedure TNetwork.HandleGetBook( Packet : GetBook );
var     I : Integer;
begin
        for I := 0 to Palanthir.GetGumpCount-1 do begin
                if ( Palanthir.GetGump( I ).Typ = GumpTyp_Book ) and ( TBook( Palanthir.GetGump( I ) ).Serial = Packet.GetSerial ) then begin
                        TBook( Palanthir.GetGump( I ) ).Fill( Packet );
                        Break;
                end;
        end;

        Packet.Free;
end;

procedure TNetwork.HandleCreateTargetCursor( Packet : CreateTargetCursor );
begin
        Palanthir.Target.AllowGround := Packet.GetType > 0;
        Palanthir.Target.Serial := Packet.GetCursorID;
        Palanthir.Target.Activated := True;
        Palanthir.Target.SetMultiId( 0 );
        Palanthir.Target.Typ := TypTargetExternal;
        Palanthir.CursorState := Cursor_Target;
        Palanthir.Cursors.CurrentCursor := crUOTarget;
        Packet.Free;
end;

procedure TNetwork.HandlePlayMidi( Packet : PlayMidi );
begin
        Palanthir.SoundManager.PlayMidi( Packet.GetId );
        Packet.Free;
end;

procedure TNetwork.HandleDoCharAnimation( Packet : DoCharAnimation );
var     UObject : TUObject;
        Char : TChar;
begin
        UObject := Palanthir.Data.GlobalObjectList.GetObject( Packet.getSerial );
        if UObject <> nil then begin
                Char := TChar( UObject );
                Char.DoAnimation( Packet );
        end;
        Packet.Free;
end;

procedure TNetwork.HandleGetSecureTrading( Packet : GetSecureTrading );
begin
        Palanthir.Player.SecureTrading( Packet );
        Packet.Free;
end;

procedure TNetwork.HandleOldEffect( Packet : OldEffect );
var     Effect : TEffect;
begin
        Effect := TEffect.Create;
        Effect.Init( Packet );
        Packet.Free;
end;

procedure TNetwork.HandleGetBulletinBoard( Packet : GetBulletinBoard );
begin
        Log.Write( Format( 'Unused Packet GetBulletinBoard Type: %x Length: %d', [Packet.GetPacketType,Packet.GetLength] ) );
        Log.Write( Packet.Dump );
        Packet.Free;
end;

procedure TNetwork.HandleOpenBuyWindow( Packet : OpenBuyWindow );
var     BuyWindow : TBuyWindow;
begin
        BuyWindow := TBuyWindow.Create;
        BuyWindow.Init( Packet );
end;

procedure TNetwork.HandleUpdatePlayer( Packet : UpdatePlayer );
var     UObject : TUObject;
        Char : TChar;
begin
        UObject := Palanthir.Data.GlobalObjectList.GetObject( Packet.GetSerial );
        if UObject <> nil then begin
                Char := TChar( UObject );
                if Char.Serial <> Palanthir.Player.Serial then
                        Char.Update( Packet );
        end;
        Packet.Free;
end;

procedure TNetwork.HandleOpenPaperdoll( Packet : OpenPaperdoll );
var     I : Integer;
        Gump : TGump;
        Paperdoll : TPaperdoll;
        Char : TChar;
begin
        for I := 0 to Palanthir.GetGumpCount-1 do begin
                Gump := Palanthir.GetGump( I );
                if (Gump.Typ = GumpTyp_Paperdoll) and (TPaperdoll( Gump ).CharSerial = Packet.GetSerial) then begin
                        TPaperdoll( Gump ).Text := Packet.GetText;
                        Packet.Free;
                        exit;
                end;
        end;

        Char := TChar( Palanthir.Data.GlobalObjectList.GetObject( Packet.GetSerial ) );

        if Char = nil then begin
                Packet.Free;
                exit;
        end;
        Paperdoll := TPaperdoll.Create;
        Paperdoll.Init( Char, Packet.GetText );
        Palanthir.AddGump( Paperdoll );

        Packet.Free;
end;

procedure TNetwork.HandleGetCorpseEquipment( Packet : GetCorpseEquipment );
var     Item, Item2 : TItem;
        Layer : Byte;
        K : Integer;
begin
        Item := TItem( Palanthir.Data.GlobalObjectList.GetObject( Packet.GetSerial ) );

        if Item = nil then begin
                Packet.Free;
                exit;
        end;

        K := 7;
        Layer := Packet.GetByte( K );
        Inc( K );

        while Layer <> 0 do begin
                Item2 := TItem( Palanthir.Data.GlobalObjectList.GetObject( Packet.GetLongWord( K ) ) );
                if Item2 = nil then begin
                        Item2 := TItem.Create;
                end else begin
                        if Item2.Container <> nil then
                                Item2.RemoveFromCont;
                        Item2.UnRegisterObject;
                end;
                Item2.Layer := Layer;
                K := K + 4;
                Layer := Packet.GetByte( K );
                Inc( K );

                Item2.Container := Item;
                Item.RegisterObject;
                Item.AddItem( Item2 );
        end;
        Packet.Free;
end;

procedure TNetwork.HandleGetMapMessage( Packet : GetMapMessage );
begin
        Log.Write( Format( 'Unused Packet GetMapMessage Type: %x Length: %d', [Packet.GetPacketType,Packet.GetLength] ) );
        Log.Write( Packet.Dump );
        Packet.Free;
end;

procedure TNetwork.HandleGetBookTitlePage( Packet : GetBookTitlePage );
var     I : Integer;
        Book : TBook;
begin
        for I := 0 to Palanthir.GetGumpCount-1 do
                if (Palanthir.GetGump( I ).Typ = GumpTyp_Book) and ( TBook( Palanthir.GetGump( I ) ).Serial = Packet.GetSerial ) then begin
                        Palanthir.DeleteGump( I );
                        Break;
                end;

        Book := TBook.Create;
        Book.Init( Packet );
        Palanthir.AddGump( Book );

        Packet.Free;
end;

procedure TNetwork.HandleOpenDyeWindow( Packet : OpenDyeWindow );
var     DyeGump : TDyeGump;
begin
        DyeGump := TDyeGump.Create( Packet.GetSerial, Packet.GetId );
        Palanthir.AddGump( DyeGump );
        Packet.Free;
end;

procedure TNetwork.HandleForceMove( Packet : ForceMove );
begin
        Log.Write( Format( 'Unused Packet ForceMove Type: %x Length: %d', [Packet.GetPacketType,Packet.GetLength] ) );
        Log.Write( Packet.Dump );
        Packet.Free;
end;

procedure TNetwork.HandlePlaceMulti( Packet : PlaceMulti );
begin
        Palanthir.Target.AllowGround := True;
        Palanthir.Target.Serial := Packet.GetSerial;
        Palanthir.Target.Activated := True;
        Palanthir.Target.SetMultiId( Packet.GetMultiID );
        Palanthir.Target.XOffset := Packet.GetXOffset;
        Palanthir.Target.YOffset := Packet.GetYOffset;
        Palanthir.Target.ZOffset := Packet.GetZOffset;
        Palanthir.Target.Typ := TypTargetExternal;
        Palanthir.CursorState := Cursor_Target;
        Palanthir.Cursors.CurrentCursor := crUOTarget;
        Packet.Free;
end;

procedure TNetwork.HandleGetConsoleTextEntry( Packet : GetConsoleTextEntry );
begin
        Palanthir.Keyboard.Typ := KB_Speech_Entry;
        Palanthir.Keyboard.SpeechText := Packet.GetText;
        Palanthir.Keyboard.MessageId := Packet.GetPrompt;
        Palanthir.Keyboard.PlayerId := Packet.GetObjectID;
        Palanthir.Keyboard.KeyboardMode := KB_Speech;
        Packet.Free;
end;

procedure TNetwork.HandleGetSellList( Packet : GetSellList );
var     SellWindow : TSellWindow;
begin
        SellWindow := TSellWindow.Create;
        SellWindow.Init( Packet );
end;

procedure TNetwork.HandleGetTipWindow( Packet : GetTipWindow );
begin
        Log.Write( Format( 'Unused Packet GetTipWindow Type: %x Length: %d', [Packet.GetPacketType,Packet.GetLength] ) );
        Log.Write( Packet.Dump );
        Packet.Free;
end;

procedure TNetwork.HandleAttackResponse( Packet : AttackResponse );
begin
        Log.Write( Format( 'Unused Packet AttackResponse Type: %x Length: %d', [Packet.GetPacketType,Packet.GetLength] ) );
        Log.Write( Packet.Dump );
        Packet.Free;
end;

procedure TNetwork.HandleGetUnicodeMessage( Packet : GetUnicodeMessage );
begin
        Palanthir.AddUnicodeSpeech( Packet );
        Packet.Free;
end;

procedure TNetwork.HandleDeathAction( Packet : DeathAction );
begin
        Log.Write( Format( 'Unused Packet DeathAction Type: %x Length: %d', [Packet.GetPacketType,Packet.GetLength] ) );
        Log.Write( Packet.Dump );
        Packet.Free;
end;

procedure TNetwork.HandleGumpMenuDialog( Packet : GumpMenuDialog );
var     CommandList, TextList, SubCommands, HtmlCommands : TStringList;
        I, J, Count, TextLength : Integer;
        Commands, NewCommand, NewText, Text, SubText, SubCommand, RealText : String;
        Gump : TDynamicGump;
        CurrentPage, CurrentGroup, RealColor : Integer;
        X, Y, UpId, DownId, MoveOverId, PageId, Hue : Word;
        ReturnNumber : Integer;
        Id, Hoehe, Breite, Font, TextId, TrueId, FalseId : Word;
        UpHue, DownHue, MoveOverHue, BackUpHue, BackDownHue, BackMoveOverHue : Word;
        ClilocID : LongWord;
        Checked, HasBack, CanScroll, Writing, AllowOnlyNumbers, Stars, IsPageButton, AllowMultiLines : Boolean;
        CheckCompleteRectangle : Boolean;
        BackLeftColor, BackRightColor, LeftColor, RightColor, TextColor : LongWord;
        Align : String;
        Current, Max : LongWord;
        Waagerecht : Boolean;
begin
        CommandList := TStringList.Create;
        TextList := TStringList.Create;

        Commands := Packet.GetCmdSection;

        NewCommand := '';
        for I := 1 to Length( Commands ) do begin
                if Commands[ I ] = '{' then
                        NewCommand := ''
                else if Commands[ I ] = '}' then begin
                        if NewCommand <> '' then
                                CommandList.Add( NewCommand );
                end
                else
                        NewCommand := NewCommand + Commands[ I ];
        end;

        Count := 23 + Packet.GetCmdSectionLen;
        for I := 0 to Packet.GetTextLineNumber-1 do begin
                TextLength := Packet.GetWord( Count );
                if TextLength > 0 then
                        NewText := Packet.GetUnicodeString( Count+2, TextLength*2 )
                else
                        NewText := '';
                TextList.Add( NewText );
                Count := Count + 2 + TextLength*2;
        end;

        Gump := TDynamicGump.Create;
        Gump.Serial := Packet.GetSerial;
        Gump.Typ := Packet.GetType;
        Gump.X := Packet.GetX;
        Gump.Y := Packet.GetY;
        CurrentPage := 0;
        CurrentGroup := 0;
        for I := 0 to CommandList.Count-1 do begin
                SubCommands := TStringList.Create;
                SubCommands.Delimiter := ' ';
                SubCommands.QuoteChar := ' ';
                SubCommands.DelimitedText := CommandList.Strings[ I ];

                if SubCommands.Count = 0 then begin
                        continue;
                end;

                if LowerCase( SubCommands.Strings[ 0 ] ) = 'noclose' then begin
                        Gump.noClose := True;
                end
                else if LowerCase( SubCommands.Strings[ 0 ] ) = 'nomove' then begin
                        Gump.noMove := True;
                end
                else if LowerCase( SubCommands.Strings[ 0 ] ) = 'nodispose' then begin
                        Gump.noDispose := True;
                end
                else if LowerCase( SubCommands.Strings[ 0 ] ) = 'noautoclose' then begin
                        Gump.noAutoClose := True;
                end
                else if LowerCase( SubCommands.Strings[ 0 ] ) = 'page' then begin
                        if SubCommands.Count < 2 then begin
                                log.Write( 'buggy gump, page has not enough parameters.' );
                                continue;
                        end;
                        CurrentPage := StrToInt( SubCommands.Strings[ 1 ] );
                end
                else if LowerCase( SubCommands.Strings[ 0 ] ) = 'group' then begin
                        if SubCommands.Count < 2 then begin
                                log.Write( 'buggy gump, group has not enough parameters.' );
                                continue;
                        end;
                        CurrentGroup := StrToInt( SubCommands.Strings[ 1 ] );
                end
                else if LowerCase( SubCommands.Strings[ 0 ] ) = 'button' then begin
                        if SubCommands.Count < 8 then begin
                                log.Write( 'buggy gump, button has not enough parameters.' );
                                continue;
                        end;
                        X := StrToInt( SubCommands.Strings[ 1 ] );
                        Y := StrToInt( SubCommands.Strings[ 2 ] );
                        UpId := StrToInt( SubCommands.Strings[ 3 ] );
                        DownId := StrToInt( SubCommands.Strings[ 4 ] );
                        PageId := StrToInt( SubCommands.Strings[ 6 ] );
                        ReturnNumber := StrToInt64Def( SubCommands.Strings[ 7 ], 0 );
                        if SubCommands.Count > 8 then
                                CheckCompleteRectangle := SubCommands.Strings[ 8 ] = '1'
                        else
                                CheckCompleteRectangle := False;
                        if StrToInt( SubCommands.Strings[ 5 ] ) = 0 then
                                Gump.AddPageButton( X, Y, UpId, DownId, PageId, CurrentPage )
                        else
                                Gump.AddButton( X, Y, UpId, DownId, UpId, ReturnNumber, CurrentPage, CheckCompleteRectangle );
                end
                else if LowerCase( SubCommands.Strings[ 0 ] ) = 'textbutton' then begin
                        //textbutton <x> <y> <Hoehe> <Breite> <ReturnNumber> <Text> <Font>
                        //<UpHue> <DownHue> <MoveOverHue> <BackgroundUpId> <BackgroundDownId>
                        //<BackgroundMoveOverId> <BackgroundUpHue> <BackgroundDownHue> <BackgroundMoveOverHue>

                        //Todo: Background Sachen
                        if SubCommands.Count < 18 then begin
                                log.Write( 'buggy gump, textbutton has not enough parameters.' );
                                continue;
                        end;
                        X := StrToInt( SubCommands.Strings[ 1 ] );
                        Y := StrToInt( SubCommands.Strings[ 2 ] );
                        Hoehe := StrToInt( SubCommands.Strings[ 3 ] );
                        Breite := StrToInt( SubCommands.Strings[ 4 ] );
                        ReturnNumber := StrToInt64Def( SubCommands.Strings[ 5 ], 0 );
                        if StrToInt( SubCommands.Strings[ 6 ] ) >= TextList.Count then
                                continue;
                        Text := TextList.Strings[ StrToInt( SubCommands.Strings[ 6 ] ) ];
                        Font := StrToInt( SubCommands.Strings[ 7 ] );

                        UpHue := StrToInt( SubCommands.Strings[ 8 ] );
                        DownHue := StrToInt( SubCommands.Strings[ 9 ] );
                        MoveOverHue := StrToInt( SubCommands.Strings[ 10 ] );

                        UpId := StrToInt( SubCommands.Strings[ 11 ] );
                        DownId := StrToInt( SubCommands.Strings[ 12 ] );
                        MoveOverId := StrToInt( SubCommands.Strings[ 13 ] );

                        BackUpHue := StrToInt( SubCommands.Strings[ 14 ] );
                        BackDownHue := StrToInt( SubCommands.Strings[ 15 ] );
                        BackMoveOverHue := StrToInt( SubCommands.Strings[ 16 ] );

                        IsPageButton := StrToInt( SubCommands.Strings[ 17 ] ) = 0;
                        PageId := StrToInt( SubCommands.Strings[ 18 ] );

                        Gump.AddTextButton( X, Y, ReturnNumber, Text, Font, CurrentPage, Breite, UpHue, DownHue, MoveOverHue, UpId, DownId, MoveOverId, BackUpHue, BackDownHue, BackMoveOverHue, Hoehe, IsPageButton, PageId );
                end
                else if LowerCase( SubCommands.Strings[ 0 ] ) = 'gumppic' then begin
                        if SubCommands.Count < 4 then begin
                                log.Write( 'buggy gump, gumppic has not enough parameters.' );
                                continue;
                        end;
                        X := StrToInt( SubCommands.Strings[ 1 ] );
                        Y := StrToInt( SubCommands.Strings[ 2 ] );
                        Id := StrToInt( SubCommands.Strings[ 3 ] );
                        if SubCommands.Count > 4 then
                                Hue := StrToInt( Copy( SubCommands.Strings[ 4 ], 5, Length( SubCommands.Strings[ 4 ] )-4 ) )
                        else
                                Hue := 0;
                        Gump.AddImage( X, Y, Id, Hue, CurrentPage );
                end
                else if LowerCase( SubCommands.Strings[ 0 ] ) = 'gumppictiled' then begin
                        if SubCommands.Count < 6 then begin
                                log.Write( 'buggy gump, gumppictiled has not enough parameters.' );
                                continue;
                        end;
                        X := StrToInt( SubCommands.Strings[ 1 ] );
                        Y := StrToInt( SubCommands.Strings[ 2 ] );
                        Breite := StrToInt( SubCommands.Strings[ 3 ] );
                        Hoehe := StrToInt( SubCommands.Strings[ 4 ] );
                        Id := StrToInt( SubCommands.Strings[ 5 ] );
                        if SubCommands.Count > 6 then
                                Hue := StrToInt( Copy( SubCommands.Strings[ 6 ], 5, Length( SubCommands.Strings[ 6 ] )-4 ) )
                        else
                                Hue := 0;
                        Gump.AddTiledImage( X, Y, Hoehe, Breite, Id, Hue, CurrentPage );
                end
                else if LowerCase( SubCommands.Strings[ 0 ] ) = 'htmlgump' then begin
                        if SubCommands.Count < 8 then begin
                                log.Write( 'buggy gump, htmlgump has not enough parameters.' );
                                continue;
                        end;
                        X := StrToInt( SubCommands.Strings[ 1 ] );
                        Y := StrToInt( SubCommands.Strings[ 2 ] );
                        Breite := StrToInt( SubCommands.Strings[ 3 ] );
                        Hoehe := StrToInt( SubCommands.Strings[ 4 ] );
                        if StrToInt( SubCommands.Strings[ 5 ] ) >= TextList.Count then
                                continue;
                        Text := TextList.Strings[ StrToInt( SubCommands.Strings[ 5 ] ) ];
                        HasBack := StrToInt( SubCommands.Strings[ 6 ] ) = 1;
                        CanScroll := StrToInt( SubCommands.Strings[ 7 ] ) = 1;

                        Gump.AddHtmlGump( X, Y, Text, Breite, Hoehe, HasBack, CanScroll, CurrentPage );
                end
                else if LowerCase( SubCommands.Strings[ 0 ] ) = 'xmfhtmlgump' then begin
                        if SubCommands.Count < 8 then begin
                                log.Write( 'buggy gump, xmfhtmlgump has not enough parameters.' );
                                continue;
                        end;
                        X := StrToInt( SubCommands.Strings[ 1 ] );
                        Y := StrToInt( SubCommands.Strings[ 2 ] );
                        Breite := StrToInt( SubCommands.Strings[ 3 ] );
                        Hoehe := StrToInt( SubCommands.Strings[ 4 ] );
                        ClilocId := StrToInt( SubCommands.Strings[ 5 ] );
                        HasBack := StrToInt( SubCommands.Strings[ 6 ] ) = 1;
                        CanScroll := StrToInt( SubCommands.Strings[ 7 ] ) = 1;
                        Gump.AddXmfHtmlGump( X, Y, ClilocId, Breite, Hoehe, HasBack, CanScroll, 0, CurrentPage );
                end
                else if LowerCase( SubCommands.Strings[ 0 ] ) = 'xmfhtmlgumpcolor' then begin
                        if SubCommands.Count < 9 then begin
                                log.Write( 'buggy gump, xmfhtmlgumpcolor has not enough parameters.' );
                                continue;
                        end;
                        X := StrToInt( SubCommands.Strings[ 1 ] );
                        Y := StrToInt( SubCommands.Strings[ 2 ] );
                        Breite := StrToInt( SubCommands.Strings[ 3 ] );
                        Hoehe := StrToInt( SubCommands.Strings[ 4 ] );
                        ClilocId := StrToInt( SubCommands.Strings[ 5 ] );
                        HasBack := StrToInt( SubCommands.Strings[ 6 ] ) = 1;
                        CanScroll := StrToInt( SubCommands.Strings[ 7 ] ) = 1;
                        Hue := StrToInt( SubCommands.Strings[ 8 ] );
                        Gump.AddXmfHtmlGump( X, Y, ClilocId, Breite, Hoehe, HasBack, CanScroll, Hue, CurrentPage );
                end
                else if LowerCase( SubCommands.Strings[ 0 ] ) = 'checkertrans' then begin
                        if SubCommands.Count < 5 then begin
                                log.Write( 'buggy gump, checkertrans has not enough parameters.' );
                                continue;
                        end;
                        X := StrToInt( SubCommands.Strings[ 1 ] );
                        Y := StrToInt( SubCommands.Strings[ 2 ] );
                        Breite := StrToInt( SubCommands.Strings[ 3 ] );
                        Hoehe := StrToInt( SubCommands.Strings[ 4 ] );
                        Gump.AddCheckerTrans( X, Y, Hoehe, Breite, CurrentPage );
                end
                else if LowerCase( SubCommands.Strings[ 0 ] ) = 'croppedtext' then begin
                        if SubCommands.Count < 7 then begin
                                log.Write( 'buggy gump, croppedtext has not enough parameters.' );
                                continue;
                        end;
                        X := StrToInt( SubCommands.Strings[ 1 ] );
                        Y := StrToInt( SubCommands.Strings[ 2 ] );
                        Breite := StrToInt( SubCommands.Strings[ 3 ] );
                        Hoehe := StrToInt( SubCommands.Strings[ 4 ] );
                        Hue := StrToInt( SubCommands.Strings[ 5 ] );
                        if StrToInt( SubCommands.Strings[ 6 ] ) >= TextList.Count then
                                continue;
                        Text := TextList.Strings[ StrToInt( SubCommands.Strings[ 6 ] ) ];
                        if SubCommands.Count > 7 then
                                Font := StrToInt( SubCommands.Strings[ 7 ] )
                        else
                                Font := 1;
                        Gump.AddCroppedText( X, Y, Hoehe, Breite, Text, Font, Hue, CurrentPage );
                end
                else if LowerCase( SubCommands.Strings[ 0 ] ) = 'resizepic' then begin
                        if SubCommands.Count < 6 then begin
                                log.Write( 'buggy gump, resizepic has not enough parameters.' );
                                continue;
                        end;
                        X := StrToInt( SubCommands.Strings[ 1 ] );
                        Y := StrToInt( SubCommands.Strings[ 2 ] );
                        Id := StrToInt( SubCommands.Strings[ 3 ] );
                        Breite := StrToInt( SubCommands.Strings[ 4 ] );
                        Hoehe := StrToInt( SubCommands.Strings[ 5 ] );

                        if SubCommands.Count > 6 then
                                Hue := StrToInt( SubCommands.Strings[ 6 ] )
                        else
                                Hue := 0;
                        Gump.AddResizeGump( X, Y, Id, Breite, Hoehe, Hue, CurrentPage );
                end
                else if LowerCase( SubCommands.Strings[ 0 ] ) = 'text' then begin
                        if SubCommands.Count < 5 then begin
                                log.Write( 'buggy gump, text has not enough parameters.' );
                                continue;
                        end;
                        X := StrToInt( SubCommands.Strings[ 1 ] );
                        Y := StrToInt( SubCommands.Strings[ 2 ] );
                        Hue := StrToInt( SubCommands.Strings[ 3 ] );
                        if StrToInt( SubCommands.Strings[ 4 ] ) >= TextList.Count then
                                continue;
                        Text := TextList.Strings[ StrToInt( SubCommands.Strings[ 4 ] ) ];

                        if SubCommands.Count > 5 then
                                Font := StrToInt( SubCommands.Strings[ 5 ] )
                        else
                                Font := 1;
                        if Text <> '' then
                                Gump.AddText( X, Y, Text, Font, Hue, CurrentPage );
                end
                else if LowerCase( SubCommands.Strings[ 0 ] ) = 'tilepic' then begin
                        if SubCommands.Count < 4 then begin
                                log.Write( 'buggy gump, tilepic has not enough parameters.' );
                                continue;
                        end;
                        X := StrToInt( SubCommands.Strings[ 1 ] );
                        Y := StrToInt( SubCommands.Strings[ 2 ] );
                        Id := StrToInt( SubCommands.Strings[ 3 ] );
                        if SubCommands.Count >= 5 then
                                Hue := StrToInt( SubCommands.Strings[ 4 ] )
                        else
                                Hue := 0;
                        Gump.AddTilePic( X, Y, Id, Hue, CurrentPage );
                end
                else if LowerCase( SubCommands.Strings[ 0 ] ) = 'tilepichue' then begin
                        if SubCommands.Count < 5 then begin
                                log.Write( 'buggy gump, tilepic has not enough parameters.' );
                                continue;
                        end;
                        X := StrToInt( SubCommands.Strings[ 1 ] );
                        Y := StrToInt( SubCommands.Strings[ 2 ] );
                        Id := StrToInt( SubCommands.Strings[ 3 ] );
                        Hue := StrToInt( SubCommands.Strings[ 4 ] );
                        Gump.AddTilePic( X, Y, Id, Hue, CurrentPage );
                end
                else if LowerCase( SubCommands.Strings[ 0 ] ) = 'textentry' then begin
                        if SubCommands.Count < 8 then begin
                                log.Write( 'buggy gump, textentry has not enough parameters.' );
                                continue;
                        end;
                        X := StrToInt( SubCommands.Strings[ 1 ] );
                        Y := StrToInt( SubCommands.Strings[ 2 ] );
                        Breite := StrToInt( SubCommands.Strings[ 3 ] );
                        Hoehe := StrToInt( SubCommands.Strings[ 4 ] );
                        Hue := StrToInt( SubCommands.Strings[ 5 ] );
                        TextId := StrToInt( SubCommands.Strings[ 6 ] );
                        if StrToInt( SubCommands.Strings[ 7 ] ) >= TextList.Count then
                                continue;
                        Text := TextList.Strings[ StrToInt( SubCommands.Strings[ 7 ] ) ];
                        if SubCommands.Count > 8 then
                                AllowOnlyNumbers := SubCommands.Strings[ 8 ] = '1'
                        else
                                AllowOnlyNumbers := False;
                        if SubCommands.Count > 9 then
                                Stars := SubCommands.Strings[ 9 ] = '1'
                        else
                                Stars := False;
                        if SubCommands.Count > 10 then
                                Font := StrToInt( SubCommands.Strings[ 10 ] )
                        else
                                Font := 1;
                        if SubCommands.Count > 11 then
                                AllowMultiLines := SubCommands.Strings[ 11 ] = '1'
                        else
                                AllowMultiLines := True;
                        Gump.AddInputField( X, Y, Hoehe, Breite, Text, Font, TextId, Hue, CurrentPage, AllowOnlyNumbers, Stars, AllowMultiLines );
                end
                else if LowerCase( SubCommands.Strings[ 0 ] ) = 'checkbox' then begin
                        if SubCommands.Count < 7 then begin
                                log.Write( 'buggy gump, checkbox has not enough parameters.' );
                                continue;
                        end;
                        X := StrToInt( SubCommands.Strings[ 1 ] );
                        Y := StrToInt( SubCommands.Strings[ 2 ] );
                        FalseId := StrToInt( SubCommands.Strings[ 3 ] );
                        TrueId := StrToInt( SubCommands.Strings[ 4 ] );
                        Checked := StrToInt( SubCommands.Strings[ 5 ] ) = 1;
                        ReturnNumber := StrToInt( SubCommands.Strings[ 6 ] );
                        Gump.AddCheckBox( X, Y, TrueId, FalseId, Checked, ReturnNumber, CurrentPage );
                end
                else if LowerCase( SubCommands.Strings[ 0 ] ) = 'radio' then begin
                        if SubCommands.Count < 7 then begin
                                log.Write( 'buggy gump, radio has not enough parameters.' );
                                continue;
                        end;
                        X := StrToInt( SubCommands.Strings[ 1 ] );
                        Y := StrToInt( SubCommands.Strings[ 2 ] );
                        FalseId := StrToInt( SubCommands.Strings[ 3 ] );
                        TrueId := StrToInt( SubCommands.Strings[ 4 ] );
                        Checked := StrToInt( SubCommands.Strings[ 5 ] ) = 1;
                        ReturnNumber := StrToInt( SubCommands.Strings[ 6 ] );
                        Gump.AddRadioButton( X, Y, TrueId, FalseId, Checked, ReturnNumber, CurrentGroup, CurrentPage );
                end
                else if LowerCase( SubCommands.Strings[ 0 ] ) = 'progressbar' then begin
                        if SubCommands.Count < 14 then begin
                                log.Write( 'buggy gump, progressbar has not enough parameters.' );
                                continue;
                        end;

                        X := StrToInt( SubCommands.Strings[ 1 ] );
                        Y := StrToInt( SubCommands.Strings[ 2 ] );
                        Breite := StrToInt( SubCommands.Strings[ 3 ] );
                        Hoehe := StrToInt( SubCommands.Strings[ 4 ] );
                        BackLeftColor := StrToInt( SubCommands.Strings[ 5 ] );
                        BackRightColor := StrToInt( SubCommands.Strings[ 6 ] );                        
                        LeftColor := StrToInt( SubCommands.Strings[ 7 ] );
                        RightColor := StrToInt( SubCommands.Strings[ 8 ] );
                        TextId := StrToInt( SubCommands.Strings[ 9 ] );
                        if TextId >= TextList.Count then
                                Text := ''
                        else
                                Text := TextList.Strings[ TextId ];
                        TextId := StrToInt( SubCommands.Strings[ 10 ] );
                        if TextId >= TextList.Count then
                                Align := 'LEFT'
                        else
                                Align := TextList.Strings[ TextId ];
                        TextColor := StrToInt( SubCommands.Strings[ 11 ] );
                        Max := StrToInt( SubCommands.Strings[ 12 ] );
                        Current := StrToInt( SubCommands.Strings[ 13 ] );

                        if SubCommands.Count > 14 then
                                Waagerecht := StrToInt( SubCommands.Strings[ 14 ] ) > 0
                        else
                                Waagerecht := True;

                        Gump.AddProgressBar( X, Y, Breite, Hoehe, Current, Max, BackLeftColor, BackRightColor, LeftColor, RightColor, Text, Align, TextColor, Waagerecht, CurrentPage );
                end
                else begin
                end;

                SubCommands.Free;
        end;

        Palanthir.AddGump( Gump );

        CommandList.Free;
        TextList.Free;
        Packet.Free;
end;

procedure TNetwork.HandleGetProfile( Packet : GetProfile );
var     Profile : TProfile;
        I : Integer;
begin
        Profile := nil;
        for I := Palanthir.GetGumpCount-1 downto 0 do
                if TGump( Palanthir.GetGump( I ) ).Typ = GumpTyp_Profile then begin
                        Profile := TProfile( Palanthir.GetGump( I ) );
                        if Profile.CharSerial = Packet.GetSerial then
                                break
                        else
                                Profile := nil;
                end;

        if Profile = nil then
                Profile := TProfile.Create;

        if Profile.Init( Packet ) then
                Palanthir.AddGump( Profile )
        else
                Profile.Free;
        Packet.Free;
end;

procedure TNetwork.HandleGetQuestPointer( Packet : GetQuestPointer );
begin
        Log.Write( Format( 'Unused Packet GetQuestPointer Type: %x Length: %d', [Packet.GetPacketType,Packet.GetLength] ) );
        Log.Write( Packet.Dump );
        Packet.Free;
end;

procedure TNetwork.HandleVersionRequest( Packet : VersionRequest );
begin
        Log.Write( Format( 'Unused Packet VersionRequest Type: %x Length: %d', [Packet.GetPacketType,Packet.GetLength] ) );
        Log.Write( Packet.Dump );
        Packet.Free;
end;

procedure TNetwork.HandleGetMultiCommand( Packet : GetMultiCommand );
var     AntiFastWalk : InitializeAntiFastWalk;
        AddAFWKey : AddAntiFastWalkKey;
        CloseGump : GetCloseGump;
        CloseStatusGump : GetCloseStatusGump;
        DisplayPopupMenu : GetDisplayPopupMenu;
        ShowDamage : GetShowDamage;
        AttachTooltip : GetAttachTooltip;
        I : Integer;
        PartyPacket : TPartyPacket;
        PartyAddMember : TPartyAddMember;
        PartyRemoveMember : TPartyRemoveMember;
        PartyPersonalMessage : TPartyPersonalMessage;
        PartyMessage : TPartyMessage;
        PartyInvitation : TPartyInvitation;
begin
        Case Packet.GetSubCommand of
                $01 : begin
                        AntiFastWalk := InitializeAntiFastWalk( Packet );

                        Palanthir.Movement.FastwalkPreventionEnabled := True;
                        Palanthir.Movement.Keys[ 0 ] := AntiFastWalk.GetKey( 0 );
                        Palanthir.Movement.Keys[ 1 ] := AntiFastWalk.GetKey( 1 );
                        Palanthir.Movement.Keys[ 2 ] := AntiFastWalk.GetKey( 2 );
                        Palanthir.Movement.Keys[ 3 ] := AntiFastWalk.GetKey( 3 );
                        Palanthir.Movement.Keys[ 4 ] := AntiFastWalk.GetKey( 4 );
                        Palanthir.Movement.Keys[ 5 ] := AntiFastWalk.GetKey( 5 );

                        AntiFastWalk.Free;
                        end;
                $02 : begin
                        AddAFWKey := AddAntiFastWalkKey( Packet );

                        for I := 4 downto 0 do
                                Palanthir.Movement.Keys[ I+1 ] := Palanthir.Movement.Keys[ I ];
                        Palanthir.Movement.Keys[ 0 ] := AddAFWKey.GetKey;

                        AddAFWKey.Free;
                        end;
                $04 : begin
                        CloseGump := GetCloseGump( Packet );
                        for I := Palanthir.GetGumpCount-1 downto 0 do
                                if TGump( Palanthir.GetGump( I ) ).Typ = CloseGump.getSerial then
                                        Palanthir.DeleteGump( TGump( Palanthir.GetGump( I ) ) );
                        CloseGump.Free;
                        end;
                $06 : begin
                        PartyPacket := TPartyPacket( Packet );

                        Case PartyPacket.GetSubSubCommand of
                                1 : begin
                                        PartyAddMember := TPartyAddMember( PartyPacket );
                                        Palanthir.Player.Party.AddMember( PartyAddMember );
                                        end;
                                2 : begin
                                        PartyRemoveMember := TPartyRemoveMember( PartyPacket );
                                        Palanthir.Player.Party.RemoveMember( PartyRemoveMember );
                                        end;
                                3 : begin
                                        PartyPersonalMessage := TPartyPersonalMessage( PartyPacket );
                                        Palanthir.Player.Party.GetPersonalMessage( PartyPersonalMessage );
                                        end;
                                4 : begin
                                        PartyMessage := TPartyMessage( PartyPacket );
                                        Palanthir.Player.Party.GetMessage( PartyMessage );
                                        end;
                                7 : begin
                                        PartyInvitation := TPartyInvitation( PartyPacket );
                                        Palanthir.Player.Party.GetInvitation( PartyInvitation );
                                        end;
                        end;
                        Packet.Free;
                        end;
                $08 : begin
                        Palanthir.ChangeMap( Packet.GetByte( 5 ) );
                        Packet.Free;
                        end;
                $0C : begin
                        CloseStatusGump := GetCloseStatusGump( Packet );
                        for I := Palanthir.GetGumpCount-1 downto 0 do
                                if (TGump( Palanthir.GetGump( I ) ).Typ = GumpTyp_Status) and  (TStatusGump( Palanthir.GetGump( I ) ).CharSerial = CloseStatusGump.GetSerial) then begin
                                        Palanthir.DeleteGump( TGump( Palanthir.GetGump( I ) ) );
                                        Break;
                                end;
                        CloseStatusGump.Free;
                        end;
                $10 : begin
                        AttachTooltip := GetAttachTooltip( Packet );
                        Palanthir.AddTooltip( AttachTooltip );
                        AttachTooltip.Free;
                        end;
                $14 : begin
                        DisplayPopupMenu := GetDisplayPopupMenu( Packet );
                        Log.Write( Format( 'Unused Packet GetDisplayPopupMenu Type: %x Length: %d', [DisplayPopupMenu.GetPacketType,DisplayPopupMenu.GetLength] ) );
                        Log.Write( DisplayPopupMenu.Dump );
                        DisplayPopupMenu.Free;
                        end;
                $22 : begin
                        ShowDamage := GetShowDamage( Packet );
                        Log.Write( Format( 'Unused Packet GetShowDamage Type: %x Length: %d', [ShowDamage.GetPacketType,ShowDamage.GetLength] ) );
                        Log.Write( ShowDamage.Dump );
                        ShowDamage.Free;
                        end;
                else begin
                        Log.Write( Format( 'Unused Packet GetMultiCommand Type: %x Length: %d', [Packet.GetPacketType,Packet.GetLength] ) );
                        Log.Write( Packet.Dump );
                        Packet.Free;
                end;
        end;
end;

procedure TNetwork.HandleEffect( Packet : Effect );
var     Effect : TEffect;
begin
        Effect := TEffect.Create;
        Effect.Init( Packet );
        Packet.Free;
end;

procedure TNetwork.HandleGetClilocMessage( Packet : GetClilocMessage );
begin
        Palanthir.AddClilocSpeech( Packet );
        Packet.Free;
end;

procedure TNetwork.HandleGetSemiVisible( Packet : GetSemiVisible );
begin
        Log.Write( Format( 'Unused Packet GetSemiVisible Type: %x Length: %d', [Packet.GetPacketType,Packet.GetLength] ) );
        Log.Write( Packet.Dump );
        Packet.Free;
end;

procedure TNetwork.HandleParticleEffect( Packet : ParticleEffect );
begin
        Log.Write( Format( 'Unused Packet ParticleEffect Type: %x Length: %d', [Packet.GetPacketType,Packet.GetLength] ) );
        Log.Write( Packet.Dump );
        Packet.Free;
end;

procedure TNetwork.HandleGetClilocAffix( Packet : GetClilocAffix );
begin
        Palanthir.AddClilocAffixSpeech( Packet );
        Packet.Free;
end;

procedure TNetwork.HandleGetTooltipList( Packet : GetTooltipList );
begin
        Log.Write( Format( 'Unused Packet GetTooltipList Type: %x Length: %d', [Packet.GetPacketType,Packet.GetLength] ) );
        Log.Write( Packet.Dump );
        Packet.Free;
end;

procedure TNetwork.HandleGetNewBookTitlePage( Packet : GetNewBookTitlePage );
var     I : Integer;
        Book : TBook;
begin
        for I := 0 to Palanthir.GetGumpCount-1 do
                if (Palanthir.GetGump( I ).Typ = GumpTyp_Book) and ( TBook( Palanthir.GetGump( I ) ).Serial = Packet.GetSerial ) then begin
                        Palanthir.DeleteGump( I );
                        Break;
                end;

        Book := TBook.Create;
        Book.Init( Packet );
        Palanthir.AddGump( Book );

        Packet.Free;
end;

procedure TNetwork.HandleGetMEInfo( Packet : GetMEInfo );
var     CharSize : GetCharSize;
        Char : TChar;
        MultiID : GetFirstMultiID;
        MEProfile : GetMEProfile;
        I : Integer;
        Profile : TMEProfile;
        SendMacAddress : TSendMacAddress;
        SendVersion : TSendVersion;
        MEDisableRadar : GetMEDisableRadar;
        MEFightSystem : GetMEFightSystem;
        MEOpenFightGump : GetMEOpenFightGump;
        MEFightDoDamage : GetMEFightDoDamage;
        FightGump : TFightGump;
        MEUpdateWounds : GetMEUpdateWounds;
        MEAddToInvisList : GetMEAddToInvisList;
        MERemoveFromInvisList : GetMERemoveFromInvisList;
        DirectionArrow : GetDirectionArrow;
        DirectionArrowGump : TDirectionArrowGump;
        LoadStaticsMapFromMuls : GetLoadStaticsMapFromMuls;
        MapBlockPacket : GetMapBlock;
        StaticBlockPacket : GetStaticBlock;
        MapBlock : TMapBlock;
        StaticItem : TStaticItem;
        WorldBlock : TWorldBlock;
        CharSpeed : GetCharSpeed;
        CloseContainer : GetCloseContainerGump;
        CharTransparency : GetCharTransparency;
begin
        Case Packet.GetType of
                $01 : begin
                        CharSize := GetCharSize( Packet );

                        Char := TChar( Palanthir.Data.GlobalObjectList.GetObject( CharSize.GetSerial ) );

                        if Char = nil then begin
                                CharSize.Free;
                                exit;
                        end;

                        Char.AnimZoomX := CharSize.GetBreite / 1000;
                        Char.AnimZoomY := CharSize.GetHoehe / 1000;
                        CharSize.Free;
                end;
                $02 : begin
                        MultiID := GetFirstMultiID( Packet );

                        Palanthir.FirstMultiID := MultiID.GetID;
                        Palanthir.LastMultiID := MultiID.GetID + $FFF;
                        Palanthir.UseItemUpdateIdFlag := False;
                        MultiID.Free;
                end;
                $03 : begin
                        MEProfile := GetMEProfile( Packet );
                        Profile := nil;
                        for I := Palanthir.GetGumpCount-1 downto 0 do
                                if TGump( Palanthir.GetGump( I ) ).Typ = GumpTyp_Profile then begin
                                        Profile := TMEProfile( Palanthir.GetGump( I ) );
                                        if Profile.CharSerial = MEProfile.GetSerial then
                                                break
                                        else
                                                Profile := nil;
                                end;

                        if Profile = nil then
                                Profile := TMEProfile.Create;

                        if Profile.Init( MEProfile ) then
                                Palanthir.AddGump( Profile )
                        else
                                Profile.Free;

                        MEProfile.Free;
                end;
                $04 : begin
                        SendMacAddress := TSendMacAddress.Create;
                        SendMacAddress.SetMacAddress( GetMacAddress );
                        Palanthir.SendPacket( SendMacAddress );
                        Packet.Free;
                end;
                $06 : begin
                        SendVersion := TSendVersion.Create;
                        SendVersion.SetVersion( Version );
                        Palanthir.SendPacket( SendVersion );
                        Packet.Free;
                end;
                $08 : begin
                        MEDisableRadar := GetMEDisableRadar( Packet );
                        Palanthir.DisableRadar := MEDisableRadar.RadarDisabled;
                        MEDisableRadar.Free;
                end;
                $09 : begin
                        MEFightSystem := GetMEFightSystem( Packet );
                        Case MEFightSystem.GetFightSystemSubSubType of
                                $01 : begin
                                        MEOpenFightGump := GetMEOpenFightGump( MEFightSystem );

                                        FightGump := nil;
                                        for I := 0 to Palanthir.GetGumpCount-1 do begin
                                                if Palanthir.GetGump( I ).Typ = GumpTyp_FightGump then begin
                                                        FightGump := TFightGump( Palanthir.GetGump( I ) );
                                                        Break;
                                                end;
                                        end;

                                        if FightGump = nil then begin
                                                FightGump := TFightGump.Create;
                                                Palanthir.AddGump( FightGump );
                                        end;

                                        FightGump.Update( MEOpenFightGump.GetTargetSerial, MEOpenFightGump.TrefferZone, MEOpenFightGump.Kampfmodus, MEOpenFightGump.Kampfgeschwindigkeit, MEOpenFightGump.Ausweichen, MEOpenFightGump.TrefferZoneFixed, MEOpenFightGump.KampfmodusFixed, MEOpenFightGump.KampfgeschwindigkeitFixed, MEOpenFightGump.AusweichenFixed, MEOpenFightGump.IsPlayer > 0 );

                                        MEOpenFightGump.Free;
                                end;
                                $03 : begin
                                        MEFightDoDamage := GetMEFightDoDamage( MEFightSystem );

                                        FightGump := nil;
                                        for I := 0 to Palanthir.GetGumpCount-1 do begin
                                                if Palanthir.GetGump( I ).Typ = GumpTyp_FightGump then begin
                                                        FightGump := TFightGump( Palanthir.GetGump( I ) );
                                                        Break;
                                                end;
                                        end;

                                        if FightGump <> nil then begin
                                                FightGump.AddDamage( MEFightDoDamage.TrefferZone, MEFightDoDamage.Staerke );
                                        end;

                                        MEFightDoDamage.Free;
                                end;
                        else
                                MEFightSystem.Free;
                        end;
                end;
                $0A : begin
                        MEUpdateWounds := GetMEUpdateWounds( Packet );

                        for I := 0 to 6 do begin
                                Case MEUpdateWounds.GetWound( I ) of
                                        0 : Palanthir.Player.Wounds[I] := $3E;
                                        1 : Palanthir.Player.Wounds[I] := $42;
                                        2 : Palanthir.Player.Wounds[I] := $35;
                                        3 : Palanthir.Player.Wounds[I] := $31;
                                        4 : Palanthir.Player.Wounds[I] := $21;
                                end;
                        end;

                        MEUpdateWounds.Free;
                end;
                $0B : begin
                        MEAddToInvisList := GetMEAddToInvisList( Packet );
                        for I := 0 to MEAddToInvisList.GetCount-1 do begin
                                Palanthir.AddToServerInvisList( MEAddToInvisList.GetId( I ) );
                        end;
                        MEAddToInvisList.Free;
                end;
                $0C : begin
                        MERemoveFromInvisList := GetMERemoveFromInvisList( Packet );
                        for I := 0 to MERemoveFromInvisList.GetCount-1 do begin
                                Palanthir.RemoveFromServerInvisList( MERemoveFromInvisList.GetId( I ) );
                        end;
                        MERemoveFromInvisList.Free;
                end;
                $0D : begin
                        DirectionArrow := GetDirectionArrow( Packet );

                        for I := Palanthir.GetGumpCount-1 downto 0 do begin
                                if Palanthir.GetGump( I ).Typ = GumpTyp_DirectionArrow then begin
                                        Palanthir.DeleteGump( I );
                                end;
                        end;

                        DirectionArrowGump := TDirectionArrowGump.Create( DirectionArrow.GetX, DirectionArrow.GetY );
                        Palanthir.AddGump( DirectionArrowGump );                        
                        DirectionArrow.Free;
                end;
                $0E : begin
                       LoadStaticsMapFromMuls := GetLoadStaticsMapFromMuls( Packet );
                       Palanthir.LoadMapStatics := LoadStaticsMapFromMuls.LoadStaticsMap;
                       Palanthir.Data.WorldCache.ClearMapStatics;
                       LoadStaticsMapFromMuls.Free;
                end;
                $0F : begin
                        MapBlockPacket := GetMapBlock( Packet );

                        WorldBlock := Palanthir.Data.WorldCache.GetObject( MapBlockPacket.GetBlockID );
                        WorldBlock.ClearMap;

                        for I := 0 to 63 do begin
                                MapBlock.Cells[ I ].Id := MapBlockPacket.GetId( I );
                                MapBlock.Cells[ I ].Z := MapBlockPacket.GetZ( I );
                        end;

                        WorldBlock.MapListe := Palanthir.Data.InitMap( MapBlockPacket.GetBlockID, MapBlock );

                        if (WorldBlock.MapListe <> nil) and WorldBlock.Visible then begin
                                for I := 0 to 63 do begin
                                        Palanthir.AddWorldItem( WorldBlock.MapListe^[ I ] );
                                end;
                        end;

                        MapBlockPacket.Free;
                end;
                $10 : begin
                        StaticBlockPacket := GetStaticBlock( Packet );

                        WorldBlock := Palanthir.Data.WorldCache.GetObject( StaticBlockPacket.GetBlockID );
                        WorldBlock.ClearStatics;

                        if StaticBlockPacket.GetStaticCount > 0 then begin
                                WorldBlock.StaticCount := StaticBlockPacket.GetStaticCount;
                                GetMem( WorldBlock.StaticListe, WorldBlock.StaticCount*sizeof( TStaticItem ) );

                                for I := 0 to WorldBlock.StaticCount-1 do begin
                                        StaticItem := TStaticItem.Create;
                                        StaticItem.ID := StaticBlockPacket.GetId( I );
                                        StaticItem.Pos.X := StaticBlockPacket.GetX( I );
                                        StaticItem.Pos.Y := StaticBlockPacket.GetY( I );
                                        StaticItem.Pos.Z := StaticBlockPacket.GetZ( I );
                                        StaticItem.Color := StaticBlockPacket.GetColor( I );

                                        WorldBlock.StaticListe^[ I ] := StaticItem;

                                        if WorldBlock.Visible then begin
                                                Palanthir.AddWorldItem( StaticItem );
                                        end;
                                end;
                        end;

                        StaticBlockPacket.Free;
                end;
                $11: begin
                        CharSpeed := GetCharSpeed( Packet );

                        Char := TChar( Palanthir.Data.GlobalObjectList.GetObject( CharSpeed.GetSerial ) );

                        if Char = nil then begin
                                CharSize.Free;
                                exit;
                        end;

                        //Wichtig: Speed < 5 kann u.U. eine Endlosschleife in TPlayer.PollAnim verursachen
                        Char.CustomMovingSpeed := Max( CharSpeed.GetMovingSpeed, 10 );
                        Char.CustomRunningSpeed := Max( CharSpeed.GetRunningSpeed, 10 );
                        Char.EnableCustomSpeed := True;

                        CharSpeed.Free;
                end;
                $12: begin
                        CloseContainer := GetCloseContainerGump( Packet );

                        for I := 0 to Palanthir.GetGumpCount-1 do begin
                                if Palanthir.GetGump( I ).Typ = GumpTyp_Container then begin
                                        if TContainer( Palanthir.GetGump( I ) ).ItemSerial = CloseContainer.GetSerial then begin
                                                Palanthir.DeleteGump( I );
                                                Break;
                                        end;
                                end;
                        end;

                        CloseContainer.Free;
                end;
                $17: begin
                        CharTransparency := GetCharTransparency( Packet );

                        Char := TChar( Palanthir.Data.GlobalObjectList.GetObject( CharTransparency.GetSerial ) );
                        if Char <> nil then begin
                                Char.Transparency := CharTransparency.GetAlpha;
                        end;

                        CharTransparency.Free;
                end;
                else begin
                        Log.Write( Format( 'Unused Packet GetMEInfo Type: %x Length: %d SubType: %x', [Packet.GetPacketType,Packet.GetLength,Packet.GetType] ) );
                        Log.Write( Packet.Dump );
                        Packet.Free;
                end;
        end;
end;

procedure TNetwork.HandleGetUnicodeTextEntry( Packet : GetUnicodeTextEntry );
begin
        Palanthir.Keyboard.Typ := KB_Speech_UnicodeEntry;
        Palanthir.Keyboard.SpeechText := '';
        Palanthir.Keyboard.MessageId := Packet.GetMessageId;
        Palanthir.Keyboard.PlayerId := Packet.GetPlayerSerial;
        Palanthir.Keyboard.KeyboardMode := KB_Speech;
        Packet.Free;
end;

end.
