unit uRecievePackets;

interface

uses    uPacket, SysUtils, uUtilities;

type    LoginDenied = Class( UOPacket )
                public
                        function GetWhy : Byte;
        end;

        ShardList = Class( UOPacket )
                public
                        function GetFlag : Byte;
                        function GetServerCount : Word;
                        function GetServerIndex( Index : Byte ) : Word;
                        function GetServerName( Index : Byte ) : String;
                        function GetPercentFull( Index : Byte ) : Byte;
                        function GetTimeZone( Index : Byte ) : Byte;
                        function GetPingIP( Index : Byte ) : Longword;
        end;

        GetGameServer = Class( UOPacket )
                public
                        function GetIP( Index : Byte ) : Byte;
                        function GetPort : Word;
                        function GetKey : Longword;
        end;

        EnableClientFeatures = Class( UOPacket )
                public
                        function GetFeatures : Word;
        end;

        CharTownList = Class( UOPacket )
                public
                        function GetCharCount : Byte;
                        function GetCharName( Index : Byte ) : String;
                        function GetPassword( Index : Byte ) : String;
                        function GetTownCount : Byte;
                        function GetTownIndex( Index : Byte ) : Byte;
                        function GetGeneralName( Index : Byte ) : String;
                        function GetExactName( Index : Byte ) : String;
                        function GetFlags : Longword;
        end;

        UpdateCharList = Class( UOPacket )
                public
                        function GetCount : Byte;
                        function GetName( Index : Byte ) : String;
                        function GetPassword( Index : Byte ) : String;
        end;        

        GetViewRange = Class( UOPacket )
                public
                        function GetVisRange : Byte;
        end;

        GetCharLocation = Class( UOPacket )
                public
                        function getPlayerID : Longword;
                        function getUnknown1 : Longword;
                        function getBody : Word;
                        function getX : Word;
                        function getY : Word;
                        function getZ : Word;
                        function getDirection : Byte;
                        function getUnknown2 : Word;
                        function getUnknown3 : Longword;
                        function getUnknown4 : Longword;
                        function getFlags : Byte;
                        function getHighLight : Byte;
                        function getUnknown5 : Longword;
                        function getUnknown6 : Word;
                        function getUnknown7 : Byte;
        end;

        GetSeason = Class( UOPacket )
                public
                        function GetSeason : Byte;
                        function SeasonChanged : Byte;
        end;

        DrawGamePlayer = Class( UOPacket )
                public
                        function getSerial : Longword;
                        function getBody : Word;
                        function getUnknown1 : Byte;
                        function getSkin : Word;
                        function getFlag : Byte;
                        function getX : Word;
                        function getY : Word;
                        function getUnknown2 : Word;
                        function getDirection : Byte;
                        function getZ : Byte;
        end;

        GetLightLevel = Class( UOPacket )
                public
                        function GetLevel : Byte;
        end;

        GetSubServer = Class( UOPacket )
                public
                        function getX : Word;
                        function getY : Word;
                        function getZ : Word;
                        function getBoundX : Word;
                        function getBoundY : Word;
                        function getWidth : Word;
                        function getHeight : Word;
        end;

        DrawObject = Class( UOPacket )
                public
                        function getSerial : LongWord;
                        function getModel : Word;
                        function getX : Word;
                        function getY : Word;
                        function getZ : Byte;
                        function getDirection : Byte;
                        function getColor : Word;
                        function getFlag : Byte;
                        function getHighLight : Byte;
        end;

        GetWornItem = Class( UOPacket )
                public
                        function getSerial : LongWord;
                        function getModel : Word;
                        function getUnkown1 : Byte;
                        function getLayer : Byte;
                        function getWearer : LongWord;
                        function getColor : Word;
        end;

        UpdateHealth = Class( UOPacket )
                public
                        function getSerial : LongWord;
                        function getMaxHealth : Word;
                        function getCurrentHealth : Word;
        end;

        UpdateMana = Class( UOPacket )
                public
                        function getSerial : LongWord;
                        function getMaxMana : Word;
                        function getCurrentMana : Word;
        end;

        UpdateStamina = Class( UOPacket )
                public
                        function getSerial : LongWord;
                        function getMaxStamina : Word;
                        function getCurrentStamina : Word;
        end;

        GetChangeWarMode = Class( UOPacket )
                public
                        function getFlag : Byte;
        end;

        LoginComplete = Class( UOPacket )
                public
        end;

        GetTime = Class( UOPacket )
                public
                        function getHour : Byte;
                        function getMinute : Byte;
                        function getSecond : Byte;
        end;

        StatWindow = Class( UOPacket )
                public
                        function getSerial : Longword;
                        function getName : String;
                        function getCurrentHealth : Word;
                        function getMaxHealth : Word;
                        function getNameChangeFlag : Byte;
                        function getFlag : Byte;

                        function getSex : Byte;
                        function getStr : Word;
                        function getDex : Word;
                        function getInt : Word;
                        function getCurrentStamina : Word;
                        function getMaxStamina : Word;
                        function getCurrentMana : Word;
                        function getMaxMana : Word;
                        function getGold : LongWord;
                        function getArmorClass : Word;
                        function getWeight : Word;

                        function getStatCap : Word;
                        function getCurrentPets : Byte;
                        function getMaxPets : Byte;

                        function getResistFire : Word;
                        function getResistCold : Word;
                        function getResistPoison : Word;
                        function getResistEnergy : Word;
                        function getLuck : Word;
                        function getMaxDamage : Word;
                        function getMinDamage : Word;
                        function getUnkown : LongWord;

                        function getMEAusdauer : Word;
                        function getMEAusdauerMax : Word;
                        function getMEXP : Word;
                        function getMELevel : Byte;
                        function getMEGewicht : Word;
                        function getMEGewichtMax : Word;
                        function getMEVolumen : Word;
                        function getMEVolumenMax : Word;
                        function getMEGold : LongWord;
        end;

        GetItem = Class( UOPacket )
                public
                        function getSerial : LongWord;
                        function getId : Word;
        end;

        GetSpeech = Class( UOPacket )
                public
                        function getSerial : LongWord;
                        function getId : Word;
                        function getSpeechType : Byte;
                        function getTextColor : Word;
                        function getFont : Word;
                        function getName : String;
                        function getMessage : String;
        end;

        DeleteObject = Class( UOPacket )
                public
                        function getSerial : LongWord;
        end;

        DenyMove = Class( UOPacket )
                public
                        function getSequence : Byte;
                        function getX : Word;
                        function getY : Word;
                        function getDirection : Byte;
                        function getZ : Byte;
        end;

        AcceptMove = Class( UOPacket )
                public
                        function getSequence : Byte;
                        function getHightLight : Byte;
        end;

        OpenContainer = Class( UOPacket )
                public
                        function GetSerial : LongWord;
                        function GumpId : Word;
        end;

        AddContainerItem = Class( UOPacket )
                public
                        function GetItemSerial : LongWord;
                        function GetId : Word;
                        function GetUnknown1 : Byte;
                        function GetAmount : Word;
                        function GetX : Word;
                        function GetY : Word;
                        function GetContainerSerial : LongWord;
                        function GetColor : Word;
        end;

        KickPlayer = Class( UOPacket )
                public
                        function GetSerial : LongWord;
        end;

        RejectItemMoveRequest = Class( UOPacket )
                public
                        function GetReason : Byte;
        end;

        ClearSquare = Class( UOPacket )
                public
                        function GetX : Word;
                        function GetY : Word;
        end;

        PaperdollClothingAdded = Class( UOPacket )
                public
        end;

        ShowBattle = Class( UOPacket )
                public
                        function GetUnknown1 : Byte;
                        function GetAttackerSerial : LongWord;
                        function GetDefenderSerial : LongWord;
        end;

        PauseClient = Class( UOPacket )
                public
                        function GetResume : Byte;
        end;

        GetSkills = Class( UOPacket )
                public
                        function GetSubType : Byte;
        end;

        GetBuyItems = Class( UOPacket )
                public
                        function GetSerial : LongWord;
                        function GetFlag : Byte;
        end;

        GetItemsInContainer = Class( UOPacket )
                public
                        function GetItemCount : Word;
                        function GetItemSerial( Index : Word ) : LongWord;
                        function GetItemID( Index : Word ) : Word;
                        function GetUnkown1( Index : Word ) : Byte;
                        function GetAmount( Index : Word ) : Word;
                        function GetX( Index : Word ) : Word;
                        function GetY( Index : Word ) : Word;
                        function GetContainerSerial( Index : Word ) : LongWord;
                        function GetColor( Index : Word ) : Word;
        end;

        GetGlow = Class( UOPacket )
                public
                        function GetSerial : LongWord;
                        function GetLevel : Byte;
        end;

        IdleWarning = Class( UOPacket )
                public
                        function GetReason : Byte;
        end;

        PlaySound = Class( UOPacket )
                public
                        function GetMode : Byte;
                        function GetSound : Word;
                        function Unkown3 : Word;
                        function GetX : Word;
                        function GetY : Word;
                        function GetZ : Word;
        end;

        GetWeather = Class( UOPacket )
                public
                        function GetType : Byte;
                        function GetAmount : Byte;
                        function GetTemperature : Byte;
        end;

        GetBook = Class( UOPacket )
                public
                        function GetSerial : LongWord;
                        function GetPageCout : Word;
        end;

        CreateTargetCursor = Class( UOPacket )
                public
                        function GetType : Byte;
                        function GetCursorID : LongWord;
                        function GetCursorType : Byte;
        end;

        PlayMidi = Class( UOPacket )
                public
                        function GetId : Word;
        end;

        DoCharAnimation = Class( UOPacket )
                public
                        function GetSerial : LongWord;
                        function GetAnimationID : Word;
                        function GetUnknown1 : Byte;
                        function GetStartFrame : Byte;
                        function GetRepeat : Word;
                        function GetBackward : Byte;
                        function GetRepeatFlag : Byte;
                        function GetFrameDelay : Byte;
        end;

        GetSecureTrading = Class( UOPacket )
                public
                        function GetAction : Byte;
                        function GetSerial1 : LongWord;
                        function GetSerial2 : LongWord;
                        function GetSerial3 : LongWord;
                        function NameFollowing : Byte;
                        function GetName : String;
        end;

        OldEffect = Class( UOPacket )
                public
                        function GetType : Byte;
                        function GetSourceSerial : LongWord;
                        function GetTargetSerial : LongWord;
                        function GetId : Word;
                        function GetXSource : Word;
                        function GetYSource : Word;
                        function GetZSource : Byte;
                        function GetXTarget : Word;
                        function GetYTarget : Word;
                        function GetZTarget : Byte;
                        function GetSpeed : Byte;
                        function GetDuration : Byte;
                        function GetUnknown2 : Word;
                        function GetNotAdjust : Byte;
                        function GetExplode : Byte;
        end;

        GetBulletinBoard = Class( UOPacket )
                public
                        function GetSubCommand : Byte;
        end;

        OpenBuyWindow = Class( UOPacket )
                public
                        function GetVendorSerial : LongWord;
                        function GetItemCount : Byte;
        end;

        UpdatePlayer = Class( UOPacket )
                public
                        function GetSerial : LongWord;
                        function GetId : Word;
                        function GetX : Word;
                        function GetY : Word;
                        function GetZ : Byte;
                        function GetDirection : Byte;
                        function GetColor : Word;
                        function GetFlag : Byte;
                        function GetHighLight : Byte;
        end;

        OpenDialogBox = Class( UOPacket )
                public
                        function GetDialogId : LongWord;
                        function GetMenuId : Word;
                        function GetQuestionLength : Byte;
        end;

        OpenPaperdoll = Class( UOPacket )
                public
                        function GetSerial : LongWord;
                        function GetText : String;
                        function GetFlag : Byte;
        end;

        GetCorpseEquipment = Class( UOPacket )
                public
                        function GetSerial : LongWord;
        end;

        GetMapMessage = Class( UOPacket )
                public
                        function GetKey : LongWord;
                        function GetGumpId : Word;
                        function GetUpperLeftX : Word;
                        function GetUpperLeftY : Word;
                        function GetLowerRightX : Word;
                        function GetLowerRightY : Word;
                        function GetWidth : Word;
                        function GetHeight : Word;
        end;

        GetBookTitlePage = Class( UOPacket )
                public
                        function GetSerial : LongWord;
                        function GetWritable : Byte;
                        function GetFlag : Byte;
                        function GetPageCount : Word;
                        function GetTitle : String;
                        function GetAuthor : String;
        end;

        GetNewBookTitlePage = Class( UOPacket )
                public
                        function GetSerial : LongWord;
                        function GetWritable : Byte;
                        function GetFlag : Byte;
                        function GetPageCount : Word;
                        function GetTitleLength : Word;
                        function GetTitle : String;
                        function GetAuthorLength : Word;
                        function GetAuthor : String;
        end;

        OpenDyeWindow = Class( UOPacket )
                public
                        function GetSerial : LongWord;
                        function GetUnknown1 : Word;
                        function GetId : Word;
        end;

        ForceMove = Class( UOPacket )
                public
                        function GetDirection : Byte;
        end;

        PlaceMulti = Class( UOPacket )
                public
                        function GetRequest : Byte;
                        function GetSerial : LongWord;
                        function GetMultiID : Word;
                        function GetXOffset : SmallInt;
                        function GetYOffset : SmallInt;
                        function GetZOffset : SmallInt;
        end;

        GetSellList = Class( UOPacket )
                public
                        function GetVendorSerial : LongWord;
                        function GetItemCount : Word;
        end;

        OpenWebBrowser = Class( UOPacket )
                public
                        function GetAdress : String;
        end;

        GetTipWindow = Class( UOPacket )
                public
                        function GetFlag : Byte;
                        function GetTipId : LongWord;
                        function GetMsgLength : Word;
                        function GetMsg : String;
        end;

        AttackResponse = Class( UOPacket )
                public
                        function GetSerial : LongWord;
        end;

        GetGumpTextEntry = Class( UOPacket )
                public
                        function GetSerial : LongWord;
                        function GetParentID : Byte;
                        function GetButtonID : Byte;
                        function GetTextLen : Word;
                        function GetText : String;
                        function GetCancel : Byte;
                        function GetStyle : Byte;
                        function GetFormat : LongWord;
                        function GetText2Len : Word;
                        function GetText2 : String;
        end;

        GetUnicodeMessage = Class( UOPacket )
                public
                        function GetSerial : LongWord;
                        function GetID : Word;
                        function GetSpeechType : Byte;
                        function GetColor : Word;
                        function GetFont : Word;
                        function GetLanguage : LongWord;
                        function GetName : String;
                        function GetMessage : String;
        end;

        DeathAction = Class( UOPacket )
                public
                        function GetSerial : LongWord;
                        function GetCorpseSerial : LongWord;
                        function GetUnkown : LongWord;
        end;

        GumpMenuDialog = Class( UOPacket )
                public
                        function GetSerial : LongWord;
                        function GetType : LongWord;
                        function GetX : LongWord;
                        function GetY : LongWord;
                        function GetCmdSectionLen : Word;
                        function GetCmdSection : String;
                        function GetTextLineNumber : Word;
        end;

        GetProfile = Class( UOPacket )
                public
                        function GetSerial : LongWord;
        end;

        GetQuestPointer = Class( UOPacket )
                public
                        function GetActive : Byte;
                        function GetX : Word;
                        function GetY : Word;
        end;

        VersionRequest = Class( UOPacket )
                public
        end;

        GetMultiCommand = Class( UOPacket )
                public
                        function GetSubCommand : Word;
        end;

        InitializeAntiFastWalk = Class( GetMultiCommand )
                public
                        function GetKey( Index : Byte ) : LongWord;
        end;

        AddAntiFastWalkKey = Class( GetMultiCommand )
                public
                        function GetKey : LongWord;
        end;

        GetCloseGump = Class( GetMultiCommand )
                public
                        function GetSerial : LongWord;
                        function GetButtonID : LongWord;
        end;

        GetCloseStatusGump = Class( GetMultiCommand )
                public
                        function GetSerial : LongWord;
        end;

        GetDisplayPopupMenu = Class( GetMultiCommand )
                public
                        function GetUnkown : Word;
                        function GetSerial : LongWord;
                        function GetEntryNumber : Byte;
        end;

        GetShowDamage = Class( GetMultiCommand )
                public
                        function GetUnkown : Word;
                        function GetSerial : LongWord;
                        function GetDamage : Byte;
        end;

        GetAttachTooltip = Class( GetMultiCommand )
                public
                        function GetSerial : LongWord;
                        function GetListID : LongWord;
        end;

        TPartyPacket = Class( GetMultiCommand )
                public
                        function GetSubSubCommand : Byte;
        end;

        TPartyAddMember = Class( TPartyPacket )
                public
                        function GetMemberCount : Byte;
                        function GetMemberSerial( Number : Byte ) : LongWord;
        end;

        TPartyRemoveMember = Class( TPartyPacket )
                public
                        function GetMemberCount : Byte;
                        function GetRemovedPlayerSerial : LongWord;
                        function GetMemberSerial( Number : Byte ) : LongWord;
        end;

        TPartyPersonalMessage = Class( TPartyPacket )
                public
                        function GetSourceSerial : LongWord;
                        function GetMessage : String;
        end;

        TPartyMessage = Class( TPartyPacket )
                public
                        function GetSourceSerial : LongWord;
                        function GetMessage : String;
        end;

        TPartyInvitation = Class( TPartyPacket )
                public
                        function GetLeaderSerial : LongWord;
        end;

        Effect = Class( UOPacket )
                public
                        function GetType : Byte;
                        function GetSourceSerial : LongWord;
                        function GetTargetSerial : LongWord;
                        function GetID : Word;
                        function GetSrcX : Word;
                        function GetSrcY : Word;
                        function GetSrcZ : ShortInt;
                        function GetTargX : Word;
                        function GetTargY : Word;
                        function GetTargZ : ShortInt;
                        function GetSpeed : Byte;
                        function GetDuration : Byte;
                        function GetUnkown1 : Word;
                        function GetFixedDirection : Byte;
                        function GetExplode : Byte;
                        function GetHue : LongWord;
                        function GetRenderMode : LongWord;
        end;

        GetClilocMessage = Class( UOPacket )
                public
                        function GetSerial : LongWord;
                        function GetId : Word;
                        function GetType : Byte;
                        function GetHue : Word;
                        function GetFont : Word;
                        function GetMessageNumber : LongWord;
                        function GetName : String;
                        function GetArguments : String;
        end;

        GetSemiVisible = Class( UOPacket )
                public
                        function GetSerial : LongWord;
                        function GetIntensity : Byte;
        end;

        ParticleEffect = Class( Effect )
                public
                        function GetEffect : Word;
                        function GetExplodeEffect : Word;
                        function GetAdditionalEffect : Word;
                        function GetTargetItemSerial : LongWord;
                        function GetLayer : Byte;
                        function GetUnkown : Word;
        end;

        GetClilocAffix = Class( UOPacket )
                public
                        function GetSerial : LongWord;
                        function GetID : Word;
                        function GetType : Byte;
                        function GetHue : Word;
                        function GetFont : Word;
                        function GetMessageID : LongWord;
                        function GetFlag : Byte;
                        function GetName : String;
        end;

        GetTooltipList = Class( UOPacket )
                public
                        function GetUnkown1 : Word;
                        function GetSerial : LongWord;
                        function GetUnkown2 : Word;
                        function GetListID : LongWord;
        end;

        GetCharAttributes = Class( UOPacket )
                public
                        function GetSerial : LongWord;
                        function GetMaxHits : Word;
                        function GetHits : Word;
                        function GetMaxMana : Word;
                        function GetMana : Word;
                        function GetMaxStamina : Word;
                        function GetStamina : Word;
        end;

        GetCharDeleteDeny = Class( UOPacket )
                public
                        function GetReason : Byte;
        end;

        GetMEInfo = Class( UOPacket )
                public
                        function GetType : Byte;
                        function ToDump : Boolean; override;
        end;

        GetCharSize = Class( GetMEInfo )
                public
                        function GetSerial : LongWord;
                        function GetBreite : Word;
                        function GetHoehe : Word;
        end;

        GetFirstMultiID = Class( GetMEInfo )
                public
                        function GetID : Word;
        end;

        GetMEProfile = Class( GetMEInfo )
                public
                        function GetSerial : LongWord;
        end;

        GetMEDisableRadar = Class( GetMEInfo )
                public
                        function RadarDisabled : Boolean;
        end;

        GetMEFightSystem = Class( GetMEInfo )
                public
                        function GetFightSystemSubSubType : Byte;
        end;

        GetMEOpenFightGump = Class( GetMEFightSystem )
                public
                        function GetTargetSerial : LongWord;
                        function IsPlayer : Byte;
                        function TrefferZone : Byte;
                        function Kampfmodus : Byte;
                        function Kampfgeschwindigkeit : Byte;
                        function Ausweichen : Byte;
                        function TrefferZoneFixed : Boolean;
                        function KampfmodusFixed : Boolean;
                        function KampfgeschwindigkeitFixed : Boolean;
                        function AusweichenFixed : Boolean;                        
        end;

        GetMEFightDoDamage = Class( GetMEFightSystem )
                public
                        function TrefferZone : Byte;
                        function Staerke : Byte;
        end;

        GetMEUpdateWounds = Class( GetMEInfo )
                public
                        function GetWound( Id : Byte ) : Byte;
        end;

        GetMEAddToInvisList = Class( GetMEInfo )
                public
                        function GetCount : Word;
                        function GetId( Index : Word ) : Word;
        end;

        GetMERemoveFromInvisList = Class( GetMEInfo )
                public
                        function GetCount : Word;
                        function GetId( Index : Word ) : Word;
        end;

        GetDirectionArrow = Class( GetMEInfo )
                public
                        function GetX : Word;
                        function GetY : Word;
        end;

        GetLoadStaticsMapFromMuls = Class( GetMEInfo )
                public
                        function LoadStaticsMap : Boolean;
        end;

        GetMapBlock = Class( GetMEInfo )
                public
                        function GetBlockID : LongWord;
                        function GetId( Index : Byte ) : Word;
                        function GetZ( Index : Byte ) : ShortInt;
        end;

        GetStaticBlock = Class( GetMEInfo )
                public
                        function GetBlockID : LongWord;
                        function GetStaticCount : Word;
                        function GetId( Index : Word ) : Word;
                        function GetX( Index : Word ) : Word;
                        function GetY( Index : Word ) : Word;
                        function GetZ( Index : Word ) : ShortInt;
                        function GetColor( Index : Word ) : Word;
        end;

        GetCharSpeed = Class( GetMEInfo )
                public
                        function GetSerial : LongWord;
                        function GetMovingSpeed : Word;
                        function GetRunningSpeed : Word;
        end;

        GetCloseContainerGump = Class( GetMEInfo )
                public
                        function GetSerial : LongWord;
        end;

        GetCharTransparency = Class( GetMEInfo )
                public
                        function GetSerial : LongWord;
                        function GetAlpha : Byte;
        end;

        GetUnicodeTextEntry = Class( UOPacket )
                public
                        function GetPlayerSerial : LongWord;
                        function GetMessageId : LongWord;
        end;

        GetConsoleTextEntry = Class( UOPacket )
                public
                        function GetObjectID : LongWord;
                        function GetPrompt : LongWord;
                        function GetRequest : LongWord;
                        function GetText : String;
        end;

implementation

//Login Denied
function LoginDenied.GetWhy : Byte;
begin
        Result := GetByte( 1 );
end;

//ShardList
function ShardList.GetFlag : Byte;
begin
        Result := GetByte( 3 );
end;

function ShardList.GetServerCount : Word;
begin
        Result := GetWord( 4 );
end;

function ShardList.GetServerIndex( Index : Byte ) : Word;
begin
        Result := GetWord( 6 + Index*40 );
end;

function ShardList.GetServerName( Index : Byte ) : String;
begin
        Result := GetAsciiString( 6 + Index*40 + 2, 32 );
end;

function ShardList.GetPercentFull( Index : Byte ) : Byte;
begin
        Result := GetByte( 6 + Index*40 + 34 );
end;

function ShardList.GetTimeZone( Index : Byte ) : Byte;
begin
        Result := GetByte( 6 + Index*40 + 35 );
end;

function ShardList.GetPingIP( Index : Byte ) : Longword;
begin
        Result := GetLongWord( 6 + Index*40 + 36 );       
end;

function GetGameServer.GetIP( Index : Byte ) : Byte;
begin
        Result := GetByte( Index+1 );
end;

function GetGameServer.GetPort : Word;
begin
        Result := GetWord( 5 );
end;

function GetGameServer.GetKey : Longword;
begin
        Result := GetLongWord( 7 );
end;

function EnableClientFeatures.GetFeatures : Word;
begin
        Result := GetWord( 1 );
end;

function CharTownList.GetCharCount : Byte;
var     I : Integer;
begin
        Result := 0;
        for I := 0 to GetByte( 3 )-1 do begin
                if GetCharName( I ) <> '' then begin
                        Inc( Result );
                end;
        end;
end;

function CharTownList.GetCharName( Index : Byte ) : String;
begin
        if Index >= GetByte( 3 ) then
                Result := ''
        else
                Result := GetAsciiString( 4 + Index*60, 30 );
end;

function CharTownList.GetPassword( Index : Byte ) : String;
begin
        if Index >= GetByte( 3 ) then
                Result := ''
        else
                Result := GetAsciiString( 34 + Index*60, 30 );
end;

function CharTownList.GetTownCount : Byte;
begin
        Result := GetByte( 304 );
end;

function CharTownList.GetTownIndex( Index : Byte ) : Byte;
begin
        if Index >= GetTownCount then
                Result := 0
        else
                Result := GetByte( 305 + Index*63 );
end;

function CharTownList.GetGeneralName( Index : Byte ) : String;
begin
        if Index >= GetTownCount then
                Result := ''
        else
                Result := GetAsciiString( 306 + Index*63, 31 );
end;

function CharTownList.GetExactName( Index : Byte ) : String;
begin
        if Index >= GetTownCount then
                Result := ''
        else
                Result := GetAsciiString( 337 + Index*63, 31 );
end;

function CharTownList.GetFlags : Longword;
begin
        Result := GetLongWord( 305 + GetTownCount*63 );
end;

function GetViewRange.GetVisRange : Byte;
begin
        Result := GetByte( 1 );
end;

function GetCharLocation.getPlayerID : Longword;
begin
        Result := GetLongWord( 1 );
end;

function GetCharLocation.getUnknown1 : Longword;
begin
        Result := GetLongWord( 5 );
end;

function GetCharLocation.getBody : Word;
begin
        Result := GetWord( 9 );
end;

function GetCharLocation.getX : Word;
begin
        Result := GetWord( 11 );
end;

function GetCharLocation.getY : Word;
begin
        Result := GetWord( 13 );
end;

function GetCharLocation.getZ : Word;
begin
        Result := GetWord( 15 );
end;

function GetCharLocation.getDirection : Byte;
begin
        Result := GetByte( 17 );
end;

function GetCharLocation.getUnknown2 : Word;
begin
        Result := GetWord( 18 );
end;

function GetCharLocation.getUnknown3 : Longword;
begin
        Result := GetLongWord( 20 );
end;

function GetCharLocation.getUnknown4 : Longword;
begin
        Result := GetLongWord( 24 );
end;

function GetCharLocation.getFlags : Byte;
begin
        Result := GetByte( 28 );
end;

function GetCharLocation.getHighLight : Byte;
begin
        Result := GetByte( 29 );
end;

function GetCharLocation.getUnknown5 : Longword;
begin
        Result := GetLongWord( 30 );
end;

function GetCharLocation.getUnknown6 : Word;
begin
        Result := GetWord( 34 );
end;

function GetCharLocation.getUnknown7 : Byte;
begin
        Result := GetByte( 36 );
end;

function GetSeason.GetSeason : Byte;
begin
        Result := GetByte( 1 );
end;

function GetSeason.SeasonChanged : Byte;
begin
        Result := GetByte( 2 );
end;

function DrawGamePlayer.getSerial : Longword;
begin
        Result := GetLongWord( 1 );
end;

function DrawGamePlayer.getBody : Word;
begin
        Result := GetWord( 5 );
end;

function DrawGamePlayer.getUnknown1 : Byte;
begin
        Result := GetByte( 7 );
end;

function DrawGamePlayer.getSkin : Word;
begin
        Result := GetWord( 8 );
end;

function DrawGamePlayer.getFlag : Byte;
begin
        Result := GetByte( 10 );
end;

function DrawGamePlayer.getX : Word;
begin
        Result := GetWord( 11 );
end;

function DrawGamePlayer.getY : Word;
begin
        Result := GetWord( 13 );
end;

function DrawGamePlayer.getUnknown2 : Word;
begin
        Result := GetWord( 15 );
end;

function DrawGamePlayer.getDirection : Byte;
begin
        Result := GetByte( 17 );
end;

function DrawGamePlayer.getZ : Byte;
begin
        Result := GetByte( 18 );
end;

function GetLightLevel.GetLevel : Byte;
begin
        Result := GetByte( 1 );
end;

function GetSubServer.getX : Word;
begin
        Result := GetWord( 1 );
end;

function GetSubServer.getY : Word;
begin
        Result := GetWord( 3 );
end;

function GetSubServer.getZ : Word;
begin
        Result := GetWord( 5 );
end;

function GetSubServer.getBoundX : Word;
begin
        Result := GetWord( 8 );
end;

function GetSubServer.getBoundY : Word;
begin
        Result := GetWord( 10 );
end;

function GetSubServer.getWidth : Word;
begin
        Result := GetWord( 12 );
end;

function GetSubServer.getHeight : Word;
begin
        Result := GetWord( 14 );
end;

function DrawObject.getSerial : LongWord;
begin
        Result := GetLongWord( 3 );
end;

function DrawObject.getModel : Word;
begin
        Result := GetWord( 7 );
end;

function DrawObject.getX : Word;
begin
        Result := GetWord( 9 );
end;

function DrawObject.getY : Word;
begin
        Result := GetWord( 11 );
end;

function DrawObject.getZ : Byte;
begin
        Result := GetByte( 13 );
end;

function DrawObject.getDirection : Byte;
begin
        Result := GetByte( 14 );
end;

function DrawObject.getColor : Word;
begin
        Result := GetWord( 15 );
end;

function DrawObject.getFlag : Byte;
begin
        Result := GetByte( 17 );
end;

function DrawObject.getHighLight : Byte;
begin
        Result := GetByte( 18 );
end;

function GetWornItem.getSerial : LongWord;
begin
        Result := GetLongWord( 1 );
end;

function GetWornItem.getModel : Word;
begin
        Result := GetWord( 5 );
end;

function GetWornItem.getUnkown1 : Byte;
begin
        Result := GetByte( 7 );
end;

function GetWornItem.getLayer : Byte;
begin
        Result := GetByte( 8 );
end;

function GetWornItem.getWearer : LongWord;
begin
        Result := GetLongWord( 9 );
end;

function GetWornItem.getColor : Word;
begin
        Result := GetWord( 13 );
end;

function UpdateHealth.getSerial : LongWord;
begin
        Result := GetLongWord( 1 );
end;

function UpdateHealth.getMaxHealth : Word;
begin
        Result := GetWord( 5 );
end;

function UpdateHealth.getCurrentHealth : Word;
begin
        Result := GetWord( 7 );
end;

function UpdateMana.getSerial : LongWord;
begin
        Result := GetLongWord( 1 );
end;

function UpdateMana.getMaxMana : Word;
begin
        Result := GetWord( 5 );
end;

function UpdateMana.getCurrentMana : Word;
begin
        Result := GetWord( 7 );
end;

function UpdateStamina.getSerial : LongWord;
begin
        Result := GetLongWord( 1 );
end;

function UpdateStamina.getMaxStamina : Word;
begin
        Result := GetWord( 5 );
end;

function UpdateStamina.getCurrentStamina : Word;
begin
        Result := GetWord( 7 );
end;

function GetChangeWarMode.getFlag : Byte;
begin
        Result := GetByte( 1 );
end;

function GetTime.getHour : Byte;
begin
        Result := GetByte( 1 );
end;

function GetTime.getMinute : Byte;
begin
        Result := GetByte( 2 );
end;

function GetTime.getSecond : Byte;
begin
        Result := GetByte( 3 );
end;

function StatWindow.getSerial : Longword;
begin
        Result := GetLongWord( 3 );
end;

function StatWindow.getName : String;
begin
        Result := GetAsciiString( 7, 30 );
end;

function StatWindow.getCurrentHealth : Word;
begin
        Result := GetWord( 37 );
end;

function StatWindow.getMaxHealth : Word;
begin
        Result := GetWord( 39 );
end;

function StatWindow.getNameChangeFlag : Byte;
begin
        Result := GetByte( 41 );
end;

function StatWindow.getFlag : Byte;
begin
        Result := GetByte( 42 );
end;

function StatWindow.getSex : Byte;
begin
        Result := GetByte( 43 );
end;

function StatWindow.getStr : Word;
begin
        Result := GetWord( 44 );
end;

function StatWindow.getDex : Word;
begin
        Result := GetWord( 46 );
end;

function StatWindow.getInt : Word;
begin
        Result := GetWord( 48 );
end;

function StatWindow.getCurrentStamina : Word;
begin
        Result := GetWord( 50 );
end;

function StatWindow.getMaxStamina : Word;
begin
        Result := GetWord( 52 );
end;

function StatWindow.getCurrentMana : Word;
begin
        Result := GetWord( 54 );
end;

function StatWindow.getMaxMana : Word;
begin
        Result := GetWord( 56 );
end;

function StatWindow.getGold : LongWord;
begin
        Result := GetLongWord( 58 );
end;

function StatWindow.getArmorClass : Word;
begin
        Result := GetWord( 62 );
end;

function StatWindow.getWeight : Word;
begin
        Result := GetWord( 64 );
end;

function StatWindow.getStatCap : Word;
begin
        Result := GetWord( 66 );
end;

function StatWindow.getCurrentPets : Byte;
begin
        Result := GetByte( 68 );
end;

function StatWindow.getMaxPets : Byte;
begin
        Result := GetByte( 69 );
end;

function StatWindow.getResistFire : Word;
begin
        Result := GetWord( 70 );
end;

function StatWindow.getResistCold : Word;
begin
        Result := GetWord( 72 );
end;

function StatWindow.getResistPoison : Word;
begin
        Result := GetWord( 74 );
end;

function StatWindow.getResistEnergy : Word;
begin
        Result := GetWord( 76 );
end;

function StatWindow.getLuck : Word;
begin
        Result := GetWord( 78 );
end;

function StatWindow.getMaxDamage : Word;
begin
        Result := GetWord( 80 );
end;

function StatWindow.getMinDamage : Word;
begin
        Result := GetWord( 82 );
end;

function StatWindow.getUnkown : LongWord;
begin
        Result := GetWord( 84 );
end;

function StatWindow.getMEAusdauer : Word;
begin
        Result := GetWord( 43 );
end;

function StatWindow.getMEAusdauerMax : Word;
begin
        Result := GetWord( 45 );
end;

function StatWindow.getMEXP : Word;
begin
        Result := GetWord( 47 );
end;

function StatWindow.getMELevel : Byte;
begin
        Result := GetByte( 49 );
end;

function StatWindow.getMEGewicht : Word;
begin
        Result := GetWord( 50 );
end;

function StatWindow.getMEGewichtMax : Word;
begin
        Result := GetWord( 52 );
end;

function StatWindow.getMEVolumen : Word;
begin
        Result := GetWord( 54 );
end;

function StatWindow.getMEVolumenMax : Word;
begin
        Result := GetWord( 56 );
end;

function StatWindow.getMEGold : LongWord;
begin
        Result := GetLongWord( 58 );
end;

function GetItem.getSerial : LongWord;
begin
        Result := GetLongWord( 3 );
end;

function GetItem.getId : Word;
begin
        Result := GetWord( 7 );
end;

function GetSpeech.getSerial : LongWord;
begin
        Result := GetLongWord( 3 );
end;

function GetSpeech.getId : Word;
begin
        Result := GetWord( 7 );
end;

function GetSpeech.getSpeechType : Byte;
begin
        Result := GetByte( 9 );
end;

function GetSpeech.getTextColor : Word;
begin
        Result := GetWord( 10 );
end;

function GetSpeech.getFont : Word;
begin
        Result := GetWord( 12 );
end;

function GetSpeech.getName : String;
begin
        Result := GetAsciiString( 14, 30 );
end;

function GetSpeech.getMessage : String;
begin
        Result := GetAsciiString( 44, GetLength-44 );
end;

function DeleteObject.getSerial : LongWord;
begin
        Result := GetLongWord( 1 );
end;

function DenyMove.getSequence : Byte;
begin
        Result := GetByte( 1 );
end;

function DenyMove.getX : Word;
begin
        Result := GetWord( 2 );
end;

function DenyMove.getY : Word;
begin
        Result := GetWord( 4 );
end;

function DenyMove.getDirection : Byte;
begin
        Result := GetByte( 6 );
end;

function DenyMove.getZ : Byte;
begin
        Result := GetByte( 7 );
end;

function AcceptMove.getSequence : Byte;
begin
        Result := GetByte( 1 );
end;

function AcceptMove.getHightLight : Byte;
begin
        Result := GetByte( 2 );
end;

function OpenContainer.GetSerial : Longword;
begin
        Result := GetLongWord( 1 );
end;

function OpenContainer.GumpId : Word;
begin
        Result := GetWord( 5 );
end;

function AddContainerItem.GetItemSerial : LongWord;
begin
        Result := GetLongWord( 1 );
end;

function AddContainerItem.GetId : Word;
begin
        Result := GetWord( 5 );
end;

function AddContainerItem.GetUnknown1 : Byte;
begin
        Result := GetByte( 7 );
end;

function AddContainerItem.GetAmount : Word;
begin
        Result := GetWord( 8 );
end;

function AddContainerItem.GetX : Word;
begin
        Result := GetWord( 10 );
end;

function AddContainerItem.GetY : Word;
begin
        Result := GetWord( 12 );
end;

function AddContainerItem.GetContainerSerial : LongWord;
begin
        Result := GetLongWord( 14 );
end;

function AddContainerItem.GetColor : Word;
begin
        Result := GetWord( 18 );
end;

function KickPlayer.GetSerial : LongWord;
begin
        Result := GetLongWord( 1 );
end;

function RejectItemMoveRequest.GetReason : Byte;
begin
        Result := GetByte( 1 );
end;

function ClearSquare.GetX : Word;
begin
        Result := GetWord( 1 );
end;

function ClearSquare.GetY : Word;
begin
        Result := GetWord( 3 );
end;

function ShowBattle.GetUnknown1 : Byte;
begin
        Result := GetByte( 1 );
end;

function ShowBattle.GetAttackerSerial : LongWord;
begin
        Result := GetLongWord( 2 );
end;

function ShowBattle.GetDefenderSerial : LongWord;
begin
        Result := GetLongWord( 6 );
end;

function PauseClient.GetResume : Byte;
begin
        Result := GetByte( 1 );
end;

function GetSkills.GetSubType : Byte;
begin
        Result := GetByte( 3 );
end;

function GetBuyItems.GetSerial : LongWord;
begin
        Result := GetLongWord( 3 );
end;

function GetBuyItems.GetFlag : Byte;
begin
        Result := GetByte( 7 );
end;

function GetItemsInContainer.GetItemCount : Word;
begin
        Result := GetWord( 3 );
end;

function GetItemsInContainer.GetItemSerial( Index : Word ) : LongWord;
begin
        Result := GetLongWord( 5 + Index*19 );
end;

function GetItemsInContainer.GetItemID( Index : Word ) : Word;
begin
        Result := GetWord( 5 + Index*19 + 4 );
end;

function GetItemsInContainer.GetUnkown1( Index : Word ) : Byte;
begin
        Result := GetByte( 5 + Index*19 + 6 );
end;

function GetItemsInContainer.GetAmount( Index : Word ) : Word;
begin
        Result := GetWord( 5 + Index*19 + 7 );
end;

function GetItemsInContainer.GetX( Index : Word ) : Word;
begin
        Result := GetWord( 5 + Index*19 + 9 );
end;

function GetItemsInContainer.GetY( Index : Word ) : Word;
begin
        Result := GetWord( 5 + Index*19 + 11 );
end;

function GetItemsInContainer.GetContainerSerial( Index : Word ) : LongWord;
begin
        Result := GetLongWord( 5 + Index*19 + 13 );
end;

function GetItemsInContainer.GetColor( Index : Word ) : Word;
begin
        Result := GetWord( 5 + Index*19 + 17 );
end;

function GetGlow.GetSerial : LongWord;
begin
        Result := GetLongWord( 1 );
end;

function GetGlow.GetLevel : Byte;
begin
        Result := GetByte( 5 );
end;

function IdleWarning.GetReason : Byte;
begin
        Result := GetByte( 1 );
end;

function PlaySound.GetMode : Byte;
begin
        Result := GetByte( 1 );
end;

function PlaySound.GetSound : Word;
begin
        Result := GetWord( 2 );
end;

function PlaySound.Unkown3 : Word;
begin
        Result := GetWord( 4 );
end;

function PlaySound.GetX : Word;
begin
        Result := GetWord( 6 );
end;

function PlaySound.GetY : Word;
begin
        Result := GetWord( 8 );
end;

function PlaySound.GetZ : Word;
begin
        Result := GetWord( 10 );
end;

function GetWeather.GetType : Byte;
begin
        Result := GetByte( 1 );
end;

function GetWeather.GetAmount : Byte;
begin
        Result := GetByte( 2 );
end;

function GetWeather.GetTemperature : Byte;
begin
        Result := GetByte( 3 );
end;

function GetBook.GetSerial : LongWord;
begin
        Result := GetLongWord( 3 );
end;

function GetBook.GetPageCout : Word;
begin
        Result := GetWord( 7 );
end;

function CreateTargetCursor.GetType : Byte;
begin
        Result := GetByte( 1 );
end;

function CreateTargetCursor.GetCursorID : LongWord;
begin
        Result := GetLongWord( 2 );
end;

function CreateTargetCursor.GetCursorType : Byte;
begin
        Result := GetByte( 6 );
end;

function PlayMidi.GetId : Word;
begin
        Result := GetWord( 1 );
end;

function DoCharAnimation.GetSerial : LongWord;
begin
        Result := GetLongWord( 1 );
end;

function DoCharAnimation.GetAnimationID : Word;
begin
        Result := GetWord( 5 );
end;

function DoCharAnimation.GetUnknown1 : Byte;
begin
        Result := GetByte( 7 );
end;

function DoCharAnimation.GetStartFrame : Byte;
begin
        Result := GetByte( 8 );
end;

function DoCharAnimation.GetRepeat : Word;
begin
        Result := GetWord( 9 );
end;

function DoCharAnimation.GetBackward : Byte;
begin
        Result := GetByte( 11 );
end;

function DoCharAnimation.GetRepeatFlag : Byte;
begin
        Result := GetByte( 12 );
end;

function DoCharAnimation.GetFrameDelay : Byte;
begin
        Result := GetByte( 13 );
end;

function GetSecureTrading.GetAction : Byte;
begin
        Result := GetByte( 3 );
end;

function GetSecureTrading.GetSerial1 : LongWord;
begin
        if getLength >= 8 then
                Result := GetLongWord( 4 )
        else
                Result := 0;
end;

function GetSecureTrading.GetSerial2 : LongWord;
begin
        if getLength >= 12 then
                Result := GetLongWord( 8 )
        else
                Result := 0;
end;

function GetSecureTrading.GetSerial3 : LongWord;
begin
        if getLength >= 16 then
                Result := GetLongWord( 12 )
        else
                Result := 0;
end;

function GetSecureTrading.NameFollowing : Byte;
begin
        if getLength >= 17 then
                Result := GetByte( 16 )
        else
                Result := 0;
end;

function GetSecureTrading.GetName : String;
begin
        Result := GetAsciiString( 17, GetLength-17 );
end;

function OldEffect.GetType : Byte;
begin
        Result := GetByte( 1 );
end;

function OldEffect.GetSourceSerial : LongWord;
begin
        Result := GetLongWord( 2 );
end;

function OldEffect.GetTargetSerial : LongWord;
begin
        Result := GetLongWord( 6 );
end;

function OldEffect.GetId : Word;
begin
        Result := GetWord( 10 );
end;

function OldEffect.GetXSource : Word;
begin
        Result := GetWord( 12 );
end;

function OldEffect.GetYSource : Word;
begin
        Result := GetWord( 14);
end;

function OldEffect.GetZSource : Byte;
begin
        Result := GetByte( 16 );
end;

function OldEffect.GetXTarget : Word;
begin
        Result := GetWord( 17 );
end;

function OldEffect.GetYTarget : Word;
begin
        Result := GetWord( 19 );
end;

function OldEffect.GetZTarget : Byte;
begin
        Result := GetByte( 21 );
end;

function OldEffect.GetSpeed : Byte;
begin
        Result := GetByte( 22 );
end;

function OldEffect.GetDuration : Byte;
begin
        Result := GetByte( 23 );
end;

function OldEffect.GetUnknown2 : Word;
begin
        Result := GetWord( 24 );
end;

function OldEffect.GetNotAdjust : Byte;
begin
        Result := GetByte( 26 );
end;

function OldEffect.GetExplode : Byte;
begin
        Result := GetByte( 27 );
end;

function GetBulletinBoard.GetSubCommand : Byte;
begin
        Result := GetByte( 3 );
end;

function OpenBuyWindow.GetVendorSerial : LongWord;
begin
        Result := GetLongWord( 3 );
end;

function OpenBuyWindow.GetItemCount : Byte;
begin
        Result := GetByte( 7 );
end;

function UpdatePlayer.GetSerial : LongWord;
begin
        Result := GetLongWord( 1 );
end;

function UpdatePlayer.GetId : Word;
begin
        Result := GetWord( 5 );
end;

function UpdatePlayer.GetX : Word;
begin
        Result := GetWord( 7 );
end;

function UpdatePlayer.GetY : Word;
begin
        Result := GetWord( 9 );
end;

function UpdatePlayer.GetZ : Byte;
begin
        Result := GetByte( 11 );
end;

function UpdatePlayer.GetDirection : Byte;
begin
        Result := GetByte( 12 );
end;

function UpdatePlayer.GetColor : Word;
begin
        Result := GetWord( 13 );
end;

function UpdatePlayer.GetFlag : Byte;
begin
        Result := GetByte( 15 );
end;

function UpdatePlayer.GetHighLight : Byte;
begin
        Result := GetByte( 16 );
end;

function OpenDialogBox.GetDialogId : LongWord;
begin
        Result := GetLongWord( 3 );
end;

function OpenDialogBox.GetMenuId : Word;
begin
        Result := GetWord( 7 );
end;

function OpenDialogBox.GetQuestionLength : Byte;
begin
        Result := GetByte( 9 );
end;

function UpdateCharList.GetCount : Byte;
var     I : Integer;
begin
        Result := 0;
        for I := 0 to GetByte( 3 )-1 do begin
                if GetName( I ) <> '' then begin
                        Inc( Result );
                end;
        end;
end;

function UpdateCharList.GetName( Index : Byte ) : String;
begin
        Result := GetAsciiString( 4 + Index*60, 30 );
end;

function UpdateCharList.GetPassword( Index : Byte ) : String;
begin
        Result := GetAsciiString( 4 + Index*60 + 30, 30 );
end;

function OpenPaperdoll.GetSerial : LongWord;
begin
        Result := GetLongWord( 1 );
end;

function OpenPaperdoll.GetText : String;
begin
        Result := GetAsciiString( 5, 60 );
end;

function OpenPaperdoll.GetFlag : Byte;
begin
        Result := GetByte( 65 );
end;

function GetCorpseEquipment.GetSerial : LongWord;
begin
        Result := GetLongWord( 3 );
end;

function GetMapMessage.GetKey : LongWord;
begin
        Result := GetLongWord( 1 );
end;

function GetMapMessage.GetGumpId : Word;
begin
        Result := GetWord( 5 );
end;

function GetMapMessage.GetUpperLeftX : Word;
begin
        Result := GetWord( 7 );
end;

function GetMapMessage.GetUpperLeftY : Word;
begin
        Result := GetWord( 9 );
end;

function GetMapMessage.GetLowerRightX : Word;
begin
        Result := GetWord( 11 );
end;

function GetMapMessage.GetLowerRightY : Word;
begin
        Result := GetWord( 13 );
end;

function GetMapMessage.GetWidth : Word;
begin
        Result := GetWord( 15 );
end;

function GetMapMessage.GetHeight : Word;
begin
        Result := GetWord( 17 );
end;

function GetBookTitlePage.GetSerial : LongWord;
begin
        Result := GetLongWord( 1 );
end;

function GetBookTitlePage.GetWritable : Byte;
begin
        Result := GetByte( 5 );
end;

function GetBookTitlePage.GetFlag : Byte;
begin
        Result := GetByte( 6 );
end;

function GetBookTitlePage.GetPageCount : Word;
begin
        Result := GetWord( 7 );
end;

function GetBookTitlePage.GetTitle : String;
begin
        Result := GetAsciiString( 9, 60 );
end;

function GetBookTitlePage.GetAuthor : String;
begin
        Result := GetAsciiString( 69, 30 );
end;

function GetNewBookTitlePage.GetSerial : LongWord;
begin
        Result := GetLongWord( 3 );
end;

function GetNewBookTitlePage.GetWritable : Byte;
begin
        Result := GetByte( 7 );
end;

function GetNewBookTitlePage.GetFlag : Byte;
begin
        Result := GetByte( 8 );
end;

function GetNewBookTitlePage.GetPageCount : Word;
begin
        Result := GetWord( 9 );
end;

function GetNewBookTitlePage.GetTitleLength : Word;
begin
        Result := GetWord( 11 );
end;

function GetNewBookTitlePage.GetTitle : String;
begin
        Result := GetAsciiString( 13, GetTitleLength );
end;

function GetNewBookTitlePage.GetAuthorLength : Word;
begin
        Result := GetWord( 13 + GetTitleLength );
end;

function GetNewBookTitlePage.GetAuthor : String;
begin
        Result := GetAsciiString( 15 + GetTitleLength, GetAuthorLength );
end;

function OpenDyeWindow.GetSerial : LongWord;
begin
        Result := GetLongWord( 1 );
end;

function OpenDyeWindow.GetUnknown1 : Word;
begin
        Result := GetWord( 5 );
end;

function OpenDyeWindow.GetId : Word;
begin
        Result := GetWord( 7 );
end;

function ForceMove.GetDirection : Byte;
begin
        Result := GetByte( 1 );
end;

function PlaceMulti.GetRequest : Byte;
begin
        Result := GetByte( 1 );
end;

function PlaceMulti.GetSerial : LongWord;
begin
        Result := GetLongWord( 2 );
end;

function PlaceMulti.GetMultiID : Word;
begin
        Result := GetWord( 18 );
end;

function PlaceMulti.GetXOffset : SmallInt;
begin
        Result := GetWord( 20 );
end;

function PlaceMulti.GetYOffset : SmallInt;
begin
        Result := GetWord( 22 );
end;

function PlaceMulti.GetZOffset : SmallInt;
begin
        Result := GetWord( 24 );
end;

function GetSellList.GetVendorSerial : LongWord;
begin
        Result := GetLongWord( 3 );
end;

function GetSellList.GetItemCount : Word;
begin
        Result := GetWord( 7 );
end;

function OpenWebBrowser.GetAdress : String;
begin
        Result := GetAsciiString( 3, GetLength-3 );
end;

function GetTipWindow.GetFlag : Byte;
begin
        Result := GetByte( 3 );
end;

function GetTipWindow.GetTipId : LongWord;
begin
        Result := GetLongWord( 4 );
end;

function GetTipWindow.GetMsgLength : Word;
begin
        Result := GetWord( 8 );
end;

function GetTipWindow.GetMsg : String;
begin
        Result := GetAsciiString( 10, GetMsgLength );
end;

function AttackResponse.GetSerial : LongWord;
begin
        Result := GetLongWord( 1 );
end;

function GetGumpTextEntry.GetSerial : LongWord;
begin
        Result := GetLongWord( 3 );
end;

function GetGumpTextEntry.GetParentID : Byte;
begin
        Result := GetByte( 7 );
end;

function GetGumpTextEntry.GetButtonID : Byte;
begin
        Result := GetByte( 8 );
end;

function GetGumpTextEntry.GetTextLen : Word;
begin
        Result := GetWord( 9 );
end;

function GetGumpTextEntry.GetText : String;
begin
        Result := GetAsciiString( 11, GetTextLen );
end;

function GetGumpTextEntry.GetCancel : Byte;
begin
        Result := GetByte( 11 + GetTextLen );
end;

function GetGumpTextEntry.GetStyle : Byte;
begin
        Result := GetByte( 12 + GetTextLen );
end;

function GetGumpTextEntry.GetFormat : LongWord;
begin
        Result := GetLongWord( 13 + GetTextLen );
end;

function GetGumpTextEntry.GetText2Len : Word;
begin
        Result := GetWord( 17 + GetTextLen );
end;

function GetGumpTextEntry.GetText2 : String;
begin
        Result := GetAsciiString( 19 + GetTextLen, GetText2Len );
end;

function GetUnicodeMessage.GetSerial : LongWord;
begin
        Result := GetLongWord( 3 );
end;

function GetUnicodeMessage.GetID : Word;
begin
        Result := GetWord( 7 );
end;

function GetUnicodeMessage.GetSpeechType : Byte;
begin
        Result := GetByte( 9 );
end;

function GetUnicodeMessage.GetColor : Word;
begin
        Result := GetWord( 10 );
end;

function GetUnicodeMessage.GetFont : Word;
begin
        Result := GetWord( 12 );
end;

function GetUnicodeMessage.GetLanguage : LongWord;
begin
        Result := GetLongWord( 14 );
end;

function GetUnicodeMessage.GetName : String;
begin
        Result := GetAsciiString( 18, 30 );
end;

function GetUnicodeMessage.GetMessage : String;
begin
        Result := GetUnicodeString( 48, GetLength-48 );
end;

function DeathAction.GetSerial : LongWord;
begin
        Result := GetLongWord( 1 );
end;

function DeathAction.GetCorpseSerial : LongWord;
begin
        Result := GetLongWord( 5 );
end;

function DeathAction.GetUnkown : LongWord;
begin
        Result := GetLongWord( 9 );
end;

function GumpMenuDialog.GetSerial : LongWord;
begin
        Result := GetLongWord( 3 );
end;

function GumpMenuDialog.GetType : LongWord;
begin
        Result := GetLongWord( 7 );
end;

function GumpMenuDialog.GetX : LongWord;
begin
        Result := GetLongWord( 11 );
end;

function GumpMenuDialog.GetY : LongWord;
begin
        Result := GetLongWord( 15 );
end;

function GumpMenuDialog.GetCmdSectionLen : Word;
begin
        Result := GetWord( 19 );
end;

function GumpMenuDialog.GetCmdSection : String;
begin
        Result := GetAsciiString( 21, GetCmdSectionLen );
end;

function GumpMenuDialog.GetTextLineNumber : Word;
begin
        Result := GetWord( 21 + GetCmdSectionLen );
end;

function GetProfile.GetSerial : LongWord;
begin
        Result := GetLongWord( 3 );
end;

function GetQuestPointer.GetActive : Byte;
begin
        Result := GetByte( 1 );
end;

function GetQuestPointer.GetX : Word;
begin
        Result := GetWord( 2 );
end;

function GetQuestPointer.GetY : Word;
begin
        Result := GetWord( 4 );
end;

function GetMultiCommand.GetSubCommand : Word;
begin
        Result := GetWord( 3 );
end;

function InitializeAntiFastWalk.GetKey( Index : Byte ) : LongWord;
begin
        Result := GetLongWord( 5 + Index*4 );
end;

function AddAntiFastWalkKey.GetKey : LongWord;
begin
        Result := GetLongWord( 5 );
end;

function GetCloseGump.GetSerial : LongWord;
begin
        Result := GetLongWord( 5 );
end;

function GetCloseGump.GetButtonID : LongWord;
begin
        Result := GetLongWord( 9 );
end;

function GetCloseStatusGump.GetSerial : LongWord;
begin
        Result := GetLongWord( 5 );
end;

function GetDisplayPopupMenu.GetUnkown : Word;
begin
        Result := GetWord( 5 );
end;

function GetDisplayPopupMenu.GetSerial : LongWord;
begin
        Result := GetLongWord( 7 );
end;

function GetDisplayPopupMenu.GetEntryNumber : Byte;
begin
        Result := GetByte( 11 );
end;

function GetShowDamage.GetUnkown : Word;
begin
        Result := GetWord( 5 );
end;

function GetShowDamage.GetSerial : LongWord;
begin
        Result := GetLongWord( 7 );
end;

function GetShowDamage.GetDamage : Byte;
begin
        Result := GetByte( 11 );
end;

function Effect.GetType : Byte;
begin
        Result := GetByte( 1 );
end;

function Effect.GetSourceSerial : LongWord;
begin
        Result := GetLongWord( 2 );
end;

function Effect.GetTargetSerial : LongWord;
begin
        Result := GetLongWord( 6 );
end;

function Effect.GetID : Word;
begin
        Result := GetWord( 10 );
end;

function Effect.GetSrcX : Word;
begin
        Result := GetWord( 12 );
end;

function Effect.GetSrcY : Word;
begin
        Result := GetWord( 14 );
end;

function Effect.GetSrcZ : ShortInt;
begin
        Result := GetByte( 16 );
end;

function Effect.GetTargX : Word;
begin
        Result := GetWord( 17 );
end;

function Effect.GetTargY : Word;
begin
        Result := GetWord( 19 );
end;

function Effect.GetTargZ : ShortInt;
begin
        Result := GetByte( 21 );
end;

function Effect.GetSpeed : Byte;
begin
        Result := GetByte( 22 );
end;

function Effect.GetDuration : Byte;
begin
        Result := GetByte( 23 );
end;

function Effect.GetUnkown1 : Word;
begin
        Result := GetWord( 24 );
end;

function Effect.GetFixedDirection : Byte;
begin
        Result := GetByte( 26 );
end;

function Effect.GetExplode : Byte;
begin
        Result := GetByte( 27 );
end;

function Effect.GetHue : LongWord;
begin
        Result := GetLongWord( 28 );
end;

function Effect.GetRenderMode : LongWord;
begin
        Result := GetLongWord( 32 );
end;

function GetClilocMessage.GetSerial : LongWord;
begin
        Result := GetLongWord( 3 );
end;

function GetClilocMessage.GetId : Word;
begin
        Result := GetWord( 7 );
end;

function GetClilocMessage.GetType : Byte;
begin
        Result := GetByte( 9 );
end;

function GetClilocMessage.GetHue : Word;
begin
        Result := GetWord( 10 );
end;

function GetClilocMessage.GetFont : Word;
begin
        Result := GetWord( 12 );
end;

function GetClilocMessage.GetMessageNumber : LongWord;
begin
        Result := GetLongWord( 14 );
end;

function GetClilocMessage.GetName : String;
begin
        Result := GetAsciiString( 18, 30 );
end;

function GetClilocMessage.GetArguments : String;
begin
        Result := GetUnicodeString( 47, GetLength-47 );
end;

function GetSemiVisible.GetSerial : LongWord;
begin
        Result := GetLongWord( 1 );
end;

function GetSemiVisible.GetIntensity : Byte;
begin
        Result := GetByte( 5 );
end;

function ParticleEffect.GetEffect : Word;
begin
        Result := GetWord( 36 );
end;

function ParticleEffect.GetExplodeEffect : Word;
begin
        Result := GetWord( 38 );
end;

function ParticleEffect.GetAdditionalEffect : Word;
begin
        Result := GetWord( 40 );
end;

function ParticleEffect.GetTargetItemSerial : LongWord;
begin
        Result := GetLongWord( 42 );
end;

function ParticleEffect.GetLayer : Byte;
begin
        Result := GetByte( 46 );
end;

function ParticleEffect.GetUnkown : Word;
begin
        Result := GetWord( 47 );
end;

function GetClilocAffix.GetSerial : LongWord;
begin
        Result := GetLongWord( 3 );
end;

function GetClilocAffix.GetID : Word;
begin
        Result := GetWord( 7 );
end;

function GetClilocAffix.GetType : Byte;
begin
        Result := GetByte( 9 );
end;

function GetClilocAffix.GetHue : Word;
begin
        Result := GetWord( 10 );
end;

function GetClilocAffix.GetFont : Word;
begin
        Result := GetWord( 12 );
end;

function GetClilocAffix.GetMessageID : LongWord;
begin
        Result := GetLongWord( 14 );
end;

function GetClilocAffix.GetFlag : Byte;
begin
        Result := GetByte( 18 );
end;

function GetClilocAffix.GetName : String;
begin
        Result := GetAsciiString( 19, 30 );
end;

function GetTooltipList.GetUnkown1 : Word;
begin
        Result := GetWord( 3 );
end;

function GetTooltipList.GetSerial : LongWord;
begin
        Result := GetLongWord( 5 );
end;

function GetTooltipList.GetUnkown2 : Word;
begin
        Result := GetWord( 9 );
end;

function GetTooltipList.GetListID : LongWord;
begin
        Result := GetLongWord( 11 );
end;

function GetAttachTooltip.GetSerial : LongWord;
begin
        Result := GetLongWord( 5 );
end;

function TPartyPacket.GetSubSubCommand : Byte;
begin
        Result := GetByte( 5 );
end;

function TPartyAddMember.GetMemberCount : Byte;
begin
        Result := GetByte( 6 );
end;

function TPartyAddMember.GetMemberSerial( Number : Byte ) : LongWord;
begin
        Result := GetLongWord( 7 + 4*Number );
end;

function TPartyRemoveMember.GetMemberCount : Byte;
begin
        Result := GetByte( 6 );
end;

function TPartyRemoveMember.GetRemovedPlayerSerial : LongWord;
begin
        Result := GetLongWord( 7 );
end;

function TPartyRemoveMember.GetMemberSerial( Number : Byte ) : LongWord;
begin
        Result := GetLongWord( 11 + Number*4 );
end;

function TPartyPersonalMessage.GetSourceSerial : LongWord;
begin
        Result := GetLongWord( 6 );
end;

function TPartyPersonalMessage.GetMessage : String;
begin
        Result := GetUnicodeString( 10, GetLength-10 );
end;

function TPartyMessage.GetSourceSerial : LongWord;
begin
        Result := GetLongWord( 6 );
end;

function TPartyMessage.GetMessage : String;
begin
        Result := GetUnicodeString( 10, GetLength-10 );
end;

function TPartyInvitation.GetLeaderSerial : LongWord;
begin
        Result := GetLongWord( 6 );
end;

function GetAttachTooltip.GetListID : LongWord;
begin
        Result := GetLongWord( 9 );
end;

function GetCharAttributes.GetSerial : LongWord;
begin
        Result := GetLongWord( 1 );
end;

function GetCharAttributes.GetMaxHits : Word;
begin
        Result := GetWord( 5 );
end;

function GetCharAttributes.GetHits : Word;
begin
        Result := GetWord( 7 );
end;

function GetCharAttributes.GetMaxMana : Word;
begin
        Result := GetWord( 9 );
end;

function GetCharAttributes.GetMana : Word;
begin
        Result := GetWord( 11 );
end;

function GetCharAttributes.GetMaxStamina : Word;
begin
        Result := GetWord( 13 );
end;

function GetCharAttributes.GetStamina : Word;
begin
        Result := GetWord( 15 );
end;

function GetCharDeleteDeny.GetReason : Byte;
begin
        Result := GetByte( 1 );
end;

function GetMEInfo.GetType : Byte;
begin
        Result := GetByte( 3 );
end;

function GetMEInfo.ToDump : Boolean;
begin
        if GetType = $4 then
                Result := False
        else
                Result := True;
end;

function GetCharSize.GetSerial : LongWord;
begin
        Result := GetLongWord( 4 );
end;

function GetCharSize.GetBreite : Word;
begin
        Result := GetWord( 8 );
end;

function GetCharSize.GetHoehe : Word;
begin
        Result := GetWord( 10 );
end;

function GetFirstMultiID.GetID : Word;
begin
        Result := GetWord( 4 );
end;

function GetMEProfile.GetSerial : LongWord;
begin
        Result := GetLongWord( 4 );
end;

function GetMEDisableRadar.RadarDisabled : Boolean;
begin
        Result := ( GetByte( 4 ) and $1 ) = $1;
end;

function GetMEFightSystem.GetFightSystemSubSubType : Byte;
begin
        Result := GetByte( 4 );
end;

function GetMEOpenFightGump.GetTargetSerial : LongWord;
begin
        Result := GetLongWord( 5 );
end;

function GetMEOpenFightGump.IsPlayer : Byte;
begin
        Result := GetByte( 9 );
end;

function GetMEOpenFightGump.TrefferZone : Byte;
begin
        Result := GetByte( 10 );
end;

function GetMEOpenFightGump.Kampfmodus : Byte;
begin
        Result := GetByte( 11 );
end;

function GetMEOpenFightGump.Kampfgeschwindigkeit : Byte;
begin
        Result := GetByte( 12 );
end;

function GetMEOpenFightGump.Ausweichen : Byte;
begin
        Result := GetByte( 13 );
end;

function GetMEOpenFightGump.TrefferZoneFixed : Boolean;
begin
        Result := GetByte( 14 ) > 0;
end;

function GetMEOpenFightGump.KampfmodusFixed : Boolean;
begin
        Result := GetByte( 15 ) > 0;
end;

function GetMEOpenFightGump.KampfgeschwindigkeitFixed : Boolean;
begin
        Result := GetByte( 16 ) > 0;
end;

function GetMEOpenFightGump.AusweichenFixed : Boolean;
begin
        Result := GetByte( 17 ) > 0;
end;

function GetMEFightDoDamage.TrefferZone : Byte;
begin
        Result := GetByte( 5 );
end;

function GetMEFightDoDamage.Staerke : Byte;
begin
        Result := GetByte( 6 );
end;

function GetUnicodeTextEntry.GetPlayerSerial : LongWord;
begin
        Result := GetLongWord( 3 );
end;

function GetUnicodeTextEntry.GetMessageId : LongWord;
begin
        Result := GetLongWord( 7 );
end;

function GetConsoleTextEntry.GetObjectID : LongWord;
begin
        Result := GetLongWord( 3 );
end;

function GetConsoleTextEntry.GetPrompt : LongWord;
begin
        Result := GetLongWord( 7 );
end;

function GetConsoleTextEntry.GetRequest : LongWord;
begin
        Result := GetLongWord( 11 );
end;

function GetConsoleTextEntry.GetText : String;
begin
        Result := GetAsciiString( 15, GetLength-15 );
end;

function GetMEUpdateWounds.GetWound( Id : Byte ) : Byte;
begin
        Result := GetByte( 4 + Id );
end;

function GetMEAddToInvisList.GetCount : Word;
begin
        Result := GetWord( 4 );
end;

function GetMEAddToInvisList.GetId( Index : Word ) : Word;
begin
        if Index < GetCount then
                Result := GetWord( 6 + Index*2 )
        else
                Result := 0;
end;

function GetMERemoveFromInvisList.GetCount : Word;
begin
        Result := GetWord( 4 );
end;

function GetMERemoveFromInvisList.GetId( Index : Word ) : Word;
begin
        if Index < GetCount then
                Result := GetWord( 6 + Index*2 )
        else
                Result := 0;
end;

function GetDirectionArrow.GetX : Word;
begin
        Result := GetWord( 4 );
end;

function GetDirectionArrow.GetY : Word;
begin
        Result := GetWord( 6 );
end;

function GetLoadStaticsMapFromMuls.LoadStaticsMap : Boolean;
begin
        Result := GetByte( 4 ) = 0;
end;

function GetMapBlock.GetBlockID : LongWord;
begin
        Result := GetLongWord( 4 );
end;

function GetMapBlock.GetId( Index : Byte ) : Word;
begin
        Result := GetWord( 8 + Index*3 );
end;

function GetMapBlock.GetZ( Index : Byte ) : ShortInt;
begin
        Result := GetByte( 10 + Index*3 );
end;

function GetStaticBlock.GetBlockID : LongWord;
begin
        Result := GetLongWord( 4 );
end;

function GetStaticBlock.GetStaticCount : Word;
begin
        Result := GetWord( 8 );
end;

function GetStaticBlock.GetId( Index : Word ) : Word;
begin
        Result := GetWord( 10 + Index*7 );
end;

function GetStaticBlock.GetX( Index : Word ) : Word;
begin
        Result := ( GetBlockID div GetMapHoehe )*8 + GetByte( 12 + Index*7 );
end;

function GetStaticBlock.GetY( Index : Word ) : Word;
begin
        Result := ( GetBlockID mod GetMapHoehe )*8 + GetByte( 13 + Index*7 );
end;

function GetStaticBlock.GetZ( Index : Word ) : ShortInt;
begin
        Result := GetByte( 14 + Index*7 );
end;

function GetStaticBlock.GetColor( Index : Word ) : Word;
begin
        Result := GetWord( 15 + Index*7 );
end;

function GetCharSpeed.GetSerial : LongWord;
begin
        Result := GetLongWord( 4 );
end;

function GetCharSpeed.GetMovingSpeed : Word;
begin
        Result := GetWord( 8 );
end;

function GetCharSpeed.GetRunningSpeed : Word;
begin
        Result := GetWord( 10 );
end;

function GetCloseContainerGump.GetSerial : LongWord;
begin
        Result := GetLongWord( 4 );
end;

function GetCharTransparency.GetSerial : LongWord;
begin
        Result := GetLongWord( 4 );
end;

function GetCharTransparency.GetAlpha : Byte;
begin
        Result := GetByte( 8 );
end;

end.
