unit uSendPackets;

interface

uses    uPacket, Classes, uUtilities, SysUtils, Dialogs;

type    TEncryptionPacket = class( UOPacket )
                public
                        constructor Create( I : Longword );
        end;

        TLoginRequest = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetUserID( UserId : String );
                        procedure SetPassword( Password : String );
                        procedure SetUnknown( Unknown : Byte );
        end;

        TServerSelect = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetShard( Shard : Word );
        end;

        TLoginGameServer = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetKey( Key : Longword );
                        procedure SetUserID( UserId : String );
                        procedure SetPassword( Password : String );
        end;

        TLoginCharacter = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetCharName( Name : String );
                        procedure SetSlot( Slot : Byte );
                        procedure SetClientIP( IP : Longword );
        end;

        TSendClientVersion = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetVersion( Version : String );
        end;

        TSendSpeechRequest = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetType( Typ : Byte );
                        procedure SetColor( Color : Word );
                        procedure SetFont( Font : Word );
                        procedure SetLanguage( Language: String );
                        procedure SetMsg( Msg : String );
        end;

        TWalkRequest = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetDirection( Direction : Byte );
                        procedure SetMoveSequence( Sequence : Byte );
                        procedure SetFastWalkKey( Key : LongWord );
        end;

        TSendSingleClick = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetSerial( Serial : LongWord );
        end;

        TSendDoubleClick = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetSerial( Serial : LongWord );
        end;

        TChooseTarget = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetType( Typ : Byte );
                        procedure SetSerial( Serial : LongWord );
                        procedure SetCursorType( Typ : Byte );
                        procedure SetTargetSerial( Serial : LongWord );
                        procedure SetX( X : Word );
                        procedure SetY( Y : Word );
                        procedure SetZ( Z : SmallInt );
                        procedure SetId( Id : Word );
        end;

        TItemPickupRequest = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetSerial( Serial : LongWord );
                        procedure SetAmount( Amount : Word );
        end;

        TDropItem = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetSerial( Serial : LongWord );
                        procedure SetX( X : Word );
                        procedure SetY( Y : Word );
                        procedure SetZ( Z : ShortInt );
                        procedure SetContSerial( Serial : LongWord );
        end;

        TEquipItem = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetSerial( Serial : LongWord );
                        procedure SetLayer( Layer : Byte );
                        procedure SetCharSerial( Serial : LongWord );
        end;

        TGumpMenuReply = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetSerial( Serial : LongWord );
                        procedure SetType( Serial : LongWord );
                        procedure SetReturnNumber( ReturnNumber : Integer );
        end;

        THelpRequest = Class( UOPacket )
                public
                        constructor Create;
        end;

        TGetCharStatus = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetPlayer( Serial : LongWord );
        end;

        TGetSkills = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetPlayer( Serial : LongWord );
        end;

        TCloseStatusGump = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetPlayer( Serial : LongWord );
        end;

        TSendPing = Class( UOPacket )
                public
                        constructor Create;
        end;

        TSendWarMode = Class( UOPacket )
                public
                        constructor Create( WarMode : Boolean );
        end;

        TSendAttack = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetAttackTarget( Serial : LongWord );
        end;

        TSendSecureTrading = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetAction( Action : Byte );
                        procedure SetSerial1( Serial : LongWord );
                        procedure SetSerial2( Serial : LongWord );
                        procedure SetSerial3( Serial : LongWord );
        end;

        TSendEndSecureTrading = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetAction( Action : Byte );
                        procedure SetSerial1( Serial : LongWord );
        end;

        TLogout = Class( UOPacket )
                public
                        constructor Create;
        end;

        TRequestSkills = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetSerial( Serial : LongWord );
        end;

        TSendBuyItems = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetSerial( Serial : LongWord );
                        procedure AddItem( Serial : LongWord; Amount : Word );
        end;

        TSendSellItems = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetSerial( Serial : LongWord );
                        procedure AddItem( Serial : LongWord; Amount : Word );
        end;

        TSendGumpInputentryReply = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetSerial( Serial : LongWord );
                        procedure SetType( Typ : Word );
                        procedure SetText( Text : String );
        end;

        TSendAddPartyMember = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetSerial( Serial : LongWord );
        end;

        TSendRemovePartyMember = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetSerial( Serial : LongWord );
        end;

        TSendPartyMemberMessage = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetTargetSerial( Serial : LongWord );
                        procedure SetText( Text : String );
        end;

        TSendPartyMessage = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetText( Text : String );
        end;

        TSendPartyCanLoot = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetCanLoot( CanLoot : Boolean );
        end;

        TSendPartyAccept = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetLeaderSerial( Serial : LongWord );
        end;

        TSendPartyDecline = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetLeaderSerial( Serial : LongWord );
        end;

        TSendProfileRequest = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetSerial( Serial : LongWord );
        end;

        TSendProfileUpdateRequest = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetSerial( Serial : LongWord );
                        procedure SetText( Text : String );
        end;

        TSendUnicodePrompt = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetMessageId( Id : LongWord );
                        procedure SetPlayerId( Id : LongWord );
                        procedure SetLanguage( Language : String );
                        procedure SetText( Text : String );
        end;

        TSendDeleteChar = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetPassword( Password : String );
                        procedure SetCharIndex( Index : Integer );
                        procedure SetClientIP( IP : LongWord );
        end;

        TResyncRequest = Class( UOPacket )
                public
                        constructor Create;
        end;

        TCreateChar = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetCharName( Name : String );
                        procedure SetPassword( Password : String );
                        procedure SetSex( Sex : Byte );
                        procedure SetStr( Str : Byte );
                        procedure SetDex( Dex : Byte );
                        procedure SetInt( Int : Byte );
                        procedure SetSkill1( Skill : Byte );
                        procedure SetSkill1Value( SkillValue : Byte );
                        procedure SetSkill2( Skill : Byte );
                        procedure SetSkill2Value( SkillValue : Byte );
                        procedure SetSkill3( Skill : Byte );
                        procedure SetSkill3Value( SkillValue : Byte );
                        procedure SetSkinColor( Color : Word );
                        procedure SetHairStyle( Style : Word );
                        procedure SetHairColor( Color : Word );
                        procedure SetFacialHairStyle( Style : Word );
                        procedure SetFacialHairColor( Color : Word );
                        procedure SetLocation( Location : Word );
                        procedure SetUnknown1( Value : Word );
                        procedure SetSlot( Slot : Word );
                        procedure SetClientIP( IP : LongWord );
                        procedure SetShirtColor( Color : Word );
                        procedure SetSkirtColor( Color : Word );
        end;

        TBoxDialogResponse = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetSerial( Serial : LongWord );
                        procedure SetMenuId( MenuId : Word );
                        procedure SetSlot( Slot : Word );
                        procedure SetModelID( ModelId : Word );
                        procedure SetModelHue( ModelHue : Word );
        end;

        TConsoleTextEntryResponse = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetObjectID( ObjectID : LongWord );
                        procedure SetPrompt( Prompt : LongWord );
                        procedure SetRequest( Request : LongWord );
                        procedure SetText( Text : String );
        end;

        TSendMacAddress = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetMacAddress( Address : String );
                        function Dump : TStringList; override;
                        function GetInternalName : String; override;                        
        end;

        TSendVersion = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetVersion( Version : LongWord );
        end;

        TSendDyeRequest = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetSerial( Serial : LongWord );
                        procedure SetModel( Model : Word );
                        procedure SetColor( Color : Word );
        end;

        TUpdateBookPage = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetSerial( Serial : LongWord );
                        procedure SetPage( Page : Word );
                        procedure SetLines( Lines : TStringList );
        end;

        TUpdateBook = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetSerial( Serial : LongWord );
                        procedure SetTitle( Title : String );
                        procedure SetAuthor( Author : String );
        end;

        MEFightGumpResponse = Class( UOPacket )
                public
                        constructor Create;
                        procedure SetTrefferZone( TrefferZone : Byte );
                        procedure SetKampfModus( KampfModus : Byte );
                        procedure SetKampfGeschwindigkeit( KampfGeschwindigkeit : Byte );
                        procedure SetAusweichen( Ausweichen : Byte );
        end;

        MEOpenFightGumpRequest = Class( UOPacket )
                public
                        constructor Create;
        end;
        
implementation

uses    uPalanthir;

constructor TEncryptionPacket.Create( I : Longword );
begin
        inherited Create( 0, 4 );
        SetLongWord( 0, I );
end;

constructor TLoginRequest.Create;
begin
        inherited Create( $80, 62 );
end;

procedure TLoginRequest.SetUserID( UserId : String );
begin
        SetAsciiString( UserId, 1, 30 );
end;

procedure TLoginRequest.SetPassword( Password : String );
begin
        SetAsciiString( Password, 31, 30 );
end;

procedure TLoginRequest.SetUnknown( Unknown : Byte );
begin
        SetByte( 61, Unknown );
end;

constructor TServerSelect.Create;
begin
        inherited Create( $A0, 3 );
end;

procedure TServerSelect.SetShard( Shard : Word );
begin
        SetWord( 1, Shard );
end;

constructor TLoginGameServer.Create;
begin
        inherited Create( $91, 65 );
end;

procedure TLoginGameServer.SetKey( Key : Longword );
begin
        SetLongWord( 1, Key );
end;

procedure TLoginGameServer.SetUserID( UserId : String );
begin
        SetAsciiString( UserId, 5, 30 );
end;

procedure TLoginGameServer.SetPassword( Password : String );
begin
        SetAsciiString( Password, 35, 30 );
end;

constructor TLoginCharacter.Create;
begin
        inherited Create( $5D, 73 );
        SetLongWord( 1, $edededed );
        SetAsciiString( '', 35, 33 );
end;

procedure TLoginCharacter.SetCharName( Name : String );
begin
        SetAsciiString( Name, 5, 30 );
end;

procedure TLoginCharacter.SetSlot( Slot : Byte );
begin
        SetByte( 68, Slot );
end;

procedure TLoginCharacter.SetClientIP( IP : Longword );
begin
        SetLongWord( 69, IP );
end;

constructor TSendClientVersion.Create;
begin
        inherited Create( $BD, 3 );
end;

procedure TSendClientVersion.SetVersion( Version : String );
begin
        SetLength( 3 + Length( Version )+1 );
        SetWord( 1, 3 + Length( Version )+1 );
        SetAsciiString( Version, 3, Length( Version )+1 );
end;

constructor TSendSpeechRequest.Create;
begin
        inherited Create( $AD, 12 );
end;

procedure TSendSpeechRequest.SetType( Typ : Byte );
begin
        SetByte( 3, Typ );
end;

procedure TSendSpeechRequest.SetColor( Color : Word );
begin
        SetWord( 4, Color );
end;

procedure TSendSpeechRequest.SetFont( Font : Word );
begin
        SetWord( 6, Font );
end;

procedure TSendSpeechRequest.SetLanguage( Language: String );
begin
        SetAsciiString( Language, 8, 4 );
end;

procedure TSendSpeechRequest.SetMsg( Msg : String );
var     Keywords : TList;
        ByteCount, Count, I : Integer;
begin
        Keywords := Palanthir.Data.GetKeyWords( Msg );

        if Keywords.Count > 0 then begin
                SetByte( 3, GetByte( 3 ) + $C0 );

                Count := ( Keywords.Count + 1 )*12;
                ByteCount := Count div 8;
                if (Count mod 8) <> 0 then
                        ByteCount := ByteCount + 1;

                SetLength( 12 + ByteCount + Length( Utf8Encode( Msg ) ) + 1 );
                SetWord( 1, 12 + ByteCount + Length( Utf8Encode( Msg ) ) + 1 );

                Count := 12;
                SetWord( Count, Keywords.Count shl 4 );
                Inc( Count );

                for I := 0 to Keywords.Count-1 do begin
                        if (I mod 2) = 0 then begin
                                SetWord( Count, (GetByte( Count ) shl 8) + Integer( Keywords.Items[ I ] ) );
                                Count := Count + 2;
                        end
                        else begin
                                SetWord( Count, Integer( Keywords.Items[ I ] ) shl 4 );
                                Count := Count + 1;
                        end;
                end;

                if (Keywords.Count mod 2) = 0 then
                        Inc( Count );

                SetAsciiString( Msg, Count, Length( Utf8Encode( Msg ) )+1 );
        end
        else begin
                SetLength( 12 + Length( Msg )*2+2 );
                SetWord( 1, 12 + Length( Msg )*2+2 );
                SetUnicodeString( Msg, 12, Length( Msg )+1 );
        end;
end;

constructor TWalkRequest.Create;
begin
        inherited Create( $2, 7 );
end;

procedure TWalkRequest.SetDirection( Direction : Byte );
begin
        SetByte( 1, Direction );
end;

procedure TWalkRequest.SetMoveSequence( Sequence : Byte );
begin
        SetByte( 2, Sequence );
end;

procedure TWalkRequest.SetFastWalkKey( Key : LongWord );
begin
        SetLongWord( 3, Key );
end;

constructor TSendSingleClick.Create;
begin
        inherited Create( $9, 5 );
end;

procedure TSendSingleClick.SetSerial( Serial : LongWord );
begin
        SetLongWord( 1, Serial );
end;

constructor TSendDoubleClick.Create;
begin
        inherited Create( $6, 5 );
end;

procedure TSendDoubleClick.SetSerial( Serial : LongWord );
begin
        SetLongWord( 1, Serial );
end;

constructor TChooseTarget.Create;
begin
        inherited Create( $6C, 19 );
end;

procedure TChooseTarget.SetType( Typ : Byte );
begin
        SetByte( 1, Typ );
end;

procedure TChooseTarget.SetSerial( Serial : LongWord );
begin
        SetLongWord( 2, Serial );
end;

procedure TChooseTarget.SetCursorType( Typ : Byte );
begin
        SetByte( 6, Typ );
end;

procedure TChooseTarget.SetTargetSerial( Serial : LongWord );
begin
        SetLongWord( 7, Serial );
end;

procedure TChooseTarget.SetX( X : Word );
begin
        SetWord( 11, X );
end;

procedure TChooseTarget.SetY( Y : Word );
begin
        SetWord( 13, Y );
end;

procedure TChooseTarget.SetZ( Z : SmallInt );
begin
        SetWord( 15, Z );
end;

procedure TChooseTarget.SetId( Id : Word );
begin
        SetWord( 17, Id );
end;

constructor TItemPickupRequest.Create;
begin
        inherited Create( $7, 7 );
end;

procedure TItemPickupRequest.SetSerial( Serial : LongWord );
begin
        SetLongWord( 1, Serial );
end;

procedure TItemPickupRequest.SetAmount( Amount : Word );
begin
        SetWord( 5, Amount );
end;

constructor TDropItem.Create;
begin
        inherited Create( $8, 14 );
end;

procedure TDropItem.SetSerial( Serial : LongWord );
begin
        SetLongWord( 1, Serial );
end;

procedure TDropItem.SetX( X : Word );
begin
        SetWord( 5, X );
end;

procedure TDropItem.SetY( Y : Word );
begin
        SetWord( 7, Y );
end;

procedure TDropItem.SetZ( Z : ShortInt );
begin
        SetByte( 9, Z );
end;

procedure TDropItem.SetContSerial( Serial : LongWord );
begin
        SetLongWord( 10, Serial );
end;

constructor TEquipItem.Create;
begin
        inherited Create( $13, 10 );
end;

procedure TEquipItem.SetSerial( Serial : LongWord );
begin
        SetLongWord( 1, Serial );
end;

procedure TEquipItem.SetLayer( Layer : Byte );
begin
        SetByte( 5, Layer );
end;

procedure TEquipItem.SetCharSerial( Serial : LongWord );
begin
        SetLongWord( 6, Serial );
end;

constructor TGumpMenuReply.Create;
begin
        inherited Create( $B1, 19 );
end;

procedure TGumpMenuReply.SetSerial( Serial : LongWord );
begin
        SetLongWord( 3, Serial );
end;

procedure TGumpMenuReply.SetType( Serial : LongWord );
begin
        SetLongWord( 7, Serial );
end;

procedure TGumpMenuReply.SetReturnNumber( ReturnNumber : Integer );
begin
        SetLongWord( 11, ReturnNumber );
end;

constructor THelpRequest.Create;
var     I : Integer;
begin
        inherited Create( $9B, 258 );
        for I := 1 to 257 do
                SetByte( I, 0 );
end;

constructor TGetCharStatus.Create;
begin
        inherited Create( $34, 10 );
        SetLongWord( 1, $EDEDEDED );
        SetByte( 5, 4 );
end;

procedure TGetCharStatus.SetPlayer( Serial : LongWord );
begin
        SetLongWord( 6, Serial );
end;

constructor TGetSkills.Create;
begin
        inherited Create( $34, 10 );
        SetLongWord( 1, $EDEDEDED );
        SetByte( 5, 5 );
end;

procedure TGetSkills.SetPlayer( Serial : LongWord );
begin
        SetLongWord( 6, Serial );
end;

constructor TCloseStatusGump.Create;
begin
        inherited Create( $BF, 9 );
        SetWord( 1, 9 );
        SetWord( 3, $C );
end;

procedure TCloseStatusGump.SetPlayer( Serial : LongWord );
begin
        SetLongWord( 5, Serial );
end;

constructor TSendPing.Create;
begin
        inherited Create( $73, 2 );
        SetByte( 1, 0 );
end;

constructor TSendWarMode.Create( WarMode : Boolean );
begin
        inherited Create( $72, 5 );
        if WarMode then
                SetByte( 1, 1 )
        else
                SetByte( 1, 0 );
        SetByte( 3, $32 );
end;

constructor TSendAttack.Create;
begin
        inherited Create( $5, 5 );
end;

procedure TSendAttack.SetAttackTarget( Serial : LongWord );
begin
        SetLongWord( 1, Serial );
end;

constructor TSendSecureTrading.Create;
begin
        inherited Create( $6F, 17 );
        SetWord( 1, 17 );
end;

procedure TSendSecureTrading.SetAction( Action : Byte );
begin
        SetByte( 3, Action );
end;

procedure TSendSecureTrading.SetSerial1( Serial : LongWord );
begin
        SetLongWord( 4, Serial );
end;

procedure TSendSecureTrading.SetSerial2( Serial : LongWord );
begin
        SetLongWord( 8, Serial );
end;

procedure TSendSecureTrading.SetSerial3( Serial : LongWord );
begin
        SetLongWord( 12, Serial );
end;

constructor TSendEndSecureTrading.Create;
begin
        inherited Create( $6F, 8 );
        SetWord( 1, 8 );
end;

procedure TSendEndSecureTrading.SetAction( Action : Byte );
begin
        SetByte( 3, Action );
end;

procedure TSendEndSecureTrading.SetSerial1( Serial : LongWord );
begin
        SetLongWord( 4, Serial );
end;

constructor TLogout.Create;
begin
        inherited Create( $D1, 2 );
        SetByte( 1, 1 );
end;

constructor TRequestSkills.Create;
begin
        inherited Create( $34, 10 );
        SetLongWord( 1, $EDEDEDED );
        SetByte( 5, 5 );
end;

procedure TRequestSkills.SetSerial( Serial : LongWord );
begin
        SetLongWord( 6, Serial );
end;

constructor TSendBuyItems.Create;
begin
        inherited Create( $3B, 8 );
        SetWord( 1, 8 );
        SetByte( 7, 0 );
end;

procedure TSendBuyItems.SetSerial( Serial : LongWord );
begin
        SetLongWord( 3, Serial );
end;

procedure TSendBuyItems.AddItem( Serial : LongWord; Amount : Word );
begin
        SetByte( 7, 2 );

        SetLength( GetLength + 7 );
        SetWord( 1, GetLength );

        SetByte( GetLength - 7, $1A );
        SetLongWord( GetLength - 6, Serial );
        SetWord( GetLength - 2, Amount );
end;

constructor TSendSellItems.Create;
begin
        inherited Create( $9F, 9 );
        SetWord( 1, 9 );
        SetWord( 7, 0 );
end;

procedure TSendSellItems.SetSerial( Serial : LongWord );
begin
        SetLongWord( 3, Serial );
end;

procedure TSendSellItems.AddItem( Serial : LongWord; Amount : Word );
begin
        SetLength( GetLength + 6 );
        SetWord( 1, GetLength );

        SetWord( 7, ( GetLength - 9 ) div 6 );

        SetLongWord( GetLength - 6, Serial );
        SetWord( GetLength - 2, Amount );
end;

constructor TSendGumpInputentryReply.Create;
begin
        inherited Create( $AC, 12 );
        SetWord( 1, 12 );
        SetByte( 7, 0 );
        SetByte( 8, 0 );
end;

procedure TSendGumpInputentryReply.SetSerial( Serial : LongWord );
begin
        SetLongWord( 3, Serial );
end;

procedure TSendGumpInputentryReply.SetType( Typ : Word );
begin
        SetByte( 9, Typ );
end;

procedure TSendGumpInputentryReply.SetText( Text : String );
var     Laenge : Word;
begin
        Laenge := Length( Text );

        SetWord( 10, Laenge + 1 );
        SetLength( 12 + Laenge + 1 );
        SetWord( 1, 12 + Laenge + 1 );

        SetAsciiString( Text, 12, Length( Text ) + 1 );
end;

constructor TSendAddPartyMember.Create;
begin
        inherited Create( $BF, 10 );
        SetWord( 1, 10 );
        SetWord( 3, 6 );//muss word sein
        SetByte( 5, 1 );
        SetLongWord( 6, 0 );
end;

procedure TSendAddPartyMember.SetSerial( Serial : LongWord );
begin
        SetLongWord( 6, Serial );
end;

constructor TSendRemovePartyMember.Create;
begin
        inherited Create( $BF, 10 );
        SetWord( 1, 10 );
        SetWord( 3, 6 );
        SetByte( 5, 2 );
        SetLongWord( 6, 0 );
end;

procedure TSendRemovePartyMember.SetSerial( Serial : LongWord );
begin
        SetLongWord( 6, Serial );
end;

constructor TSendPartyMemberMessage.Create;
begin
        inherited Create( $BF, 10 );
        SetWord( 1, 10 );
        SetWord( 3, 6 );
        SetByte( 5, 3 );
end;

procedure TSendPartyMemberMessage.SetTargetSerial( Serial : LongWord );
begin
        SetLongWord( 6, Serial );
end;

procedure TSendPartyMemberMessage.SetText( Text : String );
begin
        SetLength( 10 + Length( Text )*2 );
        SetWord( 1, 10 + Length( Text )*2 );
        SetUnicodeString( Text, 10, Length( Text ) );
end;

constructor TSendPartyMessage.Create;
begin
        inherited Create( $BF, 6 );
        SetWord( 1, 6 );
        SetWord( 3, 6 );
        SetByte( 5, 4 );
end;

procedure TSendPartyMessage.SetText( Text : String );
begin
        SetLength( 6 + Length( Text )*2 );
        SetWord( 1, 6 + Length( Text )*2 );
        SetUnicodeString( Text, 6, Length( Text ) );
end;

constructor TSendPartyCanLoot.Create;
begin
        inherited Create( $BF, 7 );
        SetWord( 1, 7 );
        SetWord( 3, 6 );
        SetByte( 5, 6 );
end;

procedure TSendPartyCanLoot.SetCanLoot( CanLoot : Boolean );
begin
        if CanLoot then
                SetByte( 6, 1 )
        else
                SetByte( 6, 0 );
end;

constructor TSendPartyAccept.Create;
begin
        inherited Create( $BF, 10 );
        SetWord( 1, 10 );
        SetWord( 3, 6 );
        SetByte( 5, 8 );
end;

procedure TSendPartyAccept.SetLeaderSerial( Serial : LongWord );
begin
        SetLongWord( 6, Serial );
end;

constructor TSendPartyDecline.Create;
begin
        inherited Create( $BF, 10 );
        SetWord( 1, 10 );
        SetWord( 3, 6 );
        SetByte( 5, 8 );
end;

procedure TSendPartyDecline.SetLeaderSerial( Serial : LongWord );
begin
        SetLongWord( 6, Serial );
end;

constructor TSendProfileRequest.Create;
begin
        inherited Create( $B8, 8 );
        SetWord( 1, 8 );
        SetByte( 3, 0 );
end;

procedure TSendProfileRequest.SetSerial( Serial : LongWord );
begin
        SetLongWord( 4, Serial );
end;

constructor TSendProfileUpdateRequest.Create;
begin
        inherited Create( $B8, 12 );
        SetWord( 1, 12 );
        SetByte( 3, 1 );
        SetWord( 8, 1 );
        SetWord( 10, 0 );
end;

procedure TSendProfileUpdateRequest.SetSerial( Serial : LongWord );
begin
        SetLongWord( 4, Serial );
end;

procedure TSendProfileUpdateRequest.SetText( Text : String );
begin
        SetLength( 12 + Length( Text )*2 );
        SetWord( 1, 12 + Length( Text )*2 );
        SetWord( 10, Length( Text ) );
        SetUnicodeString( Text, 12, Length( Text ) );
end;

constructor TSendUnicodePrompt.Create;
begin
        inherited Create( $C2, 19 );
        SetWord( 1, 19 );
        SetLongWord( 11, 1 );
        SetByte( 18, 0 );
end;

procedure TSendUnicodePrompt.SetMessageId( Id : LongWord );
begin
        SetLongWord( 7, Id );
end;

procedure TSendUnicodePrompt.SetPlayerId( Id : LongWord );
begin
        SetLongWord( 3, Id );
end;

procedure TSendUnicodePrompt.SetLanguage( Language : String );
begin
        SetAsciiString( Language, 15, 3 );
end;

procedure TSendUnicodePrompt.SetText( Text : String );
begin
        SetLength( 19 + Length( Text )*2 );
        SetWord( 1, 19 + Length( Text )*2 );
        SetUnicodeString( Text, 18, Length( Text ) );
        SetByte( GetLength-1, 0 );
end;

constructor TSendDeleteChar.Create;
begin
        inherited Create( $83, 39 );
end;

procedure TSendDeleteChar.SetPassword( Password : String );
begin
        SetAsciiString( Password, 1, 30 );
end;

procedure TSendDeleteChar.SetCharIndex( Index : Integer );
begin
        SetLongWord( 31, Index );
end;

procedure TSendDeleteChar.SetClientIP( IP : LongWord );
begin
        SetLongWord( 35, IP );
end;

constructor TResyncRequest.Create;
begin
        inherited Create( $22, 3 );
        SetByte( 1, 0 );
        SetByte( 2, 0 );
end;

constructor TCreateChar.Create;
begin
        inherited Create( $0, 104 );
        SetLongWord( 1, $EDEDEDED );
        SetLongWord( 5, $FFFFFFFF );
        SetByte( 9, 0 );
        SetUnknown1( 0 );
end;

procedure TCreateChar.SetCharName( Name : String );
begin
        SetAsciiString( Name, 10, 30 );
end;

procedure TCreateChar.SetPassword( Password : String );
begin
        SetAsciiString( Password, 40, 30 );
end;

procedure TCreateChar.SetSex( Sex : Byte );
begin
        SetByte( 70, Sex );
end;

procedure TCreateChar.SetStr( Str : Byte );
begin
        SetByte( 71, Str );
end;

procedure TCreateChar.SetDex( Dex : Byte );
begin
        SetByte( 72, Dex );
end;

procedure TCreateChar.SetInt( Int : Byte );
begin
        SetByte( 73, Int );
end;

procedure TCreateChar.SetSkill1( Skill : Byte );
begin
        SetByte( 74, Skill );
end;

procedure TCreateChar.SetSkill1Value( SkillValue : Byte );
begin
        SetByte( 75, SkillValue );
end;

procedure TCreateChar.SetSkill2( Skill : Byte );
begin
        SetByte( 76, Skill );
end;

procedure TCreateChar.SetSkill2Value( SkillValue : Byte );
begin
        SetByte( 77, SkillValue );
end;

procedure TCreateChar.SetSkill3( Skill : Byte );
begin
        SetByte( 78, Skill );
end;

procedure TCreateChar.SetSkill3Value( SkillValue : Byte );
begin
        SetByte( 79, SkillValue );
end;

procedure TCreateChar.SetSkinColor( Color : Word );
begin
        SetWord( 80, Color );
end;

procedure TCreateChar.SetHairStyle( Style : Word );
begin
        SetWord( 82, Style );
end;

procedure TCreateChar.SetHairColor( Color : Word );
begin
        SetWord( 84, Color );
end;

procedure TCreateChar.SetFacialHairStyle( Style : Word );
begin
        SetWord( 86, Style );
end;

procedure TCreateChar.SetFacialHairColor( Color : Word );
begin
        SetWord( 88, Color );
end;

procedure TCreateChar.SetLocation( Location : Word );
begin
        SetWord( 90, Location );
end;

procedure TCreateChar.SetUnknown1( Value : Word );
begin
        SetWord( 92, Value );
end;

procedure TCreateChar.SetSlot( Slot : Word );
begin
        SetWord( 94, Slot );
end;

procedure TCreateChar.SetClientIP( IP : LongWord );
begin
        SetLongWord( 96, IP );
end;

procedure TCreateChar.SetShirtColor( Color : Word );
begin
        SetWord( 100, Color );
end;

procedure TCreateChar.SetSkirtColor( Color : Word );
begin
        SetWord( 102, Color );
end;

constructor TBoxDialogResponse.Create;
begin
        inherited Create( $7D, 13 );
end;

procedure TBoxDialogResponse.SetSerial( Serial : LongWord );
begin
        SetLongWord( 1, Serial );
end;

procedure TBoxDialogResponse.SetMenuId( MenuId : Word );
begin
        SetWord( 5, MenuId );
end;

procedure TBoxDialogResponse.SetSlot( Slot : Word );
begin
        SetWord( 7, Slot );
end;

procedure TBoxDialogResponse.SetModelID( ModelId : Word );
begin
        SetWord( 9, ModelId );
end;

procedure TBoxDialogResponse.SetModelHue( ModelHue : Word );
begin
        SetWord( 11, ModelHue );
end;

constructor TConsoleTextEntryResponse.Create;
begin
        inherited Create( $9A, 16 );
        SetWord( 1, 16 );
        SetByte( 15, 0 );
end;

procedure TConsoleTextEntryResponse.SetObjectID( ObjectID : LongWord );
begin
        SetLongWord( 3, ObjectID );
end;

procedure TConsoleTextEntryResponse.SetPrompt( Prompt : LongWord );
begin
        SetLongWord( 7, Prompt );
end;

procedure TConsoleTextEntryResponse.SetRequest( Request : LongWord );
begin
        SetLongWord( 11, Request );
end;

procedure TConsoleTextEntryResponse.SetText( Text : String );
begin
        SetLength( 15 + Length( Text ) + 1 );
        SetWord( 1, GetLength );
        SetAsciiString( Text, 15, Length( Text )+1 );
end;

constructor TSendMacAddress.Create;
begin
        inherited Create( $F5, 10 );
        SetWord( 1, 10 );
        SetByte( 3, 5 );
end;

procedure TSendMacAddress.SetMacAddress( Address : String );
var     Liste : TStringList;
        I : Integer;
begin
        Liste := TStringList.Create;
        Liste.Delimiter := '-';
        Liste.DelimitedText := Address;

        for I := 0 to 5 do begin
                try
                        SetByte( I+4, StrToInt( '0x' + Liste.Strings[ I ] ) );
                except
                        SetByte( I+4, 0 );
                end;
        end;
        Liste.Free;
end;

function TSendMacAddress.Dump : TStringList;
begin
        Result := nil;
end;

function TSendMacAddress.GetInternalName : String;
begin
        Result := '';
end;

constructor TSendVersion.Create;
begin
        inherited Create( $F5, 8 );
        SetWord( 1, 8 );
        SetByte( 3, 7 );
end;

procedure TSendVersion.SetVersion( Version : LongWord );
begin
        SetLongWord( 4, Version );
end;

constructor TSendDyeRequest.Create;
begin
        inherited Create( $95, 9 );
end;

procedure TSendDyeRequest.SetSerial( Serial : LongWord );
begin
        SetLongWord( 1, Serial );
end;

procedure TSendDyeRequest.SetModel( Model : Word );
begin
        SetWord( 5, Model );
end;

procedure TSendDyeRequest.SetColor( Color : Word );
begin
        SetWord( 7, Color );
end;

constructor TUpdateBookPage.Create;
begin
        inherited Create( $66, 11 );
        SetWord( 1, 9 );
        SetWord( 7, 1 );
end;

procedure TUpdateBookPage.SetSerial( Serial : LongWord );
begin
        SetLongWord( 3, Serial );
end;

procedure TUpdateBookPage.SetPage( Page : Word );
begin
        SetWord( 9, Page );
end;

procedure TUpdateBookPage.SetLines( Lines : TStringList );
var     Count : Word;
        I, K : Integer;
begin
        Count := 13;
        for I := 0 to Lines.Count-1 do begin
                if Lines.Strings[ I ] = '' then begin
                        Inc( Count, 1 );
                end
                else begin
                        Count := Count + Length( Lines.Strings[ I ] ) + 1;
                end;
        end;

        SetLength( Count );
        SetWord( 1, Count );

        SetWord( 11, Lines.Count );
        K := 13;
        for I := 0 to Lines.Count-1 do begin
                if Lines.Strings[ I ] = '' then begin
                        SetByte( K, 0 );
                        Inc( K, 1 );
                end
                else begin
                        SetAsciiString( Lines.Strings[ I ], K, Length( Lines.Strings[ I ] )+1 );
                        K := K + Length( Lines.Strings[ I ] )+1;
                end;
        end;
end;

constructor TUpdateBook.Create;
begin
        inherited Create( $93, 99 );
        SetLongWord( 5, 0 );
end;

procedure TUpdateBook.SetSerial( Serial : LongWord );
begin
        SetLongWOrd( 1, Serial );
end;

procedure TUpdateBook.SetTitle( Title : String );
begin
        SetAsciiString( Title, 9, 60 );
end;

procedure TUpdateBook.SetAuthor( Author : String );
begin
        SetAsciiString( Author, 69, 30 );
end;

constructor MEFightGumpResponse.Create;
begin
        inherited Create( $F5, 9 );
        SetWord( 1, 9 );
        SetByte( 3, 9 );
        SetByte( 4, 2 );
end;

procedure MEFightGumpResponse.SetTrefferZone( TrefferZone : Byte );
begin
        SetByte( 5, TrefferZone );
end;

procedure MEFightGumpResponse.SetKampfModus( KampfModus : Byte );
begin
        SetByte( 6, KampfModus );
end;

procedure MEFightGumpResponse.SetKampfGeschwindigkeit( KampfGeschwindigkeit : Byte );
begin
        SetByte( 7, KampfGeschwindigkeit );
end;

procedure MEFightGumpResponse.SetAusweichen( Ausweichen : Byte );
begin
        SetByte( 8, Ausweichen );
end;

constructor MEOpenFightGumpRequest.Create;
begin
        inherited Create( $F5, 5 );
        SetWord( 1, 5 );
        SetByte( 3, 9 );
        SetByte( 4, 4 );
end;

end.
