unit ubTree;

interface

const   bitTable:       array[ 0..256, 0..1 ] of Word = (
  ($02, $00), ($05, $1F), ($06, $22), ($07, $34),
  ($07, $75), ($06, $28), ($06, $3B), ($07, $32),
  ($08, $E0), ($08, $62), ($07, $56), ($08, $79),
  ($09, $19D), ($08, $97), ($06, $2A), ($07, $57),
  ($08, $71), ($08, $5B), ($09, $1CC), ($08, $A7),
  ($07, $25), ($07, $4F), ($08, $66), ($08, $7D),
  ($09, $191), ($09, $1CE), ($07, $3F), ($09, $90),
  ($08, $59), ($08, $7B), ($08, $91), ($08, $C6),
  ($06, $2D), ($09, $186), ($08, $6F), ($09, $93),
  ($0A, $1CC), ($08, $5A), ($0A, $1AE), ($0A, $1C0),
  ($09, $148), ($09, $14A), ($09, $82), ($0A, $19F),
  ($09, $171), ($09, $120), ($09, $E7), ($0A, $1F3),
  ($09, $14B), ($09, $100), ($09, $190), ($06, $13),
  ($09, $161), ($09, $125), ($09, $133), ($09, $195),
  ($09, $173), ($09, $1CA), ($09, $86), ($09, $1E9),
  ($09, $DB), ($09, $1EC), ($09, $8B), ($09, $85),
  ($05, $0A), ($08, $96), ($08, $9C), ($09, $1C3),
  ($09, $19C), ($09, $8F), ($09, $18F), ($09, $91),
  ($09, $87), ($09, $C6), ($09, $177), ($09, $89),
  ($09, $D6), ($09, $8C), ($09, $1EE), ($09, $1EB),
  ($09, $84), ($09, $164), ($09, $175), ($09, $1CD),
  ($08, $5E), ($09, $88), ($09, $12B), ($09, $172),
  ($09, $10A), ($09, $8D), ($09, $13A), ($09, $11C),
  ($0A, $1E1), ($0A, $1E0), ($09, $187), ($0A, $1DC),
  ($0A, $1DF), ($07, $74), ($09, $19F), ($08, $8D),
  ($08, $E4), ($07, $79), ($09, $EA), ($09, $E1),
  ($08, $40), ($07, $41), ($09, $10B), ($09, $B0),
  ($08, $6A), ($08, $C1), ($07, $71), ($07, $78),
  ($08, $B1), ($09, $14C), ($07, $43), ($08, $76),
  ($07, $66), ($07, $4D), ($09, $8A), ($06, $2F),
  ($08, $C9), ($09, $CE), ($09, $149), ($09, $160),
  ($0A, $1BA), ($0A, $19E), ($0A, $39F), ($09, $E5),
  ($09, $194), ($09, $184), ($09, $126), ($07, $30),
  ($08, $6C), ($09, $121), ($09, $1E8), ($0A, $1C1),
  ($0A, $11D), ($0A, $163), ($0A, $385), ($0A, $3DB),
  ($0A, $17D), ($0A, $106), ($0A, $397), ($0A, $24E),
  ($07, $2E), ($08, $98), ($0A, $33C), ($0A, $32E),
  ($0A, $1E9), ($09, $BF), ($0A, $3DF), ($0A, $1DD),
  ($0A, $32D), ($0A, $2ED), ($0A, $30B), ($0A, $107),
  ($0A, $2E8), ($0A, $3DE), ($0A, $125), ($0A, $1E8),
  ($09, $E9), ($0A, $1CD), ($0A, $1B5), ($09, $165),
  ($0A, $232), ($0A, $2E1), ($0B, $3AE), ($0B, $3C6),
  ($0B, $3E2), ($0A, $205), ($0A, $29A), ($0A, $248),
  ($0A, $2CD), ($0A, $23B), ($0B, $3C5), ($0A, $251),
  ($0A, $2E9), ($0A, $252), ($09, $1EA), ($0B, $3A0),
  ($0B, $391), ($0A, $23C), ($0B, $392), ($0B, $3D5),
  ($0A, $233), ($0A, $2CC), ($0B, $390), ($0A, $1BB),
  ($0B, $3A1), ($0B, $3C4), ($0A, $211), ($0A, $203),
  ($09, $12A), ($0A, $231), ($0B, $3E0), ($0A, $29B),
  ($0B, $3D7), ($0A, $202), ($0B, $3AD), ($0A, $213),
  ($0A, $253), ($0A, $32C), ($0A, $23D), ($0A, $23F),
  ($0A, $32F), ($0A, $11C), ($0A, $384), ($0A, $31C),
  ($0A, $17C), ($0A, $30A), ($0A, $2E0), ($0A, $276),
  ($0A, $250), ($0B, $3E3), ($0A, $396), ($0A, $18F),
  ($0A, $204), ($0A, $206), ($0A, $230), ($0A, $265),
  ($0A, $212), ($0A, $23E), ($0B, $3AC), ($0B, $393),
  ($0B, $3E1), ($0A, $1DE), ($0B, $3D6), ($0A, $31D),
  ($0B, $3E5), ($0B, $3E4), ($0A, $207), ($0B, $3C7),
  ($0A, $277), ($0B, $3D4), ($08, $C0), ($0A, $162),
  ($0A, $3DA), ($0A, $124), ($0A, $1B4), ($0A, $264),
  ($0A, $33D), ($0A, $1D1), ($0A, $1AF), ($0A, $39E),
  ($0A, $24F), ($0B, $373), ($0A, $249), ($0B, $372),
  ($09, $167), ($0A, $210), ($0A, $23A), ($0A, $1B8),
  ($0B, $3AF), ($0A, $18E), ($0A, $2EC), ($07, $62),
  ($04, $0D) );

type    TbTree = Class
                public
                        Zero, One: TbTree;
                        Value: Word;
                        Hit: Boolean;
                        constructor Create;
                        destructor Destroy; override;
        end;

implementation

constructor TbTree.Create;
begin
        Hit := False;
        Zero := nil;
        One := nil;
end;

destructor TbTree.Destroy;
begin
        Zero.Free;
        One.Free;
end;

end.
 