program Palanthir;

uses
  Forms,
  SysUtils,
  Dialogs,
  Windows,
  uBasicTypedefs in 'uBasicTypedefs.pas',
  uBitMask in 'uBitMask.pas',
  uChar in 'uChar.pas',
  uConfig in 'uConfig.pas',
  uCursors in 'uCursors.pas',
  uData in 'uData.pas',
  uEffect in 'uEffect.pas',
  uItem in 'uItem.pas',
  uItemAnimCache in 'uItemAnimCache.pas',
  uKeyboard in 'uKeyboard.pas',
  uLog in 'uLog.pas',
  uMausHandler in 'uMausHandler.pas',
  uMovement in 'uMovement.pas',
  uObjectListe in 'uObjectListe.pas',
  uPalanthir in 'uPalanthir.pas',
  uPlayer in 'uPlayer.pas',
  uPos in 'uPos.pas',
  uRenderer in 'uRenderer.pas',
  uScreenShot in 'uScreenShot.pas',
  uShard in 'uShard.pas',
  uSoundManager in 'uSoundManager.pas',
  uTexCache in 'uTexCache.pas',
  uUObject in 'uUObject.pas',
  uUtilities in 'uUtilities.pas',
  uVertexCache in 'uVertexCache.pas',
  uWorldCache in 'uWorldCache.pas',
  uClientForm in '..\Forms\uClientForm.pas' {ClientForm},
  md5 in '..\Network\MD5.pas',
  uClient in '..\Network\uClient.pas',
  uCryptGameTwofish in '..\Network\uCryptGameTwofish.pas',
  uCryptLogin in '..\Network\uCryptLogin.pas',
  uCryptLoginKeys in '..\Network\uCryptLoginKeys.pas',
  uNetwork in '..\Network\uNetwork.pas',
  uPacket in '..\Network\uPacket.pas',
  uRecievePackets in '..\Network\uRecievePackets.pas',
  uSendPackets in '..\Network\uSendPackets.pas',
  ubTree in '..\Network\ubTree.pas',
  uLoaderAnimations in '..\DataLoader\uLoaderAnimations.pas',
  uLoaderAnimdata in '..\DataLoader\uLoaderAnimdata.pas',
  uLoaderArt in '..\DataLoader\uLoaderArt.pas',
  uLoaderCliloc in '..\DataLoader\uLoaderCliloc.pas',
  uLoaderFonts in '..\DataLoader\uLoaderFonts.pas',
  uLoaderGump in '..\DataLoader\uLoaderGump.pas',
  uLoaderHues in '..\DataLoader\uLoaderHues.pas',
  uLoaderMap in '..\DataLoader\uLoaderMap.pas',
  uLoaderTexturen in '..\DataLoader\uLoaderTexturen.pas',
  uLoaderTiledata in '..\DataLoader\uLoaderTiledata.pas',
  uLoaderUnicodeFonts in '..\DataLoader\uLoaderUnicodeFonts.pas',
  uLoaderSounds in '..\DataLoader\uLoaderSounds.pas',
  uLoaderRadarcol in '..\DataLoader\uLoaderRadarcol.pas',
  uLoaderSpeech in '..\DataLoader\uLoaderSpeech.pas',
  uLoaderLight in '..\DataLoader\uLoaderLight.pas',
  uCustomGumps in '..\Gumps\uCustomGumps.pas',
  uGumps in '..\Gumps\uGumps.pas',
  uJournal in '..\Gumps\uJournal.pas',
  uSecureTrading in '..\Gumps\uSecureTrading.pas',
  uSpecialGumps in '..\Gumps\uSpecialGumps.pas',
  uBuyWindow in '..\Gumps\uBuyWindow.pas',
  uSellWindow in '..\Gumps\uSellWindow.pas',
  uLoaderMP3 in 'uLoaderMP3.pas',
  uLightManager in 'uLightManager.pas',
  uPixelBuffer in 'uPixelBuffer.pas',
  uRadar in 'uRadar.pas',
  uSpeech in 'uSpeech.pas',
  uSecretUtility in 'uSecretUtility.pas',
  uVector in 'uVector.pas',
  uRadarCache in 'uRadarCache.pas',
  uLoaderMultis in '..\DataLoader\uLoaderMultis.pas',
  uSpecialRadar in '..\Gumps\uSpecialRadar.pas',
  uParty in 'uParty.pas',
  uProfile in '..\Gumps\uProfile.pas',
  uBasicDrawObject in 'uBasicDrawObject.pas',
  uCounter in 'uCounter.pas',
  uCharCreation in '..\Gumps\uCharCreation.pas',
  uPartyGump in '..\Gumps\uPartyGump.pas',
  uLoaderVerdata in '..\DataLoader\uLoaderVerdata.pas',
  uTimer in 'uTimer.pas',
  uMEProfile in '..\Gumps\uMEProfile.pas',
  uBook in '..\Gumps\uBook.pas',
  uMulCrypt in 'uMulCrypt.pas',
  uFightGump in 'uFightGump.pas',
  uCheckRunning in 'uCheckRunning.pas',
  uScriptManager in 'uScriptManager.pas',
  uPyPalanthir in '..\Python\uPyPalanthir.pas',
  uPythonScript in 'uPythonScript.pas',
  uPyPacket in '..\Python\uPyPacket.pas',
  uPyUtilities in '..\Python\uPyUtilities.pas',
  uPythonGump in '..\Gumps\uPythonGump.pas',
  uPyGump in '..\Python\uPyGump.pas',
  uPythonFunction in 'uPythonFunction.pas',
  uPyGumpObject in '..\Python\uPyGumpObject.pas',
  uPyChar in '..\Python\uPyChar.pas',
  uTooltip in 'uTooltip.pas',
  uPyItem in '..\Python\uPyItem.pas',
  uPyPos in '..\Python\uPyPos.pas',
  uPyMap in '..\Python\uPyMap.pas',
  uPyStatic in '..\Python\uPyStatic.pas',
  uPyMouse in '..\Python\uPyMouse.pas',
  uPyUODrawObject in '..\Python\uPyUODrawObject.pas',
  XMLLib in '..\xml\XMLLib.pas',
  StrAdapter in '..\xml\StrAdapter.pas',
  StrAdapterBase in '..\xml\StrAdapterBase.pas',
  StrAdapterDefault in '..\xml\StrAdapterDefault.pas',
  StrAdapterISO8859_1 in '..\xml\StrAdapterISO8859_1.pas',
  StrAdapterUTF_8 in '..\xml\StrAdapterUTF_8.pas',
  uPyConfig in '..\Python\uPyConfig.pas',
  uLoaderIntloc in '..\DataLoader\uLoaderIntloc.pas',
  uGestureHandler in 'uGestureHandler.pas',
  uPyKeyboard in '..\Python\uPyKeyboard.pas',
  uLoaderSkills in '..\DataLoader\uLoaderSkills.pas',
  uLoaderProgress in '..\DataLoader\uLoaderProgress.pas',
  uByteCache in 'uByteCache.pas',
  uBaseRenderer in 'uBaseRenderer.pas',
  uOpenGLRenderer in 'uOpenGLRenderer.pas',
  uGeometry in 'uGeometry.pas';

{$R *.res}

var     Console : Boolean;
        I : Integer;

begin
        if ParamCount = 0 then begin
                ShowMessage( 'Start Client.exe instead of Palanthir.exe.' );
                Halt;
        end;

        Console := False;
        for I := 1 to ParamCount do begin
                if ParamStr( I ) = '-console' then begin
                        Console := True;
                        Break;
                end;
        end;

        uCounter.Counter := TCounter.Create;
        uLog.Log := TLog.Create( ExtractFilePath( Application.ExeName ) + 'log.txt', ExtractFilePath( Application.ExeName ) + 'log\', Console );
        if not uLog.Log.Init then begin
                uLog.Log.Free;
                ShowMessage( Format( 'Could not open %slog.txt', [ExtractFilePath( Application.ExeName )] ) );
                exit;                
        end;
        uTimer.Timer := TInternalTimer.Create;
        uConfig.Config := TConfig.Create;
        try
                uConfig.Config.Load( ExtractFilePath( Application.ExeName ) + 'config.xml' );
        except
                ShowMessage( Format( 'Could not open %sconfig.xml', [ExtractFilePath( Application.ExeName )] ) );
                exit;
        end;

        Application.Initialize;
        Application.Title := 'Ultima Online';
        Application.ShowMainForm := False;
        Application.CreateForm(TClientForm, ClientForm);
  Application.Run;

        uConfig.Config.Free;
        uTimer.Timer.Free;
        uLog.Log.Free;
        uCounter.Counter.Free;
end.
