unit uBaseRenderer;

interface

uses    SysUtils, uByteCache, uBitMask, uUtilities, uLog, uGeometry;

type    TBaseRenderer = Class;
        TBasePixelBuffer = Class;

        TBaseWindow = Class
                private
                        procedure SetRenderer( vRenderer : TBaseRenderer );
                protected
                        mAllowResize : Boolean;
                        mRenderer : TBaseRenderer;
                        mHeight : Word;
                        mInitialized : Boolean;
                        mWidth : Word;
                public
                        property pHeight : Word read mHeight;
                        property pInitialized : Boolean read mInitialized;
                        property pWidth : Word read mWidth;
                        property pRenderer : TBaseRenderer read mRenderer write SetRenderer;
                        constructor Create( vFullScreen : Boolean ); virtual;
                        destructor Free; virtual;
                        procedure SetSize( vWidth, vHeight : Word ); virtual;
                        procedure AllowResize( vAllowResize : Boolean ); virtual;
                        procedure SetCaption( vCaption : String ); virtual;
                        procedure BringToFront; virtual;
                        function Poll : Boolean; virtual;
        end;

        TBaseTexture = Class
                protected
                        mBitMask : TBitMask;
                        mCount : LongWord;
                        mFrame : Word;
                        mHasAlpha : Boolean;
                        mHeight : Word;
                        mHue : Word;
                        mLoading : Boolean;
                        mId : LongWord;
                        mType : Byte;
                        mWidth : Word;
                        mZeroTime : LongWord;
                public
                        property pCount : LongWord read mCount;
                        property pFrame : Word read mFrame;
                        property pHasAlpha : Boolean read mHasAlpha;
                        property pHeight : Word read mHeight;
                        property pHue : Word read mHue;
                        property pId : LongWord read mId;
                        property pType : Byte read mType;
                        property pWidth : Word read mWidth;
                        property pZeroTime : LongWord read mZeroTime write mZeroTime;
                        constructor Create( vType : Byte ); virtual;
                        destructor Free; virtual;
                        procedure Init( vId : LongWord; vHue : LongWord; vFrame : Word; vLoading : Boolean );
                        function Load( vByteCache : TByteCache; vHasAlpha : Boolean = False ) : Boolean; virtual;
                        procedure DecCount;
                        procedure IncCount;
        end;

        TTextureArray = array[0..High(Word)] of TBaseTexture;
        PTextureArray = ^TTextureArray;

        TBaseRenderer = Class
                protected
                        mWindow : TBaseWindow;
                        mWidth, mHeight : Word;
                public
                        property pWidth : Word read mWidth;
                        property pHeight : Word read mHeight;
                        constructor Create( vWindow : TBaseWindow ); virtual;
                        destructor Free; virtual;
                        procedure SetSize( vWidth, vHeight : Word ); virtual;
                        procedure StartDraw; virtual;
                        procedure FinishDraw; virtual;
                        function CreateTexture( vType : Byte ) : TBaseTexture; virtual;
                        function DrawTexture( vTex : TBaseTexture; vCoord : TRect3D; vTexCoord : TRect2D ) : Boolean; virtual;
                        function DrawRectangle( vCoord : TRect3D; vRed, vGreen, vBlue : Byte; vAlpha : Byte = 255 ) : Boolean; virtual;
                        procedure AddBoundingBox( vRect : TRect2D ); virtual;
                        procedure RemoveLastBoundingBox; virtual;
                        procedure EnablePixelBuffer( PixelBuffer : TBasePixelBuffer ); virtual;
                        procedure DisablePixelBuffer( PixelBuffer : TBasePixelBuffer ); virtual;
                        procedure BindPixelBuffer( PixelBuffer : TBasePixelBuffer ); virtual;
                        procedure ReleasePixelBuffer( PixelBuffer : TBasePixelBuffer ); virtual;
        end;

        TBasePixelBuffer = Class
                protected
                        mBitMask : TBitMask;
                        mRenderer : TBaseRenderer;
                        mWidth, mHeight : Word;
                        mRelX, mRelY : Integer;
                public
                        property pBitMask : TBitMask read mBitMask;
                        property pWidth : Word read mWidth;
                        property pHeight : Word read mHeight;
                        property pRelX : Integer read mRelX write mRelX;
                        property pRelY : Integer read mRelY write mRelY;
                        constructor Create( vWidth, vHeight : Word; vRenderer : TBaseRenderer ); virtual;
                        destructor Free; virtual;
                        procedure Enable; virtual;
                        procedure Disable; virtual;
                        procedure Bind; virtual;
                        procedure Release; virtual;
                        function Init : Boolean; virtual;
        end;

implementation

procedure TBaseWindow.SetRenderer( vRenderer : TBaseRenderer );
begin
        if mRenderer = nil then begin
                mRenderer := vRenderer;
        end else begin
                Log.Write( 'Renderer of basewindow already set.' );
        end;
end;

constructor TBaseWindow.Create( vFullScreen : Boolean );
begin
        mAllowResize := False;
        mWidth := 640;
        mHeight := 480;
        mInitialized := False;
        mRenderer := nil;
end;

destructor TBaseWindow.Free;
begin
end;

procedure TBaseWindow.SetSize( vWidth, vHeight : Word );
begin
end;

procedure TBaseWindow.AllowResize( vAllowResize : Boolean );
begin
end;

procedure TBaseWindow.SetCaption( vCaption : String );
begin
end;

procedure TBaseWindow.BringToFront;
begin
end;

function TBaseWindow.Poll : Boolean;
begin
        Result := False;
end;

constructor TBaseTexture.Create( vType : Byte );
begin
        mType := vType;

        //default values
        mBitMask := TBitMask.Create;
        mCount := 0;
        mFrame := 0;
        mHasAlpha := False;
        mHeight := 0;
        mHue := 0;
        mLoading := False;
        mId := 0;
        mWidth := 0;
end;

destructor TBaseTexture.Free;
begin
end;

procedure TBaseTexture.Init( vId : LongWord; vHue : LongWord; vFrame : Word; vLoading : Boolean );
begin
        mFrame := vFrame;
        mHue := vHue;
        mId := vId;
        mLoading := vLoading;
end;

function TBaseTexture.Load( vByteCache : TByteCache; vHasAlpha : Boolean ) : Boolean;
begin
        Result := False;
end;

procedure TBaseTexture.DecCount;
begin
        if mCount > 0 then begin
                Dec( mCount );
        end;

        if mCount = 0 then begin
                mZeroTime := CustomGetTickCount;
        end;
end;

procedure TBaseTexture.IncCount;
begin
        Inc( mCount );
end;

constructor TBaseRenderer.Create( vWindow : TBaseWindow );
begin
        mWindow := vWindow;
        mWidth := vWindow.pWidth;
        mHeight := vWindow.pHeight;
end;

destructor TBaseRenderer.Free;
begin
end;

procedure TBaseRenderer.SetSize( vWidth, vHeight : Word );
begin
        mWidth := vWidth;
        mHeight := vHeight;
end;

procedure TBaseRenderer.StartDraw;
begin
end;

procedure TBaseRenderer.FinishDraw;
begin
end;

function TBaseRenderer.CreateTexture( vType : Byte ) : TBaseTexture;
begin
        Result := nil;
end;

function TBaseRenderer.DrawTexture( vTex : TBaseTexture; vCoord : TRect3D; vTexCoord : TRect2D ) : Boolean;
begin
        Result := False;
end;

function TBaseRenderer.DrawRectangle( vCoord : TRect3D; vRed, vGreen, vBlue, vAlpha : Byte ) : Boolean;
begin
        Result := False;
end;

procedure TBaseRenderer.AddBoundingBox( vRect : TRect2D );
begin
end;

procedure TBaseRenderer.RemoveLastBoundingBox;
begin
end;

procedure TBaseRenderer.EnablePixelBuffer( PixelBuffer : TBasePixelBuffer );
begin
end;

procedure TBaseRenderer.DisablePixelBuffer( PixelBuffer : TBasePixelBuffer );
begin
end;

procedure TBaseRenderer.BindPixelBuffer( PixelBuffer : TBasePixelBuffer );
begin
end;

procedure TBaseRenderer.ReleasePixelBuffer( PixelBuffer : TBasePixelBuffer );
begin
end;

constructor TBasePixelBuffer.Create( vWidth, vHeight : Word; vRenderer : TBaseRenderer );
begin
        mHeight := vHeight;
        mWidth := vWidth;
        mRenderer := vRenderer;
        mRelX := 0;
        mRelY := 0;
        mBitMask := nil;
end;

destructor TBasePixelBuffer.Free;
begin
        if mBitMask <> nil then begin
            mBitMask.Free;
        end;
end;

procedure TBasePixelBuffer.Enable;
begin
end;

procedure TBasePixelBuffer.Disable;
begin
end;

procedure TBasePixelBuffer.Bind;
begin
end;

procedure TBasePixelBuffer.Release;
begin
end;

function TBasePixelBuffer.Init : Boolean;
begin
        Result := False;
end;

end.
