unit uBasicTypedefs;

interface

uses    Classes, SysUtils, uPos, uTexCache, uRenderer, dglOpenGL,
        uLoaderTiledata, uLog, uUtilities, uSpeech, uVector, uBasicDrawObject,
        uCounter, uTimer, Dialogs, Python, uLightManager;

const   typ_none = 0;
        typ_corpse = 2;
        typ_char = 3;
        typ_player = 4;
        typ_map = 5;
        typ_map_stretched = 6;
        typ_static = 7;
        typ_multiitem = 8;
        typ_item = 9;
        typ_effect = 10;

        Flag_Debug = $0001;
        Flag_Chicken = $0002;

type    TUODrawObject = Class( TBasicDrawObject )
                protected
                        _Color, _ID, _DrawID : Word;
                        function GetLightColor : Word;
                        procedure SetID( NewID : Word ); virtual;
                        procedure SetColor( NewColor : Word ); virtual;
                        procedure SetDrawID( NewDrawID : Word ); virtual;
                        function GetBlockID : Integer;
                public
                        CustomVars : PPyObject;
                        Flags : Word;
                        IsInDrawList : Boolean;
                        NumberInList : LongWord;
                        Pos : TPos;
                        Speech : TSpeech;
                        Texture : TTexObject;
                        Typ : Byte;
                        Light : TLight;
                        property LightColor : Word read GetLightColor;                        
                        property ID : Word read _ID write SetID;
                        property Color : Word read _Color write SetColor;
                        property DrawID : Word read _DrawID write SetDrawID;
                        property BlockID : Integer read GetBlockID;
                        procedure GetTexture; virtual;
                        procedure UpdateTexture; virtual;                        
                        constructor Create; override;
                        destructor Free; override;
                        function IsUODrawObject : Boolean; override;
                        procedure Draw; virtual;
                        procedure OnClick; virtual;
                        procedure OnDblClick; virtual;
                        function IsVisible : Boolean; virtual;
                        function IsMap : Boolean; virtual;
                        function IsStatic : Boolean; virtual;
                        function IsUObject : Boolean; virtual;
                        function IsItem : Boolean; virtual;
                        function IsChar : Boolean; virtual;
                        function IsPlayer : Boolean; virtual;
                        function IsEffect : Boolean; virtual;
                        function IsMultiItem : Boolean; virtual;
                        function HasFlag( Flag : Word ) : Boolean;
                        procedure SetFlag( Flag : Word );
                        procedure RemoveFlag( Flag : Word );
                        procedure SetPos( X, Y : Word; Z : ShortInt );
        end;

        P_UODrawObject = ^TUODrawObject;

        TMapCell = packed record
                Id: Word;
                Z: Shortint;
        end;

        TMapBlock = packed record
                Header: Cardinal;
                Cells: Array[0..63] of TMapCell;
        end;

        TMapItem = Class( TUODrawObject )
                private
                        TextureChanged : Boolean;
                protected
                        procedure SetID( NewID : Word ); override;
                        procedure SetColor( NewColor : Word ); override;
                        procedure SetDrawID( NewDrawID : Word ); override;
                public
                        ZLevelChanged : Boolean;
                        Normals : Array[0..3] of TVector;
                        Z2, Z3, Z4 : ShortInt;
                        constructor Create; override;
                        destructor Free; override;
                        procedure GetTexture; override;
                        procedure Draw; override;
                        procedure OnClick; override;
                        function IsVisible : Boolean; override;
                        function IsMap : Boolean; override;
                        function IsStretched : Boolean;
                        procedure Update;
        end;

        P_MapItem = ^TMapItem;

        TMapListe = array[0..1] of TMapItem;

        PMapListe = ^TMapListe;

        TStaticItem = Class( TUODrawObject )
                private
                        TextureChanged : Boolean;
                protected                        
                        procedure SetID( NewID : Word ); override;
                        procedure SetColor( NewColor : Word ); override;
                        procedure SetDrawID( NewDrawID : Word ); override;        
                public
                        Index : Word;
                        constructor Create; override;
                        destructor Free; override;
                        procedure GetTexture; override;
                        procedure Draw; override;
                        procedure OnClick; override;
                        function IsVisible : Boolean; override;
                        function IsStatic : Boolean; override;
                        procedure MoveTo( X, Y : Word; Z : ShortInt; Map : Byte );                       
        end;

        P_StaticItem = ^TStaticItem;

        TStaticListe = array[0..1] of TStaticItem;

        PStaticListe = ^TStaticListe;
        
implementation

uses    uPalanthir, uUObject, uItem;

procedure TUODrawObject.SetID( NewID : Word );
begin
        if _ID <> NewID then begin
                _ID := NewID;
                UpdateTexture;
        end;
end;

procedure TUODrawObject.SetColor( NewColor : Word );
begin
        if _Color <> NewColor then begin
                _Color := NewColor;
                UpdateTexture;
        end;
end;

procedure TUODrawObject.SetDrawID( NewDrawID : Word );
begin
        if _DrawID <> NewDrawID then begin
                _DrawID := NewDrawID;
                UpdateTexture;
        end;
end;

function TUODrawObject.GetBlockID : Integer;
begin
        Result := Pos.GetBlockID;
end;

function TUODrawObject.GetLightColor : Word;
begin
        Result := Palanthir.Shard.GetLightColor( Id );
end;

procedure TUODrawObject.UpdateTexture;
var     BreiteAlt, HoeheAlt : Word;
        BreiteNeu, HoeheNeu : Word;
begin
        if Texture <> nil then begin
                BreiteAlt := Texture.Breite;
                HoeheAlt := Texture.Hoehe;
        end
        else begin
                BreiteAlt := 0;
                HoeheAlt := 0;
        end;

        GetTexture;

        if Texture <> nil then begin
                BreiteNeu := Texture.Breite;
                HoeheNeu := Texture.Hoehe;
        end
        else begin
                BreiteNeu := 0;
                HoeheNeu := 0;
        end;

        if (BreiteNeu <> BreiteAlt) or (HoeheNeu <> HoeheAlt) then begin
                if Palanthir.Data.WorldCache.BlockIsVisible( BlockID ) then begin
                        if IsInDrawList then begin
                                if not IsVisible then
                                        Palanthir.RemoveWorldItem( Self );
                        end
                        else begin
                                if IsVisible then
                                        Palanthir.AddWorldItem( Self );
                        end;
                end;
        end;
end;

procedure TUODrawObject.GetTexture;
begin
end;

constructor TUODrawObject.Create;
begin
        inherited Create;

        CustomVars := nil;

        Pos := TPos.Create;
        Pos.Map := Palanthir.CurrentMap;

        Id := 0;
        Color := 0;
        Flags := 0;
        IsInDrawList := False;
        Texture := nil;
        Speech := nil;
        Light := nil;
end;

destructor TUODrawObject.Free;
begin
        if CustomVars <> nil then begin
                Py_XDECREF( CustomVars );
                CustomVars := nil;
        end;

        Palanthir.RemoveFromDebugList( Self );
        
        if Speech <> nil then begin
                Palanthir.RemoveSpeech( Speech );
                Speech.Free;
        end;

        Texture := nil;
        Pos.Free;

        if Light <> nil then begin
                Palanthir.LightManager.RemoveLight( Light );
        end;

        inherited Free;
end;

function TUODrawObject.IsUODrawObject : Boolean;
begin
        Result := True;
end;

procedure TUODrawObject.Draw;
begin
end;

procedure TUODrawObject.OnClick;
begin
end;

procedure TUODrawObject.OnDblClick;
begin
end;

function TUODrawObject.IsVisible : Boolean;
begin
        Result := False;
end;

function TUODrawObject.IsMap : Boolean;
begin
        Result := False;
end;

function TUODrawObject.IsStatic : Boolean;
begin
        Result := False;
end;

function TUODrawObject.IsUObject : Boolean;
begin
        Result := False;
end;

function TUODrawObject.IsItem : Boolean;
begin
        Result := False;
end;

function TUODrawObject.IsChar : Boolean;
begin
        Result := False;
end;

function TUODrawObject.IsPlayer : Boolean;
begin
        Result := False;
end;

function TUODrawObject.IsEffect : Boolean;
begin
        Result := False;
end;

function TUODrawObject.IsMultiItem : Boolean;
begin
        Result := False;
end;

function TUODrawObject.HasFlag( Flag : Word ) : Boolean;
begin
        Result := Flags and Flag = Flag;
end;

procedure TUODrawObject.SetFlag( Flag : Word );
begin
        Flags := Flags or Flag;
end;

procedure TUODrawObject.RemoveFlag( Flag : Word );
begin
        Flags := Flags and not Flag;
end;

procedure TUODrawObject.SetPos( X, Y : Word; Z : ShortInt );
begin
        Pos.SetPos( X, Y, Z );
end;

procedure TMapItem.SetID( NewID : Word );
begin
        _ID := NewID;
        TextureChanged := True;
end;

procedure TMapItem.SetColor( NewColor : Word );
begin
        _Color := NewColor;
        TextureChanged := True;
end;

procedure TMapItem.SetDrawID( NewDrawID : Word );
begin
        _DrawId := NewDrawId;
        TextureChanged := True;
end;

constructor TMapItem.Create;
var     I : Integer;
begin
        inherited Create;
        Typ := typ_map;
        TextureChanged := False;
        ZLevelChanged := False;

        for I := 0 to 3 do
                Normals[ I ] := TVector.Create( 0, 0, 0 );

        Counter.IncCount( Count_Map );
end;

destructor TMapItem.Free;
var     I : Integer;
begin
        Counter.DecCount( Count_Map );

        for I := 0 to 3 do
                Normals[ I ].Free;

        if Texture <> nil then
                Palanthir.Data.DecMapArt( Texture.ID, Texture.Hue );

        inherited Free;
end;

procedure TMapItem.GetTexture;
begin
        if IsStretched then begin
                Texture := Palanthir.Data.GetTextureTexture( ID, Color );

                if Texture = nil then begin
                        exit;
                end;
        end
        else begin
                if Texture <> nil then begin
                        Palanthir.Data.DecMapArt( Texture.ID, Texture.Hue );
                end;

                Texture := Palanthir.Data.GetMapArt( ID, Color );

                if Texture <> nil then
                        Palanthir.Data.IncMapArt( Texture.ID, Texture.Hue );

                if Texture = nil then begin
                        exit;
                end;
        end;
end;

procedure TMapItem.Draw;
var     PosX, PosY : Integer;
        X0, Y0, X1, Y1, X2, Y2, X3, Y3 : Integer;
begin
        if not Palanthir.DrawMap then begin
                exit;
        end;

        if TextureChanged then begin
                TextureChanged := False;
                GetTexture;
        end;

        if ZLevelChanged then begin
                ZLevelChanged := False;
                Update;
        end;
        
        if Palanthir.IsUnderMap then begin
                if Palanthir.UnderMapOsiMode and ( Pos.Z >= Palanthir.Player.Pos.Z+15 ) then begin
                        exit;
                end
                else if (not Palanthir.UnderMapOsiMode) then begin 
                        exit;
                end;
        end;

        if Palanthir.DebugMode and HasFlag( Flag_Debug ) then
                exit;

        if Texture = nil then
                exit;

        Timer.Continue( Timer_AllMap );
        Timer.Start( Timer_Map );

        if IsStretched then begin
                Timer.Continue( Timer_Renderer );
                PosX := Palanthir.RelDrawX + (Pos.X - Pos.Y) * 22;
                PosY := Palanthir.RelDrawY + (Pos.X + Pos.Y) * 22;

                X0 := 0;
                Y0 := 0 - Pos.Z*4;
                X1 := -22;
                Y1 := 22 - Z3*4;
                X2 := 0;
                Y2 := 44 - Z4*4;
                X3 := 22;
                Y3 := 22 - Z2*4;

                if Renderer.CurrentTexID <> Texture.TexID then begin
                        Renderer.CurrentTexID := Texture.TexID;
                        glBindTexture( GL_TEXTURE_2D, Texture.TexID );
                end;

                glColor3f( 1, 1, 1 );
                glEnable( GL_LIGHTING );

                Timer.Continue( Timer_Draw );
                glBegin( gl_Quads );
                        glNormal3f( Normals[ 0 ].X, Normals[ 0 ].Y, Normals[ 0 ].Z );
                        gltexcoord2f( 0, 0 );
                        glvertex2f( PosX + X0, PosY + Y0 );
                        glNormal3f( Normals[ 3 ].X, Normals[ 3 ].Y, Normals[ 3 ].Z );
                        gltexcoord2f( 0, 1 );
                        glvertex2f( PosX + X1, PosY + Y1 );
                        glNormal3f( Normals[ 2 ].X, Normals[ 2 ].Y, Normals[ 2 ].Z );
                        gltexcoord2f( 1, 1 );
                        glvertex2f( PosX + X2, PosY + Y2 );
                        glNormal3f( Normals[ 1 ].X, Normals[ 1 ].Y, Normals[ 1 ].Z );
                        gltexcoord2f( 1, 0 );
                        glvertex2f( PosX + X3, PosY + Y3 );
                glEnd;
                Timer.Pause( Timer_Draw );

                {glBegin( GL_TRIANGLES );
			glNormal3f( Normals[ 2 ].X, Normals[ 2 ].Y, Normals[ 2 ].Z );
			gltexcoord2f( 1, 1 );
                        glvertex2f( PosX + X2, PosY + Y2 );
			glNormal3f( Normals[ 3 ].X, Normals[ 3 ].Y, Normals[ 3 ].Z );
                        gltexcoord2f( 0, 1 );
                        glvertex2f( PosX + X1, PosY + Y1 );
			glNormal3f( Normals[ 0 ].X, Normals[ 0 ].Y, Normals[ 0 ].Z );
                        gltexcoord2f( 0, 0 );
                        glvertex2f( PosX + X0, PosY + Y0 );

			glNormal3f( Normals[ 0 ].X, Normals[ 0 ].Y, Normals[ 0 ].Z );
                        gltexcoord2f( 0, 0 );
                        glvertex2f( PosX + X0, PosY + Y0 );
			glNormal3f( Normals[ 1 ].X, Normals[ 1 ].Y, Normals[ 1 ].Z );
                        gltexcoord2f( 1, 0 );
                        glvertex2f( PosX + X3, PosY + Y3 );
			glNormal3f( Normals[ 2 ].X, Normals[ 2 ].Y, Normals[ 2 ].Z );
                        gltexcoord2f( 1, 1 );
                        glvertex2f( PosX + X2, PosY + Y2 );
                glEnd();}

                glDisable( GL_LIGHTING );

                Timer.Pause( Timer_Renderer );

                Palanthir.Maus.CheckObject( PosX, PosY, X0, Y0, X1, Y1, X2, Y2, X3, Y3, Self );
        end
        else begin
                PosX := Palanthir.RelDrawX + (Pos.X - Pos.Y) * 22 - 22;
                PosY := Palanthir.RelDrawY + (Pos.X + Pos.Y) * 22 - Pos.Z*4;
                Renderer.DrawPixels( PosX, PosY, Texture );
                Palanthir.Maus.CheckObject( PosX, PosY, Self, Texture );
        end;

        Timer.Stop( Timer_Map );
        Timer.Pause( Timer_AllMap );
end;

procedure TMapItem.OnClick;
begin
        Palanthir.ScriptManager.OnClick( Self );
end;

function TMapItem.IsVisible : Boolean;
var     PosX, PosY : Integer;
        X0, Y0, X1, Y1, X2, Y2, X3, Y3 : Integer;
begin
        if TextureChanged then begin
                TextureChanged := False;
                GetTexture;
        end;

        if Id = $2 then begin
                Result := False;
                exit;
        end;

        if Texture = nil then begin
                Result := False;
                exit;
        end;

        if Palanthir.GameWindow = nil then begin
                Result := False;
                exit;
        end;

        if IsStretched then begin
                PosX := ( Palanthir.GameWindow.Breite div 2 ) + (Pos.X-Palanthir.Player.Pos.X - Pos.Y+Palanthir.Player.Pos.Y) * 22;
                PosY := ( Palanthir.GameWindow.Hoehe div 2 ) + (Pos.X-Palanthir.Player.Pos.X + Pos.Y-Palanthir.Player.Pos.Y) * 22 + Palanthir.Player.Pos.Z*4;

                X0 := 0;
                Y0 := 0 - Pos.Z*4;
                X1 := -22;
                Y1 := 22 - Z3*4;
                X2 := 0;
                Y2 := 44 - Z4*4;
                X3 := 22;
                Y3 := 22 - Z2*4;

                if ((PosX + X0 >= -44) and (PosY + Y0 >= -44) and (PosX + X0 < Palanthir.GameWindow.Breite+44) and (PosY + Y0 < Palanthir.GameWindow.Hoehe+44)) or
                   ((PosX + X1 >= -44) and (PosY + Y1 >= -44) and (PosX + X1 < Palanthir.GameWindow.Breite+44) and (PosY + Y1 < Palanthir.GameWindow.Hoehe+44)) or
                   ((PosX + X2 >= -44) and (PosY + Y2 >= -44) and (PosX + X2 < Palanthir.GameWindow.Breite+44) and (PosY + Y2 < Palanthir.GameWindow.Hoehe+44)) or
                   ((PosX + X3 >= -44) and (PosY + Y3 >= -44) and (PosX + X3 < Palanthir.GameWindow.Breite+44) and (PosY + Y3 < Palanthir.GameWindow.Hoehe+44)) then begin
                        Result := True;
                   end
                else begin
                        Result := False;
                end;
        end
        else begin
                PosX := ( Palanthir.GameWindow.Breite div 2 ) + (Pos.X-Palanthir.Player.Pos.X - Pos.Y+Palanthir.Player.Pos.Y) * 22 - 22;
                PosY := ( Palanthir.GameWindow.Hoehe div 2 ) + (Pos.X-Palanthir.Player.Pos.X + Pos.Y-Palanthir.Player.Pos.Y) * 22 - Pos.Z*4 + Palanthir.Player.Pos.Z*4;

                if (PosX - 44 >= Palanthir.GameWindow.Breite) or (PosY - 44 >= Palanthir.GameWindow.Hoehe) or (PosX + Texture.Breite + 44 < 0) or (PosY + Texture.Hoehe + 44 < 0) then
                        Result := False
                else
                        Result := True;
        end;
end;

function TMapItem.IsMap : Boolean;
begin
        Result := True;
end;

function TMapItem.IsStretched : Boolean;
begin
        Result := ( Typ = typ_map_stretched );
end;

procedure TMapItem.Update;
var     MapItem : TMapItem;
        BaseNormals : Array[-1..8,-1..8,0..3] of TVector;
        V, W : TVector;
        Cell, Left, Right, Bottom : ShortInt;
        X, Y, I : Integer;
        PX, PY : Word;
        X0, Y0 : Integer;
begin
        PX := Pos.X;
        PY := Pos.Y;
        
        Z2 := Palanthir.Data.GetMapHeight( PX+1, PY );
        Z3 := Palanthir.Data.GetMapHeight( PX, PY+1 );
        Z4 := Palanthir.Data.GetMapHeight( PX+1, PY+1 );

        if (Palanthir.Data.Tiledata.GetLandTexId( Id ) > 0) and (not Palanthir.Data.Tiledata.GetLandFlag( Id, dLIQUID ))  then
                Typ := typ_map_stretched
        else
                Typ := typ_map;

        for Y0 := -1 to 1 do begin
                for X0 := -1 to 1 do begin
                        PX := ( BlockID div GetMapHoehe  )*8 + X0;
                        PY := ( BlockID mod GetMapHoehe )*8 + Y0;

                        Cell := Palanthir.Data.GetMapHeight( PX, PY );
                        Left := Palanthir.Data.GetMapHeight( PX, PY+1 );
                        Right := Palanthir.Data.GetMapHeight( PX+1, PY );
                        Bottom := Palanthir.Data.GetMapHeight( PX+1, PY+1 );

                        if (Cell = Left) and (Cell = Right) and (Cell = Bottom) then begin
                                BaseNormals[ X0, Y0, 0 ] := TVector.Create( 0, 0, 1 );
                                BaseNormals[ X0, Y0, 1 ] := TVector.Create( 0, 0, 1 );
                                BaseNormals[ X0, Y0, 2 ] := TVector.Create( 0, 0, 1 );
                                BaseNormals[ X0, Y0, 3 ] := TVector.Create( 0, 0, 1 );
                        end
                        else begin
                                V := TVector.Create( -22, 22, (Cell-Right)*4 );
                                W := TVector.Create( -22, -22, (Left-Cell)*4 );
                                V.Kreutzproduct( W );
                                V.Normalize;
                                BaseNormals[ X0, Y0, 0 ] := V;

                                V := TVector.Create( 22, 22, (Right-Bottom)*4 );
                                W.SetTo( -22, 22, (Cell-Right)*4 );
                                V.Kreutzproduct( W );
                                V.Normalize;
                                BaseNormals[ X0, Y0, 1 ] := V;

                                V := TVector.Create( 22, -22, (Bottom-Left)*4 );
                                W.SetTo( 22, 22, (Right-Bottom)*4 );
                                V.Kreutzproduct( W );
                                V.Normalize;
                                BaseNormals[ X0, Y0, 2 ] := V;

                                V := TVector.Create( -22, -22, (Left-Cell)*4 );
                                W.SetTo( 22, -22, (Bottom-Left)*4 );
                                V.Kreutzproduct( W );
                                V.Normalize;
                                BaseNormals[ X0, Y0, 3 ] := V;

                                W.Free;
                        end;
                end;
        end;

        X := 0;
        Y := 0;
        if IsStretched then begin
                Normals[ 0 ].SetTo( BaseNormals[X-1,Y-1,2] );
                Normals[ 0 ].Add( BaseNormals[X-1,Y,1] );
                Normals[ 0 ].Add( BaseNormals[X,Y-1,3] );
                Normals[ 0 ].Add( BaseNormals[X,Y,0] );
                Normals[ 0 ].Normalize;

                Normals[ 1 ].SetTo( BaseNormals[X,Y-1,2] );
                Normals[ 1 ].Add( BaseNormals[X,Y,1] );
                Normals[ 1 ].Add( BaseNormals[X+1,Y-1,3] );
                Normals[ 1 ].Add( BaseNormals[X+1,Y,0] );
                Normals[ 1 ].Normalize;

                Normals[ 2 ].SetTo( BaseNormals[X,Y,2] );
                Normals[ 2 ].Add( BaseNormals[X,Y+1,1] );
                Normals[ 2 ].Add( BaseNormals[X+1,Y,3] );
                Normals[ 2 ].Add( BaseNormals[X+1,Y+1,0] );
                Normals[ 2 ].Normalize;

                Normals[ 3 ].SetTo( BaseNormals[X-1,Y,2] );
                Normals[ 3 ].Add( BaseNormals[X-1,Y+1,1] );
                Normals[ 3 ].Add( BaseNormals[X,Y,3] );
                Normals[ 3 ].Add( BaseNormals[X,Y+1,0] );
                Normals[ 3 ].Normalize;
        end;

        for Y0 := -1 to 1 do begin
                for X0 := -1 to 1 do begin
                        for I := 0 to 3 do
                                BaseNormals[ X0, Y0, I ].Free;
                end;
        end;
end;

procedure TStaticItem.SetID( NewID : Word );
begin
        if _ID <> NewID then begin
                if IsInDrawList and Palanthir.Data.Tiledata.GetStaticFlag( Id, dANIMATION ) then
                        Palanthir.ItemAnimCache.RemoveAnim( Id, Color );
                _ID := NewID;
                if IsInDrawList and Palanthir.Data.Tiledata.GetStaticFlag( Id, dANIMATION ) then
                        Palanthir.ItemAnimCache.AddAnim( Id, Color );
        end;
end;

procedure TStaticItem.SetColor( NewColor : Word );
begin
        if _Color <> NewColor then begin
                if IsInDrawList and Palanthir.Data.Tiledata.GetStaticFlag( Id, dANIMATION ) then
                        Palanthir.ItemAnimCache.RemoveAnim( Id, Color );
                _Color := NewColor;
                if IsInDrawList and Palanthir.Data.Tiledata.GetStaticFlag( Id, dANIMATION ) then
                        Palanthir.ItemAnimCache.AddAnim( Id, Color );
        end;
end;

procedure TStaticItem.SetDrawID( NewDrawID : Word );
begin
        if _DrawId <> NewDrawId then begin
                _DrawId := NewDrawId;
                TextureChanged := True;
        end;
end;

constructor TStaticItem.Create;
begin
        inherited Create;
        Typ := typ_static;

        Counter.IncCount( Count_Static );
end;

destructor TStaticItem.Free;
begin
        if Texture <> nil then begin
                Palanthir.Data.DecStaticArt( Texture.ID - $4000, Texture.Hue );
        end;

        Counter.DecCount( Count_Static );

        inherited Free;
end;

procedure TStaticItem.GetTexture;
begin
        if (Texture = nil) or (Texture.ID <> DrawID) or (Texture.Hue <> Color) then begin
                if Texture <> nil then begin
                        Palanthir.Data.DecStaticArt( Texture.ID - $4000, Texture.Hue );
                end;

                Texture := Palanthir.Data.GetStaticArt( DrawID, Color );

                if Texture <> nil then begin
                        Palanthir.Data.IncStaticArt( DrawID, Color );
                end;
        end;
end;

procedure TStaticItem.Draw;
var     Transparenz : Word;
        PosX, PosY : Integer;
        Diff : Integer;
        TmpTexture : TTexObject;
        LichtZeichnen : Boolean;
        ItemList : TList;
        I : Integer;
begin
        if not Palanthir.DrawStatics then begin
                exit;
        end;
        
        if Palanthir.DebugMode and HasFlag( Flag_Debug ) then begin
                exit;
        end;

        if Palanthir.IsOnInvisList( Id ) or Palanthir.IsOnServerInvisList( Id ) then begin
                exit;
        end;

        if Palanthir.Data.Tiledata.GetStaticFlag( Id, dANIMATION ) then
                DrawID := Palanthir.ItemAnimCache.GetCurrentId( ID )
        else
                DrawID := ID;

        GetTexture;

        if Texture = nil then begin
                exit;
        end;

        if ( Pos.Z >= Palanthir.RoofHeight ) or ((Palanthir.RoofHeight <> $FFFF) and Palanthir.Data.Tiledata.GetStaticFlag( Id, dROOF )) then begin
                if Light <> nil then begin
                        Palanthir.LightManager.RemoveLight( Light );
                end;
                exit;
        end;

        if Palanthir.IsUnderMap then begin
                if Palanthir.UnderMapOsiMode and ( Pos.Z >= Palanthir.Player.Pos.Z+15 ) then begin
                        exit;
                end
                else if (not Palanthir.UnderMapOsiMode) and (Pos.Z+4 >= Palanthir.Data.GetMapHeight( Pos.X, Pos.Y )) then begin
                        exit;
                end;
        end;

        Timer.Continue( Timer_AllStatics );
        Timer.Start( Timer_Statics );

        if Palanthir.Data.Tiledata.GetStaticFlag( ID, dTRANSLUCENT ) then begin
                Transparenz := ItemTransparenz;
        end
        else if Palanthir.Data.Tiledata.GetStaticFlag( Id, dFOLIAGE ) then begin
                Transparenz := 255;

                Diff := Pos.X-Palanthir.Player.Pos.X + Pos.Y-Palanthir.Player.Pos.Y;
                if (Diff > 0) and (Diff <= 6) then begin
                        Diff := Pos.X-Palanthir.Player.Pos.X - Pos.Y+Palanthir.Player.Pos.Y;
                        if (Diff <= 6) and (Diff >= -4) then
                                Transparenz := FoliageTransparenz;
                end;
        end
        else begin
                Transparenz := 255;
        end;

        PosX := Palanthir.RelDrawX + (Pos.X - Pos.Y) * 22 - ( Texture.Breite div 2 );
        PosY := Palanthir.RelDrawY + (Pos.X + Pos.Y) * 22 - Pos.Z*4 - Texture.Hoehe +44;

        if Speech <> nil then begin
                Speech.Visible := True;
                if Palanthir.Data.Tiledata.GetStaticFlag( Id, dANIMATION ) then begin
                        TmpTexture := Palanthir.Data.GetStaticArt( Id, Color );
                        Speech.Y := PosY + TmpTexture.Hoehe div 2;
                        Speech.X := PosX + TmpTexture.Breite div 2;
                end
                else begin
                        Speech.Y := PosY + Texture.Hoehe div 2;
                        Speech.X := PosX + Texture.Breite div 2;
                end;
        end;

        if (Texture.ID <> DrawID + $4000) then begin
                Log.Write( 'illegal staticart texture' );
                TextureChanged := True;
                Texture := nil;
                Exit;
        end;

        Renderer.DrawPixelsTransp( PosX, PosY, Texture, Transparenz );
        if (Transparenz <> FoliageTransparenz) then
                Palanthir.Maus.CheckObject( PosX, PosY, Self, Texture );

        if Palanthir.Data.Tiledata.GetStaticFlag( Id, dLIGHTSOURCE ) and Palanthir.LightManager.Enabled then begin
                LichtZeichnen := True;
                //lichter in husern sollen net leuchten wenn man draussen steht
                ItemList := Palanthir.Data.WorldCache.GetStaticObjects( Pos.X, Pos.Y );
                for I := 0 to ItemList.Count-1 do begin
                        if (TStaticItem( ItemList.Items[ I ] ).Pos.Z > Pos.Z+6) and
                           (TStaticItem( ItemList.Items[ I ] ).Pos.Z < Pos.Z+30) and
                           (TStaticItem( ItemList.Items[ I ] ).Pos.Z <= Palanthir.RoofHeight ) and
                           ((Palanthir.Data.Tiledata.GetStaticFlag( TStaticItem( ItemList.Items[ I ] ).ID, dSURFACE )) or
                           (Palanthir.Data.Tiledata.GetStaticFlag( TStaticItem( ItemList.Items[ I ] ).ID, dROOF ))) then begin
                                LichtZeichnen := False;
                                break;
                        end;
                end;
                ItemList.Free;

                if LichtZeichnen then begin
                        ItemList := Palanthir.Data.WorldCache.GetItems( Pos.X, Pos.Y );
                        for I := 0 to ItemList.Count-1 do
                                if (TUObject( ItemList.Items[ I ] ).Pos.Z < Pos.Z+30) and
                                (TUObject( ItemList.Items[ I ] ).Pos.Z > Pos.Z+6) and
                                (TUObject( ItemList.Items[ I ] ).Pos.Z <= Palanthir.RoofHeight ) and
                                ((Palanthir.Data.Tiledata.GetStaticFlag( TItem( ItemList.Items[ I ] ).ID, dSURFACE )) or
                                (Palanthir.Data.Tiledata.GetStaticFlag( TItem( ItemList.Items[ I ] ).ID, dROOF ))) then begin
                                        LichtZeichnen := False;
                                        break;
                                end;
                        ItemList.Free;
                end;

                if LichtZeichnen then begin
                        PosX := PosX + ( Texture.Breite div 2 ) - Palanthir.GameWindow.X;
                        PosY := PosY + ( Texture.Hoehe div 2 ) - Palanthir.GameWindow.Y;

                        if Light = nil then begin
                                Light := TLight.Create( PosX, PosY, Palanthir.Data.Tiledata.GetStaticQuality( Id ), GetLightColor );
                                Light.UODrawObject := Self;
                                Palanthir.LightManager.AddLight( Light );
                        end
                        else begin
                                Light.PosX := PosX;
                                Light.PosY := PosY;
                                Light.Id := Palanthir.Data.Tiledata.GetStaticQuality( Id );
                                Light.Color := GetLightColor;
                        end;
                end else if Light <> nil then begin
                        Palanthir.LightManager.RemoveLight( Light );
                        Light := nil;
                end;
        end;

        Timer.Stop( Timer_Statics );
        Timer.Pause( Timer_AllStatics );
end;

procedure TStaticItem.OnClick;
var     Text : TSpeechText;
        Zeile : String;
begin
        if Palanthir.ScriptManager.OnClick( Self ) then begin
                Exit;
        end;

        Zeile := Palanthir.Data.GetClilocMessage( 1020000 + Id );
        if Zeile = '' then
                Zeile := Palanthir.Data.Tiledata.GetStaticName( Id );

        if Zeile = '' then
                exit;

        if Speech <> nil then begin
                Palanthir.RemoveSpeech( Speech );
                Speech.Free;
        end;

        Speech := TSpeech.Create;
        Speech.SetDrawObjectType;
        Speech.UObject := Self;
        Palanthir.AddSpeech( Speech );

        Text := TSpeechText.Create( 0, $481, Zeile, 200, 0, CustomGetTickCount + 15*1000 );
        Text.Speech := Speech;
        Speech.Add( Text );
end;

function TStaticItem.IsVisible : Boolean;
var     PosX, PosY : Integer;
begin
        GetTexture;

        if (Id = $1) or (Id = $21BC) then begin
                Result := False;
                exit;
        end;

        if (Texture = nil) then begin
                DrawId := $0;
                GetTexture;

                if Texture = nil then begin
                        Result := False;
                        exit;
                end;
        end;

        if Palanthir.GameWindow = nil then begin
                Result := False;
                exit;
        end;

        PosX := ( Palanthir.GameWindow.Breite div 2 ) + (Pos.X-Palanthir.Player.Pos.X - Pos.Y+Palanthir.Player.Pos.Y) * 22 - ( Texture.Breite div 2 );
        PosY := ( Palanthir.GameWindow.Hoehe div 2 ) + (Pos.X-Palanthir.Player.Pos.X + Pos.Y-Palanthir.Player.Pos.Y) * 22 - Pos.Z*4 - Texture.Hoehe +44 + Palanthir.Player.Pos.Z*4;

        if (PosX - 44 >= Palanthir.GameWindow.Breite) or (PosY - 44 >= Palanthir.GameWindow.Hoehe) or (PosX + Texture.Breite + 44 < 0) or (PosY + Texture.Hoehe + 44 < 0) then
                Result := False
        else
                Result := True;
end;

function TStaticItem.IsStatic : Boolean;
begin
        Result := True;
end;

procedure TStaticItem.MoveTo( X, Y : Word; Z : ShortInt; Map : Byte );
var     NewPos : TPos;
begin
        NewPos := TPos.Create( X, Y, Z, Map );

        if BlockID <> NewPos.GetBlockID then begin
                Palanthir.Data.WorldCache.GetObject( BlockID ).RemoveStatic( Self );
                Palanthir.Data.WorldCache.GetObject( NewPos.GetBlockID ).AddStatic( Self );
        end;

        Pos.SetPos( NewPos );
        NewPos.Free;
end;

end.
